/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fp.CycleRangeInfo;
import com.kingdee.eas.fm.fp.FPFormulaCollection;
import com.kingdee.eas.fm.fp.FPFormulaInfo;
import com.kingdee.eas.fm.fs.BalanceDirectionEnum;
import com.kingdee.eas.fm.fs.ISummaryLedger;
import com.kingdee.eas.fm.fs.InAcctDataTypeEnum;
import com.kingdee.eas.fm.fs.InacctTypeEnum;
import com.kingdee.eas.fm.fs.InnerAccountCollection;
import com.kingdee.eas.fm.fs.InnerAccountInfo;
import com.kingdee.eas.fm.fs.SummaryLedgerEnum;
import com.kingdee.eas.fm.fs.SummaryLedgerFactory;
import com.kingdee.eas.fm.fs.client.AbstractSummaryLedgerHandler;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.fm.fs.client.SummaryLedgerFilterParam;
import com.kingdee.eas.fm.fs.client.SummaryLedgerUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;

public class SummaryLedgerByPeriodDateHandler
extends AbstractSummaryLedgerHandler {
    static Logger logger = Logger.getLogger(SummaryLedgerUI.class);
    private String resourcePath1 = "com.kingdee.eas.fm.fs.client.SettleLedgerResource";
    private List companyList = new ArrayList();
    private Vector innerAccountVec = null;

    @Override
    public void initTree(SummaryLedgerFilterParam param, KDTree treeList) throws BOSException {
        Date beginDateUI = param.getFromDate();
        Date endDateUI = param.getToDate();
        DateFormat dtformat = CtrlFormatUtilities.getDateFormat();
        String col_project_name = dtformat.format(beginDateUI) + "~" + dtformat.format(endDateUI);
        FSClientHelper.fillDateTree(treeList, col_project_name);
    }

    @Override
    public void initTable(SummaryLedgerFilterParam param, KDTable tblMain) throws BOSException {
        super.initTable(param, tblMain);
        String column_project = EASResource.getString((String)this.resourcePath, (String)"InnerAcct");
        tblMain.getHead().getRow(0).getCell(1).setValue((Object)column_project);
    }

    public void _initTable(SummaryLedgerFilterParam param, KDTable tblMain) throws BOSException {
        String column_project = EASResource.getString((String)this.resourcePath, (String)"Project");
        String column_total = EASResource.getString((String)this.resourcePath, (String)"Total");
        tblMain.checkParsed();
        IRow headRow = tblMain.addHeadRow();
        IRow headRow2 = tblMain.addHeadRow();
        tblMain.addColumn().setKey("Project");
        headRow.getCell("Project").setValue((Object)column_project);
        boolean bln = true;
        Vector<String> innerVec = new Vector<String>();
        CompanyOrgUnitCollection coll = FMClientHelper.getCompanyOrgUnitCollection((String[])param.getCompanyIdAry());
        int left = 1;
        int right = 1;
        for (int i = 0; i < coll.size(); ++i) {
            CompanyOrgUnitInfo company = coll.get(i);
            String companyID = company.getId().toString();
            InnerAccountCollection iac = FSClientHelper.getInnerAccountCollection(companyID, param.getUsageId(), param.isDispUnUsed());
            if (iac == null) continue;
            for (int j = 0; j < iac.size(); ++j) {
                InnerAccountInfo innerAccountInfo = iac.get(j);
                String innerAccountNumber = innerAccountInfo.getNumber();
                tblMain.addColumn().setKey(innerAccountNumber);
                headRow.getCell(innerAccountNumber).setValue((Object)company.getName());
                headRow2.getCell(innerAccountNumber).setValue((Object)innerAccountInfo.getName());
                innerVec.add(innerAccountNumber);
            }
            right = left + iac.size() - 1;
            tblMain.getHeadMergeManager().mergeBlock(0, left, 0, right);
            left += iac.size();
        }
        this.innerAccountVec = innerVec;
        if (innerVec.size() == 0) {
            tblMain.removeColumns();
            tblMain.removeHeadRows();
            MsgBox.showInfo((String)EASResource.getString((String)this.resourcePath1, (String)"NoneInnerAccount"));
            return;
        }
        tblMain.getHeadMergeManager().mergeBlock(0, 0, 1, 0);
        tblMain.addColumn().setKey("Total");
        headRow.getCell("Total").setValue((Object)column_total);
        headRow2.getCell("Total").setValue((Object)column_total);
        tblMain.getHeadMergeManager().mergeBlock(0, tblMain.getColumnCount() - 1, 1, tblMain.getColumnCount() - 1);
        List sumList = SummaryLedgerEnum.getEnumList();
        int size = sumList.size();
        for (int i = 0; i < size; ++i) {
            tblMain.addRow().getCell("Project").setValue(sumList.get(i));
        }
    }

    private InnerAccountCollection getInnerAccountColl(SummaryLedgerFilterParam param) throws BOSException {
        CompanyOrgUnitCollection coll = FMClientHelper.getCompanyOrgUnitCollection((String[])param.getCompanyIdAry());
        this.companyList.clear();
        HashSet<String> applyUnitIdSet = new HashSet<String>();
        for (int i = 0; i < coll.size(); ++i) {
            CompanyOrgUnitInfo applyUnit = coll.get(i);
            String applyUnitId = applyUnit.getId().toString();
            applyUnitIdSet.add(applyUnitId);
        }
        CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        InnerAccountCollection innerAcctColl = FSClientHelper.getInnerAccountColl(company.getId().toString(), applyUnitIdSet, param.getUsageId(), param.isDispUnUsed());
        int size = innerAcctColl.size();
        for (int i = 0; i < size; ++i) {
            this.companyList.add(innerAcctColl.get(i).getApplyUnit().getName());
        }
        return innerAcctColl;
    }

    private void fillDataToTable2(KDTable tblMain, SummaryLedgerFilterParam param, CycleRangeInfo period, EntityViewInfo mainQuery, String currencyNumber) throws Exception {
        String innerAccountNumber;
        InnerAccountCollection innerAcctColl = this.getInnerAccountColl(param);
        int innerSize = innerAcctColl.size();
        Date beginDateUI = param.getFromDate();
        Date endDateUI = param.getToDate();
        Date beginDate = this.adjustDate(beginDateUI);
        Date endDate = this.adjustDate(endDateUI);
        FPFormulaCollection paramColl = new FPFormulaCollection();
        FPFormulaInfo info = null;
        String chCompanyNumber = ContextHelperFactory.getRemoteInstance().getCurrentCompany().getNumber();
        if (innerSize == 0) {
            return;
        }
        for (int i = 0; i < innerSize; ++i) {
            innerAccountNumber = innerAcctColl.get(i).getNumber();
            info = new FPFormulaInfo();
            info.setParams(new Object[]{chCompanyNumber, innerAccountNumber, currencyNumber, beginDate, endDate, InAcctDataTypeEnum.C});
            paramColl.add(info);
            info = new FPFormulaInfo();
            info.setParams(new Object[]{chCompanyNumber, innerAccountNumber, currencyNumber, beginDate, endDate, InAcctDataTypeEnum.JF});
            paramColl.add(info);
            info = new FPFormulaInfo();
            info.setParams(new Object[]{chCompanyNumber, innerAccountNumber, currencyNumber, beginDate, endDate, InAcctDataTypeEnum.DF});
            paramColl.add(info);
        }
        IRow row = null;
        ISummaryLedger iSummaryLedger = SummaryLedgerFactory.getRemoteInstance();
        FPFormulaCollection resultcoll = iSummaryLedger.exec(InacctTypeEnum.INACCTExt, paramColl);
        InnerAccountInfo innerAcctInfo = null;
        for (int i = 0; i < innerSize; ++i) {
            row = tblMain.addRow();
            innerAccountNumber = innerAcctColl.get(i).getNumber();
            innerAcctInfo = innerAcctColl.get(i);
            innerAcctInfo.setDisplayFormat("$number$ $name$");
            row.getCell("APPLYUNIT").setValue((Object)this.companyList.get(i).toString());
            row.getCell("Project").setValue((Object)innerAcctInfo);
            info = resultcoll.get(i * 3);
            BigDecimal a = info.getResult();
            row.getCell("beginBalanceDc").setValue((Object)BalanceDirectionEnum.getEnum(a.signum()));
            row.getCell("beginBalance").setValue((Object)a.abs());
            info = resultcoll.get(i * 3 + 1);
            BigDecimal b = info.getResult();
            row.getCell("creditAmount").setValue((Object)b);
            info = resultcoll.get(i * 3 + 2);
            BigDecimal c = info.getResult();
            row.getCell("debitAmount").setValue((Object)c);
            BigDecimal d = FMHelper.add((BigDecimal)a, (BigDecimal)b).subtract(c);
            row.getCell("endBalanceDc").setValue((Object)BalanceDirectionEnum.getEnum(d.signum()));
            row.getCell("endBalance").setValue((Object)d.abs());
        }
        BigDecimal beginBalanceTotal = Constants.ZERO;
        BigDecimal endBalanceTotal = Constants.ZERO;
        BigDecimal debitAmountTotal = Constants.ZERO;
        BigDecimal creditAmountTotal = Constants.ZERO;
        BigDecimal temp = null;
        BalanceDirectionEnum direct = null;
        for (int i = 0; i <= tblMain.getRowCount() - 1; ++i) {
            direct = (BalanceDirectionEnum)((Object)tblMain.getRow(i).getCell("beginBalanceDc").getValue());
            temp = (BigDecimal)tblMain.getRow(i).getCell("beginBalance").getValue();
            if (direct.getValue() == -1) {
                temp = temp.negate();
            }
            beginBalanceTotal = beginBalanceTotal.add(temp);
            debitAmountTotal = debitAmountTotal.add((BigDecimal)tblMain.getRow(i).getCell("debitAmount").getValue());
            creditAmountTotal = creditAmountTotal.add((BigDecimal)tblMain.getRow(i).getCell("creditAmount").getValue());
            direct = (BalanceDirectionEnum)((Object)tblMain.getRow(i).getCell("endBalanceDc").getValue());
            temp = (BigDecimal)tblMain.getRow(i).getCell("endBalance").getValue();
            if (direct.getValue() == -1) {
                temp = temp.negate();
            }
            endBalanceTotal = endBalanceTotal.add(temp);
        }
        row = tblMain.addRow();
        String total = EASResource.getString((String)this.resourcePath, (String)"Total");
        row.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_TOTAL_BG_COLOR);
        row.getCell("APPLYUNIT").setValue((Object)total);
        row.getCell("beginBalanceDc").setValue((Object)BalanceDirectionEnum.getEnum(beginBalanceTotal.signum()));
        row.getCell("beginBalance").setValue((Object)beginBalanceTotal);
        row.getCell("debitAmount").setValue((Object)debitAmountTotal);
        row.getCell("creditAmount").setValue((Object)creditAmountTotal);
        row.getCell("endBalanceDc").setValue((Object)BalanceDirectionEnum.getEnum(endBalanceTotal.signum()));
        row.getCell("endBalance").setValue((Object)endBalanceTotal.abs());
    }

    @Override
    public void fillData(KDTable tblMain, SummaryLedgerFilterParam param, Object condition, EntityViewInfo mainQuery, String currencyNumber) throws Exception {
        CycleRangeInfo period = (CycleRangeInfo)condition;
        this.fillDataToTable2(tblMain, param, period, mainQuery, currencyNumber);
    }
}

