/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.be.BizTypeEnum;
import com.kingdee.eas.fm.common.DateHelper;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fs.KDRetFlagEnum;
import com.kingdee.eas.fm.fs.TransUpBillFacadeFactory;
import com.kingdee.eas.fm.fs.client.AbstractTransToSettlementListUI;
import com.kingdee.eas.fm.fs.client.TransToSettlementFilterUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class TransToSettlementListUI
extends AbstractTransToSettlementListUI {
    private static final Logger logger = CoreUIObject.getLogger(TransToSettlementListUI.class);
    private Set selectCondition;
    private HashMap filterCondition;
    public static final int REC_TRANS_TYPE = 0;
    public static final int PAY_TRANS_TYPE = 1;
    private int transType;
    private int bizType;

    public int getBizType() {
        return this.bizType;
    }

    public void setBizType(int bizType) {
        this.bizType = bizType;
    }

    public int getTransType() {
        return this.transType;
    }

    public void setTransType(int transType) {
        this.transType = transType;
    }

    public TransToSettlementListUI() throws Exception {
        this.btnConfirm.setEnabled(true);
        this.btnCancel.setEnabled(true);
        this.selectCondition = new HashSet();
        this.initFilterCondition();
    }

    private void initFilterCondition() throws BOSException, EASBizException {
        this.filterCondition = new HashMap();
        this.filterCondition.put("beginDate", TransToSettlementListUI.getDayBegin());
        this.filterCondition.put("endDate", new Date());
        CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        CurrencyInfo currency = ContextHelperFactory.getRemoteInstance().getCompanyBaseCurrency(company);
        this.filterCondition.put("Currency", currency);
        this.filterCondition.put("BankAccount", null);
        this.filterCondition.put("BizType", FMSysDefinedEnum.ALL_ITEMS);
        this.filterCondition.put("BizName", "");
        this.filterCondition.put("Description", "");
        this.filterCondition.put("KDRetFlag", KDRetFlagEnum.FALSE);
    }

    public static Date getDayBegin() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.checkParsed();
        this.tblMain.getSelectManager().setSelectMode(10);
        this.tblMain.getColumn("TransDate").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
        this.tblMain.getColumn("TransTime").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getTimeFormatString());
    }

    @Override
    public void onShow() throws Exception {
        super.onShow();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private void filltblMain(String companyId, Date beginDate, Date endDate, String Currency2, String BankPK, String BizType, String BizName, String Description, String KDRetFlag) throws BOSException, SQLException, EASBizException {
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.removeRows();
        IRowSet rs = this.getRowSet(companyId, beginDate, endDate, Currency2, BankPK, BizType, BizName, Description, KDRetFlag);
        if (rs == null || rs.toCollection().size() == 0) {
            return;
        }
        String numberFtm = FMClientHelper.getNumberFtm((BOSUuid)BOSUuid.read((String)Currency2));
        while (rs.next()) {
            IRow row = this.tblMain.addRow();
            row.getCell("TransDate").setValue((Object)Constants.FORMAT_DAY.format(rs.getObject("FBizTime")));
            String dtformat = CtrlFormatUtilities.getTimeFormatString();
            row.getCell("TransTime").setValue((Object)new SimpleDateFormat(dtformat).format(rs.getObject("FBizTime")));
            row.getCell("Currency").setValue(rs.getObject("FCurrencyName"));
            row.getCell("AccountCode").setValue(rs.getObject("FBankAccountnumber"));
            row.getCell("BankAccount").setValue(rs.getObject("FAccountNumber"));
            row.getCell("BankName").setValue(rs.getObject("FBankAccountName"));
            row.getCell("Amount").getStyleAttributes().setNumberFormat(numberFtm);
            if (this.transType == 1) {
                row.getCell("Amount").setValue(rs.getObject("FDebitAmount"));
            } else if (this.transType == 0) {
                row.getCell("Amount").setValue(rs.getObject("FCreditAmount"));
            }
            row.getCell("BizName").setValue(rs.getObject("FBizName"));
            row.getCell("OppUnit").setValue(rs.getObject("FOppUnit"));
            row.getCell("OppBank").setValue(rs.getObject("FOppBank"));
            row.getCell("OppAccount").setValue(rs.getObject("FOppBankNumber"));
            row.getCell("BizNumber").setValue(rs.getObject("FBizNumber"));
            row.getCell("Description").setValue(rs.getObject("FDescription"));
            if (rs.getObject("isKDRetFlag").equals(Boolean.TRUE)) {
                row.getCell("KDRetFlag").setValue((Object)KDRetFlagEnum.TRUE);
            }
            if (rs.getObject("isKDRetFlag").equals(Boolean.FALSE)) {
                row.getCell("KDRetFlag").setValue((Object)KDRetFlagEnum.FALSE);
            }
            row.getCell("ID").setValue(rs.getObject("id"));
        }
        this.tblMain.getColumn("ID").getStyleAttributes().setHided(true);
    }

    private IRowSet getRowSet(String companyId, Date beginDate, Date endDate, String Currency2, String BankPK, String BizType, String BizName, String Description, String KDRetFlag) throws BOSException, EASBizException {
        Set transUpBankCheckFlags;
        MetaDataPK PK = new MetaDataPK("com.kingdee.eas.fm.fs.app", "TransToSettlementQuery");
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)PK);
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("FIsDebit", (Object)new Integer(this.transType)));
        filter.getFilterItems().add(new FilterItemInfo("FIsReced", (Object)new Integer(0)));
        filter.getFilterItems().add(new FilterItemInfo("FCompanyID", (Object)companyId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("FBizTime", (Object)beginDate, CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("FBizTime", (Object)endDate, CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("FCurrencyID", (Object)Currency2, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isCreatedTransUp", (Object)Boolean.FALSE));
        if (!BankPK.equals("") && BankPK.length() != 0) {
            filter.getFilterItems().add(new FilterItemInfo("FBankAccountID", (Object)BankPK, CompareType.EQUALS));
        }
        if (!BizType.equals("1000")) {
            filter.getFilterItems().add(new FilterItemInfo("FBizType", (Object)BizType));
        }
        if (!BizName.equals("") && BizName.length() != 0) {
            filter.getFilterItems().add(new FilterItemInfo("FBizName", (Object)("%" + BizName + "%"), CompareType.LIKE));
        }
        if (!Description.equals("") && Description.length() != 0) {
            filter.getFilterItems().add(new FilterItemInfo("FDescription", (Object)("%" + Description + "%"), CompareType.LIKE));
        }
        if (!KDRetFlag.equals("2")) {
            if (KDRetFlag.equals("0")) {
                filter.getFilterItems().add(new FilterItemInfo("isKDRetFlag", (Object)Boolean.TRUE));
            }
            if (KDRetFlag.equals("1")) {
                filter.getFilterItems().add(new FilterItemInfo("isKDRetFlag", (Object)Boolean.FALSE));
            }
        }
        if (1 == this.getBizType() && !EmptyUtil.isEmpty((Collection)(transUpBankCheckFlags = TransUpBillFacadeFactory.getRemoteInstance().getTransUpBankCheckFlags(companyId, beginDate, endDate)))) {
            FilterInfo checkFlag = new FilterInfo();
            checkFlag.getFilterItems().add(new FilterItemInfo("bankCheckFlag", (Object)transUpBankCheckFlags, CompareType.NOTINCLUDE));
            checkFlag.getFilterItems().add(new FilterItemInfo("bankCheckFlag", null));
            checkFlag.setMaskString("#0 OR #1");
            filter.mergeFilter(checkFlag, "AND");
        }
        ev.setFilter(filter);
        exec.setObjectView(ev);
        IRowSet rs = exec.executeQuery();
        return rs;
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        HashMap tmpMap = this.filterCondition;
        this.filterCondition = TransToSettlementFilterUI.showTransToSettlementFilterUI(this);
        if (this.filterCondition != null && this.filterCondition.isEmpty()) {
            this.filterCondition = tmpMap;
            return;
        }
        this.doQuery();
        super.actionQuery_actionPerformed(e);
    }

    public void doQuery() throws BOSException, SQLException, EASBizException {
        CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        Date beginDate = (Date)this.filterCondition.get("beginDate");
        Date endDate = (Date)this.filterCondition.get("endDate");
        endDate = DateHelper.getSQLEnd((Date)endDate);
        String Currency2 = ((CurrencyInfo)this.filterCondition.get("Currency")).getId().toString();
        String BankPK = this.filterCondition.get("BankAccount") != null ? this.filterCondition.get("BankAccount").toString() : "";
        Integer BizTypeInt = !this.filterCondition.get("BizType").equals(FMSysDefinedEnum.ALL_ITEMS) ? new Integer(((BizTypeEnum)this.filterCondition.get("BizType")).getValue()) : new Integer(1000);
        String BizName = this.filterCondition.get("BizName").toString();
        String Description = this.filterCondition.get("Description").toString();
        Integer KDRetFlag = new Integer(2);
        if (this.filterCondition.get("KDRetFlag").equals((Object)KDRetFlagEnum.TRUE)) {
            KDRetFlag = new Integer(0);
        }
        if (this.filterCondition.get("KDRetFlag").equals((Object)KDRetFlagEnum.FALSE)) {
            KDRetFlag = new Integer(1);
        }
        this.filltblMain(companyInfo.getId().toString(), beginDate, endDate, Currency2, BankPK, BizTypeInt.toString(), BizName, Description, KDRetFlag.toString());
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.doQuery();
        super.actionRefresh_actionPerformed(e);
    }

    @Override
    public void actionExit_actionPerformed(ActionEvent e) throws Exception {
        super.actionExit_actionPerformed(e);
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        super.actionConfirm_actionPerformed(e);
        if (this.tblMain.getRowCount() == 0 || this.tblMain.getSelectManager().getActiveRowIndex() == -1) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            return;
        }
        Set selectedSet = FMClientHelper.getSelectedRows((KDTable)this.tblMain);
        Iterator iterator = selectedSet.iterator();
        HashSet<String> idSet = new HashSet<String>();
        while (iterator.hasNext()) {
            Integer i = (Integer)iterator.next();
            String IDString = this.tblMain.getRow(i.intValue()).getCell("ID").getValue().toString();
            idSet.add(IDString);
        }
        this.selectCondition.addAll(idSet);
        this.disposeUIWindow();
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
        this.disposeUIWindow();
    }

    public static Set showTransToSettlementListUI(CoreUIObject ui, int transType, int bizType) throws SQLException {
        Set returnValue = new HashSet();
        try {
            UIContext uiContext = new UIContext((Object)ui);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(TransToSettlementListUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
            ((TransToSettlementListUI)uiWindow.getUIObject()).setTransType(transType);
            ((TransToSettlementListUI)uiWindow.getUIObject()).setBizType(bizType);
            ((TransToSettlementListUI)uiWindow.getUIObject()).doQuery();
            uiWindow.show();
            returnValue = ((TransToSettlementListUI)uiWindow.getUIObject()).getReturnValue();
        }
        catch (EASBizException e) {
            logger.error((Object)e);
            SysUtil.abort();
        }
        catch (BOSException e) {
            logger.error((Object)e);
            SysUtil.abort();
        }
        return returnValue;
    }

    private Set getReturnValue() {
        return this.selectCondition;
    }
}

