/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.DefaultNoteDataProvider;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPKFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.commonquery.client.CommonQueryProcessor;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.service.helper.PermissionParameterFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.model.BatchExecuteResult;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.be.SubmitPasswordFactory;
import com.kingdee.eas.fm.be.client.SubmitPasswordUI;
import com.kingdee.eas.fm.bond.BondUtil;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.EReceiptCommonClientHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.erec.client.EReceiptInnerClientHelper;
import com.kingdee.eas.fm.fs.ITransUpBill;
import com.kingdee.eas.fm.fs.ITransUpBillFacade;
import com.kingdee.eas.fm.fs.SourceTypeEnum;
import com.kingdee.eas.fm.fs.TransBillException;
import com.kingdee.eas.fm.fs.TransUpBillCollection;
import com.kingdee.eas.fm.fs.TransUpBillFacadeFactory;
import com.kingdee.eas.fm.fs.TransUpBillFactory;
import com.kingdee.eas.fm.fs.TransUpBillInfo;
import com.kingdee.eas.fm.fs.TransUpBillStateEnum;
import com.kingdee.eas.fm.fs.client.AbstractTransUpBillListUI;
import com.kingdee.eas.fm.fs.client.ApplyTransBillRejectedUI;
import com.kingdee.eas.fm.fs.client.TransBaseBillQueryProcess;
import com.kingdee.eas.fm.fs.client.TransUpBillEditUI;
import com.kingdee.eas.fm.fs.client.TransUpBillFilterUI;
import com.kingdee.eas.fm.fs.client.TransUpBillHandler;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class TransUpBillListUI
extends AbstractTransUpBillListUI {
    private static final Logger logger = CoreUIObject.getLogger(TransUpBillListUI.class);
    protected CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
    public static final String TRANSUP_COPY = "COPY";
    public static final String RES = "com.kingdee.eas.fi.cas.CasResources";
    TransUpBillFilterUI filterUI = null;
    public static final String PAYMENTBILL_FILENAME = "/FM/TR/Up";

    protected String getOriginalCurrencyColumnKey() {
        return "currency.id";
    }

    protected String[] getFmtColumnKeysByOriginalCurrency() {
        return new String[]{"totalAmt", "confirmedAmt", "amount"};
    }

    protected String getCompanyColumnKey() {
        return "company.id";
    }

    protected String[] getFmtColumnKeysByCompanyLocalCurrency() {
        return null;
    }

    protected String[] getExchangeRateColumnKeys() {
        return new String[]{"company.id", "currency.id", "bizDate"};
    }

    protected String[] getFmtColumnKeysByExchangeRate() {
        return new String[]{"exchangeRate"};
    }

    public void onLoad() throws Exception {
        TransUpBillListUI.checkCompany((Component)((Object)this), this.getOprtState(), this.currentCompany);
        super.onLoad();
        this.actionAuditResult.setVisible(false);
        this.actionViewBdgBalance.setEnabled(true);
        this.actionViewBdgBalance.setVisible(true);
        if ("true".equalsIgnoreCase(PermissionParameterFactory.getRemoteInstance().getPermissionParameter("EnableAutoSign"))) {
            this.btnSignature.setVisible(false);
            this.btnViewSignature.setVisible(true);
            this.btnViewSignature.setEnabled(true);
        }
        if (!BondUtil.getBooleanParam(null, (String)"TM107", (CompanyOrgUnitInfo)this.currentCompany)) {
            this.actionRejected.setVisible(false);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_audit"));
        this.actionAntiAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_unaudit"));
        this.actionConfirm.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_gathering"));
        this.actionUnConfirm.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_ungathering"));
        this.actionSendReceipt.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_send"));
        this.actionWithdrawReceipt.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_replied"));
        this.actionSubmitToBe.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_submit"));
        this.actionRejected.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_fclose"));
        this.actionBatchConfirm.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_selectall"));
        this.actionBatchSubmit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_submit"));
        this.actionTdPrintView.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_dysz"));
        this.actionTdPrint.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_credenceprint"));
        this.actionNavEreceipt.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_sequencecheck"));
        this.actionNavInnerEreceipt.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_sequencecheck"));
        this.actionWorkFlowG.setVisible(true);
        this.actionMultiapprove.setVisible(true);
        this.actionViewDoProccess.setVisible(true);
        this.actionNextPerson.setVisible(true);
        this.menuWorkFlow.setVisible(true);
        this.actionCreateTo.setVisible(false);
        this.actionTdPrint.setEnabled(true);
        this.actionTdPrintView.setEnabled(true);
    }

    @Override
    protected String getEditUIName() {
        return TransUpBillEditUI.class.getName();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return TransUpBillFactory.getRemoteInstance();
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new TransUpBillFilterUI();
        }
        return this.filterUI;
    }

    @Override
    public String[] getMergeColumnKeys() {
        this.tblMain.checkParsed();
        int size = this.tblMain.getColumn("seq").getColumnIndex();
        String[] keys = new String[size];
        for (int i = 0; i < size; ++i) {
            keys[i] = this.tblMain.getColumn(i).getKey();
        }
        return keys;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("project.name"));
        sic.add(new SelectorItemInfo("project.number"));
        sic.add(new SelectorItemInfo("outBgItemNumber"));
        sic.add(new SelectorItemInfo("outBgItemName"));
        sic.add(new SelectorItemInfo("fpItem.*"));
        sic.add(new SelectorItemInfo("fundFlowItem.*"));
        sic.add(new SelectorItemInfo("fundFlowItem.id"));
        sic.add(new SelectorItemInfo("fundFlowItem.number"));
        sic.add(new SelectorItemInfo("fundFlowItem.name"));
        sic.add(new SelectorItemInfo("mbgNumber"));
        sic.add(new SelectorItemInfo("mbgName"));
        sic.add(new SelectorItemInfo("entrys.project.number"));
        sic.add(new SelectorItemInfo("entrys.project.name"));
        sic.add(new SelectorItemInfo("entrys.feeType.number"));
        sic.add(new SelectorItemInfo("entrys.feeType.name"));
        sic.add(new SelectorItemInfo("entrys.unitacctbank.name"));
        sic.add(new SelectorItemInfo("entrys.unitacctbank.number"));
        sic.add(new SelectorItemInfo("entrys.unit.name"));
        sic.add(new SelectorItemInfo("entrys.unit.number"));
        sic.add(new SelectorItemInfo("settleType.number"));
        sic.add(new SelectorItemInfo("settleType.name"));
        sic.add(new SelectorItemInfo("motherAcctBank.number"));
        sic.add(new SelectorItemInfo("motherAcctBank.name"));
        sic.add(new SelectorItemInfo("motherAcctBank.bank.number"));
        sic.add(new SelectorItemInfo("motherAcctBank.bank.name"));
        return sic;
    }

    protected CommonQueryProcessor getQueryProcessor() {
        return new TransBaseBillQueryProcess();
    }

    public boolean isNeedShowBOTPRule() {
        return true;
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblMain_tableSelectChanged(e);
        this.changeButtonStatus();
    }

    private void changeButtonStatus() {
        int rowNumber = FMClientHelper.getSelectedRow((KDTable)this.tblMain);
        IRow row = this.tblMain.getRow(rowNumber);
        if (row == null) {
            return;
        }
        int billStatus = ((BizEnumValueInfo)row.getCell("state").getValue()).getInt();
        boolean isVouchered = (Boolean)row.getCell("Fivouchered").getValue();
        boolean isCommittoBe = (Boolean)row.getCell("isCommittoBe").getValue();
        boolean[] billActionStatus = TransUpBillHandler.getBillActionStatus(billStatus);
        this.actionBatchSubmit.setEnabled(billStatus == 1);
        this.actionAudit.setEnabled(billActionStatus[0]);
        this.actionAntiAudit.setEnabled(billActionStatus[1]);
        this.actionConfirm.setEnabled(billActionStatus[2]);
        this.actionBatchConfirm.setEnabled(billActionStatus[2]);
        this.actionUnConfirm.setEnabled(billActionStatus[3]);
        this.actionSendReceipt.setEnabled(billActionStatus[4]);
        this.actionWithdrawReceipt.setEnabled(billActionStatus[5]);
        boolean canCommittoBe = 3 == billStatus && !isCommittoBe;
        this.actionSubmitToBe.setEnabled(canCommittoBe);
        boolean[] voucherActionStatus = TransUpBillHandler.getVoucherActionStatus(billStatus, isVouchered);
        this.actionVoucher.setEnabled(voucherActionStatus[0]);
        this.actionDelVoucher.setEnabled(voucherActionStatus[1]);
        Set idList = FMClientHelper.getSelectedRows((KDTable)this.tblMain);
        if (idList != null && idList.size() > 1) {
            this.actionBatchSubmit.setEnabled(true);
            this.actionAudit.setEnabled(true);
            this.actionAntiAudit.setEnabled(true);
            this.actionConfirm.setEnabled(true);
            this.actionBatchConfirm.setEnabled(true);
            this.actionUnConfirm.setEnabled(true);
            this.actionSendReceipt.setEnabled(true);
            this.actionWithdrawReceipt.setEnabled(true);
            this.actionVoucher.setEnabled(true);
            this.actionDelVoucher.setEnabled(true);
        }
        int smartType = 1;
        if (!EmptyUtil.isEmpty((Object)row.getCell("isSmart").getValue())) {
            smartType = ((BizEnumValueInfo)row.getCell("isSmart").getValue()).getInt();
        }
        if (smartType == 2 || smartType == 4) {
            this.actionOpenSmart.setEnabled(true);
            this.actionCloseSmart.setEnabled(false);
        } else if (smartType == 1 || smartType == 3) {
            this.actionOpenSmart.setEnabled(false);
            this.actionCloseSmart.setEnabled(true);
        } else {
            this.actionOpenSmart.setEnabled(false);
            this.actionCloseSmart.setEnabled(false);
        }
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        super.actionView_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkBoforeEdit();
        super.actionEdit_actionPerformed(e);
    }

    @Override
    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        uiContext.put((Object)TRANSUP_COPY, (Object)TRANSUP_COPY);
        this.prepareUIContext(uiContext, e);
        uiContext.put((Object)"IDList", null);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(this.getEditUIName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
    }

    private void checkBoforeEdit() throws TransBillException {
        this.checkSelected();
        int index = FMClientHelper.getSelectedRow((KDTable)this.tblMain);
        IRow row = this.tblMain.getRow(index);
        int state = ((BizEnumValueInfo)row.getCell("state").getValue()).getInt();
        String number = (String)row.getCell("number").getValue();
        if (state != 1 && state != 2) {
            throw new TransBillException(TransBillException.STATEERROREDIT, new Object[]{number});
        }
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
    }

    private Set getSelectedIdSet() {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        HashSet idSet = new HashSet(idList);
        return idSet;
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        Set idSet = this.getSelectedIdSet();
        boolean hasWf = FMHelper.hasWFInstance(null, (List)this.getSelectedIdValues());
        if (hasWf) {
            this.actionMultiapprove_actionPerformed(e);
        } else {
            ITransUpBillFacade facade = TransUpBillFacadeFactory.getRemoteInstance();
            Map result = facade.batchAudit(idSet);
            int success = (Integer)result.get("success");
            StringBuffer errorDetail = (StringBuffer)result.get("error");
            if (!EmptyUtil.isEmpty((String)errorDetail.toString())) {
                int failedCount = idSet.size() - success;
                String title = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"TransBaseBillAuditFail"), new Integer(success), new Integer(failedCount));
                MsgBox.showDetailAndOK((Component)((Object)this), (String)title, (String)errorDetail.toString(), (int)0);
            } else {
                String title = EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"TransBaseBillAuditSuccess");
                MsgBox.showInfo((Component)((Object)this), (String)title);
            }
        }
        this.refresh(e);
    }

    @Override
    public void actionAntiAudit_actionPerformed(ActionEvent e) throws Exception {
        Set idSet = this.getSelectedIdSet();
        ITransUpBillFacade facade = TransUpBillFacadeFactory.getRemoteInstance();
        Map result = facade.batchAntiAudit(idSet);
        int success = (Integer)result.get("success");
        StringBuffer errorDetail = (StringBuffer)result.get("error");
        if (!EmptyUtil.isEmpty((String)errorDetail.toString())) {
            int failedCount = idSet.size() - success;
            String title = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"TransBaseBillAntiAuditFail"), new Integer(success), new Integer(failedCount));
            MsgBox.showDetailAndOK((Component)((Object)this), (String)title, (String)errorDetail.toString(), (int)0);
        } else {
            String title = EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"TransBaseBillAntiAuditSuccess");
            MsgBox.showInfo((Component)((Object)this), (String)title);
        }
        this.refresh(e);
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.checkBoforeConfirm();
        String id = this.getSelectedKeyValue();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)id);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(this.getEditUIName(), (Map)uiContext, null, "CONFIRM");
        uiWindow.show();
    }

    private void checkBoforeConfirm() throws TransBillException {
        this.checkSelected();
        int index = FMClientHelper.getSelectedRow((KDTable)this.tblMain);
        IRow row = this.tblMain.getRow(index);
        int state = ((BizEnumValueInfo)row.getCell("state").getValue()).getInt();
        String number = (String)row.getCell("number").getValue();
        if (state != 3) {
            throw new TransBillException(TransBillException.STATEERRORUPCONFIRM);
        }
    }

    @Override
    public void actionUnConfirm_actionPerformed(ActionEvent e) throws Exception {
        String msg;
        int result;
        Set idSet = this.getSelectedIdSet();
        ITransUpBillFacade facade = TransUpBillFacadeFactory.getRemoteInstance();
        boolean hasSendReceipt = facade.hasSendReceipt(idSet);
        if (hasSendReceipt && (result = MsgBox.showConfirm3((Component)((Object)this), (String)(msg = EASResource.getString((String)"com.kingdee.eas.fm.fs.TransBillResource", (String)"unConfirmMsg")))) != 0) {
            return;
        }
        facade.unConfirm(idSet);
        FMClientHelper.showSuccessMessage((CoreUI)this, (ActionEvent)e);
        this.refresh(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionSendReceipt_actionPerformed(ActionEvent e) throws Exception {
        int successCounts;
        Set idSet = this.getSelectedIdSet();
        IMutexServiceControl iMutex = MutexServiceControlFactory.getRemoteInstance();
        ArrayList ids = new ArrayList(idSet);
        ArrayList appliedList = new ArrayList();
        ArrayList appliedFailList = new ArrayList();
        try {
            Map resultRequest = iMutex.batchRequestObjIDForUpdate(ids);
            for (int i = 0; i < ids.size(); ++i) {
                Boolean boolResult = (Boolean)resultRequest.get(ids.get(i));
                if (boolResult.booleanValue()) {
                    appliedList.add(ids.get(i));
                    continue;
                }
                appliedFailList.add(ids.get(i));
            }
            ITransUpBillFacade facade = TransUpBillFacadeFactory.getRemoteInstance();
            successCounts = 0;
            if (appliedList.size() > 0) {
                successCounts = facade.sendReceipt(new HashSet(appliedList));
            }
        }
        finally {
            if (appliedList.size() > 0) {
                iMutex.batchReleaseObjIDForUpdate(appliedList);
            }
        }
        FMClientHelper.showSuccessMessage((CoreUI)this, (ActionEvent)e, (int)successCounts);
        this.refresh(e);
    }

    @Override
    public void actionWithdrawReceipt_actionPerformed(ActionEvent e) throws Exception {
        Set idSet = this.getSelectedIdSet();
        ITransUpBillFacade facade = TransUpBillFacadeFactory.getRemoteInstance();
        int successCounts = facade.withdrawReceipt(idSet);
        FMClientHelper.showSuccessMessage((CoreUI)this, (ActionEvent)e, (int)successCounts);
        this.refresh(e);
    }

    public void actionVoucher_actionPerformed(ActionEvent e) throws Exception {
        super.actionVoucher_actionPerformed(e);
    }

    public void actionDelVoucher_actionPerformed(ActionEvent e) throws Exception {
        super.actionDelVoucher_actionPerformed(e);
    }

    private void checkPassword() throws UIException {
        try {
            String checkFlag = SubmitPasswordFactory.getRemoteInstance().checkPassword("password");
            if ("0".equals(checkFlag)) {
                return;
            }
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        UIContext uiContext = new UIContext((Object)this);
        IUIWindow uiWindow = null;
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(SubmitPasswordUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        if (uiWindow.getUIObject().getUIContext().get("password") == null || !uiWindow.getUIObject().getUIContext().get("password").equals("true")) {
            SysUtil.abort();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionSubmitToBe_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        Set idSet = this.getSelectedIdSet();
        Component component = (Component)e.getSource();
        this.checkPassword();
        String errorDetail = "";
        String error = "";
        Map map = new HashMap();
        try {
            ITransUpBillFacade facade = TransUpBillFacadeFactory.getRemoteInstance();
            map = facade.batchCommitToBe(idSet);
            Map errorMap = (Map)map.get("errorMap");
            for (String number : errorMap.keySet()) {
                errorDetail = errorDetail + MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"401_billNumber"), number, (String)errorMap.get(number));
            }
            error = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"402_commitToBeSuccess"), idSet.size() - errorMap.size(), errorMap.size());
            if ("true".equalsIgnoreCase(PermissionParameterFactory.getRemoteInstance().getPermissionParameter("EnableAutoSign"))) {
                this.actionSignature_actionPerformed(e);
            }
        }
        finally {
            this.refresh(e);
            if (!EmptyUtil.isEmpty((String)errorDetail)) {
                MsgBox.showDetailAndOK((Component)component, (String)error, (String)errorDetail, (int)1);
            } else {
                FMClientHelper.showSuccessMessageBox((CoreUI)this, (Component)component);
            }
        }
    }

    public void actionViewBdgBalance_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        TransUpBillInfo info = ((ITransUpBill)this.getBizInterface()).getTransUpBillInfo((IObjectPK)new ObjectUuidPK(id), this.getSelectors());
        FMClientHelper.viewBgBalance((Component)((Object)this), null, null, (IObjectValue)info);
    }

    @Override
    public void actionTdPrintView_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = super.getSelectedIdValues();
        if (idList == null || idList.size() == 0) {
            return;
        }
        Set idSet = FMHelper.list2Set((List)idList);
        IMetaDataPK headPK = MetaDataPKFactory.getMetaDataPK((String)"com.kingdee.eas.fm.fs.TransUpBillHeaderTDQuery");
        DefaultNoteDataProvider dataProvider = new DefaultNoteDataProvider(idSet, headPK);
        String mainDsName = "TransUpBillHeaderTDQuery";
        dataProvider.addMetaDataPK(mainDsName, headPK);
        dataProvider.addCustomFilterMaker(mainDsName, (DefaultNoteDataProvider.ICustomFilterMaker)new DefaultNoteDataProvider.DefaultIdFilterMaker(idSet));
        String entryDsName = "TransUpBillEntryTDQuery";
        IMetaDataPK entryPK = MetaDataPKFactory.getMetaDataPK((String)"com.kingdee.eas.fm.fs.TransUpBillEntryTDQuery");
        dataProvider.addMetaDataPK(entryDsName, entryPK);
        dataProvider.addForeignKey((Object)entryDsName, "parentId");
        dataProvider.setBatchSupported(true);
        dataProvider.setNumberOfEachBatch(100);
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.printPreview(PAYMENTBILL_FILENAME, (Object)dataProvider, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    @Override
    public void actionTdPrint_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = super.getSelectedIdValues();
        if (idList == null || idList.size() == 0) {
            return;
        }
        Set idSet = FMHelper.list2Set((List)idList);
        IMetaDataPK headPK = MetaDataPKFactory.getMetaDataPK((String)"com.kingdee.eas.fm.fs.TransUpBillHeaderTDQuery");
        DefaultNoteDataProvider dataProvider = new DefaultNoteDataProvider(idSet, headPK);
        String mainDsName = "TransUpBillHeaderTDQuery";
        dataProvider.addMetaDataPK(mainDsName, headPK);
        dataProvider.addCustomFilterMaker(mainDsName, (DefaultNoteDataProvider.ICustomFilterMaker)new DefaultNoteDataProvider.DefaultIdFilterMaker(idSet));
        String entryDsName = "TransUpBillEntryTDQuery";
        IMetaDataPK entryPK = MetaDataPKFactory.getMetaDataPK((String)"com.kingdee.eas.fm.fs.TransUpBillEntryTDQuery");
        dataProvider.addMetaDataPK(entryDsName, entryPK);
        dataProvider.addForeignKey((Object)entryDsName, "parentId");
        dataProvider.setBatchSupported(true);
        dataProvider.setNumberOfEachBatch(100);
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.print(PAYMENTBILL_FILENAME, (Object)dataProvider, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    protected boolean isSetColumnPrecFmt() {
        return true;
    }

    protected String[] getQueryShowField() {
        return new String[]{"number", "bizDate", "motherAcctBank", "payeeArea", "usage", "seq", "currency.name", "exchangeRate", "totalAmt", "totalCounts", "confirmedAmt", "confirmedCounts", "state", "isCommittoBe", "isUrgent", "Fivouchered", "accessories", "creator.name", "auditor.name", "cashier.name", "accountant.name", "unitAcctBank", "unit", "amount", "isSuccess", "isSendReceipt", "bgItem", "recProvince", "recCity", "project", "sourceType", "feeType.name"};
    }

    @Override
    public void actionRejected_actionPerformed(ActionEvent e) throws Exception {
        this.checkRejected();
        super.actionRejected_actionPerformed(e);
        ApplyTransBillRejectedUI.show((CoreUIObject)this, (IObjectPK)new ObjectUuidPK(this.getSelectedKeyValue()), SourceTypeEnum.APPTRANSUP);
        this.refresh(e);
    }

    private void checkRejected() throws EASBizException, BOSException {
        TransUpBillInfo info = this.getSelectedInfo();
        if (!TransUpBillStateEnum.SAVED.equals((Object)info.getState()) && !TransUpBillStateEnum.SUBMITED.equals((Object)info.getState())) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"293_TransUpBillListUI"));
            SysUtil.abort();
        }
        if (!SourceTypeEnum.APPTRANSUP.equals((Object)info.getSourceType())) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"294_TransUpBillListUI"));
            SysUtil.abort();
        }
    }

    private TransUpBillInfo getSelectedInfo() throws EASBizException, BOSException {
        this.checkSelected();
        return TransUpBillFactory.getRemoteInstance().getTransUpBillInfo((IObjectPK)new ObjectUuidPK(this.getSelectedKeyValue()));
    }

    public static void checkCompany(Component uiComp, String oprtState, CompanyOrgUnitInfo companyInfo) {
        boolean expired;
        if ("FINDVIEW".equals(oprtState) || "VIEW".equals(oprtState)) {
            return;
        }
        if (companyInfo == null || GlUtils.isCompanyUnion((CompanyOrgUnitInfo)companyInfo)) {
            MsgBox.showWarning((Component)uiComp, (String)EASResource.getString((String)RES, (String)"Company_AlertMsg"));
            SysUtil.abort();
        }
        Date curDate = new Date();
        Date invalidDate = companyInfo.getInvalidDate();
        boolean bl = expired = invalidDate != null && curDate.after(invalidDate);
        if (expired) {
            MsgBox.showWarning((Component)uiComp, (String)EASResource.getString((String)RES, (String)"Company_InvalidMsg"));
            SysUtil.abort();
        }
    }

    @Override
    protected boolean isFootVisible() {
        return true;
    }

    protected IRow appendFootRow() {
        IRow footRow = super.appendFootRow();
        if (footRow != null) {
            String[] numberCols = new String[]{"totalAmt", "totalCounts", "confirmedAmt", "confirmedCounts"};
            int[] numberColsPrecision = new int[]{4, 0, 4, 0};
            for (int i = 0; i < numberCols.length; ++i) {
                this.tblMain.getFootRow(0).getCell(numberCols[i]).getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm((int)numberColsPrecision[i]));
            }
        }
        return footRow;
    }

    @Override
    public void actionBatchConfirm_actionPerformed(ActionEvent e) throws Exception {
        Boolean boolResult;
        int i;
        this.checkSelected();
        Set idSet = this.getSelectedIdSet();
        this.checkBoforeConfirm();
        HashMap<String, TransUpBillInfo> idInfoMap = new HashMap<String, TransUpBillInfo>();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().add("number");
        evi.getSelector().add("company.id");
        evi.getSelector().add("id");
        TransUpBillCollection coll = TransUpBillFactory.getRemoteInstance().getTransUpBillCollection(evi);
        TransUpBillInfo info = null;
        IPermission iPermission = PermissionFactory.getRemoteInstance();
        for (int i2 = 0; i2 < coll.size(); ++i2) {
            info = coll.get(i2);
            iPermission.checkDataPermission(this.getUserPk(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId().toString()), "TRANS_UP_CONFIRM", (IObjectPK)new ObjectUuidPK(info.getId().toString()));
            idInfoMap.put(info.getId().toString(), info);
        }
        IMutexServiceControl iMutex = MutexServiceControlFactory.getRemoteInstance();
        List idList = FMHelper.set2List((Set)idSet);
        ArrayList appliedList = new ArrayList();
        String errorDetail = "";
        Map resultRequest = iMutex.batchRequestObjIDForUpdate(idList);
        for (i = 0; i < idList.size(); ++i) {
            boolResult = (Boolean)resultRequest.get(idList.get(i));
            if (!boolResult.booleanValue()) continue;
            appliedList.add(idList.get(i));
        }
        for (i = 0; i < idList.size(); ++i) {
            boolResult = (Boolean)resultRequest.get(idList.get(i));
            if (boolResult.booleanValue()) continue;
            TransUpBillInfo downInfo = (TransUpBillInfo)idInfoMap.get(idList.get(i));
            String msg = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"411_reqMutex_error"), downInfo.getNumber()) + "\n";
            errorDetail = errorDetail + msg;
        }
        Set appliedSet = FMHelper.list2Set(appliedList);
        Map map = TransUpBillFacadeFactory.getRemoteInstance().batchConfirm(appliedSet);
        for (String id : map.keySet()) {
            errorDetail = errorDetail + (String)map.get(id) + "\n";
        }
        String error = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"403_batchConfirmSuccess"), idSet.size() - map.size(), map.size());
        Component component = (Component)e.getSource();
        this.refresh(e);
        MsgBox.showDetailAndOK((Component)component, (String)error, (String)errorDetail, (int)1);
        SysUtil.abort();
        if (appliedList.size() > 0) {
            iMutex.batchReleaseObjIDForUpdate(appliedList);
        }
    }

    private Map getIdInfoMap(Set idSet) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().add("number");
        evi.getSelector().add("id");
        TransUpBillCollection coll = TransUpBillFactory.getRemoteInstance().getTransUpBillCollection(evi);
        HashMap<String, TransUpBillInfo> idInfoMap = new HashMap<String, TransUpBillInfo>();
        TransUpBillInfo info = null;
        for (int i = 0; i < coll.size(); ++i) {
            info = coll.get(i);
            idInfoMap.put(info.getId().toString(), info);
        }
        return idInfoMap;
    }

    @Override
    public void actionBatchSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        Set idSet = this.getSelectedIdSet();
        Map map = TransUpBillFactory.getRemoteInstance().batchSubmit(idSet);
        String errorDetail = (String)map.get("errorDetail");
        this.refresh(e);
        if (errorDetail.length() > 1) {
            String error = EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"289_TransDownBillListUI");
            Component component = (Component)e.getSource();
            MsgBox.showDetailAndOK((Component)component, (String)error, (String)errorDetail, (int)1);
        } else {
            Component component = (Component)e.getSource();
            FMClientHelper.showSuccessMessageBox((CoreUI)this, (Component)component);
        }
        SysUtil.abort();
    }

    public void actionMultiapprove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        super.actionMultiapprove_actionPerformed(e);
    }

    @Override
    public void actionNavEreceipt_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = super.getSelectedIdValues();
        EReceiptCommonClientHelper.viewEreceiptByBillIdList((List)idList, (Component)((Object)this));
    }

    @Override
    public void actionOpenSmart_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList validList = this.getSelectedIdValues();
        Set validSet = FMHelper.list2Set((List)validList);
        BatchExecuteResult result = new BatchExecuteResult();
        result = (BatchExecuteResult)TransUpBillFactory.getRemoteInstance().openSmart(validSet);
        StringBuffer errorDetail = new StringBuffer();
        if (!EmptyUtil.isEmpty((Object)result) && !EmptyUtil.isEmpty((Collection)result.getDetailMsgList())) {
            for (int i = 0; i < result.getDetailMsgList().size(); ++i) {
                errorDetail.append((String)result.getDetailMsgList().get(i) + "\n");
            }
        }
        if (EmptyUtil.isEmpty((String)errorDetail.toString())) {
            MsgBox.showInfo((String)result.getSummaryMsg());
        } else {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)result.getSummaryMsg(), (String)errorDetail.toString(), (int)0);
        }
        this.refresh(e);
    }

    @Override
    public void actionCloseSmart_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList validList = this.getSelectedIdValues();
        Set validSet = FMHelper.list2Set((List)validList);
        BatchExecuteResult result = new BatchExecuteResult();
        result = (BatchExecuteResult)TransUpBillFactory.getRemoteInstance().closeSmart(validSet);
        StringBuffer errorDetail = new StringBuffer();
        if (!EmptyUtil.isEmpty((Object)result) && !EmptyUtil.isEmpty((Collection)result.getDetailMsgList())) {
            for (int i = 0; i < result.getDetailMsgList().size(); ++i) {
                errorDetail.append((String)result.getDetailMsgList().get(i) + "\n");
            }
        }
        if (EmptyUtil.isEmpty((String)errorDetail.toString())) {
            MsgBox.showInfo((String)result.getSummaryMsg());
        } else {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)result.getSummaryMsg(), (String)errorDetail.toString(), (int)0);
        }
        this.refresh(e);
    }

    @Override
    public void actionNavInnerEreceipt_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = super.getSelectedIdValues();
        EReceiptInnerClientHelper.viewInnerEreceiptByBillIdList((List)idList, (Component)((Object)this));
    }
}

