/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.OverdraftCtrlEnum;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.client.AccountPromptBox;
import com.kingdee.eas.basedata.master.util.StringUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.IPaymentBill;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.RecPayAcctBankStratageCtrl;
import com.kingdee.eas.fi.cas.client.CasRecPayHandler;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.fs.FSHelper;
import com.kingdee.eas.fm.fs.ISettleFacade;
import com.kingdee.eas.fm.fs.ISettlementBill;
import com.kingdee.eas.fm.fs.SettBizTypeEnum;
import com.kingdee.eas.fm.fs.SettleFacadeFactory;
import com.kingdee.eas.fm.fs.SettlementBillCollection;
import com.kingdee.eas.fm.fs.SettlementBillFactory;
import com.kingdee.eas.fm.fs.SettlementBillInfo;
import com.kingdee.eas.fm.fs.client.AbstractWriteCHBankAcctUI;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.fm.fs.client.SettlementBillHandler;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class WriteCHBankAcctUI
extends AbstractWriteCHBankAcctUI {
    private static final Logger logger = CoreUIObject.getLogger(WriteCHBankAcctUI.class);
    private static final String ID_SET = "idSet";
    private static final String IS_PAYEE = "isPayee";
    private static final String ID = "id";
    private static final String TYPE = "type";
    private static final String NUMBER = "number";
    private static final String CURRENCY = "currency";
    private static final String CURRENCY_NAME = "currency.name";
    private static final String AMOUNT = "amount";
    private static final String ACCOUNTVIEW = "accountview";
    private static final String CHBANK_ACCT = "CHBankAcct";
    private static final String BALANCE = "balance";
    private static final String SETTLE_TYPE = "settleType";
    private static final String SETTLE_NUM = "settleNum";
    private SettlementBillCollection coll = null;
    private SettlementBillHandler handler = SettlementBillHandler.create();
    private CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
    private UserInfo userInfo = ContextHelperFactory.getRemoteInstance().getCurrentUser();
    private boolean isPayee = false;

    public void onLoad() throws Exception {
        super.onLoad();
        this.isPayee = (Boolean)this.getUIContext().get(IS_PAYEE);
        this.initUIProp();
        Set idSet = (Set)this.getUIContext().get(ID_SET);
        this.fillData(idSet);
    }

    private String getResString(boolean isPayee, boolean isHaveM) {
        String resName = null;
        resName = isPayee ? "Rec" : "Pay";
        String resClassName = "com.kingdee.eas.fm.fs.SettlementBillUI";
        String resString = EASResource.getString((String)resClassName, (String)"WriteCHBankAcctAndSettle");
        if (isHaveM) {
            resString = resString + "(M)";
        }
        return MessageFormat.format(resString, EASResource.getString((String)resClassName, (String)resName));
    }

    private void initUIProp() throws EASBizException, BOSException {
        this.btnSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_submit"));
        String iconName = null;
        iconName = this.isPayee ? "imgTbtn_gathering" : "imgTbtn_payment";
        this.btnSubmitAndSettle.setIcon(EASResource.getIcon((String)iconName));
        this.btnSubmitAndSettle.setText(this.getResString(this.isPayee, true));
        this.btnSubmitAndSettle.setToolTipText(this.getResString(this.isPayee, false));
        this.menuItemSubmitAndSettle.setText(this.getResString(this.isPayee, true));
        this.menuItemSubmitAndSettle.setIcon(EASResource.getIcon((String)iconName));
        this.tblMain.checkParsed();
        KDBizPromptBox editor = new KDBizPromptBox();
        editor.setEditable(true);
        editor.setDisplayFormat("$name$");
        editor.setEditFormat("$number$");
        editor.setCommitFormat("$simpleCode$;$number$;$name$");
        editor.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7AccountBankQuery");
        KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor((IKDEditor)editor);
        this.tblMain.getColumn(CHBANK_ACCT).setEditor((ICellEditor)cellEditor);
        KDBizPromptBox accountvieweditor = new KDBizPromptBox();
        accountvieweditor.setEditable(true);
        accountvieweditor.setDisplayFormat("$number$ $name$");
        accountvieweditor.setEditFormat("$number$");
        accountvieweditor.setCommitFormat("$number$;$name$");
        accountvieweditor.setQueryInfo("com.kingdee.eas.basedata.master.account.app.AccountViewQuery");
        KDTDefaultCellEditor accountviewcellEditor = new KDTDefaultCellEditor((IKDEditor)accountvieweditor);
        this.tblMain.getColumn(ACCOUNTVIEW).setEditor((ICellEditor)accountviewcellEditor);
        KDBizPromptBox editor2 = new KDBizPromptBox();
        editor2.setEditable(true);
        editor2.setDisplayFormat("$name$");
        editor2.setEditFormat("$number$");
        editor2.setCommitFormat("$number$");
        editor2.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7SettlementTypeQuery");
        KDTDefaultCellEditor cellEditor2 = new KDTDefaultCellEditor((IKDEditor)editor2);
        this.tblMain.getColumn(SETTLE_TYPE).setEditor((ICellEditor)cellEditor2);
        KDTextField editor3 = new KDTextField();
        editor3.setMaxLength(1000);
        cellEditor = new KDTDefaultCellEditor((JTextField)editor3);
        this.tblMain.getColumn(SETTLE_NUM).setEditor((ICellEditor)cellEditor);
    }

    @Override
    protected void tblMain_editStarting(KDTEditEvent e) throws Exception {
        CurrencyInfo currencyInfo;
        int colIndex = e.getColIndex();
        int rowIndex = e.getRowIndex();
        int bankAcctColIndex = this.tblMain.getColumn(CHBANK_ACCT).getColumnIndex();
        int acctColIndex = this.tblMain.getColumn(ACCOUNTVIEW).getColumnIndex();
        int settleTypeColIndex = this.tblMain.getColumn(SETTLE_TYPE).getColumnIndex();
        if (colIndex != acctColIndex && colIndex != bankAcctColIndex && colIndex != settleTypeColIndex) {
            return;
        }
        KDBizPromptBox prmtBox = (KDBizPromptBox)((KDTDefaultCellEditor)this.tblMain.getColumn(colIndex).getEditor()).getComponent();
        if (colIndex == bankAcctColIndex) {
            currencyInfo = (CurrencyInfo)this.tblMain.getRow(rowIndex).getCell(CURRENCY).getValue();
            AccountViewInfo accountviewInfo = (AccountViewInfo)this.tblMain.getRow(rowIndex).getCell(ACCOUNTVIEW).getValue();
            SettBizTypeEnum bizType = (SettBizTypeEnum)((Object)this.tblMain.getRow(rowIndex).getCell(TYPE).getValue());
            boolean isPayer = false;
            if (bizType == SettBizTypeEnum.PAYOUTSIDE || bizType == SettBizTypeEnum.LINKPAY) {
                isPayer = true;
            }
            if (accountviewInfo != null) {
                this.setBankAcctF7(prmtBox, accountviewInfo.getId().toString(), currencyInfo, isPayer);
            } else {
                this.setBankAcctF7(prmtBox, null, currencyInfo, isPayer);
            }
        }
        if (colIndex == acctColIndex) {
            currencyInfo = (CurrencyInfo)this.tblMain.getRow(rowIndex).getCell(CURRENCY).getValue();
            this.setPayerAcctEvi(prmtBox, currencyInfo);
        } else if (colIndex == settleTypeColIndex) {
            FilterInfo filter = new FilterInfo();
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(filter);
            prmtBox.setEntityViewInfo(evi);
        }
    }

    private void setPayerAcctEvi(KDBizPromptBox prmtPayerAccount, CurrencyInfo currencyInfo) throws EASBizException, BOSException {
        String currencyId = currencyInfo.getId().toString();
        String companyId = this.currentCompany.getId().toString();
        String cuId = this.currentCompany.getCU().getId().toString();
        prmtPayerAccount.getQueryAgent().resetRuntimeEntityView();
        EntityViewInfo treeevi = CasRecPayHandler.getAccountViewEvi((String)cuId, (String)companyId, (String)currencyId, (boolean)false);
        AccountPromptBox opseelect = new AccountPromptBox((IUIObject)this, this.currentCompany, treeevi.getFilter(), false, true);
        prmtPayerAccount.setSelector((KDPromptSelector)opseelect);
        EntityViewInfo evi = CasRecPayHandler.getAccountViewEvi((String)cuId, (String)companyId, (String)currencyId, (boolean)true);
        prmtPayerAccount.setEntityViewInfo(evi);
    }

    public void setBankAcctF7(KDBizPromptBox f7BankAcct, String accountId, CurrencyInfo currencyInfo, boolean isPayer) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("bank.*"));
        sic.add(new SelectorItemInfo("account.*"));
        f7BankAcct.setSelectorCollection(sic);
        BankInfo clearingHouse = FSClientHelper.getClearingHouse();
        String chId = clearingHouse.getId().toString();
        String chCompanyId = clearingHouse.getRelatedCompany().getId().toString();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)chCompanyId));
        filter.getFilterItems().add(new FilterItemInfo("bank.id", (Object)chId, CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)Boolean.FALSE));
        boolean val = ContextHelperFactory.getRemoteInstance().getBooleanParam("TM017", (IObjectPK)new ObjectUuidPK(chCompanyId));
        if (val) {
            filter.getFilterItems().add(new FilterItemInfo("property.property", (Object)new Integer(1)));
        }
        if (!FMHelper.isEmpty((String)accountId)) {
            filter.getFilterItems().add(new FilterItemInfo("account.id", (Object)accountId));
        }
        if (isPayer) {
            filter.getFilterItems().add(new FilterItemInfo("notOutPay", (Object)Constants.TRUE, CompareType.NOTEQUALS));
        }
        FilterInfo filterCurreny = new FilterInfo();
        filterCurreny.getFilterItems().add(new FilterItemInfo("isByCurrency", (Object)Boolean.FALSE));
        filterCurreny.getFilterItems().add(new FilterItemInfo("isByCurrency", (Object)Boolean.TRUE));
        filterCurreny.getFilterItems().add(new FilterItemInfo("currency.id", (Object)currencyInfo.getId().toString()));
        filterCurreny.setMaskString("#0 OR (#1 AND #2)");
        filter.mergeFilter(filterCurreny, "AND");
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        f7BankAcct.setEntityViewInfo(evi);
    }

    @Override
    protected void tblMain_editStarted(KDTEditEvent e) throws Exception {
    }

    @Override
    protected void tblMain_editStopped(KDTEditEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        if (colIndex != this.tblMain.getColumn(CHBANK_ACCT).getColumnIndex() && colIndex != this.tblMain.getColumn(SETTLE_TYPE).getColumnIndex() && colIndex != this.tblMain.getColumn(ACCOUNTVIEW).getColumnIndex()) {
            return;
        }
        if (e.getOldValue() != null && e.getOldValue().equals(e.getValue())) {
            return;
        }
        CurrencyInfo currencyInfo = (CurrencyInfo)this.tblMain.getRow(rowIndex).getCell(CURRENCY).getValue();
        AccountBankInfo acctBankInfo = (AccountBankInfo)this.tblMain.getRow(rowIndex).getCell(CHBANK_ACCT).getValue();
        AccountViewInfo acctInfo = (AccountViewInfo)this.tblMain.getRow(rowIndex).getCell(ACCOUNTVIEW).getValue();
        if (colIndex == this.tblMain.getColumn(CHBANK_ACCT).getColumnIndex()) {
            BigDecimal balance = this.handler.getBalanceValue(currencyInfo, acctBankInfo);
            this.tblMain.getRow(rowIndex).getCell(BALANCE).setValue((Object)balance);
            if (acctBankInfo != null) {
                this.tblMain.getRow(rowIndex).getCell(ACCOUNTVIEW).setValue((Object)acctBankInfo.getAccount());
            }
        }
        if (colIndex == this.tblMain.getColumn(ACCOUNTVIEW).getColumnIndex() && acctInfo != null && acctBankInfo != null && !acctBankInfo.getAccount().getId().equals((Object)acctInfo.getId())) {
            this.tblMain.getRow(rowIndex).getCell(CHBANK_ACCT).setValue(null);
        }
        if (rowIndex == 0) {
            IRow row = null;
            boolean isSettleTypeCol = SETTLE_TYPE.equals(this.tblMain.getColumn(colIndex).getKey());
            BigDecimal balance = (BigDecimal)this.tblMain.getRow(rowIndex).getCell(BALANCE).getValue();
            SettlementTypeInfo settleType = (SettlementTypeInfo)this.tblMain.getRow(rowIndex).getCell(SETTLE_TYPE).getValue();
            AccountViewInfo accountview = (AccountViewInfo)this.tblMain.getRow(rowIndex).getCell(ACCOUNTVIEW).getValue();
            acctBankInfo = (AccountBankInfo)this.tblMain.getRow(rowIndex).getCell(CHBANK_ACCT).getValue();
            int count = this.tblMain.getRowCount();
            for (int i = rowIndex + 1; i < count; ++i) {
                row = this.tblMain.getRow(i);
                row.getCell(CHBANK_ACCT).setValue((Object)acctBankInfo);
                row.getCell(ACCOUNTVIEW).setValue((Object)accountview);
                row.getCell(BALANCE).setValue((Object)balance);
                if (!isSettleTypeCol) continue;
                row.getCell(SETTLE_TYPE).setValue((Object)settleType);
            }
        }
    }

    private void fillData(Set idSet) throws BOSException, EASBizException {
        SettlementBillCollection coll = this.getColl(idSet);
        SettlementBillInfo info = null;
        String currencyID = null;
        AccountBankInfo acctBankInfo = null;
        AccountViewInfo accountview = null;
        IRow row = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            row = this.tblMain.addRow();
            info = coll.get(i);
            if (info.getCashier() != null) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fs.SettlementBillUI", (String)"HasSettled"));
                SysUtil.abort();
            }
            currencyID = info.getCurrency().getId().toString();
            FMClientHelper.setNumberFormat((IRow)row, (String)AMOUNT, (String)currencyID);
            FMClientHelper.setNumberFormat((IRow)row, (String)BALANCE, (String)currencyID);
            acctBankInfo = this.getAcctBankInfo(info);
            accountview = this.getAcctViewInfo(info);
            row.getCell(ID).setValue((Object)info.getId().toString());
            row.getCell(TYPE).setValue((Object)info.getType());
            row.getCell(NUMBER).setValue((Object)info.getNumber());
            row.getCell(CURRENCY).setValue((Object)info.getCurrency());
            row.getCell(CURRENCY_NAME).setValue((Object)info.getCurrency().getName());
            row.getCell(AMOUNT).setValue((Object)info.getAmount());
            row.getCell(CHBANK_ACCT).setValue((Object)acctBankInfo);
            row.getCell(ACCOUNTVIEW).setValue((Object)accountview);
            row.getCell(SETTLE_TYPE).setValue((Object)info.getSettleType());
            row.getCell(SETTLE_NUM).setValue((Object)info.getOuterSettleNumber());
            BigDecimal balance = this.handler.getBalanceValue(info.getCurrency(), acctBankInfo);
            row.getCell(BALANCE).setValue((Object)balance);
        }
    }

    private AccountBankInfo getAcctBankInfo(SettlementBillInfo info) {
        AccountBankInfo acctBankInfo = null;
        if (info.getType().equals((Object)SettBizTypeEnum.RECOUTSIDE)) {
            acctBankInfo = info.getPayeeBankAcct();
        } else if (info.getType().equals((Object)SettBizTypeEnum.PAYOUTSIDE) || info.getType().equals((Object)SettBizTypeEnum.LINKPAY)) {
            acctBankInfo = info.getPayerBankAcct();
        }
        return acctBankInfo;
    }

    private AccountViewInfo getAcctViewInfo(SettlementBillInfo info) {
        AccountViewInfo acctBankInfo = null;
        if (info.getType().equals((Object)SettBizTypeEnum.RECOUTSIDE)) {
            acctBankInfo = info.getPayeeAcct();
        } else if (info.getType().equals((Object)SettBizTypeEnum.PAYOUTSIDE) || info.getType().equals((Object)SettBizTypeEnum.LINKPAY)) {
            acctBankInfo = info.getPayerAcct();
        }
        return acctBankInfo;
    }

    private SettlementBillCollection getColl(Set idSet) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo(ID, (Object)idSet, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("*"));
        evi.getSelector().add(new SelectorItemInfo("currency.*"));
        evi.getSelector().add(new SelectorItemInfo("settleType.*"));
        evi.getSelector().add(new SelectorItemInfo("payeeBankAcct.*"));
        evi.getSelector().add(new SelectorItemInfo("payerBankAcct.*"));
        evi.getSelector().add(new SelectorItemInfo("payeeAcct.*"));
        evi.getSelector().add(new SelectorItemInfo("payerAcct.*"));
        SorterItemInfo sorter = new SorterItemInfo(NUMBER);
        SorterItemCollection sorterColl = new SorterItemCollection();
        sorter.setSortType(SortType.ASCEND);
        sorterColl.add(sorter);
        evi.setSorter(sorterColl);
        ISettlementBill iSettle = SettlementBillFactory.getRemoteInstance();
        return iSettle.getSettlementBillCollection(evi);
    }

    private SettlementBillInfo getInfo(String id) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo(ID, (Object)id));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("payerInnerAcct.id"));
        evi.getSelector().add(new SelectorItemInfo(NUMBER));
        evi.getSelector().add(new SelectorItemInfo(ID));
        SettlementBillCollection coll = SettlementBillFactory.getRemoteInstance().getSettlementBillCollection(evi);
        if (coll != null && coll.size() > 0) {
            return coll.get(0);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionSubmitTo_actionPerformed(ActionEvent e) throws Exception {
        SettlementBillInfo info;
        super.actionSubmitTo_actionPerformed(e);
        this.verify();
        this.coll = this.buildSettleColl(this.tblMain);
        if (this.coll != null && this.coll.size() > 0 && (info = this.coll.get(0)).getType() != SettBizTypeEnum.RECINSIDE && info.getType() != SettBizTypeEnum.RECINSIDEDIF && info.getType() != SettBizTypeEnum.RECOUTSIDE) {
            this.verifyOverDraftBankAcct();
        }
        ArrayList<String> idList = new ArrayList<String>();
        ArrayList appliedList = new ArrayList();
        for (int i = 0; i < this.coll.size(); ++i) {
            idList.add(this.coll.get(i).getId().toString());
        }
        IMutexServiceControl iMutex = MutexServiceControlFactory.getRemoteInstance();
        try {
            if (idList.size() > 0) {
                Map detailsRequest = iMutex.batchRequestObjIDForUpdate(idList);
                for (int i = 0; i < detailsRequest.size(); ++i) {
                    Boolean boolDetail = (Boolean)detailsRequest.get(idList.get(i));
                    if (boolDetail.booleanValue()) {
                        appliedList.add(idList.get(i));
                        continue;
                    }
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"421_Message"));
                    SysUtil.abort();
                }
            }
            ISettleFacade facade = SettleFacadeFactory.getRemoteInstance();
            facade.writeCHBankAcct(this.coll, false);
        }
        finally {
            if (appliedList.size() > 0) {
                iMutex.batchReleaseObjIDForUpdate(appliedList);
            }
        }
        if (this.coll.size() > 0) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getSuccessString(e));
        }
        this.disposeUIWindow();
    }

    @Override
    public void actionSubmitAndSettle_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmitAndSettle_actionPerformed(e);
        this.verify();
        this.coll = this.buildSettleColl(this.tblMain);
        if (this.coll != null && this.coll.size() > 0) {
            for (int i = 0; i < this.coll.size(); ++i) {
                boolean val = ContextHelperFactory.getRemoteInstance().getBooleanParam("TM012", (IObjectPK)new ObjectUuidPK(ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId()));
                SettlementBillInfo info = this.coll.get(i);
                info = (SettlementBillInfo)SettlementBillFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(info.getId()));
                if (!val || info.getType() != SettBizTypeEnum.PAYOUTSIDE && info.getType() != SettBizTypeEnum.LINKPAY || info.getAuditor() != null && info.getAuditor().getId() != null) continue;
                String msgStr = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"360_WriteCHBankAcctUI"), info.getNumber());
                MsgBox.showWarning((String)msgStr);
                SysUtil.abort();
            }
        }
        ISettleFacade facade = SettleFacadeFactory.getRemoteInstance();
        facade.writeCHBankAcct(this.coll, true);
        MsgBox.showInfo((Component)((Object)this), (String)this.getSuccessString(e));
        this.tblMain.setEnabled(false);
        this.disposeUIWindow();
    }

    private String getSuccessString(ActionEvent e) {
        Component component = (Component)e.getSource();
        if (component instanceof KDWorkButton) {
            String text = ((KDWorkButton)component).getText();
            if (EmptyUtil.isEmpty((String)text)) {
                text = ((KDWorkButton)component).getToolTipText();
            }
            return text + EASResource.getString((String)"com.kingdee.eas.fm.common.client.FMCommonClientResource", (String)"SUCCESS");
        }
        if (component instanceof KDMenuItem) {
            String text = ((KDMenuItem)component).getText();
            if (EmptyUtil.isEmpty((String)text)) {
                text = ((KDMenuItem)component).getToolTipText();
            }
            text = text.replaceAll("\\([a-zA-Z]\\)", "");
            return text + EASResource.getString((String)"com.kingdee.eas.fm.common.client.FMCommonClientResource", (String)"SUCCESS");
        }
        return EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"171_WriteCHBankAcctUI");
    }

    public SettlementBillCollection getResultColl() {
        return this.coll;
    }

    private void verify() throws EASBizException {
        FMClientVerifyHelper.verifyInput((CoreUIObject)this, (KDTable)this.tblMain, (String)ACCOUNTVIEW);
        AccountViewInfo acctViewInfo = null;
        IRow row = null;
        int count = this.tblMain.getRowCount3();
        for (int i = 0; i < count; ++i) {
            row = this.tblMain.getRow(i);
            if (!(row.getCell(ACCOUNTVIEW).getValue() instanceof AccountViewInfo) || !(acctViewInfo = (AccountViewInfo)row.getCell(ACCOUNTVIEW).getValue()).isIsBank() || row.getCell(CHBANK_ACCT).getValue() != null) continue;
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"132_SettlementBillHandler"));
            SysUtil.abort();
        }
    }

    private SettlementBillCollection buildSettleColl(KDTable table) throws BOSException {
        SettlementBillInfo info = null;
        SettlementBillCollection coll = new SettlementBillCollection();
        IRow row = null;
        int count = table.getRowCount();
        for (int i = 0; i < count; ++i) {
            row = table.getRow(i);
            String id = row.getCell(ID).getValue().toString();
            info = this.getInfo(id);
            info.setType((SettBizTypeEnum)((Object)row.getCell(TYPE).getValue()));
            if (info.getType() == SettBizTypeEnum.PAYOUTSIDE || info.getType() == SettBizTypeEnum.LINKPAY) {
                info.setPayeeBankAcct(null);
                info.setPayerBankAcct((AccountBankInfo)row.getCell(CHBANK_ACCT).getValue());
                info.setPayeeAcct(null);
                info.setPayerAcct((AccountViewInfo)row.getCell(ACCOUNTVIEW).getValue());
            } else if (info.getType() == SettBizTypeEnum.RECOUTSIDE) {
                info.setPayerBankAcct(null);
                info.setPayeeBankAcct((AccountBankInfo)row.getCell(CHBANK_ACCT).getValue());
                info.setPayeeAcct(null);
                info.setPayeeAcct((AccountViewInfo)row.getCell(ACCOUNTVIEW).getValue());
            }
            info.setAmount((BigDecimal)row.getCell(AMOUNT).getValue());
            SettlementTypeInfo settInfo = (SettlementTypeInfo)row.getCell(SETTLE_TYPE).getValue();
            info.setSettleType(settInfo);
            if (settInfo != null && settInfo.isIsAgentPay()) {
                AccountBankInfo bankAcct = FSHelper.getAcctBankByInnerAcct(null, info.getPayerInnerAcct());
                if (bankAcct != null) {
                    info.setRemitAccountBank(bankAcct);
                } else {
                    MsgBox.showWarning((String)MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"416_writeWH"), info.getNumber()));
                    SysUtil.abort();
                }
            } else {
                info.setRemitAccountBank(null);
            }
            info.setOuterSettleNumber((String)row.getCell(SETTLE_NUM).getValue());
            coll.add(info);
        }
        return coll;
    }

    private void verifyOverDraftBankAcct() throws EASBizException, BOSException {
        IRow row = null;
        AccountBankInfo acctBank = null;
        BigDecimal amount = Constants.ZERO;
        BigDecimal tempAmount = Constants.ZERO;
        CurrencyInfo currencyInfo = null;
        HashMap<String, BigDecimal> amountMap = new HashMap<String, BigDecimal>();
        HashMap<String, CurrencyInfo> currencyMap = new HashMap<String, CurrencyInfo>();
        CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        String CS132 = ContextHelperFactory.getRemoteInstance().getStringParam("CS132", (IObjectPK)new ObjectUuidPK(companyInfo.getId()));
        int count = this.tblMain.getRowCount();
        for (int i = 0; i < count; ++i) {
            row = this.tblMain.getRow(i);
            acctBank = (AccountBankInfo)row.getCell(CHBANK_ACCT).getValue();
            if (EmptyUtil.isEmpty((CoreBaseInfo)acctBank)) continue;
            acctBank = AccountBankFactory.getRemoteInstance().getAccountBankInfo((IObjectPK)new ObjectUuidPK(acctBank.getId()), this.getSelectorItemColl());
            if (acctBank != null && acctBank.isIsSetBankInterface() && !"1".equals(CS132)) {
                amount = row.getCell(AMOUNT).getValue() == null ? Constants.ZERO : (BigDecimal)row.getCell(AMOUNT).getValue();
            } else {
                String settId;
                boolean isHasEffected = false;
                boolean isSaved = false;
                boolean isHasPayerAcct = false;
                boolean isPayerAcctChange = false;
                if (row.getCell(ID) != null && !StringUtil.isEmpty((String)(settId = (String)row.getCell(ID).getValue()))) {
                    isSaved = SettlementBillFactory.getRemoteInstance().exists((IObjectPK)new ObjectUuidPK(settId));
                }
                if (isSaved) {
                    settId = (String)row.getCell(ID).getValue();
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add("hasEffected");
                    sic.add("payerBankAcct.id");
                    SettlementBillInfo info = SettlementBillFactory.getRemoteInstance().getSettlementBillInfo((IObjectPK)new ObjectUuidPK(settId), sic);
                    isHasEffected = info.isHasEffected();
                    boolean bl = isHasPayerAcct = info.getPayerBankAcct() != null;
                    if (info.getPayerBankAcct() != null && !info.getPayerBankAcct().getId().toString().equals(acctBank.getId().toString())) {
                        isPayerAcctChange = true;
                    }
                }
                amount = !isSaved || !isHasEffected || !isHasPayerAcct || isPayerAcctChange ? (row.getCell(AMOUNT).getValue() == null ? Constants.ZERO : (BigDecimal)row.getCell(AMOUNT).getValue()) : Constants.ZERO;
            }
            currencyInfo = (CurrencyInfo)row.getCell(CURRENCY).getValue();
            if (!amountMap.containsKey(acctBank.getId().toString())) {
                amountMap.put(acctBank.getId().toString(), amount);
                currencyMap.put(acctBank.getId().toString(), currencyInfo);
                continue;
            }
            tempAmount = (BigDecimal)amountMap.get(acctBank.getId().toString());
            amountMap.put(acctBank.getId().toString(), tempAmount.add(amount));
        }
        this.ctrlAcctBank(amountMap, currencyMap, CS132);
    }

    public void ctrlAcctBank(Map amountMap, Map currencyMap, String CS132) throws EASBizException, BOSException {
        AccountBankInfo acctBank = null;
        BigDecimal acctBalance = Constants.ZERO;
        BigDecimal balance = Constants.ZERO;
        CurrencyInfo currencyInfo = null;
        String bankAcctId = null;
        String showMsg = EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"198_AccountBankMsg");
        String msg = null;
        StringBuffer detailMsg = new StringBuffer();
        Iterator iter = amountMap.keySet().iterator();
        IPaymentBill iPaymentBill = PaymentBillFactory.getRemoteInstance();
        while (iter.hasNext()) {
            bankAcctId = (String)iter.next();
            acctBank = AccountBankFactory.getRemoteInstance().getAccountBankInfo((IObjectPK)new ObjectUuidPK(bankAcctId), this.getSelectorItemColl());
            currencyInfo = (CurrencyInfo)currencyMap.get(bankAcctId);
            acctBalance = acctBank != null && acctBank.isIsSetBankInterface() && !"1".equals(CS132) ? iPaymentBill.getBalanceValue(bankAcctId, currencyInfo.getId().toString()) : RecPayAcctBankStratageCtrl.getSettleBillBalance(null, (CompanyOrgUnitInfo)acctBank.getCompany(), (AccountBankInfo)acctBank, null, (CurrencyInfo)currencyInfo, null, (boolean)false);
            balance = acctBalance.subtract((BigDecimal)amountMap.get(bankAcctId));
            if (acctBank.getCtrlStrategy() == null) continue;
            if (acctBank.getCtrlStrategy().getOverdraftCtrl().equals((Object)OverdraftCtrlEnum.NOTALLOW) && balance.compareTo(Constants.ZERO) < 0) {
                msg = EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"199_NotAllow");
                msg = MessageFormat.format(msg, acctBank.getName(), acctBalance, balance.abs());
                detailMsg.append(msg).append("\n");
                this.filterSettleColl(bankAcctId, acctBalance);
                continue;
            }
            if (acctBank.getCtrlStrategy().isRemind() && balance.compareTo(Constants.ZERO) < 0) {
                msg = EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"200_IsRemind");
                msg = MessageFormat.format(msg, acctBank.getName(), acctBalance, balance.abs());
                detailMsg.append(msg).append("\n");
                if (!acctBank.getCtrlStrategy().getOverdraftCtrl().equals((Object)OverdraftCtrlEnum.INLIMITCANOVERDRAFT) || balance.negate().compareTo(acctBank.getCtrlStrategy().getOverDraftAmount()) <= 0) continue;
                this.filterSettleColl(bankAcctId, acctBalance.add(acctBank.getCtrlStrategy().getOverDraftAmount()));
                continue;
            }
            if (!acctBank.getCtrlStrategy().getOverdraftCtrl().equals((Object)OverdraftCtrlEnum.LOWESTDEPOSITGUARANTEE) || balance.compareTo(acctBank.getCtrlStrategy().getLowestBalance()) >= 0) continue;
            this.filterSettleColl(bankAcctId, acctBalance.subtract(acctBank.getCtrlStrategy().getLowestBalance()));
        }
        if (detailMsg.length() == 0) {
            return;
        }
        int result = MsgBox.showConfirm3((Component)((Object)this), (String)showMsg, (String)detailMsg.toString());
        if (result != 1 && result != 2) {
            return;
        }
        SysUtil.abort();
    }

    private SelectorItemCollection getSelectorItemColl() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo(ID));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo(NUMBER));
        sic.add(new SelectorItemInfo("company"));
        sic.add(new SelectorItemInfo("ctrlStrategy.id"));
        sic.add(new SelectorItemInfo("isSetBankInterface"));
        sic.add(new SelectorItemInfo("ctrlStrategy.name"));
        sic.add(new SelectorItemInfo("ctrlStrategy.number"));
        sic.add(new SelectorItemInfo("ctrlStrategy.remind"));
        sic.add(new SelectorItemInfo("ctrlStrategy.overdraftCtrl"));
        sic.add(new SelectorItemInfo("ctrlStrategy.overDraftAmount"));
        return sic;
    }

    private void filterSettleColl(String bankAcctId, BigDecimal useBalance) {
        SettlementBillInfo info = null;
        BigDecimal amount = Constants.ZERO;
        for (int i = 0; i < this.coll.size(); ++i) {
            info = this.coll.get(i);
            if (info.getType() == SettBizTypeEnum.PAYOUTSIDE || info.getType() == SettBizTypeEnum.LINKPAY) {
                if (!bankAcctId.equals(info.getPayerBankAcct().getId().toString()) || useBalance.compareTo(amount = amount.add(info.getAmount())) >= 0) continue;
                this.coll.remove(info);
                --i;
                continue;
            }
            if (info.getType() != SettBizTypeEnum.RECOUTSIDE || !bankAcctId.equals(info.getPayeeBankAcct().getId().toString()) || useBalance.compareTo(amount = amount.add(info.getAmount())) >= 0) continue;
            this.coll.remove(info);
            --i;
        }
    }

    public static IUIWindow showDialogWindows(IUIObject ui, Set idSet, boolean isPayee) throws UIException {
        if (idSet == null || idSet.isEmpty()) {
            return null;
        }
        UIContext uiContext = new UIContext((Object)ui);
        uiContext.put((Object)ID_SET, (Object)idSet);
        uiContext.put((Object)"selectIds", (Object)FMHelper.set2List((Set)idSet));
        uiContext.put((Object)"time", (Object)("" + System.currentTimeMillis()));
        uiContext.put((Object)IS_PAYEE, (Object)isPayee);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)FMClientHelper.getEditUIMode((CoreUIObject)((CoreUIObject)ui))).create(WriteCHBankAcctUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
        return uiWindow;
    }
}

