/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.client.AccountPromptBox;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.client.CasRecPayHandler;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.fs.ISettleFacade;
import com.kingdee.eas.fm.fs.ISettlementBill;
import com.kingdee.eas.fm.fs.InnerAccountFactory;
import com.kingdee.eas.fm.fs.InnerAccountInfo;
import com.kingdee.eas.fm.fs.SettBizTypeEnum;
import com.kingdee.eas.fm.fs.SettleFacadeFactory;
import com.kingdee.eas.fm.fs.SettlementBillCollection;
import com.kingdee.eas.fm.fs.SettlementBillFactory;
import com.kingdee.eas.fm.fs.SettlementBillInfo;
import com.kingdee.eas.fm.fs.UpReckoningTypeEnum;
import com.kingdee.eas.fm.fs.client.AbstractWriteInnerBankAcctUI;
import com.kingdee.eas.fm.fs.client.SettlementBillHandler;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class WriteInnerBankAcctUI
extends AbstractWriteInnerBankAcctUI {
    private static final Logger logger = CoreUIObject.getLogger(WriteInnerBankAcctUI.class);
    private static final String ID_SET = "idSet";
    private static final String IS_PAYEE = "isPayee";
    private static final String ID = "id";
    private static final String TYPE = "type";
    private static final String NUMBER = "number";
    private static final String CURRENCY = "currency";
    private static final String CURRENCY_NAME = "currency.name";
    private static final String AMOUNT = "amount";
    private static final String PAYUNIT = "payUnit";
    private static final String PAYACCOUNTBANK = "payAccountBank";
    private static final String PAYBANK = "payBank";
    private static final String DESCRIPTION = "description";
    private static final String USAGE = "usage";
    private static final String PAYEEINNEACT = "payeeInnteAct";
    private static final String PAYEEACCOUNT = "payeeAccount";
    private SettlementBillCollection coll = null;
    private SettlementBillHandler handler = SettlementBillHandler.create();
    private CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
    private boolean isPayee = false;

    public static IUIWindow showDialogWindows(IUIObject ui, Set idSet, boolean isPayee) throws UIException {
        if (idSet == null || idSet.isEmpty()) {
            return null;
        }
        UIContext uiContext = new UIContext((Object)ui);
        uiContext.put((Object)ID_SET, (Object)idSet);
        uiContext.put((Object)"selectIds", (Object)FMHelper.set2List((Set)idSet));
        uiContext.put((Object)"time", (Object)("" + System.currentTimeMillis()));
        uiContext.put((Object)IS_PAYEE, (Object)isPayee);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)FMClientHelper.getEditUIMode((CoreUIObject)((CoreUIObject)ui))).create(WriteInnerBankAcctUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
        return uiWindow;
    }

    public SettlementBillCollection getResultColl() {
        return this.coll;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionSubmitTo_actionPerformed(ActionEvent e) throws Exception {
        SettlementBillInfo info;
        super.actionSubmitTo_actionPerformed(e);
        this.verify();
        this.coll = this.buildSettleColl(this.tblMain);
        if (this.coll == null || this.coll.size() <= 0 || (info = this.coll.get(0)).getType() == SettBizTypeEnum.RECINSIDE || info.getType() == SettBizTypeEnum.RECINSIDEDIF || info.getType() != SettBizTypeEnum.RECOUTSIDE) {
            // empty if block
        }
        ArrayList<String> idList = new ArrayList<String>();
        ArrayList appliedList = new ArrayList();
        for (int i = 0; i < this.coll.size(); ++i) {
            idList.add(this.coll.get(i).getId().toString());
        }
        IMutexServiceControl iMutex = MutexServiceControlFactory.getRemoteInstance();
        try {
            if (idList.size() > 0) {
                Map detailsRequest = iMutex.batchRequestObjIDForUpdate(idList);
                for (int i = 0; i < detailsRequest.size(); ++i) {
                    Boolean boolDetail = (Boolean)detailsRequest.get(idList.get(i));
                    if (boolDetail.booleanValue()) {
                        appliedList.add(idList.get(i));
                        continue;
                    }
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"421_Message"));
                    SysUtil.abort();
                }
            }
            ISettleFacade facade = SettleFacadeFactory.getRemoteInstance();
            facade.writeInnerAcct((IObjectCollection)this.coll, false);
        }
        finally {
            if (appliedList.size() > 0) {
                iMutex.batchReleaseObjIDForUpdate(appliedList);
            }
        }
        if (this.coll.size() > 0) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getSuccessString(e));
        }
        this.disposeUIWindow();
    }

    private void verify() throws EASBizException {
        FMClientVerifyHelper.verifyInput((CoreUIObject)this, (KDTable)this.tblMain, (String)PAYEEACCOUNT);
    }

    private SettlementBillCollection buildSettleColl(KDTable table) throws BOSException, EASBizException {
        SettlementBillInfo info = null;
        SettlementBillCollection coll = new SettlementBillCollection();
        IRow row = null;
        int count = table.getRowCount();
        for (int i = 0; i < count; ++i) {
            row = table.getRow(i);
            String id = row.getCell(ID).getValue().toString();
            info = this.getInfo(id);
            info.setType((SettBizTypeEnum)((Object)row.getCell(TYPE).getValue()));
            InnerAccountInfo innerAcctInfo = (InnerAccountInfo)row.getCell(PAYEEINNEACT).getValue();
            if (innerAcctInfo != null) {
                innerAcctInfo = InnerAccountFactory.getRemoteInstance().getInnerAccountInfo((IObjectPK)new ObjectUuidPK(innerAcctInfo.getId()), this.getInnerAcctSelector());
            }
            if (info.getType() == SettBizTypeEnum.PAYOUTSIDE) {
                if (innerAcctInfo == null) {
                    info.setPayerFullName(null);
                    info.setPayerBankAcct(null);
                    if (UpReckoningTypeEnum.SOURCEBILL == info.getUpReckoningType()) {
                        info.setFinPayerInAcct(null);
                    }
                    info.setPayerInnerAcct(null);
                    info.setInnerPayerAcct((AccountViewInfo)row.getCell(PAYEEACCOUNT).getValue());
                } else {
                    info.setPayeeInnerAcct(null);
                    info.setPayerInnerAcct(innerAcctInfo);
                    info.setApplyUnit(innerAcctInfo.getApplyUnit());
                    info.setPayerFullName(innerAcctInfo.getApplyUnit().getName());
                    info.setInnerPayerAcct(innerAcctInfo.getAcctView());
                    if (info != null && EmptyUtil.isEmpty((String)info.getSourceBillId()) && !innerAcctInfo.isIsReckoning()) {
                        info.setFinPayerInAcct(innerAcctInfo);
                    }
                    info.setInnerPayerAcct((AccountViewInfo)row.getCell(PAYEEACCOUNT).getValue());
                }
            } else if (info.getType() == SettBizTypeEnum.RECOUTSIDE) {
                if (innerAcctInfo == null) {
                    info.setPayeeFullName(null);
                    info.setPayeeBankAcct(null);
                    if (UpReckoningTypeEnum.SOURCEBILL == info.getUpReckoningType()) {
                        info.setFinPayeeInAcct(null);
                    }
                    info.setPayeeInnerAcct(null);
                    info.setInnerPayeeAcct((AccountViewInfo)row.getCell(PAYEEACCOUNT).getValue());
                } else {
                    info.setPayerInnerAcct(null);
                    info.setPayeeInnerAcct(innerAcctInfo);
                    info.setApplyUnit(innerAcctInfo.getApplyUnit());
                    info.setPayeeFullName(innerAcctInfo.getApplyUnit().getName());
                    info.setInnerPayeeAcct(innerAcctInfo.getAcctView());
                    if (info != null && EmptyUtil.isEmpty((String)info.getSourceBillId()) && !innerAcctInfo.isIsReckoning()) {
                        info.setFinPayeeInAcct(innerAcctInfo);
                    }
                    info.setInnerPayeeAcct((AccountViewInfo)row.getCell(PAYEEACCOUNT).getValue());
                }
            }
            info.setAmount((BigDecimal)row.getCell(AMOUNT).getValue());
            info.setDescription((String)row.getCell(DESCRIPTION).getValue());
            info.setUsage((String)row.getCell(USAGE).getValue());
            coll.add(info);
        }
        return coll;
    }

    private SettlementBillInfo getInfo(String id) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo(ID, (Object)id));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("payerInnerAcct.id"));
        evi.getSelector().add(new SelectorItemInfo(NUMBER));
        evi.getSelector().add(new SelectorItemInfo(ID));
        evi.getSelector().add(new SelectorItemInfo("company.id"));
        evi.getSelector().add(new SelectorItemInfo("mutilType"));
        evi.getSelector().add(new SelectorItemInfo("sourcebillid"));
        evi.getSelector().add(new SelectorItemInfo("applyUnit.id"));
        SettlementBillCollection coll = SettlementBillFactory.getRemoteInstance().getSettlementBillCollection(evi);
        if (coll != null && coll.size() > 0) {
            return coll.get(0);
        }
        return null;
    }

    private String getSuccessString(ActionEvent e) {
        Component component = (Component)e.getSource();
        if (component instanceof KDWorkButton) {
            String text = ((KDWorkButton)component).getText();
            if (EmptyUtil.isEmpty((String)text)) {
                text = ((KDWorkButton)component).getToolTipText();
            }
            return text + EASResource.getString((String)"com.kingdee.eas.fm.common.client.FMCommonClientResource", (String)"SUCCESS");
        }
        if (component instanceof KDMenuItem) {
            String text = ((KDMenuItem)component).getText();
            if (EmptyUtil.isEmpty((String)text)) {
                text = ((KDMenuItem)component).getToolTipText();
            }
            text = text.replaceAll("\\([a-zA-Z]\\)", "");
            return text + EASResource.getString((String)"com.kingdee.eas.fm.common.client.FMCommonClientResource", (String)"SUCCESS");
        }
        return EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"171_WriteCHBankAcctUI");
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.isPayee = (Boolean)this.getUIContext().get(IS_PAYEE);
        this.initUIProp();
        Set idSet = (Set)this.getUIContext().get(ID_SET);
        this.fillData(idSet);
        if (!this.isPayee) {
            this.tblMain.getHeadRow(0).getCell(PAYUNIT).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"473_SettlementBillControllerBean"));
            this.tblMain.getHeadRow(0).getCell(PAYACCOUNTBANK).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"474_SettlementBillControllerBean"));
            this.tblMain.getHeadRow(0).getCell(PAYBANK).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"475_SettlementBillControllerBean"));
            this.tblMain.getHeadRow(0).getCell(PAYEEINNEACT).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"560_WriteInnerBankAcctUI"));
            this.tblMain.getHeadRow(0).getCell(PAYEEACCOUNT).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fs.FSAutoGenerateResource", (String)"478_SettlementBillControllerBean"));
        }
    }

    private void initUIProp() throws EASBizException, BOSException {
        this.btnSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_submit"));
        this.tblMain.checkParsed();
        KDBizPromptBox editor = new KDBizPromptBox();
        editor.setEditable(true);
        editor.setDisplayFormat("$number$ $name$");
        editor.setEditFormat("$number$");
        editor.setCommitFormat("$simpleCode$;$number$;$name$;$acctNumber$");
        editor.setQueryInfo("com.kingdee.eas.fm.fs.F7InnerAccountQuery");
        KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor((IKDEditor)editor);
        this.tblMain.getColumn(PAYEEINNEACT).setEditor((ICellEditor)cellEditor);
        KDBizPromptBox accountvieweditor = new KDBizPromptBox();
        accountvieweditor.setEditable(true);
        accountvieweditor.setDisplayFormat("$number$ $name$");
        accountvieweditor.setEditFormat("$number$");
        accountvieweditor.setCommitFormat("$number$;$name$");
        accountvieweditor.setQueryInfo("com.kingdee.eas.basedata.master.account.app.AccountViewQuery");
        KDTDefaultCellEditor accountviewcellEditor = new KDTDefaultCellEditor((IKDEditor)accountvieweditor);
        this.tblMain.getColumn(PAYEEACCOUNT).setEditor((ICellEditor)accountviewcellEditor);
    }

    private String getResString(boolean isPayee, boolean isHaveM) {
        String resName = null;
        resName = isPayee ? "Rec" : "Pay";
        String resClassName = "com.kingdee.eas.fm.fs.SettlementBillUI";
        String resString = EASResource.getString((String)resClassName, (String)"WriteCHBankAcctAndSettle");
        if (isHaveM) {
            resString = resString + "(M)";
        }
        return MessageFormat.format(resString, EASResource.getString((String)resClassName, (String)resName));
    }

    private void fillData(Set idSet) throws BOSException, EASBizException {
        SettlementBillCollection coll = this.getColl(idSet);
        SettlementBillInfo info = null;
        String currencyID = null;
        InnerAccountInfo innerAcctInfo = null;
        AccountViewInfo accountview = null;
        IRow row = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            row = this.tblMain.addRow();
            info = coll.get(i);
            if (info.getCashier() != null) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fs.SettlementBillUI", (String)"HasSettled"));
                SysUtil.abort();
            }
            currencyID = info.getCurrency().getId().toString();
            FMClientHelper.setNumberFormat((IRow)row, (String)AMOUNT, (String)currencyID);
            innerAcctInfo = this.getInnerAcctInfo(info);
            accountview = this.getAcctViewInfo(info);
            row.getCell(ID).setValue((Object)info.getId().toString());
            row.getCell(TYPE).setValue((Object)info.getType());
            row.getCell(NUMBER).setValue((Object)info.getNumber());
            row.getCell(CURRENCY).setValue((Object)info.getCurrency());
            row.getCell(CURRENCY_NAME).setValue((Object)info.getCurrency().getName());
            row.getCell(AMOUNT).setValue((Object)info.getAmount());
            row.getCell(PAYEEINNEACT).setValue((Object)innerAcctInfo);
            row.getCell(PAYEEACCOUNT).setValue((Object)accountview);
            row.getCell(DESCRIPTION).setValue((Object)info.getDescription());
            row.getCell(USAGE).setValue((Object)info.getUsage());
            if (!this.isPayee) {
                row.getCell(PAYUNIT).setValue((Object)info.getPayeeFullName());
                row.getCell(PAYACCOUNTBANK).setValue((Object)info.getPayeeBankAcctNum());
                row.getCell(PAYBANK).setValue((Object)info.getPayeeBank());
                continue;
            }
            row.getCell(PAYUNIT).setValue((Object)info.getPayerFullName());
            row.getCell(PAYACCOUNTBANK).setValue((Object)info.getPayerBankAcctNum());
            row.getCell(PAYBANK).setValue((Object)info.getPayerBank());
        }
    }

    private InnerAccountInfo getInnerAcctInfo(SettlementBillInfo info) {
        InnerAccountInfo innerAcct = null;
        if (info.getType().equals((Object)SettBizTypeEnum.RECOUTSIDE)) {
            innerAcct = info.getPayeeInnerAcct();
        } else if (info.getType().equals((Object)SettBizTypeEnum.PAYOUTSIDE)) {
            innerAcct = info.getPayerInnerAcct();
        }
        return innerAcct;
    }

    private AccountViewInfo getAcctViewInfo(SettlementBillInfo info) {
        AccountViewInfo acctBankInfo = null;
        if (info.getType().equals((Object)SettBizTypeEnum.RECOUTSIDE)) {
            acctBankInfo = info.getInnerPayeeAcct();
        } else if (info.getType().equals((Object)SettBizTypeEnum.PAYOUTSIDE)) {
            acctBankInfo = info.getInnerPayerAcct();
        }
        return acctBankInfo;
    }

    private SettlementBillCollection getColl(Set idSet) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo(ID, (Object)idSet, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("*"));
        evi.getSelector().add(new SelectorItemInfo("currency.*"));
        evi.getSelector().add(new SelectorItemInfo("payeeBankAcct.*"));
        evi.getSelector().add(new SelectorItemInfo("payerBankAcct.*"));
        evi.getSelector().add(new SelectorItemInfo("payeeAcct.*"));
        evi.getSelector().add(new SelectorItemInfo("payerAcct.*"));
        evi.getSelector().add(new SelectorItemInfo("payeeInnerAcct.*"));
        evi.getSelector().add(new SelectorItemInfo("payerInnerAcct.*"));
        evi.getSelector().add(new SelectorItemInfo("innerPayeeAcct.*"));
        evi.getSelector().add(new SelectorItemInfo("innerPayerAcct.*"));
        SorterItemInfo sorter = new SorterItemInfo(NUMBER);
        SorterItemCollection sorterColl = new SorterItemCollection();
        sorter.setSortType(SortType.ASCEND);
        sorterColl.add(sorter);
        evi.setSorter(sorterColl);
        ISettlementBill iSettle = SettlementBillFactory.getRemoteInstance();
        return iSettle.getSettlementBillCollection(evi);
    }

    @Override
    protected void tblMain_editStarted(KDTEditEvent e) throws Exception {
    }

    @Override
    protected void tblMain_editStarting(KDTEditEvent e) throws Exception {
        CurrencyInfo currencyInfo;
        int colIndex = e.getColIndex();
        int rowIndex = e.getRowIndex();
        int bankAcctColIndex = this.tblMain.getColumn(PAYEEINNEACT).getColumnIndex();
        int acctColIndex = this.tblMain.getColumn(PAYEEACCOUNT).getColumnIndex();
        if (colIndex != acctColIndex && colIndex != bankAcctColIndex) {
            return;
        }
        KDBizPromptBox prmtBox = (KDBizPromptBox)((KDTDefaultCellEditor)this.tblMain.getColumn(colIndex).getEditor()).getComponent();
        String id = this.tblMain.getRow(rowIndex).getCell(ID).getValue().toString();
        SettlementBillInfo info = this.getInfo(id);
        if (colIndex == bankAcctColIndex) {
            currencyInfo = (CurrencyInfo)this.tblMain.getRow(rowIndex).getCell(CURRENCY).getValue();
            AccountViewInfo accountviewInfo = (AccountViewInfo)this.tblMain.getRow(rowIndex).getCell(PAYEEACCOUNT).getValue();
            SettBizTypeEnum bizType = (SettBizTypeEnum)((Object)this.tblMain.getRow(rowIndex).getCell(TYPE).getValue());
            boolean isPayer = false;
            if (bizType == SettBizTypeEnum.PAYOUTSIDE) {
                isPayer = true;
            }
            if (accountviewInfo != null) {
                this.setInnerAcctF7(prmtBox, accountviewInfo.getId().toString(), currencyInfo, isPayer, info);
            } else {
                this.setInnerAcctF7(prmtBox, null, currencyInfo, isPayer, info);
            }
        }
        if (colIndex == acctColIndex) {
            currencyInfo = (CurrencyInfo)this.tblMain.getRow(rowIndex).getCell(CURRENCY).getValue();
            this.setPayeeAcctEvi(prmtBox, currencyInfo);
        }
    }

    public void setInnerAcctF7(KDBizPromptBox f7InnerAcct, String accountId, CurrencyInfo currencyInfo, boolean isPayer, SettlementBillInfo info) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("account.*"));
        f7InnerAcct.setSelectorCollection(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("closed", (Object)Boolean.FALSE));
        filter.getFilterItems().add(new FilterItemInfo("isUsed", (Object)Boolean.TRUE));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)info.getCompany().getId().toString()));
        int tm102 = ContextHelperFactory.getRemoteInstance().getIntParam("TM102", (IObjectPK)new ObjectUuidPK(info.getCompany().getId()));
        switch (tm102) {
            case 0: {
                break;
            }
            case 1: {
                filter.getFilterItems().add(new FilterItemInfo("type.property", (Object)new Integer(1).toString()));
                break;
            }
            case 2: {
                filter.getFilterItems().add(new FilterItemInfo("type.property", (Object)new Integer(2).toString()));
                break;
            }
            case 3: {
                filter.getFilterItems().add(new FilterItemInfo("type.property", (Object)new Integer(3).toString()));
                break;
            }
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        f7InnerAcct.setEntityViewInfo(evi);
    }

    private void setPayeeAcctEvi(KDBizPromptBox prmtPayeeAccount, CurrencyInfo currencyInfo) throws EASBizException, BOSException {
        String currencyId = currencyInfo.getId().toString();
        String companyId = this.currentCompany.getId().toString();
        String cuId = this.currentCompany.getCU().getId().toString();
        prmtPayeeAccount.getQueryAgent().resetRuntimeEntityView();
        EntityViewInfo treeevi = CasRecPayHandler.getAccountViewEvi((String)cuId, (String)companyId, (String)currencyId, (boolean)false);
        AccountPromptBox opseelect = new AccountPromptBox((IUIObject)this, this.currentCompany, treeevi.getFilter(), false, true);
        prmtPayeeAccount.setSelector((KDPromptSelector)opseelect);
        EntityViewInfo evi = CasRecPayHandler.getAccountViewEvi((String)cuId, (String)companyId, (String)currencyId, (boolean)true);
        prmtPayeeAccount.setEntityViewInfo(evi);
    }

    @Override
    protected void tblMain_editStopped(KDTEditEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        if (colIndex != this.tblMain.getColumn(PAYEEINNEACT).getColumnIndex() && colIndex != this.tblMain.getColumn(PAYEEACCOUNT).getColumnIndex()) {
            return;
        }
        if (e.getOldValue() != null && e.getOldValue().equals(e.getValue())) {
            return;
        }
        InnerAccountInfo innerAcctInfo = (InnerAccountInfo)this.tblMain.getRow(rowIndex).getCell(PAYEEINNEACT).getValue();
        if (innerAcctInfo != null) {
            innerAcctInfo = InnerAccountFactory.getRemoteInstance().getInnerAccountInfo((IObjectPK)new ObjectUuidPK(innerAcctInfo.getId()), this.getInnerAcctSelector());
        }
        AccountViewInfo acctInfo = (AccountViewInfo)this.tblMain.getRow(rowIndex).getCell(PAYEEACCOUNT).getValue();
        if (colIndex == this.tblMain.getColumn(PAYEEINNEACT).getColumnIndex() && innerAcctInfo != null) {
            this.tblMain.getRow(rowIndex).getCell(PAYEEACCOUNT).setValue((Object)innerAcctInfo.getAcctView());
        }
        if (rowIndex == 0) {
            IRow row = null;
            AccountViewInfo accountview = (AccountViewInfo)this.tblMain.getRow(rowIndex).getCell(PAYEEACCOUNT).getValue();
            innerAcctInfo = (InnerAccountInfo)this.tblMain.getRow(rowIndex).getCell(PAYEEINNEACT).getValue();
            int count = this.tblMain.getRowCount();
            for (int i = rowIndex + 1; i < count; ++i) {
                row = this.tblMain.getRow(i);
                row.getCell(PAYEEINNEACT).setValue((Object)innerAcctInfo);
                row.getCell(PAYEEACCOUNT).setValue((Object)accountview);
            }
        }
    }

    private SelectorItemCollection getInnerAcctSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("applyUnit.id"));
        sic.add(new SelectorItemInfo("applyUnit.name"));
        sic.add(new SelectorItemInfo("applyUnit.number"));
        sic.add(new SelectorItemInfo("acctView.id"));
        sic.add(new SelectorItemInfo("acctView.name"));
        sic.add(new SelectorItemInfo("acctView.number"));
        sic.add(new SelectorItemInfo("deFaultAcctBank.id"));
        sic.add(new SelectorItemInfo("deFaultAcctBank.name"));
        sic.add(new SelectorItemInfo("deFaultAcctBank.number"));
        sic.add(new SelectorItemInfo("deFaultAcctBank.bankAccountNumber"));
        return sic;
    }
}

