/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fs.formula;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.DateHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fs.FSException;
import com.kingdee.eas.fm.fs.FSHelper;
import com.kingdee.eas.fm.fs.IInnerAccount;
import com.kingdee.eas.fm.fs.InAcctDataTypeEnum;
import com.kingdee.eas.fm.fs.InnerAccountFactory;
import com.kingdee.eas.fm.fs.app.InAcctControllerBean;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.ColInfo;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class InAcctCaculaterHelper {
    private static final String SUMMARY_QUERY = "com.kingdee.eas.fm.fs.SummaryLedgerQuery";
    private static final String SUB_QUERY = "com.kingdee.eas.fm.fs.SubsidiaryLedgerQuery";
    private static final String DEBIT_COUNTS = "debitCounts";
    private static final String CREDIT_COUNTS = "creditCounts";
    private static final String DEBIT_TOTAL = "debitTotal";
    private static final String CREDIT_TOTAL = "creditTotal";
    private static final String END_BALANCE = "endBalance";
    private static final String COMPANY_ID = "company.id";
    private static final String INNERACCT_ID = "innerAccountID";
    private static final String BankAcct_ID = "bankAcctID";
    private static final String INNERACCT_TYPE = "innerAccount.type";
    private static final String CAPITAL_TYPE = "capitalType";
    private static final String CURRENCY_ID = "currencyID";
    private static final String BIZEDATE = "bizDate";
    private static final String SUBSIDIARY_TYPE = "type";
    private static Logger logger = Logger.getLogger(InAcctControllerBean.class);

    public IRowSet getInAccBatch(Context serverCtx, List acctList, Object[] args) throws BOSException, EASBizException, SQLException {
        String companyNumber = args[0] == null ? "" : args[0].toString();
        String innerAcctNumber = this.transFormat(acctList);
        String currencyNumber = args[2] == null ? "" : args[2].toString();
        Date beginDay = null;
        Date endDay = null;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        DateFormat format = FMHelper.getNationalDateFormat((Context)serverCtx);
        if (args[3] != null) {
            if (args[3] instanceof Variant || args[3] instanceof String) {
                try {
                    beginDay = dateFormat.parse(dateFormat.format(format.parse(args[3].toString())));
                }
                catch (ParseException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            } else {
                beginDay = DateTimeUtils.truncateDate((Date)((Date)args[3]));
            }
            beginDay = DateTimeUtils.truncateDate((Date)beginDay);
        } else {
            beginDay = DateTimeUtils.truncateDate((Date)new Date());
        }
        if (args[4] != null) {
            if (args[4] instanceof Variant || args[4] instanceof String) {
                try {
                    endDay = dateFormat.parse(dateFormat.format(format.parse(args[4].toString())));
                }
                catch (ParseException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            } else {
                endDay = DateTimeUtils.truncateDate((Date)((Date)args[4]));
            }
            endDay = DateTimeUtils.truncateDate((Date)endDay);
        } else {
            endDay = DateTimeUtils.truncateDate((Date)new Date());
        }
        InAcctDataTypeEnum inAcctDataType = InAcctDataTypeEnum.getEnum(args[5].toString());
        if (inAcctDataType == null) {
            throw new FSException(FSException.INACCTTYPEISNULL);
        }
        Set companyIds = null;
        Set innerAcctIds = null;
        CurrencyInfo currency = null;
        if (companyNumber != null) {
            companyNumber = companyNumber.trim();
            companyIds = this.parseCompanyParam(serverCtx, companyNumber);
        }
        if (currencyNumber != null) {
            currencyNumber = currencyNumber.trim();
            currency = this.getCurrency(serverCtx, currencyNumber);
        }
        if (beginDay == null) {
            throw new FSException(FSException.STARTDAYISNULL);
        }
        beginDay = DateTimeUtils.truncateDate((Date)beginDay);
        if (inAcctDataType.equals((Object)InAcctDataTypeEnum.C) || inAcctDataType.equals((Object)InAcctDataTypeEnum.Y)) {
            if (endDay != null && endDay.before(beginDay)) {
                beginDay = endDay;
            }
            endDay = null;
        }
        if (endDay != null) {
            endDay = DateTimeUtils.truncateDate((Date)endDay);
        }
        if (beginDay != null && endDay != null && endDay.before(beginDay)) {
            throw new FSException(FSException.BEGINLARGEREND);
        }
        if (innerAcctNumber != null) {
            innerAcctNumber = innerAcctNumber.trim();
            innerAcctIds = this.parseInnerAcctParam(serverCtx, innerAcctNumber);
        }
        boolean isCHData = false;
        if (args.length >= 7 && args[6].toString().equalsIgnoreCase("true")) {
            isCHData = true;
        }
        IRowSet rs = null;
        if (inAcctDataType.getValue().equals("C")) {
            rs = this.getCValue(serverCtx, companyIds, innerAcctIds, null, currency, beginDay, endDay, isCHData);
        } else if (inAcctDataType.getValue().equals("Y")) {
            rs = this.getYValue(serverCtx, companyIds, innerAcctIds, null, currency, beginDay, endDay, isCHData);
        } else if (inAcctDataType.getValue().equals("MAY")) {
            rs = this.getMAYValue(serverCtx, companyIds, innerAcctIds, null, currency, beginDay, endDay, isCHData);
        } else if (inAcctDataType.getValue().equals("WAY")) {
            rs = this.getWAYValue(serverCtx, companyIds, innerAcctIds, null, currency, beginDay, endDay, isCHData);
        } else if (inAcctDataType.getValue().equals("JF")) {
            rs = this.getJFValue(serverCtx, companyIds, innerAcctIds, null, currency, beginDay, endDay, isCHData);
        } else if (inAcctDataType.getValue().equals("DF")) {
            rs = this.getDFValue(serverCtx, companyIds, innerAcctIds, null, currency, beginDay, endDay, isCHData);
        } else if (inAcctDataType.getValue().equals("QJF")) {
            rs = this.getQJFValue(serverCtx, companyIds, innerAcctIds, null, currency, beginDay, endDay, isCHData);
        } else if (inAcctDataType.getValue().equals("QDF")) {
            rs = this.getQDFValue(serverCtx, companyIds, innerAcctIds, null, currency, beginDay, endDay, isCHData);
        } else if (inAcctDataType.getValue().equals("K")) {
            rs = this.getKValue(serverCtx, companyIds, innerAcctIds, null, currency, beginDay, endDay, isCHData);
        }
        return rs;
    }

    private String transFormat(List acctList) {
        StringBuffer returnValue = new StringBuffer();
        int size = acctList.size();
        for (int i = 0; i < size; ++i) {
            returnValue.append(acctList.get(i).toString());
            if (i == size - 1) continue;
            returnValue.append(",");
        }
        return returnValue.toString().trim();
    }

    private Set parseCompanyParam(Context ctx, String param) throws BOSException {
        if (FMHelper.isEmpty((String)param)) {
            return new HashSet();
        }
        if (param.indexOf(",") > 0) {
            throw new BOSException(EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"67_InAcctCaculaterHelper"));
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)param));
        ICompanyOrgUnit iCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("*"));
        view.setFilter(filter);
        CompanyOrgUnitCollection co = iCompany.getCompanyOrgUnitCollection(view);
        int size = co.size();
        if (size == 0) {
            return null;
        }
        HashSet<BOSUuid> companySet = new HashSet<BOSUuid>();
        for (int i = 0; i < size; ++i) {
            CompanyOrgUnitInfo companyInfo = co.get(i);
            companySet.add(companyInfo.getId());
        }
        return companySet;
    }

    private CurrencyInfo getCurrency(Context ctx, String currencyNumber) throws BOSException, FSException {
        if (currencyNumber == null) {
            return null;
        }
        CurrencyCollection currencyCollection = null;
        ICurrency iCurrency = CurrencyFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)currencyNumber));
        view.setFilter(filter);
        currencyCollection = iCurrency.getCurrencyCollection(view);
        if (currencyCollection.size() != 1) {
            throw new FSException(FSException.CURRENCYNUMNOTEXSIST);
        }
        return currencyCollection.get(0);
    }

    private Set parseInnerAcctParam(Context ctx, String param) throws FSException, BOSException {
        FilterInfo filter = this.parseParamFilter(param);
        IInnerAccount iInner = InnerAccountFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        view.setFilter(filter);
        CoreBaseCollection co = iInner.getCollection(view);
        int size = co.size();
        if (size == 0) {
            return null;
        }
        HashSet<BOSUuid> innerSet = new HashSet<BOSUuid>();
        for (int i = 0; i < size; ++i) {
            innerSet.add(co.get(i).getId());
        }
        return innerSet;
    }

    private FilterInfo parseParamFilter(String param) throws FSException {
        HashSet<String> aloneSet = new HashSet<String>();
        HashSet<String> periodSet = new HashSet<String>();
        if (param == null) {
            return null;
        }
        if (param.indexOf(",") == -1 && param.indexOf(":") == -1) {
            aloneSet.add(param);
        } else {
            String[] subParam = param.split(",");
            for (int i = 0; i < subParam.length; ++i) {
                if (subParam[i].indexOf(":") == -1) {
                    aloneSet.add(subParam[i]);
                    continue;
                }
                periodSet.add(subParam[i]);
            }
        }
        FilterInfo filter = new FilterInfo();
        FilterItemInfo aloneFilter = null;
        if (aloneSet.size() != 0) {
            aloneFilter = new FilterItemInfo("number", aloneSet, CompareType.INCLUDE);
        }
        FilterItemCollection periodFilters = new FilterItemCollection();
        Iterator it = periodSet.iterator();
        while (it.hasNext()) {
            String[] periodString = ((String)it.next()).split(":");
            if (periodString.length != 2) {
                throw new FSException(FSException.EXPRESSWRONG);
            }
            if (periodString[1].compareTo(periodString[0]) < 0) {
                throw new FSException(FSException.NUMBERWRONG);
            }
            periodFilters.add(new FilterItemInfo("number", (Object)periodString[0], CompareType.GREATER_EQUALS));
            periodFilters.add(new FilterItemInfo("number", (Object)periodString[1], CompareType.LESS_EQUALS));
        }
        int maskCount = 0;
        StringBuffer maskString = new StringBuffer("");
        if (aloneFilter != null) {
            filter.getFilterItems().add(aloneFilter);
            maskString.append("#" + maskCount);
            ++maskCount;
        }
        if (periodFilters.size() != 0) {
            filter.getFilterItems().addObjectCollection((IObjectCollection)periodFilters);
            for (int i = 0; i < periodFilters.size(); i += 2) {
                if (!maskString.toString().equals("")) {
                    maskString.append(" or ");
                }
                maskString.append("(#" + maskCount + " and #" + (maskCount + 1) + ")");
                maskCount += 2;
            }
            filter.setMaskString(maskString.toString());
        }
        return filter;
    }

    private Date getBeforeDay(Date date) {
        if (date == null) {
            return null;
        }
        date = DateTimeUtils.truncateDate((Date)date);
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.set(5, cal.get(5) - 1);
        return cal.getTime();
    }

    private IRowSet getCValue(Context ctx, Set companyIds, Set innerAcctIds, Set bankAcctIds, CurrencyInfo currency, Date beginDay, Date endDay, boolean isCHData) throws EASBizException, BOSException {
        Iterator iter = innerAcctIds.iterator();
        String innerAcctId = iter.next().toString();
        BankInfo CHInfo = FSHelper.getClearingHouseInfoByInnerAcct(ctx, innerAcctId);
        CompanyOrgUnitInfo company = FSHelper.getCHCompanyInfo(ctx, innerAcctId);
        companyIds.add(company.getId());
        if (!CHInfo.isUsed()) {
            return null;
        }
        Date settleDate = DateTimeUtils.truncateDate((Date)CHInfo.getSettleDate());
        String sql = "";
        if (settleDate.after(beginDay)) {
            String subSql = this.getSubSQL(ctx, END_BALANCE, companyIds, innerAcctIds, bankAcctIds, currency, this.getBeforeDay(beginDay), null);
            sql = "select innerAccountNumber,sum(endBalance) result from (" + subSql + ") as subTable group by innerAccountNumber order by innerAccountNumber ";
        } else {
            String subSql = this.getSubSQL(ctx, END_BALANCE, companyIds, innerAcctIds, bankAcctIds, currency, this.getBeforeDay(settleDate), null);
            sql = "select innerAccountNumber, sum(endBalance ) result from ( " + subSql + " union all " + this.getSubsidiarySql(ctx, END_BALANCE, companyIds, innerAcctIds, bankAcctIds, currency, settleDate, DateHelper.getBeforeDay((Date)beginDay)) + ") as subTable group by innerAccountNumber order by innerAccountNumber ";
        }
        logger.error((Object)("InAcctCaculaterHelper's SQL \uff1a " + sql));
        return this.getResultBySQL(ctx, sql);
    }

    private String getSubsidiarySql(Context ctx, String field, Set companyIds, Set innerAcctIds, Set bankAcctIds, CurrencyInfo currency, Date beginDay, Date endDay) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("innerAccountNumber"));
        view.getSelector().add(new SelectorItemInfo(field));
        FilterInfo filter = new FilterInfo();
        if (companyIds != null && companyIds.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo(COMPANY_ID, (Object)companyIds, CompareType.INCLUDE));
        }
        if (innerAcctIds != null && innerAcctIds.size() > 0) {
            filter.getFilterItems().add(this.getInnerAccountFilterItem(innerAcctIds));
        }
        if (bankAcctIds != null && bankAcctIds.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo(BankAcct_ID, (Object)bankAcctIds, CompareType.INCLUDE));
        }
        if (currency != null) {
            filter.getFilterItems().add(new FilterItemInfo("currency", (Object)currency.getId().toString()));
        }
        if (beginDay != null && endDay != null) {
            filter.getFilterItems().add(new FilterItemInfo("date", (Object)beginDay, CompareType.GREATER_EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("date", (Object)endDay, CompareType.LESS_EQUALS));
        }
        view.setFilter(filter);
        String subsidiarySql = null;
        MetaDataPK mainQueryPK = new MetaDataPK(SUB_QUERY);
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)mainQueryPK);
        exec.setObjectView(view);
        subsidiarySql = exec.getSQL();
        return subsidiarySql;
    }

    private IRowSet getYValue(Context ctx, Set companyIds, Set innerAcctIds, Set bankAcctIds, CurrencyInfo currency, Date beginDay, Date endDay, boolean isCHData) throws EASBizException, BOSException {
        Iterator iter = innerAcctIds.iterator();
        String innerAcctId = iter.next().toString();
        BankInfo CHInfo = FSHelper.getClearingHouseInfoByInnerAcct(ctx, innerAcctId);
        CompanyOrgUnitInfo company = FSHelper.getCHCompanyInfo(ctx, innerAcctId);
        companyIds.add(company.getId());
        Date settleDate = DateTimeUtils.truncateDate((Date)CHInfo.getSettleDate());
        String sql = "";
        String subSql = "";
        if (beginDay.compareTo(settleDate) < 0) {
            subSql = this.getSubSQL(ctx, END_BALANCE, companyIds, innerAcctIds, bankAcctIds, currency, beginDay, null);
            sql = "select innerAccountNumber,sum(endBalance) result from (" + subSql + ") as subTable group by innerAccountNumber order by innerAccountNumber ";
        } else {
            subSql = this.getSubSQL(ctx, END_BALANCE, companyIds, innerAcctIds, bankAcctIds, currency, DateHelper.getBeforeDay((Date)settleDate), null);
            sql = "select innerAccountNumber, sum(endBalance ) result from ( " + subSql + " union all " + this.getSubsidiarySql(ctx, END_BALANCE, companyIds, innerAcctIds, bankAcctIds, currency, settleDate, beginDay) + ") as subTable group by innerAccountNumber order by innerAccountNumber ";
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)sql);
        }
        return this.getResultBySQL(ctx, sql);
    }

    private IRowSet getMAYValue(Context ctx, Set companyIds, Set innerAcctIds, Set bankAcctIds, CurrencyInfo currency, Date beginDay, Date endDay, boolean isCHData) throws EASBizException, BOSException, SQLException {
        if (endDay == null) {
            throw new FSException(FSException.ENDDAYISNULL);
        }
        String companyId = companyIds.iterator().next().toString();
        BankInfo CHInfo = FSHelper.getClearingHouseInfo(ctx, companyId);
        if (CHInfo == null) {
            Iterator iter = innerAcctIds.iterator();
            CHInfo = FSHelper.getClearingHouseInfoByInnerAcct(ctx, iter.next().toString());
        }
        Date openDate = DateTimeUtils.truncateDate((Date)CHInfo.getOpenDate());
        Date settleDate = DateTimeUtils.truncateDate((Date)CHInfo.getSettleDate());
        if (beginDay.before(openDate)) {
            beginDay = this.getBeforeDay(openDate);
        }
        if (beginDay.after(this.getBeforeDay(settleDate))) {
            return this.getYValue(ctx, companyIds, innerAcctIds, bankAcctIds, currency, this.getBeforeDay(settleDate), null, isCHData);
        }
        if (endDay.before(openDate)) {
            return null;
        }
        String subSql = this.getSubSQL(ctx, END_BALANCE, companyIds, innerAcctIds, bankAcctIds, currency, beginDay, endDay);
        String sql = "select innerAccountNumber,sum(endBalance) result from (" + subSql + ") as subTable  group by innerAccountNumber order by innerAccountNumber";
        IRowSet sumRs = this.getResultBySQL(ctx, sql);
        long subDay = (endDay.getTime() - beginDay.getTime()) / 1000L / 60L / 60L / 24L + 1L;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)sql);
        }
        while (sumRs.next()) {
            BigDecimal value = sumRs.getBigDecimal(2);
            BigDecimal rstValue = value.divide(new BigDecimal("" + subDay), 6, 4);
            sumRs.updateBigDecimal(2, rstValue);
        }
        sumRs.beforeFirst();
        return sumRs;
    }

    private IRowSet getWAYValue(Context ctx, Set companyIds, Set innerAcctIds, Set bankAcctIds, CurrencyInfo currency, Date beginDay, Date endDay, boolean isCHData) throws EASBizException, BOSException, SQLException {
        if (endDay == null) {
            throw new FSException(FSException.ENDDAYISNULL);
        }
        Iterator iter = innerAcctIds.iterator();
        String innerAcctId = iter.next().toString();
        BankInfo CHInfo = FSHelper.getClearingHouseInfoByInnerAcct(ctx, innerAcctId);
        CompanyOrgUnitInfo company = FSHelper.getCHCompanyInfo(ctx, innerAcctId);
        companyIds.add(company.getId());
        Date openDate = DateTimeUtils.truncateDate((Date)CHInfo.getOpenDate());
        if (beginDay.before(openDate)) {
            beginDay = this.getBeforeDay(openDate);
        }
        if (isCHData) {
            return this.getCHWAYValue(ctx, companyIds, innerAcctIds, bankAcctIds, currency, beginDay, endDay);
        }
        return this.getUnCHWAYValue(ctx, companyIds, innerAcctIds, bankAcctIds, currency, beginDay, endDay);
    }

    private IRowSet getUnCHWAYValue(Context ctx, Set companyIds, Set innerAcctIds, Set bankAcctIds, CurrencyInfo currency, Date beginDay, Date endDay) throws EASBizException, BOSException, SQLException {
        Date tmpDate = beginDay;
        IRowSet sumRst = null;
        BigDecimal balance = new BigDecimal("0");
        while (tmpDate.before(DateHelper.getAfterDay((Date)endDay))) {
            sumRst = this.getYValue(ctx, companyIds, innerAcctIds, bankAcctIds, currency, tmpDate, endDay, false);
            sumRst.beforeFirst();
            while (sumRst.next()) {
                BigDecimal value = sumRst.getBigDecimal(2);
                balance = balance.add(value);
            }
            tmpDate = DateHelper.getAfterDay((Date)tmpDate);
        }
        long subDay = (endDay.getTime() - beginDay.getTime()) / 1000L / 60L / 60L / 24L + 1L;
        if (sumRst != null) {
            sumRst.beforeFirst();
            while (sumRst.next()) {
                BigDecimal rstValue = balance.divide(new BigDecimal("" + subDay), 6, 4);
                sumRst.updateBigDecimal(2, rstValue);
            }
            sumRst.beforeFirst();
        }
        return sumRst;
    }

    private IRowSet getCHWAYValue(Context ctx, Set companyIds, Set innerAcctIds, Set bankAcctIds, CurrencyInfo currency, Date beginDay, Date endDay) throws SQLDataException, BOSException, EASBizException, SQLException {
        Iterator iter = innerAcctIds.iterator();
        BankInfo CHInfo = FSHelper.getClearingHouseInfoByInnerAcct(ctx, iter.next().toString());
        Date openDate = DateTimeUtils.truncateDate((Date)CHInfo.getOpenDate());
        Date settleDate = DateTimeUtils.truncateDate((Date)CHInfo.getSettleDate());
        if (beginDay.after(this.getBeforeDay(settleDate))) {
            return this.getYValue(ctx, companyIds, innerAcctIds, bankAcctIds, currency, this.getBeforeDay(settleDate), null, true);
        }
        if (endDay.before(openDate)) {
            return null;
        }
        String subSql = null;
        subSql = endDay.before(this.getBeforeDay(settleDate)) ? this.getSubSQL(ctx, END_BALANCE, companyIds, innerAcctIds, bankAcctIds, currency, beginDay, endDay) : this.getSubSQL(ctx, END_BALANCE, companyIds, innerAcctIds, bankAcctIds, currency, beginDay, this.getBeforeDay(settleDate));
        if (endDay.before(this.getBeforeDay(settleDate))) {
            String sql = "select innerAccountNumber,sum(endBalance) result from (" + subSql + ") as subTable  group by innerAccountNumber order by innerAccountNumber";
            if (logger.isDebugEnabled()) {
                logger.debug((Object)sql);
            }
            IRowSet sumRst = this.getResultBySQL(ctx, sql);
            long subDay = (endDay.getTime() - beginDay.getTime()) / 1000L / 60L / 60L / 24L + 1L;
            sumRst.beforeFirst();
            while (sumRst.next()) {
                BigDecimal value = sumRst.getBigDecimal(2);
                BigDecimal rstValue = value.divide(new BigDecimal("" + subDay), 6, 4);
                sumRst.updateBigDecimal(2, rstValue);
            }
            sumRst.beforeFirst();
            return sumRst;
        }
        String sql = "select innerAccountNumber,sum(endBalance) result from (" + subSql + ") as subTable  group by innerAccountNumber order by innerAccountNumber";
        if (logger.isDebugEnabled()) {
            logger.debug((Object)sql);
        }
        IRowSet sumRst = this.getResultBySQL(ctx, sql);
        IRowSet sumAddRst = this.getCValue(ctx, companyIds, innerAcctIds, bankAcctIds, currency, settleDate, null, true);
        long subDay = (endDay.getTime() - beginDay.getTime()) / 1000L / 60L / 60L / 24L + 1L;
        long subDay2 = (endDay.getTime() - settleDate.getTime()) / 1000L / 60L / 60L / 24L + 1L;
        while (sumRst.next()) {
            String fnumber = sumRst.getString(1);
            BigDecimal fvalue = sumRst.getBigDecimal(2);
            while (sumAddRst.next()) {
                String fnumberAdd = sumAddRst.getString(1);
                BigDecimal fvalueAdd = sumAddRst.getBigDecimal(2);
                if (!fnumber.equalsIgnoreCase(fnumberAdd)) continue;
                fvalue = fvalue.add(fvalueAdd.multiply(new BigDecimal("" + subDay2)));
                BigDecimal result = fvalue.divide(new BigDecimal("" + subDay), 6, 4);
                sumRst.updateBigDecimal(2, result);
            }
            sumAddRst.beforeFirst();
        }
        sumRst.beforeFirst();
        return sumRst;
    }

    private IRowSet getJFValue(Context ctx, Set companyIds, Set innerAcctIds, Set bankAcctIds, CurrencyInfo currency, Date beginDay, Date endDay, boolean isCHData) throws BOSException, EASBizException {
        if (endDay == null) {
            throw new FSException(FSException.ENDDAYISNULL);
        }
        Iterator iter = innerAcctIds.iterator();
        String innerAcctId = iter.next().toString();
        BankInfo CHInfo = FSHelper.getClearingHouseInfoByInnerAcct(ctx, innerAcctId);
        CompanyOrgUnitInfo company = FSHelper.getCHCompanyInfo(ctx, innerAcctId);
        companyIds.add(company.getId());
        Date settleDate = DateTimeUtils.truncateDate((Date)CHInfo.getSettleDate());
        String subSql = "";
        String sql = "";
        if (isCHData) {
            subSql = this.getSubSQL(ctx, DEBIT_TOTAL, companyIds, innerAcctIds, bankAcctIds, currency, beginDay, endDay);
            sql = "select innerAccountNumber,sum(debitTotal) result from (" + subSql + ") as subTable  group by innerAccountNumber order by innerAccountNumber";
        } else if (endDay.compareTo(settleDate) < 0) {
            subSql = this.getSubSQL(ctx, DEBIT_TOTAL, companyIds, innerAcctIds, bankAcctIds, currency, beginDay, endDay);
            sql = "select innerAccountNumber,sum(debitTotal) result from (" + subSql + ") as subTable  group by innerAccountNumber order by innerAccountNumber";
        } else if (beginDay.compareTo(settleDate) < 0 && endDay.compareTo(settleDate) >= 0) {
            subSql = this.getSubSQL(ctx, DEBIT_TOTAL, companyIds, innerAcctIds, bankAcctIds, currency, beginDay, endDay);
            sql = "select innerAccountNumber, sum(debitTotal ) result from ( " + subSql + " union all " + this.getSubsidiarySql(ctx, "debitAmount", companyIds, innerAcctIds, bankAcctIds, currency, settleDate, endDay) + ") as subTable group by innerAccountNumber order by innerAccountNumber ";
        } else if (beginDay.compareTo(settleDate) >= 0) {
            subSql = this.getSubsidiarySql(ctx, "debitAmount", companyIds, innerAcctIds, bankAcctIds, currency, beginDay, endDay);
            sql = "select innerAccountNumber,sum(debitAmount) result from (" + subSql + ") as subTable  group by innerAccountNumber order by innerAccountNumber";
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)sql);
        }
        return this.getResultBySQL(ctx, sql);
    }

    private IRowSet getDFValue(Context ctx, Set companyIds, Set innerAcctIds, Set bankAcctIds, CurrencyInfo currency, Date beginDay, Date endDay, boolean isCHData) throws BOSException, EASBizException {
        if (endDay == null) {
            throw new FSException(FSException.ENDDAYISNULL);
        }
        Iterator iter = innerAcctIds.iterator();
        String innerAcctId = iter.next().toString();
        BankInfo CHInfo = FSHelper.getClearingHouseInfoByInnerAcct(ctx, innerAcctId);
        CompanyOrgUnitInfo company = FSHelper.getCHCompanyInfo(ctx, innerAcctId);
        companyIds.add(company.getId());
        Date settleDate = DateTimeUtils.truncateDate((Date)CHInfo.getSettleDate());
        String subSql = "";
        String sql = "";
        if (isCHData) {
            subSql = this.getSubSQL(ctx, CREDIT_TOTAL, companyIds, innerAcctIds, bankAcctIds, currency, beginDay, endDay);
            sql = "select innerAccountNumber,sum(creditTotal) result from (" + subSql + ") as subTable  group by innerAccountNumber order by innerAccountNumber";
        } else if (endDay.compareTo(settleDate) < 0) {
            subSql = this.getSubSQL(ctx, CREDIT_TOTAL, companyIds, innerAcctIds, bankAcctIds, currency, beginDay, endDay);
            sql = "select innerAccountNumber,sum(creditTotal) result from (" + subSql + ") as subTable  group by innerAccountNumber order by innerAccountNumber";
        } else if (beginDay.compareTo(settleDate) < 0 && endDay.compareTo(settleDate) >= 0) {
            subSql = this.getSubSQL(ctx, CREDIT_TOTAL, companyIds, innerAcctIds, bankAcctIds, currency, beginDay, endDay);
            sql = "select innerAccountNumber, sum(creditTotal ) result from ( " + subSql + " union all " + this.getSubsidiarySql(ctx, "creditAmount", companyIds, innerAcctIds, bankAcctIds, currency, settleDate, endDay) + ") as subTable group by innerAccountNumber order by innerAccountNumber ";
        } else if (beginDay.compareTo(settleDate) >= 0) {
            subSql = this.getSubsidiarySql(ctx, "creditAmount", companyIds, innerAcctIds, bankAcctIds, currency, beginDay, endDay);
            sql = "select innerAccountNumber,sum(creditAmount) result from (" + subSql + ") as subTable  group by innerAccountNumber order by innerAccountNumber";
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)sql);
        }
        return this.getResultBySQL(ctx, sql);
    }

    private IRowSet getQJFValue(Context ctx, Set companyIds, Set innerAcctIds, Set bankAcctIds, CurrencyInfo currency, Date beginDay, Date endDay, boolean isCHData) throws BOSException, EASBizException {
        if (endDay == null) {
            throw new FSException(FSException.ENDDAYISNULL);
        }
        Iterator iter = innerAcctIds.iterator();
        String innerAcctId = iter.next().toString();
        CompanyOrgUnitInfo company = FSHelper.getCHCompanyInfo(ctx, innerAcctId);
        companyIds.add(company.getId());
        String sql = "";
        if (isCHData) {
            String subSql = this.getSubSQL(ctx, DEBIT_COUNTS, companyIds, innerAcctIds, bankAcctIds, currency, beginDay, endDay);
            sql = "select innerAccountNumber,sum(debitCounts) result from (" + subSql + ") as subTable group by innerAccountNumber order by innerAccountNumber";
        } else {
            String subSql = this.getSubsidiarySql(ctx, INNERACCT_ID, companyIds, innerAcctIds, bankAcctIds, currency, beginDay, endDay);
            sql = "select innerAccountNumber,count(innerAccountID) result from (" + subSql + " and FDebitAmount<>0 ) as subTable  group by innerAccountNumber order by innerAccountNumber";
        }
        return this.getResultBySQL(ctx, sql);
    }

    private IRowSet getQDFValue(Context ctx, Set companyIds, Set innerAcctIds, Set bankAcctIds, CurrencyInfo currency, Date beginDay, Date endDay, boolean isCHData) throws BOSException, EASBizException {
        if (endDay == null) {
            throw new FSException(FSException.ENDDAYISNULL);
        }
        Iterator iter = innerAcctIds.iterator();
        String innerAcctId = iter.next().toString();
        CompanyOrgUnitInfo company = FSHelper.getCHCompanyInfo(ctx, innerAcctId);
        companyIds.add(company.getId());
        String sql = "";
        if (isCHData) {
            String subSql = this.getSubSQL(ctx, CREDIT_COUNTS, companyIds, innerAcctIds, bankAcctIds, currency, beginDay, endDay);
            sql = "select innerAccountNumber,sum(creditCounts) result from (" + subSql + ") as subTable group by innerAccountNumber order by innerAccountNumber";
        } else {
            String subSql = this.getSubsidiarySql(ctx, INNERACCT_ID, companyIds, innerAcctIds, bankAcctIds, currency, beginDay, endDay);
            sql = "select innerAccountNumber,count(innerAccountID) result from (" + subSql + " and FCreditAmount<>0 ) as subTable  group by innerAccountNumber order by innerAccountNumber";
        }
        return this.getResultBySQL(ctx, sql);
    }

    private IRowSet getKValue(Context ctx, Set companyIds, Set innerAcctIds, Set bankAcctIds, CurrencyInfo currency, Date beginDay, Date endDay, boolean isCHData) throws EASBizException, BOSException, SQLException {
        String companyId = companyIds.iterator().next().toString();
        BankInfo CHInfo = FSHelper.getClearingHouseInfo(ctx, companyId);
        if (CHInfo == null) {
            Iterator iter = innerAcctIds.iterator();
            CHInfo = FSHelper.getClearingHouseInfoByInnerAcct(ctx, iter.next().toString());
        }
        Date unSettledDate = CHInfo.getSettleDate();
        unSettledDate = DateTimeUtils.truncateDate((Date)unSettledDate);
        IRowSet resultSubL = null;
        IRowSet resultReturn = null;
        if (!beginDay.before(unSettledDate)) {
            String subsidiarySQL = this.getSubsidiarySQL(ctx, "amountOffset", companyIds, innerAcctIds, null, currency, unSettledDate, beginDay);
            String subsidiarySumSQL = "select innerAccountNumber,sum(amountOffset) result from (" + subsidiarySQL + ") as subTable group by innerAccountNumber order by innerAccountNumber ";
            resultSubL = this.getResultBySQL(ctx, subsidiarySumSQL);
            beginDay = this.getBeforeDay(unSettledDate);
        }
        String subSql = this.getSubSQL(ctx, END_BALANCE, companyIds, innerAcctIds, bankAcctIds, currency, beginDay, null);
        String sql = "select innerAccountNumber,sum(endBalance) result from (" + subSql + ") as subTable group by innerAccountNumber order by innerAccountNumber ";
        if (logger.isDebugEnabled()) {
            logger.debug((Object)sql);
        }
        resultReturn = this.getResultBySQL(ctx, sql);
        if (resultSubL != null) {
            while (resultSubL.next()) {
                String fnumberSubL = resultSubL.getString(1);
                BigDecimal fvalueSubL = resultSubL.getBigDecimal(2);
                while (resultReturn.next()) {
                    String fnumberReturn = resultReturn.getString(1);
                    BigDecimal fvalueReturn = resultReturn.getBigDecimal(2);
                    if (!fnumberReturn.equalsIgnoreCase(fnumberSubL)) continue;
                    BigDecimal result = fvalueReturn.add(fvalueSubL);
                    resultReturn.updateBigDecimal(2, result);
                }
            }
        }
        resultReturn.beforeFirst();
        return resultReturn;
    }

    private IRowSet getResultBySQL(Context ctx, String sql) throws SQLDataException, BOSException {
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        DynamicRowSet drs = null;
        try {
            int i;
            ResultSetMetaData rsmd = rs.getMetaData();
            int colCount = rsmd.getColumnCount();
            drs = new DynamicRowSet(colCount);
            String[] columnNameArray = new String[colCount];
            for (i = 0; i < colCount; ++i) {
                String columnName = rsmd.getColumnName(i + 1);
                int columnClz = rsmd.getColumnType(i + 1);
                String columnlbl = rsmd.getColumnLabel(i + 1);
                columnNameArray[i] = columnName;
                ColInfo ciId = new ColInfo(columnName, columnlbl, columnClz, null);
                drs.setColInfo(i + 1, ciId);
            }
            while (rs.next()) {
                drs.moveToInsertRow();
                for (i = 0; i < colCount; ++i) {
                    drs.updateObject(columnNameArray[i], rs.getObject(columnNameArray[i]));
                }
                drs.insertRow();
            }
            drs.beforeFirst();
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return drs;
    }

    private String getSubSQL(Context ctx, String entry, Set companyIds, Set innerAcctIds, Set bankAcctIds, CurrencyInfo currency, Date beginDay, Date endDay) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("innerAccountNumber"));
        view.getSelector().add(new SelectorItemInfo(entry));
        FilterInfo filter = this.getFilter(companyIds, innerAcctIds, bankAcctIds, currency, beginDay, endDay);
        view.setFilter(filter);
        String subSql = null;
        MetaDataPK mainQueryPK = new MetaDataPK(SUMMARY_QUERY);
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)mainQueryPK);
        exec.setObjectView(view);
        subSql = exec.getSQL();
        return subSql;
    }

    private String getSubsidiarySQL(Context ctx, String selector, Set companyIds, Set innerAcctIds, Set bankAcctIds, CurrencyInfo currency, Date beginDay, Date endDay) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("innerAccountNumber"));
        SelectorItemInfo selectorItemInfo = new SelectorItemInfo(selector);
        view.getSelector().add(selectorItemInfo);
        FilterInfo filter = this.getSubsidiaryFilter(companyIds, innerAcctIds, bankAcctIds, currency, beginDay, endDay);
        view.setFilter(filter);
        String subSql = null;
        MetaDataPK mainQueryPK = new MetaDataPK(SUB_QUERY);
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)mainQueryPK);
        exec.setObjectView(view);
        subSql = exec.getSQL();
        return subSql;
    }

    private FilterInfo getSubsidiaryFilter(Set companyIds, Set innerAcctIds, Set bankAcctIds, CurrencyInfo currency, Date beginDay, Date endDay) {
        FilterItemInfo filterItem;
        FilterInfo filter = new FilterInfo();
        if (companyIds != null) {
            filterItem = new FilterItemInfo(COMPANY_ID, (Object)companyIds, CompareType.INCLUDE);
            filter.getFilterItems().add(filterItem);
        }
        if (innerAcctIds != null) {
            filter.getFilterItems().add(this.getInnerAccountFilterItem(innerAcctIds));
        }
        if (bankAcctIds != null) {
            filter.getFilterItems().add(this.getBankAcctFilterItem(bankAcctIds));
        }
        if (currency != null) {
            filterItem = new FilterItemInfo("currency", (Object)currency.getId().toString());
            filter.getFilterItems().add(filterItem);
        }
        if (beginDay != null) {
            beginDay = DateTimeUtils.truncateDate((Date)beginDay);
            filterItem = new FilterItemInfo("date", (Object)beginDay, CompareType.GREATER_EQUALS);
            filter.getFilterItems().add(filterItem);
        }
        return filter;
    }

    private FilterInfo getFilter(Set companyIds, Set innerAcctIds, Set bankAcctIds, CurrencyInfo currency, Date beginDay, Date endDay) {
        FilterInfo filter = new FilterInfo();
        if (companyIds != null && companyIds.size() > 0) {
            filter.getFilterItems().add(this.getApplyUnitFilterItem(companyIds));
        }
        if (innerAcctIds != null && innerAcctIds.size() > 0) {
            filter.getFilterItems().add(this.getInnerAccountFilterItem(innerAcctIds));
        }
        if (bankAcctIds != null && bankAcctIds.size() > 0) {
            filter.getFilterItems().add(this.getBankAcctFilterItem(bankAcctIds));
        }
        if (currency != null) {
            filter.getFilterItems().add(this.getCurrencyFilterItem(currency));
        }
        if (beginDay != null) {
            if (endDay != null) {
                filter.getFilterItems().add(this.getBeginDateFilterItem(beginDay, CompareType.GREATER_EQUALS));
                filter.getFilterItems().add(this.getEndDateFilterItem(endDay));
            } else {
                filter.getFilterItems().add(this.getBeginDateFilterItem(beginDay, CompareType.EQUALS));
            }
        }
        return filter;
    }

    private FilterItemInfo getApplyUnitFilterItem(Set companyIds) {
        FilterItemInfo filter = new FilterItemInfo(COMPANY_ID, (Object)companyIds, CompareType.INCLUDE);
        return filter;
    }

    private FilterItemInfo getInnerAccountFilterItem(Set innerAcctIds) {
        FilterItemInfo filter = new FilterItemInfo(INNERACCT_ID, (Object)innerAcctIds, CompareType.INCLUDE);
        return filter;
    }

    private FilterItemInfo getBankAcctFilterItem(Set bankAcctIds) {
        FilterItemInfo filter = new FilterItemInfo(BankAcct_ID, (Object)bankAcctIds, CompareType.INCLUDE);
        return filter;
    }

    private FilterItemInfo getBeginDateFilterItem(Date beginDay, CompareType type) {
        beginDay = DateTimeUtils.truncateDate((Date)beginDay);
        FilterItemInfo filterItem = new FilterItemInfo(BIZEDATE, (Object)beginDay, type);
        return filterItem;
    }

    private FilterItemInfo getEndDateFilterItem(Date endDay) {
        FilterItemInfo filterItem = new FilterItemInfo(BIZEDATE, (Object)endDay, CompareType.LESS_EQUALS);
        return filterItem;
    }

    private FilterItemInfo getCurrencyFilterItem(CurrencyInfo currency) {
        FilterItemInfo filterItem = new FilterItemInfo(CURRENCY_ID, (Object)currency.getId().toString());
        return filterItem;
    }
}

