/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.gnt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.ui.tree.TreeUI;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.print.IPrintActionListener;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.adaptor.KdfToR1DataAdaptor;
import com.kingdee.bos.ctrl.report.forapp.kdnote.integrate.PreviewArea;
import com.kingdee.bos.ctrl.report.forapp.kdnote.integrate.TemplatesTree;
import com.kingdee.bos.ctrl.reportone.r1.print.data.AbstractPrintDataProvider;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.common.EJBAccessFactory;
import com.kingdee.eas.fm.common.FilterParam;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.common.client.MutexUtils;
import com.kingdee.eas.fm.gnt.GnoteFacadeFactory;
import com.kingdee.eas.fm.gnt.GnoteFilterParam;
import com.kingdee.eas.fm.gnt.IGnoteFacade;
import com.kingdee.eas.fm.gnt.client.AbstractGnoteListUI;
import com.kingdee.eas.fm.gnt.client.AppopriationEditUI;
import com.kingdee.eas.fm.gnt.client.GnoteChequeEditUI;
import com.kingdee.eas.fm.gnt.client.GnoteFilterUI;
import com.kingdee.eas.fm.gnt.client.GnoteHandler;
import com.kingdee.eas.fm.gnt.client.GnoteTDPrintDelegate;
import com.kingdee.eas.fm.gnt.common.NoteHelper;
import com.kingdee.eas.fm.nt.ChequeFactory;
import com.kingdee.eas.fm.nt.ChequeInfo;
import com.kingdee.eas.fm.nt.NTTypeGroupEnum;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.IllegalConversionException;
import com.kingdee.util.InvalidDateException;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class GnoteListUI
extends AbstractGnoteListUI {
    private static final Logger logger = CoreUIObject.getLogger(GnoteListUI.class);
    public static String resourcePath = "com.kingdee.eas.fm.gnt.GntResource";
    private GnoteFilterUI filterUI = null;
    private GnoteHandler handler;
    private GnoteFilterParam filterParam = null;
    FilterInfo filterTreeOutLine = null;
    TemplatesTree _templateTree = new TemplatesTree();
    PreviewArea _previewArea = new PreviewArea();

    public GnoteListUI() throws Exception {
        this.handler = new GnoteHandler(this.tblMain);
        this._templateTree.setContext(KDNoteHelper.getContext());
        this._templateTree.setNoteType("/FM/GOV");
        this._previewArea.bindTemplatesTree(this._templateTree);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.getDataRequestManager().setDataRequestMode(0);
        this.treeOutline.setModel(this.getTree());
        this.treeOutline.setCollapsePathDisabled(false);
        this.treeOutline.setRootVisible(false);
        this.treeOutline.setShowsRootHandles(true);
        FMClientHelper.goLeaf((KDTree)this.treeOutline);
        this.tblMain.getSelectManager().setSelectMode(10);
        this.actionAttachment.setVisible(false);
        this.actionAuditResult.setVisible(false);
        this.cbDirectView.setSelected(true);
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.kDScrollPane1.getViewport().add(this._templateTree.getCtrl());
        this.kDScrollPane2.getViewport().add(this._previewArea.getCtrl());
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnTDPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.btnReturn.setIcon(EASResource.getIcon((String)"imgTbtn_untread"));
        this.btnVC.setIcon(EASResource.getIcon((String)"imgTbtn_cancelverification"));
        this.btnAntiVC.setIcon(EASResource.getIcon((String)"imgTbtn_fcancelverification"));
        this.bntAddNew.setIcon(EASResource.getIcon((String)"imgTbtn_new"));
        this.menuItemVC.setIcon(EASResource.getIcon((String)"imgTbtn_cancelverification"));
        this.menuItemDelVC.setIcon(EASResource.getIcon((String)"imgTbtn_fcancelverification"));
        this.menuItemReturn.setIcon(EASResource.getIcon((String)"imgTbtn_untread"));
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new GnoteFilterUI();
        }
        return this.filterUI;
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
    }

    @Override
    protected void treeOutline_valueChanged(TreeSelectionEvent e) throws Exception {
        super.treeOutline_valueChanged(e);
        if (e == null) {
            return;
        }
        TreePath path = e.getNewLeadSelectionPath();
        if (path == null) {
            return;
        }
        IGnoteFacade noteFacade = GnoteFacadeFactory.getRemoteInstance();
        this.filterTreeOutLine = new FilterInfo();
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)path.getLastPathComponent();
        Object obj = node.getUserObject();
        NTTypeGroupEnum noteGroup = null;
        if (path.getPathCount() == 3) {
            noteGroup = (NTTypeGroupEnum)((DefaultKingdeeTreeNode)node.getParent()).getUserObject();
            CoreBaseInfo info = (CoreBaseInfo)obj;
            Set noteTypeIdSet = NoteHelper.getNTTypeIdSet(noteGroup);
            HashSet validNumbers = noteFacade.getValidProvideIDByBank(info.getId().toString());
            this.filterTreeOutLine.getFilterItems().add(new FilterItemInfo("purchase.id", (Object)validNumbers, CompareType.INCLUDE));
            this.filterTreeOutLine.getFilterItems().add(new FilterItemInfo("ntType.id", (Object)noteTypeIdSet, CompareType.INCLUDE));
        } else if (path.getPathCount() == 2) {
            noteGroup = (NTTypeGroupEnum)node.getUserObject();
            Set noteTypeIdSet = NoteHelper.getNTTypeIdSet(noteGroup);
            this.filterTreeOutLine.getFilterItems().add(new FilterItemInfo("nttype.id", (Object)noteTypeIdSet, CompareType.INCLUDE));
        } else if (path.getPathCount() == 1) {
            return;
        }
        this.filterTreeOutLine.getFilterItems().add(new FilterItemInfo("noteState", (Object)new Integer(5), CompareType.NOTEQUALS));
        this.handler.setNoteTypeEnum(noteGroup);
        this.handler.initTableHeader();
        this.handler.fillTalble(this.getComboViewInfo());
    }

    @Override
    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblMain_tableSelectChanged(e);
        String pk = this.getSelectedKeyValue();
        if (pk == null) {
            return;
        }
        CoreBaseInfo info = this.getBizInterface().getValue((IObjectPK)new ObjectUuidPK(pk));
        this.initToolbar(info);
        ArrayList<String> idList = new ArrayList<String>();
        idList.add(pk);
        if (this.cbDirectView.isSelected()) {
            GnoteTDPrintDelegate data = new GnoteTDPrintDelegate(idList, this.getTDQueryPK());
            this._previewArea.fireDataChange((AbstractPrintDataProvider)new KdfToR1DataAdaptor((BOSQueryDelegate)data));
        }
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String pk = this.getSelectedKeyValue();
        CoreBaseInfo info = this.getBizInterface().getValue((IObjectPK)new ObjectUuidPK(pk));
        boolean isCheque = BOSUuid.read((String)pk).getType().toString().equals(new ChequeInfo().getBOSType().toString());
        super.actionRemove_actionPerformed(e);
        this.tblMain.removeRows();
        this.handler.fillTalble(this.getComboViewInfo());
    }

    private void initToolbar(CoreBaseInfo info) throws IllegalConversionException, InvalidDateException {
        boolean fiVouchered = info.getBoolean("fiVouchered");
        boolean hasReturn = info.get("abandonDate") != null;
        boolean isPrint = info.getInt("notestate") == 2;
        boolean isVC = info.getDate("vcDate") != null;
        this.actionVoucher.setEnabled(!fiVouchered && !hasReturn);
        this.actionDelVoucher.setEnabled(fiVouchered && !hasReturn);
        this.actionTDPrint.setEnabled(!isPrint && !hasReturn);
        this.actionReturn.setEnabled(!hasReturn && !isVC && !fiVouchered);
        this.actionVC.setEnabled(!isVC && !hasReturn);
        this.actionAntiVC.setEnabled(isVC && !hasReturn);
        this.actionEdit.setEnabled(!fiVouchered && !hasReturn && !isPrint && !isVC);
        this.actionRemove.setEnabled(!hasReturn && !fiVouchered && !isVC);
    }

    @Override
    public void actionReturn_actionPerformed(ActionEvent e) throws Exception {
        super.actionReturn_actionPerformed(e);
        this.checkSelected();
        String pk = this.getSelectedKeyValue();
        CoreBaseInfo info = this.getBizInterface().getValue((IObjectPK)new ObjectUuidPK(pk));
        int result1 = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"isCanceled"));
        if (result1 != 0) {
            return;
        }
        info.setDate("abandonDate", new Date());
        info.setInt("noteState", 4);
        this.getBizInterface().update((IObjectPK)new ObjectUuidPK(pk), info);
        int result2 = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"isAddNew"));
        if (result2 == 0) {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
            uiContext.put((Object)"COPY", (Object)"COPY");
            uiContext.put((Object)"UPDATE", (Object)"update");
            this.prepareUIContext(uiContext, e);
            uiContext.put((Object)"IDList", null);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(this.getEditUIName(), (Map)uiContext, null, OprtState.ADDNEW);
            uiWindow.show();
        }
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    public TreeModel getTree() throws BOSException, EASBizException {
        List list = NTTypeGroupEnum.getEnumList();
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode((Object)EASResource.getString((String)resourcePath, (String)"NTTypeGroupName"));
        IGnoteFacade facade = GnoteFacadeFactory.getRemoteInstance();
        for (int i = 0; i < list.size(); ++i) {
            NTTypeGroupEnum enums = (NTTypeGroupEnum)list.get(i);
            if (enums.getValue() != 1 && enums.getValue() <= 10) continue;
            DefaultKingdeeTreeNode node = new DefaultKingdeeTreeNode(list.get(i));
            CoreBaseCollection banks = (CoreBaseCollection)facade.getBankColl(enums.getValue());
            root.add((MutableTreeNode)node);
            if (banks == null) continue;
            for (int j = 0; j < banks.size(); ++j) {
                BankInfo info = (BankInfo)banks.get(j);
                DefaultKingdeeTreeNode subNode = new DefaultKingdeeTreeNode((Object)info.getName());
                subNode.setUserObject((Object)info);
                node.add((MutableTreeNode)subNode);
            }
        }
        DefaultTreeModel model = new DefaultTreeModel((TreeNode)root);
        return model;
    }

    protected String getEditUIName() {
        if (this.handler.getEditUIName() != null) {
            return this.handler.getEditUIName();
        }
        return GnoteChequeEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        if (this.handler.getEntity() != null) {
            EntityObjectInfo entity = this.handler.getEntity();
            return EJBAccessFactory.createRemoteInstance().getEntityBizInterface(entity.getType());
        }
        return ChequeFactory.getRemoteInstance();
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    public CommonQueryDialog getQueryDlg() throws Exception {
        CommonQueryDialog dialog = super.getQueryDlg();
        dialog.setUiObject(null);
        return dialog;
    }

    public void executeQuery(FilterParam param) throws BOSException {
        if (this.handler.getQuery() == null) {
            return;
        }
        try {
            this.handler.initTableHeader();
            this.handler.fillTalble(this.getComboViewInfo());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.handler.initTableHeader();
        this.handler.fillTalble(this.getComboViewInfo());
    }

    public EntityViewInfo getComboViewInfo() throws Exception {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterCombo = new FilterInfo();
        FilterInfo filterTree = this.filterTreeOutLine;
        FilterInfo queryDlgFilter = new FilterInfo();
        if (this.getQueryDlg() != null) {
            if (this.getQueryDlg().getEntityViewInfoResult() != null) {
                EntityViewInfo dlgView = (EntityViewInfo)this.getQueryDlg().getEntityViewInfoResult().clone();
                if (dlgView.getFilter() != null) {
                    queryDlgFilter.getFilterItems().addObjectCollection((IObjectCollection)dlgView.getFilter().getFilterItems());
                }
                view.getSorter().addObjectCollection((IObjectCollection)dlgView.getSorter());
            }
            if (this.filterUI != null) {
                GnoteFilterParam param = (GnoteFilterParam)((Object)this.filterUI.getParam());
                queryDlgFilter.getFilterItems().addObjectCollection((IObjectCollection)param.getFilter().getFilterItems());
            }
        }
        if (queryDlgFilter.getFilterItems().size() == 0) {
            queryDlgFilter.getFilterItems().addObjectCollection((IObjectCollection)this.getDefalutQueryParam().getFilter().getFilterItems());
        }
        filterCombo.getFilterItems().addObjectCollection((IObjectCollection)this.filterTreeOutLine.getFilterItems());
        filterCombo.getFilterItems().addObjectCollection((IObjectCollection)queryDlgFilter.getFilterItems());
        if (!this.getEditUIName().equals(GnoteChequeEditUI.class.getName())) {
            FilterItemCollection coll = filterCombo.getFilterItems();
            for (int i = 0; i < coll.size(); ++i) {
                if (!coll.get(i).getPropertyName().equals("isQuota")) continue;
                coll.remove(coll.get(i));
                break;
            }
        }
        view.setFilter(filterCombo);
        return view;
    }

    public FilterParam getDefalutQueryParam() {
        return super.getDefalutQueryParam();
    }

    public KDTable getMainTable() {
        return this.tblMain;
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            String string = this.getSelectedKeyValue();
        }
        super.tblMain_tableClicked(e);
    }

    @Override
    public void actionVoucher_actionPerformed(ActionEvent e) throws Exception {
        MutexUtils.setMutex((CoreUI)this, (String)this.getSelectedKeyValue());
        HashSet set = new HashSet();
        set.addAll(this.getSelectedIdValues());
        CoreBaseInfo[] bills = NoteHelper.getBaseInfoFromIdSet(set);
        super.actionVoucher_actionPerformed(e);
        MutexUtils.releaseMutex((CoreUI)this);
    }

    public void actionDelVoucher_actionPerformed(ActionEvent e) throws Exception {
        super.actionDelVoucher_actionPerformed(e);
        this.handler.fillTalble(this.getComboViewInfo());
    }

    @Override
    public void actionAntiVC_actionPerformed(ActionEvent e) throws Exception {
        super.actionVC_actionPerformed(e);
        this.checkSelected();
        String pk = this.getSelectedKeyValue();
        CoreBaseInfo info = this.getBizInterface().getValue((IObjectPK)new ObjectUuidPK(pk));
        boolean isCheque = info.getBOSType().toString().equals(new ChequeInfo().getBOSType().toString());
        if (isCheque) {
            ChequeInfo cheque = (ChequeInfo)info;
            cheque.setVcDate(null);
            cheque.setAmount(null);
            ChequeFactory.getRemoteInstance().update((IObjectPK)new ObjectUuidPK(pk), (CoreBaseInfo)cheque);
        }
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.gnt.GNTAutoGenerateResource", (String)"4_GnoteListUI"));
    }

    @Override
    public void actionVC_actionPerformed(ActionEvent e) throws Exception {
        super.actionVC_actionPerformed(e);
        this.checkSelected();
        String pk = this.getSelectedKeyValue();
        CoreBaseInfo info = this.getBizInterface().getValue((IObjectPK)new ObjectUuidPK(pk));
        boolean isCheque = info.getBOSType().toString().equals(new ChequeInfo().getBOSType().toString());
        if (!isCheque) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.gnt.GNTAutoGenerateResource", (String)"5_GnoteListUI"));
            return;
        }
        ChequeInfo cheque = (ChequeInfo)info;
        boolean isVerification = false;
        if (!isVerification) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.gnt.GNTAutoGenerateResource", (String)"6_GnoteListUI"));
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"Verification", (Object)Boolean.TRUE);
        uiContext.put((Object)"ID", (Object)pk);
        IUIWindow uiWindow = null;
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(GnoteChequeEditUI.class.getName(), (Map)uiContext, null, "EDIT");
        uiWindow.show();
    }

    @Override
    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"UPDATE", (Object)"update");
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(this.getEditUIName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
    }

    @Override
    public void actionTDPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionTDPrint_actionPerformed(e);
        this.checkSelected();
        ArrayList idList = super.getSelectedIdValues();
        if (idList == null || idList.size() == 0 || this.getTDQueryPK() == null || this.getTDFileName() == null) {
            return;
        }
        GnoteTDPrintDelegate data = new GnoteTDPrintDelegate(idList, this.getTDQueryPK());
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.addKDNoteActionListener((IPrintActionListener)new PrintListener());
        appHlp.print(this.getTDFileName(), (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    @Override
    public void actionDirectPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionDirectPrint_actionPerformed(e);
        this.checkSelected();
        String pk = this.getSelectedKeyValue();
        if (pk == null) {
            return;
        }
        ArrayList<String> idList = new ArrayList<String>();
        idList.add(pk);
        GnoteTDPrintDelegate data = new GnoteTDPrintDelegate(idList, this.getTDQueryPK());
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.addKDNoteActionListener((IPrintActionListener)new PrintListener());
        appHlp.directPrint(((TreeUI)this._templateTree.getCtrl()).getSelectionPathText(), (Object)data, false, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    protected String getTDFileName() {
        String editUIName = "";
        if (this.handler.getEditUIName() != null) {
            editUIName = this.handler.getEditUIName();
        }
        if (editUIName == null) {
            return "/FM/GOV/Cheque";
        }
        if (editUIName.equals(GnoteChequeEditUI.class.getName())) {
            return "/FM/GOV/Cheque";
        }
        if (editUIName.equals(AppopriationEditUI.class.getName())) {
            return "/FM/GOV/Appr";
        }
        return "/FM/GOV/TeleOrder";
    }

    protected IMetaDataPK getTDQueryPK() {
        return new MetaDataPK(this.handler.getMainQueryName());
    }

    private final class PrintListener
    implements IPrintActionListener {
        private PrintListener() {
        }

        public void beforePrintOrPreview() {
        }

        public void beforePreview() {
        }

        public void beforePrint() {
            try {
                CoreBaseInfo info = GnoteListUI.this.getBizInterface().getValue((IObjectPK)new ObjectUuidPK(GnoteListUI.this.getSelectedKeyValue()));
                info.setInt("noteState", 2);
                GnoteListUI.this.getBizInterface().update((IObjectPK)new ObjectUuidPK(GnoteListUI.this.getSelectedKeyValue()), info);
            }
            catch (Exception e) {
                GnoteListUI.this.handUIException(e);
            }
        }

        public void closePreview() {
            String aa = "";
        }
    }
}

