/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.gnt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.appframework.databinding.BindingUtility;
import com.kingdee.bos.appframework.databinding.Field;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CommonQueryProcessor;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FilterParam;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.common.client.FMDefaultQueryProcessor;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.gnt.GnoteProvideRecordFactory;
import com.kingdee.eas.fm.gnt.GnoteProvideRecordInfo;
import com.kingdee.eas.fm.gnt.GnotePurchaseRecordCollection;
import com.kingdee.eas.fm.gnt.GnotePurchaseRecordFactory;
import com.kingdee.eas.fm.gnt.GnotePurchaseRecordInfo;
import com.kingdee.eas.fm.gnt.client.AbstractGnoteProvideEditUI;
import com.kingdee.eas.fm.gnt.client.GnotePurchaseFilterParam;
import com.kingdee.eas.fm.gnt.client.GnotePurchaseFilterUI;
import com.kingdee.eas.fm.gnt.common.MyPersonPromptBox;
import com.kingdee.eas.fm.gnt.common.NoteHelper;
import com.kingdee.eas.fm.gnt.common.NoteNumberHelper;
import com.kingdee.eas.fm.nt.NTTypeFactory;
import com.kingdee.eas.fm.nt.NTTypeInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class GnoteProvideEditUI
extends AbstractGnoteProvideEditUI {
    private static final Logger logger = CoreUIObject.getLogger(GnoteProvideEditUI.class);
    private GnotePurchaseRecordInfo bill = null;
    private GnotePurchaseFilterUI filterUI = null;
    private GnotePurchaseFilterParam filterParam = null;
    private CommonQueryDialog queryDlg;
    private static final String GntResource = "com.kingdee.eas.fm.gnt.GntResource";

    @Override
    public void loadFields() {
        super.loadFields();
        this.dpReceiptDate.setValue((Object)new Date());
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
    }

    @Override
    public void storeFields() {
        this.editData.setParent(this.bill);
        super.storeFields();
        this.editData.setReceiptDate(DateTimeUtils.truncateDate((Date)((Date)this.dpReceiptDate.getValue())));
    }

    public void onLoad() throws Exception {
        super.onLoad();
        String changeLine = this.txtRemark.getText().replaceAll("\\\\r", "\r").replaceAll("\\\\n", "\n");
        this.txtRemark.setText(changeLine);
        this.tblAppRec.getSelectManager().setSelectMode(2);
        this.tblAppRec.setEditable(false);
        this.fillBilllist(this.tblAppRec, null);
        MyPersonPromptBox select = NoteHelper.initPerson((IUIObject)this, this.prmtReceiptor);
        select.setSelectable(false).setExpandMode(MyPersonPromptBox.CURRENT_ADMIN);
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        Date receiptDate;
        Pattern pc = Pattern.compile("((([0-9]+\\-[0-9]+)|([0-9])+),)*(([0-9]+\\-[0-9]+)|([0-9]+))");
        Matcher m1 = pc.matcher(this.txtNum.getText());
        if (!m1.matches()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)GntResource, (String)"numberError"));
            SysUtil.abort();
        }
        if (!NoteNumberHelper.checkProvideNoteValid(this.editData)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)GntResource, (String)"validNumber"));
            SysUtil.abort();
        }
        if ((receiptDate = (Date)this.dpReceiptDate.getValue()).compareTo(DateTimeUtils.truncateDate((Date)this.bill.getApplyDate())) < 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)GntResource, (String)"receiptDateBiggerThanPurchaseDate"));
            SysUtil.abort();
        }
        if (FMHelper.isEmpty((String)this.prmtReceiptor.getText())) {
            this.prmtReceiptor.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)FMClientVerifyHelper.getMessage((Component)this.prmtReceiptor));
            SysUtil.abort();
        }
        super.verifyInput(e);
    }

    protected void afterSubmitAddNew() {
        super.afterSubmitAddNew();
        try {
            this.fillBilllist(this.tblAppRec, this.filterParam);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.tblAppRec.getSelectManager().setActiveColumnIndex(0);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return GnoteProvideRecordFactory.getRemoteInstance();
    }

    protected KDTable getDetailTable() {
        return this.tblAppRec;
    }

    protected IObjectValue createNewData() {
        GnoteProvideRecordInfo provideRecInfo = new GnoteProvideRecordInfo();
        return provideRecInfo;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
    }

    @Override
    protected void tblAppRec_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblAppRec_tableSelectChanged(e);
        int selectRow = this.tblAppRec.getSelectManager().getActiveRowIndex();
        if (selectRow == -1) {
            return;
        }
        String id = this.tblAppRec.getRow(selectRow).getCell("id").getValue().toString();
        this.bill = GnotePurchaseRecordFactory.getRemoteInstance().getGnotePurchaseRecordInfo((IObjectPK)new ObjectUuidPK(id));
        NTTypeInfo noteType = NTTypeFactory.getRemoteInstance().getNTTypeInfo((IObjectPK)new ObjectUuidPK(this.bill.getNtType().getId().toString()));
        this.prmtNTType.setData((Object)noteType);
    }

    private void fillBilllist(KDTable table, GnotePurchaseFilterParam param) throws BOSException, EASBizException, SQLException {
        GnotePurchaseRecordCollection coll = this.getPurchaseNoteColl(param);
        if (coll.size() == 0) {
            return;
        }
        table.removeRows();
        table.checkParsed();
        for (int i = 0; i < coll.size(); ++i) {
            IRow row = table.addRow();
            CoreBaseInfo vo = (CoreBaseInfo)coll.getObject(i);
            for (int j = 0; j < table.getColumnCount(); ++j) {
                row.getCell(j).setValue(BindingUtility.getValue((IObjectValue)vo, (Field)new Field(table.getColumnKey(j))));
            }
        }
    }

    private GnotePurchaseRecordCollection getPurchaseNoteColl() throws BOSException {
        return this.getPurchaseNoteColl(null);
    }

    private GnotePurchaseRecordCollection getPurchaseNoteColl(GnotePurchaseFilterParam param) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("remainNotes", (Object)new Integer(0), CompareType.GREATER));
        if (param != null) {
            filter.mergeFilter(this.filterParam.getFilter(), "AND");
        }
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("*"));
        view.getSelector().add(new SelectorItemInfo("name"));
        view.getSelector().add(new SelectorItemInfo("bank.*"));
        view.getSelector().add(new SelectorItemInfo("ntType.name"));
        GnotePurchaseRecordCollection coll = GnotePurchaseRecordFactory.getRemoteInstance().getGnotePurchaseRecordCollection(view);
        return coll;
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
        CommonQueryDialog dialog = this.getQueryDlg();
        if (!dialog.show()) {
            SysUtil.abort();
        }
        FilterParam param = (FilterParam)this.getFilterUI().getParam();
        this.filterParam = (GnotePurchaseFilterParam)((Object)this.filterUI.getParam());
        this.fillBilllist(this.tblAppRec, this.filterParam);
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new GnotePurchaseFilterUI();
        }
        return this.filterUI;
    }

    protected CommonQueryDialog getQueryDlg() throws Exception {
        if (this.queryDlg != null) {
            return this.queryDlg;
        }
        FMFilterBaseUI filterUI = this.getFilterUI();
        MetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.fm.gnt.app", "GnotePurchaseQuery");
        filterUI.setListUI((IUIObject)this);
        filterUI.setActionListOnLoad((ItemAction)this.actionOnLoad);
        this.queryDlg = new CommonQueryDialog();
        EntityViewInfo view = new EntityViewInfo();
        this.queryDlg.setEntityViewInfo(view);
        this.queryDlg.setOwner((Component)this.getUIContext().get("Owner"));
        this.queryDlg.setParentUIClassName(this.getMetaDataPK().getFullName());
        this.queryDlg.setQueryObjectPK((IMetaDataPK)mainQueryPK);
        this.queryDlg.setHeight(300);
        this.queryDlg.setWidth(400);
        this.queryDlg.setTitle(filterUI.getUITitle());
        this.queryDlg.addUserPanel((KDPanel)filterUI);
        this.queryDlg.setProcessor((IProcessor)this.getQueryProcessor());
        return this.queryDlg;
    }

    protected CommonQueryProcessor getQueryProcessor() {
        return new FMDefaultQueryProcessor();
    }
}

