/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.gnt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.gnt.GnoteProvideRecordFactory;
import com.kingdee.eas.fm.gnt.GnoteProvideRecordInfo;
import com.kingdee.eas.fm.gnt.GntException;
import com.kingdee.eas.fm.gnt.IGnoteProvideRecord;
import com.kingdee.eas.fm.gnt.client.AbstractGnoteProvideListUI;
import com.kingdee.eas.fm.gnt.client.AppopriationEditUI;
import com.kingdee.eas.fm.gnt.client.GnoteChequeEditUI;
import com.kingdee.eas.fm.gnt.client.GnoteProvideFilterUI;
import com.kingdee.eas.fm.gnt.client.GnoteProvideModelEditUI;
import com.kingdee.eas.fm.gnt.client.TeleOrderEditUI;
import com.kingdee.eas.fm.gnt.common.NoteNumberHelper;
import com.kingdee.eas.fm.nt.NTTypeFactory;
import com.kingdee.eas.fm.nt.NTTypeGroupEnum;
import com.kingdee.eas.fm.nt.NTTypeInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class GnoteProvideListUI
extends AbstractGnoteProvideListUI {
    private static final Logger logger = CoreUIObject.getLogger(GnoteProvideListUI.class);
    private GnoteProvideFilterUI filterUI = null;
    private GnoteProvideRecordInfo provide = null;
    CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
    UserInfo curUser = SysContext.getSysContext().getCurrentUserInfo();

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.actionAttachment.setVisible(false);
        this.actionAuditResult.setVisible(false);
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new GnoteProvideFilterUI();
        }
        return this.filterUI;
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionRecord.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_new"));
        this.actionPrintAll.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_print"));
    }

    protected ICoreBase getBizInterface() throws Exception {
        return GnoteProvideRecordFactory.getRemoteInstance();
    }

    @Override
    public void actionRecord_actionPerformed(ActionEvent e) throws Exception {
        super.actionRecord_actionPerformed(e);
        this.checkSelected();
        ObjectUuidPK id = new ObjectUuidPK(this.getSelectedKeyValue());
        GnoteProvideRecordInfo bill = GnoteProvideRecordFactory.getRemoteInstance().getGnoteProvideRecordInfo((IObjectPK)id);
        NTTypeInfo NTTypeInfo2 = NTTypeFactory.getRemoteInstance().getNTTypeInfo((IObjectPK)new ObjectUuidPK(bill.getNtType().getId().toString()));
        NTTypeGroupEnum noteGroup = NTTypeInfo2.getGroup();
        String editUIName = this.getRecordEditUIName(noteGroup);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"UPDATE", (Object)"update");
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(editUIName, (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
    }

    public String getRecordEditUIName(NTTypeGroupEnum noteGroup) throws EASBizException {
        if (noteGroup.getValue() == 1) {
            return GnoteChequeEditUI.class.getName();
        }
        if (noteGroup.getValue() == 12) {
            return AppopriationEditUI.class.getName();
        }
        if (noteGroup.getValue() == 11) {
            return TeleOrderEditUI.class.getName();
        }
        throw new GntException(GntException.SELECTNODEINVALID);
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        this.checkSelected();
        ObjectUuidPK id = new ObjectUuidPK(this.getSelectedKeyValue());
        this.provide = GnoteProvideRecordFactory.getRemoteInstance().getGnoteProvideRecordInfo((IObjectPK)id);
        super.tblMain_tableSelectChanged(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        if (this.provide == null) {
            return;
        }
        if (this.provide.getUsedAmount() != 0) {
            throw new GntException(GntException.RECORDHASBEANUSED);
        }
        super.actionEdit_actionPerformed(e);
    }

    @Override
    public void actionPrintAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintAll_actionPerformed(e);
        this.checkSelected();
        KDTable table = new KDTable();
        this.initTable(table);
        this.fillPrintTable(table);
        FMClientHelper.exportToExcel((Component)((Object)this), (KDTable)table);
    }

    private void fillPrintTable(KDTable table) throws NumberFormatException, BOSException, EASBizException {
        int i;
        IGnoteProvideRecord iprovide = GnoteProvideRecordFactory.getRemoteInstance();
        ArrayList<Integer> list = new ArrayList<Integer>();
        KDTSelectBlock selectBlock = null;
        int size = this.tblMain.getSelectManager().size();
        for (i = 0; i < size; ++i) {
            selectBlock = this.tblMain.getSelectManager().get(i);
            for (int j = selectBlock.getTop(); j <= selectBlock.getBottom(); ++j) {
                list.add(new Integer(j));
            }
        }
        for (i = 0; i < list.size(); ++i) {
            int rowIndex = Integer.parseInt(list.get(i).toString());
            String codingRule = this.tblMain.getRow(rowIndex).getCell("codingRule").getValue().toString();
            String number = this.tblMain.getRow(rowIndex).getCell("receiptedNum").getValue().toString();
            String nttype = this.tblMain.getRow(rowIndex).getCell("NTType.name").getValue().toString();
            String id = this.tblMain.getRow(rowIndex).getCell("id").getValue().toString();
            GnoteProvideRecordInfo record = iprovide.getGnoteProvideRecordInfo((IObjectPK)new ObjectUuidPK(id));
            HashSet usedID = record.getUsedNumbersHashSet();
            HashSet numberList = NoteNumberHelper.getCodingNumber(codingRule, NoteNumberHelper.getProvidedNotesNum(number));
            numberList.removeAll(usedID);
            Object[] array = numberList.toArray();
            Arrays.sort(array);
            for (int j = 0; j < array.length; ++j) {
                IRow row = table.addRow();
                row.getCell(EASResource.getString((String)"com.kingdee.eas.fm.gnt.GNTAutoGenerateResource", (String)"7_GnoteProvideListUI")).setValue((Object)nttype);
                row.getCell(EASResource.getString((String)"com.kingdee.eas.fm.gnt.GNTAutoGenerateResource", (String)"8_GnoteProvideListUI")).setValue((Object)array[j].toString());
            }
        }
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        if (this.provide == null) {
            return;
        }
        if (this.provide.getUsedAmount() != 0) {
            throw new GntException(GntException.RECORDHASBEANUSED);
        }
        super.actionRemove_actionPerformed(e);
    }

    protected String getEditUIName() {
        return GnoteProvideModelEditUI.class.getName();
    }

    private void initTable(KDTable table) {
        table.addColumn().setKey(EASResource.getString((String)"com.kingdee.eas.fm.gnt.GNTAutoGenerateResource", (String)"9_GnoteProvideListUI"));
        table.addColumn().setKey(EASResource.getString((String)"com.kingdee.eas.fm.gnt.GNTAutoGenerateResource", (String)"7_GnoteProvideListUI"));
        table.addColumn().setKey(EASResource.getString((String)"com.kingdee.eas.fm.gnt.GNTAutoGenerateResource", (String)"8_GnoteProvideListUI"));
        table.addColumn().setKey(EASResource.getString((String)"com.kingdee.eas.fm.gnt.GNTAutoGenerateResource", (String)"10_GnoteProvideListUI"));
        table.addColumn().setKey(EASResource.getString((String)"com.kingdee.eas.fm.gnt.GNTAutoGenerateResource", (String)"11_GnoteProvideListUI"));
        IRow row = table.addHeadRow();
        row.getCell(EASResource.getString((String)"com.kingdee.eas.fm.gnt.GNTAutoGenerateResource", (String)"8_GnoteProvideListUI")).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.gnt.GNTAutoGenerateResource", (String)"12_GnoteProvideListUI"));
        row.setMergeable(true);
        table.addHeadRow();
        IRow rowHeader = table.addHeadRow();
        for (int i = 0; i < table.getColumnCount(); ++i) {
            rowHeader.getCell(i).setValue((Object)table.getColumn(i).getKey());
        }
    }

    protected void beforeExcutQuery(EntityViewInfo ev) {
        FilterInfo oldFilter = ev.getFilter();
        if (oldFilter == null) {
            oldFilter = new FilterInfo();
            ev.setFilter(oldFilter);
        }
        boolean canRecord = false;
        try {
            IPermission iPermission = PermissionFactory.getRemoteInstance();
            canRecord = iPermission.hasFunctionPermission((IObjectPK)new ObjectUuidPK(this.curUser.getId()), (IObjectPK)new ObjectUuidPK(this.company.getId()), "gnt_GnoteProvideRecord_record");
        }
        catch (BOSException e1) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
            e1.printStackTrace();
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
            e.printStackTrace();
        }
        FilterInfo bfilter = new FilterInfo();
        if (!canRecord) {
            bfilter.getFilterItems().add(new FilterItemInfo("receiptor.id", (Object)this.curUser.getId().toString(), CompareType.EQUALS));
        }
        try {
            if (oldFilter.getFilterItems().size() > 0) {
                oldFilter.mergeFilter(bfilter, "and");
            } else {
                ev.setFilter(bfilter);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        super.beforeExcutQuery(ev);
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }
}

