/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.gnt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.F7SelectorFactory;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.gnt.GnotePurchaseRecordFactory;
import com.kingdee.eas.fm.gnt.GnotePurchaseRecordInfo;
import com.kingdee.eas.fm.gnt.GntException;
import com.kingdee.eas.fm.gnt.client.AbstractGnotePurchaseEditUI;
import com.kingdee.eas.fm.gnt.common.MyPersonPromptBox;
import com.kingdee.eas.fm.gnt.common.NoteHelper;
import com.kingdee.eas.fm.gnt.common.NoteNumberHelper;
import com.kingdee.eas.fm.nt.NTTypeFactory;
import com.kingdee.eas.fm.nt.NTTypeGroupEnum;
import com.kingdee.eas.fm.nt.NTTypeInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class GnotePurchaseEditUI
extends AbstractGnotePurchaseEditUI {
    private static final Logger logger = CoreUIObject.getLogger(GnotePurchaseEditUI.class);
    PersonInfo currentUser = SysContext.getSysContext().getCurrentUserInfo().getPerson();
    CompanyOrgUnitInfo admin = SysContext.getSysContext().getCurrentFIUnit();

    public GnotePurchaseEditUI() throws Exception {
        String changeLine = this.txtAreaRemark.getText().replaceAll("\\\\r", "\r").replaceAll("\\\\n", "\n");
        this.txtAreaRemark.setText(changeLine);
    }

    @Override
    public void storeFields() {
        int totalNotes = this.txtEndNum.getNumberValue().intValue() - this.txtStartNum.getNumberValue().intValue() + 1;
        this.editData.setApplier(this.prmtApplier.getText());
        this.editData.setTotalNotes(totalNotes);
        super.storeFields();
        this.editData.setApplyDate(DateTimeUtils.truncateDate((Date)((Date)this.pkApplyDate.getValue())));
    }

    @Override
    public void loadFields() {
        super.loadFields();
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            this.comboNoteType.setSelectedIndex(0);
            this.pkApplyDate.setValue((Object)new Date());
        } else {
            this.prmtApplier.setText(this.editData.getApplier());
            try {
                NTTypeInfo nttype = NTTypeFactory.getRemoteInstance().getNTTypeInfo((IObjectPK)new ObjectUuidPK(this.editData.getNtType().getId().toString()));
                FMClientHelper.setSelectObject((KDComboBox)this.comboNoteType, (Object)nttype);
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
    }

    @Override
    public void setOprtState(String oprtType) {
        if (oprtType.equals(OprtState.ADDNEW)) {
            if (this.currentUser != null) {
                this.prmtApplier.setText(this.currentUser.getName());
            }
            this.pkApplyDate.setValue((Object)DateTimeUtils.truncateDate((Date)new Date()));
        }
        super.setOprtState(oprtType);
    }

    public void onLoad() throws Exception {
        NoteHelper.initNoteTypeCombo(this.comboNoteType);
        super.onLoad();
        if (this.admin != null) {
            // empty if block
        }
        F7SelectorFactory.initBankTree((IUIObject)this, (KDBizPromptBox)this.prmtBank);
        MyPersonPromptBox select = NoteHelper.initPerson((IUIObject)this, this.prmtApplier);
        select.setSelectable(false).setExpandMode(MyPersonPromptBox.CURRENT_ADMIN);
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        Pattern pc = Pattern.compile("[A-Za-z0-9]*\\*+[A-Za-z0-9]*");
        Matcher m1 = pc.matcher(this.txtCodingRule.getText());
        if (!m1.matches()) {
            throw new GntException(GntException.CODINGRULEWRONG);
        }
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDComboBox)this.comboNoteType);
        NTTypeInfo selectedItem = (NTTypeInfo)this.comboNoteType.getSelectedItem();
        if (!selectedItem.getGroup().equals((Object)NTTypeGroupEnum.APPROPRIATION)) {
            FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtBank);
        }
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDFormattedTextField)this.txtStartNum);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDFormattedTextField)this.txtEndNum);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDTextField)this.txtCodingRule);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.pkApplyDate);
        if (FMHelper.isEmpty((String)this.prmtApplier.getText())) {
            this.prmtApplier.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)FMClientVerifyHelper.getMessage((Component)this.prmtApplier));
            SysUtil.abort();
        }
        FMClientHelper.verifyNotNegtive((CoreUIObject)this, (KDFormattedTextField)this.txtStartNum);
        FMClientHelper.verifyNotNegtive((CoreUIObject)this, (KDFormattedTextField)this.txtEndNum);
        if (this.txtStartNum.getNumberValue().intValue() > this.txtEndNum.getNumberValue().intValue()) {
            throw new GntException(GntException.STARTNUMMUSTSMALLTHANENDNUM);
        }
        this.verifyEndNumLength();
        if (!NoteNumberHelper.checkPurchaseNoteValid(this.editData)) {
            throw new GntException(GntException.NUMBERDUPLICATED);
        }
    }

    private void verifyEndNumLength() throws GntException {
        int maskBegin = this.txtCodingRule.getText().indexOf("*");
        int maskEnd = this.txtCodingRule.getText().lastIndexOf("*");
        int seqLen = maskEnd - maskBegin + 1;
        if (this.txtEndNum.getNumberValue().toString().length() > seqLen) {
            throw new GntException(GntException.ENDNUMTOOLONG);
        }
    }

    protected IObjectValue createNewData() {
        GnotePurchaseRecordInfo info = new GnotePurchaseRecordInfo();
        return info;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return GnotePurchaseRecordFactory.getRemoteInstance();
    }

    @Override
    protected void txtCodingRule_focusLost(FocusEvent e) throws Exception {
        super.txtCodingRule_focusLost(e);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add("*");
        return sic;
    }
}

