/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.gnt.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.fm.gnt.GnoteProvideRecordCollection;
import com.kingdee.eas.fm.gnt.GnoteProvideRecordFactory;
import com.kingdee.eas.fm.gnt.GnoteProvideRecordInfo;
import com.kingdee.eas.fm.gnt.GnotePurchaseRecordCollection;
import com.kingdee.eas.fm.gnt.GnotePurchaseRecordFactory;
import com.kingdee.eas.fm.gnt.GnotePurchaseRecordInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NoteNumberHelper {
    public static List genNumBySeperator(String number, String seperator) {
        ArrayList<String> numList = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(number, seperator);
        while (tokenizer.hasMoreTokens()) {
            numList.add(tokenizer.nextToken());
        }
        return numList;
    }

    public static List genNumByCodingRule(String codingRule, int beginIndex, int endIndex) {
        int i;
        ArrayList<String> numList = new ArrayList<String>();
        int maskBegin = codingRule.indexOf("*");
        int maskEnd = codingRule.lastIndexOf("*");
        StringBuffer seqNumber = new StringBuffer("");
        int seqLen = 0;
        seqLen = maskEnd - maskBegin + 1;
        String prefix = codingRule.substring(0, maskBegin);
        String suffix = codingRule.substring(maskEnd + 1);
        int zeroNumber = 0;
        int count = endIndex - beginIndex + 1;
        String sMaxIndex = String.valueOf(endIndex);
        if (seqLen >= sMaxIndex.length()) {
            zeroNumber = seqLen - sMaxIndex.length();
        }
        int lenthOfZero = sMaxIndex.length() - String.valueOf(endIndex).length();
        for (i = 0; i < zeroNumber + lenthOfZero; ++i) {
            seqNumber.append("0");
        }
        for (i = beginIndex; i <= endIndex; ++i) {
            String zero = "";
            if (String.valueOf(i).length() < String.valueOf(endIndex).length()) {
                for (int j = 0; j < String.valueOf(endIndex).length() - String.valueOf(i).length(); ++j) {
                    zero = zero + "0";
                }
            }
            numList.add(prefix + zero + seqNumber + i + suffix);
        }
        return numList;
    }

    public static List genNumByCodingRule(String codingRule, String beginIndex, String endIndex) {
        ArrayList<String> numList = new ArrayList<String>();
        int maskBegin = codingRule.indexOf("*");
        int maskEnd = codingRule.lastIndexOf("*");
        StringBuffer seqNumber = new StringBuffer("");
        int seqLen = 0;
        seqLen = maskEnd - maskBegin + 1;
        String prefix = codingRule.substring(0, maskBegin);
        String suffix = codingRule.substring(maskEnd + 1);
        int zeroNumber = 0;
        if (seqLen >= endIndex.length()) {
            zeroNumber = seqLen - endIndex.length();
        }
        int lenthOfZero = endIndex.length() - String.valueOf(Integer.parseInt(endIndex)).length();
        for (int i = 0; i < zeroNumber + lenthOfZero; ++i) {
            seqNumber.append("0");
        }
        int beginInt = Integer.parseInt(beginIndex);
        int endInt = Integer.parseInt(endIndex);
        for (int i = beginInt; i <= endInt; ++i) {
            String zero = "";
            if (String.valueOf(i).length() < String.valueOf(endIndex).length()) {
                for (int j = 0; j < String.valueOf(endInt).length() - String.valueOf(i).length(); ++j) {
                    zero = zero + "0";
                }
            }
            numList.add(prefix + zero + seqNumber + i + suffix);
        }
        return numList;
    }

    public static List getProvidedNotesNum(String numbers) {
        StringTokenizer st = new StringTokenizer(numbers, ",");
        ArrayList<String> list = new ArrayList<String>();
        Pattern singleNumber = Pattern.compile("[0-9]+");
        Pattern manyNumber = Pattern.compile("[0-9]+\\-[0-9]+");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            Matcher m1 = singleNumber.matcher(token);
            Matcher m2 = manyNumber.matcher(token);
            if (m1.matches()) {
                list.add(token);
            }
            if (!m2.matches()) continue;
            int maskBegin = token.indexOf("-");
            String prefix = token.substring(0, maskBegin);
            String suffix = token.substring(maskBegin + 1);
            for (int i = Integer.parseInt(prefix); i <= Integer.parseInt(suffix); ++i) {
                list.add("" + i);
            }
        }
        return list;
    }

    public static HashSet getCodingNumber(String codingRule, List numbers) {
        HashSet<String> set = new HashSet<String>();
        if (numbers == null) {
            return set;
        }
        int maskBegin = codingRule.indexOf("*");
        int maskEnd = codingRule.lastIndexOf("*");
        String prefix = codingRule.substring(0, maskBegin);
        String suffix = codingRule.substring(maskEnd + 1);
        int zeroNumber = 0;
        Iterator iter = numbers.iterator();
        while (iter.hasNext()) {
            String number = iter.next().toString();
            zeroNumber = maskEnd - maskBegin + 1 - number.length();
            String zero = "";
            for (int i = 0; i < zeroNumber; ++i) {
                zero = zero + "0";
            }
            set.add(prefix + zero + number + suffix);
        }
        return set;
    }

    public static boolean checkProvideNoteValid(GnoteProvideRecordInfo note) throws BOSException {
        List list = NoteNumberHelper.getProvidedNotesNum(note.getReceiptedNum());
        GnotePurchaseRecordInfo purchase = note.getParent();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)purchase.getId().toString()));
        view.setFilter(filter);
        GnoteProvideRecordCollection coll = GnoteProvideRecordFactory.getRemoteInstance().getGnoteProvideRecordCollection(view);
        Iterator iter = coll.iterator();
        while (iter.hasNext()) {
            List hasUsedNumber;
            boolean isDuplicate;
            GnoteProvideRecordInfo info = (GnoteProvideRecordInfo)iter.next();
            if (info.getId().equals((Object)note.getId()) || (isDuplicate = NoteNumberHelper.disjoint(list, hasUsedNumber = NoteNumberHelper.getProvidedNotesNum(info.getReceiptedNum())))) continue;
            return isDuplicate;
        }
        Iterator iter2 = list.iterator();
        while (iter2.hasNext()) {
            int number = Integer.parseInt(iter2.next().toString());
            if (number <= purchase.getEndNum() && number >= purchase.getStartNum()) continue;
            return false;
        }
        return true;
    }

    public static boolean checkPurchaseNoteValid(GnotePurchaseRecordInfo note) throws BOSException {
        List currentList = NoteNumberHelper.genNumByCodingRule(note.getNumRule(), note.getStartNum(), note.getEndNum());
        GnotePurchaseRecordCollection coll = GnotePurchaseRecordFactory.getRemoteInstance().getGnotePurchaseRecordCollection();
        Iterator iter = coll.iterator();
        while (iter.hasNext()) {
            List privousNumberList;
            GnotePurchaseRecordInfo privousInfo = (GnotePurchaseRecordInfo)iter.next();
            if (privousInfo.getId().equals((Object)note.getId()) || NoteNumberHelper.disjoint(currentList, privousNumberList = NoteNumberHelper.genNumByCodingRule(privousInfo.getNumRule(), privousInfo.getStartNum(), privousInfo.getEndNum()))) continue;
            return false;
        }
        return true;
    }

    public static boolean disjoint(Collection c1, Collection c2) {
        if (c1 instanceof Set && !(c2 instanceof Set) || c1.size() > c2.size()) {
            Collection tmp = c1;
            c1 = c2;
            c2 = tmp;
        }
        for (Object obj : c1) {
            if (!c2.contains(obj)) continue;
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
    }
}

