/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ivt;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.vc.VerifyScopeEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BillTypeEnum;
import com.kingdee.eas.fi.cas.DefaultBookNotifyBuilder;
import com.kingdee.eas.fi.cas.JournalCollection;
import com.kingdee.eas.fi.cas.JournalInfo;
import com.kingdee.eas.fi.cas.JournalSourceEnum;
import com.kingdee.eas.fi.cas.JournalTypeEnum;
import com.kingdee.eas.fm.ivt.FinancingRedeemFactory;
import com.kingdee.eas.fm.ivt.FinancingRedeemInfo;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;

public class FinRedeemBookNotifyBuilder
extends DefaultBookNotifyBuilder {
    public JournalCollection getJournalColl(Context ctx, Set ids) throws BOSException, EASBizException {
        JournalCollection journalColl = new JournalCollection();
        Iterator it = ids.iterator();
        while (it.hasNext()) {
            String pk = it.next().toString();
            FinancingRedeemInfo redeemInfo = this.getFinancingRedeemInfo(ctx, pk);
            JournalInfo journalInfo = this.createJournalInfoAmt(ctx, redeemInfo);
            journalColl.add(journalInfo);
        }
        return journalColl;
    }

    private JournalInfo createJournalInfoAmt(Context ctx, FinancingRedeemInfo info) {
        JournalInfo journalInfo = new JournalInfo();
        journalInfo.setType(JournalTypeEnum.BANK);
        journalInfo.setAccountBank(info.getBankAccount());
        journalInfo.setCurrency(info.getCurrency());
        this.cs104 = ContextHelperFactory.getLocalInstance((Context)ctx).getIntParam("CS104", (IObjectPK)new ObjectUuidPK(info.getCompany().getId()));
        if (this.cs104 == 1) {
            journalInfo.setCreateDate(new Date());
        } else {
            journalInfo.setCreateDate(info.getBizDate());
        }
        journalInfo.setDebitAmount(info.getRedeemAmount().add(info.getPracticalWinAmount()));
        journalInfo.setCreditAmount(Constants.ZERO);
        journalInfo.setIsDebit(false);
        journalInfo.setBizDate(info.getBizDate());
        if (info.getBankAccount() != null) {
            journalInfo.setAccountView(info.getBankAccount().getAccount());
        }
        journalInfo.setBillType(BillTypeEnum.finRedeemAccount);
        journalInfo.setBillId(info.getId().toString());
        journalInfo.setBillNumber(info.getNumber());
        journalInfo.setCompany(info.getCompany());
        journalInfo.setVerifyStatus(VerifyScopeEnum.NOVA);
        journalInfo.setSource(JournalSourceEnum.BYBILL);
        return journalInfo;
    }

    private FinancingRedeemInfo getFinancingRedeemInfo(Context ctx, String billId) throws EASBizException, BOSException {
        FinancingRedeemInfo info = FinancingRedeemFactory.getLocalInstance(ctx).getFinancingRedeemInfo((IObjectPK)new ObjectUuidPK(billId), this.getSelector());
        return info;
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("bankAccount.account.*");
        return sic;
    }
}

