/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ivt;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.BOTPUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BillDisposerAction;
import com.kingdee.eas.fi.cas.BillStatusEnum;
import com.kingdee.eas.fi.cas.DisposerActionEnum;
import com.kingdee.eas.fi.cas.IPaymentDisposer;
import com.kingdee.eas.fi.cas.PaymentBillCollection;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fm.ivt.FinancingAccountApplyFactory;
import com.kingdee.eas.fm.ivt.FinancingAccountApplyInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;

public class FinanAccountApplyDisposer
implements IPaymentDisposer {
    private static final String RESOURCE = "com.kingdee.eas.fm.ivt.IVTFINANCINGResource";

    public BigDecimal getCashRebate(Date billDate, BigDecimal apAmount, String srcBillId, String srcBillEntryId) {
        return null;
    }

    public void dispose(Context ctx, BillDisposerAction action) throws BOSException, EASBizException {
        CoreBaseInfo destInfo = action.getDestBill();
        DisposerActionEnum actionType = action.getActionType();
        if (actionType == DisposerActionEnum.SUBMIT) {
            this.savedipose(ctx, destInfo);
        } else if (actionType == DisposerActionEnum.DELETE) {
            this.deletedipose(ctx, destInfo);
        }
    }

    private void deletedipose(Context ctx, CoreBaseInfo destInfo) throws EASBizException, BOSException {
        String sourceBillId = ((PaymentBillInfo)destInfo).getSourceBillId();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("sourceBillId", (Object)sourceBillId, CompareType.EQUALS));
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(filterInfo);
        PaymentBillCollection collection = PaymentBillFactory.getLocalInstance((Context)ctx).getPaymentBillCollection(entityViewInfo);
        if (collection.size() == 1) {
            String sql = "update T_IVT_FinancingAccountApply set FIsGenePayBill =0 where FID= ? ";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{sourceBillId});
        }
    }

    private void savedipose(Context ctx, CoreBaseInfo destInfo) throws EASBizException, BOSException {
        BigDecimal paymount = BigDecimal.ZERO;
        String sourceBillId = ((PaymentBillInfo)destInfo).getSourceBillId();
        FinancingAccountApplyInfo accountapplyInfo = FinancingAccountApplyFactory.getLocalInstance(ctx).getFinancingAccountApplyInfo((IObjectPK)new ObjectUuidPK(sourceBillId));
        BigDecimal finamount = accountapplyInfo.getFinanceAmount();
        Set destBillIdSet = BOTPUtil.getDestBillIdSet((Context)ctx, (String)sourceBillId);
        if (destBillIdSet.size() > 0) {
            Iterator iterator = destBillIdSet.iterator();
            while (iterator.hasNext()) {
                String destBillId = iterator.next().toString();
                if (!new PaymentBillInfo().getBOSType().equals((Object)BOSUuid.read((String)destBillId).getType())) continue;
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add("BillStatus");
                sic.add("ActPayAmt");
                PaymentBillInfo pInfo = PaymentBillFactory.getLocalInstance((Context)ctx).getPaymentBillInfo((IObjectPK)new ObjectUuidPK(destBillId), sic);
                if (pInfo.getBillStatus().equals((Object)BillStatusEnum.SAVE)) continue;
                paymount = paymount.add(pInfo.getActPayAmt());
            }
        }
        if (paymount.compareTo(finamount) == 1) {
            throw new EASBizException(new NumericExceptionSubItem("85", ResourceBase.getString((String)RESOURCE, (String)"018_OVERPAYAMOUNT", (Locale)ctx.getLocale())));
        }
        String sql = "update T_IVT_FinancingAccountApply set FIsGenePayBill =1 where FID= ? ";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{sourceBillId});
    }
}

