/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ivt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.IvtModualUtils;
import com.kingdee.eas.fm.common.IvtModuleResourceReader;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fin.FloatActionEnum;
import com.kingdee.eas.fm.fin.IntRateModifyType;
import com.kingdee.eas.fm.fin.util.FinHelper;
import com.kingdee.eas.fm.im.IntRateBaseFactory;
import com.kingdee.eas.fm.im.IntRateBaseInfo;
import com.kingdee.eas.fm.im.IntRateTypeCollection;
import com.kingdee.eas.fm.im.IntRateTypeExpressionEnum;
import com.kingdee.eas.fm.im.IntRateTypeFactory;
import com.kingdee.eas.fm.im.IntRateTypeInfo;
import com.kingdee.eas.fm.im.PenAccrualTypeEnum;
import com.kingdee.eas.fm.ivt.CHLoanException;
import com.kingdee.eas.fm.ivt.ChLoanFactory;
import com.kingdee.eas.fm.ivt.ChLoanInfo;
import com.kingdee.eas.fm.ivt.ChLoanRateAdjustBillFactory;
import com.kingdee.eas.fm.ivt.ChLoanRateAdjustBillInfo;
import com.kingdee.eas.fm.ivt.client.AbstractChLoanRateAdjustBillEditUI;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.sql.Date;
import java.text.MessageFormat;
import java.util.Map;

public class ChLoanRateAdjustBillEditUI
extends AbstractChLoanRateAdjustBillEditUI {
    public static final String RESOURCE_PATH = "com.kingdee.eas.fm.ivt.IVTAutoGenerateResource";
    private boolean successFlag;
    private IntRateTypeInfo rateTypeInfo;
    public static final IvtModuleResourceReader RESOURCE_READER = new IvtModuleResourceReader();

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        ClientUtils.checkCompany((Component)((Object)this), (CompanyOrgUnitInfo)this.currentCompany);
        this.txtRateAdjustPeriod.setHorizontalAlignment(4);
        this.txtRateAdjustPeriod.setMinimumValue((Comparable)Constants.ZERO);
        this.txtBasePoints.setPrecision(6);
        this.txtBasePoints.setHorizontalAlignment(4);
        this.txtBasePoints.setSupportedEmpty(false);
        this.txtBasePoints.setMaximumValue((Comparable)Integer.valueOf(100));
        this.txtBasePoints.setMinimumValue((Comparable)Integer.valueOf(-100));
        super.onLoad();
        this.prmtLoan.setDisplayFormat("$number$");
        this.prmtLoanCompany.setDisplayFormat("$name$");
        this.kDBizPromptBox3.setDisplayFormat("$name$");
        this.prmtLoanAccount.setDisplayFormat("$name$");
        this.prmtLoan.setEnabled(false);
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
        this.actionRemove.setEnabled(false);
        this.actionAuditResult.setVisible(false);
        this.txtRateAfterAdjt.setMinimumValue((Comparable)Constants.ZERO);
        this.txtRateAfterAdjt.setMaximumValue((Comparable)Constants.ONE_HUNDRED);
        this.txtPenaRateAfterAdj.setMinimumValue((Comparable)Constants.ZERO);
        this.txtRateAfterAdjt.setMaximumValue((Comparable)Constants.ONE_HUNDRED);
        this.dpFirstRateAdjustDate.setSupportedEmpty(false);
        this.txtRateAdjustPeriod.setHorizontalAlignment(4);
        this.txtRateAdjustPeriod.setMinimumValue((Comparable)Constants.ZERO);
        this.txtBasePoints.setPrecision(6);
        this.txtBasePoints.setHorizontalAlignment(4);
        this.txtBasePoints.setSupportedEmpty(false);
        this.txtBasePoints.setMaximumValue((Comparable)Integer.valueOf(100));
        this.txtBasePoints.setMinimumValue((Comparable)Integer.valueOf(-100));
        if (this.getOprtState().equals("ADDNEW")) {
            this.initRateExpression();
            this.initPenaType();
            this.initAdjRate();
        }
    }

    public void onShow() throws Exception {
        super.onShow();
        FMClientHelper.setFirstFocus((Component[])new Component[]{this.txtNumber, this.pkAdjustDate});
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ChLoanRateAdjustBillFactory.getRemoteInstance();
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        this.doBizCheck();
    }

    private void doBizCheck() {
        if (this.txtYearDays.getBigDecimalValue().compareTo(Constants.ZERO) <= 0) {
            MsgBox.showInfo((String)IvtModuleResourceReader.getMsg((String)"yearday_error"));
            SysUtil.abort();
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
        FMClientHelper.initNumber((CoreBaseInfo)this.editData, (KDTextField)this.txtNumber, (String)this.currentCompany.getId().toString());
        if (this.editData.getRateExpression() != null) {
            this.comboRateExpression.setSelectedItem((Object)this.editData.getRateExpression());
            this.txtRateAfterAdjt.setValue((Object)this.editData.getRateAfterAdjt());
            this.txtYearDays.setValue((Object)new Integer(this.editData.getYearDays()));
        }
        if (this.editData.getPenAccrualType() != null) {
            this.comboPenAccrualType.setSelectedItem((Object)this.editData.getPenAccrualType());
            this.txtPenaRateAfterAdj.setValue((Object)this.editData.getPenaRateAfterAdj());
        }
        if (this.editData.getLoan() != null) {
            this.prmtLoanAccount.setValue((Object)this.editData.getLoan().getLoanAccount());
            this.kDBizPromptBox3.setValue((Object)this.editData.getLoan().getDistributeAccou());
            this.prmtLoanCompany.setValue((Object)this.editData.getLoan().getLoanCompany());
        }
        if (this.editData.getModifyRateType() != null) {
            this.combModifyRateType.setSelectedItem((Object)this.editData.getModifyRateType());
        } else {
            this.combModifyRateType.setSelectedItem((Object)IntRateModifyType.LPR);
        }
        this.prmtIntRateType.setData((Object)this.editData.getIntRateType());
        if (this.editData.getFloatAction() != null) {
            this.combFloatAction.setSelectedItem((Object)this.editData.getFloatAction());
        } else {
            this.combFloatAction.setSelectedItem((Object)FloatActionEnum.LPR);
        }
        this.txtBasePoints.setValue((Object)this.editData.getBasePoints());
        if (this.editData.getFirstRateAdjustDate() != null) {
            this.dpFirstRateAdjustDate.setValue((Object)this.editData.getFirstRateAdjustDate());
        } else {
            this.dpFirstRateAdjustDate.setValue((Object)this.editData.getAdjustDate());
        }
        this.txtRateAdjustPeriod.setValue((Object)this.editData.getRateAdjustPeriod());
    }

    private SelectorItemCollection getLoanInfoSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("loanAccount.id"));
        sic.add(new SelectorItemInfo("loanAccount.name"));
        sic.add(new SelectorItemInfo("distributeAccou.id"));
        sic.add(new SelectorItemInfo("distributeAccou.name"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("loanCompany.name"));
        sic.add(new SelectorItemInfo("loanCompany.id"));
        sic.add(new SelectorItemInfo("loanCompany.number"));
        return sic;
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.checkSourceLoanIntRateType();
        super.actionSubmit_actionPerformed(e);
        this.successFlag = true;
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
        this.disposeUIWindow();
    }

    private void checkSourceLoanIntRateType() {
        if (IntRateModifyType.Agreement.equals(this.combModifyRateType.getSelectedItem()) && !"lJlpCQEQEADgAAc+wKgSjiR9knQ=".equals(this.editData.getLoan().getIntRateType().getId().toString())) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"350_LoanAdjustInterestEditUI"));
            SysUtil.abort();
        }
    }

    private IntRateTypeInfo getLprRate() throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isLPR", (Object)1, CompareType.EQUALS));
        view.setFilter(filter);
        view.setTopCount(1);
        IntRateTypeCollection rateColl = IntRateTypeFactory.getRemoteInstance().getIntRateTypeCollection(view);
        if (!EmptyUtil.isEmpty((AbstractObjectCollection)rateColl)) {
            this.rateTypeInfo = rateColl.get(0);
            return this.rateTypeInfo;
        }
        return null;
    }

    protected IObjectValue createNewData() {
        ChLoanRateAdjustBillInfo rateAdjustInfo = new ChLoanRateAdjustBillInfo();
        if (this.getUIContext().get("loanid") != null) {
            IObjectPK pk = (IObjectPK)this.getUIContext().get("loanid");
            try {
                ChLoanInfo loanInfo = ChLoanFactory.getRemoteInstance().getChLoanInfo(pk, this.getLoanInfoSelector());
                rateAdjustInfo.setLoan(loanInfo);
                rateAdjustInfo.setAdjustSeq(loanInfo.getAdjustRateTimes() + 1);
                rateAdjustInfo.setLastAdjustDate(loanInfo.getLastAdjustDate());
                rateAdjustInfo.setCurrency(loanInfo.getCurrency());
                rateAdjustInfo.setAdjustDate(DateUtil.getDayBegin());
                rateAdjustInfo.setRateExpression(IntRateTypeExpressionEnum.YEAR);
                rateAdjustInfo.setYearDays(IvtModualUtils.VALUE_360);
                rateAdjustInfo.setBasePoints(Constants.ZERO);
                rateAdjustInfo.setRateAfterAdjt(Constants.ZERO);
                rateAdjustInfo.setPenAccrualType(PenAccrualTypeEnum.ADD_PERCENT);
                rateAdjustInfo.setPenaRateAfterAdj(Constants.ZERO);
                rateAdjustInfo.setCompany(this.currentCompany);
                rateAdjustInfo.setIntRateType(this.getLprRate());
                rateAdjustInfo.setCreator(this.userinfo);
                if (rateAdjustInfo.getAdjustSeq() == 1) {
                    String msgStr = MessageFormat.format(EASResource.getString((String)RESOURCE_PATH, (String)"129_ChLoanRateAdjustBillEditUI"), loanInfo.getNumber(), rateAdjustInfo.getAdjustSeq());
                    rateAdjustInfo.setDescription(msgStr);
                } else {
                    String dataste = Constants.FORMAT_DAY.format(loanInfo.getLastAdjustDate());
                    String msgStr = MessageFormat.format(EASResource.getString((String)RESOURCE_PATH, (String)"130_ChLoanRateAdjustBillEditUI"), loanInfo.getNumber(), rateAdjustInfo.getAdjustSeq(), dataste);
                    rateAdjustInfo.setDescription(msgStr);
                }
                this.baseCurrency = loanInfo.getCurrency();
            }
            catch (Exception e) {
                ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
            }
        } else {
            rateAdjustInfo.setAdjustDate(DateUtil.getDayBegin());
            rateAdjustInfo.setRateExpression(IntRateTypeExpressionEnum.YEAR);
            rateAdjustInfo.setYearDays(IvtModualUtils.VALUE_360);
            rateAdjustInfo.setRateAfterAdjt(Constants.ZERO);
            rateAdjustInfo.setPenAccrualType(PenAccrualTypeEnum.ADD_PERCENT);
            rateAdjustInfo.setPenaRateAfterAdj(Constants.ZERO);
            rateAdjustInfo.setCompany(this.currentCompany);
        }
        return rateAdjustInfo;
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.verify();
        this.checkSourceLoanIntRateType();
        super.actionSubmit_actionPerformed(e);
        this.successFlag = true;
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
        this.disposeUIWindow();
    }

    public static void show(CoreUIObject ui, IObjectPK pk) throws EASBizException, UIException {
        if (pk == null) {
            return;
        }
        UIContext uiContext = new UIContext((Object)ui);
        uiContext.put((Object)"loanid", (Object)pk);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ChLoanRateAdjustBillEditUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        boolean flag = ((ChLoanRateAdjustBillEditUI)uiWindow.getUIObject()).getSuccessFlag();
        if (flag) {
            uiWindow.close();
        }
    }

    private boolean getSuccessFlag() {
        return false;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection select = super.getSelectors();
        select.add("*");
        select.add("loan.*");
        select.add("creator.name");
        select.add("creator.id");
        select.add("loan.distributeAccou.id");
        select.add("loan.distributeAccou.name");
        select.add("loan.loanAccount.id");
        select.add("loan.loanAccount.name");
        select.add("loan.loanCompany.id");
        select.add("loan.loanCompany.name");
        return select;
    }

    protected void setAutoNumberByOrg(String orgType) {
    }

    private void initRateExpression() {
        this.comboRateExpression.setSelectedItem((Object)IntRateTypeExpressionEnum.YEAR);
        this.contRateAfterAdjt.setBoundLabelText(IvtModuleResourceReader.getMsg((String)"rateafteradjust_per"));
        this.contBasePoints.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"589_LoanEditUI"));
    }

    private void initPenaType() {
        this.comboPenAccrualType.setSelectedItem((Object)PenAccrualTypeEnum.ADD_PERCENT);
        this.contPenaRateAfterAdj.setBoundLabelText(IvtModuleResourceReader.getMsg((String)"penarateafteradjust_per"));
    }

    public boolean verify() throws EASBizException, BOSException {
        this.storeFields();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("adjustDate", (Object)this.editData.getAdjustDate()));
        filter.getFilterItems().add(new FilterItemInfo("loan.id", (Object)this.editData.getLoan().getId()));
        filter.getFilterItems().add(new FilterItemInfo("adjustSeq", (Object)String.valueOf(this.editData.getAdjustSeq()), CompareType.NOTEQUALS));
        if (ChLoanRateAdjustBillFactory.getRemoteInstance().exists(filter)) {
            throw new CHLoanException(CHLoanException.SUBMITDUMP, new Object[]{this.editData.getLoan().getNumber(), FMHelper.formateDate((java.util.Date)this.editData.getAdjustDate())});
        }
        Date firstRateAdjustDate = this.dpFirstRateAdjustDate.getSqlDate();
        Date adjustDate = this.pkAdjustDate.getSqlDate();
        IntRateModifyType intRateModifyType = (IntRateModifyType)this.combModifyRateType.getSelectedItem();
        IntRateTypeInfo intRateType = (IntRateTypeInfo)this.prmtIntRateType.getData();
        if (intRateModifyType.equals((Object)IntRateModifyType.LPR) && !this.isFixedInterest(intRateType) && adjustDate.getTime() > firstRateAdjustDate.getTime()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"349_LoanAdjustInterestEditUI"));
            SysUtil.abort();
        }
        return true;
    }

    @Override
    protected void combModifyRateType_itemStateChanged(ItemEvent e) throws Exception {
        IntRateTypeInfo intRateType = (IntRateTypeInfo)this.prmtIntRateType.getData();
        IntRateModifyType intRateModifyType = (IntRateModifyType)this.combModifyRateType.getSelectedItem();
        if (IntRateModifyType.Agreement.equals((Object)intRateModifyType)) {
            this.contIntRateType.setVisible(false);
            this.prmtIntRateType.setRequired(false);
            this.prmtIntRateType.setData(null);
            this.contFloatAction.setVisible(false);
            this.combFloatAction.setSelectedItem(null);
            this.contBasePoints.setVisible(false);
            this.txtBasePoints.setText(null);
            this.contFirstRateAdjustDate.setVisible(false);
            this.dpFirstRateAdjustDate.setValue(null);
            this.contRateAdjustPeriod.setVisible(false);
            this.txtRateAdjustPeriod.setValue((Object)Constants.ZERO);
            this.contMonth.setVisible(false);
            this.comboRateExpression.setEnabled(true);
            this.comboRateExpression.setSelectedItem((Object)IntRateTypeExpressionEnum.YEAR);
            this.txtYearDays.setEnabled(true);
            this.txtYearDays.setText("360");
            this.txtRateAfterAdjt.setEnabled(true);
            this.txtRateAfterAdjt.setValue((Object)Constants.ZERO);
            this.prmtModifyRateHide(true);
        } else {
            this.contIntRateType.setVisible(true);
            this.prmtIntRateType.setRequired(true);
            this.prmtIntRateType.setData((Object)this.rateTypeInfo);
            FilterInfo filter = new FilterInfo();
            EntityViewInfo evi = new EntityViewInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)"AgreementRate", CompareType.NOTEQUALS));
            filter.getFilterItems().add(new FilterItemInfo("isLPR", (Object)1, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)"QYYAAAAKQTYkfZJ0", CompareType.EQUALS));
            filter.setMaskString("(#0 and #1) or #2");
            evi.setFilter(filter);
            this.prmtIntRateType.setEntityViewInfo(evi);
            this.prmtIntRateType.getQueryAgent().resetRuntimeEntityView();
            if (this.isFixedInterest(intRateType)) {
                this.txtYearDays.setEnabled(false);
                this.contBasePoints.setVisible(true);
                this.comboRateExpression.setEnabled(false);
            } else {
                this.contFloatAction.setVisible(true);
                this.combFloatAction.setEnabled(false);
                this.combFloatAction.setSelectedItem((Object)FloatActionEnum.LPR);
                this.contBasePoints.setVisible(true);
                this.txtBasePoints.setRequired(true);
                this.txtBasePoints.setValue((Object)Constants.ZERO);
                this.contFirstRateAdjustDate.setVisible(true);
                this.dpFirstRateAdjustDate.setValue((Object)this.pkAdjustDate.getSqlDate());
                this.contRateAdjustPeriod.setVisible(true);
                this.txtRateAdjustPeriod.setValue((Object)Constants.ZERO);
                this.contMonth.setVisible(true);
                this.comboRateExpression.setEnabled(false);
            }
            this.prmtModifyRateHide(false);
        }
    }

    @Override
    protected void prmtIntRateType_dataChanged(DataChangeEvent e) throws Exception {
        IntRateTypeInfo intRateType = (IntRateTypeInfo)this.prmtIntRateType.getData();
        IntRateModifyType intRateModifyType = (IntRateModifyType)this.combModifyRateType.getSelectedItem();
        if (IntRateModifyType.Agreement.equals((Object)intRateModifyType) || this.isFixedInterest(intRateType)) {
            this.contFloatAction.setVisible(false);
            this.combFloatAction.setSelectedIndex(-1);
            this.comboRateExpression.setEnabled(true);
            this.txtYearDays.setEnabled(true);
            this.txtYearDays.setText("360");
            this.txtRateAfterAdjt.setEnabled(true);
            this.txtRateAfterAdjt.setValue((Object)Constants.ZERO);
            this.contBasePoints.setVisible(false);
            this.txtBasePoints.setValue((Object)Constants.ZERO);
            this.contFirstRateAdjustDate.setVisible(false);
            this.dpFirstRateAdjustDate.setValue(null);
            this.contRateAdjustPeriod.setVisible(false);
            this.txtRateAdjustPeriod.setValue((Object)Constants.ZERO);
            this.contMonth.setVisible(false);
            if (this.isFixedInterest(intRateType)) {
                this.prmtIntRateTypeHide(true);
            }
        } else if (IntRateModifyType.LPR.equals((Object)intRateModifyType) && !this.isFixedInterest(intRateType)) {
            this.prmtIntRateTypeHide(false);
            this.contFloatAction.setVisible(true);
            this.combFloatAction.setSelectedItem((Object)FloatActionEnum.LPR);
            this.combFloatAction.setEnabled(false);
            this.contBasePoints.setVisible(true);
            this.txtBasePoints.setValue((Object)Constants.ZERO);
            this.contFirstRateAdjustDate.setVisible(true);
            this.dpFirstRateAdjustDate.setValue((Object)this.pkAdjustDate.getSqlDate());
            this.contRateAdjustPeriod.setVisible(true);
            this.txtRateAdjustPeriod.setValue((Object)FinHelper.ZERO_INT);
            this.contMonth.setVisible(true);
            this.comboRateExpression.setEnabled(false);
            this.txtYearDays.setEnabled(false);
            this.txtRateAfterAdjt.setEnabled(false);
            this.txtRateAfterAdjt.setValue((Object)this.getYieldRate(intRateType, (FloatActionEnum)this.combFloatAction.getSelectedItem()));
            if (intRateType != null) {
                int intRate = intRateType.getFactorDay();
                String RateExpreValue = intRateType.getRateExpression().getValue();
                if (RateExpreValue.equals("year")) {
                    this.comboRateExpression.setSelectedItem((Object)IntRateTypeExpressionEnum.YEAR);
                    this.contRateAfterAdjt.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"257_LoanAdjustInterestEditUI"));
                    this.contBasePoints.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"589_LoanEditUI"));
                } else if (RateExpreValue.equals("month")) {
                    this.comboRateExpression.setSelectedItem((Object)IntRateTypeExpressionEnum.MONTH);
                    this.contRateAfterAdjt.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"258_LoanAdjustInterestEditUI"));
                    this.contBasePoints.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"590_LoanEditUI"));
                } else {
                    this.comboRateExpression.setSelectedItem((Object)IntRateTypeExpressionEnum.DAY);
                    this.contRateAfterAdjt.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"258_LoanAdjustInterestEditUI"));
                    this.contBasePoints.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"590_LoanEditUI"));
                }
                this.txtYearDays.setValue((Object)new Integer(intRate));
            }
        }
    }

    @Override
    protected void pkAdjustDate_dataChanged(DataChangeEvent e) throws Exception {
        this.dpFirstRateAdjustDate.setValue((Object)this.pkAdjustDate.getSqlDate());
        this.initAdjRate();
    }

    @Override
    protected void dpFirstRateAdjustDate_dataChanged(DataChangeEvent e) throws Exception {
        java.util.Date firstRateAdjDate = (java.util.Date)this.dpFirstRateAdjustDate.getValue();
        java.util.Date adjDate = (java.util.Date)this.pkAdjustDate.getValue();
        if (firstRateAdjDate != null && adjDate != null && firstRateAdjDate.getTime() < adjDate.getTime()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"351_LoanAdjustInterestEditUI"));
            this.dpFirstRateAdjustDate.setValue((Object)adjDate);
            SysUtil.abort();
        }
    }

    private void initAdjRate() throws EASBizException, BOSException {
        IntRateTypeInfo intRateType = (IntRateTypeInfo)this.prmtIntRateType.getData();
        if (intRateType == null) {
            this.txtRateAfterAdjt.setValue((Object)new BigDecimal(String.valueOf(0)));
        } else if (this.isXUEXILILV(intRateType)) {
            this.txtRateAfterAdjt.setValue((Object)new BigDecimal(String.valueOf(0)));
        } else {
            this.txtRateAfterAdjt.setValue((Object)this.getYieldRate(intRateType, (FloatActionEnum)this.combFloatAction.getSelectedItem()));
        }
    }

    protected boolean isXUEXILILV(IntRateTypeInfo intRateType) {
        return intRateType.getId().toString().equals("lJlpCQEQEADgAAc+wKgSjiR9knQ=") || intRateType.getId().toString().equals("QYYAAAAKQTYkfZJ0");
    }

    protected void comboRateExpression_itemStateChanged(ItemEvent e) throws Exception {
        IntRateTypeExpressionEnum intRateTypeExpress = (IntRateTypeExpressionEnum)this.comboRateExpression.getSelectedItem();
        if (intRateTypeExpress.equals((Object)IntRateTypeExpressionEnum.YEAR)) {
            this.txtYearDays.setText("360");
            this.contBasePoints.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"589_LoanEditUI"));
        } else if (intRateTypeExpress.equals((Object)IntRateTypeExpressionEnum.MONTH)) {
            this.txtYearDays.setText("30");
            this.contBasePoints.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"590_LoanEditUI"));
        } else if (intRateTypeExpress.equals((Object)IntRateTypeExpressionEnum.DAY)) {
            this.txtYearDays.setText("1");
            this.contBasePoints.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"590_LoanEditUI"));
        }
    }

    @Override
    protected void txtBasePoints_dataChanged(DataChangeEvent e) throws Exception {
        IntRateTypeInfo intRateType = (IntRateTypeInfo)this.prmtIntRateType.getData();
        IntRateModifyType intRateModifyType = (IntRateModifyType)this.combModifyRateType.getSelectedItem();
        if (IntRateModifyType.LPR.equals((Object)intRateModifyType) && !this.isFixedInterest(intRateType) || IntRateModifyType.LPR_Adjustment.equals((Object)intRateModifyType)) {
            BigDecimal yieldRate = this.getYieldRate(intRateType, (FloatActionEnum)this.combFloatAction.getSelectedItem());
            this.txtRateAfterAdjt.setValue((Object)yieldRate);
            this.txtRateAfterAdjt.setEnabled(false);
        }
    }

    private BigDecimal getYieldRate(IntRateTypeInfo intRateType, FloatActionEnum floatAction) throws BOSException, EASBizException {
        java.util.Date date = DateTimeUtils.truncateDate((java.util.Date)this.pkAdjustDate.getSqlDate());
        BigDecimal bdBP = this.txtBasePoints.getBigDecimalValue();
        if (this.baseCurrency != null && intRateType != null && date != null && bdBP != null) {
            IntRateBaseInfo intRateBase = IntRateBaseFactory.getRemoteInstance().getCurRateByCond(intRateType.getId().toString(), this.baseCurrency.getId().toString(), date);
            BigDecimal bdBaseRate = null;
            bdBaseRate = intRateBase != null ? intRateBase.getYearRate() : Constants.ZERO;
            BigDecimal bdYieldRate = Constants.ZERO;
            bdYieldRate = floatAction.equals((Object)FloatActionEnum.BASEINTRATE_FLOAT) ? bdBaseRate.multiply(new BigDecimal(String.valueOf(1)).add(bdBP.divide(Constants.ONE_HUNDRED, 10, 4))) : bdBaseRate.add(bdBP);
            if (bdYieldRate.compareTo(Constants.ZERO) < 0) {
                MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"283_LoanEditUI"));
                this.txtBasePoints.requestFocus();
                SysUtil.abort();
            }
            return bdYieldRate;
        }
        return Constants.ZERO;
    }

    private boolean isFixedInterest(IntRateTypeInfo intRateType) {
        if (intRateType == null) {
            return false;
        }
        return intRateType.getId().toString().equals("QYYAAAAKQTYkfZJ0");
    }

    private void prmtIntRateTypeHide(boolean isHide) {
        if (!isHide) {
            super.add((Component)this.contYearDays, (Object)new KDLayout.Constraints(10, 163, 270, 19, 261));
            super.add((Component)this.contPenAccrualType, (Object)new KDLayout.Constraints(9, 187, 270, 19, 261));
            this.contDescription.setBounds(new Rectangle(9, 207, 588, 19));
            this.add((Component)this.contDescription, new KDLayout.Constraints(9, 207, 588, 19, 13));
            this.add((Component)this.contCreator, new KDLayout.Constraints(9, 227, 270, 19, 261));
            this.add((Component)this.contRateExpression, new KDLayout.Constraints(290, 140, 307, 19, 137));
            this.add((Component)this.contRateAfterAdjt, new KDLayout.Constraints(290, 163, 307, 19, 137));
            this.add((Component)this.contPenaRateAfterAdj, new KDLayout.Constraints(290, 187, 307, 19, 137));
            this.add((Component)this.contCompany, new KDLayout.Constraints(290, 227, 307, 19, 137));
        }
    }

    private void prmtModifyRateHide(boolean isHide) {
        if (isHide) {
            super.add((Component)this.contYearDays, (Object)new KDLayout.Constraints(10, 93, 270, 19, 261));
            super.add((Component)this.contPenAccrualType, (Object)new KDLayout.Constraints(9, 117, 270, 19, 261));
            this.contDescription.setBounds(new Rectangle(9, 137, 588, 19));
            this.add((Component)this.contDescription, new KDLayout.Constraints(9, 157, 588, 19, 13));
            this.add((Component)this.contCreator, new KDLayout.Constraints(9, 177, 270, 19, 261));
            this.add((Component)this.contRateExpression, new KDLayout.Constraints(290, 93, 307, 19, 137));
            this.add((Component)this.contRateAfterAdjt, new KDLayout.Constraints(290, 117, 307, 19, 137));
            this.add((Component)this.contPenaRateAfterAdj, new KDLayout.Constraints(290, 137, 307, 19, 137));
            this.add((Component)this.contCompany, new KDLayout.Constraints(290, 177, 307, 19, 137));
        } else {
            super.add((Component)this.contYearDays, (Object)new KDLayout.Constraints(10, 163, 270, 19, 261));
            super.add((Component)this.contPenAccrualType, (Object)new KDLayout.Constraints(9, 187, 270, 19, 261));
            this.contDescription.setBounds(new Rectangle(9, 207, 588, 19));
            this.add((Component)this.contDescription, new KDLayout.Constraints(9, 207, 588, 19, 13));
            this.add((Component)this.contCreator, new KDLayout.Constraints(9, 227, 270, 19, 261));
            this.add((Component)this.contRateExpression, new KDLayout.Constraints(290, 140, 307, 19, 137));
            this.add((Component)this.contRateAfterAdjt, new KDLayout.Constraints(290, 163, 307, 19, 137));
            this.add((Component)this.contPenaRateAfterAdj, new KDLayout.Constraints(290, 187, 307, 19, 137));
            this.add((Component)this.contCompany, new KDLayout.Constraints(290, 227, 307, 19, 137));
        }
    }

    @Override
    protected void prmtIntRateType_willShow(SelectorEvent e) throws Exception {
        IntRateModifyType intRateModifyType;
        if (this.combModifyRateType.getSelectedItem() != null && (intRateModifyType = (IntRateModifyType)this.combModifyRateType.getSelectedItem()).equals((Object)IntRateModifyType.LPR)) {
            FilterInfo filter = new FilterInfo();
            EntityViewInfo evi = new EntityViewInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)"AgreementRate", CompareType.NOTEQUALS));
            filter.getFilterItems().add(new FilterItemInfo("isLPR", (Object)1, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)"QYYAAAAKQTYkfZJ0", CompareType.EQUALS));
            filter.setMaskString("(#0 and #1) or #2");
            evi.setFilter(filter);
            this.prmtIntRateType.setEntityViewInfo(evi);
            this.prmtIntRateType.getQueryAgent().resetRuntimeEntityView();
        }
    }
}

