/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ivt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.client.F7SelectorFactory;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.ivt.IvtBillStatusEnum;
import com.kingdee.eas.fm.ivt.client.AbstractEntRepaymentBillFilterUI;
import com.kingdee.eas.fm.ivt.client.EntRepaymentBillParam;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.Logger;

public class EntRepaymentBillFilterUI
extends AbstractEntRepaymentBillFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(EntRepaymentBillFilterUI.class);
    private boolean isBOTP;

    public EntRepaymentBillFilterUI(boolean isBOTP) throws Exception {
        this.isBOTP = isBOTP;
    }

    protected void init() throws Exception {
        super.init();
        this.dpStartDate.setSupportedEmpty(false);
        this.dpEndDate.setSupportedEmpty(false);
        this.customInit();
        this.prmtLoanCompany.setSelector((KDPromptSelector)F7SelectorFactory.getSelectCompany((IUIObject)this, null, null, (boolean)true));
    }

    private void customInit() {
        this.prmtLoanCompany.setValue(null);
        this.bySubmit.setSelected(true);
        this.initDate();
        this.initCurrency();
    }

    private void initDate() {
        Date now = new Date();
        this.dpStartDate.setValue((Object)this.getStartDate(now));
        this.dpEndDate.setValue((Object)now);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.dpStartDate.setSupportedEmpty(false);
        this.dpEndDate.setSupportedEmpty(false);
    }

    private Date getStartDate(Date now) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(now);
        calendar.set(5, 1);
        return calendar.getTime();
    }

    private void initCurrency() {
        CashHelper.initCombCurrency((KDComboBox)this.comboCurrency, (boolean)false);
        this.comboCurrency.addItem((Object)FMSysDefinedEnum.ALL_ITEMS);
    }

    public Object getParam() {
        Object obj;
        EntRepaymentBillParam entRepaymentBillFilterParam = new EntRepaymentBillParam();
        if (null != this.dpStartDate.getValue()) {
            entRepaymentBillFilterParam.setStartDate(DateTimeUtils.truncateDate((Date)((Date)this.dpStartDate.getValue())));
        }
        if (null != this.dpEndDate.getValue()) {
            entRepaymentBillFilterParam.setEndDate(DateTimeUtils.truncateDate((Date)((Date)this.dpEndDate.getValue())));
        }
        if (null != this.comboCurrency.getSelectedItem() && (obj = this.comboCurrency.getSelectedItem()) instanceof CurrencyInfo) {
            entRepaymentBillFilterParam.setCurrencyInfo((CurrencyInfo)this.comboCurrency.getSelectedItem());
        }
        if (null != this.prmtLoanCompany.getValue()) {
            entRepaymentBillFilterParam.setLoanCompany(AccessHelper.getF7Ids((KDBizPromptBox)this.prmtLoanCompany));
        }
        entRepaymentBillFilterParam.setBOTP(this.isBOTP);
        if (this.bySubmit.isSelected()) {
            entRepaymentBillFilterParam.setStatus(IvtBillStatusEnum.SUBMIT);
        } else if (this.byAudit.isSelected()) {
            entRepaymentBillFilterParam.setStatus(IvtBillStatusEnum.AUDIT);
        } else if (this.byBook.isSelected()) {
            entRepaymentBillFilterParam.setStatus(IvtBillStatusEnum.BOOK);
        } else {
            entRepaymentBillFilterParam.setStatus(null);
        }
        return entRepaymentBillFilterParam;
    }

    protected Class getParamClass() {
        return EntRepaymentBillParam.class;
    }

    protected boolean isNeedEachSerializable() {
        return false;
    }

    public void setParam(Object param) {
        if (null == param || !(param instanceof EntRepaymentBillParam)) {
            return;
        }
        EntRepaymentBillParam filterParam = (EntRepaymentBillParam)param;
        this.dpStartDate.setValue((Object)filterParam.getStartDate());
        this.dpEndDate.setValue((Object)filterParam.getEndDate());
        if (filterParam.getCurrencyInfo() != null) {
            FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)filterParam.getCurrencyInfo());
        } else {
            FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)FMSysDefinedEnum.ALL_ITEMS);
        }
        try {
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            String[] loanCompany = filterParam.getLoanCompany();
            if (loanCompany != null && loanCompany.length > 0 && FMHelper.asSet((String[])loanCompany) != null) {
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)FMHelper.asSet((String[])loanCompany), CompareType.INCLUDE));
                ev.setFilter(filter);
                CompanyOrgUnitCollection com = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(ev);
                this.prmtLoanCompany.setValue((Object)com.toArray());
            } else {
                this.prmtLoanCompany.setValue(null);
            }
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
        if (filterParam.getStatus() == null) {
            this.byAll.setSelected(true);
        } else if (filterParam.getStatus() == IvtBillStatusEnum.SUBMIT) {
            this.bySubmit.setSelected(true);
        } else if (filterParam.getStatus() == IvtBillStatusEnum.AUDIT) {
            this.byAudit.setSelected(true);
        } else if (filterParam.getStatus() == IvtBillStatusEnum.BOOK) {
            this.byBook.setSelected(true);
        }
    }

    public boolean verify() {
        if (DateTimeUtils.truncateDate((Date)((Date)this.dpStartDate.getValue())).after(DateTimeUtils.truncateDate((Date)((Date)this.dpEndDate.getValue())))) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.CHLoanResource", (String)"enddate_error"));
            Date d = new Date();
            this.dpStartDate.setValue((Object)this.getStartDate(d));
            this.dpStartDate.setFocusable(true);
            SysUtil.abort();
        }
        return true;
    }

    public void clear() {
        super.clear();
        this.customInit();
    }
}

