/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ivt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.multiapprove.client.MultiApproveUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.client.CasRecPayHandler;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.ConvertUtils;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMCommonSortedDataProvider;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.common.client.MutexUtils;
import com.kingdee.eas.fm.common.util.FMARAPUtil;
import com.kingdee.eas.fm.ivt.FinancingAccountCollection;
import com.kingdee.eas.fm.ivt.FinancingAccountFactory;
import com.kingdee.eas.fm.ivt.FinancingAccountInfo;
import com.kingdee.eas.fm.ivt.FinancingRedeemCollection;
import com.kingdee.eas.fm.ivt.FinancingRedeemFactory;
import com.kingdee.eas.fm.ivt.FinancingRedeemInfo;
import com.kingdee.eas.fm.ivt.FinancingStateEnum;
import com.kingdee.eas.fm.ivt.IFinancingAccount;
import com.kingdee.eas.fm.ivt.client.AbstractFinancingAccountListUI;
import com.kingdee.eas.fm.ivt.client.FinancingAccountEditUI;
import com.kingdee.eas.fm.ivt.client.FinancingAccountFilterUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreBillListUI;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class FinancingAccountListUI
extends AbstractFinancingAccountListUI {
    private static final Logger logger = CoreUIObject.getLogger(FinancingAccountListUI.class);
    private String[] amountFields = new String[]{"saleSize", "financeAmount", "predictWinAmount", "SumRedeemAmount"};
    FMFilterBaseUI filterUI = null;
    protected static final String IVT_RES = "com.kingdee.eas.fm.ivt.IVTFINANCINGResource";
    private static final String FMIVT_RESOURCE_PATH = "com.kingdee.eas.fm.ivt.IVTFINANCINGResource";
    FillListener fillListener = new FillListener();

    public void onLoad() throws Exception {
        IContextHelper ctxHelper;
        int val;
        super.onLoad();
        this.actionUnAudit.setEnabled(true);
        this.btnunaudit.setEnabled(true);
        this.btnUnClose.setEnabled(true);
        this.actionCreateTo.setVisible(false);
        this.actionWorkFlowG.setVisible(true);
        this.actionAuditResult.setVisible(false);
        this.actionTraceUp.setVisible(true);
        this.actionTraceDown.setVisible(true);
        this.menuWorkFlow.setVisible(false);
        this.actionCopyTo.setVisible(false);
        this.actionCopy.setVisible(true);
        this.actionCopy.setEnabled(true);
        this.menuItemUnClose.setEnabled(true);
        if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.currentCompanyCommon)) {
            this.actionDelVoucher.setVisible(false);
            this.actionVoucher.setVisible(false);
            this.actionEdit.setVisible(false);
            this.actionRemove.setVisible(false);
            this.actionViewBdgBalance.setVisible(false);
            this.actionAttachment.setVisible(false);
            this.actionAuditResult.setVisible(false);
            this.actionAddNew.setVisible(false);
            this.actionCopy.setVisible(false);
            this.actionClose.setVisible(false);
            this.actionUnClose.setVisible(false);
        }
        boolean isBillBook = (val = (ctxHelper = ContextHelperFactory.getRemoteInstance()).getIntParam("CS001", (IObjectPK)new ObjectUuidPK(ctxHelper.getCurrentCompany().getId()))) == 0;
        this.actionBook.setEnabled(isBillBook);
        this.tblMain.getColumn("beginDate").getStyleAttributes().setNumberFormat(this.dformat);
        this.tblMain.getColumn("endDate").getStyleAttributes().setNumberFormat(this.dformat);
        this.tblMain.getColumn("changeDate").getStyleAttributes().setNumberFormat(this.dformat);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionCopy.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_copy"));
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private void setListUITablePrecision(int start, int end) {
        for (int i = start; i <= end; ++i) {
            IRow row = this.tblMain.getRow(i);
            int precision = 2;
            ICell cell = row.getCell("currency.precision");
            if (cell != null && cell.getValue() != null) {
                precision = Integer.parseInt(cell.getValue().toString());
            }
            for (int j = 0; j < this.amountFields.length; ++j) {
                FMARAPUtil.setPrecision((ICell)row.getCell(this.amountFields[j]), (int)precision);
            }
            int prec = CasRecPayHandler.getExRatePrec((String)row.getCell("currency.id").getValue().toString(), null, (CompanyOrgUnitInfo)ContextHelperFactory.getRemoteInstance().getCurrentCompany(), (Date)((Date)row.getCell("bizDate").getValue()));
            FMARAPUtil.setPrecision((ICell)row.getCell("exchangeRate"), (int)prec);
            FMARAPUtil.setPrecision((ICell)row.getCell("practicalWinAmount"), (int)2);
            FMARAPUtil.setPrecision((ICell)row.getCell("predictYield"), (int)3);
            FMARAPUtil.setPrecision((ICell)row.getCell("balance"), (int)precision);
            FMARAPUtil.setPrecision((ICell)row.getCell("financeLocAmount"), (int)precision);
            FMARAPUtil.setPrecision((ICell)row.getCell("SumRedeemAmount"), (int)precision);
            FMARAPUtil.setPrecision((ICell)row.getCell("practicalWinLocAmount"), (int)precision);
        }
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.getDataRequestManager().addDataFillListener((KDTDataFillListener)this.fillListener);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("changeDate"));
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("balance"));
        FinancingAccountInfo finAccountInfo = FinancingAccountFactory.getRemoteInstance().getFinancingAccountInfo((IObjectPK)new ObjectUuidPK(this.getSelectedKeyValue()), sic);
        if (finAccountInfo.getBalance().compareTo(Constants.ZERO) == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"135_CanNotEdit"));
            SysUtil.abort();
        }
        if (finAccountInfo.getState() == FinancingStateEnum.CLOSE) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"83_FinancingAccountEditUI"));
            SysUtil.abort();
        }
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        int i;
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        ArrayList<String> lst = new ArrayList<String>();
        IFinancingAccount fai = (IFinancingAccount)this.getBizInterface();
        StringBuffer str = new StringBuffer();
        if (idList != null && idList.size() > 0) {
            for (i = 0; i < idList.size(); ++i) {
                String id = (String)idList.get(i);
                FinancingAccountInfo info = fai.getFinancingAccountInfo((IObjectPK)new ObjectUuidPK(id));
                if (info.getState() == FinancingStateEnum.CLOSE) {
                    str.append(EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"84_FinancingAccountEditUI", (Object[])new String[]{info.getNumber()}));
                    str.append("\r\n");
                    continue;
                }
                if (info.getState() == FinancingStateEnum.AUDIT) {
                    str.append(EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"134_FinancingAccountListUI", (Object[])new String[]{info.getNumber()}));
                    str.append("\r\n");
                    continue;
                }
                lst.add(id);
            }
        }
        if (MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Delete")))) {
            if (lst.size() != 0) {
                for (i = 0; i < lst.size(); ++i) {
                    String pk = lst.get(i).toString();
                    fai.delete((IObjectPK)new ObjectUuidPK(pk));
                }
            }
        } else {
            return;
        }
        if (str.length() > 0) {
            MsgBox.showDetailAndOK(null, (String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTFINANCINGResource", (String)"009_DELETE_RESULT", (Object[])new String[]{String.valueOf(lst.size()), String.valueOf(idList.size() - lst.size())}), (String)str.toString(), (int)1);
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTFINANCINGResource", (String)"010_DELETE_SUCCESS"));
        }
        this.refreshList();
    }

    @Override
    public void actionClose_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        if (idList == null || idList.size() <= 0) {
            return;
        }
        ArrayList<String> lst = new ArrayList<String>();
        String userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        IFinancingAccount finaccount = (IFinancingAccount)this.getBizInterface();
        StringBuffer str = new StringBuffer();
        if (idList != null && idList.size() > 0) {
            for (int i = 0; i < idList.size(); ++i) {
                String id = (String)idList.get(i);
                boolean hasWf = FMHelper.hasWFInstance(null, (String)id);
                if (hasWf) {
                    MultiApproveUtil.multiapproveBills((CoreUIObject)this, (String)userID, (String[])new String[]{id});
                    continue;
                }
                FinancingAccountInfo info = finaccount.getFinancingAccountInfo((IObjectPK)new ObjectUuidPK(id));
                if (!FinancingStateEnum.AUDIT.equals((Object)info.getState())) {
                    str.append(EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTFINANCINGResource", (String)"039_CLOSE_ERROR", (Object[])new String[]{info.getNumber()}));
                    str.append("\r\n");
                    continue;
                }
                if (info.isIsNoOut()) {
                    str.append(EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTFINANCINGResource", (String)"040_CLOSE_ERROR", (Object[])new String[]{info.getNumber()}));
                    str.append("\r\n");
                    continue;
                }
                lst.add(id);
            }
        }
        if (lst.size() != 0) {
            HashSet idSet = new HashSet(lst);
            finaccount.batchClose(idSet);
        }
        if (str.length() > 0) {
            MsgBox.showDetailAndOK(null, (String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTFINANCINGResource", (String)"013_CLOSE_RESULT", (Object[])new String[]{String.valueOf(lst.size()), String.valueOf(idList.size() - lst.size())}), (String)str.toString(), (int)1);
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTFINANCINGResource", (String)"014_CLOSE_SUCCESS"));
        }
        this.refreshList();
    }

    @Override
    public void actionUnClose_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        if (idList == null || idList.size() <= 0) {
            return;
        }
        ArrayList<String> lst = new ArrayList<String>();
        String userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        IFinancingAccount finaccount = (IFinancingAccount)this.getBizInterface();
        StringBuffer str = new StringBuffer();
        if (idList != null && idList.size() > 0) {
            for (int i = 0; i < idList.size(); ++i) {
                String id = (String)idList.get(i);
                boolean hasWf = FMHelper.hasWFInstance(null, (String)id);
                if (hasWf) {
                    MultiApproveUtil.multiapproveBills((CoreUIObject)this, (String)userID, (String[])new String[]{id});
                    continue;
                }
                FinancingAccountInfo info = finaccount.getFinancingAccountInfo((IObjectPK)new ObjectUuidPK(id));
                if (!FinancingStateEnum.CLOSE.equals((Object)info.getState())) {
                    str.append(EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTFINANCINGResource", (String)"020_CLOSE_ERROR", (Object[])new String[]{info.getNumber()}));
                    str.append("\r\n");
                    continue;
                }
                if (info.isIsNoOut()) {
                    str.append(EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTFINANCINGResource", (String)"021_CLOSE_ERROR", (Object[])new String[]{info.getNumber()}));
                    str.append("\r\n");
                    continue;
                }
                if (info.getBalance().compareTo(Constants.ZERO) == 0) {
                    str.append(EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTFINANCINGResource", (String)"022_CLOSE_ERROR", (Object[])new String[]{info.getNumber()}));
                    str.append("\r\n");
                    continue;
                }
                lst.add(id);
            }
        }
        if (lst.size() != 0) {
            HashSet idSet = new HashSet(lst);
            finaccount.batchUnClose(idSet);
        }
        if (str.length() > 0) {
            MsgBox.showDetailAndOK(null, (String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTFINANCINGResource", (String)"015_UNCLOSE_RESULT", (Object[])new String[]{String.valueOf(lst.size()), String.valueOf(idList.size() - lst.size())}), (String)str.toString(), (int)1);
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTFINANCINGResource", (String)"016_UNCLOSE_SUCCESS"));
        }
        this.refreshList();
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        if (idList == null || idList.size() <= 0) {
            return;
        }
        ArrayList<String> lst = new ArrayList<String>();
        String userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        IFinancingAccount finaccount = (IFinancingAccount)this.getBizInterface();
        StringBuffer str = new StringBuffer();
        if (idList != null && idList.size() > 0) {
            for (int i = 0; i < idList.size(); ++i) {
                String id = (String)idList.get(i);
                FinancingAccountInfo info = finaccount.getFinancingAccountInfo((IObjectPK)new ObjectUuidPK(id));
                if (!FinancingStateEnum.SUBMIT.equals((Object)info.getState())) {
                    str.append(EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTFINANCINGResource", (String)"023_AUDIT_ERRO", (Object[])new String[]{info.getNumber()}));
                    str.append("\r\n");
                    continue;
                }
                lst.add(id);
            }
        }
        if (lst.size() != 0) {
            HashSet idSet = new HashSet(lst);
            finaccount.batchAudit(idSet);
        }
        if (str.length() > 0) {
            MsgBox.showDetailAndOK(null, (String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTFINANCINGResource", (String)"005_AUDIT_RESULT", (Object[])new String[]{String.valueOf(lst.size()), String.valueOf(idList.size() - lst.size())}), (String)str.toString(), (int)1);
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTFINANCINGResource", (String)"006_AUDIT_SUCCESS"));
        }
        this.refreshList();
    }

    @Override
    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        if (idList == null || idList.size() <= 0) {
            return;
        }
        ArrayList<String> lst = new ArrayList<String>();
        String userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        IFinancingAccount finaccount = (IFinancingAccount)this.getBizInterface();
        StringBuffer str = new StringBuffer();
        if (idList != null && idList.size() > 0) {
            for (int i = 0; i < idList.size(); ++i) {
                String id = (String)idList.get(i);
                FinancingAccountInfo info = finaccount.getFinancingAccountInfo((IObjectPK)new ObjectUuidPK(id));
                if (!FinancingStateEnum.AUDIT.equals((Object)info.getState())) {
                    str.append(EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTFINANCINGResource", (String)"024_UNAUDIT_ERRO", (Object[])new String[]{info.getNumber()}));
                    str.append("\r\n");
                    continue;
                }
                if (info.isIsBook()) {
                    str.append(EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTFINANCINGResource", (String)"025_UNAUDIT_ERRO", (Object[])new String[]{info.getNumber()}));
                    str.append("\r\n");
                    continue;
                }
                if (info.isIsGenePayBill()) {
                    str.append(EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTFINANCINGResource", (String)"026_UNAUDIT_ERRO", (Object[])new String[]{info.getNumber()}));
                    str.append("\r\n");
                    continue;
                }
                if (this.checkRedeem(info)) {
                    str.append(EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTFINANCINGResource", (String)"027_UNAUDIT_ERRO", (Object[])new String[]{info.getNumber()}));
                    str.append("\r\n");
                    continue;
                }
                if (info.isFiVouchered()) {
                    str.append(EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTFINANCINGResource", (String)"083_UNAUDIT_ERRO", (Object[])new String[]{info.getNumber()}));
                    str.append("\r\n");
                    continue;
                }
                lst.add(id);
            }
        }
        if (lst.size() != 0) {
            HashSet idSet = new HashSet(lst);
            finaccount.batchUnAudit(idSet);
        }
        if (str.length() > 0) {
            MsgBox.showDetailAndOK(null, (String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTFINANCINGResource", (String)"007_UNAUDIT_RESULT", (Object[])new String[]{String.valueOf(lst.size()), String.valueOf(idList.size() - lst.size())}), (String)str.toString(), (int)1);
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTFINANCINGResource", (String)"008_UNAUDIT_SUCCESS"));
        }
        this.refreshList();
    }

    private boolean checkRedeem(FinancingAccountInfo info) {
        boolean Isredem = false;
        try {
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("sourceBillId", (Object)info.getId().toString()));
            entityViewInfo.setFilter(filter);
            FinancingRedeemCollection collection = FinancingRedeemFactory.getRemoteInstance().getFinancingRedeemCollection(entityViewInfo);
            if (collection.size() > 0) {
                Isredem = true;
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return Isredem;
    }

    private void showMsg(ActionEvent e) throws Exception {
        this.refresh(e);
        FMClientHelper.showSuccessMessage((CoreUI)this, (ActionEvent)e);
    }

    protected FinancingAccountCollection getFinancingAccountCollection(Set idSet) throws BOSException, Exception {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        evi.setFilter(filterInfo);
        return FinancingAccountFactory.getRemoteInstance().getFinancingAccountCollection(evi);
    }

    @Override
    protected String getEditUIName() {
        return FinancingAccountEditUI.class.getName();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return FinancingAccountFactory.getRemoteInstance();
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (null == this.filterUI) {
            this.filterUI = new FinancingAccountFilterUI();
        }
        return this.filterUI;
    }

    private void checkObjectExists() throws Exception {
        if (this.getSelectedKeyValue() == null) {
            return;
        }
        if (!this.getBizInterface().exists((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.getSelectedKeyValue())))) {
            this.refreshList();
            throw new EASBizException(EASBizException.CHECKEXIST);
        }
    }

    @Override
    public void actionBook_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        ArrayList<String> lst = new ArrayList<String>();
        String userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        IFinancingAccount finaccount = (IFinancingAccount)this.getBizInterface();
        StringBuffer str = new StringBuffer();
        if (idList != null && idList.size() > 0) {
            for (int i = 0; i < idList.size(); ++i) {
                String id = (String)idList.get(i);
                boolean hasWf = FMHelper.hasWFInstance(null, (String)id);
                if (hasWf) {
                    MultiApproveUtil.multiapproveBills((CoreUIObject)this, (String)userID, (String[])new String[]{id});
                } else {
                    FinancingAccountInfo info = finaccount.getFinancingAccountInfo((IObjectPK)new ObjectUuidPK(id));
                    if (!FinancingStateEnum.AUDIT.equals((Object)info.getState())) {
                        str.append(EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTFINANCINGResource", (String)"028_BOOK_ERROR", (Object[])new String[]{info.getNumber()}));
                        str.append("\r\n");
                        continue;
                    }
                    if (info.isIsGenePayBill()) {
                        str.append(EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTFINANCINGResource", (String)"029_BOOK_ERROR", (Object[])new String[]{info.getNumber()}));
                        str.append("\r\n");
                        continue;
                    }
                    if (info.isIsBook()) {
                        str.append(EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTFINANCINGResource", (String)"030_BOOK_ERROR", (Object[])new String[]{info.getNumber()}));
                        str.append("\r\n");
                        continue;
                    }
                    if (info.getAccountBank() == null) {
                        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTFINANCINGResource", (String)"083_ACCOUNTBANK"));
                        SysUtil.abort();
                    }
                }
                lst.add(id);
            }
        }
        if (lst.size() != 0) {
            finaccount.book(lst);
        }
        if (str.length() > 0) {
            MsgBox.showDetailAndOK(null, (String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTFINANCINGResource", (String)"002_BOOK_RESULT", (Object[])new String[]{String.valueOf(lst.size()), String.valueOf(idList.size() - lst.size())}), (String)str.toString(), (int)1);
            SysUtil.abort();
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTFINANCINGResource", (String)"004_BOOK_SUCCESS"));
        }
        this.refreshList();
    }

    @Override
    public void actionRedeem_actionPerformed(ActionEvent e) throws Exception {
        String id = this.getSelectedKeyValue();
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        if (idList.size() > 1) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTFINANCINGResource", (String)"031_SELECT_ONE"));
            SysUtil.abort();
        }
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("balance"));
        FinancingAccountInfo info = FinancingAccountFactory.getRemoteInstance().getFinancingAccountInfo((IObjectPK)new ObjectUuidPK(id), sic);
        if (info.getState() != FinancingStateEnum.AUDIT) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTFINANCINGResource", (String)"032_REDEM_ERROR"));
            SysUtil.abort();
        }
        if (info.getBalance().compareTo(Constants.ZERO) == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTFINANCINGResource", (String)"033_REDEM_ERROR"));
            SysUtil.abort();
        } else {
            FMClientHelper.generateDestBill((CoreBillListUI)this, (String)FinancingAccountInfo.BOSTYPE.toString(), (String)new FinancingRedeemInfo().getBOSType().toString(), (String)id);
        }
    }

    @Override
    public void actionCancelBook_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        ArrayList<String> lst = new ArrayList<String>();
        String userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        IFinancingAccount financingAccount = (IFinancingAccount)this.getBizInterface();
        StringBuffer str = new StringBuffer();
        if (idList != null && idList.size() > 0) {
            for (int i = 0; i < idList.size(); ++i) {
                String id = (String)idList.get(i);
                boolean hasWf = FMHelper.hasWFInstance(null, (String)id);
                if (hasWf) {
                    MultiApproveUtil.multiapproveBills((CoreUIObject)this, (String)userID, (String[])new String[]{id});
                    continue;
                }
                FinancingAccountInfo info = financingAccount.getFinancingAccountInfo((IObjectPK)new ObjectUuidPK(id));
                if (!info.isIsBook()) {
                    str.append(EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTFINANCINGResource", (String)"034_CANCELREDEM_ERROR", (Object[])new String[]{info.getNumber()}));
                    str.append("\r\n");
                    continue;
                }
                lst.add(id);
            }
        }
        if (lst.size() != 0) {
            financingAccount.cancelbook(lst);
        }
        if (str.length() > 0) {
            MsgBox.showDetailAndOK(null, (String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTFINANCINGResource", (String)"001_CANCELBOOK_RESULT", (Object[])new String[]{String.valueOf(lst.size()), String.valueOf(idList.size() - lst.size())}), (String)str.toString(), (int)1);
            SysUtil.abort();
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTFINANCINGResource", (String)"003_CANCELBOOK_SUCCESS"));
        }
        this.refreshList();
    }

    @Override
    public void actionGenPayBill_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        if (idList.size() > 1) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTFINANCINGResource", (String)"035_PAY_ERROR"));
            SysUtil.abort();
        }
        String id = (String)idList.get(0);
        SelectorItemCollection selector = super.getSelectors();
        selector.add("accountbank.name");
        selector.add("accountbank.number");
        selector.add("accountbank.bankAccountNumber");
        selector.add("accountbank.bank");
        selector.add("accountbank.*");
        FinancingAccountInfo info = FinancingAccountFactory.getRemoteInstance().getFinancingAccountInfo((IObjectPK)new ObjectUuidPK(id), selector);
        if (info.getState() != FinancingStateEnum.AUDIT) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTFINANCINGResource", (String)"036_PAY_ERROR"));
            this.abort();
        }
        if (info.isIsBook()) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTFINANCINGResource", (String)"037_PAY_ERROR"));
            this.abort();
        }
        if (info.isIsGenePayBill()) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTFINANCINGResource", (String)"038_PAY_ERROR"));
            this.abort();
        }
        FMClientHelper.generateDestBill((CoreBillListUI)this, (String)FinancingAccountInfo.BOSTYPE.toString(), (String)new PaymentBillInfo().getBOSType().toString(), (String)this.getSelectedKeyValue());
    }

    @Override
    public void actionTDPrint_actionPerformed(ActionEvent e) throws Exception {
        this.tdPrint(false);
    }

    @Override
    public void actionTDPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.tdPrint(true);
    }

    private void tdPrint(boolean isPreview) {
        this.checkSelected();
        ArrayList idList = super.getSelectedIdValues();
        if (idList == null || idList.size() == 0) {
            return;
        }
        FMCommonSortedDataProvider data = new FMCommonSortedDataProvider((List)idList, this.getTDQueryPK());
        KDNoteHelper appHlp = new KDNoteHelper();
        if (isPreview) {
            appHlp.printPreview("/FM/INVEST/FINIVT/FINACCOUNT", (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        } else {
            appHlp.print("/FM/INVEST/FINIVT/FINACCOUNT", (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        }
    }

    @Override
    protected IMetaDataPK getTDQueryPK() {
        return new MetaDataPK("com.kingdee.eas.fm.ivt.app.FinancingAccountTDQuery");
    }

    public FilterInfo getFilterInfo() {
        FilterInfo filter = new FilterInfo();
        String companyid = ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString();
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(3)));
        filter.getFilterItems().add(new FilterItemInfo("balance", (Object)Constants.ZERO, CompareType.GREATER));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyid));
        return filter;
    }

    @Override
    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkObjectExists();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        uiContext.put((Object)"COPY", (Object)"COPY");
        this.prepareUIContext(uiContext, e);
        uiContext.put((Object)"IDList", null);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(this.getEditUIName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
    }

    public void actionVoucher_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        MutexUtils.requestMutex((CoreUI)this, (List)idList);
        try {
            super.actionVoucher_actionPerformed(e);
        }
        finally {
            MutexUtils.releaseMutex((List)idList);
        }
    }

    public void actionDelVoucher_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        MutexUtils.requestMutex((CoreUI)this, (List)idList);
        try {
            super.actionDelVoucher_actionPerformed(e);
        }
        finally {
            MutexUtils.releaseMutex((List)idList);
        }
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblMain_tableSelectChanged(e);
        int rowNumber = FMClientHelper.getSelectedRow((KDTable)this.tblMain);
        if (rowNumber == -1) {
            return;
        }
        IRow row = this.tblMain.getRow(rowNumber);
        String id = row.getCell("id").getValue().toString();
        SelectorItemCollection select = new SelectorItemCollection();
        select.add("state");
        select.add("fiVouchered");
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)id));
        FinancingAccountInfo info = (FinancingAccountInfo)this.getBizInterface().getValue((IObjectPK)pk, select);
        if (info.isFiVouchered()) {
            this.actionVoucher.setEnabled(false);
            this.actionDelVoucher.setEnabled(true);
        } else if (FinancingStateEnum.AUDIT.equals((Object)info.getState())) {
            this.actionVoucher.setEnabled(true);
            this.actionDelVoucher.setEnabled(false);
        } else if (!FinancingStateEnum.AUDIT.equals((Object)info.getState())) {
            this.actionVoucher.setEnabled(false);
            this.actionDelVoucher.setEnabled(false);
        }
    }

    protected SystemEnum getSystemEnum() {
        return SystemEnum.FIN_MANAGE;
    }

    protected String getDateField() {
        return "beginDate";
    }

    protected String[] getControlActions() {
        return new String[]{"actionEdit", "actionRemove", "actionAudit", "actionUnAudit"};
    }

    private FilterInfo getBillCanbeReceived() {
        Map btpeditparameter;
        String targetBillType;
        FilterInfo f = new FilterInfo();
        if (this.getUIContext().get("BTPEDITPARAMETER") != null && (targetBillType = (String)(btpeditparameter = (Map)this.getUIContext().get("BTPEDITPARAMETER")).get("TargetBillType")) != null && "PaymentBill".equals(targetBillType)) {
            f.getFilterItems().add(ConvertUtils.FITEM((Object[])new Object[]{"company.id", ConvertUtils.PSTR((String)"ARAPCOMPANY.id", (Object)btpeditparameter)}));
            f.getFilterItems().add(new FilterItemInfo("isGenePayBill", (Object)Boolean.FALSE));
            f.getFilterItems().add(new FilterItemInfo("isBook", (Object)Boolean.FALSE));
            f.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(3)));
        }
        return f;
    }

    protected void execQuery() {
        try {
            FilterInfo extFilter = this.getBillCanbeReceived();
            if (!EmptyUtil.isEmpty((AbstractObjectCollection)extFilter.getFilterItems())) {
                this.mainQuery.getFilter().mergeFilter(extFilter, "AND");
            }
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e.getCause());
        }
        super.execQuery();
    }

    private final class FillListener
    implements KDTDataFillListener {
        private FillListener() {
        }

        public void afterDataFill(KDTDataRequestEvent e) {
            FinancingAccountListUI.this.setListUITablePrecision(e.getFirstRow(), e.getLastRow());
        }
    }
}

