/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ivt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.DefaultNoteDataProvider;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPKFactory;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.AccountMgrStrategyFactory;
import com.kingdee.eas.basedata.assistant.AccountMgrStrategyInfo;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.OverdraftCtrlEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fi.cas.FundFlowDirection;
import com.kingdee.eas.fm.common.FMBgItemProp;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.IvtModualUtils;
import com.kingdee.eas.fm.common.client.F7SelectorFactory;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.fin.util.FinHelper;
import com.kingdee.eas.fm.fs.InnerAccountFactory;
import com.kingdee.eas.fm.fs.InnerAccountInfo;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.fm.ivt.ChLoanHelper;
import com.kingdee.eas.fm.ivt.EntRepaymentBillInfo;
import com.kingdee.eas.fm.ivt.IntCalTypeEnum;
import com.kingdee.eas.fm.ivt.IntRateTypeExpressionEnum;
import com.kingdee.eas.fm.ivt.IvtBillStatusEnum;
import com.kingdee.eas.fm.ivt.LoanInterestBillEntryInfo;
import com.kingdee.eas.fm.ivt.LoanInterestBillFactory;
import com.kingdee.eas.fm.ivt.LoanInterestBillInfo;
import com.kingdee.eas.fm.ivt.LoanInterestTypeEnum;
import com.kingdee.eas.fm.ivt.PenAccrualTypeEnum;
import com.kingdee.eas.fm.ivt.client.AbstractLoanInterestBillEditUI;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.EditUI;
import com.kingdee.eas.ma.budget.FpCashDirectionEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class LoanInterestBillEditUI
extends AbstractLoanInterestBillEditUI {
    private static final String PENARATE_TEXT = EASResource.getString((String)"com.kingdee.eas.fm.ivt.CHLoanResource", (String)"penerate_text");
    private static final String RATE_PER = EASResource.getString((String)"com.kingdee.eas.fm.ivt.CHLoanResource", (String)"rate_per");
    public static final String RATE_TNE_PER = EASResource.getString((String)"com.kingdee.eas.fm.ivt.CHLoanResource", (String)"rate_ten_per");
    private static final Logger logger = CoreUIObject.getLogger(LoanInterestBillEditUI.class);
    private UserInfo userinfo = ContextHelperFactory.getRemoteInstance().getCurrentUser();
    private BankInfo clearingHouse;
    private EntRepaymentBillInfo entRepaymentBillInfo;
    private CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
    private boolean successFlag = false;
    private static final String CHLOANRESOURCE_PATH = "com.kingdee.eas.fm.ivt.CHLoanResource";
    public static final String LOANINTR_FILENAME = "/FM/IM/LOANINTR";

    public void onLoad() throws Exception {
        if (null == this.getUIContext().get("repaymentbillid") && !this.getOprtState().equals("FINDVIEW")) {
            FSClientHelper.checkClearingHouseCompany();
            ChLoanHelper.checkClearingHouseUsed(this.currentCompany);
        }
        this.clearingHouse = BankFactory.getRemoteInstance().getClearingHouse(this.currentCompany.getId().toString());
        this.entRepaymentBillInfo = (EntRepaymentBillInfo)this.getUIContext().get("repaymentbillid");
        this.initControls();
        super.onLoad();
        this.verifyUIStrategy();
        this.actionPrint.setEnabled(false);
        this.actionPrint.setVisible(false);
        this.actionEdit.setEnabled(false);
        this.actionEdit.setVisible(false);
        this.actionRemove.setEnabled(false);
        this.actionRemove.setVisible(false);
        this.actionPrintPreview.setEnabled(false);
        this.actionPrintPreview.setVisible(false);
        this.actionCopy.setEnabled(false);
        this.actionCopy.setVisible(false);
        this.actionCopyFrom.setVisible(false);
        this.actionCopyFrom.setVisible(false);
        this.kdtEntrys.setEditable(false);
        this.kdtEntrys.setEnabled(false);
        this.menuItemAddNew.setVisible(false);
        this.menuItemAddNew.setEnabled(false);
        this.actionAddNew.setEnabled(false);
        this.actionAddNew.setVisible(false);
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
        this.bizPromptCreator.setEnabled(false);
        this.prmtaccountant.setEnabled(false);
        this.txtDescription.setMaxLength(80);
        this.txtNumber.setMaxLength(50);
        this.actionMultiapprove.setEnabled(false);
        this.actionMultiapprove.setVisible(false);
        this.actionAuditResult.setEnabled(false);
        this.actionAuditResult.setVisible(false);
        this.actionNextPerson.setVisible(false);
        this.actionNextPerson.setEnabled(false);
        this.setPrmtIntAccountQuery();
        F7SelectorFactory.initProject((IUIObject)this, (KDBizPromptBox)this.prmtProject);
        FMClientHelper.initBgItemF7((KDBizPromptBox)this.prmtBgItem, (FpCashDirectionEnum[])new FpCashDirectionEnum[]{FpCashDirectionEnum.input, FpCashDirectionEnum.other}, (boolean)true, (boolean)true);
        FMClientHelper.initFundFlowItemF7((IUIObject)this, (KDLabelContainer)this.contBgItem, (KDLabelContainer)this.contFundFlowItem, (FundFlowDirection)FundFlowDirection.IN);
    }

    public void onShow() throws Exception {
        super.onShow();
        FMClientHelper.setFirstFocus((Component[])new Component[]{this.txtNumber, this.pkBizDate});
    }

    protected boolean isSetPrecisionAuto() {
        return true;
    }

    protected CurrencyInfo getSelectCurrency() {
        return (CurrencyInfo)this.comboCurrency.getSelectedItem();
    }

    protected void resetPrecisionForOtherComponent() {
        this.txtyearIntRate.setPrecision(5);
        this.txtpunishIntRate.setPrecision(5);
    }

    @Override
    public void loadFields() {
        FMClientHelper.loadFieldsBgItem((KDBizPromptBox)this.prmtBgItem, (CoreBaseInfo)this.editData, (FMBgItemProp)this.editData.getBgItemProps()[0]);
        if (this.editData != null) {
            if (this.editData.getBank() != null) {
                this.clearingHouse = this.editData.getBank();
            }
            if (this.isSetPrecisionAuto()) {
                try {
                    this.setPrecision();
                }
                catch (Exception e) {
                    ExceptionHandler.handle((Component)((Object)this), (Throwable)e.getCause());
                }
            }
            super.loadFields();
            this.initOldData((IObjectValue)this.editData);
            FMClientHelper.initNumber((CoreBaseInfo)this.editData, (KDTextField)this.txtNumber, (String)this.currentCompany.getId().toString());
            if (this.clearingHouse != null && this.clearingHouse.getRelatedCompany() != null) {
                FMClientHelper.initNumber((CoreBaseInfo)this.editData, (KDTextField)this.txtNumber, (String)this.clearingHouse.getRelatedCompany().getId().toString());
            }
            if (this.editData.getCurrency() != null) {
                FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)this.editData.getCurrency());
            }
            if (this.editData.getIntCalType() == IntCalTypeEnum.PRE_INT) {
                this.prmtIntAccount.setRequired(false);
            } else {
                this.prmtIntAccount.setRequired(true);
            }
            int UiState = FinHelper.getUIState((EditUI)this);
            if (FinHelper.isInStates((int)UiState, (int[])new int[]{6, 2}) && this.editData.getBillStatus() == IvtBillStatusEnum.BOOK) {
                this.actionSubmit.setEnabled(false);
            }
            this.txtInterestAcctual.setValue((Object)this.editData.getInterestAcctual());
            this.txtPeneIntAcctual.setValue((Object)this.editData.getPunishInterestActual());
            this.fillTable();
        }
    }

    private void fillTable() {
        IRow row = null;
        String currencyId = null;
        CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        currencyId = this.editData.getCurrency().getId().toString();
        for (int i = 0; i < this.kdtEntrys.getRowCount(); ++i) {
            row = this.kdtEntrys.getRow(i);
            this.setRow(row);
            if (currencyId != null) {
                this.setAmtCellNumberFormat(row, currencyId);
            }
            if (companyInfo == null || companyInfo.getBaseCurrency() == null) continue;
            String baseCurrency = companyInfo.getBaseCurrency().getId().toString();
            this.setAmtCellNumberFormat(row, baseCurrency);
        }
    }

    private void setRow(IRow row) {
        BigDecimal rate = (BigDecimal)row.getCell("rate").getValue();
        BigDecimal penaRate = (BigDecimal)row.getCell("punishIntRate").getValue();
        row.getCell("rateDis").setValue((Object)rate);
        IntRateTypeExpressionEnum rateExpression = (IntRateTypeExpressionEnum)((Object)row.getCell("rateExpression").getValue());
        if (rateExpression == null) {
            rateExpression = this.editData.getIntRateTypeExpression();
        }
        if (IntRateTypeExpressionEnum.YEAR == rateExpression) {
            row.getCell("rateDis").getStyleAttributes().setNumberFormat("#,##0.00000\\%");
        } else {
            row.getCell("rateDis").getStyleAttributes().setNumberFormat("#,##0.00000\\\u2030");
        }
        row.getCell("penaIntRate").setValue((Object)penaRate);
        if (this.editData.getPunishIntType() == PenAccrualTypeEnum.ADD_ACCRUAL) {
            row.getCell("penaIntRate").getStyleAttributes().setNumberFormat("#,##0.00000\\\u2030");
        } else {
            row.getCell("penaIntRate").getStyleAttributes().setNumberFormat("#,##0.00000\\%");
        }
        row.getCell("rateDis").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        row.getCell("penaIntRate").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        String df = CtrlFormatUtilities.getDateFormatString();
        row.getCell("beginDate").getStyleAttributes().setNumberFormat(df);
        row.getCell("endDate").getStyleAttributes().setNumberFormat(df);
    }

    private String formatValue(String rateTmp) {
        String tmp = rateTmp.substring(rateTmp.indexOf(".") + 1, rateTmp.length() - 1);
        if (tmp.length() == 5) {
            return rateTmp;
        }
        int size = 5 - tmp.length();
        for (int i = 0; i < size; ++i) {
            tmp = tmp + "0";
        }
        return rateTmp.substring(0, rateTmp.indexOf(".") + 1) + tmp + rateTmp.substring(rateTmp.length() - 1);
    }

    private void setAmtCellNumberFormat(IRow row, String currencyId) {
        FMClientHelper.setNumberFormat((IRow)row, (String)"amount", (String)currencyId);
        FMClientHelper.setNumberFormat((IRow)row, (String)"interest", (String)currencyId);
        FMClientHelper.setNumberFormat((IRow)row, (String)"punishInterest", (String)currencyId);
    }

    @Override
    protected void txtInterestAcctual_dataChanged(DataChangeEvent e) throws Exception {
        this.caclIntActual();
    }

    private void caclIntActual() {
        BigDecimal penActual = this.txtPeneIntAcctual.getBigDecimalValue();
        BigDecimal intActual = this.txtInterestAcctual.getBigDecimalValue();
        penActual = penActual == null ? Constants.ZERO : penActual;
        intActual = intActual == null ? Constants.ZERO : intActual;
        this.txtinterestToPay.setValue((Object)penActual.add(intActual));
    }

    @Override
    protected void txtPeneIntAcctual_dataChanged(DataChangeEvent e) throws Exception {
        this.caclIntActual();
    }

    private void initControls() {
        CashHelper.initCombCurrency((KDComboBox)this.comboCurrency, (boolean)false);
        this.txtPeneIntAcctual.setMinimumValue((Comparable)Constants.ZERO);
        this.txtInterestAcctual.setMinimumValue((Comparable)Constants.ZERO);
        this.txtPeneIntAcctual.setMaximumValue((Comparable)Constants.MAX_VALUE);
        this.txtInterestAcctual.setMaximumValue((Comparable)Constants.MAX_VALUE);
        this.pkBizDate.setRequired(true);
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return LoanInterestBillFactory.getRemoteInstance();
    }

    @Override
    protected KDTable getDetailTable() {
        return this.kdtEntrys;
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.verifyInput(e);
        if (this.entRepaymentBillInfo != null) {
            int userChoosed = -1;
            this.storeFields();
            this.initOldData((IObjectValue)this.editData);
            this.editData.setEntRepaymentBillInfo(this.entRepaymentBillInfo);
            this.editData.setIntCalType(IntCalTypeEnum.REPAY_INT);
            if (!LoanInterestBillFactory.getRemoteInstance().checkBalanceEnough(this.editData)) {
                boolean isControl = ContextHelperFactory.getRemoteInstance().getBooleanParam("INT005", (IObjectPK)new ObjectUuidPK(this.currentCompany.getId()));
                InnerAccountInfo innerAccountInfo = InnerAccountFactory.getRemoteInstance().getInnerAccountInfo((IObjectPK)new ObjectUuidPK(this.editData.getIntAccount().getId()));
                AccountMgrStrategyInfo accountMgrStrategyInfo = innerAccountInfo.getCtrlParam();
                accountMgrStrategyInfo = AccountMgrStrategyFactory.getRemoteInstance().getAccountMgrStrategyInfo((IObjectPK)new ObjectUuidPK(accountMgrStrategyInfo.getId()), this.getAccountMgrStrategySelector());
                OverdraftCtrlEnum overdraftCtrl = accountMgrStrategyInfo.getOverdraftCtrl();
                if (isControl && !OverdraftCtrlEnum.NOTCONTROL.equals((Object)overdraftCtrl)) {
                    MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)CHLOANRESOURCE_PATH, (String)"banlance_isControl"));
                } else {
                    userChoosed = MsgBox.showConfirm2New((Component)((Object)this), (String)EASResource.getString((String)CHLOANRESOURCE_PATH, (String)"banlance_insufficient"));
                }
            } else {
                userChoosed = 0;
            }
            if (userChoosed == 0) {
                if (this.entRepaymentBillInfo != null) {
                    super.actionSubmit_actionPerformed(e);
                    this.storeFields();
                    this.initOldData((IObjectValue)this.editData);
                    this.uiWindow.close();
                } else {
                    super.actionSubmit_actionPerformed(e);
                    this.storeFields();
                    this.initOldData((IObjectValue)this.editData);
                    this.uiWindow.close();
                }
            } else {
                this.storeFields();
                this.initOldData((IObjectValue)this.editData);
                this.disposeUIWindow();
                this.uiWindow.close();
            }
        } else {
            String isVerify = this.getUIContext().get("VERIFY") + "";
            if (isVerify.equals("verify")) {
                this.checkVerifyData();
                this.storeFields();
                this.initOldData((IObjectValue)this.editData);
                LoanInterestBillFactory.getRemoteInstance().verifyBill(this.editData);
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"92_LoanInterestBillEditUI"));
                this.disposeUIWindow();
                this.uiWindow.close();
            } else {
                this.checkStoreData();
                this.storeFields();
                this.initOldData((IObjectValue)this.editData);
                super.actionSubmit_actionPerformed(e);
                this.storeFields();
                this.initOldData((IObjectValue)this.editData);
                this.uiWindow.close();
            }
        }
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
        this.uiWindow.close();
    }

    private int checkStoreData() throws EASBizException, BOSException {
        int count = 0;
        StringBuffer msgDetail = new StringBuffer();
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        boolean isSubmit = IvtModualUtils.getSysParam(null, (String)"IVT003");
        if (isSubmit && this.editData.getIntCalType() != IntCalTypeEnum.PRE_INT) {
            BigDecimal interestActual = FMHelper.add((BigDecimal)this.editData.getInterestAcctual(), (BigDecimal)this.editData.getPunishInterestActual());
            if (!EmptyUtil.isEmpty((CoreBaseInfo)this.editData.getIntAccount())) {
                InnerAccountInfo innerAccountInfo = InnerAccountFactory.getRemoteInstance().getInnerAccountInfo((IObjectPK)new ObjectUuidPK(this.editData.getIntAccount().getId()));
                BigDecimal payeeInnerAcctBalance = FMHelper.getBalanceValue(null, (CurrencyInfo)((CurrencyInfo)this.editData.get("currency")), (InnerAccountInfo)this.editData.getIntAccount());
                AccountMgrStrategyInfo accountMgrStrategyInfo = innerAccountInfo.getCtrlParam();
                accountMgrStrategyInfo = AccountMgrStrategyFactory.getRemoteInstance().getAccountMgrStrategyInfo((IObjectPK)new ObjectUuidPK(accountMgrStrategyInfo.getId()), this.getAccountMgrStrategySelector());
                OverdraftCtrlEnum overdraftCtrl = accountMgrStrategyInfo.getOverdraftCtrl();
                if (overdraftCtrl.equals((Object)OverdraftCtrlEnum.NOTCONTROL) && accountMgrStrategyInfo.isRemind() && interestActual.compareTo(payeeInnerAcctBalance) > 0) {
                    ++count;
                    numberFormat.setMaximumFractionDigits(((CurrencyInfo)this.editData.get("currency")).getPrecision());
                    numberFormat.setMinimumFractionDigits(((CurrencyInfo)this.editData.get("currency")).getPrecision());
                    String tmp = FMHelper.formatMessage(null, (String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"DraftDetail", (Object[])new String[]{this.editData.getLoanBill().getNumber(), this.editData.getIntAccount().getName(), numberFormat.format(payeeInnerAcctBalance), numberFormat.format(FMHelper.subtract((BigDecimal)interestActual, (BigDecimal)payeeInnerAcctBalance))});
                    msgDetail.append(tmp + "\n");
                }
            }
        }
        int result = 0;
        if (count > 0) {
            result = MsgBox.showConfirm4a((String)FMHelper.formatMessage(null, (String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"DraftMain", (Object[])new String[]{String.valueOf(count), String.valueOf(count)}), (String)msgDetail.toString());
        }
        if (result != 0) {
            SysUtil.abort();
        }
        return result;
    }

    private void checkVerifyData() throws EASBizException, BOSException {
        BigDecimal verifyAmount = this.txtVerifyAmount.getBigDecimalValue();
        if (verifyAmount.compareTo(Constants.ZERO) <= 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"minVerifyAmount"));
            SysUtil.abort();
        }
        BigDecimal payeeInnerAcctBalance = FMHelper.getBalanceValue(null, (CurrencyInfo)((CurrencyInfo)this.editData.get("currency")), (InnerAccountInfo)((InnerAccountInfo)this.editData.getObjectValue("intAccount")));
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        LoanInterestBillInfo info = LoanInterestBillFactory.getRemoteInstance().getLoanInterestBillInfo((IObjectPK)new ObjectUuidPK(this.editData.getId()));
        InnerAccountInfo innerAccountInfo = (InnerAccountInfo)this.editData.getObjectValue("intAccount");
        String innerAccountID = info.getIntAccount().getId().toString();
        innerAccountInfo = InnerAccountFactory.getRemoteInstance().getInnerAccountInfo((IObjectPK)new ObjectUuidPK(innerAccountID));
        numberFormat.setMaximumFractionDigits(this.editData.getCurrency().getPrecision());
        numberFormat.setMinimumFractionDigits(this.editData.getCurrency().getPrecision());
        AccountMgrStrategyInfo accountMgrStrategyInfo = innerAccountInfo.getCtrlParam();
        accountMgrStrategyInfo = AccountMgrStrategyFactory.getRemoteInstance().getAccountMgrStrategyInfo((IObjectPK)new ObjectUuidPK(accountMgrStrategyInfo.getId()), this.getAccountMgrStrategySelector());
        BigDecimal maxPayAmount = FMHelper.add((BigDecimal)payeeInnerAcctBalance, (BigDecimal)Constants.ZERO);
        OverdraftCtrlEnum overdraftCtrl = accountMgrStrategyInfo.getOverdraftCtrl();
        if (overdraftCtrl.equals((Object)OverdraftCtrlEnum.INLIMITCANOVERDRAFT)) {
            maxPayAmount = FMHelper.add((BigDecimal)maxPayAmount, (BigDecimal)accountMgrStrategyInfo.getOverDraftAmount());
            if (verifyAmount.compareTo(payeeInnerAcctBalance) > 0 && verifyAmount.compareTo(maxPayAmount) <= 0) {
                String text = FMHelper.formatMessage(null, (String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"INLIMITCANOVERDRAFTTEXT", (Object[])new Object[]{innerAccountInfo.getName(), numberFormat.format(payeeInnerAcctBalance), numberFormat.format(accountMgrStrategyInfo.getOverDraftAmount()), numberFormat.format(FMHelper.subtract((BigDecimal)verifyAmount, (BigDecimal)payeeInnerAcctBalance))});
                if (accountMgrStrategyInfo.isRemind()) {
                    this.showInfoText(text);
                }
            } else if (verifyAmount.compareTo(maxPayAmount) > 0) {
                String text = FMHelper.formatMessage(null, (String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"NO_INLIMITCANOVERDRAFTTEXT", (Object[])new Object[]{innerAccountInfo.getName(), numberFormat.format(payeeInnerAcctBalance), numberFormat.format(accountMgrStrategyInfo.getOverDraftAmount()), numberFormat.format(FMHelper.subtract((BigDecimal)verifyAmount, (BigDecimal)maxPayAmount))});
                this.showUnDraftText(text);
            }
        } else if (overdraftCtrl.equals((Object)OverdraftCtrlEnum.LOWESTDEPOSITGUARANTEE)) {
            if (verifyAmount.compareTo(maxPayAmount = FMHelper.subtract((BigDecimal)maxPayAmount, (BigDecimal)accountMgrStrategyInfo.getLowestBalance())) > 0) {
                String text = FMHelper.formatMessage(null, (String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"NO_LOWESTDEPOSITGUARANTEE", (Object[])new Object[]{innerAccountInfo.getName(), numberFormat.format(payeeInnerAcctBalance), numberFormat.format(FMHelper.subtract((BigDecimal)verifyAmount, (BigDecimal)maxPayAmount))});
                this.showUnDraftText(text);
            }
        } else if (overdraftCtrl.equals((Object)OverdraftCtrlEnum.NOTCONTROL)) {
            maxPayAmount = Constants.MAX_VALUE;
            if (verifyAmount.compareTo(payeeInnerAcctBalance) > 0 && verifyAmount.compareTo(maxPayAmount) <= 0) {
                String text = FMHelper.formatMessage(null, (String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"NoControlText", (Object[])new Object[]{innerAccountInfo.getName(), numberFormat.format(payeeInnerAcctBalance), numberFormat.format(FMHelper.subtract((BigDecimal)verifyAmount, (BigDecimal)payeeInnerAcctBalance))});
                if (accountMgrStrategyInfo.isRemind()) {
                    this.showInfoText(text);
                }
            }
        } else if (overdraftCtrl.equals((Object)OverdraftCtrlEnum.NOTALLOW) && verifyAmount.compareTo(payeeInnerAcctBalance) > 0) {
            String text = FMHelper.formatMessage(null, (String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"NO_NOTALLOW", (Object[])new Object[]{innerAccountInfo.getName(), numberFormat.format(payeeInnerAcctBalance), numberFormat.format(FMHelper.subtract((BigDecimal)verifyAmount, (BigDecimal)payeeInnerAcctBalance))});
            this.showUnDraftText(text);
        }
    }

    private void showUnDraftText(String text) {
        MsgBox.showInfo((String)text);
        SysUtil.abort();
    }

    private void showInfoText(String text) {
        int result = MsgBox.showConfirm2((String)text);
        if (result != 0) {
            SysUtil.abort();
        }
    }

    public boolean getSuccessFlag() {
        return this.successFlag;
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        return new LoanInterestBillEntryInfo();
    }

    protected void afterSubmitAddNew() {
    }

    @Override
    protected IObjectValue createNewData() {
        Date startDate = this.getStartDate();
        Date endDate = this.getEndDate();
        LoanInterestBillInfo objectValue = null;
        try {
            objectValue = LoanInterestBillFactory.getRemoteInstance().calInt(startDate, endDate, this.entRepaymentBillInfo);
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
        if (objectValue.getStrikeAmount() == null) {
            objectValue.setStrikeAmount(Constants.ZERO);
        }
        objectValue.setIsDownLoaded(false);
        return objectValue;
    }

    private Date getEndDate() {
        if (this.entRepaymentBillInfo.getRepayDate().compareTo(this.entRepaymentBillInfo.getChLoanInfo().getStartDate()) == 0) {
            return this.entRepaymentBillInfo.getRepayDate();
        }
        Calendar c = Calendar.getInstance();
        c.setTime(this.entRepaymentBillInfo.getRepayDate());
        c.add(6, -1);
        return c.getTime();
    }

    private Date getStartDate() {
        Date loanStartDate = this.entRepaymentBillInfo.getLoanBillID().getStartDate();
        Date lastIntDate = this.entRepaymentBillInfo.getLoanBillID().getLastSettleDate();
        if (lastIntDate == null) {
            return loanStartDate;
        }
        return this.maxDate(loanStartDate, lastIntDate);
    }

    private Date maxDate(Date date1, Date date2) {
        int i = date1.compareTo(date2);
        switch (i) {
            case 1: {
                return date1;
            }
            case -1: {
                return date2;
            }
            case 0: {
                return date1;
            }
        }
        return date1;
    }

    @Override
    protected void comboRateTypeExpression_actionPerformed(ActionEvent e) throws Exception {
        IntRateTypeExpressionEnum intRateTypeExpressionEnum = (IntRateTypeExpressionEnum)((Object)this.comboRateTypeExpression.getSelectedItem());
        if (intRateTypeExpressionEnum == IntRateTypeExpressionEnum.YEAR) {
            this.contyearIntRate.setBoundLabelText(RATE_PER);
        } else if (intRateTypeExpressionEnum == IntRateTypeExpressionEnum.MONTH) {
            this.contyearIntRate.setBoundLabelText(RATE_TNE_PER);
        } else {
            this.contyearIntRate.setBoundLabelText(RATE_TNE_PER);
        }
    }

    @Override
    public void punishIntType_actionPerformed(ActionEvent e) {
        PenAccrualTypeEnum penAccrualType = (PenAccrualTypeEnum)((Object)this.punishIntType.getShowSelectedItem());
        if (penAccrualType == PenAccrualTypeEnum.ADD_ACCRUAL) {
            this.contpunishIntRate.setBoundLabelText(EASResource.getString((String)CHLOANRESOURCE_PATH, (String)"dailyrate"));
        } else if (penAccrualType == PenAccrualTypeEnum.ADD_PERCENT) {
            this.contpunishIntRate.setBoundLabelText(PENARATE_TEXT);
        }
    }

    public void actionViewBdgBalance_actionPerformed(ActionEvent e) throws Exception {
        this.storeFields();
        FMClientHelper.viewBgBalance((Component)((Object)this), (String)"com.kingdee.eas.fm.ivt.app.LoanInterestBill", null, (IObjectValue)this.editData);
    }

    protected boolean showViewBdgBalanceBtn() {
        return true;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add("*");
        sic.add("currency.*");
        sic.add("company.*");
        sic.add("bank.id");
        sic.add("fpItem.id");
        sic.add("fpItem.number");
        sic.add("fpItem.name");
        sic.add("project.id");
        sic.add("project.name");
        sic.add("project.number");
        sic.add("fundFlowItem.*");
        return sic;
    }

    public SelectorItemCollection getBOTPSelectors() {
        return this.getSelectors();
    }

    @Override
    protected void setAutoNumberByOrg(String orgType) {
    }

    @Override
    public void actionTDPrint_actionPerformed(ActionEvent e) throws Exception {
        LoanInterestBillInfo info = (LoanInterestBillInfo)this.getDataObject();
        HashSet<String> idSet = new HashSet<String>();
        if (info.getId() != null) {
            idSet.add(info.getId().toString());
            IMetaDataPK headPK = MetaDataPKFactory.getMetaDataPK((String)"com.kingdee.eas.fm.ivt.client.LoanInterestBillHeaderTDQuery");
            DefaultNoteDataProvider dataProvider = new DefaultNoteDataProvider(idSet, headPK);
            String mainDsName = "LoanInterestBillHeaderTDQuery";
            dataProvider.addMetaDataPK(mainDsName, headPK);
            dataProvider.addCustomFilterMaker(mainDsName, (DefaultNoteDataProvider.ICustomFilterMaker)new DefaultNoteDataProvider.DefaultIdFilterMaker(idSet));
            String entryDsName = "LoanInterestBillEntryTDQuery";
            IMetaDataPK entryPK = MetaDataPKFactory.getMetaDataPK((String)"com.kingdee.eas.fm.ivt.client.LoanInterestBillEntryTDQuery");
            dataProvider.addMetaDataPK(entryDsName, entryPK);
            dataProvider.addForeignKey((Object)entryDsName, "parentId");
            dataProvider.setBatchSupported(true);
            dataProvider.setNumberOfEachBatch(100);
            KDNoteHelper appHlp = new KDNoteHelper();
            appHlp.print(LOANINTR_FILENAME, (Object)dataProvider, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        }
    }

    @Override
    public void actionTDPrintPreView_actionPerformed(ActionEvent e) throws Exception {
        LoanInterestBillInfo info = (LoanInterestBillInfo)this.getDataObject();
        HashSet<String> idSet = new HashSet<String>();
        if (info.getId() != null) {
            idSet.add(info.getId().toString());
            IMetaDataPK headPK = MetaDataPKFactory.getMetaDataPK((String)"com.kingdee.eas.fm.ivt.client.LoanInterestBillHeaderTDQuery");
            DefaultNoteDataProvider dataProvider = new DefaultNoteDataProvider(idSet, headPK);
            String mainDsName = "LoanInterestBillHeaderTDQuery";
            dataProvider.addMetaDataPK(mainDsName, headPK);
            dataProvider.addCustomFilterMaker(mainDsName, (DefaultNoteDataProvider.ICustomFilterMaker)new DefaultNoteDataProvider.DefaultIdFilterMaker(idSet));
            String entryDsName = "LoanInterestBillEntryTDQuery";
            IMetaDataPK entryPK = MetaDataPKFactory.getMetaDataPK((String)"com.kingdee.eas.fm.ivt.client.LoanInterestBillEntryTDQuery");
            dataProvider.addMetaDataPK(entryDsName, entryPK);
            dataProvider.addForeignKey((Object)entryDsName, "parentId");
            dataProvider.setBatchSupported(true);
            dataProvider.setNumberOfEachBatch(100);
            KDNoteHelper appHlp = new KDNoteHelper();
            appHlp.printPreview(LOANINTR_FILENAME, (Object)dataProvider, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        }
    }

    protected void initDataStatus() {
        super.initDataStatus();
        boolean TDPStatus = this.getOprtState().equals(OprtState.ADDNEW);
        this.actionTDPrint.setVisible(!TDPStatus);
        this.actionTDPrint.setEnabled(!TDPStatus);
        this.actionTDPrintPreView.setVisible(!TDPStatus);
        this.actionTDPrintPreView.setEnabled(!TDPStatus);
        this.intCalType.setEnabled(false);
        this.pkendDate.setEnabled(false);
        this.txtdays.setEnabled(false);
        this.pkbeginDate.setEnabled(false);
        this.txtdaysOverdue.setEnabled(false);
        this.txtyearIntRate.setEnabled(false);
        this.txtamount.setEnabled(false);
        this.txtinterest.setEnabled(false);
        this.punishIntType.setEnabled(false);
        this.txtpunishIntRate.setEnabled(false);
        this.txtpunishInterest.setEnabled(false);
        this.prmtloanCompany.setEnabled(false);
    }

    public void initWorkButton() {
        super.initWorkButton();
        this.actionTDPrint.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_credenceprint"));
        this.actionTDPrintPreView.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_dysz"));
    }

    @Override
    public void storeFields() {
        FMClientHelper.storeFieldsBgItem((KDBizPromptBox)this.prmtBgItem, (CoreBaseInfo)this.editData, (FMBgItemProp)this.editData.getBgItemProps()[0]);
        if (this.editData.getCompany() != null && this.editData.getCompany().getNumber() == null) {
            this.editData.setCompany(this.currentCompany);
        } else if (this.editData.getCompany() == null) {
            this.editData.setCompany(this.currentCompany);
        }
        super.storeFields();
        this.editData.setFivouchered(false);
    }

    protected void initAddNewStatus() {
        this.prmtIntAccount.setEditable(true);
        this.prmtIntAccount.setEnabled(true);
    }

    protected void initEditStatus() {
        this.prmtIntAccount.setEditable(true);
        this.prmtIntAccount.setEnabled(true);
    }

    @Override
    protected void prmtIntAccount_willCommit(CommitEvent e) throws Exception {
        ChLoanHelper.getInstance().setAccountFilter(this.clearingHouse, this.prmtIntAccount, null, 1);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("applyUnit.id", (Object)this.editData.getLoanCompany().getId()));
        this.prmtIntAccount.getEntityViewInfo().getFilter().mergeFilter(filter, "AND");
        this.prmtIntAccount.getQueryAgent().resetRuntimeEntityView();
    }

    @Override
    protected void prmtIntAccount_willShow(SelectorEvent e) throws Exception {
        ChLoanHelper.getInstance().setAccountFilter(this.clearingHouse, this.prmtIntAccount, null, 1);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("applyUnit.id", (Object)this.editData.getLoanCompany().getId()));
        this.prmtIntAccount.getEntityViewInfo().getFilter().mergeFilter(filter, "AND");
        this.prmtIntAccount.getQueryAgent().resetRuntimeEntityView();
    }

    private void setPrmtIntAccountQuery() {
        this.prmtIntAccount.setQueryInfo("com.kingdee.eas.fm.fs.InnerAccountQuery");
        this.prmtIntAccount.setEditFormat("$name$");
        this.prmtIntAccount.setCommitFormat("$number$");
        this.prmtIntAccount.setDisplayFormat("$name$");
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        FMClientVerifyHelper.verifyUIControlEmpty((CoreUI)this);
    }

    private void verifyUIStrategy() throws EASBizException, BOSException {
        this.kDLabelContainer11.setVisible(false);
        this.kDLabelContainer12.setVisible(false);
        this.kDLabelContainer13.setVisible(false);
        this.kDLabelContainer14.setEnabled(false);
        this.txtVerifyAmount.setEditable(false);
        this.verifySeq.setEditable(false);
        this.verifySeq.setVisible(false);
        this.verifySeq.setText(this.editData.getVerifySeq() + "");
        this.txtIntAccountBalance.setEditable(false);
        this.comboBillType.setEnabled(false);
        this.comboBillType.setEditable(false);
        FMClientHelper.setSelectObject((KDComboBox)this.comboBillType, (Object)((Object)this.editData.getBillType()));
        BigDecimal verifyAmount = (BigDecimal)this.editData.get("unVerifyAmount");
        BigDecimal payeeInnerAcctBalance = FMHelper.getBalanceValue(null, (CurrencyInfo)((CurrencyInfo)this.editData.get("currency")), (InnerAccountInfo)((InnerAccountInfo)this.editData.getObjectValue("intAccount")));
        String intCalType = this.getUIContext().get("INTCALTYPE") + "";
        if ("intCalType".equals(intCalType)) {
            this.kDLabelContainer11.setVisible(true);
            BigDecimal verifyAmount2 = ((BigDecimal)this.editData.get("interestActual")).add((BigDecimal)this.editData.get("punishInterestActual")).subtract((BigDecimal)this.editData.get("unVerifyAmount"));
            FMClientHelper.setCutValue((KDFormattedTextField)this.txtVerifyAmount, (Number)verifyAmount2);
        }
        FMClientHelper.setCutValue((KDFormattedTextField)this.txtIntAccountBalance, (Number)payeeInnerAcctBalance);
        String isVerify = this.getUIContext().get("VERIFY") + "";
        if (isVerify.equals("verify") || (LoanInterestTypeEnum)((Object)this.comboBillType.getSelectedItem()) == LoanInterestTypeEnum.VERIFY) {
            this.kDLabelContainer11.setVisible(true);
            this.txtVerifyAmount.setEditable(true);
            this.txtPeneIntAcctual.setEditable(false);
            this.txtpunishInterest.setEditable(false);
            this.btnSubmit.setEnabled(true);
            this.prmtProject.setEnabled(false);
            this.prmtIntAccount.setEnabled(false);
            this.txtDescription.setEditable(false);
            this.txtInterestAcctual.setEditable(false);
            this.prmtBgItem.setEnabled(false);
            this.pkBizDate.setEditable(true);
            this.pkBizDate.setEnabled(true);
            LoanInterestBillInfo info = LoanInterestBillFactory.getRemoteInstance().getLoanInterestBillInfo((IObjectPK)new ObjectUuidPK(this.editData.getId()));
            InnerAccountInfo innerAccountInfo = (InnerAccountInfo)this.editData.getObjectValue("intAccount");
            String innerAccountID = info.getIntAccount().getId().toString();
            innerAccountInfo = InnerAccountFactory.getRemoteInstance().getInnerAccountInfo((IObjectPK)new ObjectUuidPK(innerAccountID));
            AccountMgrStrategyInfo accountMgrStrategyInfo = innerAccountInfo.getCtrlParam();
            accountMgrStrategyInfo = AccountMgrStrategyFactory.getRemoteInstance().getAccountMgrStrategyInfo((IObjectPK)new ObjectUuidPK(accountMgrStrategyInfo.getId()), this.getAccountMgrStrategySelector());
            BigDecimal maxPayAmount = FMHelper.add((BigDecimal)payeeInnerAcctBalance, (BigDecimal)Constants.ZERO);
            OverdraftCtrlEnum overdraftCtrl = accountMgrStrategyInfo.getOverdraftCtrl();
            if (overdraftCtrl.equals((Object)OverdraftCtrlEnum.INLIMITCANOVERDRAFT)) {
                maxPayAmount = FMHelper.add((BigDecimal)maxPayAmount, (BigDecimal)accountMgrStrategyInfo.getOverDraftAmount());
            } else if (overdraftCtrl.equals((Object)OverdraftCtrlEnum.LOWESTDEPOSITGUARANTEE)) {
                maxPayAmount = FMHelper.subtract((BigDecimal)maxPayAmount, (BigDecimal)accountMgrStrategyInfo.getLowestBalance());
            } else if (overdraftCtrl.equals((Object)OverdraftCtrlEnum.NOTCONTROL)) {
                maxPayAmount = Constants.MAX_VALUE;
            } else if (overdraftCtrl.equals((Object)OverdraftCtrlEnum.NOTALLOW)) {
                // empty if block
            }
            if (verifyAmount.compareTo(maxPayAmount) == 1) {
                verifyAmount = maxPayAmount;
            }
            this.kDLabelContainer13.setVisible(true);
            this.txtIntAccountBalance.setVisible(true);
            if (!this.getOprtState().equals(OprtState.VIEW)) {
                FMClientHelper.setCutValue((KDFormattedTextField)this.txtVerifyAmount, (Number)verifyAmount);
                this.editData.setVerifyAmount(verifyAmount);
            }
        }
        if (("VIEW".equals(this.getOprtState()) || "FINDVIEW".equals(this.getOprtState())) && this.editData.getVerifySeq() > 0) {
            this.kDLabelContainer11.setVisible(true);
            this.kDContainer1.setVisible(false);
            this.verifySeq.setVisible(true);
            this.kDLabelContainer12.setVisible(true);
        }
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
    }

    @Override
    protected void txtVerifyAmount_dataChanged(DataChangeEvent e) throws Exception {
        LoanInterestBillInfo info = LoanInterestBillFactory.getRemoteInstance().getLoanInterestBillInfo((IObjectPK)new ObjectUuidPK(this.editData.getId()));
        BigDecimal verifyAmount = (BigDecimal)this.editData.get("unVerifyAmount");
        BigDecimal payeeInnerAcctBalance = FMHelper.getBalanceValue(null, (CurrencyInfo)((CurrencyInfo)this.editData.get("currency")), (InnerAccountInfo)((InnerAccountInfo)this.editData.getObjectValue("intAccount")));
        InnerAccountInfo innerAccountInfo = (InnerAccountInfo)this.editData.getObjectValue("intAccount");
        if (!EmptyUtil.isEmpty((CoreBaseInfo)info.getIntAccount()) && this.editData.getIntCalType() != null && this.editData.getIntCalType() != IntCalTypeEnum.PRE_INT) {
            BigDecimal a;
            String innerAccountID = info.getIntAccount().getId().toString();
            innerAccountInfo = InnerAccountFactory.getRemoteInstance().getInnerAccountInfo((IObjectPK)new ObjectUuidPK(innerAccountID));
            AccountMgrStrategyInfo accountMgrStrategyInfo = innerAccountInfo.getCtrlParam();
            accountMgrStrategyInfo = AccountMgrStrategyFactory.getRemoteInstance().getAccountMgrStrategyInfo((IObjectPK)new ObjectUuidPK(accountMgrStrategyInfo.getId()), this.getAccountMgrStrategySelector());
            BigDecimal maxPayAmount = FMHelper.add((BigDecimal)payeeInnerAcctBalance, (BigDecimal)Constants.ZERO);
            OverdraftCtrlEnum overdraftCtrl = accountMgrStrategyInfo.getOverdraftCtrl();
            if (overdraftCtrl.equals((Object)OverdraftCtrlEnum.INLIMITCANOVERDRAFT)) {
                maxPayAmount = FMHelper.add((BigDecimal)maxPayAmount, (BigDecimal)accountMgrStrategyInfo.getOverDraftAmount());
            } else if (overdraftCtrl.equals((Object)OverdraftCtrlEnum.LOWESTDEPOSITGUARANTEE)) {
                maxPayAmount = FMHelper.subtract((BigDecimal)maxPayAmount, (BigDecimal)accountMgrStrategyInfo.getLowestBalance());
            } else if (overdraftCtrl.equals((Object)OverdraftCtrlEnum.NOTCONTROL)) {
                maxPayAmount = Constants.MAX_VALUE;
            } else if (overdraftCtrl.equals((Object)OverdraftCtrlEnum.NOTALLOW)) {
                // empty if block
            }
            if (verifyAmount.compareTo(maxPayAmount) == 1) {
                verifyAmount = maxPayAmount;
            }
            if ((a = this.txtVerifyAmount.getBigDecimalValue()).compareTo(maxPayAmount) == 1) {
                FMClientHelper.setCutValue((KDFormattedTextField)this.txtVerifyAmount, (Number)verifyAmount);
            } else {
                FMClientHelper.setCutValue((KDFormattedTextField)this.txtVerifyAmount, (Number)a);
            }
        }
        super.txtVerifyAmount_dataChanged(e);
    }

    private SelectorItemCollection getAccountMgrStrategySelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("overdraftCtrl");
        sic.add("overDraftAmount");
        sic.add("lowestBalance");
        sic.add("remind");
        return sic;
    }
}

