/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ivt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.client.F7SelectorFactory;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.fm.ivt.ChLoanCollection;
import com.kingdee.eas.fm.ivt.ChLoanFactory;
import com.kingdee.eas.fm.ivt.ChLoanHelper;
import com.kingdee.eas.fm.ivt.ChLoanInfo;
import com.kingdee.eas.fm.ivt.LoanInterestBillCollection;
import com.kingdee.eas.fm.ivt.LoanInterestBillFactory;
import com.kingdee.eas.fm.ivt.client.AbstractPreIntScopeChooserUI;
import com.kingdee.eas.fm.ivt.client.LoanInterestBillListUI;
import com.kingdee.eas.fm.ivt.client.ModifyFpItemsUI;
import com.kingdee.eas.fm.ivt.client.RecIntScopeChooserUI;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class PreIntScopeChooserUI
extends AbstractPreIntScopeChooserUI {
    private static final String ALL = EASResource.getString((String)"com.kingdee.eas.fm.ivt.CHLoanResource", (String)"all");
    private static final Logger logger = CoreUIObject.getLogger(PreIntScopeChooserUI.class);
    protected Set createdIntReceivedID;
    private CompanyOrgUnitInfo currentCompany;
    Map hm = new HashMap();

    public PreIntScopeChooserUI() throws Exception {
        this.currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
    }

    public void onLoad() throws Exception {
        FSClientHelper.checkClearingHouseCompany();
        ChLoanHelper.checkClearingHouseUsed(this.currentCompany);
        super.onLoad();
        this.customed_init();
    }

    private void customed_init() {
        this.initchkStartDate();
        this.initPrmtLoan(this.prmtLoan);
        this.initCurrency(this.comboCurrency);
        this.initDate();
        this.initPrmtLoanCompany();
    }

    private void initDate() {
        if (this.chkStartDate.isSelected()) {
            this.pdStartDate.setEditable(true);
            this.pdStartDate.setEnabled(true);
            this.pdStartDate.setSupportedEmpty(false);
            this.pdStartDate.setValue((Object)new Date());
            this.dpEndDate.setSupportedEmpty(false);
            this.dpEndDate.setValue((Object)new Date());
        } else {
            this.pdStartDate.setEditable(false);
            this.pdStartDate.setEnabled(false);
            this.pdStartDate.setValue(null);
            this.dpEndDate.setSupportedEmpty(false);
        }
    }

    private void initPrmtLoanCompany() {
        this.prmtLoanCompany.setSelector((KDPromptSelector)F7SelectorFactory.getSelectCompany((IUIObject)this, null, null, (boolean)true));
    }

    private void initchkStartDate() {
        this.chkStartDate.setSelected(false);
    }

    private void initCurrency(KDComboBox comboCurrency) {
        CashHelper.initCombCurrency((KDComboBox)comboCurrency, (boolean)false);
        comboCurrency.addItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        comboCurrency.setSelectedItem((Object)FMSysDefinedEnum.ALL_ITEMS);
    }

    private void initPrmtLoan(KDBizPromptBox prmtLoan) {
        prmtLoan.setEditable(true);
    }

    @Override
    public void chkStartDate_actionPerformed(ActionEvent e) {
        if (this.chkStartDate.isSelected()) {
            this.pdStartDate.setEditable(true);
            this.pdStartDate.setEnabled(true);
            this.pdStartDate.setSupportedEmpty(false);
            this.pdStartDate.setValue((Object)new Date());
            this.dpEndDate.setSupportedEmpty(false);
            this.dpEndDate.setValue((Object)new Date());
        } else {
            this.pdStartDate.setEditable(false);
            this.pdStartDate.setEnabled(false);
            this.pdStartDate.setValue(null);
            this.dpEndDate.setSupportedEmpty(false);
        }
    }

    public boolean verify() {
        Set ids;
        if (this.chkStartDate.isSelected() && ((Date)this.dpEndDate.getValue()).compareTo((Date)this.pdStartDate.getValue()) <= 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.CHLoanResource", (String)"enddate_error"));
            this.pdStartDate.setFocusable(true);
            SysUtil.abort();
        }
        if ((ids = AccessHelper.getIds((Object[])AccessHelper.getF7Ids((KDBizPromptBox)this.prmtLoan))) == null || ids.size() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"102_PreIntScopeChooserUI"));
            SysUtil.abort();
        }
        return true;
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.createdIntReceivedID = null;
        super.disposeUIWindow();
    }

    @Override
    public void prmtLoan_willShow(SelectorEvent e) {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        this.setFilterItems(filter);
        evi.setFilter(filter);
        this.prmtLoan.setEntityViewInfo(evi);
        this.prmtLoan.getQueryAgent().resetRuntimeEntityView();
    }

    @Override
    protected void prmtLoanCompany_dataChanged(DataChangeEvent e) throws Exception {
        this.prmtLoan.setData(null);
    }

    @Override
    public void comboCurrency_actionPerformed(ActionEvent e) {
        this.prmtLoan.setValue(null);
        if (this.comboCurrency.getSelectedItem() instanceof FMSysDefinedEnum) {
            // empty if block
        }
    }

    private void setFilterItems(FilterInfo filter) {
        filter.getFilterItems().add(new FilterItemInfo("loanBalance", (Object)Constants.ZERO, CompareType.GREATER));
        filter.getFilterItems().add(new FilterItemInfo("billStatus", (Object)new Integer(4)));
        if (!(this.comboCurrency.getSelectedItem() instanceof FMSysDefinedEnum)) {
            CurrencyInfo info = (CurrencyInfo)this.comboCurrency.getSelectedItem();
            filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)info.getId().toString()));
        }
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString()));
        Object[] obj = (Object[])this.prmtLoanCompany.getData();
        if (!EmptyUtil.isEmpty((Object[])obj)) {
            String[] stringObj = new String[obj.length];
            for (int index = 0; index < obj.length; ++index) {
                stringObj[index] = String.valueOf(obj[index]);
            }
            filter.getFilterItems().add(new FilterItemInfo("applyUnit.name", (Object)FMHelper.Array2Set((String[])stringObj), CompareType.INCLUDE));
        }
    }

    protected EntityViewInfo getEntityView() {
        EntityViewInfo env = this.prmtLoan.getEntityViewInfo();
        if (env == null) {
            env = new EntityViewInfo();
        }
        FilterInfo filter = new FilterInfo();
        this.setFilterItems(filter);
        env.setFilter(filter);
        return env;
    }

    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.verify();
        this.createdIntReceivedID = new HashSet();
        this.createdIntReceivedID.clear();
        this.withFpItemControl();
    }

    protected void withFpItemControl() throws Exception {
        LoanInterestBillCollection loanIntCol = null;
        if (this.prmtLoan.getText().equals(ALL)) {
            ChLoanCollection col = ChLoanFactory.getRemoteInstance().getChLoanCollection(this.getEntityView());
            loanIntCol = LoanInterestBillFactory.getRemoteInstance().batchPreIntWithFpItem(this.convertIDSet(col), (Date)this.pdStartDate.getValue(), (Date)this.dpEndDate.getValue());
        } else {
            Set ids = AccessHelper.getIds((Object[])AccessHelper.getF7Ids((KDBizPromptBox)this.prmtLoan));
            loanIntCol = LoanInterestBillFactory.getRemoteInstance().batchPreIntWithFpItem(ids, (Date)this.pdStartDate.getValue(), (Date)this.dpEndDate.getValue());
        }
        this.getUIContext().put("type", "Pre");
        this.createdIntReceivedID = ModifyFpItemsUI.showModifyFpItemsUI((CoreUI)this, loanIntCol);
        if (this.createdIntReceivedID == null || this.createdIntReceivedID.size() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.CHLoanResource", (String)"not_loanbill"));
            SysUtil.abort();
        } else {
            if (this.getUIContext().get("UIClassParam") != null) {
                // empty if block
            }
            this.hm.clear();
            this.hm.put("createdID", this.createdIntReceivedID);
            this.disposeUIWindow();
        }
    }

    private void withoutFpItemControl() throws Exception {
        if (this.prmtLoan.getText().equals(ALL)) {
            ChLoanCollection col = ChLoanFactory.getRemoteInstance().getChLoanCollection(this.getEntityView());
            this.hm = LoanInterestBillFactory.getRemoteInstance().batchRecInt(this.convertIDSet(col), (Date)this.pdStartDate.getValue(), (Date)this.dpEndDate.getValue());
        } else {
            Set ids = AccessHelper.getIds((Object[])AccessHelper.getF7Ids((KDBizPromptBox)this.prmtLoan));
            this.hm = LoanInterestBillFactory.getRemoteInstance().batchPreInt(ids, (Date)this.pdStartDate.getValue(), (Date)this.dpEndDate.getValue());
        }
        this.createdIntReceivedID = (Set)this.hm.get("createdID");
        if (this.createdIntReceivedID.size() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.CHLoanResource", (String)"not_loanbill"));
            SysUtil.abort();
        } else {
            if (this.getUIContext().get("UIClassParam") != null) {
                // empty if block
            }
            this.disposeUIWindow();
        }
    }

    private void redirctToListUI() {
        try {
            UIContext uiContext = new UIContext((Object)this.ui);
            uiContext.put((Object)"createdids", (Object)this.createdIntReceivedID);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(LoanInterestBillListUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
            uiWindow.show();
        }
        catch (BOSException e) {
            SysUtil.abort();
        }
    }

    protected Set convertIDSet(ChLoanCollection col) {
        HashSet<String> idSets = new HashSet<String>();
        ChLoanInfo info = null;
        for (int i = 0; i < col.size(); ++i) {
            info = col.get(i);
            idSets.add(info.getId().toString());
        }
        if (idSets.size() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.CHLoanResource", (String)"not_loanbill"));
            SysUtil.abort();
        }
        return idSets;
    }

    public static Map showPreIntScopeChooserUI(CoreUI ui) {
        Map returnValue = new HashMap();
        try {
            UIContext uiContext = new UIContext((Object)ui);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(PreIntScopeChooserUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
            uiWindow.show();
            returnValue = ((PreIntScopeChooserUI)uiWindow.getUIObject()).getReturnValueWithMsg();
        }
        catch (BOSException e) {
            SysUtil.abort();
        }
        Set id = (Set)returnValue.get("createdID");
        if (id == null) {
            SysUtil.abort();
        }
        if (id.size() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.CHLoanResource", (String)"not_loanbill"));
        } else {
            String msg = (String)returnValue.get("failureMsg");
            if (msg != null && msg.length() > 0) {
                MsgBox.showInfo((String)msg);
                Object var3_4 = null;
            }
        }
        return returnValue;
    }

    protected Map getReturnValueWithMsg() {
        return this.hm;
    }

    public static Map showRecIntScopeChooserUI(CoreUI ui) {
        Map returnValue = new HashMap();
        try {
            UIContext uiContext = new UIContext((Object)ui);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(RecIntScopeChooserUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
            uiWindow.show();
            returnValue = ((PreIntScopeChooserUI)uiWindow.getUIObject()).getReturnValueWithMsg();
        }
        catch (BOSException e) {
            SysUtil.abort();
        }
        String msg = (String)returnValue.get("failureMsg");
        if (msg != null && msg.length() > 0) {
            MsgBox.showInfo((String)msg);
            msg = null;
        }
        return returnValue;
    }

    private Set getReturnValue() {
        return this.createdIntReceivedID;
    }
}

