/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ivt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPKFactory;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.client.IFMDetailRptHandler;
import com.kingdee.eas.fm.ivt.EarnTypeEnum;
import com.kingdee.eas.fm.ivt.FinancingAccountFactory;
import com.kingdee.eas.fm.ivt.FinancingAccountInfo;
import com.kingdee.eas.fm.ivt.FinancingRedeemCollection;
import com.kingdee.eas.fm.ivt.FinancingRedeemFactory;
import com.kingdee.eas.fm.ivt.FinancingRedeemInfo;
import com.kingdee.eas.fm.ivt.IntRateTypeExpressionEnum;
import com.kingdee.eas.fm.ivt.client.RptFinancingDetailFilterParam;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Color;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Date;

public class RptFinancingDetailHandler
implements IFMDetailRptHandler {
    private KDTable kdtable;
    private static String yes = EASResource.getString((String)"com.kingdee.eas.fm.common.client.FMCommonClientResource", (String)"Yes");
    private RptFinancingDetailFilterParam param;
    private static String no = EASResource.getString((String)"com.kingdee.eas.fm.common.client.FMCommonClientResource", (String)"No");
    private BigDecimal exchangeRate = Constants.ONE;
    private int persion;
    private BigDecimal bdUnit;

    public RptFinancingDetailHandler(KDTable kdtable, RptFinancingDetailFilterParam filterParam) {
        this.param = filterParam;
        this.kdtable = kdtable;
    }

    public void initHeader() {
        this.initFirstHeader();
        IColumn colfinancingProNumber = this.kdtable.addColumn();
        colfinancingProNumber.setKey("financingProNumber");
        colfinancingProNumber.setMergeable(true);
        colfinancingProNumber.setGroup(true);
        IColumn colfinancingProName = this.kdtable.addColumn();
        colfinancingProName.setKey("financingProName");
        colfinancingProName.setMergeable(true);
        colfinancingProName.setGroup(true);
        IColumn colRate = this.kdtable.addColumn();
        colRate.setKey("Rate");
        colRate.setMergeable(true);
        colRate.setGroup(true);
        IColumn colnumber = this.kdtable.addColumn();
        colnumber.setKey("number");
        colnumber.setGroup(true);
        colnumber.setMergeable(true);
        IColumn colfinanceAmount = this.kdtable.addColumn();
        colfinanceAmount.setKey("financeAmount");
        colfinanceAmount.setMergeable(true);
        colfinanceAmount.setGroup(true);
        RptFinancingDetailHandler.initDecimalCell(colfinanceAmount);
        IColumn colfinanceLocAmoumt = this.kdtable.addColumn();
        colfinanceLocAmoumt.setKey("financeLocAmoumt");
        colfinanceLocAmoumt.setMergeable(true);
        colfinanceLocAmoumt.setGroup(true);
        RptFinancingDetailHandler.initDecimalCell(colfinanceLocAmoumt);
        IColumn colbalance = this.kdtable.addColumn();
        colbalance.setKey("balance");
        colbalance.setMergeable(true);
        colbalance.setGroup(true);
        RptFinancingDetailHandler.initDecimalCell(colbalance);
        IColumn colLocbalance = this.kdtable.addColumn();
        colLocbalance.setKey("Locbalance");
        colLocbalance.setMergeable(true);
        colLocbalance.setGroup(true);
        RptFinancingDetailHandler.initDecimalCell(colLocbalance);
        IColumn colbeginDate = this.kdtable.addColumn();
        colbeginDate.setKey("beginDate");
        colbeginDate.setMergeable(true);
        colbeginDate.setGroup(true);
        IColumn colendDat = this.kdtable.addColumn();
        colendDat.setKey("endDate");
        colendDat.setMergeable(true);
        colendDat.setGroup(true);
        IColumn colterm = this.kdtable.addColumn();
        colterm.setKey("term");
        colterm.setMergeable(true);
        colterm.setGroup(true);
        IColumn collastRedeemDate = this.kdtable.addColumn();
        collastRedeemDate.setKey("lastRedeemDate");
        collastRedeemDate.setMergeable(true);
        collastRedeemDate.setGroup(true);
        IColumn colpredictYield = this.kdtable.addColumn();
        colpredictYield.setKey("predictYield");
        colpredictYield.setMergeable(true);
        colpredictYield.setGroup(true);
        IColumn colintRateTypeExpression = this.kdtable.addColumn();
        colintRateTypeExpression.setKey("intRateTypeExpression");
        colintRateTypeExpression.setMergeable(true);
        colintRateTypeExpression.setGroup(true);
        IColumn colpredictWinAmount = this.kdtable.addColumn();
        colpredictWinAmount.setKey("predictWinAmount");
        colpredictWinAmount.setMergeable(true);
        colpredictWinAmount.setGroup(true);
        RptFinancingDetailHandler.initDecimalCell(colpredictWinAmount);
        IColumn colsumpredictWinAmount = this.kdtable.addColumn();
        colsumpredictWinAmount.setKey("sumpredictWinAmount");
        colsumpredictWinAmount.setMergeable(true);
        colsumpredictWinAmount.setGroup(true);
        RptFinancingDetailHandler.initDecimalCell(colsumpredictWinAmount);
        IColumn colisNoOut = this.kdtable.addColumn();
        colisNoOut.setKey("isNoOut");
        colisNoOut.setMergeable(true);
        colisNoOut.setGroup(true);
        IColumn colearnType = this.kdtable.addColumn();
        colearnType.setKey("earnType");
        colearnType.setMergeable(true);
        colearnType.setGroup(true);
        IColumn colbizDate = this.kdtable.addColumn();
        colbizDate.setKey("bizDate");
        colbizDate.setMergeable(true);
        colbizDate.setGroup(true);
        IColumn colcreator = this.kdtable.addColumn();
        colcreator.setKey("creator");
        colcreator.setMergeable(true);
        colcreator.setGroup(true);
        IColumn colredeemNumber = this.kdtable.addColumn();
        colredeemNumber.setKey("redeemNumber");
        IColumn colRedeemDate = this.kdtable.addColumn();
        colRedeemDate.setKey("redeemDate");
        IColumn colamount = this.kdtable.addColumn();
        colamount.setKey("amount");
        RptFinancingDetailHandler.initDecimalCell(colamount);
        IColumn colrealAmount = this.kdtable.addColumn();
        colrealAmount.setKey("realAmount");
        RptFinancingDetailHandler.initDecimalCell(colrealAmount);
        IColumn colid = this.kdtable.addColumn();
        colid.setKey("id");
        StyleAttributes sa = Styles.getEmptySA();
        sa.setHided(true);
        colid.setStyleAttributes(sa);
        this.formatHeadRow();
    }

    private void initFirstHeader() {
        switch (this.param.getDimType()) {
            case 1: {
                this.setComapnyPanel();
                break;
            }
            case 2: {
                this.setBankPanel();
                break;
            }
            case 3: {
                this.setFinanceFinancingPanel();
                break;
            }
            case 4: {
                this.setCurrencyPanel();
                break;
            }
            case 5: {
                this.setaccountPanel();
                break;
            }
            default: {
                this.setComapnyPanel();
            }
        }
    }

    private void setaccountPanel() {
        IColumn colaccountNumber = this.kdtable.addColumn();
        colaccountNumber.setKey("accountNumber");
        colaccountNumber.setMergeable(true);
        colaccountNumber.setGroup(true);
        this.kdtable.getColumn("accountNumber").setStat(true);
        IColumn colCompany = this.kdtable.addColumn();
        colCompany.setKey("company");
        colCompany.setMergeable(true);
        colCompany.setGroup(true);
        IColumn colBank = this.kdtable.addColumn();
        colBank.setKey("bank");
        colBank.setGroup(true);
        colBank.setMergeable(true);
        IColumn colFinanceFinancing = this.kdtable.addColumn();
        colFinanceFinancing.setKey("financeFinancing");
        colFinanceFinancing.setGroup(true);
        IColumn colCurrency = this.kdtable.addColumn();
        colCurrency.setKey("currency");
        colCurrency.setMergeable(true);
        colCurrency.setGroup(true);
    }

    private void setCurrencyPanel() {
        IColumn colCurrency = this.kdtable.addColumn();
        colCurrency.setKey("currency");
        colCurrency.setMergeable(true);
        colCurrency.setGroup(true);
        this.kdtable.getColumn("currency").setStat(true);
        IColumn colCompany = this.kdtable.addColumn();
        colCompany.setKey("company");
        colCompany.setMergeable(true);
        colCompany.setGroup(true);
        IColumn colBank = this.kdtable.addColumn();
        colBank.setKey("bank");
        colBank.setGroup(true);
        colBank.setMergeable(true);
        IColumn colaccountNumber = this.kdtable.addColumn();
        colaccountNumber.setKey("accountNumber");
        colaccountNumber.setMergeable(true);
        colaccountNumber.setGroup(true);
        IColumn colFinanceFinancing = this.kdtable.addColumn();
        colFinanceFinancing.setKey("financeFinancing");
        colFinanceFinancing.setGroup(true);
    }

    private void setFinanceFinancingPanel() {
        IColumn colFinanceFinancing = this.kdtable.addColumn();
        colFinanceFinancing.setKey("financeFinancing");
        colFinanceFinancing.setGroup(true);
        colFinanceFinancing.setMergeable(true);
        this.kdtable.getColumn("financeFinancing").setStat(true);
        IColumn colCompany = this.kdtable.addColumn();
        colCompany.setKey("company");
        colCompany.setMergeable(true);
        colCompany.setGroup(true);
        IColumn colBank = this.kdtable.addColumn();
        colBank.setKey("bank");
        colBank.setGroup(true);
        colBank.setMergeable(true);
        IColumn colaccountNumber = this.kdtable.addColumn();
        colaccountNumber.setKey("accountNumber");
        colaccountNumber.setMergeable(true);
        colaccountNumber.setGroup(true);
        IColumn colCurrency = this.kdtable.addColumn();
        colCurrency.setKey("currency");
        colCurrency.setMergeable(true);
        colCurrency.setGroup(true);
    }

    private void setBankPanel() {
        IColumn colBank = this.kdtable.addColumn();
        colBank.setKey("bank");
        colBank.setGroup(true);
        colBank.setMergeable(true);
        this.kdtable.getColumn("bank").setStat(true);
        IColumn colCompany = this.kdtable.addColumn();
        colCompany.setKey("company");
        colCompany.setMergeable(true);
        colCompany.setGroup(true);
        IColumn colaccountNumber = this.kdtable.addColumn();
        colaccountNumber.setKey("accountNumber");
        colaccountNumber.setMergeable(true);
        colaccountNumber.setGroup(true);
        IColumn colFinanceFinancing = this.kdtable.addColumn();
        colFinanceFinancing.setKey("financeFinancing");
        colFinanceFinancing.setGroup(true);
        IColumn colCurrency = this.kdtable.addColumn();
        colCurrency.setKey("currency");
        colCurrency.setMergeable(true);
        colCurrency.setGroup(true);
    }

    private void setComapnyPanel() {
        IColumn colCompany = this.kdtable.addColumn();
        colCompany.setKey("company");
        colCompany.setMergeable(true);
        colCompany.setGroup(true);
        this.kdtable.getColumn("company").setStat(true);
        IColumn colBank = this.kdtable.addColumn();
        colBank.setKey("bank");
        colBank.setGroup(true);
        colBank.setMergeable(true);
        IColumn colaccountNumber = this.kdtable.addColumn();
        colaccountNumber.setKey("accountNumber");
        colaccountNumber.setMergeable(true);
        colaccountNumber.setGroup(true);
        IColumn colFinanceFinancing = this.kdtable.addColumn();
        colFinanceFinancing.setKey("financeFinancing");
        colFinanceFinancing.setGroup(true);
        IColumn colCurrency = this.kdtable.addColumn();
        colCurrency.setKey("currency");
        colCurrency.setMergeable(true);
        colCurrency.setGroup(true);
    }

    private void formatHeadRow() {
        IRow row = this.kdtable.addHeadRow();
        row.getCell("company").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"606_organization"));
        row.getCell("bank").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"607_bank"));
        row.getCell("accountNumber").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"608_financialAccount"));
        row.getCell("financeFinancing").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"609_financialType"));
        row.getCell("financingProNumber").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"610_financialNumber"));
        row.getCell("financingProName").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"611_financialName"));
        row.getCell("currency").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"612_currency"));
        row.getCell("Rate").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"613_exchange"));
        row.getCell("number").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"614_financialBillNumber"));
        row.getCell("financeAmount").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"615_financialAmount"));
        row.getCell("financeLocAmoumt").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"616_financialLocalAmount"));
        row.getCell("balance").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"617_financialBalance"));
        row.getCell("Locbalance").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"618_financialBalanceLocal"));
        row.getCell("beginDate").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"619_financialStarDate"));
        row.getCell("endDate").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"620_financialEndDate"));
        row.getCell("term").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"621_financialTern"));
        row.getCell("lastRedeemDate").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"622_lastRedeemDate"));
        row.getCell("predictYield").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"623_PredictYield"));
        row.getCell("intRateTypeExpression").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"624_interesRepre"));
        row.getCell("predictWinAmount").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"625_PredictYieldAmount"));
        row.getCell("sumpredictWinAmount").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"626_accumulateAmount"));
        row.getCell("isNoOut").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"627_isGuaranteed"));
        row.getCell("earnType").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"628_yieldType"));
        row.getCell("bizDate").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"629_bizDate"));
        row.getCell("creator").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"630_creator"));
        row.getCell("redeemNumber").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"631_redeemContent"));
        row.getCell("redeemDate").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"632_redeemDate"));
        row.getCell("amount").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"633_redeemAmount"));
        row.getCell("realAmount").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"634_actualIncome"));
        row.getCell("id").setValue((Object)"Id");
    }

    public void filldata(IRowSet rs) throws SQLException, EASBizException, BOSException {
        BigDecimal redeemSummount = Constants.ZERO;
        Object id = null;
        while (rs.next()) {
            IRow row = this.kdtable.addRow();
            row.getCell("company").setValue((Object)rs.getString("company.name"));
            row.getCell("bank").setValue((Object)rs.getString("bank.name"));
            row.getCell("accountNumber").setValue((Object)rs.getString("accountBank.bankAccountNumber"));
            row.getCell("financeFinancing").setValue((Object)rs.getString("financeFinancing.name"));
            row.getCell("financingProNumber").setValue((Object)rs.getString("financingProNumber"));
            row.getCell("financingProName").setValue((Object)rs.getString("financingProName"));
            row.getCell("currency").setValue((Object)rs.getString("currency.name"));
            row.getCell("Rate").setValue((Object)rs.getString("exchangeRate"));
            row.getCell("number").setValue((Object)rs.getString("number"));
            row.getCell("financeAmount").setValue((Object)new BigDecimal(rs.getString("financeAmount")).divide(this.bdUnit));
            if (rs.getString("financeLocAmount") != null) {
                row.getCell("financeLocAmoumt").setValue((Object)new BigDecimal(rs.getString("financeLocAmount")).divide(this.bdUnit));
            } else {
                row.getCell("financeLocAmoumt").setValue((Object)Constants.ZERO);
            }
            row.getCell("beginDate").setValue((Object)rs.getString("beginDate"));
            row.getCell("endDate").setValue((Object)rs.getString("endDate"));
            row.getCell("term").setValue((Object)rs.getString("term"));
            row.getCell("predictYield").setValue((Object)rs.getString("predictYield"));
            row.getCell("intRateTypeExpression").setValue((Object)IntRateTypeExpressionEnum.getEnum(rs.getString("intRateTypeExpression")));
            IntRateTypeExpressionEnum exp = (IntRateTypeExpressionEnum)((Object)row.getCell("intRateTypeExpression").getValue());
            String enu = exp.getValue();
            if ("year".equalsIgnoreCase(enu.toString())) {
                row.getCell("predictYield").getStyleAttributes().setNumberFormat("#,##0.00000\\%");
            } else {
                row.getCell("predictYield").getStyleAttributes().setNumberFormat("#,##0.00000\\\u2030");
            }
            if (rs.getString("predictWinAmount") != null) {
                row.getCell("predictWinAmount").setValue((Object)new BigDecimal(rs.getString("predictWinAmount")).divide(this.bdUnit));
            } else {
                row.getCell("predictWinAmount").setValue((Object)Constants.ZERO);
            }
            row.getCell("isNoOut").setValue((Object)(rs.getBoolean("isNoOut") ? yes : no));
            if (rs.getString("earnType") != null) {
                row.getCell("earnType").setValue((Object)EarnTypeEnum.getEnum(Integer.parseInt(rs.getString("earnType"))));
            }
            row.getCell("bizDate").setValue((Object)rs.getString("bizDate"));
            row.getCell("redeemNumber").setValue((Object)rs.getString("financingRedeem.number"));
            row.getCell("redeemDate").setValue((Object)rs.getString("financingRedeem.redeemDate"));
            this.setPersion(rs.getString("currency.id"));
            if (rs.getString("financingRedeem.redeemAmount") != null) {
                row.getCell("amount").setValue((Object)new BigDecimal(rs.getString("financingRedeem.redeemAmount")).divide(this.bdUnit).setScale(this.persion, 4));
            } else {
                row.getCell("amount").setValue((Object)Constants.ZERO);
            }
            if (rs.getString("financingRedeem.practicalWinAmount") != null) {
                row.getCell("realAmount").setValue((Object)new BigDecimal(rs.getString("financingRedeem.practicalWinAmount")).divide(this.bdUnit).setScale(this.persion, 4));
            } else {
                row.getCell("realAmount").setValue((Object)Constants.ZERO);
            }
            row.getCell("id").setValue((Object)rs.getString("id"));
            this.setLeiji(rs.getString("id"), row, rs);
        }
    }

    private void setPersion(String id) throws EASBizException, BOSException {
        CurrencyInfo currencyInfo = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(id));
        this.persion = currencyInfo.getPrecision();
    }

    private void setLeiji(String sourceBillIid, IRow row, IRowSet rs) throws BOSException, SQLException, EASBizException {
        FilterInfo filterInfo = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("creator.name"));
        FinancingAccountInfo accountInfo = FinancingAccountFactory.getRemoteInstance().getFinancingAccountInfo((IObjectPK)new ObjectUuidPK(sourceBillIid), sic);
        row.getCell("creator").setValue((Object)accountInfo.getCreator().getName());
        filterInfo.getFilterItems().add(new FilterItemInfo("sourceBillId", (Object)sourceBillIid, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("redeemDate", (Object)this.param.getEndate(), CompareType.LESS_EQUALS));
        SorterItemCollection sc = new SorterItemCollection();
        SorterItemInfo sorterItem = new SorterItemInfo("redeemDate");
        sorterItem.setSortType(SortType.DESCEND);
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(filterInfo);
        entityViewInfo.setSorter(sc);
        FinancingRedeemCollection collection = FinancingRedeemFactory.getRemoteInstance().getFinancingRedeemCollection(entityViewInfo);
        BigDecimal sumRedemmAmount = Constants.ZERO;
        BigDecimal sumWinAmount = Constants.ZERO;
        Date maxRedeemDate = null;
        for (int i = 0; i < collection.size(); ++i) {
            FinancingRedeemInfo info = collection.get(i);
            FinancingRedeemInfo firstInfo = collection.get(0);
            maxRedeemDate = firstInfo.getRedeemDate();
            sumRedemmAmount = sumRedemmAmount.add(info.getRedeemAmount());
            if (info.getPracticalWinAmount() == null) continue;
            sumWinAmount = sumWinAmount.add(info.getPracticalWinAmount());
        }
        row.getCell("sumpredictWinAmount").setValue((Object)sumWinAmount.divide(this.bdUnit).setScale(this.persion, 4));
        row.getCell("balance").setValue((Object)new BigDecimal(rs.getString("financeAmount")).subtract(sumRedemmAmount).setScale(this.persion, 4).divide(this.bdUnit));
        row.getCell("Locbalance").setValue((Object)new BigDecimal(rs.getString("financeAmount")).subtract(sumRedemmAmount).multiply(this.exchangeRate).setScale(this.persion, 4).divide(this.bdUnit));
        row.getCell("lastRedeemDate").setValue((Object)maxRedeemDate);
    }

    public void setTableStateRow() {
        switch (this.param.getDimType()) {
            case 1: {
                this.setCompanyTableStateRow();
                break;
            }
            case 2: {
                this.setBankTableStateRow();
                break;
            }
            case 3: {
                this.setFinTableStateRow();
                break;
            }
            case 4: {
                this.setCurrencyTableStateRow();
                break;
            }
            case 5: {
                this.setaccountNumberTableStateRow();
                break;
            }
            default: {
                this.setCompanyTableStateRow();
            }
        }
    }

    private void setaccountNumberTableStateRow() {
        this.kdtable.getColumn("accountNumber").setStat(true);
        this.kdtable.getColumn("number").setStat(true);
        this.kdtable.getGroupManager().setTotalize(true);
        IRow rowLongTotal = this.kdtable.getGroupManager().getStatRowTemplate(-1);
        rowLongTotal.getCell("financeAmount").setExpressions("SUM");
        rowLongTotal.getStyleAttributes().setBackground(new Color(0xF6F6B6));
        rowLongTotal.getCell("financeAmount").getStyleAttributes().setBackground(new Color(0xF6F6B6));
        RptFinancingDetailHandler.initDecimalCell(rowLongTotal.getCell("financeAmount"));
        rowLongTotal.getCell("financeLocAmoumt").setExpressions("SUM");
        rowLongTotal.getStyleAttributes().setBackground(new Color(0xF6F6B6));
        rowLongTotal.getCell("financeLocAmoumt").getStyleAttributes().setBackground(new Color(0xF6F6B6));
        RptFinancingDetailHandler.initDecimalCell(rowLongTotal.getCell("financeLocAmoumt"));
        rowLongTotal.getCell("balance").setExpressions("SUM");
        rowLongTotal.getStyleAttributes().setBackground(new Color(0xF6F6B6));
        rowLongTotal.getCell("balance").getStyleAttributes().setBackground(new Color(0xF6F6B6));
        RptFinancingDetailHandler.initDecimalCell(rowLongTotal.getCell("balance"));
        rowLongTotal.getCell("Locbalance").setExpressions("SUM");
        rowLongTotal.getStyleAttributes().setBackground(new Color(0xF6F6B6));
        rowLongTotal.getCell("Locbalance").getStyleAttributes().setBackground(new Color(0xF6F6B6));
        RptFinancingDetailHandler.initDecimalCell(rowLongTotal.getCell("Locbalance"));
        rowLongTotal.getCell("sumpredictWinAmount").setExpressions("SUM");
        rowLongTotal.getStyleAttributes().setBackground(new Color(0xF6F6B6));
        rowLongTotal.getCell("sumpredictWinAmount").getStyleAttributes().setBackground(new Color(0xF6F6B6));
        RptFinancingDetailHandler.initDecimalCell(rowLongTotal.getCell("sumpredictWinAmount"));
        rowLongTotal.getCell("predictWinAmount").setExpressions("SUM");
        rowLongTotal.getStyleAttributes().setBackground(new Color(0xF6F6B6));
        rowLongTotal.getCell("predictWinAmount").getStyleAttributes().setBackground(new Color(0xF6F6B6));
        RptFinancingDetailHandler.initDecimalCell(rowLongTotal.getCell("predictWinAmount"));
        rowLongTotal.getCell("accountNumber").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"635_total"));
        IRow rowTotal = this.kdtable.getGroupManager().getStatRowTemplate(0);
        rowTotal.getCell("financeAmount").setExpressions("SUM");
        rowTotal.getStyleAttributes().setBackground(new Color(0xF6F6B6));
        rowTotal.getCell("financeAmount").getStyleAttributes().setBackground(new Color(0xF6F6B6));
        RptFinancingDetailHandler.initDecimalCell(rowTotal.getCell("financeAmount"));
        rowTotal.getCell("accountNumber").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"313_LoanEditUI"));
        rowTotal.getCell("financeLocAmoumt").setExpressions("SUM");
        rowTotal.getStyleAttributes().setBackground(new Color(0xF6F6B6));
        rowTotal.getCell("financeLocAmoumt").getStyleAttributes().setBackground(new Color(0xF6F6B6));
        RptFinancingDetailHandler.initDecimalCell(rowTotal.getCell("financeLocAmoumt"));
        rowTotal.getCell("balance").setExpressions("SUM");
        rowTotal.getStyleAttributes().setBackground(new Color(0xF6F6B6));
        rowTotal.getCell("balance").getStyleAttributes().setBackground(new Color(0xF6F6B6));
        RptFinancingDetailHandler.initDecimalCell(rowTotal.getCell("balance"));
        rowTotal.getCell("Locbalance").setExpressions("SUM");
        rowTotal.getStyleAttributes().setBackground(new Color(0xF6F6B6));
        rowTotal.getCell("Locbalance").getStyleAttributes().setBackground(new Color(0xF6F6B6));
        RptFinancingDetailHandler.initDecimalCell(rowTotal.getCell("Locbalance"));
        int index = this.kdtable.getColumn("number").getColumnIndex();
        IRow rowPlanRepay = this.kdtable.getGroupManager().getStatRowTemplate(index);
        rowPlanRepay.getCell("amount").setExpressions("SUM");
        rowPlanRepay.getStyleAttributes().setBackground(new Color(16119270));
        rowPlanRepay.getCell("amount").getStyleAttributes().setBackground(new Color(16119270));
        RptFinancingDetailHandler.initDecimalCell(rowPlanRepay.getCell("amount"));
        rowPlanRepay.getCell("realAmount").setExpressions("SUM");
        rowPlanRepay.getCell("realAmount").getStyleAttributes().setBackground(new Color(16119270));
        rowPlanRepay.getCell("realAmount").getStyleAttributes().setBackground(new Color(16119270));
        RptFinancingDetailHandler.initDecimalCell(rowPlanRepay.getCell("realAmount"));
        rowPlanRepay.getCell("number").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"302_LoanEditUI"));
    }

    private void setCurrencyTableStateRow() {
        this.kdtable.getColumn("currency").setStat(true);
        this.kdtable.getColumn("number").setStat(true);
        this.kdtable.getGroupManager().setTotalize(true);
        IRow rowLongTotal = this.kdtable.getGroupManager().getStatRowTemplate(-1);
        rowLongTotal.getCell("financeAmount").setExpressions("SUM");
        rowLongTotal.getStyleAttributes().setBackground(new Color(0xF6F6B6));
        rowLongTotal.getCell("financeAmount").getStyleAttributes().setBackground(new Color(0xF6F6B6));
        RptFinancingDetailHandler.initDecimalCell(rowLongTotal.getCell("financeAmount"));
        rowLongTotal.getCell("financeLocAmoumt").setExpressions("SUM");
        rowLongTotal.getStyleAttributes().setBackground(new Color(0xF6F6B6));
        rowLongTotal.getCell("financeLocAmoumt").getStyleAttributes().setBackground(new Color(0xF6F6B6));
        RptFinancingDetailHandler.initDecimalCell(rowLongTotal.getCell("financeLocAmoumt"));
        rowLongTotal.getCell("balance").setExpressions("SUM");
        rowLongTotal.getStyleAttributes().setBackground(new Color(0xF6F6B6));
        rowLongTotal.getCell("balance").getStyleAttributes().setBackground(new Color(0xF6F6B6));
        RptFinancingDetailHandler.initDecimalCell(rowLongTotal.getCell("balance"));
        rowLongTotal.getCell("Locbalance").setExpressions("SUM");
        rowLongTotal.getStyleAttributes().setBackground(new Color(0xF6F6B6));
        rowLongTotal.getCell("Locbalance").getStyleAttributes().setBackground(new Color(0xF6F6B6));
        RptFinancingDetailHandler.initDecimalCell(rowLongTotal.getCell("Locbalance"));
        rowLongTotal.getCell("sumpredictWinAmount").setExpressions("SUM");
        rowLongTotal.getStyleAttributes().setBackground(new Color(0xF6F6B6));
        rowLongTotal.getCell("sumpredictWinAmount").getStyleAttributes().setBackground(new Color(0xF6F6B6));
        RptFinancingDetailHandler.initDecimalCell(rowLongTotal.getCell("sumpredictWinAmount"));
        rowLongTotal.getCell("predictWinAmount").setExpressions("SUM");
        rowLongTotal.getStyleAttributes().setBackground(new Color(0xF6F6B6));
        rowLongTotal.getCell("predictWinAmount").getStyleAttributes().setBackground(new Color(0xF6F6B6));
        RptFinancingDetailHandler.initDecimalCell(rowLongTotal.getCell("predictWinAmount"));
        rowLongTotal.getCell("currency").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"635_total"));
        IRow rowTotal = this.kdtable.getGroupManager().getStatRowTemplate(0);
        rowTotal.getCell("financeAmount").setExpressions("SUM");
        rowTotal.getStyleAttributes().setBackground(new Color(0xF6F6B6));
        rowTotal.getCell("financeAmount").getStyleAttributes().setBackground(new Color(0xF6F6B6));
        RptFinancingDetailHandler.initDecimalCell(rowTotal.getCell("financeAmount"));
        rowTotal.getCell("currency").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"313_LoanEditUI"));
        rowTotal.getCell("financeLocAmoumt").setExpressions("SUM");
        rowTotal.getStyleAttributes().setBackground(new Color(0xF6F6B6));
        rowTotal.getCell("financeLocAmoumt").getStyleAttributes().setBackground(new Color(0xF6F6B6));
        RptFinancingDetailHandler.initDecimalCell(rowTotal.getCell("financeLocAmoumt"));
        rowTotal.getCell("balance").setExpressions("SUM");
        rowTotal.getStyleAttributes().setBackground(new Color(0xF6F6B6));
        rowTotal.getCell("balance").getStyleAttributes().setBackground(new Color(0xF6F6B6));
        RptFinancingDetailHandler.initDecimalCell(rowTotal.getCell("balance"));
        rowTotal.getCell("Locbalance").setExpressions("SUM");
        rowTotal.getStyleAttributes().setBackground(new Color(0xF6F6B6));
        rowTotal.getCell("Locbalance").getStyleAttributes().setBackground(new Color(0xF6F6B6));
        RptFinancingDetailHandler.initDecimalCell(rowTotal.getCell("Locbalance"));
        int index = this.kdtable.getColumn("number").getColumnIndex();
        IRow rowPlanRepay = this.kdtable.getGroupManager().getStatRowTemplate(index);
        rowPlanRepay.getCell("amount").setExpressions("SUM");
        rowPlanRepay.getStyleAttributes().setBackground(new Color(16119270));
        rowPlanRepay.getCell("amount").getStyleAttributes().setBackground(new Color(16119270));
        RptFinancingDetailHandler.initDecimalCell(rowPlanRepay.getCell("amount"));
        rowPlanRepay.getCell("realAmount").setExpressions("SUM");
        rowPlanRepay.getCell("realAmount").getStyleAttributes().setBackground(new Color(16119270));
        rowPlanRepay.getCell("realAmount").getStyleAttributes().setBackground(new Color(16119270));
        RptFinancingDetailHandler.initDecimalCell(rowPlanRepay.getCell("realAmount"));
        rowPlanRepay.getCell("number").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"302_LoanEditUI"));
    }

    private void setFinTableStateRow() {
        this.kdtable.getColumn("financeFinancing").setStat(true);
        this.kdtable.getColumn("number").setStat(true);
        this.kdtable.getGroupManager().setTotalize(true);
        IRow rowLongTotal = this.kdtable.getGroupManager().getStatRowTemplate(-1);
        rowLongTotal.getCell("financeAmount").setExpressions("SUM");
        rowLongTotal.getStyleAttributes().setBackground(new Color(0xF6F6B6));
        rowLongTotal.getCell("financeAmount").getStyleAttributes().setBackground(new Color(0xF6F6B6));
        RptFinancingDetailHandler.initDecimalCell(rowLongTotal.getCell("financeAmount"));
        rowLongTotal.getCell("financeLocAmoumt").setExpressions("SUM");
        rowLongTotal.getStyleAttributes().setBackground(new Color(0xF6F6B6));
        rowLongTotal.getCell("financeLocAmoumt").getStyleAttributes().setBackground(new Color(0xF6F6B6));
        RptFinancingDetailHandler.initDecimalCell(rowLongTotal.getCell("financeLocAmoumt"));
        rowLongTotal.getCell("balance").setExpressions("SUM");
        rowLongTotal.getStyleAttributes().setBackground(new Color(0xF6F6B6));
        rowLongTotal.getCell("balance").getStyleAttributes().setBackground(new Color(0xF6F6B6));
        RptFinancingDetailHandler.initDecimalCell(rowLongTotal.getCell("balance"));
        rowLongTotal.getCell("Locbalance").setExpressions("SUM");
        rowLongTotal.getStyleAttributes().setBackground(new Color(0xF6F6B6));
        rowLongTotal.getCell("Locbalance").getStyleAttributes().setBackground(new Color(0xF6F6B6));
        RptFinancingDetailHandler.initDecimalCell(rowLongTotal.getCell("Locbalance"));
        rowLongTotal.getCell("sumpredictWinAmount").setExpressions("SUM");
        rowLongTotal.getStyleAttributes().setBackground(new Color(0xF6F6B6));
        rowLongTotal.getCell("sumpredictWinAmount").getStyleAttributes().setBackground(new Color(0xF6F6B6));
        RptFinancingDetailHandler.initDecimalCell(rowLongTotal.getCell("sumpredictWinAmount"));
        rowLongTotal.getCell("predictWinAmount").setExpressions("SUM");
        rowLongTotal.getStyleAttributes().setBackground(new Color(0xF6F6B6));
        rowLongTotal.getCell("predictWinAmount").getStyleAttributes().setBackground(new Color(0xF6F6B6));
        RptFinancingDetailHandler.initDecimalCell(rowLongTotal.getCell("predictWinAmount"));
        rowLongTotal.getCell("financeFinancing").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"635_total"));
        IRow rowTotal = this.kdtable.getGroupManager().getStatRowTemplate(0);
        rowTotal.getCell("financeAmount").setExpressions("SUM");
        rowTotal.getStyleAttributes().setBackground(new Color(0xF6F6B6));
        rowTotal.getCell("financeAmount").getStyleAttributes().setBackground(new Color(0xF6F6B6));
        RptFinancingDetailHandler.initDecimalCell(rowTotal.getCell("financeAmount"));
        rowTotal.getCell("financeFinancing").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"313_LoanEditUI"));
        rowTotal.getCell("financeLocAmoumt").setExpressions("SUM");
        rowTotal.getStyleAttributes().setBackground(new Color(0xF6F6B6));
        rowTotal.getCell("financeLocAmoumt").getStyleAttributes().setBackground(new Color(0xF6F6B6));
        RptFinancingDetailHandler.initDecimalCell(rowTotal.getCell("financeLocAmoumt"));
        rowTotal.getCell("balance").setExpressions("SUM");
        rowTotal.getStyleAttributes().setBackground(new Color(0xF6F6B6));
        rowTotal.getCell("balance").getStyleAttributes().setBackground(new Color(0xF6F6B6));
        RptFinancingDetailHandler.initDecimalCell(rowTotal.getCell("balance"));
        rowTotal.getCell("Locbalance").setExpressions("SUM");
        rowTotal.getStyleAttributes().setBackground(new Color(0xF6F6B6));
        rowTotal.getCell("Locbalance").getStyleAttributes().setBackground(new Color(0xF6F6B6));
        RptFinancingDetailHandler.initDecimalCell(rowTotal.getCell("Locbalance"));
        int index = this.kdtable.getColumn("number").getColumnIndex();
        IRow rowPlanRepay = this.kdtable.getGroupManager().getStatRowTemplate(index);
        rowPlanRepay.getCell("amount").setExpressions("SUM");
        rowPlanRepay.getStyleAttributes().setBackground(new Color(16119270));
        rowPlanRepay.getCell("amount").getStyleAttributes().setBackground(new Color(16119270));
        RptFinancingDetailHandler.initDecimalCell(rowPlanRepay.getCell("amount"));
        rowPlanRepay.getCell("realAmount").setExpressions("SUM");
        rowPlanRepay.getCell("realAmount").getStyleAttributes().setBackground(new Color(16119270));
        rowPlanRepay.getCell("realAmount").getStyleAttributes().setBackground(new Color(16119270));
        RptFinancingDetailHandler.initDecimalCell(rowPlanRepay.getCell("realAmount"));
        rowPlanRepay.getCell("number").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"302_LoanEditUI"));
    }

    private void setBankTableStateRow() {
        this.kdtable.getColumn("bank").setStat(true);
        this.kdtable.getColumn("number").setStat(true);
        this.kdtable.getGroupManager().setTotalize(true);
        IRow rowLongTotal = this.kdtable.getGroupManager().getStatRowTemplate(-1);
        rowLongTotal.getCell("financeAmount").setExpressions("SUM");
        rowLongTotal.getStyleAttributes().setBackground(new Color(0xF6F6B6));
        rowLongTotal.getCell("financeAmount").getStyleAttributes().setBackground(new Color(0xF6F6B6));
        RptFinancingDetailHandler.initDecimalCell(rowLongTotal.getCell("financeAmount"));
        rowLongTotal.getCell("financeLocAmoumt").setExpressions("SUM");
        rowLongTotal.getStyleAttributes().setBackground(new Color(0xF6F6B6));
        rowLongTotal.getCell("financeLocAmoumt").getStyleAttributes().setBackground(new Color(0xF6F6B6));
        RptFinancingDetailHandler.initDecimalCell(rowLongTotal.getCell("financeLocAmoumt"));
        rowLongTotal.getCell("balance").setExpressions("SUM");
        rowLongTotal.getStyleAttributes().setBackground(new Color(0xF6F6B6));
        rowLongTotal.getCell("balance").getStyleAttributes().setBackground(new Color(0xF6F6B6));
        RptFinancingDetailHandler.initDecimalCell(rowLongTotal.getCell("balance"));
        rowLongTotal.getCell("Locbalance").setExpressions("SUM");
        rowLongTotal.getStyleAttributes().setBackground(new Color(0xF6F6B6));
        rowLongTotal.getCell("Locbalance").getStyleAttributes().setBackground(new Color(0xF6F6B6));
        RptFinancingDetailHandler.initDecimalCell(rowLongTotal.getCell("Locbalance"));
        rowLongTotal.getCell("sumpredictWinAmount").setExpressions("SUM");
        rowLongTotal.getStyleAttributes().setBackground(new Color(0xF6F6B6));
        rowLongTotal.getCell("sumpredictWinAmount").getStyleAttributes().setBackground(new Color(0xF6F6B6));
        RptFinancingDetailHandler.initDecimalCell(rowLongTotal.getCell("sumpredictWinAmount"));
        rowLongTotal.getCell("predictWinAmount").setExpressions("SUM");
        rowLongTotal.getStyleAttributes().setBackground(new Color(0xF6F6B6));
        rowLongTotal.getCell("predictWinAmount").getStyleAttributes().setBackground(new Color(0xF6F6B6));
        RptFinancingDetailHandler.initDecimalCell(rowLongTotal.getCell("predictWinAmount"));
        rowLongTotal.getCell("bank").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"635_total"));
        IRow rowTotal = this.kdtable.getGroupManager().getStatRowTemplate(0);
        rowTotal.getCell("financeAmount").setExpressions("SUM");
        rowTotal.getStyleAttributes().setBackground(new Color(0xF6F6B6));
        rowTotal.getCell("financeAmount").getStyleAttributes().setBackground(new Color(0xF6F6B6));
        RptFinancingDetailHandler.initDecimalCell(rowTotal.getCell("financeAmount"));
        rowTotal.getCell("bank").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"313_LoanEditUI"));
        rowTotal.getCell("financeLocAmoumt").setExpressions("SUM");
        rowTotal.getStyleAttributes().setBackground(new Color(0xF6F6B6));
        rowTotal.getCell("financeLocAmoumt").getStyleAttributes().setBackground(new Color(0xF6F6B6));
        RptFinancingDetailHandler.initDecimalCell(rowTotal.getCell("financeLocAmoumt"));
        rowTotal.getCell("balance").setExpressions("SUM");
        rowTotal.getStyleAttributes().setBackground(new Color(0xF6F6B6));
        rowTotal.getCell("balance").getStyleAttributes().setBackground(new Color(0xF6F6B6));
        RptFinancingDetailHandler.initDecimalCell(rowTotal.getCell("balance"));
        rowTotal.getCell("Locbalance").setExpressions("SUM");
        rowTotal.getStyleAttributes().setBackground(new Color(0xF6F6B6));
        rowTotal.getCell("Locbalance").getStyleAttributes().setBackground(new Color(0xF6F6B6));
        RptFinancingDetailHandler.initDecimalCell(rowTotal.getCell("Locbalance"));
        int index = this.kdtable.getColumn("number").getColumnIndex();
        IRow rowPlanRepay = this.kdtable.getGroupManager().getStatRowTemplate(index);
        rowPlanRepay.getCell("amount").setExpressions("SUM");
        rowPlanRepay.getStyleAttributes().setBackground(new Color(16119270));
        rowPlanRepay.getCell("amount").getStyleAttributes().setBackground(new Color(16119270));
        RptFinancingDetailHandler.initDecimalCell(rowPlanRepay.getCell("amount"));
        rowPlanRepay.getCell("realAmount").setExpressions("SUM");
        rowPlanRepay.getCell("realAmount").getStyleAttributes().setBackground(new Color(16119270));
        rowPlanRepay.getCell("realAmount").getStyleAttributes().setBackground(new Color(16119270));
        RptFinancingDetailHandler.initDecimalCell(rowPlanRepay.getCell("realAmount"));
        rowPlanRepay.getCell("number").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"302_LoanEditUI"));
    }

    private void setCompanyTableStateRow() {
        this.kdtable.getColumn("company").setStat(true);
        this.kdtable.getColumn("number").setStat(true);
        this.kdtable.getGroupManager().setTotalize(true);
        IRow rowLongTotal = this.kdtable.getGroupManager().getStatRowTemplate(-1);
        rowLongTotal.getCell("financeAmount").setExpressions("SUM");
        rowLongTotal.getStyleAttributes().setBackground(new Color(0xF6F6B6));
        rowLongTotal.getCell("financeAmount").getStyleAttributes().setBackground(new Color(0xF6F6B6));
        RptFinancingDetailHandler.initDecimalCell(rowLongTotal.getCell("financeAmount"));
        rowLongTotal.getCell("financeLocAmoumt").setExpressions("SUM");
        rowLongTotal.getStyleAttributes().setBackground(new Color(0xF6F6B6));
        rowLongTotal.getCell("financeLocAmoumt").getStyleAttributes().setBackground(new Color(0xF6F6B6));
        RptFinancingDetailHandler.initDecimalCell(rowLongTotal.getCell("financeLocAmoumt"));
        rowLongTotal.getCell("balance").setExpressions("SUM");
        rowLongTotal.getStyleAttributes().setBackground(new Color(0xF6F6B6));
        rowLongTotal.getCell("balance").getStyleAttributes().setBackground(new Color(0xF6F6B6));
        RptFinancingDetailHandler.initDecimalCell(rowLongTotal.getCell("balance"));
        rowLongTotal.getCell("Locbalance").setExpressions("SUM");
        rowLongTotal.getStyleAttributes().setBackground(new Color(0xF6F6B6));
        rowLongTotal.getCell("Locbalance").getStyleAttributes().setBackground(new Color(0xF6F6B6));
        RptFinancingDetailHandler.initDecimalCell(rowLongTotal.getCell("Locbalance"));
        rowLongTotal.getCell("sumpredictWinAmount").setExpressions("SUM");
        rowLongTotal.getStyleAttributes().setBackground(new Color(0xF6F6B6));
        rowLongTotal.getCell("sumpredictWinAmount").getStyleAttributes().setBackground(new Color(0xF6F6B6));
        RptFinancingDetailHandler.initDecimalCell(rowLongTotal.getCell("sumpredictWinAmount"));
        rowLongTotal.getCell("predictWinAmount").setExpressions("SUM");
        rowLongTotal.getStyleAttributes().setBackground(new Color(0xF6F6B6));
        rowLongTotal.getCell("predictWinAmount").getStyleAttributes().setBackground(new Color(0xF6F6B6));
        RptFinancingDetailHandler.initDecimalCell(rowLongTotal.getCell("predictWinAmount"));
        rowLongTotal.getCell("company").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"635_total"));
        IRow rowTotal = this.kdtable.getGroupManager().getStatRowTemplate(0);
        rowTotal.getCell("financeAmount").setExpressions("SUM");
        rowTotal.getStyleAttributes().setBackground(new Color(0xF6F6B6));
        rowTotal.getCell("financeAmount").getStyleAttributes().setBackground(new Color(0xF6F6B6));
        RptFinancingDetailHandler.initDecimalCell(rowTotal.getCell("financeAmount"));
        rowTotal.getCell("company").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"313_LoanEditUI"));
        rowTotal.getCell("financeLocAmoumt").setExpressions("SUM");
        rowTotal.getStyleAttributes().setBackground(new Color(0xF6F6B6));
        rowTotal.getCell("financeLocAmoumt").getStyleAttributes().setBackground(new Color(0xF6F6B6));
        RptFinancingDetailHandler.initDecimalCell(rowTotal.getCell("financeLocAmoumt"));
        rowTotal.getCell("balance").setExpressions("SUM");
        rowTotal.getStyleAttributes().setBackground(new Color(0xF6F6B6));
        rowTotal.getCell("balance").getStyleAttributes().setBackground(new Color(0xF6F6B6));
        RptFinancingDetailHandler.initDecimalCell(rowTotal.getCell("balance"));
        rowTotal.getCell("Locbalance").setExpressions("SUM");
        rowTotal.getStyleAttributes().setBackground(new Color(0xF6F6B6));
        rowTotal.getCell("Locbalance").getStyleAttributes().setBackground(new Color(0xF6F6B6));
        RptFinancingDetailHandler.initDecimalCell(rowTotal.getCell("Locbalance"));
        int index = this.kdtable.getColumn("number").getColumnIndex();
        IRow rowPlanRepay = this.kdtable.getGroupManager().getStatRowTemplate(index);
        rowPlanRepay.getCell("amount").setExpressions("SUM");
        rowPlanRepay.getStyleAttributes().setBackground(new Color(16119270));
        rowPlanRepay.getCell("amount").getStyleAttributes().setBackground(new Color(16119270));
        RptFinancingDetailHandler.initDecimalCell(rowPlanRepay.getCell("amount"));
        rowPlanRepay.getCell("realAmount").setExpressions("SUM");
        rowPlanRepay.getCell("realAmount").getStyleAttributes().setBackground(new Color(16119270));
        rowPlanRepay.getCell("realAmount").getStyleAttributes().setBackground(new Color(16119270));
        RptFinancingDetailHandler.initDecimalCell(rowPlanRepay.getCell("realAmount"));
        rowPlanRepay.getCell("number").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"302_LoanEditUI"));
    }

    public void endDataFill() {
        this.kdtable.setRefresh(true);
        this.kdtable.repaint();
        this.kdtable.getGroupManager().group();
        this.kdtable.getGroupManager().setGroup(false);
    }

    public IRowSet getRowSet() throws BOSException {
        IMetaDataPK pk = MetaDataPKFactory.getMetaDataPK((String)"com.kingdee.eas.fm.ivt.app.RptFinancingAccountQuery");
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)pk);
        int intUnit = this.param.getUnit().getValue();
        this.bdUnit = new BigDecimal(String.valueOf(intUnit));
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(this.param.getFilter());
        entityViewInfo.setSorter(this.param.getSorterItems());
        exec.setObjectView(entityViewInfo);
        return exec.executeQuery();
    }

    protected static void initDecimalCell(ICell cell) {
        cell.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        cell.getStyleAttributes().setNumberFormat("##,###,###,###,###,##0.00");
    }

    protected static void initDecimalCell(IColumn col) {
        col.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        col.getStyleAttributes().setNumberFormat("##,###,###,###,###,##0.00");
    }
}

