/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ivt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.BasicFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.fm.common.AmountUnitEnum;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.ivt.RptFinancingInterestFilterParam;
import com.kingdee.eas.fm.ivt.client.AbstractRptFinancingInterestFilterUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.sql.Date;
import org.apache.log4j.Logger;

public class RptFinancingInterestFilterUI
extends AbstractRptFinancingInterestFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(RptFinancingInterestFilterUI.class);

    protected void init() throws Exception {
        super.init();
        this.doInit();
    }

    private void doInit() throws Exception {
        this.pkbeginDate.setSupportedEmpty(true);
        this.pkEndDate.setSupportedEmpty(false);
        this.txtamount.setSupportedEmpty(true);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtamount);
        this.txtamount.setPrecision(2);
        this.txtamount.setValue((Object)Constants.TEN);
        this.pkEndDate.setValue((Object)new java.util.Date());
        FMClientHelper.setSelectObject((KDComboBox)this.statUnit, (Object)AmountUnitEnum.wan_yuan);
        this.initF7Bank();
        this.kDButtonGroupDetail.setValue(0);
    }

    private void initF7Bank() throws Exception {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)Boolean.TRUE));
        filterInfo.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)new Integer(1)));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filterInfo);
        this.prmtBank.setEntityViewInfo(evi);
        FinUtils.initBankTree((IUIObject)this, (KDBizPromptBox)this.prmtBank, null);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public Object getParam() {
        RptFinancingInterestFilterParam param = new RptFinancingInterestFilterParam();
        param.setCompanyIdSet(this.getCompanyIdSet());
        param.setFinanceFinancingIdSet(this.getIdSetFromF7(this.prmtFinanceFinancing));
        param.setBankIdSet(this.getIdSetFromF7(this.prmtBank));
        param.setUnit((AmountUnitEnum)this.statUnit.getSelectedItem());
        param.setAmount(this.txtamount.getBigDecimalValue());
        param.setDateFrom((java.util.Date)this.pkbeginDate.getValue());
        param.setDateTo((java.util.Date)this.pkEndDate.getValue());
        param.setDimType(this.kDButtonGroupDetail.getValue() + 1);
        return param;
    }

    public void setParam(Object param) {
        if (param == null) {
            return;
        }
        RptFinancingInterestFilterParam finparam = (RptFinancingInterestFilterParam)param;
        this.setCompanyIdSet(finparam.getCompanyIdSet());
        this.txtamount.setValue((Object)finparam.getAmount());
        this.pkbeginDate.setValue((Object)finparam.getDateFrom());
        this.pkEndDate.setValue((Object)finparam.getDateTo());
        FMClientHelper.setSelectObject((KDComboBox)this.statUnit, (Object)finparam.getUnit());
        this.kDButtonGroupDetail.setValue(finparam.getDimType() - 1);
        try {
            this.prmtFinanceFinancing.setData((Object)this.getBaseInfoFromIdSet(finparam.getFinanceFinancingIdSet()));
            this.prmtBank.setData((Object)this.getBaseInfoFromIdSet(finparam.getBankIdSet()));
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
    }

    protected Class getParamClass() {
        return RptFinancingInterestFilterParam.class;
    }

    protected void setDefaultValue() {
        super.setDefaultValue();
        this.pkbeginDate.setSupportedEmpty(true);
        this.txtamount.setSupportedEmpty(true);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtamount);
        this.txtamount.setPrecision(2);
        this.txtamount.setValue((Object)Constants.TEN);
        this.pkEndDate.setValue((Object)new java.util.Date());
        FMClientHelper.setSelectObject((KDComboBox)this.statUnit, (Object)AmountUnitEnum.wan_yuan);
    }

    public boolean verify() {
        Date startDate = this.pkbeginDate.getSqlDate();
        Date endDate = this.pkEndDate.getSqlDate();
        if (startDate != null && endDate != null && startDate.after(endDate)) {
            String msg = EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"133_RptFinancingInterestFilterUI");
            MsgBox.showWarning((Component)((Object)this), (String)msg);
            return false;
        }
        return super.verify();
    }
}

