/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ps.test;

import com.kingdee.eas.fm.ps.DecomposeBillEntryInfo;
import com.kingdee.eas.fm.ps.PaymentPlanBillCollection;
import com.kingdee.eas.fm.ps.PaymentPlanBillInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class ScheduleRelationTest {
    public static void main(String[] args) {
        PaymentPlanBillCollection detailColl = new PaymentPlanBillCollection();
        PaymentPlanBillInfo detail1 = new PaymentPlanBillInfo();
        detail1.setNumber("M001");
        detail1.setApplyPayAmount(new BigDecimal(5));
        detail1.setScheduleAmount(new BigDecimal(2));
        detailColl.add(detail1);
        PaymentPlanBillInfo detail2 = new PaymentPlanBillInfo();
        detail2.setNumber("M002");
        detail2.setApplyPayAmount(new BigDecimal(10));
        detailColl.add(detail2);
        ArrayList<DecomposeBillEntryInfo> infoList = new ArrayList<DecomposeBillEntryInfo>();
        DecomposeBillEntryInfo entry1 = new DecomposeBillEntryInfo();
        entry1.setSumNumber("FS001");
        entry1.setCurrentIssueAmt(new BigDecimal(3));
        entry1.setAvailable(true);
        infoList.add(entry1);
        DecomposeBillEntryInfo entry2 = new DecomposeBillEntryInfo();
        entry2.setSumNumber("FS002");
        entry2.setCurrentIssueAmt(new BigDecimal(6));
        entry2.setAvailable(true);
        infoList.add(entry2);
        DecomposeBillEntryInfo entry3 = new DecomposeBillEntryInfo();
        entry3.setSumNumber("FS003");
        entry3.setCurrentIssueAmt(new BigDecimal(4));
        entry3.setAvailable(true);
        infoList.add(entry3);
        ScheduleRelationTest.doSaveRelation(detailColl, infoList);
    }

    private static void doSaveRelation(PaymentPlanBillCollection detailColl, List<DecomposeBillEntryInfo> infoList) {
        block0: for (int i = 0; i < detailColl.size(); ++i) {
            PaymentPlanBillInfo detail = detailColl.get(i);
            BigDecimal schdlAmt = detail.getScheduleAmount() != null ? detail.getScheduleAmount() : BigDecimal.ZERO;
            BigDecimal applyAmt = detail.getApplyPayAmount().subtract(schdlAmt);
            for (DecomposeBillEntryInfo entry : infoList) {
                BigDecimal currentIssueAmt;
                if (!entry.isAvailable() || (currentIssueAmt = entry.getCurrentIssueAmt().subtract(entry.getActAmt())).compareTo(BigDecimal.ZERO) <= 0) continue;
                if (currentIssueAmt.compareTo(applyAmt) < 0) {
                    schdlAmt = currentIssueAmt;
                    entry.setActAmt(currentIssueAmt);
                    ScheduleRelationTest.saveRelation(detail, entry, schdlAmt);
                    applyAmt = applyAmt.subtract(currentIssueAmt);
                    entry.setAvailable(false);
                    continue;
                }
                schdlAmt = applyAmt;
                entry.setActAmt(applyAmt);
                ScheduleRelationTest.saveRelation(detail, entry, schdlAmt);
                continue block0;
            }
        }
    }

    private static void saveRelation(PaymentPlanBillInfo detail, DecomposeBillEntryInfo entry, BigDecimal schdlAmt) {
        StringBuffer sb = new StringBuffer();
        sb.append(detail.getNumber()).append("\t");
        sb.append(detail.getApplyPayAmount().toString()).append("\t");
        sb.append(schdlAmt != null ? schdlAmt.toString() : entry.getCurrentIssueAmt().toString()).append("\t");
        sb.append(entry.getSumNumber()).append("\t");
        sb.append(entry.getCurrentIssueAmt().toString()).append("\t");
        sb.append(entry.getActAmt().toString()).append("\t");
        System.out.println(sb.toString());
    }
}

