/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.sl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.BasicFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMBgItemProp;
import com.kingdee.eas.fm.common.FMBudgetFacadeFactory;
import com.kingdee.eas.fm.common.client.F7SelectorFactory;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.im.IntCalTypeEnum;
import com.kingdee.eas.fm.im.IntRateTypeExpressionEnum;
import com.kingdee.eas.fm.im.PenAccrualTypeEnum;
import com.kingdee.eas.fm.sl.LoanContractInterestFactory;
import com.kingdee.eas.fm.sl.LoanContractInterestInfo;
import com.kingdee.eas.fm.sl.LoanContractRepayInfo;
import com.kingdee.eas.fm.sl.client.AbstractLoanContractInterestEditUI;
import com.kingdee.eas.fm.sl.util.SLUtils;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.budget.FpCashDirectionEnum;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.sql.Date;
import org.apache.log4j.Logger;

public class LoanContractInterestEditUI
extends AbstractLoanContractInterestEditUI {
    private static final Logger logger = CoreUIObject.getLogger(LoanContractInterestEditUI.class);
    private static final String SLRESOURCE = "com.kingdee.eas.fm.sl.FmslResource";
    private boolean successFlag = false;
    private LoanContractRepayInfo repayInfo;
    IObjectPK pk1;

    public LoanContractInterestEditUI() throws Exception {
        this.setPreferredSize(new Dimension(900, 780));
    }

    @Override
    public void storeFields() {
        FMClientHelper.storeFieldsBgItem((KDBizPromptBox)this.prmtBgItem, (CoreBaseInfo)this.editData, (FMBgItemProp)this.editData.getBgItemProps()[0]);
        super.storeFields();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return LoanContractInterestFactory.getRemoteInstance();
    }

    public boolean getSuccessFlag() {
        return this.successFlag;
    }

    protected IObjectValue createNewData() {
        LoanContractInterestInfo objectValue = null;
        try {
            objectValue = LoanContractInterestFactory.getRemoteInstance().calInt(this.repayInfo);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        FMClientHelper.initNumber((CoreBaseInfo)objectValue, (KDTextField)this.txtNumber, (String)objectValue.getCompany().getId().toString());
        return objectValue;
    }

    public IObjectPK runSubmit() throws Exception {
        this.pk1 = super.runSubmit();
        return this.pk1;
    }

    protected boolean isSubmitLoad() {
        return false;
    }

    protected boolean isModifySave() {
        return false;
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.pk1 = null;
        if (this.repayInfo != null) {
            this.editData.setInterestType(IntCalTypeEnum.REPAY_INT);
            super.actionSubmit_actionPerformed(e);
            this.disposeUIWindow();
        } else {
            super.actionSubmit_actionPerformed(e);
        }
        if (this.pk1 != null) {
            String billId = this.pk1.toString();
            String Msg = FMBudgetFacadeFactory.getRemoteInstance().getMsgFromID(billId);
            if (Msg != null && !"".equals(Msg)) {
                MsgBox.showConfirm2((String)Msg);
            }
        }
    }

    public void onLoad() throws Exception {
        this.initKDTablesXml();
        this.initLoanContractInterestHeader();
        this.repayInfo = (LoanContractRepayInfo)this.getUIContext().get("loanContractRepayInfo");
        super.onLoad();
        this.actionAuditResult.setVisible(false);
    }

    public void initLoanContractInterestHeader() throws Exception {
        SLUtils.setNumberKdtextFieldStyle(this.txtDays);
        SLUtils.setNumberKdtextFieldStyle(this.txtDaysOverdue);
        SLUtils.setBigDecimalKdtextFieldStyle(this.txtIntRate, SLUtils.maxValue, Constants.ZERO, 5);
        SLUtils.setBigDecimalKdtextFieldStyle(this.txtExchange, SLUtils.maxValue, Constants.ZERO, 5);
        SLUtils.setBigDecimalKdtextFieldStyle(this.txtInterest, SLUtils.maxValue, Constants.ZERO, 5);
        SLUtils.setBigDecimalKdtextFieldStyle(this.txtAmount, SLUtils.maxValue, Constants.ZERO, 5);
        SLUtils.setBigDecimalKdtextFieldStyle(this.txtRealInterest, SLUtils.maxValue, Constants.ZERO, 5);
        SLUtils.setBigDecimalKdtextFieldStyle(this.txtPunishInterest, SLUtils.maxValue, Constants.ZERO, 5);
        SLUtils.setBigDecimalKdtextFieldStyle(this.txtRealPunishInterest, SLUtils.maxValue, Constants.ZERO, 5);
        SLUtils.setBigDecimalKdtextFieldStyle(this.txtStrikeAmount, SLUtils.maxValue, Constants.ZERO, 5);
        SLUtils.setBigDecimalKdtextFieldStyle(this.txtPunishIntRate, Constants.ONE_HUNDRED, Constants.ZERO, 5);
        FinUtils.initCurrencyComboBox((KDComboBox)this.kDComboBoxCurrency);
        F7SelectorFactory.initProject((IUIObject)this, (KDBizPromptBox)this.prmtProject);
        FMClientHelper.initBgItemF7((KDBizPromptBox)this.prmtBgItem, (FpCashDirectionEnum[])new FpCashDirectionEnum[]{FpCashDirectionEnum.output, FpCashDirectionEnum.other}, (boolean)true, (boolean)true);
        this.setAcctF7(this.prmtPayAcount);
        this.setAcctViewF7(this.prmtIntFeeAcctView);
        this.pkBizDate.setSupportedEmpty(false);
    }

    private void setAcctViewF7(KDBizPromptBox f7Box) throws EASBizException, BOSException {
        f7Box.setQueryInfo("com.kingdee.eas.basedata.master.account.app.F7AccountViewQuery");
        EntityViewInfo vi = new EntityViewInfo();
        vi.setFilter(new FilterInfo());
        if (this.currentCompany.getAccountTable() != null) {
            vi.getFilter().getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)this.currentCompany.getAccountTable().getId().toString()));
        }
        vi.getFilter().getFilterItems().add(new FilterItemInfo("isLeaf", (Object)Constants.TRUE));
        vi.getFilter().getFilterItems().add(new FilterItemInfo("isGFreeze", (Object)Constants.FALSE));
        vi.getFilter().getFilterItems().add(new FilterItemInfo("isCFreeze", (Object)Constants.FALSE));
        vi.getFilter().getFilterItems().add(new FilterItemInfo("companyID.id", (Object)this.currentCompany.getId().toString()));
        f7Box.setEntityViewInfo(vi);
        f7Box.getQueryAgent().resetRuntimeEntityView();
    }

    private void setAcctF7(KDBizPromptBox f7Box) throws EASBizException, BOSException {
        EntityViewInfo vi = new EntityViewInfo();
        vi.setFilter(new FilterInfo());
        vi.getFilter().getFilterItems().add(new FilterItemInfo("company.id", (Object)this.currentCompany.getId().toString()));
        vi.getFilter().getFilterItems().add(new FilterItemInfo("isClosed", (Object)Boolean.FALSE));
        f7Box.setEntityViewInfo(vi);
        f7Box.getQueryAgent().resetRuntimeEntityView();
    }

    private void initKDTablesXml() {
        this.kdtEntry.checkParsed();
    }

    @Override
    public void loadFields() {
        FMClientHelper.loadFieldsBgItem((KDBizPromptBox)this.prmtBgItem, (CoreBaseInfo)this.editData, (FMBgItemProp)this.editData.getBgItemProps()[0]);
        FMClientHelper.initNumber((CoreBaseInfo)this.editData, (KDTextField)this.txtNumber, (String)this.currentCompany.getId().toString());
        CurrencyInfo curInfo = this.editData.getCurrency();
        FMClientHelper.setSelectObject((KDComboBox)this.kDComboBoxCurrency, (Object)curInfo);
        if (curInfo != null) {
            this.initKDTPrecesion(curInfo.getPrecision());
        }
        super.loadFields();
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        FMClientVerifyHelper.verifyRequire((CoreUIObject)this);
        super.verifyInput(e);
    }

    public boolean useScrollPane() {
        return true;
    }

    public int getVerticalScrollPolicy() {
        return 22;
    }

    public int getHorizontalScrollPolicy() {
        return 32;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("creator.id"));
        sic.add(new SelectorItemInfo("creator.number"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("bizDate"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("interestType"));
        sic.add(new SelectorItemInfo("loancontractNum"));
        sic.add(new SelectorItemInfo("payAcount.id"));
        sic.add(new SelectorItemInfo("payAcount.name"));
        sic.add(new SelectorItemInfo("payAcount.number"));
        sic.add(new SelectorItemInfo("beginDate"));
        sic.add(new SelectorItemInfo("endDate"));
        sic.add(new SelectorItemInfo("days"));
        sic.add(new SelectorItemInfo("daysOverdue"));
        sic.add(new SelectorItemInfo("intRateTypeExpression"));
        sic.add(new SelectorItemInfo("intRate"));
        sic.add(new SelectorItemInfo("exchange"));
        sic.add(new SelectorItemInfo("amount"));
        sic.add(new SelectorItemInfo("interest"));
        sic.add(new SelectorItemInfo("realInterest"));
        sic.add(new SelectorItemInfo("punishIntType"));
        sic.add(new SelectorItemInfo("punishIntRate"));
        sic.add(new SelectorItemInfo("punishInterest"));
        sic.add(new SelectorItemInfo("realPunishInterest"));
        sic.add(new SelectorItemInfo("strikeAmount"));
        sic.add(new SelectorItemInfo("intFeeAcctView.id"));
        sic.add(new SelectorItemInfo("intFeeAcctView.number"));
        sic.add(new SelectorItemInfo("intFeeAcctView.name"));
        sic.add(new SelectorItemInfo("project.id"));
        sic.add(new SelectorItemInfo("project.name"));
        sic.add(new SelectorItemInfo("project.number"));
        sic.add(new SelectorItemInfo("entry.beginDate"));
        sic.add(new SelectorItemInfo("entry.endDate"));
        sic.add(new SelectorItemInfo("entry.days"));
        sic.add(new SelectorItemInfo("entry.entryAmount"));
        sic.add(new SelectorItemInfo("entry.entryIntRate"));
        sic.add(new SelectorItemInfo("entry.entryIntRateTypeExpression"));
        sic.add(new SelectorItemInfo("entry.entryYearDays"));
        sic.add(new SelectorItemInfo("entry.entryInterest"));
        sic.add(new SelectorItemInfo("entry.entryDaysOverdue"));
        sic.add(new SelectorItemInfo("entry.entryPunishIntRate"));
        sic.add(new SelectorItemInfo("entry.entryPunishInterest"));
        sic.add(new SelectorItemInfo("entry.fetchNumer"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("createTime"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("sourceBillNum"));
        sic.add(new SelectorItemInfo("sourceBillNum.id"));
        sic.add(new SelectorItemInfo("sourceBillNum.number"));
        sic.add(new SelectorItemInfo("lastIntDate"));
        sic.add(new SelectorItemInfo("loanContractRepay.id"));
        sic.add(new SelectorItemInfo("outBgItemNumber"));
        sic.add(new SelectorItemInfo("outBgItemName"));
        sic.add(new SelectorItemInfo("outBgItemId"));
        return sic;
    }

    @Override
    protected void kDComboBoxCurrency_itemStateChanged(ItemEvent e) throws Exception {
        super.kDComboBoxCurrency_itemStateChanged(e);
        CurrencyInfo currency = (CurrencyInfo)this.kDComboBoxCurrency.getSelectedItem();
        Date date = this.pkBizDate.getSqlDate();
        if (currency != null) {
            SLUtils.setLocalCurExRate(this.currentCompany, currency.getId().toString(), null, date, this.txtExchange, null);
            if (currency.equals((Object)SLUtils.getCurrentCurrency(this.currentCompany))) {
                this.txtExchange.setEnabled(false);
            } else {
                this.txtExchange.setEnabled(true);
            }
        }
    }

    protected void initKDTPrecesion(int prec) {
        this.initPrecesion(this.kdtEntry, new String[]{"entryAmount", "entryInterest", "entryPunishInterest"}, prec, true);
        this.initPrecesion(this.kdtEntry, new String[]{"entryIntRate", "entryPunishIntRate"}, 5, true);
        this.initPrecesion(this.kdtEntry, new String[]{"days", "entryDaysOverdue", "entryYearDays"}, 0, true);
        this.initPrecesion(this.kdtEntry, new String[]{"fetchNumer", "beginDate", "endDate", "entryIntRateTypeExpression"}, 0, false);
        this.txtAmount.setPrecision(prec);
        this.txtInterest.setPrecision(prec);
        this.txtRealInterest.setPrecision(prec);
        this.txtPunishInterest.setPrecision(prec);
        this.txtRealPunishInterest.setPrecision(prec);
        this.txtStrikeAmount.setPrecision(prec);
    }

    protected void initPrecesion(KDTable kdt, String[] cols, int prec, boolean isRight) {
        String format = FMClientHelper.getKDTNumFormat((int)prec);
        int n = cols.length;
        for (int i = 0; i < n; ++i) {
            IColumn col = kdt.getColumn(cols[i]);
            if (col == null) continue;
            if (prec != 0) {
                col.getStyleAttributes().setNumberFormat(format);
            }
            if (isRight) {
                col.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            }
            col.getStyleAttributes().setLocked(true);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
    }

    @Override
    protected void comboIntRateTypeExpression_actionPerformed(ActionEvent e) throws Exception {
        IntRateTypeExpressionEnum intRateTypeExpressionEnum = (IntRateTypeExpressionEnum)this.comboIntRateTypeExpression.getSelectedItem();
        if (intRateTypeExpressionEnum == IntRateTypeExpressionEnum.YEAR) {
            this.txtIntRate.setBoundLabelText(EASResource.getString((String)SLRESOURCE, (String)"9_loanFetchEditUI"));
        } else if (intRateTypeExpressionEnum == IntRateTypeExpressionEnum.MONTH) {
            this.txtIntRate.setBoundLabelText(EASResource.getString((String)SLRESOURCE, (String)"10_loanFetchEditUI"));
        } else {
            this.txtIntRate.setBoundLabelText(EASResource.getString((String)SLRESOURCE, (String)"10_loanFetchEditUI"));
        }
    }

    @Override
    protected void comboPunishIntType_actionPerformed(ActionEvent e) throws Exception {
        PenAccrualTypeEnum penTtpe = (PenAccrualTypeEnum)this.comboPunishIntType.getSelectedItem();
        if (penTtpe == PenAccrualTypeEnum.ADD_ACCRUAL) {
            this.txtPunishIntRate.setBoundLabelText(EASResource.getString((String)SLRESOURCE, (String)"dailyrate"));
        } else if (penTtpe == PenAccrualTypeEnum.ADD_PERCENT) {
            this.txtPunishIntRate.setBoundLabelText(EASResource.getString((String)SLRESOURCE, (String)"penerate"));
        }
    }

    @Override
    protected void pkBizDate_dataChanged(DataChangeEvent e) throws Exception {
        Date bizDate = this.pkBizDate.getSqlDate();
        CurrencyInfo curCurrency = (CurrencyInfo)this.kDComboBoxCurrency.getSelectedItem();
        CurrencyInfo baseCurrency = SLUtils.getCurrentCurrency(this.currentCompany);
        FinUtils.initExchangeRate(null, (BasicFormattedTextField)this.txtExchange, (CompanyOrgUnitInfo)this.currentCompany, (CurrencyInfo)curCurrency, (CurrencyInfo)baseCurrency, (java.util.Date)bizDate, null);
    }

    protected boolean isNeedAddToolMenus() {
        return false;
    }
}

