/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.sl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.fs.client.CurrencyUtil;
import com.kingdee.eas.fm.sl.client.AbstractLoanContractInterestFilterUI;
import com.kingdee.eas.fm.sl.client.LoanContractInterestFilterParam;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Calendar;
import java.util.Date;
import java.util.Set;
import org.apache.log4j.Logger;

public class LoanContractInterestFilterUI
extends AbstractLoanContractInterestFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(LoanContractInterestFilterUI.class);

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void chkIA_actionPerformed(ActionEvent e) throws Exception {
        super.chkIA_actionPerformed(e);
    }

    protected void btnCompanySelect_actionPerformed(ActionEvent e) throws Exception {
        super.btnCompanySelect_actionPerformed(e);
    }

    public Object getParam() {
        Set cmpSet;
        LoanContractInterestFilterParam filterParam = new LoanContractInterestFilterParam();
        if (null != this.kDComboBoxCurrency.getSelectedItem()) {
            if (!(this.kDComboBoxCurrency.getSelectedItem() instanceof FMSysDefinedEnum)) {
                filterParam.setCurrencyId(((CurrencyInfo)this.kDComboBoxCurrency.getSelectedItem()).getId().toString());
            } else {
                filterParam.setCurrencyId(null);
            }
        }
        if ((cmpSet = this.getCompanyIdSet()) != null && cmpSet.size() > 0) {
            filterParam.setCompanyIdSet(this.getCompanyIdSet());
        }
        if (this.startBizDate.getSqlDate() != null) {
            filterParam.setStartBizDate(DateTimeUtils.truncateDate((Date)this.startBizDate.getSqlDate()));
        }
        if (this.endBizDate.getSqlDate() != null) {
            filterParam.setEndBizDate(DateTimeUtils.truncateDate((Date)this.endBizDate.getSqlDate()));
        }
        return filterParam;
    }

    public void setParam(Object param) {
        if (param == null) {
            return;
        }
        LoanContractInterestFilterParam filterParam = (LoanContractInterestFilterParam)((Object)param);
        try {
            if (filterParam.getCurrencyId() != null) {
                CurrencyInfo cur = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(filterParam.getCurrencyId()));
                FMClientHelper.setSelectObject((KDComboBox)this.kDComboBoxCurrency, (Object)cur);
            } else {
                FMClientHelper.setSelectObject((KDComboBox)this.kDComboBoxCurrency, (Object)FMSysDefinedEnum.SELECT_ALL);
            }
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        this.setCompanyIdSet(filterParam.getCompanyIdSet());
        this.startBizDate.setValue((Object)filterParam.getStartBizDate());
        this.endBizDate.setValue((Object)filterParam.getEndBizDate());
    }

    protected void init() throws Exception {
        super.init();
        CurrencyUtil.fillCombCurrency((KDComboBox)this.kDComboBoxCurrency);
        this.kDComboBoxCurrency.addItem((Object)FMSysDefinedEnum.SELECT_ALL);
        FMClientHelper.setSelectObject((KDComboBox)this.kDComboBoxCurrency, (Object)FMSysDefinedEnum.SELECT_ALL);
        Calendar cal = Calendar.getInstance();
        cal.set(1, 2000);
        cal.set(2, 0);
        cal.set(5, 1);
        this.startBizDate.setValue((Object)cal.getTime());
        this.endBizDate.setValue((Object)DateUtil.getDayEnd());
    }

    protected void setDefaultValue() {
        super.setDefaultValue();
    }

    public boolean verify() {
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.startBizDate);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.endBizDate);
        if (DateTimeUtils.truncateDate((Date)((Date)this.startBizDate.getValue())).after(DateTimeUtils.truncateDate((Date)((Date)this.endBizDate.getValue())))) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.sl.FmslResource", (String)"25_EndDateMustAfterBeginDate"));
            SysUtil.abort();
        }
        return super.verify();
    }

    public void clear() {
        super.clear();
        try {
            FMClientHelper.setSelectObject((KDComboBox)this.kDComboBoxCurrency, (Object)FMSysDefinedEnum.SELECT_ALL);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        Calendar cal = Calendar.getInstance();
        cal.set(1, 2000);
        cal.set(2, 0);
        cal.set(5, 1);
        this.startBizDate.setValue((Object)cal.getTime());
        this.endBizDate.setValue((Object)DateUtil.getDayEnd());
    }

    protected Class getParamClass() {
        return LoanContractInterestFilterParam.class;
    }
}

