/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.sl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.IvtModualUtils;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.common.util.MsgPromtUtil;
import com.kingdee.eas.fm.im.IntCalTypeEnum;
import com.kingdee.eas.fm.sl.LoanContractInterestCollection;
import com.kingdee.eas.fm.sl.LoanContractInterestFactory;
import com.kingdee.eas.fm.sl.LoanContractInterestInfo;
import com.kingdee.eas.fm.sl.SLInterestStatusEnum;
import com.kingdee.eas.fm.sl.client.AbstractLoanContractInterestListUI;
import com.kingdee.eas.fm.sl.client.LoanContractInterestFilterParam;
import com.kingdee.eas.fm.sl.client.LoanContractInterestFilterUI;
import com.kingdee.eas.fm.sl.client.PreInterestLoanContractUI;
import com.kingdee.eas.fm.sl.client.RecInterestLoanContractUI;
import com.kingdee.eas.fm.sl.util.SLUtils;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class LoanContractInterestListUI
extends AbstractLoanContractInterestListUI {
    private static final Logger logger = CoreUIObject.getLogger(LoanContractInterestListUI.class);
    private LoanContractInterestFilterUI filterUI = null;
    private CompanyOrgUnitInfo currentCompany;
    private Map hm = null;
    private Set setIDs;
    private static final String SLRESOURCE = "com.kingdee.eas.fm.sl.FmslResource";
    private static Integer preInt = new Integer(0);
    boolean isEnterByPreInt = false;
    FillListener fillListener = new FillListener();

    public LoanContractInterestListUI() throws Exception {
        this.currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private void onshows() {
        boolean isFpItem = FMClientHelper.getIsFpOrBg();
        FMClientHelper.initFpOrBgF7Item((boolean)isFpItem, (IColumn)this.tblMain.getColumn("fpItem"), (IColumn)this.tblMain.getColumn("bgItem"));
        this.appendFootRow();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return LoanContractInterestFactory.getRemoteInstance();
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        this.isEnterByPreInt = false;
        super.actionQuery_actionPerformed(e);
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.isEnterByPreInt = false;
        super.actionRefresh_actionPerformed(e);
    }

    public void onLoad() throws Exception {
        this.tblMain.getDataRequestManager().setDataRequestMode(0);
        String uiParam = (String)this.getUIContext().get("UIClassParam");
        if (this.getBOTPViewStatus() != 1) {
            if (uiParam != null && uiParam.equals("LOANCONTRACTINTERESTPREINT")) {
                if (SLUtils.checkBizUnit()) {
                    throw new FMException(FMException.UNIONCANNOTOPRT);
                }
                if (!SLUtils.checkCodingRule(new LoanContractInterestInfo())) {
                    throw new BEException(BEException.COMMON, new Object[]{"\u94f6\u56e2\u8d37\u6b3e\u5229\u606f\u5355\u6307\u5b9a\u7684\u7f16\u7801\u89c4\u5219\u672a\u5b9a\u4e49\u6216\u8005\u672a\u542f\u7528"});
                }
                this.isEnterByPreInt = true;
                this.hm = PreInterestLoanContractUI.showPreInterestLoanContractUI((CoreUI)this);
                this.setIDs = (Set)this.hm.get("createdID");
                if (this.setIDs == null) {
                    SysUtil.abort();
                }
            } else if (uiParam != null && uiParam.equals("LOANCONTRACTINTERESTCALINT")) {
                if (SLUtils.checkBizUnit()) {
                    throw new FMException(FMException.UNIONCANNOTOPRT);
                }
                if (!SLUtils.checkCodingRule(new LoanContractInterestInfo())) {
                    throw new BEException(BEException.COMMON, new Object[]{"\u94f6\u56e2\u8d37\u6b3e\u5229\u606f\u5355\u6307\u5b9a\u7684\u7f16\u7801\u89c4\u5219\u672a\u5b9a\u4e49\u6216\u8005\u672a\u542f\u7528"});
                }
                this.hm = RecInterestLoanContractUI.showRecInterestLoanContractUI((CoreUI)this);
                this.setIDs = (Set)this.hm.get("createdID");
                if (this.setIDs == null) {
                    SysUtil.abort();
                }
            } else if (uiParam != null && uiParam.equals("LOANCONTRACTINTERESTLIST")) {
                logger.info((Object)" Enter the LoanContractInterestList ");
            }
        }
        super.onLoad();
        this.actionAuditResult.setVisible(false);
        this.setBtnDisplayInBizUnit();
    }

    private void setBtnDisplayInBizUnit() {
        boolean isBizUnit = SLUtils.checkBizUnit();
        this.menuEdit.setVisible(!isBizUnit);
        this.menuBiz.setVisible(!isBizUnit);
        this.actionEdit.setVisible(!isBizUnit);
        this.actionRemove.setVisible(!isBizUnit);
        this.actionAudit.setVisible(!isBizUnit);
        this.actionUnAudit.setVisible(!isBizUnit);
        this.actionGenPay.setVisible(!isBizUnit);
        this.actionVoucher.setEnabled(!isBizUnit);
        this.actionVoucher.setVisible(!isBizUnit);
        this.actionDelVoucher.setEnabled(!isBizUnit);
        this.actionDelVoucher.setVisible(!isBizUnit);
        this.actionPreInt.setVisible(!isBizUnit);
        this.actionPreInt.setEnabled(!isBizUnit);
        this.actionReceiveInt.setVisible(!isBizUnit);
        this.actionReceiveInt.setEnabled(!isBizUnit);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionGenPay.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_releasebymodule"));
        this.actionAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_auditing"));
        this.actionUnAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_fauditing"));
        this.actionAudit.setEnabled(true);
        this.actionUnAudit.setEnabled(true);
        this.actionGenPay.setEnabled(true);
        this.actionAddNew.setVisible(false);
        this.actionPreInt.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_autocount"));
        this.actionReceiveInt.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_releasebymodule"));
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.getDataRequestManager().addDataFillListener((KDTDataFillListener)this.fillListener);
    }

    protected IRow appendFootRow() {
        IRow sumRow = super.appendFootRow();
        this.formatFootRow();
        return sumRow;
    }

    protected boolean isFootVisible() {
        return true;
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    protected void formatFootRow() {
        CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        try {
            LoanContractInterestFilterParam param = (LoanContractInterestFilterParam)((Object)this.getFilterUI().getParam());
            if (this.tblMain.getFootManager() == null) {
                return;
            }
            IRow row = this.tblMain.getFootManager().getFootRow(0);
            String curID = null;
            curID = param.getCurrencyId() == null ? company.getBaseCurrency().getId().toString() : param.getCurrencyId();
            String[] columns = new String[]{"amount", "interest", "realInterest", "punishInterest", "realPunishInterest", "strikeAmount"};
            for (int i = 0; i < columns.length; ++i) {
                FMClientHelper.setNumberFormat((IRow)row, (String)columns[i], (String)curID);
            }
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new LoanContractInterestFilterUI();
        }
        return this.filterUI;
    }

    protected String getEditUIName() {
        return "com.kingdee.eas.fm.sl.client.LoanContractInterestEditUI";
    }

    protected String getKeyFieldName() {
        return "id";
    }

    @Override
    public void actionGenPay_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkSelectOneItem((CoreUI)this, this.tblMain);
        String billId = this.getSelectedKeyValue();
        ObjectStringPK pk = new ObjectStringPK(billId);
        LoanContractInterestInfo info = (LoanContractInterestInfo)this.getBizInterface().getValue((IObjectPK)pk);
        this.checkGenPay(info);
        this.actionCreateTo_actionPerformed(e);
        this.refreshList();
    }

    private void checkGenPay(LoanContractInterestInfo info) {
        if (info != null) {
            if (info.getStatus() != SLInterestStatusEnum.AUDIT || info.isIsGenPayBill()) {
                MsgBox.showWarning((String)"\u672a\u751f\u6210\u4ed8\u6b3e\u5355\u4e14\u5df2\u5ba1\u6279\u7684\u4ed8\u606f\u6216\u8fd8\u672c\u4ed8\u606f\u5229\u606f\u5355\u5141\u8bb8\u751f\u6210\u4ed8\u6b3e\u5355");
                SysUtil.abort();
            }
            if (info.getInterestType() != IntCalTypeEnum.PAY_INT && info.getInterestType() != IntCalTypeEnum.REPAY_INT) {
                MsgBox.showWarning((String)"\u672a\u751f\u6210\u4ed8\u6b3e\u5355\u4e14\u5df2\u5ba1\u6279\u7684\u4ed8\u606f\u6216\u8fd8\u672c\u4ed8\u606f\u5229\u606f\u5355\u5141\u8bb8\u751f\u6210\u4ed8\u6b3e\u5355");
                SysUtil.abort();
            }
        }
    }

    private void checkSelectOneItem(CoreUI ui, KDTable table) {
        int size = KDTableUtil.getSelectedRowCount((KDTable)this.tblMain);
        if (size > 1) {
            MsgBox.showInfo((Component)((Object)this), (String)"\u5355\u7b14\u8bb0\u5f55\u5141\u8bb8\u751f\u6210\u4ed8\u6b3e\u5355");
            SysUtil.abort();
        }
    }

    public void actionDelVoucher_actionPerformed(ActionEvent e) throws Exception {
        this.checkDelVoucher();
        super.actionDelVoucher_actionPerformed(e);
    }

    public void actionVoucher_actionPerformed(ActionEvent e) throws Exception {
        this.checkVoucher();
        super.actionVoucher_actionPerformed(e);
    }

    private void checkDelVoucher() throws EASBizException, BOSException {
        LoanContractInterestInfo info;
        if (IvtModualUtils.getSysParam(null, (String)"FIN009") && (info = this.getSelectObject()).getInterestType() == IntCalTypeEnum.REPAY_INT) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"331_LoanInterestListUI"));
            SysUtil.abort();
        }
    }

    private void checkVoucher() throws EASBizException, BOSException {
        LoanContractInterestInfo info;
        if (IvtModualUtils.getSysParam(null, (String)"FIN009") && (info = this.getSelectObject()).getInterestType() == IntCalTypeEnum.REPAY_INT) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"331_LoanInterestListUI"));
            SysUtil.abort();
        }
    }

    private LoanContractInterestInfo getSelectObject() throws EASBizException, BOSException {
        this.checkSelected();
        return LoanContractInterestFactory.getRemoteInstance().getLoanContractInterestInfo((IObjectPK)new ObjectUuidPK(this.getSelectedKeyValue()));
    }

    protected boolean isMutiRemove() {
        return false;
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)this.getSelectedKeyValue()));
        LoanContractInterestInfo info = (LoanContractInterestInfo)this.getBizInterface().getValue((IObjectPK)pk);
        if (info != null && info.getStatus() == SLInterestStatusEnum.AUDIT) {
            MsgPromtUtil.showInfo((CoreUI)this, (String)SLRESOURCE, (String)"15_SubmitStatus_can_audit");
        }
        LoanContractInterestFactory.getRemoteInstance().audit((IObjectPK)pk);
        FMClientHelper.showSuccessMessage((CoreUI)this, (Component)((Component)e.getSource()));
        this.refreshList();
    }

    @Override
    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String billId = this.getSelectedKeyValue();
        ObjectStringPK pk = new ObjectStringPK(billId);
        LoanContractInterestInfo info = (LoanContractInterestInfo)this.getBizInterface().getValue((IObjectPK)pk);
        if (info.getStatus() != SLInterestStatusEnum.AUDIT) {
            MsgPromtUtil.showInfo((CoreUI)this, (String)SLRESOURCE, (String)"16_Audit_not_relation_can_unAudit");
        }
        if (SLUtils.existsDestBillSet(billId)) {
            MsgPromtUtil.showInfo((CoreUI)this, (String)SLRESOURCE, (String)"16_Audit_not_relation_can_unAudit");
        }
        LoanContractInterestFactory.getRemoteInstance().unAudit((IObjectPK)pk);
        FMClientHelper.showSuccessMessage((CoreUI)this, (Component)((Component)e.getSource()));
        this.refreshList();
    }

    protected boolean isVoucherVisible() {
        boolean isBizUnit = SLUtils.checkBizUnit();
        return !isBizUnit;
    }

    public boolean isNeedShowBOTPRule() {
        return true;
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String billId = this.getSelectedKeyValue();
        ObjectStringPK pk = new ObjectStringPK(billId);
        LoanContractInterestInfo info = (LoanContractInterestInfo)this.getBizInterface().getValue((IObjectPK)pk);
        if (info.getInterestType() != null && info.getInterestType() == IntCalTypeEnum.REPAY_INT) {
            MsgBox.showWarning((Component)((Object)this), (String)"\u8fd8\u672c\u4ed8\u606f\u5229\u606f\u5355\u4e0d\u5141\u8bb8\u4fee\u6539");
            SysUtil.abort();
        }
        if (info.getStatus() == SLInterestStatusEnum.AUDIT || SLUtils.existsDestBillSet(info.getId().toString())) {
            MsgBox.showWarning((Component)((Object)this), (String)"\u6682\u5b58\u72b6\u6001\u6216\u63d0\u4ea4\u72b6\u6001\u4e14\u65e0\u4e0b\u6e38\u5355\u636e\u7684\u8bb0\u5f55\u5141\u8bb8\u4fee\u6539");
            SysUtil.abort();
        }
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String billId = this.getSelectedKeyValue();
        ObjectStringPK pk = new ObjectStringPK(billId);
        LoanContractInterestInfo info = (LoanContractInterestInfo)this.getBizInterface().getValue((IObjectPK)pk);
        if (info.getInterestType() != null && info.getInterestType() == IntCalTypeEnum.REPAY_INT) {
            MsgBox.showWarning((Component)((Object)this), (String)"\u8fd8\u672c\u4ed8\u606f\u5229\u606f\u5355\u4e0d\u5141\u8bb8\u624b\u5de5\u5220\u9664\uff0c\u53ea\u80fd\u5728\u5220\u9664\u501f\u6b3e\u5408\u540c\u8fd8\u6b3e\u5355\u65f6\u540c\u6b65\u5220\u9664");
            SysUtil.abort();
        }
        if (info.getStatus() == SLInterestStatusEnum.AUDIT || SLUtils.existsDestBillSet(info.getId().toString())) {
            MsgBox.showWarning((Component)((Object)this), (String)"\u6682\u5b58\u72b6\u6001\u6216\u63d0\u4ea4\u72b6\u6001\u4e14\u65e0\u4e0b\u6e38\u5355\u636e\u7684\u8bb0\u5f55\u5141\u8bb8\u5220\u9664");
            SysUtil.abort();
        }
        super.actionRemove_actionPerformed(e);
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = null;
        if (this.setIDs == null) {
            filter = super.getDefaultFilterForQuery();
        } else {
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.parseValue(this.setIDs), CompareType.INCLUDE));
        }
        return filter;
    }

    private String parseValue(Set setIDs) {
        StringBuffer returnSb = new StringBuffer();
        Object[] ids = setIDs.toArray();
        for (int i = 0; i < ids.length; ++i) {
            if (i == ids.length - 1) {
                returnSb.append(ids[i].toString());
                continue;
            }
            returnSb.append(ids[i].toString()).append(",");
        }
        return returnSb.toString();
    }

    protected void execQuery() {
        if (this.setIDs != null) {
            String includeValue = this.parseValue(this.setIDs);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)includeValue, CompareType.INCLUDE));
            this.mainQuery.setFilter(filter);
        }
        super.execQuery();
        this.onshows();
        this.formatFootRow();
        this.setIDs = null;
    }

    private FilterInfo getBillCanbePayed() {
        Map btpeditparameter;
        String targetBillType;
        FilterInfo f = new FilterInfo();
        if (this.getUIContext().get("BTPEDITPARAMETER") != null && (targetBillType = (String)(btpeditparameter = (Map)this.getUIContext().get("BTPEDITPARAMETER")).get("FromFinRepayment")) != null && "FromFinRepayment".equals(targetBillType)) {
            f.getFilterItems().add(new FilterItemInfo("isGenPayBill", (Object)Boolean.FALSE));
            f.getFilterItems().add(new FilterItemInfo("interestType", (Object)preInt, CompareType.NOTEQUALS));
            f.getFilterItems().add(new FilterItemInfo("statusExtEnum", (Object)new Integer(1)));
        }
        return f;
    }

    @Override
    public void actionPreInt_actionPerformed(ActionEvent e) throws Exception {
        this.checkHasNumber();
        if (this.isEnterByPreInt) {
            boolean hasSavedBill;
            FilterInfo filt = new FilterInfo();
            filt.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer("0")));
            this.mainQuery.getFilter().mergeFilter(filt, "AND");
            LoanContractInterestCollection col = LoanContractInterestFactory.getRemoteInstance().getLoanContractInterestCollection(this.mainQuery);
            boolean bl = hasSavedBill = col.size() > 0;
            if (hasSavedBill) {
                boolean isSave;
                int result = MsgBox.showConfirm2New((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"319_LoanInterestListUI"));
                boolean bl2 = isSave = result == 1;
                if (isSave) {
                    return;
                }
                FilterInfo f = new FilterInfo();
                f.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer("0")));
                this.mainQuery.getFilter().mergeFilter(f, "AND");
                LoanContractInterestFactory.getRemoteInstance().delete(this.mainQuery.getFilter());
                this.refreshList();
                this.isEnterByPreInt = true;
            }
        }
        this.hm = PreInterestLoanContractUI.showPreInterestLoanContractUI((CoreUI)this);
        this.setIDs = (Set)this.hm.get("createdID");
        if (this.setIDs != null) {
            String includeValue = this.parseValue(this.setIDs);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)includeValue, CompareType.INCLUDE));
            this.mainQuery.setFilter(filter);
            this.isEnterByPreInt = true;
            this.refresh(e);
        }
    }

    @Override
    public void actionReceiveInt_actionPerformed(ActionEvent e) throws Exception {
        this.checkHasNumber();
        if (this.isEnterByPreInt) {
            boolean hasSavedBill;
            FilterInfo filt = new FilterInfo();
            filt.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer("0")));
            this.mainQuery.getFilter().mergeFilter(filt, "AND");
            LoanContractInterestCollection col = LoanContractInterestFactory.getRemoteInstance().getLoanContractInterestCollection(this.mainQuery);
            boolean bl = hasSavedBill = col.size() > 0;
            if (hasSavedBill) {
                boolean isSave;
                int result = MsgBox.showConfirm2New((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"319_LoanInterestListUI"));
                boolean bl2 = isSave = result == 1;
                if (isSave) {
                    return;
                }
                FilterInfo f = new FilterInfo();
                f.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer("0")));
                this.mainQuery.getFilter().mergeFilter(f, "AND");
                LoanContractInterestFactory.getRemoteInstance().delete(this.mainQuery.getFilter());
                this.refreshList();
                this.isEnterByPreInt = false;
            }
        }
        this.hm = RecInterestLoanContractUI.showRecInterestLoanContractUI((CoreUI)this);
        this.setIDs = (Set)this.hm.get("createdID");
        if (this.setIDs != null) {
            String includeValue = this.parseValue(this.setIDs);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)includeValue, CompareType.INCLUDE));
            this.mainQuery.setFilter(filter);
            this.refresh(e);
        }
    }

    private void checkHasNumber() throws Exception {
        if (!SLUtils.checkCodingRule(new LoanContractInterestInfo())) {
            throw new BEException(BEException.COMMON, new Object[]{"\u94f6\u56e2\u8d37\u6b3e\u5229\u606f\u5355\u6307\u5b9a\u7684\u7f16\u7801\u89c4\u5219\u672a\u5b9a\u4e49\u6216\u8005\u672a\u542f\u7528"});
        }
    }

    public boolean destroyWindow() {
        try {
            if (this.isEnterByPreInt) {
                boolean hasSavedBill;
                FilterInfo filt = new FilterInfo();
                filt.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer("0")));
                this.mainQuery.getFilter().mergeFilter(filt, "AND");
                LoanContractInterestCollection col = LoanContractInterestFactory.getRemoteInstance().getLoanContractInterestCollection(this.mainQuery);
                boolean bl = hasSavedBill = col.size() > 0;
                if (hasSavedBill) {
                    boolean isSave;
                    int result = MsgBox.showConfirm2New((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"332_LoanInterestListUI"));
                    boolean bl2 = isSave = result == 1;
                    if (isSave) {
                        return false;
                    }
                    this.isEnterByPreInt = false;
                    FilterInfo f = new FilterInfo();
                    f.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer("0")));
                    this.mainQuery.getFilter().mergeFilter(f, "AND");
                    LoanContractInterestFactory.getRemoteInstance().delete(this.mainQuery.getFilter());
                    return super.destroyWindow();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblMain_tableSelectChanged(e);
        String billId = this.getSelectedKeyValue();
        ObjectStringPK pk = new ObjectStringPK(billId);
        LoanContractInterestInfo info = (LoanContractInterestInfo)this.getBizInterface().getValue((IObjectPK)pk);
        if (info.isFiVouchered()) {
            this.actionVoucher.setEnabled(false);
            this.actionDelVoucher.setEnabled(true);
        } else {
            this.actionVoucher.setEnabled(true);
            this.actionDelVoucher.setEnabled(false);
        }
    }

    private final class FillListener
    implements KDTDataFillListener {
        private FillListener() {
        }

        public void afterDataFill(KDTDataRequestEvent e) {
            IRow row = null;
            String currencyId = null;
            CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
            if (e == null) {
                return;
            }
            for (int i = e.getFirstRow(); i <= e.getLastRow(); ++i) {
                String rateExpression;
                row = LoanContractInterestListUI.this.tblMain.getRow(i);
                currencyId = (String)row.getCell("currency.id").getValue();
                if (currencyId != null) {
                    FMClientHelper.setNumberFormat((IRow)row, (String)"amount", (String)currencyId);
                    FMClientHelper.setNumberFormat((IRow)row, (String)"interest", (String)currencyId);
                    FMClientHelper.setNumberFormat((IRow)row, (String)"realInterest", (String)currencyId);
                    FMClientHelper.setNumberFormat((IRow)row, (String)"punishInterest", (String)currencyId);
                    FMClientHelper.setNumberFormat((IRow)row, (String)"realPunishInterest", (String)currencyId);
                    FMClientHelper.setNumberFormat((IRow)row, (String)"strikeAmount", (String)currencyId);
                }
                if (row.getCell("penAccrualRateAddPercent").getValue() != null) {
                    row.getCell("penAccrualRateAddPercent").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                    row.getCell("penAccrualRateAddPercent").getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm((int)5));
                }
                if (row.getCell("penAccrualRateAddaccrual").getValue() != null) {
                    row.getCell("penAccrualRateAddaccrual").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                    row.getCell("penAccrualRateAddaccrual").getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm((int)5));
                }
                if (row.getCell("intRate").getValue() != null) {
                    row.getCell("intRate").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                }
                if (row.getCell("intRateTypeExpression").getValue() != null && (rateExpression = row.getCell("intRateTypeExpression").getValue().toString()) != null) {
                    if (rateExpression.equals(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"480_CompDepositAccountBillListUI"))) {
                        row.getCell("intRate").getFormattedStyleAttributes().setNumberFormat("##,###,###,###,###,##0.0000000000!%");
                    } else {
                        row.getCell("intRate").getFormattedStyleAttributes().setNumberFormat("##,###,###,###,###,##0.0000000000!\u2030");
                    }
                }
                if (row.getCell("exchange").getValue() != null) {
                    row.getCell("exchange").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                    row.getCell("exchange").getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm((int)6));
                }
                if (row.getCell("days").getValue() != null) {
                    row.getCell("days").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                }
                if (row.getCell("daysOverdue").getValue() == null) continue;
                row.getCell("daysOverdue").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            }
        }
    }
}

