/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.sl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.common.util.MsgPromtUtil;
import com.kingdee.eas.fm.fin.FinancingFeeRourceEnum;
import com.kingdee.eas.fm.fin.client.FinancingFeeBillBathUI;
import com.kingdee.eas.fm.sl.FsBillStatusEnum;
import com.kingdee.eas.fm.sl.ILoanContract;
import com.kingdee.eas.fm.sl.LoanContractFactory;
import com.kingdee.eas.fm.sl.LoanContractInfo;
import com.kingdee.eas.fm.sl.LoanFetchCollection;
import com.kingdee.eas.fm.sl.LoanFetchFactory;
import com.kingdee.eas.fm.sl.LoanFetchInfo;
import com.kingdee.eas.fm.sl.client.AbstractLoanContractListUI;
import com.kingdee.eas.fm.sl.client.ExtensionEditUI;
import com.kingdee.eas.fm.sl.client.LoanContractAdjustEditUI;
import com.kingdee.eas.fm.sl.client.LoanContractFilterParam;
import com.kingdee.eas.fm.sl.client.LoanContractFilterUI;
import com.kingdee.eas.fm.sl.util.SLUtils;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class LoanContractListUI
extends AbstractLoanContractListUI {
    private static final Logger logger = CoreUIObject.getLogger(LoanContractListUI.class);
    private boolean historyContract = false;
    protected LoanContractFilterUI filterUI = null;
    private static final String SLRESOURCE = "com.kingdee.eas.fm.sl.FmslResource";
    UIContext uiContext = new UIContext((Object)this);
    private Map returnMap = null;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String billId = this.getSelectedKeyValue();
        LoanContractInfo info = (LoanContractInfo)this.getBizInterface().getValue((IObjectPK)new ObjectStringPK(billId));
        if (info != null && info.getStatus() == FsBillStatusEnum.AUDIT) {
            MsgBox.showWarning((String)"\u4fdd\u5b58\u6216\u63d0\u4ea4\u72b6\u6001\u4e14\u65e0\u4e0b\u6e38\u5355\u636e\u7684\u8bb0\u5f55\u5141\u8bb8\u5220\u9664");
            SysUtil.abort();
        }
        super.actionRemove_actionPerformed(e);
    }

    public void actionCreateTo_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkSelectOneItem((CoreUI)this, this.tblMain);
        String billId = this.getSelectedKeyValue();
        LoanContractInfo info = (LoanContractInfo)this.getBizInterface().getValue((IObjectPK)new ObjectStringPK(billId));
        this.checkRepayCondition(info);
        super.actionCreateTo_actionPerformed(e);
    }

    private void checkRepayCondition(LoanContractInfo info) throws Exception {
        if (info != null && info.getStatus() != FsBillStatusEnum.AUDIT) {
            MsgPromtUtil.showInfo((CoreUI)this, (String)SLRESOURCE, (String)"23_CanRepayContract");
        }
        if (info.getTotalBalance() != null && info.getTotalBalance().compareTo(Constants.ZERO) == 0) {
            MsgPromtUtil.showInfo((CoreUI)this, (String)SLRESOURCE, (String)"23_CanRepayContract");
        }
    }

    private void checkAllLoanFetchStatus(LoanContractInfo info) throws Exception {
        String sourceBillId = info.getId().toString();
        EntityViewInfo viewC = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("sourceBillId"));
        sic.add(new SelectorItemInfo("status"));
        filter.getFilterItems().add(new FilterItemInfo("sourceBillId", (Object)sourceBillId));
        viewC.setFilter(filter);
        viewC.setSelector(sic);
        LoanFetchCollection coll = LoanFetchFactory.getRemoteInstance().getLoanFetchCollection(viewC);
        if (coll.size() > 0) {
            Iterator it = coll.iterator();
            while (it.hasNext()) {
                LoanFetchInfo fetchInfo = (LoanFetchInfo)it.next();
                if (fetchInfo.getStatus() == FsBillStatusEnum.AUDIT) continue;
                MsgPromtUtil.showInfo((CoreUI)this, (String)SLRESOURCE, (String)"38_AllFetchBillAuditCanCreateReapy");
            }
        }
    }

    public void checkSelectOneItem(CoreUI ui, KDTable table) {
        int size = KDTableUtil.getSelectedRowCount((KDTable)this.tblMain);
        if (size > 1) {
            MsgPromtUtil.showInfo((CoreUI)ui, (String)SLRESOURCE, (String)"24_OnlyOneRecoreCanCreateRepay");
        }
    }

    protected boolean isMutiRemove() {
        return false;
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new LoanContractFilterUI(this.historyContract);
        }
        return this.filterUI;
    }

    protected String getCurrencyIdColName() {
        return "CurrencyId";
    }

    protected String[] getPrecColName() {
        return new String[]{"loanPromiseAmount", "notFetchAmount", "totalProjectAmount"};
    }

    protected String getEditUIName() {
        return "com.kingdee.eas.fm.sl.client.LoanContractEditUI";
    }

    protected ICoreBase getBizInterface() throws Exception {
        return LoanContractFactory.getRemoteInstance();
    }

    public void onLoad() throws Exception {
        String parem = (String)this.getUIContext().get("UIClassParam");
        if (!FMHelper.isEmpty((String)parem)) {
            this.historyContract = true;
        }
        if (this.historyContract) {
            this.setUITitle("\u5386\u53f2\u501f\u6b3e\u5408\u540c");
        }
        this.tblMain.getDataRequestManager().setDataRequestMode(0);
        super.onLoad();
        this.displayButton();
        this.setBtnDisplayInBizUnit();
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_auditing"));
        this.actionUnAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_fauditing"));
        this.actionExtension.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_movedata"));
        this.actionExtensionCancel.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_undo"));
        this.actionCreateTo.putValue("SmallIcon", (Object)EASResource.getIcon((String)"imgTbtn_requite"));
        this.actionFinFee.setEnabled(true);
        this.actionFinFee.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_modifyformat"));
        this.actionAdjust.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_backwarddepreciat"));
    }

    protected void execQuery() {
        FilterInfo extFilter = this.getBillCanbeReceived();
        if (extFilter != null && extFilter.getFilterItems().size() > 0) {
            try {
                this.mainQuery.getFilter().mergeFilter(extFilter, "AND");
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
        super.execQuery();
        this.onshows();
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.getDataRequestManager().addDataFillListener((KDTDataFillListener)new FillListener());
    }

    public void setListUITable(KDTable tblMain, KDTDataRequestEvent e) {
        if (e == null) {
            return;
        }
        IRow row = null;
        for (int j = 0; j < tblMain.getRowCount(); ++j) {
            row = tblMain.getRow(j);
            String[] needSetArribute = new String[]{"LocalCurExRate", "loanPromiseAmount", "notFetchAmount", "Horizon", "extendLimit", "BasePoints", "rateAdjustPeriod", "penAccrualRateAddPercent", "penAccrualRateAddaccrual", "yearDays", "YieldRate", "amountlocalcur", "totalProjectAmount"};
            this.setRightAttribute(row, needSetArribute);
        }
        String currencyId = null;
        IRow row2 = null;
        for (int j = 0; j < tblMain.getRowCount(); ++j) {
            String rateExpression;
            row2 = tblMain.getRow(j);
            row2.getCell("BasePoints").getFormattedStyleAttributes().setNumberFormat(FMClientHelper.getKDTNumFormat((int)2));
            row2.getCell("BasePoints").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            row2.getCell("YieldRate").getFormattedStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            if (row2.getCell("intRateTypeExpression").getValue() == null || (rateExpression = row2.getCell("intRateTypeExpression").getValue().toString()) == null) continue;
            if (rateExpression.equals(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"480_CompDepositAccountBillListUI"))) {
                row2.getCell("YieldRate").getFormattedStyleAttributes().setNumberFormat("##,###,###,###,###,##0.0000000000!%");
                continue;
            }
            row2.getCell("YieldRate").getFormattedStyleAttributes().setNumberFormat("##,###,###,###,###,##0.0000000000!\u2030");
        }
        for (int i = e.getFirstRow(); i <= e.getLastRow(); ++i) {
            row = tblMain.getRow(i);
            if (row.getCell("extendLimit").getValue() != null) {
                row.getCell("extendLimit").getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm((int)0));
            }
            if (row.getCell("Horizon").getValue() != null) {
                row.getCell("Horizon").getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm((int)0));
            }
            if (row.getCell("amountlocalcur").getValue() != null) {
                row.getCell("amountlocalcur").getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm((int)this.getBaseCurrencyPrecision()));
            }
            if (row.getCell("penAccrualRateAddPercent").getValue() != null) {
                row.getCell("penAccrualRateAddPercent").getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm((int)10));
            }
            if (row.getCell("penAccrualRateAddaccrual").getValue() != null) {
                row.getCell("penAccrualRateAddaccrual").getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm((int)10));
            }
            if (row.getCell("LocalCurExRate").getValue() != null) {
                row.getCell("LocalCurExRate").getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm((int)6));
            }
            if ((currencyId = (String)row.getCell(this.getCurrencyIdColName()).getValue()) == null) continue;
            String[] formatCol = this.getPrecColName();
            for (int j = 0; j < formatCol.length; ++j) {
                FMClientHelper.setNumberFormat((IRow)row, (String)formatCol[j], (String)currencyId);
            }
        }
    }

    private void setRightAttribute(IRow curRow, String[] needSetArr) {
        if (needSetArr != null) {
            for (int i = 0; i < needSetArr.length; ++i) {
                curRow.getCell(needSetArr[i]).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            }
        }
    }

    private FilterInfo getBillCanbeReceived() {
        FilterInfo filterInfo = new FilterInfo();
        if (this.historyContract) {
            filterInfo.getFilterItems().add(new FilterItemInfo("historybill", (Object)new Boolean(this.historyContract)));
        }
        if (this.getUIContext().get("BTPEDITPARAMETER") != null && ((Map)this.getUIContext().get("BTPEDITPARAMETER")).get("isCreateLoanFetch") != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(2)));
            filterInfo.getFilterItems().add(new FilterItemInfo("balance", (Object)SysConstant.BIGZERO, CompareType.GREATER));
            filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString()));
        }
        return filterInfo;
    }

    private void onshows() {
        boolean isFpItem = FMClientHelper.getIsFpOrBg();
        FMClientHelper.initFpOrBgF7Item((boolean)isFpItem, (IColumn)this.tblMain.getColumn("fpItem"), (IColumn)this.tblMain.getColumn("bgItem"));
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String billId = this.getSelectedKeyValue();
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)billId));
        LoanContractInfo info = (LoanContractInfo)this.getBizInterface().getValue((IObjectPK)new ObjectStringPK(billId));
        if (info != null && (info.getStatus() == FsBillStatusEnum.AUDIT || info.getStatus() == FsBillStatusEnum.SAVE)) {
            MsgBox.showWarning((String)"\u63d0\u4ea4\u72b6\u6001\u7684\u8bb0\u5f55\u5141\u8bb8\u5ba1\u6279");
            SysUtil.abort();
        }
        LoanContractFactory.getRemoteInstance().audit((IObjectPK)pk);
        FMClientHelper.showSuccessMessage((CoreUI)this, (Component)((Component)e.getSource()));
        this.refreshList();
    }

    @Override
    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String billId = this.getSelectedKeyValue();
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)billId));
        LoanContractInfo info = (LoanContractInfo)this.getBizInterface().getValue((IObjectPK)new ObjectStringPK(billId));
        if (info.getStatus() != FsBillStatusEnum.AUDIT) {
            MsgBox.showWarning((String)"\u5df2\u5ba1\u6279\u4e14\u65e0\u4e0b\u6e38\u5355\u636e\u7684\u8bb0\u5f55\u5141\u8bb8\u53cd\u5ba1\u6279");
            SysUtil.abort();
        }
        LoanContractFactory.getRemoteInstance().unAudit((IObjectPK)pk);
        FMClientHelper.showSuccessMessage((CoreUI)this, (Component)((Component)e.getSource()));
        this.refreshList();
    }

    protected IRow appendFootRow() {
        IRow sumRow = super.appendFootRow();
        this.formatFootRow();
        return sumRow;
    }

    protected boolean isFootVisible() {
        return true;
    }

    protected void formatFootRow() {
        CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        try {
            LoanContractFilterParam param = (LoanContractFilterParam)((Object)this.getFilterUI().getParam());
            if (this.tblMain.getFootManager() == null) {
                return;
            }
            IRow row = this.tblMain.getFootManager().getFootRow(0);
            String curID = null;
            curID = param.getCurrencyId() == null ? company.getBaseCurrency().getId().toString() : param.getCurrencyId();
            String[] columns = new String[]{"loanPromiseAmount", "amountlocalcur", "notFetchAmount"};
            for (int i = 0; i < columns.length; ++i) {
                FMClientHelper.setNumberFormat((IRow)row, (String)columns[i], (String)curID);
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    private void setBtnDisplayInBizUnit() {
        boolean isBizUnit = SLUtils.checkBizUnit();
        this.actionAudit.setVisible(!isBizUnit);
        this.actionUnAudit.setVisible(!isBizUnit);
        this.actionExtension.setVisible(!isBizUnit);
        this.actionExtensionCancel.setVisible(!isBizUnit);
        this.actionCreateTo.setVisible(!isBizUnit);
        this.actionFinFee.setVisible(!isBizUnit);
        this.actionAdjust.setVisible(!isBizUnit);
    }

    protected void displayButton() {
        this.btnWorkFlowG.setVisible(false);
        this.btnAuditResult.setVisible(false);
        this.btnLocate.setVisible(false);
        this.menuItemCopyTo.setVisible(false);
        this.menuItemLocate.setVisible(false);
        this.menuWorkFlow.setVisible(false);
    }

    @Override
    public void actionExtension_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String billId = this.getSelectedKeyValue();
        ObjectStringPK pk = new ObjectStringPK(billId);
        LoanContractInfo info = (LoanContractInfo)this.getBizInterface().getValue((IObjectPK)pk);
        if (!FMHelper.isEmpty((CoreBaseInfo)info)) {
            BigDecimal totalBalance;
            BigDecimal totalFetchAmount = FMHelper.isEmpty((Object)info.getTotalFetchAmount()) ? Constants.ZERO : info.getTotalFetchAmount();
            BigDecimal bigDecimal = totalBalance = FMHelper.isEmpty((Object)info.getTotalBalance()) ? Constants.ZERO : info.getTotalBalance();
            if (info.getStatus() != FsBillStatusEnum.AUDIT || totalFetchAmount.compareTo(Constants.ZERO) <= 0 || totalBalance.compareTo(Constants.ZERO) == 0) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)SLRESOURCE, (String)"4_Contract_Extension"));
                SysUtil.abort();
            }
            this.CreateExtensionUI(e, info);
            Object obj = this.returnMap.get("operateFlag");
            if (obj instanceof Boolean && obj.equals(Boolean.TRUE)) {
                FMClientHelper.showSuccessMessage((CoreUI)this, (Component)((Component)e.getSource()));
                this.refreshList();
            }
        }
    }

    private void CreateExtensionUI(ActionEvent e, LoanContractInfo info) throws Exception {
        this.uiContext.put((Object)"loanContractInfo", (Object)info);
        this.returnMap = ExtensionEditUI.showExtensionEditUI(this, this.uiContext);
    }

    @Override
    public void actionExtensionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String billId = this.getSelectedKeyValue();
        ObjectStringPK pk = new ObjectStringPK(billId);
        LoanContractInfo info = (LoanContractInfo)this.getBizInterface().getValue((IObjectPK)pk);
        if (!FMHelper.isEmpty((CoreBaseInfo)info)) {
            if (info.getStatus() != FsBillStatusEnum.AUDIT || !info.isIsExtension()) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)SLRESOURCE, (String)"5_Contract_CancelExtension"));
                SysUtil.abort();
            }
            ((ILoanContract)this.getBizInterface()).cancelExtension((IObjectPK)pk);
        }
        FMClientHelper.showSuccessMessage((CoreUI)this, (Component)((Component)e.getSource()));
        this.refreshList();
    }

    @Override
    public void actionFinFee_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        LoanContractInfo info = (LoanContractInfo)this.getBizInterface().getValue((IObjectPK)new ObjectUuidPK(this.getSelectedKeyValue()), this.getSelectors());
        if (info.getStatus().equals((Object)FsBillStatusEnum.SAVE)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)SLRESOURCE, (String)"39_FinFee"));
            SysUtil.abort();
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"id", (Object)info.getId().toString());
        uiContext.put((Object)"FinancingProduct", (Object)info.getType());
        uiContext.put((Object)"sourceBillNm", (Object)info.getNumber());
        uiContext.put((Object)"sourceBillType", (Object)FinancingFeeRourceEnum.LoanContract);
        IUIWindow uiWindow = null;
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(FinancingFeeBillBathUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("Type.id"));
        sic.add(new SelectorItemInfo("Type.number"));
        sic.add(new SelectorItemInfo("Type.name"));
        return sic;
    }

    @Override
    public void actionAdjust_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String billId = this.getSelectedKeyValue();
        ObjectStringPK pk = new ObjectStringPK(billId);
        LoanContractInfo info = (LoanContractInfo)this.getBizInterface().getValue((IObjectPK)pk);
        this.adjustRateCheck(info);
        LoanContractAdjustEditUI.show((CoreUIObject)this, (IObjectPK)pk);
    }

    private void adjustRateCheck(LoanContractInfo info) throws Exception {
        String XIEYILILV;
        if (info.getIntRateType() != null && !(XIEYILILV = info.getIntRateType().getId().toString()).equals("lJlpCQEQEADgAAc+wKgSjiR9knQ=")) {
            MsgBox.showInfo((Component)((Object)this), (String)"\u975e\u534f\u8bae\u5229\u7387\u501f\u6b3e\u5408\u540c\u8c03\u606f\u8bf7\u5728\u5229\u7387\u8868\u4e2d\u8c03\u6574\u5229\u7387");
            SysUtil.abort();
        }
        if (info.getStatus() != FsBillStatusEnum.AUDIT) {
            MsgBox.showInfo((Component)((Object)this), (String)"\u5df2\u5ba1\u6279\u72b6\u6001\u7684\u8bb0\u5f55\u5141\u8bb8\u8c03\u606f");
            SysUtil.abort();
        }
        if (info.getAmount().compareTo(info.getBalance()) == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)"\u501f\u6b3e\u5408\u540c\u5c1a\u672a\u63d0\u6b3e\uff0c\u4e0d\u5141\u8bb8\u8c03\u606f");
            SysUtil.abort();
        }
        if (info.getTotalBalance() != null && info.getTotalBalance().compareTo(Constants.ZERO) <= 0) {
            MsgBox.showInfo((Component)((Object)this), (String)"\u501f\u6b3e\u5408\u540c\u5df2\u5168\u989d\u8fd8\u6b3e\uff0c\u4e0d\u5141\u8bb8\u8c03\u606f");
            SysUtil.abort();
        }
    }

    public List getDestBosTypeForBotp(CoreBillBaseCollection srcBillInfos, List destBosTypeList) {
        LoanFetchInfo info = new LoanFetchInfo();
        String removeBosType = info.getBOSType().toString();
        for (int i = destBosTypeList.size() - 1; i >= 0; --i) {
            String bosType = (String)destBosTypeList.get(i);
            if (!removeBosType.equals(bosType)) continue;
            destBosTypeList.remove(i);
        }
        return destBosTypeList;
    }

    public FilterInfo getFilterInfo() {
        FilterInfo filterInfo = new FilterInfo();
        if (this.getUIContext().get("BTPEDITPARAMETER") != null && ((Map)this.getUIContext().get("BTPEDITPARAMETER")).get("isCreateLoanFetch") != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(2)));
            filterInfo.getFilterItems().add(new FilterItemInfo("balance", (Object)SysConstant.BIGZERO, CompareType.GREATER));
            filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString()));
        }
        return filterInfo;
    }

    private final class FillListener
    implements KDTDataFillListener {
        private FillListener() {
        }

        public void afterDataFill(KDTDataRequestEvent e) {
            LoanContractListUI.this.setListUITable(LoanContractListUI.this.tblMain, e);
        }
    }
}

