/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.sl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.BasicFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fm.common.FMBgItemProp;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.F7SelectorFactory;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.common.client.KDTableTotalRowUtil;
import com.kingdee.eas.fm.common.util.FMBillBigDecimalUtil;
import com.kingdee.eas.fm.common.util.FMBillUtil;
import com.kingdee.eas.fm.common.util.MsgPromtUtil;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.fin.FinancingBillTypeEnum;
import com.kingdee.eas.fm.im.IntRateTypeExpressionEnum;
import com.kingdee.eas.fm.sl.LoanContractExecuteEntryCollection;
import com.kingdee.eas.fm.sl.LoanContractExecuteEntryFactory;
import com.kingdee.eas.fm.sl.LoanContractExecuteEntryInfo;
import com.kingdee.eas.fm.sl.LoanContractFactory;
import com.kingdee.eas.fm.sl.LoanContractInfo;
import com.kingdee.eas.fm.sl.LoanContractInterestInfo;
import com.kingdee.eas.fm.sl.LoanContractOfLenderEntryFactory;
import com.kingdee.eas.fm.sl.LoanContractOfLenderEntryInfo;
import com.kingdee.eas.fm.sl.LoanContractRepayCollection;
import com.kingdee.eas.fm.sl.LoanContractRepayDetailCollection;
import com.kingdee.eas.fm.sl.LoanContractRepayDetailInfo;
import com.kingdee.eas.fm.sl.LoanContractRepayFactory;
import com.kingdee.eas.fm.sl.LoanContractRepayInfo;
import com.kingdee.eas.fm.sl.RepayBankDetailCollection;
import com.kingdee.eas.fm.sl.RepayBankDetailInfo;
import com.kingdee.eas.fm.sl.client.AbstractLoanContractRepayEditUI;
import com.kingdee.eas.fm.sl.client.LoanContractInterestEditUI;
import com.kingdee.eas.fm.sl.util.SLUtils;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.budget.FpCashDirectionEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class LoanContractRepayEditUI
extends AbstractLoanContractRepayEditUI {
    private static final Logger logger = CoreUIObject.getLogger(LoanContractRepayEditUI.class);
    private BigDecimal restBalance = Constants.ZERO;
    private BigDecimal Balance = Constants.ZERO;
    private BigDecimal totalAmount = Constants.ZERO;
    private KDCheckBox check = new KDCheckBox();
    KDTableTotalRowUtil totalRow_kDRepayDetail;
    KDTableTotalRowUtil totalRow_kDLoanBankDetail;
    private static final BigDecimal maxValue = new BigDecimal("9999999999999");
    private static final BigDecimal minValue = Constants.ZERO;
    private static final BigDecimal largeMaxValue = new BigDecimal("99999999999999999999999999");
    private static final String SLRESOURCE = "com.kingdee.eas.fm.sl.FmslResource";
    private static boolean isNeedChange = false;
    private static boolean isCreateTo = false;
    private Date LastRepayDate = null;
    private Date maxFetchDate = null;
    private LoanContractInfo contractInfo = null;

    public LoanContractRepayEditUI() throws Exception {
        this.setPreferredSize(new Dimension(1000, 780));
    }

    public void onLoad() throws Exception {
        this.initLoanContractRepayHeader();
        this.initLoanContractRepayEntrys();
        this.initEntryStyle();
        super.onLoad();
        this.contractInfo = this.editData.getSourceBillNm();
        this.specialOperate();
    }

    @Override
    public void onShow() {
        try {
            super.onShow();
            this.kDRepayDetail.removeKDTMouseListener((KDTMouseListener)this.kDRepayDetail.getSortMange());
            this.kDRepayDetail.setSortMange(null);
        }
        catch (Exception ex) {
            this.handUIExceptionAndAbort(ex);
        }
    }

    public void initLoanContractRepayHeader() {
        this.setFieldStyle(this.txtloanAmount, false, true);
        this.setFieldStyle(this.txtRepaySeq, false, false);
        this.setFieldStyle(this.txtRepayAmount, true, false);
        this.setFieldStyle(this.txtLocalAmount, false, false);
        this.setFieldStyle(this.txtTotalAddAmount, true, false);
        this.setFieldStyle(this.txtBalance, true, false);
        this.setFieldStyle(this.txtLocalCurExRate, true, false);
        this.setFieldStyle(this.txtRate, true, false);
        this.setFieldStyle(this.txtInterest, true, false);
        this.setFieldStyle(this.txtRepayment, true, false);
        this.pkBizDate.setSupportedEmpty(false);
        this.txtDescription.setMaxLength(200);
    }

    public void initLoanContractRepayEntrys() {
        CurrencyInfo currency = (CurrencyInfo)this.comCurrency.getSelectedItem();
        SLUtils.resetTextFieldStyle(this.kdtLoanBankDetail, null, new KDFormattedTextField(), "creditRate", minValue, maxValue);
        SLUtils.resetTextFieldStyle(this.kdtLoanBankDetail, currency, new KDFormattedTextField(), "returnQuota", minValue, maxValue);
        SLUtils.resetTextFieldStyle(this.kDRepayDetail, currency, new KDFormattedTextField(), "repayAmt", minValue, maxValue);
        SLUtils.resetTextFieldStyle(this.kdtLoanBankDetail, null, new KDFormattedTextField(), "repayAmt", minValue, maxValue);
        SLUtils.resetTextFieldStyle(this.kdtLoanBankDetail, null, new KDFormattedTextField(), "balance", minValue, maxValue);
        KDTextField remark = new KDTextField();
        remark.setMaxLength(200);
        this.kdtLoanBankDetail.getColumn("remark").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)remark));
        KDTextField remark1 = new KDTextField();
        remark1.setMaxLength(200);
        this.kDRepayDetail.getColumn("remark").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)remark1));
    }

    public void initEntryStyle() {
        this.kDTabbedPane1.removeAll();
        this.kDTabbedPane1.add((Component)this.kDPanel1, (Object)this.resHelper.getString("kDPanel1.constraints"));
        this.kDTabbedPane1.add((Component)this.kDPanel2, (Object)this.resHelper.getString("kDPanel2.constraints"));
        int height = 215;
        this.kDPanel1.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(0, 0, 870, height));
        this.kDPanel2.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(0, 0, 870, height));
    }

    public void setFieldStyle(KDFormattedTextField field, boolean setRange, boolean setLargeRange) {
        if (field == null) {
            return;
        }
        field.setRemoveingZeroInDispaly(false);
        field.setHorizontalAlignment(4);
        if (setRange) {
            field.setMaximumValue((Comparable)maxValue);
            field.setMinimumValue((Comparable)minValue);
        }
        if (setLargeRange) {
            field.setMaximumValue((Comparable)largeMaxValue);
            field.setMinimumValue((Comparable)minValue);
        }
    }

    private void specialOperate() {
        this.actionAuditResult.setVisible(false);
        if (this.kDRepayDetail != null && this.kDRepayDetail.getSortMange() != null) {
            this.kDRepayDetail.getSortMange().setSortAuto(false);
        }
    }

    @Override
    public void loadFields() {
        FMClientHelper.loadFieldsBgItem((KDBizPromptBox)this.prmtbgItem, (CoreBaseInfo)this.editData, (FMBgItemProp)this.editData.getBgItemProps()[0]);
        FMClientHelper.initNumber((CoreBaseInfo)this.editData, (KDTextField)this.txtNumber, (String)this.editData.getCompany().getId().toString());
        super.loadFields();
        if (this.editData.getCurrency() != null) {
            FMClientHelper.setSelectObject((KDComboBox)this.comCurrency, (Object)this.editData.getCurrency());
        } else {
            FMClientHelper.setSelectObject((KDComboBox)this.comCurrency, (Object)this.currentCompany.getBaseCurrency());
        }
        this.setEntryExchangeRateStyle();
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
        if (this.getOprtState().equals(OprtState.EDIT)) {
            SLUtils.resetKdtableStatus(this.kDRepayDetail, new String[]{"isRepay", "repayAmt"}, true);
            SLUtils.resetKdtableStatus(this.kdtLoanBankDetail, new String[]{"repayAmt", "creditRate", "returnQuota"}, true);
        }
    }

    private void setEntryExchangeRateStyle() {
        CurrencyInfo curCurrency = (CurrencyInfo)this.comCurrency.getSelectedItem();
        SLUtils.setEntryExchangeRate(this.kdtLoanBankDetail, "CreditCurrency", "creditRate", curCurrency, isCreateTo, isNeedChange, this.pkBizDate, this.currentCompany, true, "repayAmt", "returnQuota", false);
        isCreateTo = false;
    }

    @Override
    public void storeFields() {
        if (this.totalRow_kDRepayDetail != null) {
            this.totalRow_kDRepayDetail.removeTotalRow();
        }
        if (this.totalRow_kDLoanBankDetail != null) {
            this.totalRow_kDLoanBankDetail.removeTotalRow();
        }
        FMClientHelper.storeFieldsBgItem((KDBizPromptBox)this.prmtbgItem, (CoreBaseInfo)this.editData, (FMBgItemProp)this.editData.getBgItemProps()[0]);
        super.storeFields();
        if (this.totalRow_kDRepayDetail != null) {
            this.totalRow_kDRepayDetail.resetTotalRow(true);
        }
        if (this.totalRow_kDLoanBankDetail != null) {
            this.totalRow_kDLoanBankDetail.resetTotalRow(true);
        }
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        super.setDataObject(dataObject);
        if (this.getOprtState().equals(OprtState.ADDNEW) && this.getBOTPViewStatus() == 1) {
            this.initBaseData();
            this.initEntryDetailData();
            isCreateTo = true;
        }
    }

    protected void initUIProp() throws Exception {
        super.initUIProp();
        CashHelper.initCombCurrency((KDComboBox)this.comCurrency, (boolean)false);
        this.check.setVisible(true);
        this.check.setEnabled(true);
        this.kDRepayDetail.getColumn("isRepay").setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)this.check));
        this.chkMenuItemSubmitAndAddNew.setSelected(false);
    }

    protected void initPropEvi() throws Exception {
        super.initPropEvi();
        this.totalRow_kDRepayDetail = new KDTableTotalRowUtil(this.kDRepayDetail, new String[]{"repayAmt"});
        this.totalRow_kDRepayDetail.resetTotalRow(true);
        this.totalRow_kDLoanBankDetail = new KDTableTotalRowUtil(this.kdtLoanBankDetail, new String[]{"permissionRate", "repayAmt", "balance"});
        this.totalRow_kDLoanBankDetail.resetTotalRow(true);
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            this.txtRepayAmount.setEnabled(true);
            this.kDRepayDetail.getColumn("repayAmt").getStyleAttributes().setLocked(true);
        } else {
            this.kDRepayDetail.getColumn("isRepay").getStyleAttributes().setLocked(true);
            this.kDRepayDetail.getColumn("repayAmt").getStyleAttributes().setLocked(true);
            this.pkBizDate.setEnabled(false);
        }
        this.setAcctViewF7(this.prmtIntFeeAcct);
        this.setAcctViewF7(this.prmtoppAccount);
        F7SelectorFactory.initProject((IUIObject)this, (KDBizPromptBox)this.prmtProject);
        FMClientHelper.initBgItemF7((KDBizPromptBox)this.prmtbgItem, (FpCashDirectionEnum[])new FpCashDirectionEnum[]{FpCashDirectionEnum.output, FpCashDirectionEnum.other}, (boolean)true, (boolean)true);
        EntityViewInfo acctView = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        acctView.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Integer(0)));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.currentCompany.getId().toString()));
        this.prmtRepayBankAcct.setEntityViewInfo(acctView);
        this.setExtendStyle();
    }

    private void setExtendStyle() {
        if (FMHelper.isEmpty((CoreBaseInfo)this.editData)) {
            return;
        }
        IntRateTypeExpressionEnum intRateTypeExpressionEnum = this.editData.getIntRateTypeExpression();
        if (!FMHelper.isEmpty((Object)intRateTypeExpressionEnum)) {
            if (intRateTypeExpressionEnum == IntRateTypeExpressionEnum.YEAR) {
                this.contRate.setBoundLabelText(EASResource.getString((String)SLRESOURCE, (String)"9_loanFetchEditUI"));
            } else if (intRateTypeExpressionEnum == IntRateTypeExpressionEnum.MONTH) {
                this.contRate.setBoundLabelText(EASResource.getString((String)SLRESOURCE, (String)"10_loanFetchEditUI"));
            } else {
                this.contRate.setBoundLabelText(EASResource.getString((String)SLRESOURCE, (String)"10_loanFetchEditUI"));
            }
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
    }

    protected void initDataStatus() {
        super.initDataStatus();
        this.actionSubmitOption.setVisible(false);
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        FMClientVerifyHelper.verifyUIControlEmpty((CoreUI)this);
        FMClientHelper.verifyMoreThanZero((CoreUIObject)this, (KDFormattedTextField)this.txtRepayAmount);
        if (!FMHelper.isEmpty((Object)this.Balance) && this.Balance.compareTo(this.txtloanAmount.getBigDecimalValue()) > 0) {
            this.txtRepayAmount.requestFocus(true);
            if (this.editData != null) {
                this.editData.setTotalAddAmount(this.totalAmount);
            }
            this.txtTotalAddAmount.setValue((Object)this.totalAmount);
            MsgPromtUtil.showInfo((CoreUI)this, (String)SLRESOURCE, (String)"27_RepayAmountMustOverZeroLessThanLoanAmount");
        }
        if (!FMHelper.isEmpty((Object)this.txtTotalAddAmount.getBigDecimalValue()) && this.txtTotalAddAmount.getBigDecimalValue().compareTo(this.txtloanAmount.getBigDecimalValue()) > 0) {
            this.txtRepayAmount.requestFocus(true);
            if (this.editData != null) {
                this.editData.setTotalAddAmount(this.totalAmount);
            }
            this.txtTotalAddAmount.setValue((Object)this.totalAmount);
            MsgPromtUtil.showInfo((CoreUI)this, (String)SLRESOURCE, (String)"29_OverRepayAmountMustOverZeroThanLoanAmount");
        }
        if (this.restBalance.compareTo(Constants.ZERO) != 0) {
            MsgPromtUtil.showInfo((CoreUI)this, (String)SLRESOURCE, (String)"28_EntrysTotalRepayAmountMustEqualRepayAmount");
        }
        if (this.pkBizDate.getSqlDate() != null && this.LastRepayDate != null && this.pkBizDate.getSqlDate().before(this.LastRepayDate)) {
            this.pkBizDate.requestFocus(true);
            MsgPromtUtil.showInfo((CoreUI)this, (String)SLRESOURCE, (String)"26_RepayDateMustAfterLastRepayDate");
        }
        BigDecimal totalRepayAmt = Constants.ZERO;
        for (int i = 0; i < this.kdtLoanBankDetail.getRowCount() - 1; ++i) {
            BigDecimal balance;
            IRow row = this.kdtLoanBankDetail.getRow(i);
            if (row == null) continue;
            BigDecimal repayAmt = SLUtils.getKdtableColumnValue(row, "repayAmt");
            if (repayAmt.compareTo(balance = SLUtils.getKdtableColumnValue(row, "balance")) > 0) {
                MsgBox.showInfo((Component)((Object)this), (String)"\u8d37\u6b3e\u884c\u8fd8\u6b3e\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u6700\u65b0\u4f59\u989d");
                SysUtil.abort();
            }
            totalRepayAmt = totalRepayAmt.add(repayAmt);
        }
        if (totalRepayAmt.compareTo(this.txtRepayAmount.getBigDecimalValue()) != 0) {
            MsgPromtUtil.showInfo((CoreUI)this, (String)SLRESOURCE, (String)"28_EntrysTotalRepayAmountMustEqualRepayAmount");
        }
    }

    protected void initViewStatus() {
        this.pkBizDate.setEnabled(false);
        this.txtRepayAmount.setEnabled(false);
    }

    protected void initEditStatus() {
        this.pkBizDate.setEnabled(false);
        this.txtRepayAmount.setEnabled(false);
        this.chkisRepayInt.setEnabled(false);
        this.chkisCallPunishInt.setEnabled(false);
    }

    private void initEntryDetailData() {
        int i;
        String sourceBillId = this.editData.getSourceBillId();
        if (FMHelper.isEmpty((String)sourceBillId)) {
            MsgPromtUtil.showInfo((CoreUI)this, (String)SLRESOURCE, (String)"35_BOTP_SourceBillID");
        }
        LoanContractRepayDetailCollection repayColl = this.editData.getRepayContractDetail();
        LoanContractRepayDetailCollection tempRepayColl = new LoanContractRepayDetailCollection();
        if (repayColl != null && repayColl.size() > 0) {
            LoanContractRepayDetailInfo info = null;
            for (i = 0; i < repayColl.size(); ++i) {
                info = repayColl.get(i);
                if (info.getLoanBalance().compareTo(Constants.ZERO) > 0) {
                    info.setIsRepay(false);
                    info.setRepayAmt(Constants.ZERO);
                    info.setBalance(info.getLoanBalance());
                    tempRepayColl.add(info);
                }
                if (i != repayColl.size() - 1) continue;
                this.maxFetchDate = info.getFetchDate();
            }
        }
        this.editData.getRepayContractDetail().clear();
        this.editData.getRepayContractDetail().addCollection(tempRepayColl);
        RepayBankDetailCollection bankColl = this.editData.getLoanBankDetail();
        if (bankColl != null && bankColl.size() > 0) {
            for (i = 0; i < bankColl.size(); ++i) {
                RepayBankDetailInfo info = bankColl.get(i);
                LoanContractOfLenderEntryInfo lenderEntryInfo = null;
                try {
                    lenderEntryInfo = LoanContractOfLenderEntryFactory.getRemoteInstance().getLoanContractOfLenderEntryInfo((IObjectPK)new ObjectUuidPK(info.getSourceBillId()));
                }
                catch (Exception e) {
                    this.handUIExceptionAndAbort(e);
                }
                info.setRepayAmt(Constants.ZERO);
                info.setBalance(lenderEntryInfo.getLoanBalance());
            }
        }
        LoanContractInfo loanContractInfo = null;
        try {
            loanContractInfo = LoanContractFactory.getRemoteInstance().getLoanContractInfo((IObjectPK)new ObjectUuidPK(sourceBillId));
            this.editData.setSourceBillNm(loanContractInfo);
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
        EntityViewInfo viewC = new EntityViewInfo();
        FilterInfo filterC = new FilterInfo();
        viewC.setFilter(filterC);
        filterC.getFilterItems().add(new FilterItemInfo("sourceBillId", (Object)sourceBillId));
        viewC.getSelector().add(new SelectorItemInfo("id"));
        viewC.getSelector().add(new SelectorItemInfo("RepayAmount"));
        viewC.getSelector().add(new SelectorItemInfo("bizDate"));
        SorterItemCollection sorterColl = new SorterItemCollection();
        SorterItemInfo sorter = new SorterItemInfo("bizDate");
        sorter.setSortType(SortType.DESCEND);
        sorterColl.add(sorter);
        viewC.setSorter(sorterColl);
        try {
            LoanContractRepayCollection colls = LoanContractRepayFactory.getRemoteInstance().getLoanContractRepayCollection(viewC);
            LoanContractRepayInfo maxInfo = null;
            if (colls.size() > 0) {
                this.editData.setRepaySeq(colls.size() + 1);
            } else {
                this.editData.setRepaySeq(1);
            }
            if (colls.size() > 0) {
                maxInfo = colls.get(0);
                this.LastRepayDate = maxInfo.getBizDate();
            } else {
                this.LastRepayDate = null;
            }
            if (loanContractInfo != null) {
                this.totalAmount = this.totalAmount.add(this.getHistoryOverRepayAmount(sourceBillId));
            }
            this.editData.setTotalAddAmount(this.totalAmount);
            this.editData.setBalance(this.editData.getLoanAmount().subtract(this.totalAmount));
        }
        catch (BOSException e) {
            this.handUIExceptionAndAbort((Exception)((Object)e));
        }
    }

    private BigDecimal getHistoryOverRepayAmount(String sourceBillId) {
        BigDecimal historyRepayAmount = Constants.ZERO;
        EntityViewInfo viewC = new EntityViewInfo();
        FilterInfo filterC = new FilterInfo();
        viewC.setFilter(filterC);
        filterC.getFilterItems().add(new FilterItemInfo("parent.id", (Object)sourceBillId));
        viewC.getSelector().add(new SelectorItemInfo("amount"));
        viewC.getSelector().add(new SelectorItemInfo("loanExtraAmount"));
        try {
            LoanContractExecuteEntryCollection colls = LoanContractExecuteEntryFactory.getRemoteInstance().getLoanContractExecuteEntryCollection(viewC);
            Iterator it = colls.iterator();
            while (it.hasNext()) {
                LoanContractExecuteEntryInfo entryInfo = (LoanContractExecuteEntryInfo)it.next();
                BigDecimal overLoanAmount = SLUtils.getBigDecimalValue(entryInfo.getAmount());
                BigDecimal repayAmount = SLUtils.getBigDecimalValue(entryInfo.getLoanExtraAmount());
                historyRepayAmount = historyRepayAmount.add(overLoanAmount.subtract(repayAmount));
            }
        }
        catch (BOSException e) {
            this.handUIExceptionAndAbort((Exception)((Object)e));
        }
        return historyRepayAmount;
    }

    private void initBaseData() {
        this.editData.setCompany(this.currentCompany);
        this.editData.setCreator(this.userinfo);
        this.editData.setBizDate(DateTimeUtils.truncateDate((Date)new Date()));
        this.editData.setCreateTime(new Timestamp(System.currentTimeMillis()));
        this.editData.setRepayAmount(Constants.ZERO);
        this.editData.setLocalAmount(Constants.ZERO);
        this.editData.setInterest(Constants.ZERO);
        this.editData.setRepayment(Constants.ZERO);
        this.editData.setSourceBillType(FinancingBillTypeEnum.LoanContract);
        this.editData.setIsRepayInt(true);
        this.editData.setIsGenPay(false);
        this.Balance = Constants.ZERO;
        this.totalAmount = Constants.ZERO;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return LoanContractRepayFactory.getRemoteInstance();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("sourceBillId"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("bizDate"));
        sic.add(new SelectorItemInfo("createTime"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("loanContractNm"));
        sic.add(new SelectorItemInfo("isRepayInt"));
        sic.add(new SelectorItemInfo("isCallPunishInt"));
        sic.add(new SelectorItemInfo("sourceBillType"));
        sic.add(new SelectorItemInfo("loanContractNam"));
        sic.add(new SelectorItemInfo("loanAmount"));
        sic.add(new SelectorItemInfo("loanContractNm"));
        sic.add(new SelectorItemInfo("sourceBillNm.number"));
        sic.add(new SelectorItemInfo("sourceBillNm.contractNum"));
        sic.add(new SelectorItemInfo("sourceBillNm.contractName"));
        sic.add(new SelectorItemInfo("finProduct.number"));
        sic.add(new SelectorItemInfo("finProduct.name"));
        sic.add(new SelectorItemInfo("RepaySeq"));
        sic.add(new SelectorItemInfo("RepayAmount"));
        sic.add(new SelectorItemInfo("UpRepayAmt"));
        sic.add(new SelectorItemInfo("LocalCurExRate"));
        sic.add(new SelectorItemInfo("LocalAmount"));
        sic.add(new SelectorItemInfo("intRateTypeExpression"));
        sic.add(new SelectorItemInfo("Rate"));
        sic.add(new SelectorItemInfo("TotalAddAmount"));
        sic.add(new SelectorItemInfo("oppAccount.number"));
        sic.add(new SelectorItemInfo("oppAccount.name"));
        sic.add(new SelectorItemInfo("IntFeeAcct.number"));
        sic.add(new SelectorItemInfo("IntFeeAcct.name"));
        sic.add(new SelectorItemInfo("Balance"));
        sic.add(new SelectorItemInfo("Project.number"));
        sic.add(new SelectorItemInfo("Project.name"));
        sic.add(new SelectorItemInfo("bgItem.number"));
        sic.add(new SelectorItemInfo("bgItem.name"));
        sic.add(new SelectorItemInfo("Interest"));
        sic.add(new SelectorItemInfo("Repayment"));
        sic.add(new SelectorItemInfo("RepayBankAcct.*"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("Currency.id"));
        sic.add(new SelectorItemInfo("Currency.number"));
        sic.add(new SelectorItemInfo("Currency.name"));
        sic.add(new SelectorItemInfo("RepayDetail.*"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("outBgItemNumber"));
        sic.add(new SelectorItemInfo("outBgItemName"));
        sic.add(new SelectorItemInfo("outBgItemId"));
        sic.add(new SelectorItemInfo("RepayContractDetail.id"));
        sic.add(new SelectorItemInfo("RepayContractDetail.isRepay"));
        sic.add(new SelectorItemInfo("RepayContractDetail.repaySeq"));
        sic.add(new SelectorItemInfo("RepayContractDetail.fetchLoanNm"));
        sic.add(new SelectorItemInfo("RepayContractDetail.fetchDate"));
        sic.add(new SelectorItemInfo("RepayContractDetail.loanBalance"));
        sic.add(new SelectorItemInfo("RepayContractDetail.repayAmt"));
        sic.add(new SelectorItemInfo("RepayContractDetail.balance"));
        sic.add(new SelectorItemInfo("RepayContractDetail.remark"));
        sic.add(new SelectorItemInfo("LoanBankDetail.id"));
        sic.add(new SelectorItemInfo("LoanBankDetail.LenderProperty.name"));
        sic.add(new SelectorItemInfo("LoanBankDetail.bank.id"));
        sic.add(new SelectorItemInfo("LoanBankDetail.bank.name"));
        sic.add(new SelectorItemInfo("LoanBankDetail.bank.number"));
        sic.add(new SelectorItemInfo("LoanBankDetail.permissionRate"));
        sic.add(new SelectorItemInfo("LoanBankDetail.CreditLimit.*"));
        sic.add(new SelectorItemInfo("LoanBankDetail.creditCurrency.id"));
        sic.add(new SelectorItemInfo("LoanBankDetail.creditCurrency.name"));
        sic.add(new SelectorItemInfo("LoanBankDetail.repayAmt"));
        sic.add(new SelectorItemInfo("LoanBankDetail.creditRate"));
        sic.add(new SelectorItemInfo("LoanBankDetail.returnQuota"));
        sic.add(new SelectorItemInfo("LoanBankDetail.remark"));
        sic.add(new SelectorItemInfo("LoanBankDetail.balance"));
        sic.add(new SelectorItemInfo("LoanBankDetail.sourceBillId"));
        return sic;
    }

    @Override
    protected void comCurrency_itemStateChanged(ItemEvent e) throws Exception {
        super.comCurrency_itemStateChanged(e);
        CurrencyInfo currency = (CurrencyInfo)this.comCurrency.getSelectedItem();
        java.sql.Date date = this.pkBizDate.getSqlDate();
        if (currency != null) {
            this.initKDTPrecesion(currency.getPrecision());
            SLUtils.setLocalCurExRate(this.currentCompany, currency.getId().toString(), null, date, this.txtLocalCurExRate, this.txtLocalAmount);
            if (currency.equals((Object)SLUtils.getCurrentCurrency(this.currentCompany))) {
                this.txtLocalCurExRate.setEnabled(false);
            } else {
                this.txtLocalCurExRate.setEnabled(true);
            }
        }
    }

    protected void initKDTPrecesion(int prec) {
        this.initPrecesion(this.kDRepayDetail, new String[]{"loanBalance", "repayAmt", "balance"}, prec);
        this.initPrecesion(this.kdtLoanBankDetail, new String[]{"repayAmt", "returnQuota", "balance"}, prec);
        this.txtRepayAmount.setPrecision(prec);
        this.txtloanAmount.setPrecision(prec);
        this.txtTotalAddAmount.setPrecision(prec);
        this.txtBalance.setPrecision(prec);
        this.txtInterest.setPrecision(prec);
        this.txtRepayment.setPrecision(prec);
        this.initPrecesion(this.kdtLoanBankDetail, new String[]{"permissionRate"}, 4);
        this.initPrecesion(this.kdtLoanBankDetail, new String[]{"creditRate"}, 0);
    }

    protected void initPrecesion(KDTable kdt, String[] cols, int prec) {
        String format = FMClientHelper.getKDTNumFormat((int)prec);
        int n = cols.length;
        for (int i = 0; i < n; ++i) {
            IColumn col = kdt.getColumn(cols[i]);
            if (col == null) continue;
            col.getStyleAttributes().setNumberFormat(format);
            col.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }
    }

    @Override
    protected void kdtLoanBankDetail_editStopped(KDTEditEvent e) throws Exception {
        int colIndex = e.getColIndex();
        int rowIndex = e.getRowIndex();
        if (colIndex == this.kdtLoanBankDetail.getColumn("creditRate").getColumnIndex()) {
            BigDecimal creditRate = SLUtils.getKdtableColumnValue(this.kdtLoanBankDetail.getRow(rowIndex), "creditRate");
            BigDecimal repayAmt = SLUtils.getKdtableColumnValue(this.kdtLoanBankDetail.getRow(rowIndex), "repayAmt");
            this.kdtLoanBankDetail.getRow(rowIndex).getCell("returnQuota").setValue((Object)repayAmt.multiply(creditRate));
        }
        if (colIndex == this.kdtLoanBankDetail.getColumn("repayAmt").getColumnIndex()) {
            BigDecimal balance;
            BigDecimal repayAmt = SLUtils.getKdtableColumnValue(this.kdtLoanBankDetail.getRow(rowIndex), "repayAmt");
            if (repayAmt.compareTo(balance = SLUtils.getKdtableColumnValue(this.kdtLoanBankDetail.getRow(rowIndex), "balance")) > 0) {
                MsgBox.showInfo((Component)((Object)this), (String)"\u8fd8\u6b3e\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u6700\u65b0\u4f59\u989d");
                this.kdtLoanBankDetail.getRow(rowIndex).getCell("repayAmt").setValue((Object)Constants.ZERO);
                SysUtil.abort();
            }
            this.totalRow_kDLoanBankDetail.resetTotalRow(true);
        }
    }

    @Override
    protected void kDRepayDetail_editValueChanged(KDTEditEvent e) throws Exception {
        int colIndex = e.getColIndex();
        if (colIndex == this.kDRepayDetail.getColumn("isRepay").getColumnIndex()) {
            IRow row = this.kDRepayDetail.getRow(FMClientHelper.getSelectedRow((KDTable)this.kDRepayDetail));
            boolean isRepay = this.editData.getRepayContractDetail().get(FMClientHelper.getSelectedRow((KDTable)this.kDRepayDetail)).isIsRepay();
            if (this.restBalance.compareTo(Constants.ZERO) == 0 && !isRepay) {
                this.editData.getRepayContractDetail().get(FMClientHelper.getSelectedRow((KDTable)this.kDRepayDetail)).setIsRepay(false);
                this.check.setSelected(false);
                return;
            }
            this.editData.getRepayContractDetail().get(FMClientHelper.getSelectedRow((KDTable)this.kDRepayDetail)).setIsRepay(!isRepay);
            BigDecimal loanAmt = (BigDecimal)row.getCell("loanBalance").getValue();
            BigDecimal entryBalance = Constants.ZERO;
            BigDecimal repayAmt = SLUtils.getKdtableColumnValue(row, "repayAmt");
            if (!isRepay) {
                row.getCell("repayAmt").getStyleAttributes().setLocked(false);
                if (this.restBalance.compareTo(loanAmt) > 0) {
                    if (repayAmt.compareTo(Constants.ZERO) == 0) {
                        repayAmt = loanAmt;
                    }
                    this.restBalance = this.restBalance.subtract(repayAmt);
                } else {
                    repayAmt = this.restBalance;
                    entryBalance = loanAmt.subtract(this.restBalance);
                    this.restBalance = Constants.ZERO;
                }
                row.getCell("repayAmt").setValue((Object)repayAmt);
                row.getCell("balance").setValue((Object)entryBalance);
            } else {
                row.getCell("repayAmt").getStyleAttributes().setLocked(true);
                this.restBalance = this.restBalance.add(repayAmt);
                row.getCell("repayAmt").setValue((Object)Constants.ZERO);
                row.getCell("balance").setValue((Object)loanAmt);
            }
        }
        this.totalRow_kDRepayDetail.resetTotalRow(true);
    }

    @Override
    protected void kDRepayDetail_editStopped(KDTEditEvent e) throws Exception {
        int colIndex = e.getColIndex();
        if (colIndex == this.kDRepayDetail.getColumn("repayAmt").getColumnIndex()) {
            IRow row = this.kDRepayDetail.getRow(FMClientHelper.getSelectedRow((KDTable)this.kDRepayDetail));
            BigDecimal repayAmout = FMHelper.isEmpty((Object)this.txtRepayAmount.getBigDecimalValue()) ? Constants.ZERO : this.txtRepayAmount.getBigDecimalValue();
            BigDecimal bgEntryValue = SLUtils.getKdtableColumnValue(row, "repayAmt");
            BigDecimal loanBalance = SLUtils.getKdtableColumnValue(row, "loanBalance");
            if (bgEntryValue.compareTo(repayAmout) > 0 || bgEntryValue.compareTo(Constants.ZERO) < 0) {
                row.getCell("repayAmt").setValue((Object)Constants.ZERO);
                row.getCell("balance").setValue((Object)loanBalance);
                this.restBalance = this.restBalance.add((BigDecimal)e.getOldValue()).subtract(Constants.ZERO);
                row.getCell("repayAmt").getStyleAttributes().setLocked(true);
                row.getCell("isRepay").setValue((Object)Boolean.FALSE);
                this.totalRow_kDRepayDetail.resetTotalRow(true);
                MsgPromtUtil.showInfo((CoreUI)this, (String)SLRESOURCE, (String)"31_EntryRepayAmountMustMoreZeroLessRepayAmout");
            }
            if (bgEntryValue.compareTo(loanBalance) > 0) {
                row.getCell("repayAmt").setValue((Object)Constants.ZERO);
                row.getCell("balance").setValue((Object)loanBalance);
                this.restBalance = this.restBalance.add((BigDecimal)e.getOldValue()).subtract(Constants.ZERO);
                row.getCell("repayAmt").getStyleAttributes().setLocked(true);
                row.getCell("isRepay").setValue((Object)Boolean.FALSE);
                this.totalRow_kDRepayDetail.resetTotalRow(true);
                MsgPromtUtil.showInfo((CoreUI)this, (String)SLRESOURCE, (String)"32_EntryRepayAmountMustLessThanBalance");
            }
            row.getCell("balance").setValue((Object)loanBalance.subtract(bgEntryValue));
            this.restBalance = this.restBalance.add((BigDecimal)e.getOldValue()).subtract(bgEntryValue);
        }
        this.totalRow_kDRepayDetail.resetTotalRow(true);
    }

    @Override
    protected void txtRepayAmount_dataChanged(DataChangeEvent e) throws Exception {
        BigDecimal extRate;
        BigDecimal repayAmount = this.txtRepayAmount.getBigDecimalValue();
        if (repayAmount == null) {
            repayAmount = Constants.ZERO;
        }
        if (FMHelper.isEmpty((Object)(extRate = this.txtLocalCurExRate.getBigDecimalValue()))) {
            extRate = Constants.ONE;
        }
        FMClientHelper.setCutValue((KDFormattedTextField)this.txtLocalAmount, (Number)FMHelper.getLocalAmount((BigDecimal)repayAmount, (BigDecimal)extRate));
        if (FMBillBigDecimalUtil.ge((Object)this.txtLocalAmount.getBigDecimalValue(), (Object)FMBillBigDecimalUtil.MAX_VALUE)) {
            this.txtRepayAmount.setValue((Object)Constants.ZERO);
            MsgPromtUtil.showInfo((CoreUI)this, (String)SLRESOURCE, (String)"33_NeedModifyRepayAmount");
        }
        String txt = FMBillUtil.getChineseFormat((BigDecimal)repayAmount, (boolean)true);
        this.txtUpRepayAmt.setText(txt);
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            if (FMHelper.isEmpty((Object)this.editData.getTotalAddAmount())) {
                this.editData.setTotalAddAmount(Constants.ZERO);
            }
            this.txtTotalAddAmount.setValue((Object)repayAmount.add(this.editData.getTotalAddAmount()));
            if (FMHelper.isEmpty((Object)this.txtloanAmount.getBigDecimalValue())) {
                this.txtloanAmount.setValue((Object)Constants.ZERO);
            }
            this.txtBalance.setValue((Object)this.txtloanAmount.getBigDecimalValue().subtract(this.txtTotalAddAmount.getBigDecimalValue()));
            this.restBalance = FMHelper.isEmpty((Object)this.txtRepayAmount.getBigDecimalValue()) ? Constants.ZERO : this.restBalance.add(this.txtRepayAmount.getBigDecimalValue().subtract(this.Balance));
            if (!FMHelper.isEmpty((Object)this.txtRepayAmount.getBigDecimalValue())) {
                this.Balance = this.txtRepayAmount.getBigDecimalValue();
            }
            this.initEntryBankDetail();
            this.initEntryRepayDetail();
            BigDecimal txtInterestValue = FMHelper.isEmpty((Object)this.txtInterest.getBigDecimalValue()) ? Constants.ZERO : this.txtInterest.getBigDecimalValue();
            this.txtRepayment.setValue((Object)repayAmount.add(txtInterestValue));
        }
    }

    private void initEntryRepayDetail() {
        for (int i = 0; i < this.kDRepayDetail.getRowCount() - 1; ++i) {
            IRow row = this.kDRepayDetail.getRow(i);
            if (row == null) continue;
            row.getCell("isRepay").setValue((Object)Boolean.FALSE);
            BigDecimal bgEntryValue = SLUtils.getKdtableColumnValue(row, "repayAmt");
            this.restBalance = this.restBalance.add(bgEntryValue);
            if (this.editData.getRepayContractDetail() != null && this.editData.getRepayContractDetail().get(i) != null) {
                this.editData.getRepayContractDetail().get(i).setIsRepay(false);
            }
            row.getCell("repayAmt").setValue((Object)Constants.ZERO);
            row.getCell("repayAmt").getStyleAttributes().setLocked(true);
            row.getCell("balance").setValue(row.getCell("loanBalance").getValue());
        }
        if (this.totalRow_kDRepayDetail != null) {
            this.totalRow_kDRepayDetail.resetTotalRow(true);
        }
    }

    private void initEntryBankDetail() throws EASBizException, BOSException {
        java.sql.Date bizDate = this.pkBizDate.getSqlDate();
        for (int i = 0; i < this.kdtLoanBankDetail.getRowCount(); ++i) {
            BigDecimal permissionRate = (BigDecimal)this.kdtLoanBankDetail.getRow(i).getCell("permissionRate").getValue();
            BigDecimal repayAmt = this.Balance.multiply(permissionRate.divide(Constants.ONE_HUNDRED, 4, 4));
            this.kdtLoanBankDetail.getRow(i).getCell("repayAmt").setValue((Object)repayAmt);
            if (FMHelper.isEmpty((Object)this.kdtLoanBankDetail.getRow(i).getCell("CreditCurrency").getValue()) || FMHelper.isEmpty((CoreBaseInfo)this.editData.getCurrency())) continue;
            if (this.kdtLoanBankDetail.getRow(i).getCell("CreditCurrency").getValue().equals(this.editData.getCurrency().getName())) {
                this.kdtLoanBankDetail.getRow(i).getCell("creditRate").setValue((Object)Constants.ONE);
                this.kdtLoanBankDetail.getRow(i).getCell("creditRate").getStyleAttributes().setLocked(true);
                this.kdtLoanBankDetail.getRow(i).getCell("returnQuota").setValue((Object)repayAmt);
                continue;
            }
            String companyid = this.currentCompany.getId().toString();
            String srcCurrencyid = this.editData.getCurrency().getId().toString();
            String desCurrencyid = this.kdtLoanBankDetail.getRow(i).getCell("CreditCurrencyid").getValue().toString();
            BigDecimal exchangeRate = FMClientHelper.getExRate((String)companyid, (String)srcCurrencyid, (String)desCurrencyid, (Date)bizDate);
            if (isNeedChange) {
                this.kdtLoanBankDetail.getRow(i).getCell("creditRate").setValue((Object)exchangeRate);
            }
            this.kdtLoanBankDetail.getRow(i).getCell("returnQuota").setValue((Object)repayAmt.multiply(exchangeRate));
        }
    }

    @Override
    protected void txtLocalCurExRate_dataChanged(DataChangeEvent e) throws Exception {
        BigDecimal extRate = this.txtLocalCurExRate.getBigDecimalValue();
        if (FMHelper.isEmpty((Object)extRate)) {
            extRate = Constants.ONE;
        }
        if (extRate.compareTo(Constants.ZERO) < 0) {
            this.txtLocalCurExRate.requestFocus();
            MsgPromtUtil.showInfo((CoreUI)this, (String)SLRESOURCE, (String)"30_LocalCurRateMustMoreZero");
        }
        FMClientHelper.setCutValue((KDFormattedTextField)this.txtLocalAmount, (Number)FMHelper.getLocalAmount((BigDecimal)this.txtRepayAmount.getBigDecimalValue(), (BigDecimal)extRate));
        if (FMBillBigDecimalUtil.ge((Object)this.txtLocalAmount.getBigDecimalValue(), (Object)FMBillBigDecimalUtil.MAX_VALUE)) {
            this.txtRepayAmount.setValue((Object)Constants.ZERO);
            MsgPromtUtil.showInfo((CoreUI)this, (String)SLRESOURCE, (String)"33_NeedModifyRepayAmount");
        }
    }

    private void setAcctViewF7(KDBizPromptBox f7Box) throws EASBizException, BOSException {
        f7Box.setQueryInfo("com.kingdee.eas.basedata.master.account.app.F7AccountViewQuery");
        EntityViewInfo vi = new EntityViewInfo();
        vi.setFilter(new FilterInfo());
        if (this.currentCompany.getAccountTable() != null) {
            vi.getFilter().getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)this.currentCompany.getAccountTable().getId().toString()));
        }
        vi.getFilter().getFilterItems().add(new FilterItemInfo("isLeaf", (Object)Constants.TRUE));
        vi.getFilter().getFilterItems().add(new FilterItemInfo("isGFreeze", (Object)Constants.FALSE));
        vi.getFilter().getFilterItems().add(new FilterItemInfo("isCFreeze", (Object)Constants.FALSE));
        vi.getFilter().getFilterItems().add(new FilterItemInfo("companyID.id", (Object)this.currentCompany.getId().toString()));
        f7Box.setEntityViewInfo(vi);
        f7Box.getQueryAgent().resetRuntimeEntityView();
    }

    @Override
    protected void pkBizDate_dataChanged(DataChangeEvent e) throws Exception {
        java.sql.Date bizDate = this.pkBizDate.getSqlDate();
        CurrencyInfo curCurrency = (CurrencyInfo)this.comCurrency.getSelectedItem();
        isNeedChange = true;
        try {
            CurrencyInfo baseCurrency = SLUtils.getCurrentCurrency(this.currentCompany);
            FinUtils.initExchangeRate(null, (BasicFormattedTextField)this.txtLocalCurExRate, (CompanyOrgUnitInfo)this.currentCompany, (CurrencyInfo)curCurrency, (CurrencyInfo)baseCurrency, (Date)bizDate, null);
            BigDecimal amount = this.txtRepayAmount.getBigDecimalValue();
            BigDecimal extRate = this.txtLocalCurExRate.getBigDecimalValue();
            if (FMHelper.isEmpty((Object)extRate)) {
                extRate = Constants.ONE;
            }
            this.txtLocalAmount.setValue((Object)FMHelper.getLocalAmount((BigDecimal)amount, (BigDecimal)extRate));
        }
        catch (EASBizException e1) {
            this.handUIExceptionAndAbort((Exception)((Object)e1));
        }
        SLUtils.setEntryExchangeRate(this.kdtLoanBankDetail, "CreditCurrency", "creditRate", curCurrency, isCreateTo, isNeedChange, this.pkBizDate, this.currentCompany, true, "repayAmt", "returnQuota", false);
        SLUtils.resetKDTableColumnsPrecesion(this.kdtLoanBankDetail, new String[]{"returnQuota"}, curCurrency.getPrecision());
        isNeedChange = false;
    }

    @Override
    protected void chkisRepayInt_itemStateChanged(ItemEvent e) throws Exception {
        boolean chkRepayInt = this.chkisRepayInt.isSelected();
        this.chkisCallPunishInt.setEnabled(chkRepayInt);
        if (!chkRepayInt) {
            this.chkisCallPunishInt.setSelected(chkRepayInt);
        }
    }

    @Override
    protected void kDRepayDetail_tableClicked(KDTMouseEvent e) throws Exception {
        if (this.kDRepayDetail != null && this.kDRepayDetail.getSortMange() != null) {
            this.kDRepayDetail.getSortMange().setSortAuto(false);
        }
    }

    @Override
    protected void kdtLoanBankDetail_tableClicked(KDTMouseEvent e) throws Exception {
        if (this.kdtLoanBankDetail != null && this.kdtLoanBankDetail.getSortMange() != null) {
            this.kdtLoanBankDetail.getSortMange().setSortAuto(false);
        }
    }

    public boolean useScrollPane() {
        return true;
    }

    public int getVerticalScrollPolicy() {
        return 22;
    }

    public int getHorizontalScrollPolicy() {
        return 32;
    }

    protected boolean isNeedAddToolMenus() {
        return false;
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.verifyInput(e);
        if (this.chkisRepayInt.isSelected()) {
            this.storeFields();
            int result = this.createLoanContractInterest();
            if (result == 1) {
                super.actionSubmit_actionPerformed(e);
            }
            this.storeFields();
            this.initOldData((IObjectValue)this.editData);
        } else {
            super.actionSubmit_actionPerformed(e);
        }
        this.getUIWindow().close();
    }

    private int createLoanContractInterest() {
        int result = this.showIntReceiveEditUI((CoreUIObject)this, this.editData);
        return result;
    }

    public int showIntReceiveEditUI(CoreUIObject ui, LoanContractRepayInfo editData) {
        try {
            UIContext uiContext = new UIContext((Object)ui);
            uiContext.put((Object)"loanContractRepayInfo", (Object)editData);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(LoanContractInterestEditUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
            LoanContractInterestInfo info = (LoanContractInterestInfo)((LoanContractInterestEditUI)uiWindow.getUIObject()).getEditData();
            if (info.getInterest().compareTo(Constants.ZERO) <= 0) {
                uiWindow.close();
                return 1;
            }
            uiWindow.show();
            boolean success = ((LoanContractInterestEditUI)uiWindow.getUIObject()).getSuccessFlag();
            if (success) {
                uiWindow.close();
            }
            return 2;
        }
        catch (BOSException e) {
            SysUtil.abort((Throwable)e);
            return 0;
        }
    }
}

