/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.sl.client;

import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.fs.client.CurrencyUtil;
import com.kingdee.eas.fm.sl.client.AbstractLoanContractRepayFilterUI;
import com.kingdee.eas.fm.sl.client.LoanContractRepayFilterParam;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.util.Calendar;
import java.util.Date;
import java.util.Set;
import org.apache.log4j.Logger;

public class LoanContractRepayFilterUI
extends AbstractLoanContractRepayFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(LoanContractRepayFilterUI.class);

    public Object getParam() {
        LoanContractRepayFilterParam param = new LoanContractRepayFilterParam();
        Set cmpSet = this.getCompanyIdSet();
        if (cmpSet != null && cmpSet.size() > 0) {
            param.setCompanyIdSet(this.getCompanyIdSet());
        }
        if (this.kdtBegin.getSqlDate() != null) {
            param.setStartBizDate(DateTimeUtils.truncateDate((Date)this.kdtBegin.getSqlDate()));
        }
        if (this.kdtEnd.getSqlDate() != null) {
            param.setEndBizDate(DateTimeUtils.truncateDate((Date)this.kdtEnd.getSqlDate()));
        }
        if (null != this.comCurrency.getSelectedItem()) {
            if (!(this.comCurrency.getSelectedItem() instanceof FMSysDefinedEnum)) {
                param.setCurrencyId(((CurrencyInfo)this.comCurrency.getSelectedItem()).getId().toString());
            } else {
                param.setCurrencyId(null);
            }
        }
        return param;
    }

    public void setParam(Object param) {
        LoanContractRepayFilterParam filterParam = (LoanContractRepayFilterParam)((Object)param);
        this.setCompanyIdSet(filterParam.getCompanyIdSet());
        if (filterParam.getCurrencyId() != null) {
            try {
                if (filterParam.getCurrencyId() != null) {
                    CurrencyInfo cur = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(filterParam.getCurrencyId()));
                    FMClientHelper.setSelectObject((KDComboBox)this.comCurrency, (Object)cur);
                } else {
                    FMClientHelper.setSelectObject((KDComboBox)this.comCurrency, (Object)FMSysDefinedEnum.SELECT_ALL);
                }
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        this.kdtBegin.setValue((Object)filterParam.getStartBizDate());
        this.kdtEnd.setValue((Object)filterParam.getEndBizDate());
    }

    protected void init() throws Exception {
        super.init();
        CurrencyUtil.fillCombCurrency((KDComboBox)this.comCurrency);
        this.comCurrency.addItem((Object)FMSysDefinedEnum.SELECT_ALL);
        FMClientHelper.setSelectObject((KDComboBox)this.comCurrency, (Object)FMSysDefinedEnum.SELECT_ALL);
        Calendar cal = Calendar.getInstance();
        cal.set(1, 2000);
        cal.set(2, 0);
        cal.set(5, 1);
        this.kdtBegin.setValue((Object)cal.getTime());
        this.kdtEnd.setValue((Object)DateUtil.getDayBegin());
    }

    protected void setDefaultValue() {
        super.setDefaultValue();
    }

    public boolean verify() {
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.kdtBegin);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.kdtEnd);
        if (DateTimeUtils.truncateDate((Date)((Date)this.kdtBegin.getValue())).after(DateTimeUtils.truncateDate((Date)((Date)this.kdtEnd.getValue())))) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.sl.FmslResource", (String)"25_EndDateMustAfterBeginDate"));
            SysUtil.abort();
        }
        return super.verify();
    }

    public void clear() {
        super.clear();
        try {
            FMClientHelper.setSelectObject((KDComboBox)this.comCurrency, (Object)FMSysDefinedEnum.SELECT_ALL);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        Calendar cal = Calendar.getInstance();
        cal.set(1, 2000);
        cal.set(2, 0);
        cal.set(5, 1);
        this.kdtBegin.setValue((Object)cal.getTime());
        this.kdtEnd.setValue((Object)DateUtil.getDayEnd());
    }

    protected Class getParamClass() {
        return LoanContractRepayFilterParam.class;
    }
}

