/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.sl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.fin.FinancingBillTypeEnum;
import com.kingdee.eas.fm.fin.client.F7FinancingProductsTreeUI;
import com.kingdee.eas.fm.fs.client.CurrencyUtil;
import com.kingdee.eas.fm.sl.FsBillStatusEnum;
import com.kingdee.eas.fm.sl.client.AbstractLoanFetchFilterUI;
import com.kingdee.eas.fm.sl.client.LoanFetchFilterParam;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class LoanFetchFilterUI
extends AbstractLoanFetchFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(LoanFetchFilterUI.class);

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void chkIA_actionPerformed(ActionEvent e) throws Exception {
        super.chkIA_actionPerformed(e);
    }

    protected void btnCompanySelect_actionPerformed(ActionEvent e) throws Exception {
        super.btnCompanySelect_actionPerformed(e);
    }

    public Object getParam() {
        Set fpSet;
        LoanFetchFilterParam filterParam = new LoanFetchFilterParam();
        if (null != this.kDComboBoxCurrency.getSelectedItem()) {
            if (!(this.kDComboBoxCurrency.getSelectedItem() instanceof FMSysDefinedEnum)) {
                filterParam.setCurrencyId(((CurrencyInfo)this.kDComboBoxCurrency.getSelectedItem()).getId().toString());
            } else {
                filterParam.setCurrencyId(null);
            }
        }
        if (!(this.status.getSelectedItem() instanceof FMSysDefinedEnum)) {
            filterParam.setStatus((FsBillStatusEnum)((Object)this.status.getSelectedItem()));
        } else {
            filterParam.setStatus(null);
        }
        Set cmpSet = this.getCompanyIdSet();
        if (cmpSet != null && cmpSet.size() > 0) {
            filterParam.setCompanyIdSet(this.getCompanyIdSet());
        }
        if (this.startBizDate.getSqlDate() != null) {
            filterParam.setStartBizDate(DateTimeUtils.truncateDate((Date)this.startBizDate.getSqlDate()));
        }
        if (this.endBizDate.getSqlDate() != null) {
            filterParam.setEndBizDate(DateTimeUtils.truncateDate((Date)this.endBizDate.getSqlDate()));
        }
        if ((fpSet = this.getIdSetFromF7(this.prmtFinProduct)) != null && fpSet.size() > 0) {
            filterParam.setFinProductSet(fpSet);
        }
        filterParam.setViewZero(this.chkIsViewZero.isSelected());
        return filterParam;
    }

    public void setParam(Object param) {
        if (param == null) {
            return;
        }
        LoanFetchFilterParam filterParam = (LoanFetchFilterParam)((Object)param);
        this.setCompanyIdSet(filterParam.getCompanyIdSet());
        try {
            if (filterParam.getCurrencyId() != null) {
                CurrencyInfo cur = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(filterParam.getCurrencyId()));
                FMClientHelper.setSelectObject((KDComboBox)this.kDComboBoxCurrency, (Object)cur);
            } else {
                FMClientHelper.setSelectObject((KDComboBox)this.kDComboBoxCurrency, (Object)FMSysDefinedEnum.SELECT_ALL);
            }
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        if (filterParam.getStatus() != null) {
            FMClientHelper.setSelectObject((KDComboBox)this.status, (Object)((Object)filterParam.getStatus()));
        } else {
            FMClientHelper.setSelectObject((KDComboBox)this.status, (Object)FMSysDefinedEnum.SELECT_ALL);
        }
        this.startBizDate.setValue((Object)filterParam.getStartBizDate());
        this.endBizDate.setValue((Object)filterParam.getEndBizDate());
        try {
            this.prmtFinProduct.setData((Object)this.getBaseInfoFromIdSet(filterParam.getFinProductSet()));
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        this.chkIsViewZero.setSelected(filterParam.isViewZero());
    }

    protected void init() throws Exception {
        super.init();
        CurrencyUtil.fillCombCurrency((KDComboBox)this.kDComboBoxCurrency);
        this.kDComboBoxCurrency.addItem((Object)FMSysDefinedEnum.SELECT_ALL);
        FMClientHelper.setSelectObject((KDComboBox)this.kDComboBoxCurrency, (Object)FMSysDefinedEnum.SELECT_ALL);
        this.status.addItem((Object)FsBillStatusEnum.SAVE);
        this.status.addItem((Object)FsBillStatusEnum.SUBMIT);
        this.status.addItem((Object)FsBillStatusEnum.AUDIT);
        this.status.addItem((Object)FMSysDefinedEnum.SELECT_ALL);
        FMClientHelper.setSelectObject((KDComboBox)this.status, (Object)FMSysDefinedEnum.SELECT_ALL);
        FinUtils.setFinProductF7((KDBizPromptBox)this.prmtFinProduct, (FinancingBillTypeEnum)FinancingBillTypeEnum.Loan);
        this.prmtFinProduct.addSelectorListener(new SelectorListener(){
            F7FinancingProductsTreeUI prmtParent_F7ListUI = null;

            public void willShow(SelectorEvent e) {
                if (this.prmtParent_F7ListUI == null) {
                    try {
                        this.prmtParent_F7ListUI = new F7FinancingProductsTreeUI();
                        FilterInfo filter = new FilterInfo();
                        filter.getFilterItems().add(new FilterItemInfo("BillType", (Object)new Integer(1), CompareType.EQUALS));
                        this.prmtParent_F7ListUI.setFilterInfo(filter);
                        HashMap<String, Window> ctx = new HashMap<String, Window>();
                        ctx.put("bizUIOwner", SwingUtilities.getWindowAncestor((Component)this.prmtParent_F7ListUI));
                        this.prmtParent_F7ListUI.setF7Use(true, ctx);
                        LoanFetchFilterUI.this.prmtFinProduct.setSelector((KDPromptSelector)this.prmtParent_F7ListUI);
                    }
                    catch (Exception e1) {
                        LoanFetchFilterUI.this.handUIException(e1);
                    }
                }
            }
        });
        Calendar cal = Calendar.getInstance();
        cal.set(1, 2000);
        cal.set(2, 0);
        cal.set(5, 1);
        this.startBizDate.setValue((Object)cal.getTime());
        this.endBizDate.setValue((Object)DateUtil.getDayEnd());
        this.chkIsViewZero.setSelected(false);
    }

    protected void setDefaultValue() {
        super.setDefaultValue();
        this.prmtFinProduct.setData(null);
        this.chkIsViewZero.setSelected(false);
    }

    public boolean verify() {
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.startBizDate);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.endBizDate);
        if (DateTimeUtils.truncateDate((Date)((Date)this.startBizDate.getValue())).after(DateTimeUtils.truncateDate((Date)((Date)this.endBizDate.getValue())))) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.sl.FmslResource", (String)"25_EndDateMustAfterBeginDate"));
            SysUtil.abort();
        }
        return super.verify();
    }

    public void clear() {
        super.clear();
        try {
            FMClientHelper.setSelectObject((KDComboBox)this.kDComboBoxCurrency, (Object)FMSysDefinedEnum.SELECT_ALL);
            FMClientHelper.setSelectObject((KDComboBox)this.status, (Object)FMSysDefinedEnum.SELECT_ALL);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        Calendar cal = Calendar.getInstance();
        cal.set(1, 2000);
        cal.set(2, 0);
        cal.set(5, 1);
        this.startBizDate.setValue((Object)cal.getTime());
        this.endBizDate.setValue((Object)DateUtil.getDayEnd());
        this.prmtFinProduct.setData(null);
        this.chkIsViewZero.setSelected(false);
    }

    protected Class getParamClass() {
        return LoanFetchFilterParam.class;
    }
}

