/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.sl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.fs.client.CurrencyUtil;
import com.kingdee.eas.fm.sl.LoanContractInfo;
import com.kingdee.eas.fm.sl.LoanContractInterestFactory;
import com.kingdee.eas.fm.sl.client.AbstractPreInterestLoanContractUI;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class PreInterestLoanContractUI
extends AbstractPreInterestLoanContractUI {
    private static final Logger logger = CoreUIObject.getLogger(PreInterestLoanContractUI.class);
    private static final String RESOURCE = "com.kingdee.eas.fm.fin.client.FinClientResource";
    private CompanyOrgUnitInfo CURRENT_COMPANY = null;
    Map hm = new HashMap();
    private Set createdIntReceivedID;

    public void onLoad() throws Exception {
        this.CURRENT_COMPANY = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        super.onLoad();
        this.init();
    }

    private void init() throws Exception {
        this.chkStartDate.setSelected(false);
        this.pkStartDate.setSupportedEmpty(false);
        this.pkStartDate.setValue(null);
        this.pkStartDate.setEnabled(false);
        this.pkEndDate.setSupportedEmpty(false);
        this.prmtLoanContractNum.setValue(null);
        CurrencyUtil.fillCombCurrency((KDComboBox)this.prmtCurrency);
        this.prmtCurrency.addItem((Object)FMSysDefinedEnum.SELECT_ALL);
        FMClientHelper.setSelectObject((KDComboBox)this.prmtCurrency, (Object)FMSysDefinedEnum.SELECT_ALL);
        this.pkEndDate_dataChanged(null);
    }

    @Override
    protected void pkEndDate_dataChanged(DataChangeEvent e) throws Exception {
        this.prmtPayIntMode.setData(null);
        Date tmp = DateTimeUtils.truncateDate((Date)this.pkEndDate.getSqlDate());
        Calendar c = Calendar.getInstance();
        c.setTime(tmp);
        int month = c.get(2);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (month == 2 || month == 5 || month == 8) {
            HashSet<Integer> integerSet = new HashSet<Integer>();
            integerSet.add(new Integer(1));
            integerSet.add(new Integer(3));
            filter.getFilterItems().add(new FilterItemInfo("cycleType", integerSet, CompareType.INCLUDE));
            evi.setFilter(filter);
            this.prmtPayIntMode.setEntityViewInfo(evi);
        } else if (month == 11) {
            this.prmtPayIntMode.setEntityViewInfo(null);
        } else {
            filter.getFilterItems().add(new FilterItemInfo("cycleType", (Object)new Integer(1)));
            evi.setFilter(filter);
            this.prmtPayIntMode.setEntityViewInfo(evi);
        }
    }

    private void verify() {
        if (this.chkStartDate.isSelected()) {
            FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.pkStartDate);
            if (this.pkStartDate.getSqlDate().after(this.pkEndDate.getSqlDate())) {
                MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"LoanEndDateLaterThanBeginDate"));
                SysUtil.abort();
            }
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        FMClientVerifyHelper.verifyUIControlEmpty((CoreUI)this);
        this.verify();
        this.createdIntReceivedID = new HashSet();
        this.createdIntReceivedID.clear();
        LoanContractInfo info = (LoanContractInfo)this.prmtLoanContractNum.getValue();
        if (info == null) {
            MsgBox.showWarning((Component)((Object)this), (String)"\u9009\u62e9\u5408\u540c\u624d\u80fd\u8fdb\u884c\u9884\u63d0");
        }
        this.hm = LoanContractInterestFactory.getRemoteInstance().preInt(this.pkStartDate.getSqlDate(), this.pkEndDate.getSqlDate(), info);
        this.createdIntReceivedID = (Set)this.hm.get("createdID");
        if (this.createdIntReceivedID.size() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"\u672a\u751f\u6210\u9884\u63d0\u7684\u5229\u606f\u5355"));
            SysUtil.abort();
        } else {
            this.disposeUIWindow();
        }
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.createdIntReceivedID = null;
        this.disposeUIWindow();
    }

    private Map getReturnValueWithMsg() {
        return this.hm;
    }

    public static Map showPreInterestLoanContractUI(CoreUI ui) {
        Map returnValue = new HashMap();
        try {
            UIContext uiContext = new UIContext((Object)ui);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(PreInterestLoanContractUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
            uiWindow.show();
            returnValue = ((PreInterestLoanContractUI)uiWindow.getUIObject()).getReturnValueWithMsg();
        }
        catch (BOSException e) {
            SysUtil.abort();
        }
        return returnValue;
    }

    @Override
    protected void prmtLoanContractNum_willShow(SelectorEvent e) throws Exception {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        this.setFilterItems(filter);
        evi.setFilter(filter);
        this.prmtLoanContractNum.setEntityViewInfo(evi);
        this.prmtLoanContractNum.getQueryAgent().resetRuntimeEntityView();
    }

    private void setFilterItems(FilterInfo filter) {
        Set payIntModeIdSet;
        String companyId = this.CURRENT_COMPANY.getId().toString();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
        filter.getFilterItems().add(new FilterItemInfo("totalBalance", (Object)Constants.ZERO, CompareType.GREATER));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(2), CompareType.EQUALS));
        Object currencyObj = this.prmtCurrency.getSelectedItem();
        if (currencyObj != null && currencyObj instanceof CurrencyInfo) {
            CurrencyInfo currency = (CurrencyInfo)currencyObj;
            filter.getFilterItems().add(new FilterItemInfo("Currency.id", (Object)currency.getId().toString(), CompareType.EQUALS));
        }
        if ((payIntModeIdSet = AccessHelper.getIds((Object[])AccessHelper.getF7Ids((KDBizPromptBox)this.prmtPayIntMode))) != null && payIntModeIdSet.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("payIntMode.id", (Object)payIntModeIdSet, CompareType.INCLUDE));
        }
    }

    @Override
    protected void chkStartDate_actionPerformed(ActionEvent e) throws Exception {
        if (this.chkStartDate.isSelected()) {
            this.pkStartDate.setVisible(true);
            this.pkStartDate.setEditable(true);
            this.pkStartDate.setEnabled(true);
            this.pkStartDate.setRequired(true);
            this.pkStartDate.setSupportedEmpty(false);
            this.pkStartDate.setValue((Object)new Date());
            this.pkEndDate.setSupportedEmpty(false);
            this.pkEndDate.setValue((Object)new Date());
        } else {
            this.pkStartDate.setEnabled(false);
            this.pkStartDate.setRequired(false);
            this.pkStartDate.setValue(null);
            this.pkEndDate.setSupportedEmpty(false);
        }
    }

    @Override
    protected void prmtCurrency_itemStateChanged(ItemEvent e) throws Exception {
        this.prmtLoanContractNum.setValue(null);
    }
}

