/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.sl.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.FMBillBaseInfo;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.fin.util.FinHorizon;
import com.kingdee.eas.fm.im.IntRateTypeInfo;
import com.kingdee.eas.fm.sl.LoanContractAdjustInfo;
import com.kingdee.eas.fm.sl.LoanContractInterestInfo;
import com.kingdee.eas.fm.sl.LoanFetchFactory;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Color;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JTextField;

public class SLUtils {
    private static final String SLRESOURCE = "com.kingdee.eas.fm.sl.FmslResource";
    public static final Date BizDate = new Date();
    public static final BigDecimal maxValue = new BigDecimal("9999999999999");
    public static final BigDecimal minValue = Constants.ZERO;

    public static Date addManyMonthDay(Date startDate, int month) {
        if (FMHelper.isEmpty((Object)startDate)) {
            return null;
        }
        if (month == 0) {
            return startDate;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(startDate);
        calendar.set(2, calendar.get(2) + month);
        return DateTimeUtils.truncateDate((Date)calendar.getTime());
    }

    public static BigDecimal getHorizon(Date dpBegin, Date dpEnd) {
        if (dpBegin == null || dpEnd == null) {
            return Constants.ZERO;
        }
        if (dpBegin.after(dpEnd)) {
            return Constants.ZERO;
        }
        Date beginDate = DateTimeUtils.truncateDate((Date)dpBegin);
        Date endDate = DateTimeUtils.truncateDate((Date)dpEnd);
        return FinHorizon.getHorizon((Date)beginDate, (Date)endDate);
    }

    public static CurrencyInfo getCurrentCurrency(CompanyOrgUnitInfo currentCompany) throws BOSException, EASBizException {
        ICompanyOrgUnit corgUnit = CompanyOrgUnitFactory.getRemoteInstance();
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("baseCurrency.*");
        CompanyOrgUnitInfo info = corgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(currentCompany.getId()), selectors);
        CurrencyInfo currcurr = info.getBaseCurrency();
        return currcurr;
    }

    public static void setLocalCurExRate(CompanyOrgUnitInfo currentCompany, String srcCurrId, String destCurrId, Date date, KDFormattedTextField txtLocalCurExRate, KDFormattedTextField txtAmountLocalCur) throws Exception {
        if (FMHelper.isEmpty((CoreBaseInfo)currentCompany)) {
            return;
        }
        txtLocalCurExRate.setPrecision(FMClientHelper.getPrecOfExRate((String)currentCompany.getId().toString(), (String)srcCurrId, null, (Date)date));
        if (txtAmountLocalCur != null) {
            txtAmountLocalCur.setPrecision(SLUtils.getCurrentCurrency(currentCompany).getPrecision());
        }
    }

    public static Map entryColumnNotRepeatClearColumn(KDTable kdtable, String key, String showMessage, String[] needClearColumn) {
        HashMap<String, Object> existsMap = new HashMap<String, Object>();
        for (int i = 0; i < kdtable.getRowCount(); ++i) {
            IRow row = kdtable.getRow(i);
            Object value = row.getCell(key).getValue();
            if (FMHelper.isEmpty((Object)value)) continue;
            if (existsMap.containsValue(value = value.toString().trim()) && !FMHelper.isEmpty((String)showMessage)) {
                MsgBox.showWarning((String)showMessage);
                row.getCell(key).setValue(null);
                if (needClearColumn != null && needClearColumn.length > 0) {
                    for (int j = 0; j < needClearColumn.length; ++j) {
                        row.getCell(needClearColumn[j]).setValue(null);
                    }
                }
                SysUtil.abort();
            }
            existsMap.put("key" + i, value);
        }
        return existsMap;
    }

    public static Map entryColumnNotRepeat(KDTable kdtable, String key, String showMessage) {
        return SLUtils.entryColumnNotRepeatClearColumn(kdtable, key, showMessage, null);
    }

    public static String operateMapData(Map transferMap) {
        if (FMHelper.isEmpty((Object)transferMap) || transferMap.size() == 0) {
            return null;
        }
        StringBuffer sbuffer = new StringBuffer();
        Collection col = transferMap.values();
        Iterator it = col.iterator();
        while (it.hasNext()) {
            sbuffer.append("'").append(it.next()).append("',");
        }
        return sbuffer.toString();
    }

    public static String subString(String transferStr, String subValue) {
        String tempString = null;
        if (!FMHelper.isEmpty((String)transferStr) && transferStr.length() > 0) {
            tempString = transferStr.lastIndexOf(subValue) != -1 ? transferStr.substring(0, transferStr.length() - 1) : transferStr;
        }
        return tempString;
    }

    public static Date getSpecifyDate(Date transferDate, int year) {
        if (FMHelper.isEmpty((Object)transferDate)) {
            return DateTimeUtils.truncateDate((Date)new Date());
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(transferDate);
        cal.set(1, cal.get(1) + year);
        cal.set(2, 0);
        cal.set(5, 1);
        return DateTimeUtils.truncateDate((Date)cal.getTime());
    }

    public static boolean isXUEXILILV(IntRateTypeInfo intRateType) {
        if (intRateType == null) {
            return false;
        }
        return intRateType.getId().toString().equals("lJlpCQEQEADgAAc+wKgSjiR9knQ=");
    }

    public static SelectorItemCollection getLoanBankSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("LenderProperty.id"));
        sic.add(new SelectorItemInfo("LenderProperty.name"));
        sic.add(new SelectorItemInfo("Bank.id"));
        sic.add(new SelectorItemInfo("Bank.name"));
        sic.add(new SelectorItemInfo("AccountBank.id"));
        sic.add(new SelectorItemInfo("AccountBank.name"));
        sic.add(new SelectorItemInfo("promiseProportion"));
        sic.add(new SelectorItemInfo("promiseLoanAmount"));
        sic.add(new SelectorItemInfo("loanBalance"));
        sic.add(new SelectorItemInfo("remark"));
        sic.add(new SelectorItemInfo("CreditLimit.id"));
        sic.add(new SelectorItemInfo("CreditLimit.name"));
        sic.add(new SelectorItemInfo("CreditCurrency.name"));
        sic.add(new SelectorItemInfo("CreditCurrency.id"));
        sic.add(new SelectorItemInfo("CreditCurExRate"));
        sic.add(new SelectorItemInfo("CreditAmount"));
        return sic;
    }

    public static boolean checkBizUnit() {
        boolean isBizUnit = false;
        isBizUnit = GlUtils.isCompanyUnion((CompanyOrgUnitInfo)ContextHelperFactory.getRemoteInstance().getCurrentCompany());
        return isBizUnit;
    }

    public static boolean existsDownstreamItem(String tableName, String[] sqlParms, Object[] params) throws BOSException, EASBizException {
        boolean flag = false;
        if (sqlParms == null || params == null || sqlParms.length == 0 || params.length == 0) {
            flag = false;
        }
        if (sqlParms.length != params.length) {
            flag = false;
        }
        String sql = "select * from " + tableName + " where ";
        for (int i = 0; i < sqlParms.length; ++i) {
            sql = sql + sqlParms[i] + " = '" + params[i] + "' ";
            if (sqlParms.length <= 1 || i == sqlParms.length - 1) continue;
            sql = sql + " and ";
        }
        flag = LoanFetchFactory.getRemoteInstance().existsDownStream(sql);
        return flag;
    }

    public static void setEntryExchangeRate(KDTable table, String currecnyKey, String key, CurrencyInfo currCurrencyInfo, boolean isCreateFrom, boolean isNeedChange, KDDatePicker pkBizDate, CompanyOrgUnitInfo company, boolean needCountAmount, String loanAmountKey, String creditAmountKey, boolean precsionByEntryCurrency) {
        Date bizDate = FMHelper.isEmpty((Object)pkBizDate.getValue()) ? BizDate : (Date)pkBizDate.getValue();
        for (int j = 0; j < table.getRowCount(); ++j) {
            IRow row = table.getRow(j);
            Object currencyValue = row.getCell(currecnyKey).getValue();
            CurrencyInfo entryCurrencyInfo = null;
            if (currencyValue == null || !(currencyValue instanceof CurrencyInfo)) {
                row.getCell(key).getStyleAttributes().setLocked(true);
                if (!needCountAmount) continue;
                row.getCell(creditAmountKey).getStyleAttributes().setLocked(true);
                continue;
            }
            entryCurrencyInfo = (CurrencyInfo)currencyValue;
            if (entryCurrencyInfo != null && currCurrencyInfo.equals((Object)entryCurrencyInfo)) {
                row.getCell(key).setValue((Object)Constants.ONE);
                row.getCell(key).getStyleAttributes().setLocked(true);
            } else {
                row.getCell(key).getStyleAttributes().setBackground(Color.WHITE);
                try {
                    if (isCreateFrom || isNeedChange) {
                        SLUtils.setExchangeRateRelAss(row.getCell(key), company, currCurrencyInfo, entryCurrencyInfo, bizDate);
                    } else {
                        row.getCell(key).getStyleAttributes().setLocked(false);
                    }
                }
                catch (Exception e) {
                    row.getCell(key).setValue((Object)Constants.ONE);
                }
            }
            if (FMHelper.isEmpty((Object)row.getCell(key).getValue()) && isCreateFrom) {
                row.getCell(key).setValue((Object)Constants.ONE);
            }
            if (currCurrencyInfo != null && entryCurrencyInfo != null) {
                try {
                    int precesion = FMClientHelper.getPrecOfExRate((String)company.getId().toString(), (String)currCurrencyInfo.getId().toString(), (String)entryCurrencyInfo.getId().toString(), (Date)bizDate);
                    row.getCell(key).getStyleAttributes().setNumberFormat(FMClientHelper.getKDTNumFormat((int)precesion));
                }
                catch (Exception precesion) {
                    // empty catch block
                }
            }
            if (!needCountAmount) continue;
            BigDecimal promiseBalance = row.getCell(loanAmountKey).getValue() == null ? Constants.ZERO : row.getCell(loanAmountKey).getValue();
            BigDecimal creditCurExRate = row.getCell(key).getValue() == null ? Constants.ONE : row.getCell(key).getValue();
            BigDecimal creditAmount = promiseBalance.multiply(creditCurExRate);
            if (isCreateFrom || isNeedChange) {
                row.getCell(creditAmountKey).setValue((Object)creditAmount);
            }
            if (entryCurrencyInfo == null || !precsionByEntryCurrency) continue;
            row.getCell(creditAmountKey).getStyleAttributes().setNumberFormat(FMClientHelper.getKDTNumFormat((int)entryCurrencyInfo.getPrecision()));
        }
    }

    protected static void setExchangeRateRelAss(ICell cell, CompanyOrgUnitInfo company, CurrencyInfo currInfo, CurrencyInfo destCurr, Date bizDate) throws Exception {
        FinUtils.initExchangeRateRelAss(null, (ICell)cell, (CompanyOrgUnitInfo)company, (CurrencyInfo)currInfo, (CurrencyInfo)destCurr, (Date)bizDate);
    }

    public static int getPrecOfExRate(CurrencyInfo srcCurr, CurrencyInfo destCurr) {
        try {
            int precOfExRate = FMClientHelper.getPrecOfExRate(null, (String)srcCurr.getId().toString(), (String)destCurr.getId().toString(), null);
            return precOfExRate;
        }
        catch (EASBizException e) {
            return 5;
        }
        catch (BOSException e) {
            return 5;
        }
    }

    public void setPrecesionByCurrency(CurrencyInfo info, KDFormattedTextField[] inputArray) {
        if (info == null) {
            return;
        }
        int precesion = info.getPrecision();
        if (!FMHelper.isEmpty((Object[])inputArray) && inputArray.length > 0) {
            int arraySize = inputArray.length;
            for (int i = 0; i < arraySize; ++i) {
                inputArray[i].setPrecision(precesion);
            }
        }
    }

    public static void resetKDTableColumnsPrecesion(KDTable table, String[] columns, int precision) {
        String format = FMClientHelper.getKDTNumFormat((int)precision);
        int n = columns.length;
        for (int i = 0; i < n; ++i) {
            IColumn col = table.getColumn(columns[i]);
            col.getStyleAttributes().setNumberFormat(format);
            col.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }
    }

    public static void resetTextFieldStyle(KDTable table, CurrencyInfo currency, KDFormattedTextField field, String key, BigDecimal minVal, BigDecimal maxVal) {
        if (field == null) {
            return;
        }
        field.setDataType(1);
        field.setHorizontalAlignment(4);
        field.setRemoveingZeroInDispaly(false);
        field.setMinimumValue((Comparable)minVal);
        field.setMaximumValue((Comparable)maxVal);
        if (currency != null) {
            int pre = currency.getPrecision();
            field.setPrecision(pre);
        } else {
            field.setPrecision(5);
        }
        table.getColumn(key).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)field));
    }

    public static void resetTextFieldStyle(KDTable table, CurrencyInfo currency, int prec, KDFormattedTextField field, String key, BigDecimal minVal, BigDecimal maxVal) {
        if (field == null) {
            return;
        }
        field.setDataType(1);
        field.setHorizontalAlignment(4);
        field.setRemoveingZeroInDispaly(false);
        field.setMinimumValue((Comparable)minVal);
        field.setMaximumValue((Comparable)maxVal);
        if (currency != null) {
            int pre = currency.getPrecision();
            field.setPrecision(pre);
        } else {
            field.setPrecision(prec);
        }
        table.getColumn(key).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)field));
    }

    public static void resetTextFieldStyle(KDTable table, KDFormattedTextField field, String key) {
        if (field == null) {
            return;
        }
        field.setDataType(0);
        field.setHorizontalAlignment(4);
        field.setRemoveingZeroInDispaly(false);
        table.getColumn(key).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)field));
    }

    public static void resetKdtableStatus(KDTable table, String[] columns, boolean isLocked) {
        if (table == null || columns == null) {
            return;
        }
        for (int i = 0; i < table.getRowCount(); ++i) {
            IRow row = table.getRow(i);
            for (int j = 0; j < columns.length; ++j) {
                row.getCell(columns[j]).getStyleAttributes().setLocked(isLocked);
            }
        }
    }

    public static BigDecimal getKdtableColumnValue(IRow row, String key) {
        if (row == null || key == null) {
            return Constants.ZERO;
        }
        if (row.getCell(key) == null) {
            return Constants.ZERO;
        }
        BigDecimal value = row.getCell(key).getValue() == null ? Constants.ZERO : (BigDecimal)row.getCell(key).getValue();
        return value;
    }

    public static BigDecimal getBigDecimalValue(BigDecimal amount) {
        if (amount == null) {
            amount = Constants.ZERO;
        }
        return amount;
    }

    public static BigDecimal getBigDecimalValue(Object amount) {
        BigDecimal tempAmount = Constants.ZERO;
        if (amount == null) {
            tempAmount = Constants.ZERO;
        }
        if (amount instanceof BigDecimal) {
            tempAmount = (BigDecimal)amount;
        }
        return tempAmount;
    }

    public static boolean existsDestBillSet(String billId) throws Exception {
        if (billId == null) {
            return false;
        }
        return FMHelper.getDestBillIdSet(null, (String)billId).size() > 0;
    }

    public static void setNumberKdtextFieldStyle(KDFormattedTextField field) {
        if (field == null) {
            field = new KDFormattedTextField();
        }
        field.setRemoveingZeroInDispaly(false);
        field.setDataType(0);
        field.setHorizontalAlignment(4);
    }

    public static void setBigDecimalKdtextFieldStyle(KDFormattedTextField field, BigDecimal maxValue, BigDecimal minValue, int prec) {
        if (field == null) {
            field = new KDFormattedTextField();
        }
        field.setRemoveingZeroInDispaly(false);
        field.setDataType(1);
        field.setHorizontalAlignment(4);
        field.setPrecision(prec);
        field.setMaximumValue((Comparable)maxValue);
        field.setMinimumValue((Comparable)minValue);
    }

    public static boolean checkCodingRule(FMBillBaseInfo billInfo) throws Exception {
        ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
        CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        boolean exist = false;
        if (billInfo instanceof LoanContractAdjustInfo) {
            exist = codingRuleManager.isExist((IObjectValue)new LoanContractAdjustInfo(), currentCompany.getId().toString());
        }
        if (billInfo instanceof LoanContractInterestInfo) {
            exist = codingRuleManager.isExist((IObjectValue)new LoanContractInterestInfo(), currentCompany.getId().toString());
        }
        return exist;
    }

    public static boolean compareAmount(BigDecimal compare1, BigDecimal compare2, boolean isForward) {
        if (compare1 == null) {
            compare1 = Constants.ZERO;
        }
        if (compare2 == null) {
            compare2 = Constants.ZERO;
        }
        if (compare1.compareTo(compare2) > 0 && isForward) {
            return false;
        }
        return compare1.compareTo(compare2) >= 0 || isForward;
    }

    public static void main(String[] args) {
        SLUtils.operateMapData(new HashMap());
    }
}

