/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.benefit.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.hr.benefit.client.AbstractAccountBatchFilterUI;
import com.kingdee.eas.hr.benefit.util.BenefitVerifyUtils;
import com.kingdee.eas.hr.org.client.AdminByOrgRangePromptBox;
import com.kingdee.eas.hr.perf.client.FilterUIUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class AccountBatchFilterUI
extends AbstractAccountBatchFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(AccountBatchFilterUI.class);

    public AccountBatchFilterUI() throws Exception {
        AdminByOrgRangePromptBox f7 = new AdminByOrgRangePromptBox();
        f7.showChkSealUp(false);
        f7.setIsSingleSelect(false);
        HashSet<String> hro = new HashSet<String>();
        hro.add(SysContext.getSysContext().getCurrentHRUnit().getId().toString());
        f7.setHROFilter(hro);
        this.adminBox.setSelector((KDPromptSelector)f7);
        this.adminBox.setDisplayFormat("$name$");
        this.adminBox.setEditFormat("$number$");
        this.adminBox.setCommitFormat("$number$");
        this.adminBox.setEnabledMultiSelection(true);
        this.adminBox.setEditable(false);
    }

    public CustomerParams getCustomerParams() {
        CustomerParams params = new CustomerParams();
        FilterUIUtil.saveData((CustomerParams)params, (Component)this.adminBox);
        return params;
    }

    public void setCustomerParams(CustomerParams cp) {
        try {
            this.clear();
            if (cp == null) {
                return;
            }
            FilterUIUtil.retriveData((CustomerParams)cp, (Component)this.adminBox);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    public void clear() {
        super.clear();
        this.adminBox.setData(null);
    }

    public boolean verify() {
        if (!BenefitVerifyUtils.adminOrgNotNullVerify(this.adminBox)) {
            return false;
        }
        return super.verify();
    }

    public Set getPersonSetByAdmin() throws BOSException, EASBizException {
        Object[] obj;
        HashSet<String> set = new HashSet<String>();
        Object object = this.adminBox.getData();
        if (object instanceof DataBaseInfo) {
            obj = this.adminBox.getData();
            set.add(((AdminOrgUnitInfo)obj).getId().toString());
        }
        if (object instanceof Object[]) {
            obj = (Object[])this.adminBox.getData();
            int length = obj.length;
            for (int i = 0; i < length; ++i) {
                set.add(((AdminOrgUnitInfo)obj[i]).getId().toString());
            }
        }
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.benefit.app", "AccountPersonQuery");
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        IQueryExecutor iQe = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        filterInfo.getFilterItems().add(new FilterItemInfo("admin.id", set, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("adminToUnit.id", (Object)SysContext.getSysContext().getCurrentHRUnit().getId().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("adminUser.id", (Object)SysContext.getSysContext().getCurrentUserInfo().getId().toString()));
        viewInfo.setFilter(filterInfo);
        iQe.setObjectView(viewInfo);
        IRowSet rowSet = iQe.executeQuery();
        HashSet<String> personIDSet = new HashSet<String>();
        try {
            while (rowSet.next()) {
                personIDSet.add(rowSet.getString("id"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return personIDSet;
    }
}

