/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.benefit.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.TextRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFrame;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.client.GetDataDialog;
import com.kingdee.eas.base.core.client.GetDataTaskAdapter;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.client.util.PermissionHelper;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.IIDList;
import com.kingdee.eas.framework.client.RealModeIDList;
import com.kingdee.eas.hr.benefit.AccountCollection;
import com.kingdee.eas.hr.benefit.AccountDetailCollection;
import com.kingdee.eas.hr.benefit.AccountDetailFactory;
import com.kingdee.eas.hr.benefit.AccountDetailInfo;
import com.kingdee.eas.hr.benefit.AccountFactory;
import com.kingdee.eas.hr.benefit.AccountInfo;
import com.kingdee.eas.hr.benefit.AccountTypeCollection;
import com.kingdee.eas.hr.benefit.AccountTypeFactory;
import com.kingdee.eas.hr.benefit.AccountTypeInfo;
import com.kingdee.eas.hr.benefit.BenefitCommonFacadeFactory;
import com.kingdee.eas.hr.benefit.BenefitException;
import com.kingdee.eas.hr.benefit.BenefitRuleCollection;
import com.kingdee.eas.hr.benefit.BenefitRuleInfo;
import com.kingdee.eas.hr.benefit.EmpAccountManagerException;
import com.kingdee.eas.hr.benefit.EmpManagerFacadeFactory;
import com.kingdee.eas.hr.benefit.IAccount;
import com.kingdee.eas.hr.benefit.IAccountDetail;
import com.kingdee.eas.hr.benefit.IBenefitCommonFacade;
import com.kingdee.eas.hr.benefit.IEmpManagerFacade;
import com.kingdee.eas.hr.benefit.PayTypeEnum;
import com.kingdee.eas.hr.benefit.client.AbstractAccountBatchManagerListUI;
import com.kingdee.eas.hr.benefit.client.BeneChooseUI;
import com.kingdee.eas.hr.benefit.util.BenefitUtils;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.hr.emp.client.EmployeeMultiF7PromptBox;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.client.DatataskCaller;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class AccountBatchManagerListUI
extends AbstractAccountBatchManagerListUI {
    private static final long serialVersionUID = 1L;
    private static final String AD_ID = "ad.id";
    private static final String ADID = "adID";
    private static final String ACC_ID = "acc.id";
    private static final String ACCID = "accID";
    private static final String ACCOUNTS = "accounts";
    private static final String ADPAY = "adPay";
    private static final String ACCOUNTNUMBER = "accountNumber";
    private static final String ADMINNAME = "adminOrg.name";
    private static final String NAME = "name";
    private static final String NUM = "number";
    private static final String INSERVICE = "et.inService";
    private static final String ID = "id";
    protected static final TextRender render = new TextRender();
    private static String formatStrDate = "yyyy-MM-dd";
    private static final String APAYSTATE = "payState";
    private static final String ASTOPDATE = "stopDate";
    private static final String ACREATETIME = "createTime";
    private static final String ANAME = "accountType.name";
    private static final String BRNAME = "benefitRule.name";
    private static final String REDATE = "retireTransactDate";
    private static final String RENUM = "retireNumber";
    private static final String FUND = "fundItem";
    private static final String TDATE = "transactDate";
    private static final String CURPERIOD = "curPeriod";
    private static final String LIST = "list";
    private HashMap brMap = new HashMap();
    Set perIdSet = new HashSet();
    private boolean dataChange = false;
    private boolean saveWarn = false;

    public void onLoad() throws Exception {
        this.checkLicense();
        this.handlePermissionForItemAction((ItemAction)this.actionOnLoad);
        if (!BenefitUtils.hasInitPeriod()) {
            throw new BenefitException(BenefitException.NO_BENEFIT_PERIOD);
        }
        this.showQueryF7();
        this.initEditorForTblMain();
        this.initWorkButton();
        this.tblMain.getStyleAttributes().setLocked(true);
        this.setWorkButtonEnabled(false);
        this.setOprtState(LIST);
        this.saveOldBenefitRule();
        this.setAccountTypeLocked();
        if (this.tblMain.getRowCount() != -1 && this.tblMain.getRowCount() <= 0) {
            this.setStateButton(false);
        }
        KDTSortManager sortManager = new KDTSortManager(this.tblMain);
        int size = this.tblMain.getColumnCount();
        for (int i = 0; i < size; ++i) {
            this.tblMain.getColumn(i).setSortable(true);
        }
        sortManager.setSortAuto(true);
        this.tblMain.getInputMap().remove(KeyStroke.getKeyStroke("ctrl pressed V"));
        this.tblMain.getActionMap().remove("Paste");
        this.initStateCombo();
    }

    private void saveOldBenefitRule() {
        int size = this.tblMain.getRowCount3();
        for (int i = 0; i < size; ++i) {
            IRow row = this.tblMain.getRow(i);
            if (row.getCell(BRNAME).getValue() == null) continue;
            this.brMap.put(i, (BenefitRuleInfo)row.getCell(BRNAME).getValue());
        }
    }

    private void setStateButton(boolean b) {
        this.btnSeal.setEnabled(b);
        this.menuItemSeal.setEnabled(b);
        this.btnStop.setEnabled(b);
        this.menuItemStop.setEnabled(b);
        this.btnNormal.setEnabled(b);
        this.menuItemNormal.setEnabled(b);
    }

    private void setWorkButtonEnabled(boolean b) {
        this.btnAddRow.setEnabled(b);
        this.btnInsertRow.setEnabled(b);
        this.btnCopyRow.setEnabled(b);
        this.btnSave.setEnabled(b);
        this.menuItemSave.setEnabled(b);
        this.btnCopy.setEnabled(b);
        this.menuItemCopy.setEnabled(b);
    }

    protected void initPayStateBtlEnable(int payState) {
        if (payState == 10) {
            this.btnStop.setEnabled(true);
            this.menuItemStop.setEnabled(true);
            this.btnSeal.setEnabled(false);
            this.menuItemSeal.setEnabled(false);
            this.btnNormal.setEnabled(false);
            this.menuItemNormal.setEnabled(false);
        }
        if (payState == 20) {
            this.btnStop.setEnabled(false);
            this.menuItemStop.setEnabled(false);
            this.btnSeal.setEnabled(true);
            this.menuItemSeal.setEnabled(true);
            this.btnNormal.setEnabled(true);
            this.menuItemNormal.setEnabled(true);
        }
        if (payState == 30) {
            this.btnStop.setEnabled(false);
            this.menuItemStop.setEnabled(false);
            this.btnSeal.setEnabled(false);
            this.menuItemSeal.setEnabled(false);
            this.btnNormal.setEnabled(true);
            this.menuItemNormal.setEnabled(true);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAddRow.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnInsertRow.setIcon(EASResource.getIcon((String)"imgTbtn_insert"));
        this.btnCopyRow.setIcon(EASResource.getIcon((String)"imgTbtn_copyline"));
        this.btnDelRow.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnNormal.setIcon(EASResource.getIcon((String)"imgTbtn_execute"));
        this.btnStop.setIcon(EASResource.getIcon((String)"imgTbtn_forbid"));
        this.btnSeal.setIcon(EASResource.getIcon((String)"imgTbtn_sealup"));
        this.btnUpate.setIcon(EASResource.getIcon((String)"imgTbtn_emend"));
        this.btnOutput.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
        this.btnimport.setIcon(EASResource.getIcon((String)"imgTbtn_input"));
        this.menuItemNormal.setIcon(EASResource.getIcon((String)"imgTbtn_execute"));
        this.menuItemStop.setIcon(EASResource.getIcon((String)"imgTbtn_forbid"));
        this.menuItemSeal.setIcon(EASResource.getIcon((String)"imgTbtn_sealup"));
        this.menuItemCopy.setIcon(EASResource.getIcon((String)"imgTbtn_electcopy"));
        this.menuItemUpdate.setIcon(EASResource.getIcon((String)"imgTbtn_emend"));
        this.menuItemSave.setEnabled(true);
        this.menuItemSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnSave.setEnabled(true);
        this.btnOutput.setEnabled(true);
        this.btnimport.setEnabled(true);
        this.btnDelRow.setEnabled(false);
        this.menuItemImportData.setVisible(true);
        this.btnOutput.setVisible(false);
        this.actionUpdate.setEnabled(true);
        this.actionCopy.setEnabled(true);
        this.btnCopy.setIcon(EASResource.getIcon((String)"imgTbtn_electcopy"));
        this.menuItemAddNew.setEnabled(false);
        this.menuItemAddNew.setVisible(false);
        this.menuItemRemove.setEnabled(false);
        this.menuItemRemove.setVisible(false);
        this.actionRefresh.setEnabled(false);
        this.actionRefresh.setVisible(false);
        this.setButtonDefaultStyl(this.btnSave);
    }

    private void initEditorForTblMain() throws BOSException, EASBizException {
        this.tblMain.checkParsed();
        this.tblMain.getSelectManager().setSelectMode(15);
        this.tblMain.getColumn(ID).getStyleAttributes().setLocked(true);
        this.tblMain.getColumn(ID).getStyleAttributes().setBackground(BenefitUtils.mColor);
        this.tblMain.getColumn(INSERVICE).getStyleAttributes().setLocked(true);
        this.tblMain.getColumn(INSERVICE).getStyleAttributes().setBackground(BenefitUtils.mColor);
        this.tblMain.getColumn(NUM).getStyleAttributes().setLocked(true);
        this.tblMain.getColumn(NUM).getStyleAttributes().setBackground(BenefitUtils.mColor);
        this.tblMain.getColumn(APAYSTATE).getStyleAttributes().setLocked(true);
        this.tblMain.getColumn(ADMINNAME).getStyleAttributes().setLocked(true);
        this.tblMain.getColumn(ADMINNAME).getStyleAttributes().setBackground(BenefitUtils.mColor);
        this.tblMain.getColumn(NAME).getStyleAttributes().setLocked(true);
        KDBizPromptBox kdBizPromptBoxUnit = new KDBizPromptBox();
        EmployeeMultiF7PromptBox pmF7 = new EmployeeMultiF7PromptBox((IUIObject)this);
        pmF7.showNoPositionPerson(true);
        pmF7.setIsSingleSelect(false);
        pmF7.showOnlySocietyPerson(true);
        HashSet<String> set = new HashSet<String>();
        set.add(SysContext.getSysContext().getCurrentHRUnit().getId().toString());
        pmF7.setHROFilter(set);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("PositionMember.isPrimary", (Object)"1"));
        filter.getFilterItems().add(new FilterItemInfo("Position.id", null, CompareType.EQUALS));
        filter.setMaskString("#0 or #1");
        pmF7.setNopositionPersonFilter(filter);
        kdBizPromptBoxUnit.setSelector((KDPromptSelector)pmF7);
        kdBizPromptBoxUnit.setDisplayFormat("$name$");
        kdBizPromptBoxUnit.setEditFormat("$number$");
        kdBizPromptBoxUnit.setCommitFormat("$name$");
        kdBizPromptBoxUnit.setEditable(false);
        this.tblMain.getColumn(NAME).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)kdBizPromptBoxUnit));
        this.tblMain.getColumn(ANAME).setEditor(BenefitUtils.getComboBoxCellEditor((IObjectCollection)BenefitUtils.getAccountTypeColl(null)));
        this.tblMain.getColumn(ACREATETIME).getStyleAttributes().setNumberFormat(formatStrDate);
        this.tblMain.getColumn(ACREATETIME).setEditor((ICellEditor)new KDTDefaultCellEditor(this.getPickDate()));
        this.tblMain.getColumn(ASTOPDATE).getStyleAttributes().setNumberFormat(formatStrDate);
        this.tblMain.getColumn(ASTOPDATE).setEditor((ICellEditor)new KDTDefaultCellEditor(this.getPickDate()));
        this.tblMain.getColumn(ACCOUNTNUMBER).getStyleAttributes().setLocked(true);
        KDTextField txtFormat1 = null;
        txtFormat1 = new KDTextField();
        txtFormat1.setMaxLength(20);
        this.tblMain.getColumn(ACCOUNTS).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtFormat1));
        this.tblMain.getColumn(REDATE).getStyleAttributes().setNumberFormat(formatStrDate);
        this.tblMain.getColumn(REDATE).setEditor((ICellEditor)new KDTDefaultCellEditor(this.getPickDate()));
        txtFormat1 = new KDTextField();
        txtFormat1.setMaxLength(80);
        this.tblMain.getColumn(RENUM).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtFormat1));
        txtFormat1 = new KDTextField();
        txtFormat1.setMaxLength(300);
        this.tblMain.getColumn(FUND).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtFormat1));
        this.tblMain.getColumn(TDATE).getStyleAttributes().setNumberFormat(formatStrDate);
        this.tblMain.getColumn(TDATE).setEditor((ICellEditor)new KDTDefaultCellEditor(this.getPickDate()));
        this.setBREditor();
        this.setCurPeriodEditor();
    }

    private void setCurPeriodEditor() throws BOSException, EASBizException {
        String hrOrgUnit = SysContext.getSysContext().getCurrentHRUnit().getId().toString();
        CmpPeriodInfo initInfo = BenefitUtils.getInitPeriod();
        KDBizPromptBox prmtBox = new KDBizPromptBox();
        prmtBox.setQueryInfo("com.kingdee.eas.hr.compensation.app.F7CmpPeriodQuery");
        prmtBox.setDisplayFormat("$number$");
        prmtBox.setEditFormat("$number$");
        prmtBox.setCommitFormat("$number$");
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo info = new FilterInfo();
        info.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)hrOrgUnit));
        info.getFilterItems().add(new FilterItemInfo("beginDate", (Object)initInfo.getBeginDate(), CompareType.GREATER_EQUALS));
        info.setMaskString("#0 and #1");
        evi.setFilter(info);
        prmtBox.setEntityViewInfo(evi);
        prmtBox.setRequired(true);
        this.tblMain.getColumn(CURPERIOD).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtBox));
    }

    private void setBREditor() throws BOSException, EASBizException {
        IRow iRow = null;
        AccountTypeInfo brInfo = null;
        int size = this.tblMain.getRowCount();
        for (int i = 0; i < size; ++i) {
            iRow = this.tblMain.getRow(i);
            if (iRow.getCell(ANAME).getValue() == null) continue;
            brInfo = (AccountTypeInfo)iRow.getCell(ANAME).getValue();
            this.tblMain.getCell(i, BRNAME).setEditor(BenefitUtils.getComboBoxCellEditor((IObjectCollection)BenefitUtils.getBenefitRuleColl(brInfo.getId().toString())));
        }
    }

    private AccountCollection getAccountInfoColl() throws EASBizException, BOSException {
        HROrgUnitInfo hrOrgInfo = SysContext.getSysContext().getCurrentHRUnit();
        AccountCollection coll = new AccountCollection();
        AccountInfo accInfo = null;
        IRow iRow = null;
        HashSet<String> personIDSet = new HashSet<String>();
        String personID = null;
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        int count = this.tblMain.getRowCount();
        for (int i = 0; i < count; ++i) {
            iRow = this.tblMain.getRow(i);
            personID = iRow.getCell(ID).getValue().toString();
            map.put(personID, i);
            personIDSet.add(personID);
        }
        HashMap personInfoMap = this.getPersonInfoMap(personIDSet);
        Iterator iter = map.keySet().iterator();
        String key = null;
        while (iter.hasNext()) {
            key = iter.next().toString();
            int rowIndex = (Integer)map.get(key);
            accInfo = new AccountInfo();
            iRow = this.tblMain.getRow(rowIndex);
            personID = iRow.getCell(ID).getValue().toString();
            accInfo.setHrOrgUnit(hrOrgInfo);
            accInfo.setPerson((PersonInfo)personInfoMap.get(personID));
            if (iRow.getCell(ACC_ID).getValue() != null) {
                accInfo.setId(BOSUuid.read((String)iRow.getCell(ACC_ID).getValue().toString()));
            }
            accInfo.put("pid", iRow.getCell(ID).getValue().toString());
            coll.add(accInfo);
        }
        return coll;
    }

    private HashMap getPersonInfoMap(Set personIDSet) throws BOSException {
        HashMap<String, PersonInfo> personInfoMap = new HashMap<String, PersonInfo>();
        IPerson iPerson = PersonFactory.getRemoteInstance();
        StringBuffer oql = new StringBuffer("select * where id in");
        oql.append(BenefitUtils.getStrFromSet(personIDSet));
        PersonCollection perColl = iPerson.getPersonCollection(oql.toString());
        int size = perColl.size();
        for (int i = 0; i < size; ++i) {
            personInfoMap.put(perColl.get(i).getId().toString(), perColl.get(i));
        }
        return personInfoMap;
    }

    private AccountDetailCollection getAccountDetailInfoColl() throws EASBizException, BOSException {
        AccountDetailCollection coll = new AccountDetailCollection();
        AccountDetailInfo adInfo = null;
        IRow iRow = null;
        HashMap<String, BenefitRuleInfo> personDetailMap = new HashMap<String, BenefitRuleInfo>();
        ArrayList<String> atIDList = new ArrayList<String>();
        String accounts = null;
        HashSet accountsSet = new HashSet();
        int count = this.tblMain.getRowCount();
        for (int i = 0; i < count; ++i) {
            adInfo = new AccountDetailInfo();
            iRow = this.tblMain.getRow(i);
            if (iRow.getCell(INSERVICE).getValue() == null) {
                throw new EmpAccountManagerException(EmpAccountManagerException.EMPTYPE_NOTNULL);
            }
            if (iRow.getCell(ANAME).getValue() == null) {
                throw new EmpAccountManagerException(EmpAccountManagerException.ACCTYPE_NOTNULL, new Object[]{i + 1});
            }
            if (iRow.getCell(ACCOUNTS).getValue() == null) {
                throw new EmpAccountManagerException(EmpAccountManagerException.ACCOUNTS_NOTNULL);
            }
            accounts = (String)iRow.getCell(ACCOUNTS).getValue();
            adInfo.setCurPeriod((CmpPeriodInfo)iRow.getCell(CURPERIOD).getValue());
            adInfo.setAccountType((AccountTypeInfo)iRow.getCell(ANAME).getValue());
            adInfo.setAccountNumber(iRow.getCell(ACCOUNTNUMBER).getValue().toString());
            adInfo.setAccounts(iRow.getCell(ACCOUNTS).getValue().toString());
            if (iRow.getCell(ACREATETIME).getValue() != null) {
                adInfo.setCreateDate(BenefitUtils.getSqlTimestamp((Date)iRow.getCell(ACREATETIME).getValue()));
            }
            adInfo.setStopDate((Date)iRow.getCell(ASTOPDATE).getValue());
            adInfo.setBenefitRule((BenefitRuleInfo)iRow.getCell(BRNAME).getValue());
            adInfo.setRetireTransactDate((Date)iRow.getCell(REDATE).getValue());
            adInfo.setRetireNumber((String)iRow.getCell(RENUM).getValue());
            adInfo.setFundItem((String)iRow.getCell(FUND).getValue());
            adInfo.setTransactDate((Date)iRow.getCell(TDATE).getValue());
            if (this.brMap.get(i) != null) {
                adInfo.put("oldBr", (BenefitRuleInfo)this.brMap.get(i));
            }
            if (iRow.getCell(APAYSTATE).getValue() instanceof PayTypeEnum) {
                adInfo.setPayState((PayTypeEnum)((Object)iRow.getCell(APAYSTATE).getValue()));
            } else {
                adInfo.setPayState(this.getPTEnum(iRow.getCell(APAYSTATE).getValue()));
            }
            if (iRow.getCell(ACC_ID).getValue() != null) {
                adInfo.setAccount(this.getAccountInfo(iRow, iRow.getCell(ACC_ID).getValue().toString()));
            }
            if (iRow.getCell(AD_ID).getValue() != null) {
                String id = iRow.getCell(AD_ID).getValue().toString();
                for (int ii = 0; ii < atIDList.size(); ++ii) {
                    if (!id.equals(atIDList.get(ii))) continue;
                    id = null;
                    break;
                }
                if (StringUtils.isEmpty((String)id)) {
                    adInfo.setId(null);
                } else {
                    adInfo.setId(BOSUuid.read((String)id));
                    atIDList.add(id);
                }
            }
            String personID = iRow.getCell(ID).getValue().toString();
            adInfo.put("pid", personID);
            String atId = adInfo.getAccountType().getId().toString();
            StringBuffer key = new StringBuffer();
            key.append(personID).append("&&").append(atId);
            if (personDetailMap.containsKey(key.toString())) {
                throw new EmpAccountManagerException(EmpAccountManagerException.ACCDETAILPERSON, new Object[]{iRow.getCell(NUM).getValue()});
            }
            personDetailMap.put(key.toString(), adInfo.getBenefitRule());
            coll.add(adInfo);
        }
        return coll;
    }

    private IObjectPK[] getPKList() {
        return null;
    }

    private AccountInfo getAccountInfo(IRow iRow, String accountID) throws BOSException, EASBizException {
        IAccount iAccount = AccountFactory.getRemoteInstance();
        AccountInfo info = null;
        ObjectUuidPK pk = null;
        if (StringUtils.isEmpty((String)accountID)) {
            pk = new ObjectUuidPK(accountID);
            info = iAccount.getAccountInfo((IObjectPK)pk);
            info.put("perNum", iRow.getCell(NUM).getValue().toString());
        }
        return info;
    }

    public void loadFields() {
        super.loadFields();
    }

    public void storeFields() {
        super.storeFields();
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.saveWarn = false;
        IEmpManagerFacade iemf = EmpManagerFacadeFactory.getRemoteInstance();
        if (!iemf.hasUpdatePeriodData()) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.hr.benefit.PersonInBenefitResource.PLEASE_UPDATE_DATA"));
            this.saveWarn = true;
            return;
        }
        GetDataDialog dlg = new GetDataDialog((Frame)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        dlg.setGetDataTask(new GetDataTaskAdapter(){

            public Object exec() throws Exception {
                try {
                    AccountBatchManagerListUI.this.saveData();
                }
                catch (Exception e) {
                    AccountBatchManagerListUI.this.saveWarn = true;
                    ExceptionHandler.handle((Throwable)e);
                }
                return null;
            }
        });
        dlg.show();
    }

    private void saveData() throws Exception {
        IObjectPK logPK = LogUtil.beginLog(null, (String)"", (BOSObjectType)new AccountDetailInfo().getBOSType(), null, null, (String)"AccountBatchManager");
        PermissionHelper.checkFunctionPermission((IObjectPK)this.getUserPk(), (IObjectPK)new ObjectStringPK(SysContext.getSysContext().getCurrentHRUnit().getId().toString()), (IMetaDataPK)this.getMetaDataPK(), (ItemAction)this.actionSave);
        IEmpManagerFacade iEmpManagerFacade = EmpManagerFacadeFactory.getRemoteInstance();
        if (this.checkTblMainData()) {
            this.checkCurPeriod();
            AccountCollection accColl = this.getAccountInfoColl();
            AccountDetailCollection adColl = this.getAccountDetailInfoColl();
            try {
                iEmpManagerFacade.submitAll(accColl, adColl, this.getPKList());
                this.setSaveId(iEmpManagerFacade);
            }
            catch (EASBizException e) {
                MsgBox.showError((Component)((Object)this), (String)e.getMessage());
                this.saveWarn = true;
                return;
            }
            catch (BOSException e) {
                throw new BOSException((Throwable)e);
            }
            this.setAccountTypeLocked();
            this.showMessage();
        }
        if (!this.saveWarn) {
            this.dataChange = false;
        }
        LogUtil.afterLog(null, (IObjectPK)logPK);
    }

    private void checkCurPeriod() throws BOSException, EASBizException {
        String accDetailID = null;
        String newCurPeriodID = null;
        String oldCurPeriodID = null;
        IRow row = null;
        AccountDetailInfo adInfo = null;
        Object[] param = null;
        IAccountDetail iad = AccountDetailFactory.getRemoteInstance();
        int size = this.tblMain.getRowCount();
        for (int i = 0; i < size; ++i) {
            row = this.tblMain.getRow(i);
            accDetailID = (String)row.getCell(AD_ID).getValue();
            if (!StringUtils.isEmpty((String)accDetailID)) {
                adInfo = iad.getAccountDetailInfo((IObjectPK)new ObjectStringPK(accDetailID));
                newCurPeriodID = adInfo.getCurPeriod().getId().toString();
                oldCurPeriodID = ((CmpPeriodInfo)row.getCell(CURPERIOD).getValue()).getId().toString();
                if (!this.isHasCmpPeriod("T_HR_CMPPERIOD", "fid", oldCurPeriodID)) {
                    param = new Object[]{row.getCell(CURPERIOD).getValue()};
                    throw new EmpAccountManagerException(EmpAccountManagerException.EXCEPTION18, param);
                }
                if (oldCurPeriodID.equals(newCurPeriodID)) continue;
                param = new Object[]{adInfo.getAccounts()};
                if (iad.hasInitBenefitData(accDetailID)) {
                    throw new EmpAccountManagerException(EmpAccountManagerException.EXISTINITDATA, param);
                }
                if (iad.hasCaculated(accDetailID)) {
                    throw new EmpAccountManagerException(EmpAccountManagerException.EXISTCALDATA, param);
                }
                if (!adInfo.isHasBenefitBiz()) continue;
                throw new EmpAccountManagerException(EmpAccountManagerException.HASBENEBIZ, param);
            }
            oldCurPeriodID = ((CmpPeriodInfo)row.getCell(CURPERIOD).getValue()).getId().toString();
            if (this.isHasCmpPeriod("T_HR_CMPPERIOD", "fid", oldCurPeriodID)) continue;
            param = new Object[]{row.getCell(CURPERIOD).getValue()};
            throw new EmpAccountManagerException(EmpAccountManagerException.EXCEPTION18, param);
        }
    }

    private boolean isHasCmpPeriod(String tableName, String fieldName, String cmpPeriodId) {
        try {
            String sql = "SELECT * FROM " + tableName + " WHERE " + fieldName + "=" + "'" + cmpPeriodId + "'";
            ISQLExecutor iSQL = SQLExecutorFactory.getRemoteInstance((String)sql.toString());
            IRowSet iRowSet = iSQL.executeSQL();
            return iRowSet.next();
        }
        catch (BOSException e) {
            return false;
        }
        catch (SQLException e) {
            return false;
        }
    }

    private void setSaveId(IEmpManagerFacade iEmpManagerFacade) throws BOSException, EASBizException {
        IRow iRow = null;
        IRowSet rowSet = null;
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<Integer, String> mergeMap = new HashMap<Integer, String>();
        HashMap<String, String> storeMap = new HashMap<String, String>();
        int size = this.tblMain.getRowCount();
        for (int i = 0; i < size; ++i) {
            iRow = this.tblMain.getRow(i);
            if (iRow.getCell(ID).getValue() == null || iRow.getCell(ANAME).getValue() == null) continue;
            String perID = iRow.getCell(ID).getValue().toString();
            String atID = ((AccountTypeInfo)iRow.getCell(ANAME).getValue()).getId().toString();
            map.put(Integer.valueOf(i).toString() + "&&" + perID, atID);
            mergeMap.put(i, perID + atID);
        }
        rowSet = iEmpManagerFacade.setSaveId(map);
        try {
            while (rowSet.next()) {
                String perID = rowSet.getString("person.id");
                String atID = rowSet.getString("accountType.id");
                String accID = rowSet.getString("account.id");
                String adID = rowSet.getString(ID);
                storeMap.put(perID + atID, accID + "#" + adID);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        String mergeID = null;
        String[] IdArray = null;
        int size2 = this.tblMain.getRowCount();
        for (int i = 0; i < size2; ++i) {
            iRow = this.tblMain.getRow(i);
            if (storeMap.get(mergeMap.get(i).toString()) == null) continue;
            mergeID = storeMap.get(mergeMap.get(i).toString()).toString();
            IdArray = StringUtils.split((String)mergeID, (String)"#");
            iRow.getCell(ACC_ID).setValue((Object)IdArray[0]);
            iRow.getCell(AD_ID).setValue((Object)IdArray[1]);
        }
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        KDTSelectBlock sb = null;
        int size2 = this.tblMain.getSelectManager().size();
        if (size2 > 0) {
            sb = this.tblMain.getSelectManager().get(0);
            ICell iCell = null;
            int row = sb.getTop();
            int column = sb.getLeft();
            IColumn iColumn = this.tblMain.getColumn(column);
            if (row == -1) {
                return;
            }
            int[] selectDis = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
            Object value = this.tblMain.getCell(row, column).getValue();
            if (iColumn.getStyleAttributes().isLocked()) {
                return;
            }
            BenefitRuleCollection benefitRuleColl = null;
            ICellEditor cellEditor = null;
            if (value != null && value instanceof AccountTypeInfo) {
                AccountTypeInfo brInfo = (AccountTypeInfo)value;
                benefitRuleColl = BenefitUtils.getBenefitRuleColl(brInfo.getId().toString());
                cellEditor = BenefitUtils.getComboBoxCellEditor((IObjectCollection)benefitRuleColl);
            }
            ICell iCellId = null;
            boolean hasChanged = false;
            int count = selectDis.length;
            for (int i = 0; i < count; ++i) {
                if (selectDis[i] == row || this.tblMain.getCell(selectDis[i], column).getStyleAttributes().isLocked()) continue;
                iCell = this.tblMain.getCell(selectDis[i], column);
                if (column == this.tblMain.getColumnIndex(NAME)) {
                    this.copyPerInfo(row, selectDis[i]);
                    continue;
                }
                if (column == this.tblMain.getColumnIndex(ANAME)) {
                    if (value == null || !(value instanceof AccountTypeInfo) || iCell.getValue() != null && iCell.getValue().equals(this.tblMain.getCell(row, column).getValue())) continue;
                    hasChanged = true;
                    this.tblMain.getCell(selectDis[i], ACCOUNTNUMBER).setValue((Object)((AccountTypeInfo)value).getNumber());
                    this.tblMain.getCell(selectDis[i], ANAME).setValue((Object)((AccountTypeInfo)value));
                    this.tblMain.getCell(selectDis[i], BRNAME).setEditor(cellEditor);
                    if (benefitRuleColl != null && benefitRuleColl.size() > 0) {
                        this.tblMain.getCell(selectDis[i], BRNAME).setValue((Object)benefitRuleColl.get(0));
                    } else {
                        this.tblMain.getCell(selectDis[i], BRNAME).setValue(null);
                    }
                    this.tblMain.getCell(selectDis[i], ACREATETIME).setValue((Object)new Date());
                    continue;
                }
                if (column == this.tblMain.getColumnIndex(BRNAME)) {
                    Object atValue = this.tblMain.getCell(row, ANAME).getValue();
                    Object atNewValue = this.tblMain.getCell(selectDis[i], ANAME).getValue();
                    if (atNewValue == null || !atNewValue.equals(atValue)) continue;
                    iCellId = this.tblMain.getCell(selectDis[i], BRNAME);
                    if (iCellId.getValue() != null && iCellId.getValue() instanceof BenefitRuleInfo && !iCellId.getValue().equals(value)) {
                        this.brMap.put(selectDis[i], (BenefitRuleInfo)iCellId.getValue());
                    }
                    iCellId.setValue(value);
                    continue;
                }
                this.tblMain.getCell(selectDis[i], column).setValue(value);
            }
            if (column == this.tblMain.getColumnIndex(ANAME) && value != null && value instanceof AccountTypeInfo && hasChanged) {
                AccountTypeInfo brInfo = (AccountTypeInfo)value;
                boolean accTypeIsCheck = EmpManagerFacadeFactory.getRemoteInstance().checkIsCheck(brInfo.getId().toString(), SysContext.getSysContext().getCurrentHRUnit().getId().toString());
                if (accTypeIsCheck) {
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.benefit.AccountManagerResource.SHOW_INFO"));
                }
            }
        }
    }

    private void copyPerInfo(int row, int i) {
        Object obj = null;
        obj = this.tblMain.getCell(row, ID).getValue();
        this.tblMain.getCell(i, ID).setValue(obj);
        obj = this.tblMain.getCell(row, INSERVICE).getValue();
        this.tblMain.getCell(i, INSERVICE).setValue(obj);
        obj = this.tblMain.getCell(row, NUM).getValue();
        this.tblMain.getCell(i, NUM).setValue(obj);
        obj = this.tblMain.getCell(row, NAME).getValue();
        this.tblMain.getCell(i, NAME).setValue(obj);
        obj = this.tblMain.getCell(row, ADMINNAME).getValue();
        this.tblMain.getCell(i, ADMINNAME).setValue(obj);
        obj = this.tblMain.getCell(row, APAYSTATE).getValue();
        this.tblMain.getCell(i, APAYSTATE).setValue(obj);
        obj = this.tblMain.getCell(row, ACC_ID).getValue();
        this.tblMain.getCell(i, ACC_ID).setValue(obj);
    }

    public void actionNormal_actionPerformed(ActionEvent e) throws Exception {
        int[] indexs = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        IRow curRow = null;
        int size = indexs.length;
        for (int i = 0; i < size; ++i) {
            curRow = this.tblMain.getRow(indexs[i]);
            curRow.getCell(APAYSTATE).setValue((Object)PayTypeEnum.NORMALPAY);
            curRow.getCell(ASTOPDATE).setValue(null);
        }
    }

    public void actionSeal_actionPerformed(ActionEvent e) throws Exception {
        int[] indexs = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        IRow curRow = null;
        int size = indexs.length;
        for (int i = 0; i < size; ++i) {
            curRow = this.tblMain.getRow(indexs[i]);
            curRow.getCell(APAYSTATE).setValue((Object)PayTypeEnum.SEALPAY);
        }
    }

    public void actionStop_actionPerformed(ActionEvent e) throws Exception {
        if (BenefitUtils.confirmStopBiz()) {
            int[] indexs = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
            IRow curRow = null;
            int size = indexs.length;
            for (int i = 0; i < size; ++i) {
                curRow = this.tblMain.getRow(indexs[i]);
                curRow.getCell(APAYSTATE).setValue((Object)PayTypeEnum.STOPPAY);
                curRow.getCell(ASTOPDATE).setValue((Object)new Date());
            }
        }
    }

    protected void btnAddRow_actionPerformed(ActionEvent e) throws Exception {
        super.btnAddRow_actionPerformed(e);
        BenefitUtils.addNewRow(this.tblMain);
        this.tblMain.getColumn(NAME).getStyleAttributes().setLocked(false);
    }

    protected void btnCopyRow_actionPerformed(ActionEvent e) throws Exception {
        IRow iRow = null;
        IRow addRow = null;
        int[] selectRowIndexes = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        int size = selectRowIndexes.length;
        for (int i = 0; i < size; ++i) {
            if (selectRowIndexes[i] == -1) continue;
            iRow = this.tblMain.getRow(selectRowIndexes[i]);
            addRow = this.tblMain.addRow();
            int sum = this.tblMain.getColumnCount();
            for (int j = 0; j < sum; ++j) {
                if (this.tblMain.getColumn(j).getKey().equals(AD_ID) || iRow.getCell(j) == null) continue;
                addRow.getCell(j).setValue(iRow.getCell(j).getValue());
            }
        }
        this.tblMain.getColumn(NAME).getStyleAttributes().setLocked(false);
    }

    protected void btnDelRow_actionPerformed(ActionEvent e) throws Exception {
        super.btnDelRow_actionPerformed(e);
        BenefitUtils.deleteBlock(this.tblMain);
    }

    protected void btnInsertRow_actionPerformed(ActionEvent e) throws Exception {
        super.btnInsertRow_actionPerformed(e);
        BenefitUtils.insertRow(this.tblMain);
        this.tblMain.getColumn(NAME).getStyleAttributes().setLocked(false);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        PermissionHelper.checkFunctionPermission((IObjectPK)this.getUserPk(), (IObjectPK)new ObjectStringPK(SysContext.getSysContext().getCurrentHRUnit().getId().toString()), (IMetaDataPK)this.getMetaDataPK(), (ItemAction)this.actionAddNew);
        super.actionAddNew_actionPerformed(e);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        PermissionHelper.checkFunctionPermission((IObjectPK)this.getUserPk(), (IObjectPK)new ObjectStringPK(SysContext.getSysContext().getCurrentHRUnit().getId().toString()), (IMetaDataPK)this.getMetaDataPK(), (ItemAction)this.actionEdit);
        this.oprtState = OprtState.EDIT;
        this.tblMain.setEnabled(true);
        this.setColumnUnLock();
        this.setWorkButtonEnabled(true);
        this.btnEdit.setEnabled(false);
        this.menuItemEdit.setEnabled(false);
    }

    private void setColumnUnLock() {
        this.tblMain.getColumn(ANAME).getStyleAttributes().setLocked(false);
        this.tblMain.getColumn(BRNAME).getStyleAttributes().setLocked(false);
        this.tblMain.getColumn(ACCOUNTS).getStyleAttributes().setLocked(false);
        this.tblMain.getColumn(CURPERIOD).getStyleAttributes().setLocked(false);
        this.tblMain.getColumn(ACREATETIME).getStyleAttributes().setLocked(false);
        this.tblMain.getColumn(ASTOPDATE).getStyleAttributes().setLocked(false);
        this.tblMain.getColumn(REDATE).getStyleAttributes().setLocked(false);
        this.tblMain.getColumn(RENUM).getStyleAttributes().setLocked(false);
        this.tblMain.getColumn(FUND).getStyleAttributes().setLocked(false);
        this.tblMain.getColumn(TDATE).getStyleAttributes().setLocked(false);
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        this.showQueryF7();
        this.setBREditor();
        this.comboState.setSelectedIndex(0);
    }

    private void showQueryF7() throws BOSException, EASBizException, Exception {
        IBenefitCommonFacade iBenefitCommonFacade = BenefitCommonFacadeFactory.getRemoteInstance();
        EmployeeMultiF7PromptBox personNoPositionPromptBox = new EmployeeMultiF7PromptBox((IUIObject)this);
        personNoPositionPromptBox.showNoPositionPerson(true);
        personNoPositionPromptBox.setIsSingleSelect(false);
        personNoPositionPromptBox.showOnlySocietyPerson(true);
        personNoPositionPromptBox.show();
        if (!personNoPositionPromptBox.isCanceled()) {
            if (personNoPositionPromptBox.getData() instanceof Object[]) {
                int i;
                Object[] obj = (Object[])personNoPositionPromptBox.getData();
                HashSet<String> set = new HashSet<String>();
                int length = obj.length;
                for (i = 0; i < length; ++i) {
                    set.add(((PersonInfo)obj[i]).getId().toString());
                }
                this.perIdSet = set;
                if (this.perIdSet.size() == 0) {
                    return;
                }
                ArrayList perList = iBenefitCommonFacade.getPersonListBySet(set);
                this.tblMain.removeRows();
                length = perList.size();
                for (i = 0; i < length; ++i) {
                    HashMap innerMap = (HashMap)perList.get(i);
                    this.addPersonInfo(innerMap);
                }
            }
        } else {
            SysUtil.abort();
        }
    }

    protected IIDList getSelectedKeyValues() {
        return new RealModeIDList();
    }

    private void addPersonInfo(HashMap innerMap) throws BOSException {
        this.tblMain.checkParsed();
        IRow curRow = this.tblMain.addRow();
        curRow.getCell(ID).setValue((Object)innerMap.get("perid").toString());
        curRow.getCell(NUM).setValue(innerMap.get("perNum"));
        curRow.getCell(NAME).setValue(innerMap.get("perName"));
        curRow.getCell(ADMINNAME).setValue(innerMap.get("aname"));
        curRow.getCell(INSERVICE).setValue(innerMap.get("et"));
        int inservice = (Integer)innerMap.get("et");
        this.convertAliasInService(curRow, inservice);
        curRow.getCell(ACCOUNTNUMBER).setValue(innerMap.get("accNum"));
        if (innerMap.get(ADPAY) != null && (Integer)innerMap.get(ADPAY) != 0) {
            curRow.getCell(APAYSTATE).setValue((Object)PayTypeEnum.getEnum((Integer)innerMap.get(ADPAY)));
            curRow.getCell(ASTOPDATE).setValue(innerMap.get("adSd"));
        } else {
            curRow.getCell(APAYSTATE).setValue((Object)PayTypeEnum.STOPPAY);
        }
        curRow.getCell(ACREATETIME).setValue(innerMap.get("adSt"));
        curRow.getCell(ANAME).setValue(innerMap.get("atName"));
        curRow.getCell(BRNAME).setValue(innerMap.get("brName"));
        curRow.getCell(ACCOUNTS).setValue(innerMap.get("adAcc"));
        curRow.getCell(REDATE).setValue(innerMap.get("reDate"));
        curRow.getCell(RENUM).setValue(innerMap.get("reNum"));
        curRow.getCell(FUND).setValue(innerMap.get("fund"));
        curRow.getCell(TDATE).setValue(innerMap.get("tDate"));
        curRow.getCell(CURPERIOD).setValue(innerMap.get(CURPERIOD));
        if (innerMap.get(ACCID) != null) {
            curRow.getCell(ACC_ID).setValue(innerMap.get(ACCID));
        }
        if (innerMap.get(ADID) != null) {
            curRow.getCell(AD_ID).setValue(innerMap.get(ADID));
        }
    }

    private void convertAliasInService(IRow curRow, int inservice) {
        if (inservice == 1) {
            curRow.getCell(INSERVICE).setValue((Object)EASResource.getString((String)"com.kingdee.eas.hr.base.HRBasedataResource.EMPLOYEETYPE_INSERVICE"));
        } else if (inservice == 0) {
            curRow.getCell(INSERVICE).setValue((Object)EASResource.getString((String)"com.kingdee.eas.hr.base.HRBasedataResource.EMPLOYEETYPE_NOTINSERVICE"));
        } else if (inservice == 2) {
            curRow.getCell(INSERVICE).setValue((Object)EASResource.getString((String)"com.kingdee.eas.hr.base.HRBasedataResource.EMPLOYEETYPE_LEAVEINSERVICE"));
        } else if (inservice == 3) {
            curRow.getCell(INSERVICE).setValue((Object)EASResource.getString((String)"com.kingdee.eas.hr.base.HRBasedataResource.EMPLOYEETYPE_RETIRESERVICE"));
        } else if (inservice == 4) {
            curRow.getCell(INSERVICE).setValue((Object)EASResource.getString((String)"com.kingdee.eas.hr.base.HRBasedataResource.EMPLOYEETYPE_RERETAIN"));
        }
    }

    private void insertPersonInfo(HashMap innerMap, Set existPerNum) throws BOSException, EASBizException {
        IRow curRow = BenefitUtils.insertRow(this.tblMain);
        if (curRow != null) {
            curRow.getCell(ID).setValue((Object)innerMap.get("perid").toString());
            curRow.getCell(NUM).setValue(innerMap.get("perNum"));
            curRow.getCell(NAME).setValue(innerMap.get("perName"));
            curRow.getCell(ADMINNAME).setValue(innerMap.get("aname"));
            int inservice = (Integer)innerMap.get("et");
            this.convertAliasInService(curRow, inservice);
            if (innerMap.get(ACCID) != null) {
                curRow.getCell(ACC_ID).setValue(innerMap.get(ACCID));
            }
            if (innerMap.get(CURPERIOD) != null) {
                curRow.getCell(CURPERIOD).setValue(innerMap.get(CURPERIOD));
            }
            if (!existPerNum.contains(innerMap.get("perNum"))) {
                curRow.getCell(ACCOUNTNUMBER).setValue(innerMap.get("accNum"));
                if (innerMap.get(ADPAY) != null && (Integer)innerMap.get(ADPAY) != 0) {
                    curRow.getCell(APAYSTATE).setValue((Object)PayTypeEnum.getEnum((Integer)innerMap.get(ADPAY)));
                } else {
                    curRow.getCell(APAYSTATE).setValue((Object)PayTypeEnum.STOPPAY);
                }
                curRow.getCell(ASTOPDATE).setValue(innerMap.get("adSd"));
                curRow.getCell(ACREATETIME).setValue(innerMap.get("adSt"));
                curRow.getCell(ANAME).setValue(innerMap.get("atName"));
                curRow.getCell(BRNAME).setValue(innerMap.get("brName"));
                curRow.getCell(ACCOUNTS).setValue(innerMap.get("adAcc"));
                curRow.getCell(REDATE).setValue(innerMap.get("reDate"));
                curRow.getCell(RENUM).setValue(innerMap.get("reNum"));
                curRow.getCell(FUND).setValue(innerMap.get("fund"));
                curRow.getCell(TDATE).setValue(innerMap.get("tDate"));
                if (innerMap.get(ACCID) != null && innerMap.get("atName") != null && this.checkAccountDetail(innerMap.get(ACCID).toString(), ((AccountTypeInfo)innerMap.get("atName")).getId().toString())) {
                    curRow.getCell(AD_ID).setValue(innerMap.get(ADID));
                }
            } else {
                curRow.getCell(APAYSTATE).setValue((Object)PayTypeEnum.STOPPAY);
            }
            this.setBREditor();
        }
    }

    private boolean checkAccountDetail(String accountID, String atID) throws BOSException, EASBizException {
        IAccountDetail iAccountDetail = AccountDetailFactory.getRemoteInstance();
        return iAccountDetail.exists(" where account.id='" + accountID + "' and accountType.id='" + atID + "'");
    }

    protected void tblMain_doRequestRowSet(RequestRowSetEvent e) {
        if (this.mainQuery != null) {
            int start = (Integer)e.getParam1();
            int length = (Integer)e.getParam2() - start + 1;
            try {
                IQueryExecutor exec = this.getQueryExecutor(this.mainQueryPK, this.mainQuery);
                exec.option().isAutoTranslateEnum = true;
                IRowSet rowSet = exec.executeQuery(start, length);
                e.setRowSet(rowSet);
                this.onGetRowSet(rowSet);
            }
            catch (Exception ee) {
                this.handUIException(ee);
            }
        }
    }

    protected void tblMain_editStopped(KDTEditEvent e) throws Exception {
        int colIndex = e.getColIndex();
        int rowIndex = e.getRowIndex();
        if (e.getValue() != null && !e.getValue().equals(e.getOldValue()) || e.getValue() == null && e.getOldValue() != null) {
            this.dataChange = true;
        }
        if (this.tblMain.getColumnKey(colIndex).equals(ANAME) && e.getValue() != null && e.getValue() instanceof AccountTypeInfo && !e.getValue().equals(e.getOldValue())) {
            AccountTypeInfo brInfo = (AccountTypeInfo)e.getValue();
            boolean accTypeIsCheck = EmpManagerFacadeFactory.getRemoteInstance().checkIsCheck(brInfo.getId().toString(), SysContext.getSysContext().getCurrentHRUnit().getId().toString());
            if (accTypeIsCheck) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.benefit.AccountManagerResource.SHOW_INFO"));
            }
            BenefitRuleCollection benefitRuleColl = BenefitUtils.getBenefitRuleColl(brInfo.getId().toString());
            this.tblMain.getCell(e.getRowIndex(), ACCOUNTNUMBER).setValue((Object)brInfo.getNumber());
            this.tblMain.getCell(rowIndex, BRNAME).setEditor(BenefitUtils.getComboBoxCellEditor((IObjectCollection)benefitRuleColl));
            if (benefitRuleColl != null && benefitRuleColl.size() > 0) {
                this.tblMain.getCell(rowIndex, BRNAME).setValue((Object)benefitRuleColl.get(0));
            } else {
                this.tblMain.getCell(rowIndex, BRNAME).setValue(null);
            }
            this.tblMain.getCell(e.getRowIndex(), ACREATETIME).setValue((Object)new Date());
        }
        if (this.tblMain.getColumnKey(colIndex).equals(BRNAME) && e.getValue() != null && e.getValue() instanceof BenefitRuleInfo && !e.getValue().equals(e.getOldValue())) {
            this.brMap.put(e.getRowIndex(), (BenefitRuleInfo)e.getOldValue());
        }
        IBenefitCommonFacade iBenefitCommonFacade = BenefitCommonFacadeFactory.getRemoteInstance();
        if (this.tblMain.getColumnKey(colIndex).equals(NAME) && e.getValue() != null && !e.getValue().equals(e.getOldValue())) {
            Object[] obj = (Object[])((KDBizPromptBox)this.tblMain.getColumn(NAME).getEditor().getComponent()).getSelector().getData();
            if (obj == null || obj.length == 0) {
                return;
            }
            IRow row = null;
            String perNum = null;
            HashSet<String> existPerNum = new HashSet<String>();
            HashSet<String> tempPerNum = new HashSet<String>();
            int rowSize = this.tblMain.getRowCount3();
            for (int m = 0; m < rowSize; ++m) {
                row = this.tblMain.getRow(m);
                perNum = (String)row.getCell(NUM).getValue();
                if (perNum == null) continue;
                existPerNum.add(perNum);
                tempPerNum.add(perNum);
            }
            ArrayList perList = iBenefitCommonFacade.getPersonList(obj);
            int length = perList.size();
            for (int i = 0; i < length; ++i) {
                HashMap innerMap = (HashMap)perList.get(i);
                if (!existPerNum.contains(innerMap.get("perNum"))) {
                    this.insertPersonInfo(innerMap, existPerNum);
                    continue;
                }
                if (!tempPerNum.contains(innerMap.get("perNum"))) continue;
                this.insertPersonInfo(innerMap, existPerNum);
                tempPerNum.remove(innerMap.get("perNum"));
            }
            this.tblMain.removeRow(rowIndex);
        }
    }

    protected ArrayList getImportParam() {
        String solutionName;
        DatataskParameter param = new DatataskParameter();
        param.solutionName = solutionName = "eas.hr.benefit.AccountBatch";
        param.alias = EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitCommonResource.ACCBATCH");
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
        PermissionHelper.checkFunctionPermission((IObjectPK)this.getUserPk(), (IObjectPK)new ObjectStringPK(SysContext.getSysContext().getCurrentHRUnit().getId().toString()), (IMetaDataPK)this.getMetaDataPK(), (ItemAction)this.actionImportData);
        HashSet<Object> perIdSet = new HashSet<Object>();
        int count = this.tblMain.getRowCount();
        for (int i = 0; i < count; ++i) {
            perIdSet.add(this.tblMain.getCell(i, ID).getValue() == null ? "" : this.tblMain.getCell(i, ID).getValue());
        }
        DatataskCaller task = new DatataskCaller();
        task.setParentComponent((Component)((Object)this));
        task.invoke(this.getImportParam(), 0, true);
        if (!task.isCanceld()) {
            IBenefitCommonFacade iBenefitCommonFacade = BenefitCommonFacadeFactory.getRemoteInstance();
            if (perIdSet.size() == 0) {
                return;
            }
            ArrayList perList = iBenefitCommonFacade.getPersonListBySet(perIdSet);
            this.tblMain.removeRows();
            int length = perList.size();
            for (int i = 0; i < length; ++i) {
                HashMap innerMap = (HashMap)perList.get(i);
                this.addPersonInfo(innerMap);
            }
            this.setBREditor();
            this.comboState.setSelectedIndex(0);
        }
    }

    protected ArrayList getExportParam() {
        String solutionName;
        DatataskParameter param = new DatataskParameter();
        param.solutionName = solutionName = "eas.hr.benefit.AccountBatch";
        param.alias = EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitCommonResource.ACCBATCH");
        param.datataskMode = 1;
        param.putContextParam((Object)"mainQueryPK", (Object)new MetaDataPK("com.kingdee.eas.hr.benefit.app.AccountBatchExportQuery"));
        param.putContextParam((Object)"mainQuery", (Object)this.getExportView());
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    public EntityViewInfo getExportView() {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)this.perIdSet, CompareType.INCLUDE));
        view.setFilter(filterInfo);
        return view;
    }

    public void actionExportData_actionPerformed(ActionEvent e) throws Exception {
        PermissionHelper.checkFunctionPermission((IObjectPK)this.getUserPk(), (IObjectPK)new ObjectStringPK(SysContext.getSysContext().getCurrentHRUnit().getId().toString()), (IMetaDataPK)this.getMetaDataPK(), (ItemAction)this.actionExportData);
        DatataskCaller dc = new DatataskCaller();
        if (SwingUtilities.getWindowAncestor((Component)((Object)this)) instanceof KDFrame) {
            dc.setParentComponent((Component)((Object)this));
        }
        dc.invoke(this.getExportParam(), 1);
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    private KDDatePicker getPickDate() {
        KDDatePicker pkDate = new KDDatePicker();
        pkDate.setMilliSecondEnable(false);
        pkDate.setDateEnabled(true);
        pkDate.setTimeEnabled(false);
        pkDate.setEditable(false);
        return pkDate;
    }

    private PayTypeEnum getPTEnum(Object enumValue) {
        int eValue = Integer.parseInt(enumValue.toString());
        PayTypeEnum ptEnum = PayTypeEnum.getEnum(eValue);
        return ptEnum;
    }

    public void actionUpdate_actionPerformed(ActionEvent e) throws Exception {
        PermissionHelper.checkFunctionPermission((IObjectPK)this.getUserPk(), (IObjectPK)new ObjectStringPK(SysContext.getSysContext().getCurrentHRUnit().getId().toString()), (IMetaDataPK)this.getMetaDataPK(), (ItemAction)this.actionUpdate);
        UIContext uiContext = new UIContext((Object)this);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BeneChooseUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
        BeneChooseUI userUI = (BeneChooseUI)uiWindow.getUIObject();
        IEmpManagerFacade iEmpManagerFacade = EmpManagerFacadeFactory.getRemoteInstance();
        if (!userUI.isCanceled()) {
            List benefitIdList = userUI.getBenefitIdList();
            if (benefitIdList.size() <= 0) {
                return;
            }
            AccountDetailCollection coll = this.getAccountDetailInfoColl();
            iEmpManagerFacade.updateAiiInfo(benefitIdList, coll);
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitCommonResource.ACCBATHUPDATE_SUCC"));
        }
    }

    private void setAccountTypeLocked() {
        int size = this.tblMain.getRowCount3();
        IRow row = null;
        for (int i = 0; i < size; ++i) {
            row = this.tblMain.getRow(i);
            if (row.getCell(ANAME).getValue() == null) continue;
            row.getCell(ANAME).getStyleAttributes().setLocked(true);
        }
    }

    private boolean checkTblMainData() {
        int size = this.tblMain.getRowCount3();
        IRow row = null;
        for (int i = 0; i < size; ++i) {
            row = this.tblMain.getRow(i);
            if (row.getCell(NAME).getValue() == null) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitCommonResource.PERSON_NULL"));
                this.saveWarn = true;
                return false;
            }
            if (row.getCell(CURPERIOD).getValue() != null) continue;
            MsgBox.showInfo((String)(EASResource.getString((String)"com.kingdee.eas.hr.benefit.PersonInBenefitResource.FROM") + (i + 1) + EASResource.getString((String)"com.kingdee.eas.hr.benefit.PersonInBenefitResource.ROW") + EASResource.getString((String)"com.kingdee.eas.hr.benefit.AccountManagerResource.CURPERIOD_NOT_NULL")));
            this.saveWarn = true;
            return false;
        }
        return true;
    }

    protected String getMessageText() {
        return EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitCommonResource.ACCOUNTBATH_SUCC");
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        int topIndex = e.getSelectBlock().getTop();
        if (topIndex != -1) {
            IRow iRow = this.tblMain.getRow(topIndex);
            String accDetailID = (String)iRow.getCell(AD_ID).getValue();
            if (StringUtils.isEmpty((String)accDetailID)) {
                this.btnDelRow.setEnabled(true);
                iRow.getCell(NAME).getStyleAttributes().setLocked(false);
                iRow.getCell(ANAME).getStyleAttributes().setLocked(false);
                iRow.getCell(CURPERIOD).getStyleAttributes().setLocked(false);
            } else {
                this.btnDelRow.setEnabled(false);
                iRow.getCell(NAME).getStyleAttributes().setLocked(true);
                iRow.getCell(ANAME).getStyleAttributes().setLocked(true);
                IAccountDetail iad = AccountDetailFactory.getRemoteInstance();
                AccountDetailInfo adInfo = iad.getAccountDetailInfo((IObjectPK)new ObjectStringPK(accDetailID));
                if (adInfo.isHasBenefitBiz() || iad.hasCacuLateOrEndInit(accDetailID)) {
                    iRow.getCell(CURPERIOD).getStyleAttributes().setLocked(true);
                } else if (OprtState.EDIT.equals(this.oprtState)) {
                    iRow.getCell(CURPERIOD).getStyleAttributes().setLocked(false);
                }
            }
            if (iRow.getCell(APAYSTATE) != null) {
                if (iRow.getCell(APAYSTATE).getValue() != null) {
                    if (!this.oprtState.equals(LIST)) {
                        int payState = ((PayTypeEnum)((Object)iRow.getCell(APAYSTATE).getValue())).getValue();
                        this.initPayStateBtlEnable(payState);
                    } else {
                        this.setStateButton(false);
                    }
                } else {
                    this.setStateButton(false);
                }
            } else {
                this.setStateButton(false);
            }
        }
    }

    public boolean checkBeforeWindowClosing() {
        super.checkBeforeWindowClosing();
        if (this.dataChange) {
            String message = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Save_Exit");
            int result = MsgBox.showConfirm3((Component)((Object)this), (String)message);
            if (result == 0) {
                try {
                    this.actionSave_actionPerformed(null);
                }
                catch (Exception e) {
                    ExceptionHandler.handle((Throwable)e);
                    return false;
                }
                return !this.saveWarn;
            }
            return result == 1;
        }
        return true;
    }

    private void initStateCombo() {
        AccountTypeCollection coll = null;
        Object[] arrType = null;
        HROrgUnitInfo orgUnitInfo = HRSchemeUtils.getClientHROrgUnitInfo();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)orgUnitInfo.getId().toString()));
        view.setFilter(filter);
        try {
            coll = AccountTypeFactory.getRemoteInstance().getAccountTypeCollection(view);
        }
        catch (BOSException e1) {
            this.handleException((Exception)((Object)e1));
        }
        if (coll != null) {
            arrType = new AccountTypeInfo[coll.size() + 1];
            AccountTypeInfo temp = new AccountTypeInfo();
            temp.setName(EASResource.getString((String)"com.kingdee.eas.hr.compensation.CmpCheckWizardResource.ALL"));
            temp.setId(BOSUuid.create((String)"9DA8ECBB"));
            arrType[0] = temp;
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                arrType[i + 1] = coll.get(i);
            }
        }
        this.comboState.removeAllItems();
        this.comboState.addItems(arrType);
        this.comboState.setSelectedIndex(0);
        this.comboState.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                try {
                    AccountBatchManagerListUI.this.fillValueToTable(AccountBatchManagerListUI.this.comboState);
                }
                catch (Exception e1) {
                    AccountBatchManagerListUI.this.handleException(e1);
                }
            }
        });
    }

    private void fillValueToTable(KDComboBox comboState) throws BOSException, EASBizException {
        int seleIndex = comboState.getSelectedIndex();
        AccountTypeInfo typeInfo = (AccountTypeInfo)comboState.getSelectedItem();
        IBenefitCommonFacade iBenefitCommonFacade = BenefitCommonFacadeFactory.getRemoteInstance();
        ArrayList perList = iBenefitCommonFacade.getPersonListBySet(this.perIdSet);
        this.tblMain.removeRows();
        int length = perList.size();
        for (int i = 0; i < length; ++i) {
            HashMap innerMap = (HashMap)perList.get(i);
            if (seleIndex == 0) {
                this.addPersonInfo(innerMap);
                continue;
            }
            if (innerMap.get("atName") == null || !typeInfo.getId().toString().equals(((AccountTypeInfo)innerMap.get("atName")).getId().toString())) continue;
            this.addPersonInfo(innerMap);
        }
        this.setBREditor();
    }

    protected void execQuery() {
        this.tblMain.repaint();
    }
}

