/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.benefit.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.hr.base.util.HRUtil;
import com.kingdee.eas.hr.benefit.EmpManagerFacadeFactory;
import com.kingdee.eas.hr.benefit.IEmpManagerFacade;
import com.kingdee.eas.hr.benefit.client.AbstractAccountDetailItemFilterUI;
import com.kingdee.eas.hr.benefit.util.BenefitUtils;
import com.kingdee.eas.hr.benefit.util.BenefitVerifyUtils;
import com.kingdee.eas.hr.benefit.util.CommonQueryUtil;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class AccountDetailItemFilterUI
extends AbstractAccountDetailItemFilterUI {
    private static Logger logger = Logger.getLogger(AccountDetailItemFilterUI.class);
    private static final long serialVersionUID = 1L;
    private boolean isUseAdminFlag = false;

    public void initUIContentLayout() {
        super.initUIContentLayout();
        if (!this.kDLabelContainer1.isVisible()) {
            this.kdlAdminOrg.setBounds(new Rectangle(25, 35, 270, 19));
            this.chkIncludeSubOrgUnit.setBounds(new Rectangle(105, 70, 140, 19));
            this.kblCurPeriod.setBounds(new Rectangle(25, 105, 270, 19));
            this.kblBenifitPeriod.setBounds(new Rectangle(24, 150, 271, 19));
            this.kDPanel1.setBorder((Border)new TitledBorder(BorderFactory.createLineBorder(new Color(192, 192, 192), 0), ""));
        }
    }

    public void loadFields() {
        super.loadFields();
    }

    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.setPanelName(EASResource.getString((String)"com.kingdee.eas.hr.benefit.AccountManagerResource.SEARCH"));
        this.initAllEditor();
    }

    private void initAllEditor() {
        BenefitUtils.setAdminOrgF7(this.prmtAdminOrg);
        this.prmtCurPeriod.setEnabled(false);
        this.prmtBenifitPeriod.setEnabled(false);
    }

    protected void prmtAdminOrg_stateChanged(ChangeEvent e) throws Exception {
        this.setCurPeriodPrompt();
    }

    protected void chkIncludeSubOrgUnit_itemStateChanged(ItemEvent e) throws Exception {
        this.setCurPeriodPrompt();
    }

    private void setCurPeriodPrompt() throws EASBizException, BOSException {
        if (this.prmtAdminOrg.getData() == null) {
            this.prmtCurPeriod.setData(null);
            this.prmtCurPeriod.setEnabled(false);
            this.prmtBenifitPeriod.setEnabled(false);
        } else {
            AdminOrgUnitInfo admin = (AdminOrgUnitInfo)this.prmtAdminOrg.getData();
            this.prmtCurPeriod.setQueryInfo("com.kingdee.eas.hr.compensation.app.F7CmpPeriodQuery");
            this.prmtCurPeriod.setDisplayFormat("$number$");
            this.prmtCurPeriod.setEditFormat("$number$");
            this.prmtCurPeriod.setCommitFormat("$number$");
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)SysContext.getSysContext().getCurrentHRUnit().getId()));
            IEmpManagerFacade iemf = EmpManagerFacadeFactory.getRemoteInstance();
            Map map = iemf.getPeriodCollection(admin.getId().toString(), this.chkIncludeSubOrgUnit.isSelected(), null);
            Set set = (Set)map.get("periodset");
            CmpPeriodInfo beginInfo = (CmpPeriodInfo)map.get("CmpPeriodInfo");
            if (set != null && set.size() > 0) {
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)set, CompareType.INCLUDE));
                filter.setMaskString("#0 and #1");
                this.prmtCurPeriod.setData((Object)beginInfo);
                this.prmtCurPeriod.setEnabled(true);
            } else {
                this.prmtCurPeriod.setData(null);
                this.prmtCurPeriod.setEnabled(false);
            }
            evi.setFilter(filter);
            this.prmtCurPeriod.setEntityViewInfo(evi);
            if (!this.prmtCurPeriod.isEnabled()) {
                this.prmtBenifitPeriod.setEnabled(true);
                evi = new EntityViewInfo();
                filter = new FilterInfo();
                CmpPeriodInfo initInfo = BenefitUtils.getInitPeriod();
                filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)SysContext.getSysContext().getCurrentHRUnit().getId()));
                filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)initInfo.getBeginDate(), CompareType.GREATER_EQUALS));
                filter.setMaskString("#0 and #1");
                evi.setFilter(filter);
                this.setSelector(evi, this.prmtBenifitPeriod);
            }
        }
    }

    protected void prmtCurPeriod_stateChanged(ChangeEvent e) throws Exception {
        this.prmtBenifitPeriod.setData(null);
        if (this.prmtCurPeriod.getData() == null) {
            this.prmtBenifitPeriod.setEnabled(true);
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            CmpPeriodInfo initInfo = BenefitUtils.getInitPeriod();
            filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)SysContext.getSysContext().getCurrentHRUnit().getId()));
            filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)initInfo.getBeginDate(), CompareType.GREATER_EQUALS));
            filter.setMaskString("#0 and #1");
            evi.setFilter(filter);
            this.setSelector(evi, this.prmtBenifitPeriod);
        } else {
            this.prmtBenifitPeriod.setEnabled(true);
            CmpPeriodInfo curPeriodInfo = (CmpPeriodInfo)this.prmtCurPeriod.getData();
            CmpPeriodInfo initInfo = BenefitUtils.getInitPeriod();
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)SysContext.getSysContext().getCurrentHRUnit().getId()));
            filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)curPeriodInfo.getBeginDate(), CompareType.LESS_EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)initInfo.getBeginDate(), CompareType.GREATER_EQUALS));
            filter.setMaskString("#0 and #1 and #2");
            evi.setFilter(filter);
            this.setSelector(evi, this.prmtBenifitPeriod);
        }
    }

    private void setSelector(EntityViewInfo evi, KDBizPromptBox prmt) {
        prmt.setQueryInfo("com.kingdee.eas.hr.compensation.app.F7CmpPeriodQuery");
        prmt.setDisplayFormat("$number$");
        prmt.setEditFormat("$number$");
        prmt.setCommitFormat("$number$");
        prmt.setEntityViewInfo(evi);
        prmt.setEditable(true);
    }

    public boolean verify() {
        if (!BenefitVerifyUtils.adminOrgNotNullVerify(this.prmtAdminOrg)) {
            return false;
        }
        if (this.prmtBenifitPeriod.getData() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.benefit.client.FormDetailResource.MUST_BEN_PERIOD"));
            this.prmtBenifitPeriod.requestFocusInWindow();
            return false;
        }
        return true;
    }

    public String getPanelSql() {
        StringBuffer paenelSql = new StringBuffer();
        AdminOrgUnitInfo adminOrgUnitInfo = (AdminOrgUnitInfo)this.prmtAdminOrg.getData();
        CmpPeriodInfo cmpBeginPeriodInfo = (CmpPeriodInfo)this.prmtBenifitPeriod.getData();
        if (this.chkIncludeSubOrgUnit.isSelected()) {
            paenelSql.append(" (admin.FLongNumber = '");
            paenelSql.append(adminOrgUnitInfo.getLongNumber());
            paenelSql.append("' or admin.FLongNumber like '");
            paenelSql.append(adminOrgUnitInfo.getLongNumber());
            paenelSql.append("!%')");
        } else {
            paenelSql.append(" admin.FLongNumber = '");
            paenelSql.append(adminOrgUnitInfo.getLongNumber());
            paenelSql.append("'");
        }
        paenelSql.append(" and brd.fcmpperiodid = '");
        paenelSql.append(cmpBeginPeriodInfo.getId().toString());
        paenelSql.append("'");
        paenelSql.append(" # cmpperiod.FID = '");
        paenelSql.append(cmpBeginPeriodInfo.getId().toString());
        paenelSql.append("' ");
        return paenelSql.toString();
    }

    public FilterInfo getPersonFilterInfoIF() {
        return this.getPersonFilterInfo();
    }

    private FilterInfo getPersonFilterInfo() {
        FilterInfo filterInfo = new FilterInfo();
        int count = 0;
        if (this.chkOnPosition.isSelected()) {
            filterInfo.getFilterItems().add(new FilterItemInfo("EmpType.inService", (Object)"1"));
            ++count;
        }
        if (this.chkOutPosition.isSelected()) {
            filterInfo.getFilterItems().add(new FilterItemInfo("EmpType.inService", (Object)"0"));
            ++count;
        }
        if (this.chkResignation.isSelected()) {
            filterInfo.getFilterItems().add(new FilterItemInfo("EmpType.inService", (Object)"2"));
            ++count;
        }
        if (this.chkRetire.isSelected()) {
            filterInfo.getFilterItems().add(new FilterItemInfo("EmpType.inService", (Object)"3"));
            ++count;
        }
        if (this.chkReretain.isSelected()) {
            filterInfo.getFilterItems().add(new FilterItemInfo("EmpType.inService", (Object)"4"));
            ++count;
        }
        StringBuffer maskString = new StringBuffer("(");
        int countTemp = count - 1;
        for (int i = 0; i < count; ++i) {
            maskString.append("#").append(i);
            if (i >= countTemp) continue;
            maskString.append(" OR ");
        }
        maskString.append(") AND ");
        CmpPeriodInfo cmpPeriodInfo = (CmpPeriodInfo)this.prmtBenifitPeriod.getData();
        filterInfo.getFilterItems().add(new FilterItemInfo("CmpPeriod.id", (Object)cmpPeriodInfo.getId().toString()));
        maskString.append("(#").append(count).append(") ");
        if (this.chkOnPosition.isSelected() || this.chkReretain.isSelected()) {
            filterInfo.getFilterItems().add(new FilterItemInfo("Position.id", null, CompareType.NOTEQUALS));
            ++count;
            if (this.chkOutPosition.isSelected() || this.chkResignation.isSelected() || this.chkRetire.isSelected()) {
                maskString.append("  AND ((#").append(count).append(")");
                filterInfo.getFilterItems().add(new FilterItemInfo("Position.id", null, CompareType.EQUALS));
                maskString.append("  OR (#").append(++count).append("))");
            } else {
                maskString.append("  AND (#").append(count).append(")");
            }
        } else if (this.chkOutPosition.isSelected() || this.chkResignation.isSelected() || this.chkRetire.isSelected()) {
            filterInfo.getFilterItems().add(new FilterItemInfo("Position.id", null, CompareType.EQUALS));
            maskString.append("  AND (#").append(++count).append(") ");
        } else {
            maskString.append("  AND (#").append(count).append(")");
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("hROrgUnit.id", (Object)HRSchemeUtils.getClientHROrgUnitInfo().getId().toString()));
        maskString.append(" and ( #").append(++count).append(")");
        ++count;
        filterInfo.getFilterItems().add(new FilterItemInfo("OrgRange.type", (Object)"20"));
        maskString.append(" and (#").append(++count).append(")");
        filterInfo.getFilterItems().add(new FilterItemInfo("TypeRela.id", (Object)"00000000-0000-0000-0000-0000000000100FE9F8B5"));
        maskString.append(" and (#").append(++count).append(")");
        if (this.isUseAdminFlag) {
            AdminOrgUnitInfo adminOrgUnitInfo = (AdminOrgUnitInfo)this.prmtAdminOrg.getData();
            if (!this.chkIncludeSubOrgUnit.isSelected()) {
                filterInfo.getFilterItems().add(new FilterItemInfo("AdminOrgUnit.id", (Object)adminOrgUnitInfo.getId().toString()));
                maskString.append(" and (#").append(count).append(")");
                ++count;
                filterInfo.setMaskString(maskString.toString());
            } else {
                try {
                    filterInfo.getFilterItems().add(new FilterItemInfo("AdminOrgUnit.longNumber", (Object)adminOrgUnitInfo.getLongNumber()));
                    maskString.append(" and (").append("#").append(count);
                    filterInfo.getFilterItems().add(new FilterItemInfo("AdminOrgUnit.longNumber", (Object)(adminOrgUnitInfo.getLongNumber() + "!%"), CompareType.LIKE));
                    maskString.append(" or ").append("#").append(++count).append(")");
                    filterInfo.setMaskString(maskString.toString());
                    FilterInfo filterAdminOrg = HRUtil.buildHROFilter((String)"AdminOrgUnit.id");
                    filterInfo.mergeFilter(filterAdminOrg, "AND");
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage());
                }
            }
        } else {
            filterInfo.setMaskString(maskString.toString());
        }
        FilterInfo fli = this.getDefaultFilterForQuery();
        try {
            filterInfo.mergeFilter(fli, "and");
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
        }
        return filterInfo;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("ToUnit.id", (Object)SysContext.getSysContext().getCurrentHRUnit().getId().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("User.id", (Object)SysContext.getSysContext().getCurrentUserInfo().getId().toString()));
        filterInfo.setMaskString("#0 and #1");
        return filterInfo;
    }

    public void clear() {
        super.clear();
        this.chkOnPosition.setSelected(false);
        this.chkOutPosition.setSelected(false);
        this.chkResignation.setSelected(false);
        this.chkRetire.setSelected(false);
        this.chkReretain.setSelected(false);
        this.chkIncludeSubOrgUnit.setSelected(false);
        this.prmtAdminOrg.setData(null);
        this.prmtCurPeriod.setData(null);
        this.prmtBenifitPeriod.setData(null);
    }

    private void setAdminOrgState() {
        if (this.chkOutPosition.isSelected() || this.chkResignation.isSelected() || this.chkRetire.isSelected() || this.chkOnPosition.isSelected()) {
            this.isUseAdminFlag = true;
        }
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        cp.addCustomerParam("chkOnPosition", Boolean.valueOf(this.chkOnPosition.isSelected()).toString());
        cp.addCustomerParam("chkOutPosition", Boolean.valueOf(this.chkOutPosition.isSelected()).toString());
        cp.addCustomerParam("chkResignation", Boolean.valueOf(this.chkResignation.isSelected()).toString());
        cp.addCustomerParam("chkRetire", Boolean.valueOf(this.chkRetire.isSelected()).toString());
        cp.addCustomerParam("chkReretain", Boolean.valueOf(this.chkReretain.isSelected()).toString());
        cp.addCustomerParam("personFilterInfo", this.getPersonFilterInfo().toString());
        CommonQueryUtil.getAdminFromQueryPanel(cp, this.prmtAdminOrg);
        cp.addCustomerParam("chkIncludeSubOrgUnit", Boolean.valueOf(this.chkIncludeSubOrgUnit.isSelected()).toString());
        CommonQueryUtil.getCmpFromQueryPanel("curPeriod", cp, this.prmtCurPeriod);
        CommonQueryUtil.getCmpFromQueryPanel("benefitPeriod.id", cp, this.prmtBenifitPeriod);
        return cp;
    }

    public void setCustomerParams(CustomerParams cp) {
        if (cp == null) {
            return;
        }
        if (cp.getCustomerParam("chkOnPosition") != null) {
            this.chkOnPosition.setSelected(Boolean.valueOf(cp.getCustomerParam("chkOnPosition")).booleanValue());
        }
        if (cp.getCustomerParam("chkOutPosition") != null) {
            this.chkOutPosition.setSelected(Boolean.valueOf(cp.getCustomerParam("chkOutPosition")).booleanValue());
        }
        if (cp.getCustomerParam("chkRetire") != null) {
            this.chkResignation.setSelected(Boolean.valueOf(cp.getCustomerParam("chkRetire")).booleanValue());
        }
        if (cp.getCustomerParam("chkResignation") != null) {
            this.chkResignation.setSelected(Boolean.valueOf(cp.getCustomerParam("chkResignation")).booleanValue());
        }
        if (cp.getCustomerParam("chkReretain") != null) {
            this.chkReretain.setSelected(Boolean.valueOf(cp.getCustomerParam("chkReretain")).booleanValue());
        }
        CommonQueryUtil.setAdminFromQueryPanel(cp, this.prmtAdminOrg);
        if (cp.getCustomerParam("chkIncludeSubOrgUnit") != null) {
            this.chkIncludeSubOrgUnit.setSelected(Boolean.valueOf(cp.getCustomerParam("chkIncludeSubOrgUnit")).booleanValue());
        }
        CommonQueryUtil.setCmpFromQueryPanel("curPeriod", cp, this.prmtCurPeriod);
        CommonQueryUtil.setCmpFromQueryPanel("benefitPeriod.id", cp, this.prmtBenifitPeriod);
    }

    protected void chkOnPosition_itemStateChanged(ItemEvent e) throws Exception {
        super.chkOnPosition_itemStateChanged(e);
        this.setAdminOrgState();
    }

    protected void chkOutPosition_itemStateChanged(ItemEvent e) throws Exception {
        super.chkOutPosition_itemStateChanged(e);
        this.setAdminOrgState();
    }

    protected void chkResignation_itemStateChanged(ItemEvent e) throws Exception {
        super.chkResignation_itemStateChanged(e);
        this.setAdminOrgState();
    }

    protected void chkRetire_itemStateChanged(ItemEvent e) throws Exception {
        super.chkRetire_itemStateChanged(e);
        this.setAdminOrgState();
    }
}

