/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.benefit.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.client.GetDataDialog;
import com.kingdee.eas.base.core.client.GetDataTaskAdapter;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.uiframe.client.UIModelDialog;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.hr.benefit.AccountSettleFacadeFactory;
import com.kingdee.eas.hr.benefit.AccountTypeCollection;
import com.kingdee.eas.hr.benefit.AccountTypeInfo;
import com.kingdee.eas.hr.benefit.BenefitException;
import com.kingdee.eas.hr.benefit.BenefitInvokeFacadeFactory;
import com.kingdee.eas.hr.benefit.EmpAccountManagerException;
import com.kingdee.eas.hr.benefit.EmpManagerFacadeFactory;
import com.kingdee.eas.hr.benefit.IAccountSettleFacade;
import com.kingdee.eas.hr.benefit.IBenefitInvokeFacade;
import com.kingdee.eas.hr.benefit.IEmpManagerFacade;
import com.kingdee.eas.hr.benefit.client.AbstractAccountSettleUI;
import com.kingdee.eas.hr.benefit.util.BenefitUtils;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;

public class AccountSettleUI
extends AbstractAccountSettleUI {
    private static final long serialVersionUID = 1L;
    private static final String ZERO_STR = "0";

    public void loadFields() {
        super.loadFields();
    }

    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        if (!BenefitUtils.hasInitPeriod()) {
            throw new BenefitException(BenefitException.NO_BENEFIT_PERIOD);
        }
        super.onLoad();
        this.setTxtUnEnable();
        this.setTxtNullValue();
        this.initAccountType();
        this.initEditor();
        this.setButtonEnable();
    }

    private void initEditor() {
        BenefitUtils.setAdminOrgF7(this.prmtAdminOrg);
        this.prmtCurPeriod.setEnabled(false);
    }

    private void setTxtUnEnable() {
        this.txtCheck.setEnabled(false);
        this.txtUnCheck.setEnabled(false);
        this.txtChecked.setEnabled(false);
        this.txtNotChecked.setEnabled(false);
        this.txtNormal.setEnabled(false);
        this.txtSeal.setEnabled(false);
        this.txtStop.setEnabled(false);
        this.txtTotal.setEnabled(false);
    }

    private void setTxtNullValue() {
        this.txtCheck.setText(null);
        this.txtUnCheck.setText(null);
        this.txtChecked.setText(null);
        this.txtNotChecked.setText(null);
        this.txtNormal.setText(null);
        this.txtSeal.setText(null);
        this.txtStop.setText(null);
        this.txtTotal.setText(null);
    }

    private void setButtonEnable() {
        if (this.prmtAdminOrg.getData() == null || this.prmtCurPeriod.getData() == null || this.comboAccountType.getSelectedItem() == null) {
            this.btnSettle.setEnabled(false);
        } else {
            int notChecked = 0;
            int unCheck = 0;
            int checked = 0;
            int normal = 0;
            if (!StringUtils.isEmpty((String)this.txtNotChecked.getText())) {
                notChecked = Integer.parseInt(this.txtNotChecked.getText());
            }
            if (!StringUtils.isEmpty((String)this.txtUnCheck.getText())) {
                unCheck = Integer.parseInt(this.txtUnCheck.getText());
            }
            if (!StringUtils.isEmpty((String)this.txtChecked.getText())) {
                checked = Integer.parseInt(this.txtChecked.getText());
            }
            if (!StringUtils.isEmpty((String)this.txtNormal.getText())) {
                normal = Integer.parseInt(this.txtNormal.getText());
            }
            if (unCheck != 0 || notChecked != 0 || checked == 0 || normal != checked) {
                this.btnSettle.setEnabled(false);
            } else {
                this.btnSettle.setEnabled(true);
            }
        }
    }

    private void setAccountInfo() throws BOSException, EASBizException {
        if (this.prmtAdminOrg.getData() == null || this.prmtCurPeriod.getData() == null || this.comboAccountType.getSelectedItem() == null) {
            this.setTxtNullValue();
        } else {
            String admin = ((AdminOrgUnitInfo)this.prmtAdminOrg.getData()).getId().toString();
            String period = ((CmpPeriodInfo)this.prmtCurPeriod.getData()).getId().toString();
            String accType = ((AccountTypeInfo)this.comboAccountType.getSelectedItem()).getId().toString();
            boolean includeSubOrg = this.includeSubOrg.isSelected();
            IBenefitInvokeFacade ibnf = BenefitInvokeFacadeFactory.getRemoteInstance();
            HashMap map = ibnf.getAccountInfos(accType, period, admin, includeSubOrg);
            if (map.get("COUNT_ACCOUNT_TOTAL") != null) {
                this.txtTotal.setText(((Integer)map.get("COUNT_ACCOUNT_TOTAL")).toString());
            } else {
                this.txtTotal.setText(ZERO_STR);
            }
            if (map.get("COUNT_ACCOUNT_STOP") != null) {
                this.txtStop.setText(((Integer)map.get("COUNT_ACCOUNT_STOP")).toString());
            } else {
                this.txtStop.setText(ZERO_STR);
            }
            if (map.get("COUNT_ACCOUNT_NORMAL") != null) {
                this.txtNormal.setText(((Integer)map.get("COUNT_ACCOUNT_NORMAL")).toString());
            } else {
                this.txtNormal.setText(ZERO_STR);
            }
            if (map.get("COUNT_ACCOUNT_FREEZE") != null) {
                this.txtSeal.setText(((Integer)map.get("COUNT_ACCOUNT_FREEZE")).toString());
            } else {
                this.txtSeal.setText(ZERO_STR);
            }
            if (map.get("COUNT_ACCOUNT_CURRENT_CHK") != null) {
                this.txtChecked.setText(((Integer)map.get("COUNT_ACCOUNT_CURRENT_CHK")).toString());
            } else {
                this.txtChecked.setText(ZERO_STR);
            }
            if (map.get("COUNT_ACCOUNT_CURRENT_UNCHK") != null) {
                this.txtNotChecked.setText(((Integer)map.get("COUNT_ACCOUNT_CURRENT_UNCHK")).toString());
            } else {
                this.txtNotChecked.setText(ZERO_STR);
            }
            if (map.get("COUNT_ADJUST_CURRENT_CHK") != null) {
                this.txtCheck.setText(((Integer)map.get("COUNT_ADJUST_CURRENT_CHK")).toString());
            } else {
                this.txtCheck.setText(ZERO_STR);
            }
            if (map.get("COUNT_ADJUST_CURRENT_UNCHK") != null) {
                this.txtUnCheck.setText(((Integer)map.get("COUNT_ADJUST_CURRENT_UNCHK")).toString());
            } else {
                this.txtUnCheck.setText(ZERO_STR);
            }
        }
    }

    private void initAccountType() throws BOSException {
        DefaultComboBoxModel<AccountTypeInfo> model = new DefaultComboBoxModel<AccountTypeInfo>();
        AccountTypeCollection coll = BenefitUtils.getAccountTypeColl();
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            model.addElement(coll.get(i));
        }
        this.comboAccountType.setModel(model);
    }

    protected void btnCancle_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancle_actionPerformed(e);
        this.getUIWindow().close();
    }

    protected void btnSettle_actionPerformed(ActionEvent e) throws Exception {
        IObjectPK logPK = LogUtil.beginLog(null, (String)"", null, null, (String)EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitResource.MESSAGE_BENEFIT_SETTLE"), (String)"AccountSettle");
        GetDataDialog dlg = new GetDataDialog((Dialog)((UIModelDialog)SwingUtilities.getWindowAncestor((Component)((Object)this))));
        dlg.setGetDataTask(new GetDataTaskAdapter(){

            public Object exec() throws Exception {
                AccountSettleUI.this.accountSettle();
                return null;
            }
        });
        dlg.show();
        LogUtil.afterLog(null, (IObjectPK)logPK);
    }

    private void showMessage(String message) {
        this.setMessageText(message);
        this.showMessage();
    }

    protected void prmtAdminOrg_stateChanged(ChangeEvent e) throws Exception {
        if (this.prmtAdminOrg.getData() == null) {
            this.setTxtNullValue();
            this.btnSettle.setEnabled(false);
        } else {
            this.setAccountInfo();
            this.setButtonEnable();
        }
        this.setCurPeriodPrompt();
    }

    protected void includeSubOrg_stateChanged(ChangeEvent e) throws Exception {
        this.setCurPeriodPrompt();
    }

    protected void prmtCurPeriod_stateChanged(ChangeEvent e) throws Exception {
        if (this.prmtCurPeriod.getData() == null) {
            this.setTxtNullValue();
            this.btnSettle.setEnabled(false);
        } else {
            this.setAccountInfo();
            this.setButtonEnable();
        }
    }

    protected void comboAccountType_itemStateChanged(ItemEvent e) throws Exception {
        if (this.comboAccountType.getSelectedItem() == null) {
            this.setTxtNullValue();
            this.btnSettle.setEnabled(false);
        } else {
            this.setAccountInfo();
            this.setButtonEnable();
        }
        this.setCurPeriodPrompt();
    }

    private void setCurPeriodPrompt() throws EASBizException, BOSException {
        if (this.prmtAdminOrg.getData() == null) {
            this.prmtCurPeriod.setData(null);
            this.prmtCurPeriod.setEnabled(false);
        } else {
            AdminOrgUnitInfo admin = (AdminOrgUnitInfo)this.prmtAdminOrg.getData();
            this.prmtCurPeriod.setQueryInfo("com.kingdee.eas.hr.compensation.app.F7CmpPeriodQuery");
            this.prmtCurPeriod.setDisplayFormat("$number$");
            this.prmtCurPeriod.setEditFormat("$number$");
            this.prmtCurPeriod.setCommitFormat("$number$");
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)SysContext.getSysContext().getCurrentHRUnit().getId()));
            String accTypeID = null;
            if (this.comboAccountType.getSelectedItem() != null) {
                accTypeID = ((AccountTypeInfo)this.comboAccountType.getSelectedItem()).getId().toString();
            }
            IEmpManagerFacade iemf = EmpManagerFacadeFactory.getRemoteInstance();
            Map map = iemf.getPeriodCollection(admin.getId().toString(), this.includeSubOrg.isSelected(), accTypeID);
            Set set = (Set)map.get("periodset");
            CmpPeriodInfo beginInfo = (CmpPeriodInfo)map.get("CmpPeriodInfo");
            if (set != null && set.size() > 0) {
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)set, CompareType.INCLUDE));
                filter.setMaskString("#0 and #1");
                this.prmtCurPeriod.setData((Object)beginInfo);
                this.prmtCurPeriod.setEnabled(true);
            } else {
                this.prmtCurPeriod.setData(null);
                this.prmtCurPeriod.setEnabled(false);
            }
            evi.setFilter(filter);
            this.prmtCurPeriod.setEntityViewInfo(evi);
            if (set == null || set.size() > 0) {
                // empty if block
            }
        }
    }

    private void accountSettle() throws BOSException, EASBizException {
        String admin = ((AdminOrgUnitInfo)this.prmtAdminOrg.getData()).getId().toString();
        String period = ((CmpPeriodInfo)this.prmtCurPeriod.getData()).getId().toString();
        String accType = ((AccountTypeInfo)this.comboAccountType.getSelectedItem()).getId().toString();
        boolean includeSubOrg = this.includeSubOrg.isSelected();
        IBenefitInvokeFacade ibif = BenefitInvokeFacadeFactory.getRemoteInstance();
        CmpPeriodInfo newCmpPeriod = ibif.getNextPeriod(period);
        if (newCmpPeriod == null) {
            throw new EmpAccountManagerException(EmpAccountManagerException.NEXT_PERIOD_NULL);
        }
        IAccountSettleFacade iAccountSettleFacade = AccountSettleFacadeFactory.getRemoteInstance();
        iAccountSettleFacade.settleAccountData(accType, period, admin, includeSubOrg);
        this.showMessage(EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitResource.MESSAGE_BENEFIT_SETTLE") + EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitResource.MESSAGE_SUCCESS"));
        this.getUIWindow().close();
    }
}

