/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.benefit.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgF7InnerUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.hr.base.util.HRUtil;
import com.kingdee.eas.hr.benefit.AccountTypeCollection;
import com.kingdee.eas.hr.benefit.AccountTypeInfo;
import com.kingdee.eas.hr.benefit.EmpManagerFacadeFactory;
import com.kingdee.eas.hr.benefit.IEmpManagerFacade;
import com.kingdee.eas.hr.benefit.client.AbstractBenefitCalcuFilterUI;
import com.kingdee.eas.hr.benefit.util.BenefitUtils;
import com.kingdee.eas.hr.benefit.util.BenefitVerifyUtils;
import com.kingdee.eas.hr.benefit.util.CommonQueryUtil;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ItemEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import javax.swing.event.ChangeEvent;

public class BenefitCalcuFilterUI
extends AbstractBenefitCalcuFilterUI {
    private static final long serialVersionUID = 1L;
    private AccountTypeCollection accountTypeInfos;

    protected boolean isFirstAccType() {
        if (this.accountTypeInfos.size() == 0) {
            return false;
        }
        return this.accountTypeInfos.get(0).equals(this.comboAccountType.getSelectedItem());
    }

    public BenefitCalcuFilterUI() throws Exception {
        this.loadComboAccountType();
        this.initF7();
    }

    public void loadFields() {
        super.loadFields();
    }

    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.setPanelName(EASResource.getString((String)"com.kingdee.eas.hr.benefit.AccountManagerResource.SEARCH"));
    }

    private void initF7() {
        BenefitUtils.setAdminOrgF7(this.promptOrg);
        this.prmtCurPeriod.setEnabled(false);
    }

    protected void promptOrg_stateChanged(ChangeEvent e) throws Exception {
        this.setCurPeriodPrompt();
    }

    protected void chkIncludeSubOrg_itemStateChanged(ItemEvent e) throws Exception {
        this.setCurPeriodPrompt();
    }

    protected void comboAccountType_itemStateChanged(ItemEvent e) throws Exception {
        this.setCurPeriodPrompt();
    }

    private void setCurPeriodPrompt() throws EASBizException, BOSException {
        if (this.promptOrg.getData() == null) {
            this.prmtCurPeriod.setData(null);
            this.prmtCurPeriod.setEnabled(false);
        } else {
            this.prmtCurPeriod.setQueryInfo("com.kingdee.eas.hr.compensation.app.F7CmpPeriodQuery");
            this.prmtCurPeriod.setDisplayFormat("$number$");
            this.prmtCurPeriod.setEditFormat("$number$");
            this.prmtCurPeriod.setCommitFormat("$number$");
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)SysContext.getSysContext().getCurrentHRUnit().getId()));
            AdminOrgUnitInfo admin = (AdminOrgUnitInfo)this.promptOrg.getData();
            String accTypeID = null;
            if (this.comboAccountType.getSelectedItem() != null) {
                accTypeID = ((AccountTypeInfo)this.comboAccountType.getSelectedItem()).getId().toString();
            }
            IEmpManagerFacade iemf = EmpManagerFacadeFactory.getRemoteInstance();
            Map map = iemf.getPeriodCollection(admin.getId().toString(), this.chkIncludeSubOrg.isSelected(), accTypeID);
            Set set = (Set)map.get("periodset");
            CmpPeriodInfo beginInfo = (CmpPeriodInfo)map.get("CmpPeriodInfo");
            if (set != null && set.size() > 0) {
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)set, CompareType.INCLUDE));
                filter.setMaskString("#0 and #1");
                this.prmtCurPeriod.setData((Object)beginInfo);
                this.prmtCurPeriod.setEnabled(true);
            } else {
                this.prmtCurPeriod.setData(null);
                this.prmtCurPeriod.setEnabled(false);
            }
            evi.setFilter(filter);
            this.prmtCurPeriod.setEntityViewInfo(evi);
        }
    }

    private void loadComboAccountType() throws BOSException {
        DefaultComboBoxModel<AccountTypeInfo> model = new DefaultComboBoxModel<AccountTypeInfo>();
        this.accountTypeInfos = BenefitUtils.getAccountTypeColl();
        for (int i = 0; i < this.accountTypeInfos.size(); ++i) {
            model.addElement(this.accountTypeInfos.get(i));
        }
        if (this.accountTypeInfos.size() != 0) {
            model.setSelectedItem(this.accountTypeInfos.get(0));
        }
        this.comboAccountType.setModel(model);
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        CommonQueryUtil.getAdminFromQueryPanel(cp, this.promptOrg);
        cp.putBoolean("chkIncludeSubOrg", this.chkIncludeSubOrg.isSelected());
        CommonQueryUtil.getCmpFromQueryPanel("curPeriod", cp, this.prmtCurPeriod);
        if (this.comboAccountType.getSelectedItem() != null) {
            AccountTypeInfo atInfo = (AccountTypeInfo)this.comboAccountType.getSelectedItem();
            cp.addCustomerParam("AccountType", atInfo.getId().toString());
        }
        return cp;
    }

    public void setCustomerParams(CustomerParams cp) {
        if (cp == null) {
            return;
        }
        CommonQueryUtil.setAdminFromQueryPanel(cp, this.promptOrg);
        this.chkIncludeSubOrg.setSelected(cp.getBoolean("chkIncludeSubOrg"));
        String acc = cp.getCustomerParam("AccountType");
        int size = this.comboAccountType.getItemCount();
        for (int i = 0; i < size; ++i) {
            if (!acc.equals(((AccountTypeInfo)this.comboAccountType.getItemAt(i)).getId().toString())) continue;
            this.comboAccountType.setSelectedIndex(i);
            break;
        }
        CommonQueryUtil.setCmpFromQueryPanel("curPeriod", cp, this.prmtCurPeriod);
    }

    public void clear() {
        super.clear();
        this.chkIncludeSubOrg.setSelected(false);
        this.promptOrg.setValue(null);
        if (this.comboAccountType.getItemCount() <= 0) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.hr.benefit.BENEFITAutoGenerateResource", (String)"38_BenefitCalcuFilterUI"));
            SysUtil.abort();
        }
        this.comboAccountType.setSelectedIndex(0);
        this.chkIncludeSubOrg.setSelected(false);
        this.prmtCurPeriod.setData(null);
    }

    public boolean verify() {
        if (!BenefitVerifyUtils.adminOrgNotNullVerify(this.promptOrg)) {
            return false;
        }
        if (!BenefitVerifyUtils.curPeriodNotNullVerify(this.prmtCurPeriod)) {
            return false;
        }
        if (!BenefitVerifyUtils.accountTypeNotNullVerify(this.comboAccountType)) {
            return false;
        }
        return super.verify();
    }

    public AccountTypeCollection getAccountTypeInfos() {
        return this.accountTypeInfos;
    }

    public FilterInfo getFilterInfo(CustomerParams cp) {
        int fSize;
        FilterInfo info = new FilterInfo();
        Object set = null;
        String adminId = cp.getCustomerParam("adminOrg");
        boolean includeSubOrg = cp.getBoolean("chkIncludeSubOrg");
        if (adminId != null) {
            AdminOrgUnitInfo adminOrg = new AdminOrgUnitInfo();
            if (includeSubOrg) {
                info.getFilterItems().add(new FilterItemInfo("admin.longNumber", (Object)(this.getAdminOrgInfo().getLongNumber() + "%"), CompareType.LIKE));
            } else {
                info.getFilterItems().add(new FilterItemInfo("admin.id", (Object)adminId, CompareType.EQUALS));
            }
            info.getFilterItems().add(new FilterItemInfo("admin.isSealUp", (Object)"0", CompareType.EQUALS));
        }
        if (SysContext.getSysContext().getCurrentHRUnit() != null) {
            String curHROId = SysContext.getSysContext().getCurrentHRUnit().getId().toString();
            info.getFilterItems().add(new FilterItemInfo("adminToUnit.id", (Object)curHROId));
        }
        if (SysContext.getSysContext().getCurrentUserInfo() != null) {
            info.getFilterItems().add(new FilterItemInfo("user.id", (Object)SysContext.getSysContext().getCurrentUserInfo().getId().toString()));
        }
        String type = cp.getCustomerParam("AccountType");
        info.getFilterItems().add(new FilterItemInfo("accountType.id", (Object)type));
        String curPeriod = cp.getCustomerParam("curPeriod");
        if (!StringUtils.isEmpty((String)curPeriod)) {
            info.getFilterItems().add(new FilterItemInfo("curPeriod.id", (Object)curPeriod));
        }
        if ((fSize = info.getFilterItems().size()) > 1) {
            StringBuffer mStr = new StringBuffer();
            for (int i = 0; i < fSize; ++i) {
                if (i == 0) {
                    mStr.append("#");
                    mStr.append(i);
                    continue;
                }
                mStr.append(" and #");
                mStr.append(i);
            }
            info.setMaskString(mStr.toString());
        }
        return info;
    }

    private DefaultKingdeeTreeNode getSubOrgTreeNode(AdminOrgUnitInfo node) throws Exception {
        HashMap nodeMap = HRUtil.getAdminNodeHashMap();
        return (DefaultKingdeeTreeNode)nodeMap.get(node.getId().toString());
    }

    private void addAdminIdsByNode(HashSet set, DefaultKingdeeTreeNode node) {
        String adminId = this.getAdminIdByAdminNode(node);
        if (node.getChildCount() == 0) {
            if (!set.contains(adminId) && !OrgF7InnerUtils.isTreeNodeDisable((DefaultKingdeeTreeNode)node)) {
                set.add(adminId);
            }
        } else {
            int count = node.getChildCount();
            for (int i = 0; i < count; ++i) {
                this.addAdminIdsByNode(set, (DefaultKingdeeTreeNode)node.getChildAt(i));
            }
            if (!set.contains(adminId) && !OrgF7InnerUtils.isTreeNodeDisable((DefaultKingdeeTreeNode)node)) {
                set.add(adminId);
            }
        }
    }

    private String getAdminIdByAdminNode(DefaultKingdeeTreeNode node) {
        AdminOrgUnitInfo adminInfo = (AdminOrgUnitInfo)node.getUserObject();
        if (adminInfo != null) {
            return adminInfo.getId().toString();
        }
        return null;
    }

    public AdminOrgUnitInfo getAdminOrgInfo() {
        return (AdminOrgUnitInfo)this.promptOrg.getData();
    }
}

