/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.benefit.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeManager;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QueryPanelInfo;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.commonquery.client.Util;
import com.kingdee.eas.base.core.client.GetDataDialog;
import com.kingdee.eas.base.core.client.GetDataTaskAdapter;
import com.kingdee.eas.base.core.hr.util.HRParamUtil;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgF7InnerUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.config.TablePreferencesHelper;
import com.kingdee.eas.hr.base.util.HRUtil;
import com.kingdee.eas.hr.base.util.IDCardCommonUtil;
import com.kingdee.eas.hr.benefit.BenefitCommonFacadeFactory;
import com.kingdee.eas.hr.benefit.BenefitException;
import com.kingdee.eas.hr.benefit.BenefitInvokeFacadeFactory;
import com.kingdee.eas.hr.benefit.IBenefitCommonFacade;
import com.kingdee.eas.hr.benefit.IBenefitInvokeFacade;
import com.kingdee.eas.hr.benefit.PersonInfoException;
import com.kingdee.eas.hr.benefit.client.AbstractBenefitCalculateUI;
import com.kingdee.eas.hr.benefit.client.BenefitCaculateUI;
import com.kingdee.eas.hr.benefit.client.BenefitCalcuFilterUI;
import com.kingdee.eas.hr.benefit.client.BenefitEmpTypeFilterUI;
import com.kingdee.eas.hr.benefit.util.BenefitUtils;
import com.kingdee.eas.hr.compensation.CmpPeriodFactory;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.hr.compensation.ICmpPeriod;
import com.kingdee.eas.hr.compensation.util.CompTableStyleUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class BenefitCalculateUI
extends AbstractBenefitCalculateUI {
    private static final long serialVersionUID = 1L;
    private CommonQueryDialog commonQueryDialog;
    private boolean isFirstDefaultQuery = true;
    private String curHROId = null;
    private String accountType = null;
    private String curPeriod = null;
    private String adminOrg = null;
    private boolean includeSubOrg = false;
    private FilterInfo info = null;
    private List infoList = null;
    private String ID = "id";
    private String NAME = "name";
    private String NUMBER = "number";
    private String ADMIN = "admin";
    private String ACCOUNTS = "accounts";
    private String IDCARDNO = "IDCarcNo";
    private String BIRTHDAY = "birthday";
    private String TRANTIME = "tranInsTime";
    private String ACCOUNTID = "accountID";
    private String ACCOUNTDETAILID = "accountDetailID";
    private String BENEFITRULEID = "benefitRuleID";
    private static final String CAL = "Cal";
    private static final String NOT_CAL = "NotCal";
    private boolean isIDCardVerify = false;
    private static final Logger logger = CoreUIObject.getLogger(BenefitCalculateUI.class);
    private Map ruleInfoMap = new HashMap();
    CustomerParams params = new CustomerParams();
    private Map showMap = new HashMap();
    private AdminOrgUnitInfo adminInfo = null;
    private CmpPeriodInfo cmpPeriodInfo = null;
    private String defaultQuerySolutionKey = null;
    CompTableStyleUtil tableStyle = null;

    public void onLoad() throws Exception {
        if (!BenefitUtils.hasInitPeriod()) {
            throw new BenefitException(BenefitException.NO_BENEFIT_PERIOD);
        }
        String hrOrgUnit = SysContext.getSysContext().getCurrentHRUnit().getId().toString();
        this.isIDCardVerify = HRParamUtil.getParamOfHR(null, (String)"IS_IDCARD_VERIFY", (String)hrOrgUnit);
        super.onLoad();
    }

    public void loadFilterUI() throws Exception {
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        String queryName = BenefitCalculateUI.getQueryInfo(this.mainQueryPK).getFullName();
        BenefitCalcuFilterUI filterUI = new BenefitCalcuFilterUI();
        BenefitEmpTypeFilterUI benefitEmpTypeFilterUI = new BenefitEmpTypeFilterUI();
        if (this.isFirstDefaultQuery && iQuery.hasDefaultSolution(this.getMetaDataPK().getFullName(), queryName)) {
            QuerySolutionInfo solution = iQuery.getDefaultSolution(this.getMetaDataPK().getFullName(), queryName);
            this.defaultQuerySolutionKey = solution.getName();
            CustomerParams cp = null;
            QueryPanelInfo queryPanelInfo = BenefitUtils.getQueryPanelInfo(solution.getQueryPanelInfo(), ((Object)((Object)filterUI)).getClass());
            if (queryPanelInfo != null) {
                cp = CustomerParams.getCustomerParams2((String)queryPanelInfo.getCustomerParams());
            }
            CustomerParams cp1 = null;
            queryPanelInfo = BenefitUtils.getQueryPanelInfo(solution.getQueryPanelInfo(), ((Object)((Object)benefitEmpTypeFilterUI)).getClass());
            if (queryPanelInfo != null) {
                cp1 = CustomerParams.getCustomerParams2((String)queryPanelInfo.getCustomerParams());
            }
            if (cp != null) {
                if (!BenefitUtils.hasCurPeriodParams(cp) || !BenefitUtils.hasAdminParams(cp)) {
                    this.showQueryDig(filterUI, benefitEmpTypeFilterUI);
                }
                this.params = cp;
                filterUI.setCustomerParams(cp);
                benefitEmpTypeFilterUI.setCustomerParams(cp1);
                if (this.mainQuery == null) {
                    this.mainQuery = new EntityViewInfo();
                }
                this.adminInfo = filterUI.getAdminOrgInfo();
                FilterInfo filterInfo = benefitEmpTypeFilterUI.getEmpFilterInfo();
                filterInfo.mergeFilter(this.getCustomFilter(cp), "and");
                this.mainQuery.setFilter(filterInfo);
                this.info = this.mainQuery.getFilter();
                FilterInfo infoTmp = null;
                if (solution.getEntityViewInfo() == null) {
                    infoTmp = new FilterInfo();
                } else {
                    EntityViewInfo vi = Util.getInnerFilterInfo((QuerySolutionInfo)solution);
                    infoTmp = vi.getFilter();
                }
                this.infoList = new ArrayList();
                this.infoList.add(this.info);
                if (infoTmp != null && infoTmp.getFilterItems() != null && infoTmp.getFilterItems().size() > 0) {
                    this.infoList.add(infoTmp);
                } else {
                    this.infoList.add(null);
                }
                this.accountType = cp.getCustomerParam("AccountType");
                this.adminOrg = cp.getCustomerParam("adminOrg");
                this.includeSubOrg = cp.getBoolean("chkIncludeSubOrg");
                this.setCurPeriodValue(cp.getCustomerParam("curPeriod"));
                this.fillDataToTable();
                this.tHelper.setQuerySolutionInfo(solution);
            } else {
                this.showQueryDig(filterUI, benefitEmpTypeFilterUI);
            }
            this.isFirstDefaultQuery = false;
            this.fillUserConfig();
        } else {
            this.showQueryDig(filterUI, benefitEmpTypeFilterUI);
            this.fillUserConfig();
        }
    }

    private void showQueryDig(BenefitCalcuFilterUI filterUI, BenefitEmpTypeFilterUI benefitEmpTypeFilterUI) throws Exception {
        if (this.commonQueryDialog == null) {
            this.commonQueryDialog = new CommonQueryDialog();
            this.commonQueryDialog.setHeight(350);
            this.commonQueryDialog.setWidth(420);
            if (this.getUIWindow() == null) {
                this.commonQueryDialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
            } else {
                this.commonQueryDialog.setOwner((Component)((Object)this));
            }
            this.commonQueryDialog.setParentUIClassName(this.getMetaDataPK().getFullName());
            this.commonQueryDialog.setQueryObjectPK(this.mainQueryPK);
            this.commonQueryDialog.setShowFilter(true);
            this.commonQueryDialog.setShowSorter(false);
            this.commonQueryDialog.setShowToolbar(true);
            this.commonQueryDialog.setTitle(EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitResource.TITLE_CALCULATE"));
            this.commonQueryDialog.addUserPanel((KDPanel)filterUI);
            this.commonQueryDialog.addUserPanel((KDPanel)benefitEmpTypeFilterUI);
        }
        if (this.commonQueryDialog.show()) {
            CustomerParams params = ((BenefitCalcuFilterUI)this.commonQueryDialog.getUserPanel(BenefitCalcuFilterUI.class.getName())).getCustomerParams();
            CustomerParams params1 = ((BenefitEmpTypeFilterUI)this.commonQueryDialog.getUserPanel(BenefitEmpTypeFilterUI.class.getName())).getCustomerParams();
            this.params = params;
            filterUI.setCustomerParams(params);
            benefitEmpTypeFilterUI.setCustomerParams(params1);
            this.accountType = params.getCustomerParam("AccountType");
            this.adminOrg = params.getCustomerParam("adminOrg");
            this.includeSubOrg = params.getBoolean("chkIncludeSubOrg");
            this.setCurPeriodValue(params.getCustomerParam("curPeriod"));
            this.info = benefitEmpTypeFilterUI.getEmpFilterInfo();
            this.info.mergeFilter(filterUI.getFilterInfo(params), "and");
            FilterInfo infoTmp = this.commonQueryDialog.getEntityViewInfoResult().getFilter();
            this.infoList = new ArrayList();
            this.infoList.add(this.info);
            this.infoList.add(infoTmp);
            this.fillDataToTable();
            this.tHelper.setDialog(this.commonQueryDialog);
            this.defaultQuerySolutionKey = this.commonQueryDialog.getCurrentSolutionInfo().getName();
        } else {
            SysUtil.abort();
        }
    }

    private void setCurPeriodValue(String cmpID) throws BOSException, EASBizException {
        if (!StringUtils.isEmpty((String)cmpID)) {
            ICmpPeriod icp = CmpPeriodFactory.getRemoteInstance();
            this.cmpPeriodInfo = icp.getCmpPeriodInfo((IObjectPK)new ObjectStringPK(cmpID));
            this.curPeriod = this.cmpPeriodInfo.getId().toString();
            this.txtCmpperiod.setText(this.cmpPeriodInfo.getNumber());
        }
    }

    private FilterInfo getCustomFilter(CustomerParams cp) throws Exception {
        int fSize;
        if (SysContext.getSysContext().getCurrentHRUnit() == null) {
            throw new BenefitException(BenefitException.NO_HRO);
        }
        this.curHROId = SysContext.getSysContext().getCurrentHRUnit().getId().toString();
        FilterInfo filter = new FilterInfo();
        Object set = null;
        String adminId = cp.getCustomerParam("adminOrg");
        boolean includeSubOrg = cp.getBoolean("chkIncludeSubOrg");
        if (!StringUtils.isEmpty((String)adminId)) {
            if (includeSubOrg) {
                filter.getFilterItems().add(new FilterItemInfo("admin.longNumber", (Object)(this.adminInfo.getLongNumber() + "%"), CompareType.LIKE));
            } else {
                filter.getFilterItems().add(new FilterItemInfo("admin.id", (Object)adminId, CompareType.EQUALS));
            }
            filter.getFilterItems().add(new FilterItemInfo("admin.isSealUp", (Object)"0", CompareType.EQUALS));
        }
        String type = cp.getCustomerParam("AccountType");
        filter.getFilterItems().add(new FilterItemInfo("accountType.id", (Object)type));
        filter.getFilterItems().add(new FilterItemInfo("adminToUnit.id", (Object)this.curHROId));
        filter.getFilterItems().add(new FilterItemInfo("user.id", (Object)SysContext.getSysContext().getCurrentUserInfo().getId().toString()));
        String curPeriod = cp.getCustomerParam("curPeriod");
        if (!StringUtils.isEmpty((String)curPeriod)) {
            filter.getFilterItems().add(new FilterItemInfo("curPeriod.id", (Object)curPeriod));
        }
        if ((fSize = filter.getFilterItems().size()) > 1) {
            StringBuffer mStr = new StringBuffer();
            for (int i = 0; i < fSize; ++i) {
                if (i == 0) {
                    mStr.append("#");
                    mStr.append(i);
                    continue;
                }
                mStr.append(" and #");
                mStr.append(i);
            }
            filter.setMaskString(mStr.toString());
        }
        return filter;
    }

    private void addAdminIdsByNode(HashSet set, DefaultKingdeeTreeNode node) {
        String adminId = this.getAdminIdByAdminNode(node);
        if (node.getChildCount() == 0) {
            if (!set.contains(adminId) && !OrgF7InnerUtils.isTreeNodeDisable((DefaultKingdeeTreeNode)node)) {
                set.add(adminId);
            }
        } else {
            int count = node.getChildCount();
            for (int i = 0; i < count; ++i) {
                this.addAdminIdsByNode(set, (DefaultKingdeeTreeNode)node.getChildAt(i));
            }
            if (!set.contains(adminId) && !OrgF7InnerUtils.isTreeNodeDisable((DefaultKingdeeTreeNode)node)) {
                set.add(adminId);
            }
        }
    }

    private String getAdminIdByAdminNode(DefaultKingdeeTreeNode node) {
        AdminOrgUnitInfo adminInfo = (AdminOrgUnitInfo)node.getUserObject();
        if (adminInfo != null) {
            return adminInfo.getId().toString();
        }
        return null;
    }

    private DefaultKingdeeTreeNode getSubOrgTreeNode(AdminOrgUnitInfo node) throws Exception {
        HashMap nodeMap = HRUtil.getAdminNodeHashMap();
        return (DefaultKingdeeTreeNode)nodeMap.get(node.getId().toString());
    }

    public static QueryInfo getQueryInfo(IMetaDataPK queryPK) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        return loader.getQuery(queryPK);
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        this.loadFilterUI();
        this.showMap.clear();
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.fillDataToTable();
    }

    public void actionCalculate_actionPerformed(ActionEvent e) throws Exception {
        super.actionCalculate_actionPerformed(e);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"accountType", (Object)this.accountType);
        uiContext.put((Object)"curPeriod", (Object)this.curPeriod);
        uiContext.put((Object)"adminOrg", (Object)this.adminOrg);
        uiContext.put((Object)"includeSubOrg", (Object)this.includeSubOrg);
        uiContext.put((Object)"personList", (Object)this.getPersonIDList());
        IUIFactory uiFactory = null;
        try {
            uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            IUIWindow curUI = uiFactory.create(BenefitCaculateUI.class.getName(), (Map)uiContext);
            curUI.show();
            if (((BenefitCaculateUI)curUI.getUIObject()).getIsCancel() || curUI.close() && !((BenefitCaculateUI)curUI.getUIObject()).getIsSubmit()) {
                return;
            }
        }
        catch (UIException ex1) {
            this.handleException((Exception)((Object)ex1));
        }
        GetDataDialog dlg = new GetDataDialog((Frame)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        dlg.setGetDataTask(new GetDataTaskAdapter(){

            public Object exec() throws Exception {
                BenefitCalculateUI.this.calculateData();
                return null;
            }
        });
        dlg.show();
    }

    private HashMap saveDataByRule() throws Exception {
        IRow row = null;
        String personID = null;
        HashMap<String, AbstractCollection> dataMap = new HashMap<String, AbstractCollection>();
        ArrayList<Object> dataList = null;
        HashMap<String, BigDecimal> radixMap = null;
        String[] tmp = null;
        String benefitID = null;
        String benefitNumber = null;
        BigDecimal radixValue = null;
        IBenefitInvokeFacade ibnf = BenefitInvokeFacadeFactory.getRemoteInstance();
        List list = this.getBenefitAndItemData(this.accountType, ibnf);
        List benefit = (List)list.get(0);
        HashSet<String> ruleSet = new HashSet<String>();
        int rs = this.tblMain.getRowCount3();
        for (int i = 0; i < rs; ++i) {
            row = this.tblMain.getRow(i);
            if (row.getCell(this.ID).getValue() == null || row.getCell(this.BENEFITRULEID).getValue() == null || "null".equals(row.getCell(this.BENEFITRULEID).getValue())) continue;
            personID = row.getCell(this.ID).getValue().toString();
            dataList = new ArrayList<Object>();
            dataList.add(0, row.getCell(this.ACCOUNTID).getValue().toString());
            dataList.add(1, row.getCell(this.ACCOUNTDETAILID).getValue().toString());
            dataList.add(2, row.getCell(this.BENEFITRULEID).getValue().toString());
            ruleSet.add(row.getCell(this.BENEFITRULEID).getValue().toString());
            radixMap = new HashMap<String, BigDecimal>();
            int bs = benefit.size();
            for (int j = 0; j < bs; ++j) {
                tmp = benefit.get(j).toString().split("@");
                benefitID = tmp[0];
                benefitNumber = tmp[2];
                radixValue = row.getCell(benefitID + "@" + "Base_insu").getValue() != null ? new BigDecimal(row.getCell(benefitID + "@" + "Base_insu").getValue().toString()) : BenefitUtils.ZERO_BIGDECIMAL;
                radixMap.put(benefitNumber, radixValue);
            }
            dataList.add(3, radixMap);
            if (row.getCell(this.IDCARDNO).getValue() != null) {
                dataList.add(4, row.getCell(this.IDCARDNO).getValue().toString());
            } else {
                dataList.add(4, "");
            }
            dataMap.put(personID, dataList);
        }
        dataMap.put("ruleSet", ruleSet);
        return dataMap;
    }

    private void calculateData() throws Exception {
        HashMap map = this.saveDataByRule();
        IBenefitInvokeFacade ibnf = BenefitInvokeFacadeFactory.getRemoteInstance();
        long startTime = System.currentTimeMillis();
        try {
            ibnf.calcuBenefit(this.accountType, this.getPersonIDList(), this.curPeriod, map);
        }
        catch (PersonInfoException e) {
            MsgBox.showError((Component)((Object)this), (String)e.getMessage());
            return;
        }
        catch (EASBizException e) {
            MsgBox.showError((Component)((Object)this), (String)e.getMessage());
            return;
        }
        catch (BOSException e) {
            throw e;
        }
        long endTime = System.currentTimeMillis();
        System.out.println("ibnf.calcuBenefit:" + (endTime - startTime));
        this.fillDataToTable();
        System.out.println("fillDataToTable:" + (System.currentTimeMillis() - endTime));
        this.showMessage();
    }

    protected String getMessageText() {
        return EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitCommonResource.CALCULATE_FINISH");
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.txtCmpperiod.setEditable(false);
        this.btnCalculate.setIcon(EASResource.getIcon((String)"imgTbtn_autocount"));
        this.btnCalculate.setEnabled(true);
        this.btnQuery.setEnabled(true);
        this.btnRefresh.setEnabled(true);
        this.btnRefresh.setToolTipText(this.resHelper.getString("btnRefresh.text"));
        this.btnLocate.setToolTipText(this.resHelper.getString("btnLocate.text"));
        this.btnQuery.setToolTipText(this.resHelper.getString("btnQuery.text"));
        this.menuItemCalculate.setIcon(EASResource.getIcon((String)"imgTbtn_autocount"));
    }

    private void fillDataToTable() throws Exception {
        Object tmp;
        int baseColumn;
        IBenefitCommonFacade benefitCommonFacade = BenefitCommonFacadeFactory.getRemoteInstance();
        String hrOrgUnit = null;
        if (SysContext.getSysContext().getCurrentHRUnit() != null) {
            hrOrgUnit = SysContext.getSysContext().getCurrentHRUnit().getId().toString();
        }
        IBenefitInvokeFacade ibnf = BenefitInvokeFacadeFactory.getRemoteInstance();
        List list = this.getBenefitAndItemData(this.accountType, ibnf);
        List benefit = (List)list.get(0);
        List item = (List)list.get(1);
        int mergeColNum = item.size() - 2;
        item.remove(EASResource.getString((String)"com.kingdee.eas.hr.benefit.BENEFITAutoGenerateResource", (String)"40_BenefitCalculateUI"));
        item.remove(EASResource.getString((String)"com.kingdee.eas.hr.benefit.BENEFITAutoGenerateResource", (String)"41_BenefitCalculateUI"));
        item.add(EASResource.getString((String)"com.kingdee.eas.hr.benefit.BENEFITAutoGenerateResource", (String)"42_BenefitCalculateUI"));
        item.add(EASResource.getString((String)"com.kingdee.eas.hr.benefit.BENEFITAutoGenerateResource", (String)"43_BenefitCalculateUI"));
        item.add(EASResource.getString((String)"com.kingdee.eas.hr.benefit.BENEFITAutoGenerateResource", (String)"44_BenefitCalculateUI"));
        item.add(EASResource.getString((String)"com.kingdee.eas.hr.benefit.BENEFITAutoGenerateResource", (String)"45_BenefitCalculateUI"));
        item.add(EASResource.getString((String)"com.kingdee.eas.hr.benefit.BENEFITAutoGenerateResource", (String)"46_BenefitCalculateUI"));
        item.add(EASResource.getString((String)"com.kingdee.eas.hr.benefit.BENEFITAutoGenerateResource", (String)"47_BenefitCalculateUI"));
        int itemSize = item.size();
        KDTMergeManager mm = this.tblMain.getHeadMergeManager();
        this.tblMain.checkParsed();
        this.tblMain.removeRows();
        int col = baseColumn = 11;
        for (int size = this.tblMain.getColumnCount(); col < size; --size) {
            this.tblMain.removeColumn(size - 1);
        }
        int s0 = benefit.size();
        for (int i = 0; i < s0; ++i) {
            String[] tmp1 = benefit.get(i).toString().split("@");
            String beneID = tmp1[0];
            String beneName = tmp1[1];
            int s1 = itemSize;
            for (int j = 0; j < s1; ++j) {
                String[] tmp2 = item.get(j).toString().split("@");
                String itNumber = tmp2[0];
                String itName = tmp2[1];
                IColumn iCol = this.tblMain.addColumn();
                iCol.getStyleAttributes().setLocked(true);
                iCol.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                String key = beneID + "@" + itNumber;
                iCol.setKey(key);
                if (itNumber.equals("Emp_Sum_radix") || itNumber.equals("Com_Sum_radix") || itNumber.equals("Total_radix")) {
                    iCol.getStyleAttributes().setNumberFormat("0.00%");
                } else {
                    iCol.getStyleAttributes().setNumberFormat("#,##0.00");
                }
                if (itNumber.equals("Base_insu") || itNumber.equals("Emp_Sum_radix") || itNumber.equals("Com_Sum_radix") || itNumber.equals("Total_radix")) {
                    iCol.setUserObject((Object)NOT_CAL);
                } else {
                    iCol.setUserObject((Object)CAL);
                }
                this.tblMain.getHeadRow(2).getCell(iCol.getColumnIndex()).setValue((Object)itName);
            }
            for (int k = 0; k < mergeColNum; ++k) {
                mm.mergeBlock(1, baseColumn + i * itemSize + k, 2, baseColumn + i * itemSize + k);
            }
            for (int m = mergeColNum; m < itemSize; m += 2) {
                mm.mergeBlock(1, baseColumn + i * itemSize + m, 1, baseColumn + i * itemSize + m + 1);
            }
            this.tblMain.getHeadRow(1).getCell(baseColumn + i * itemSize + mergeColNum).setValue((Object)EASResource.getString((String)"com.kingdee.eas.hr.benefit.BENEFITAutoGenerateResource", (String)"48_BenefitCalculateUI"));
            this.tblMain.getHeadRow(1).getCell(baseColumn + i * itemSize + mergeColNum + 2).setValue((Object)EASResource.getString((String)"com.kingdee.eas.hr.benefit.BENEFITAutoGenerateResource", (String)"49_BenefitCalculateUI"));
            this.tblMain.getHeadRow(1).getCell(baseColumn + i * itemSize + mergeColNum + 4).setValue((Object)EASResource.getString((String)"com.kingdee.eas.hr.benefit.BENEFITAutoGenerateResource", (String)"50_BenefitCalculateUI"));
            mm.mergeBlock(0, i * itemSize + baseColumn, 0, (i + 1) * itemSize + baseColumn - 1);
            this.tblMain.getHeadRow(0).getCell(i * itemSize + baseColumn).setValue((Object)beneName);
        }
        HashMap<String, Integer> columnMap = new HashMap<String, Integer>();
        int columnCount = this.tblMain.getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            columnMap.put(this.tblMain.getColumn(i).getKey(), new Integer(i));
        }
        HashMap result = ibnf.getBenefitCalcuteData(this.infoList, this.accountType, this.curPeriod);
        List person = (List)result.get("personid");
        this.tblMain.setRowCount(person.size());
        Map ruleMap = BenefitUtils.getBenefitRuleItem(null, null);
        HashMap mapPersonInfo = (HashMap)result.get("personInfo");
        HashMap mapData = (HashMap)result.get("personData");
        HashMap baseMap = (HashMap)mapData.get("Base_insu");
        HashMap radixMap = (HashMap)result.get("radixInfo");
        String name = null;
        String number = null;
        String admin = null;
        String accounts = null;
        String idcardno = null;
        String tranTime = null;
        String birthday = null;
        String accountID = null;
        String accountDetailID = null;
        String benefitRuleID = null;
        String[] keys = null;
        ICell tempCell = null;
        int ss = person.size();
        for (int k = 0; k < ss; ++k) {
            this.tblMain.addRow();
            String[] tmp3 = mapPersonInfo.get(person.get(k).toString()).toString().split("@_@");
            name = tmp3[0];
            number = tmp3[1];
            admin = tmp3[2];
            accounts = tmp3[3];
            idcardno = tmp3[4];
            birthday = this.getBirthdayByIDCardNo(idcardno);
            tranTime = tmp3[5];
            accountID = tmp3[6];
            accountDetailID = tmp3[7];
            benefitRuleID = tmp3[8];
            if (tranTime == null || tranTime.equals("null")) {
                tranTime = "";
            } else {
                String[] tmp2 = tranTime.toString().split(" ");
                tranTime = tmp2[0];
            }
            if (idcardno == null || idcardno.equals("null")) {
                idcardno = null;
            }
            this.tblMain.getCell(k, ((Integer)columnMap.get(this.ID)).intValue()).setValue(person.get(k));
            this.tblMain.getCell(k, ((Integer)columnMap.get(this.NAME)).intValue()).setValue((Object)name);
            this.tblMain.getCell(k, ((Integer)columnMap.get(this.NUMBER)).intValue()).setValue((Object)number);
            this.tblMain.getCell(k, ((Integer)columnMap.get(this.ADMIN)).intValue()).setValue((Object)admin);
            this.tblMain.getCell(k, ((Integer)columnMap.get(this.ACCOUNTS)).intValue()).setValue((Object)accounts);
            this.tblMain.getCell(k, ((Integer)columnMap.get(this.IDCARDNO)).intValue()).setValue((Object)idcardno);
            this.tblMain.getCell(k, ((Integer)columnMap.get(this.BIRTHDAY)).intValue()).setValue((Object)birthday);
            this.tblMain.getCell(k, ((Integer)columnMap.get(this.TRANTIME)).intValue()).setValue((Object)tranTime);
            this.tblMain.getCell(k, ((Integer)columnMap.get(this.ACCOUNTID)).intValue()).setValue((Object)accountID);
            this.tblMain.getCell(k, ((Integer)columnMap.get(this.ACCOUNTDETAILID)).intValue()).setValue((Object)accountDetailID);
            this.tblMain.getCell(k, ((Integer)columnMap.get(this.BENEFITRULEID)).intValue()).setValue((Object)benefitRuleID);
            int s02 = benefit.size();
            for (int i = 0; i < s02; ++i) {
                String[] tmp1 = benefit.get(i).toString().split("@");
                String beneID = tmp1[0];
                boolean temp = false;
                int s1 = itemSize;
                for (int j = 0; j < s1; ++j) {
                    String value = null;
                    String[] tmp2 = item.get(j).toString().split("@");
                    String itNumber = tmp2[0];
                    String key = beneID + "@" + itNumber;
                    value = itNumber.equals("Base_insu") ? (baseMap == null || baseMap != null && baseMap.get(person.get(k) + "@" + beneID) == null ? "0" : baseMap.get(person.get(k) + "@" + beneID).toString()) : ((tmp = (HashMap)mapData.get(person.get(k) + "@" + beneID)) == null || tmp != null && ((HashMap)tmp).get(itNumber) == null ? "0" : ((HashMap)tmp).get(itNumber).toString());
                    if (value.startsWith("0E-")) {
                        value = "0";
                    }
                    tempCell = this.tblMain.getCell(k, ((Integer)columnMap.get(key)).intValue());
                    tempCell.setValue((Object)new BigDecimal(value));
                    keys = key.split("@");
                    temp = BenefitUtils.setCellStyleByRule(ruleMap, benefitRuleID, keys[0], keys[1], tempCell, this.showMap, key, temp);
                }
                BigDecimal perValue = (BigDecimal)this.tblMain.getCell(k, baseColumn + i * itemSize + mergeColNum + 1).getValue();
                BigDecimal comValue = (BigDecimal)this.tblMain.getCell(k, baseColumn + i * itemSize + mergeColNum + 3).getValue();
                if (perValue == null) {
                    perValue = new BigDecimal(0);
                }
                if (comValue == null) {
                    comValue = new BigDecimal(0);
                }
                this.tblMain.getCell(k, baseColumn + i * itemSize + mergeColNum + 5).setValue((Object)perValue.add(comValue));
                if (!temp) continue;
                this.tblMain.getCell(k, baseColumn + i * itemSize + mergeColNum + 5).getStyleAttributes().setNumberFormat("#,##0.000");
                this.showMap.put(beneID + "@Total_value", "true");
            }
        }
        int beneSize = benefit.size();
        for (int i = 0; i < beneSize; ++i) {
            BigDecimal totalradix;
            BigDecimal comradix;
            BigDecimal perradix;
            List tmpList;
            String pid;
            String benefitNum;
            block37: {
                String[] tmp1 = benefit.get(i).toString().split("@");
                benefitNum = tmp1[2].toString();
                pid = null;
                tmpList = null;
                perradix = null;
                comradix = null;
                totalradix = null;
                if (!benefitNum.equals("Insu002")) break block37;
                boolean FLAG = false;
                String IDCardNo = null;
                int rowsize = person.size();
                for (int row = 0; row < rowsize; ++row) {
                    block38: {
                        block40: {
                            int perAge;
                            block39: {
                                perAge = 0;
                                IDCardNo = null;
                                perradix = null;
                                comradix = null;
                                totalradix = null;
                                pid = this.tblMain.getCell(row, ((Integer)columnMap.get(this.ID)).intValue()).getValue().toString();
                                tmpList = (List)radixMap.get(pid + "@" + benefitNum);
                                if (tmpList == null || tmpList.size() <= 0) break block38;
                                perradix = (BigDecimal)tmpList.get(0);
                                tempCell = this.tblMain.getCell(row, ((Integer)columnMap.get(this.IDCARDNO)).intValue());
                                if (tempCell.getValue() != null) {
                                    IDCardNo = tempCell.getValue().toString();
                                }
                                if ((perAge = this.calcuAgeByIDCardNo(IDCardNo)) != -1) break block39;
                                if (tmpList.get(tmpList.size() - 2) == null) break block40;
                                tmp = tmpList.get(tmpList.size() - 2).toString().split("@");
                                comradix = new BigDecimal(tmp[2]);
                                break block40;
                            }
                            int lsize = tmpList.size() - 1;
                            for (int j = 1; j < lsize; ++j) {
                                if (tmpList.get(j) == null) continue;
                                String[] tmp3 = tmpList.get(j).toString().split("@");
                                if (Integer.parseInt(tmp3[0]) == 0 && perAge > Integer.parseInt(tmp3[1])) {
                                    comradix = new BigDecimal(tmp3[2]);
                                    break;
                                }
                                if (Integer.parseInt(tmp3[0]) != 1 || perAge < Integer.parseInt(tmp3[1])) continue;
                                comradix = new BigDecimal(tmp3[2]);
                                break;
                            }
                        }
                        if (tmpList.get(tmpList.size() - 1) != null && "TRUE_FLAG".equals((String)tmpList.get(tmpList.size() - 1))) {
                            FLAG = true;
                        }
                    }
                    String perradixTmp = null;
                    String comradixTmp = null;
                    String totalradixTmp = null;
                    if (FLAG && perradix != null && comradix != null) {
                        perradixTmp = perradix.toString() + "%";
                        comradixTmp = comradix.toString() + "%";
                        totalradix = perradix.add(comradix);
                        totalradixTmp = totalradix.toString() + "%";
                    } else {
                        if (perradix != null) {
                            perradixTmp = perradix.toString() + "%";
                        }
                        if (comradix != null) {
                            comradixTmp = comradix.toString() + "%";
                        }
                    }
                    this.tblMain.getCell(row, baseColumn + i * itemSize + mergeColNum).setValue((Object)perradixTmp);
                    this.tblMain.getCell(row, baseColumn + i * itemSize + mergeColNum + 2).setValue((Object)comradixTmp);
                    this.tblMain.getCell(row, baseColumn + i * itemSize + mergeColNum + 4).setValue((Object)totalradixTmp);
                }
                continue;
            }
            int rowsize = person.size();
            for (int row = 0; row < rowsize; ++row) {
                boolean FLAG = false;
                perradix = null;
                comradix = null;
                totalradix = null;
                pid = this.tblMain.getCell(row, ((Integer)columnMap.get(this.ID)).intValue()).getValue().toString();
                tmpList = (List)radixMap.get(pid + "@" + benefitNum);
                if (tmpList != null && tmpList.size() > 0) {
                    perradix = (BigDecimal)tmpList.get(0);
                    comradix = (BigDecimal)tmpList.get(1);
                    if (tmpList.get(tmpList.size() - 1) != null && "TRUE_FLAG".equals((String)tmpList.get(tmpList.size() - 1))) {
                        FLAG = true;
                    }
                }
                String perradixTmp = null;
                String comradixTmp = null;
                String totalradixTmp = null;
                if (FLAG && perradix != null && comradix != null) {
                    perradixTmp = perradix.toString() + "%";
                    comradixTmp = comradix.toString() + "%";
                    totalradix = perradix.add(comradix);
                    totalradixTmp = totalradix.toString() + "%";
                } else {
                    if (perradix != null) {
                        perradixTmp = perradix.toString() + "%";
                    }
                    if (comradix != null) {
                        comradixTmp = comradix.toString() + "%";
                    }
                }
                this.tblMain.getCell(row, baseColumn + i * itemSize + mergeColNum).setValue((Object)perradixTmp);
                this.tblMain.getCell(row, baseColumn + i * itemSize + mergeColNum + 2).setValue((Object)comradixTmp);
                this.tblMain.getCell(row, baseColumn + i * itemSize + mergeColNum + 4).setValue((Object)totalradixTmp);
            }
        }
        this.addTotalRow();
    }

    private void addTotalRow() {
        IRow totalRow = this.tblMain.addRow();
        totalRow.getStyleAttributes().setBackground(new Color(246, 246, 191));
        this.tblMain.getCell(this.tblMain.getRowCount3(), 1).setValue((Object)EASResource.getString((String)"com.kingdee.eas.hr.benefit.client.FormDetailResource.NAME_ITEM_TOTAL"));
        int size = this.tblMain.getColumnCount() - 8;
        int baseCol = this.tblMain.getColumnIndex(this.TRANTIME);
        int countSize = this.tblMain.getRowCount3();
        IColumn col = null;
        ICell cell = null;
        IRow row = null;
        BigDecimal value = null;
        for (int i = 0; i < size; ++i) {
            if ((col = this.tblMain.getColumn(++baseCol)).getUserObject() == null) continue;
            if (col.getUserObject().toString().equals(CAL)) {
                BigDecimal sum = new BigDecimal(0);
                for (int j = 0; j < countSize; ++j) {
                    row = this.tblMain.getRow(j);
                    cell = row.getCell(baseCol);
                    if (cell.getValue() == null) continue;
                    value = StringUtils.isEmpty((String)cell.getValue().toString()) || cell.getValue().toString().startsWith("0E-") ? new BigDecimal(0) : new BigDecimal(cell.getValue().toString());
                    sum = sum.add(value);
                }
                this.tblMain.getCell(countSize, baseCol).setValue((Object)sum);
                if (!this.showMap.containsKey(col.getKey())) continue;
                this.tblMain.getCell(countSize, baseCol).getStyleAttributes().setNumberFormat("#,##0.000");
                continue;
            }
            if (!NOT_CAL.equals(col.getUserObject().toString())) continue;
            this.tblMain.getCell(countSize, baseCol).setValue((Object)"------");
        }
        this.tblMain.setRowCount(this.tblMain.getRowCount() + 1);
    }

    private List getBenefitAndItemData(String accountType, IBenefitInvokeFacade ibnf) throws BOSException, EASBizException {
        List beneList = ibnf.getBenefitList(accountType);
        return beneList;
    }

    private String getBirthdayByIDCardNo(String strCarcNo) {
        if (StringUtils.isEmpty((String)strCarcNo) || strCarcNo.equals("null")) {
            return null;
        }
        String birthday = null;
        try {
            IDCardCommonUtil iDCardCommonUtil = null;
            if (this.isIDCardVerify) {
                iDCardCommonUtil = new IDCardCommonUtil(strCarcNo);
                birthday = iDCardCommonUtil.getBirthday();
            }
            return birthday;
        }
        catch (Exception e) {
            return null;
        }
    }

    private int calcuAgeByIDCardNo(String strCarcNo) {
        int age;
        block4: {
            age = -1;
            if (!StringUtils.isEmpty((String)strCarcNo) && !strCarcNo.equals("null")) {
                try {
                    IDCardCommonUtil iDCardCommonUtil = null;
                    if (this.isIDCardVerify) {
                        iDCardCommonUtil = new IDCardCommonUtil(strCarcNo);
                        int birthYear = Integer.parseInt(iDCardCommonUtil.getBirthday().substring(0, 4));
                        int birthMonth = Integer.parseInt(iDCardCommonUtil.getBirthday().substring(5, 7));
                        int birthDay = Integer.parseInt(iDCardCommonUtil.getBirthday().substring(8, 10));
                        int nowYear = Calendar.getInstance().get(1);
                        int nowMonth = Calendar.getInstance().get(2) + 1;
                        int nowDay = Calendar.getInstance().get(5);
                        age = nowMonth > birthMonth ? nowYear - birthYear : (nowMonth < birthMonth ? nowYear - birthYear - 1 : (nowDay >= birthDay ? nowYear - birthYear : nowYear - birthYear - 1));
                        break block4;
                    }
                    return -1;
                }
                catch (Exception e) {
                    return -1;
                }
            }
        }
        return age;
    }

    private List getPersonIDList() {
        ArrayList<String> list = new ArrayList<String>();
        IRow row = null;
        String personID = null;
        int size = this.tblMain.getRowCount3();
        for (int i = 0; i < size; ++i) {
            row = this.tblMain.getRow(i);
            if (row.getCell(this.ID).getValue() == null) continue;
            personID = row.getCell(this.ID).getValue().toString();
            list.add(personID);
        }
        return list;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    protected String getEditUIName() {
        return null;
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    protected void tblMain_doRequestRowSet(RequestRowSetEvent e) {
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    protected void fillUserConfig() {
        if (this.tableStyle == null) {
            this.tableStyle = new CompTableStyleUtil();
            this.tableStyle.setTableFullName("com.kingdee.eas.hr.benefit.client.BenefitCalculateUI.tblMain");
            this.tableStyle.setTblMain(this.tblMain);
        }
        this.tableStyle.setTHelper((TablePreferencesHelper)this.tHelper);
        this.tableStyle.fillUserConfig();
    }

    protected void setThelper() {
        this.setQueryPreference(true);
    }

    public Object getTablePreferenceSchemaKey() {
        String key = null;
        if (this.commonQueryDialog == null || this.commonQueryDialog.getCurrentSolutionInfo() == null) {
            return this.defaultQuerySolutionKey;
        }
        key = this.commonQueryDialog.getCurrentSolutionInfo().getName();
        return key;
    }

    protected void execQuery() {
        this.tblMain.repaint();
    }
}

