/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.benefit.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.hr.benefit.BenefitException;
import com.kingdee.eas.hr.benefit.BenefitFactory;
import com.kingdee.eas.hr.benefit.BenefitInfo;
import com.kingdee.eas.hr.benefit.IBenefit;
import com.kingdee.eas.hr.benefit.client.AbstractBenefitListUI;
import com.kingdee.eas.hr.benefit.client.BenefitEditUI;
import com.kingdee.eas.hr.benefit.util.BenefitUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class BenefitListUI
extends AbstractBenefitListUI {
    private static final Logger logger = CoreUIObject.getLogger(BenefitListUI.class);

    public void onLoad() throws Exception {
        if (!BenefitUtils.hasInitPeriod()) {
            throw new BenefitException(BenefitException.NO_BENEFIT_PERIOD);
        }
        this.addHROrgUtil();
        super.onLoad();
        this.tblMain.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent kde) {
                int index = kde.getSelectBlock().getTop();
                IRow irow = BenefitListUI.this.tblMain.getRow(index);
                if (((Boolean)irow.getCell("state").getValue()).booleanValue()) {
                    BenefitListUI.this.actionEnable.setEnabled(false);
                    BenefitListUI.this.actionUnEnable.setEnabled(true);
                } else {
                    BenefitListUI.this.actionEnable.setEnabled(true);
                    BenefitListUI.this.actionUnEnable.setEnabled(false);
                }
            }
        });
        this.initTblMainColWidth();
    }

    private void initTblMainColWidth() {
        int size = this.tblMain.getColumnCount();
        for (int i = 0; i < size; ++i) {
            this.tblMain.getColumn(i).setWidth(200);
        }
    }

    private void addHROrgUtil() {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)SysContext.getSysContext().getCurrentHRUnit().getId().toString()));
        viewInfo.setFilter(filterInfo);
        this.mainQuery = viewInfo;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnEnable.setIcon(EASResource.getIcon((String)"imgTbtn_staruse"));
        this.btnUnEnable.setIcon(EASResource.getIcon((String)"imgTbtn_forbid"));
        this.actionEnable.setEnabled(true);
        this.actionUnEnable.setEnabled(true);
        this.menuItemQuery.setVisible(false);
        this.menuItemImportData.setVisible(false);
    }

    public void actionEnable_actionPerformed(ActionEvent e) throws Exception {
        IBenefit iBenefit = (IBenefit)this.getBizInterface();
        this.checkSelected();
        IObjectPK logPK = LogUtil.beginLog(null, (String)"", (BOSObjectType)new BenefitInfo().getBOSType(), null, (String)EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitResource.BenefitQueryF7WindowTitle"), (String)"Benefit_state");
        iBenefit.setBatchEnable(this.getSelectedIdValues());
        LogUtil.afterLog(null, (IObjectPK)logPK);
        this.tblMain.refresh();
        super.actionEnable_actionPerformed(e);
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitCommonResource.ENABLE_SUCC"));
    }

    public void actionUnEnable_actionPerformed(ActionEvent e) throws Exception {
        IBenefit iBenefit = (IBenefit)this.getBizInterface();
        this.checkSelected();
        IObjectPK logPK = LogUtil.beginLog(null, (String)"", (BOSObjectType)new BenefitInfo().getBOSType(), null, (String)EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitResource.BenefitQueryF7WindowTitle"), (String)"Benefit_state");
        iBenefit.setBatchUnEnable(this.getSelectedIdValues());
        LogUtil.afterLog(null, (IObjectPK)logPK);
        this.tblMain.refresh();
        super.actionUnEnable_actionPerformed(e);
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitCommonResource.UNENABLE_SUCC"));
    }

    public void loadFields() {
        super.loadFields();
    }

    public void storeFields() {
        super.storeFields();
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
    }

    protected String getEditUIName() {
        return BenefitEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BenefitFactory.getRemoteInstance();
    }

    protected IObjectValue createNewData() {
        BenefitInfo objectValue = new BenefitInfo();
        return objectValue;
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.WELFARE;
    }
}

