/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.benefit.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.hr.benefit.EmpManagerFacadeFactory;
import com.kingdee.eas.hr.benefit.IEmpManagerFacade;
import com.kingdee.eas.hr.benefit.client.AbstractBenefitQueryQueryPanelUI;
import com.kingdee.eas.hr.benefit.util.BenefitUtils;
import com.kingdee.eas.hr.benefit.util.BenefitVerifyUtils;
import com.kingdee.eas.hr.benefit.util.CommonQueryUtil;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.event.ItemEvent;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import javax.swing.event.ChangeEvent;

public class BenefitQueryQueryPanelUI
extends AbstractBenefitQueryQueryPanelUI {
    private static final long serialVersionUID = 1L;

    public void onLoad() throws Exception {
        super.onLoad();
        this.prmtCurPeriod.setEnabled(false);
        this.prmtFromPeriod.setEnabled(false);
        this.prmtToPeriod.setEnabled(false);
        BenefitUtils.initF7Selector(this, this.prmtAdminOrgUnit);
    }

    private void setSelector(EntityViewInfo evi, KDBizPromptBox prmt) {
        prmt.setQueryInfo("com.kingdee.eas.hr.compensation.app.F7CmpPeriodQuery");
        prmt.setDisplayFormat("$number$");
        prmt.setEditFormat("$number$");
        prmt.setCommitFormat("$number$");
        prmt.setEntityViewInfo(evi);
        prmt.setEditable(true);
    }

    protected void prmtAdminOrgUnit_stateChanged(ChangeEvent e) throws Exception {
        this.setCurPeriodPrompt();
    }

    protected void includeSubOrg_itemStateChanged(ItemEvent e) throws Exception {
        this.setCurPeriodPrompt();
    }

    private void setCurPeriodPrompt() throws EASBizException, BOSException {
        if (this.prmtAdminOrgUnit.getData() == null) {
            this.prmtCurPeriod.setData(null);
            this.prmtCurPeriod.setEnabled(false);
        } else {
            this.prmtCurPeriod.setQueryInfo("com.kingdee.eas.hr.compensation.app.F7CmpPeriodQuery");
            this.prmtCurPeriod.setDisplayFormat("$number$");
            this.prmtCurPeriod.setEditFormat("$number$");
            this.prmtCurPeriod.setCommitFormat("$number$");
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)SysContext.getSysContext().getCurrentHRUnit().getId()));
            AdminOrgUnitInfo admin = (AdminOrgUnitInfo)this.prmtAdminOrgUnit.getData();
            IEmpManagerFacade iemf = EmpManagerFacadeFactory.getRemoteInstance();
            Map map = iemf.getPeriodCollection(admin.getId().toString(), this.includeSubOrg.isSelected(), null);
            Set set = (Set)map.get("periodset");
            CmpPeriodInfo beginInfo = (CmpPeriodInfo)map.get("CmpPeriodInfo");
            if (set != null && set.size() > 0) {
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)set, CompareType.INCLUDE));
                filter.setMaskString("#0 and #1");
                this.prmtCurPeriod.setData((Object)beginInfo);
                this.prmtCurPeriod.setEnabled(true);
            } else {
                this.prmtCurPeriod.setData(null);
                this.prmtCurPeriod.setEnabled(false);
            }
            evi.setFilter(filter);
            this.prmtCurPeriod.setEntityViewInfo(evi);
        }
    }

    protected void prmtCurPeriod_stateChanged(ChangeEvent e) throws Exception {
        this.prmtFromPeriod.setData(null);
        this.prmtToPeriod.setData(null);
        if (this.prmtCurPeriod.getData() == null) {
            this.prmtFromPeriod.setEnabled(false);
            this.prmtToPeriod.setEnabled(false);
        } else {
            this.prmtFromPeriod.setEnabled(true);
            this.prmtToPeriod.setEnabled(true);
            CmpPeriodInfo curPeriodInfo = (CmpPeriodInfo)this.prmtCurPeriod.getData();
            CmpPeriodInfo initInfo = BenefitUtils.getInitPeriod();
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)SysContext.getSysContext().getCurrentHRUnit().getId()));
            filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)curPeriodInfo.getBeginDate(), CompareType.LESS_EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)initInfo.getBeginDate(), CompareType.GREATER_EQUALS));
            filter.setMaskString("#0 and #1 and #2");
            evi.setFilter(filter);
            this.setSelector(evi, this.prmtFromPeriod);
            this.setSelector(evi, this.prmtToPeriod);
        }
    }

    public boolean verify() {
        if (!BenefitVerifyUtils.adminOrgNotNullVerify(this.prmtAdminOrgUnit)) {
            return false;
        }
        if (!BenefitVerifyUtils.curPeriodNotNullVerify(this.prmtCurPeriod)) {
            return false;
        }
        if (!BenefitVerifyUtils.beginPeriodNotNullVerify(this.prmtFromPeriod)) {
            return false;
        }
        if (!BenefitVerifyUtils.endPeriodNotNullVerify(this.prmtToPeriod)) {
            return false;
        }
        CmpPeriodInfo beginCmp = (CmpPeriodInfo)this.prmtFromPeriod.getValue();
        CmpPeriodInfo endCmp = (CmpPeriodInfo)this.prmtToPeriod.getValue();
        if (DateTimeUtils.dayBefore((Date)endCmp.getBeginDate(), (Date)beginCmp.getEndDate()) && !DateTimeUtils.dayEquals((Date)endCmp.getBeginDate(), (Date)beginCmp.getBeginDate())) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitCommonResource.TOCMP_FROMCMP_INVALID"));
            return false;
        }
        return super.verify();
    }

    public void loadFields() {
        super.loadFields();
    }

    public void storeFields() {
        super.storeFields();
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        CommonQueryUtil.getAdminFromQueryPanel(cp, this.prmtAdminOrgUnit);
        cp.putBoolean("includeSubOrg", this.includeSubOrg.isSelected());
        CommonQueryUtil.getCmpFromQueryPanel("curPeriod", cp, this.prmtCurPeriod);
        CommonQueryUtil.getCmpFromQueryPanel("beginPeriod", cp, this.prmtFromPeriod);
        CommonQueryUtil.getCmpFromQueryPanel("endPeriod", cp, this.prmtToPeriod);
        return cp;
    }

    public void setCustomerParams(CustomerParams cp) {
        if (cp == null) {
            return;
        }
        CommonQueryUtil.setAdminFromQueryPanel(cp, this.prmtAdminOrgUnit);
        this.includeSubOrg.setSelected(cp.getBoolean("includeSubOrg"));
        CommonQueryUtil.setCmpFromQueryPanel("curPeriod", cp, this.prmtCurPeriod);
        CommonQueryUtil.setCmpFromQueryPanel("beginPeriod", cp, this.prmtFromPeriod);
        CommonQueryUtil.setCmpFromQueryPanel("endPeriod", cp, this.prmtToPeriod);
    }

    public void clear() {
        super.clear();
        this.prmtAdminOrgUnit.setData(null);
        this.prmtCurPeriod.setData(null);
        this.prmtFromPeriod.setData(null);
        this.prmtToPeriod.setData(null);
        this.includeSubOrg.setSelected(false);
    }

    public FilterInfo getCustomerFilterInfo(CustomerParams cp) throws BOSException, EASBizException {
        String adminOrg;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("adminToUnit.id", (Object)SysContext.getSysContext().getCurrentHRUnit().getId().toString()));
        String curPeriod = cp.getCustomerParam("curPeriod");
        if (!StringUtils.isEmpty((String)curPeriod)) {
            filter.getFilterItems().add(new FilterItemInfo("curPeriod.id", (Object)curPeriod));
        }
        if (!StringUtils.isEmpty((String)(adminOrg = cp.getCustomerParam("adminOrg")))) {
            IAdminOrgUnit iaou = AdminOrgUnitFactory.getRemoteInstance();
            AdminOrgUnitInfo orgInfo = iaou.getAdminOrgUnitInfo((IObjectPK)new ObjectStringPK(adminOrg));
            filter.getFilterItems().add(new FilterItemInfo("admin.longNumber", (Object)orgInfo.getLongNumber(), CompareType.EQUALS));
            if (!this.includeSubOrg.isSelected()) {
                filter.setMaskString("#0 and #1 and #2");
            } else {
                filter.getFilterItems().add(new FilterItemInfo("admin.longNumber", (Object)(orgInfo.getLongNumber() + "!%"), CompareType.LIKE));
                filter.setMaskString("#0 and #1 and (#2 or #3)");
            }
        }
        return filter;
    }
}

