/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.benefit.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.swing.KDList;
import com.kingdee.bos.ctrl.swing.LanguageInfo;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.benefit.BeneSchemeException;
import com.kingdee.eas.hr.benefit.BenefitCollection;
import com.kingdee.eas.hr.benefit.BenefitException;
import com.kingdee.eas.hr.benefit.BenefitFactory;
import com.kingdee.eas.hr.benefit.BenefitInfo;
import com.kingdee.eas.hr.benefit.BenefitSchemeBenefitCollection;
import com.kingdee.eas.hr.benefit.BenefitSchemeBenefitFactory;
import com.kingdee.eas.hr.benefit.BenefitSchemeFacadeFactory;
import com.kingdee.eas.hr.benefit.BenefitSchemeFactory;
import com.kingdee.eas.hr.benefit.BenefitSchemeInfo;
import com.kingdee.eas.hr.benefit.BenefitSchemePersonCollection;
import com.kingdee.eas.hr.benefit.BenefitSchemePersonInfo;
import com.kingdee.eas.hr.benefit.IBenefit;
import com.kingdee.eas.hr.benefit.IBenefitSchemeBenefit;
import com.kingdee.eas.hr.benefit.IBenefitSchemeFacade;
import com.kingdee.eas.hr.benefit.client.AbstractBenefitSchemeEditUI;
import com.kingdee.eas.hr.benefit.util.BenefitUtils;
import com.kingdee.eas.hr.emp.client.EmployeeMultiF7PromptBox;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import org.apache.log4j.Logger;

public class BenefitSchemeEditUI
extends AbstractBenefitSchemeEditUI {
    private static final Logger logger = CoreUIObject.getLogger(BenefitSchemeEditUI.class);

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAll.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_right"));
        this.btnAll.setText(null);
        this.btnSingle.setIcon(EASResource.getIcon((String)"imgTbtn_move_right"));
        this.btnSingle.setText(null);
        this.btnDelAll.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_left"));
        this.btnDelAll.setText(null);
        this.btnDelSingle.setIcon(EASResource.getIcon((String)"imgTbtn_move_left"));
        this.btnDelSingle.setText(null);
        this.btnAdd.setIcon(EASResource.getIcon((String)"imgTbtn_userview"));
        this.btnAdd.setText(null);
        this.btnDel.setIcon(EASResource.getIcon((String)"imgTbtn_logoutuser"));
        this.btnDel.setText(null);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initEdit();
    }

    private void setWidgetEnable(boolean tag) {
        this.listAll.setEnabled(tag);
        this.listSelected.setEnabled(tag);
        this.btnAll.setEnabled(tag);
        this.btnDelAll.setEnabled(tag);
        this.btnDelSingle.setEnabled(tag);
        this.btnSingle.setEnabled(tag);
    }

    private void initEdit() throws BOSException, EASBizException {
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            this.initKDList(null);
            this.txtNumber.setEnabled(true);
        } else {
            this.txtNumber.setEnabled(false);
            this.initKDList(this.editData.getId().toString());
            this.loadDataForPersonTab(this.editData.getId().toString());
        }
    }

    private void initKDList(String benefitSchemeId) throws BOSException {
        int i;
        BenefitCollection coll = null;
        DefaultListModel<BenefitInfo> modelAll = new DefaultListModel<BenefitInfo>();
        DefaultListModel<BenefitInfo> modelSelect = new DefaultListModel<BenefitInfo>();
        coll = this.getBeneCollByHr();
        int size = coll.size();
        for (i = 0; i < size; ++i) {
            modelAll.addElement(coll.get(i));
        }
        if (benefitSchemeId == null) {
            this.listAll.setModel(modelAll);
            this.setWidgetEnable(true);
        } else {
            coll = this.getBeneCollInBeneScheme(benefitSchemeId);
            size = coll.size();
            for (i = 0; i < size; ++i) {
                modelSelect.addElement(coll.get(i));
            }
            size = coll.size();
            block2: for (i = 0; i < size; ++i) {
                int sum = modelAll.size();
                for (int j = 0; j < sum; ++j) {
                    if (!coll.get(i).getId().toString().equals(((BenefitInfo)modelAll.elementAt(j)).getId().toString())) continue;
                    modelAll.removeElementAt(j);
                    continue block2;
                }
            }
            this.listAll.setModel(modelAll);
            this.listSelected.setModel(modelSelect);
            this.setWidgetEnable(false);
            if (this.getOprtState().equals(OprtState.EDIT)) {
                this.setWidgetEnable(true);
            }
        }
    }

    private void loadDataForPersonTab(String beneSchemeId) throws BOSException, EASBizException {
        IBenefitSchemeFacade iBenefitSchemeFacade = BenefitSchemeFacadeFactory.getRemoteInstance();
        this.tblPerson.removeRows();
        this.tblPerson.checkParsed();
        IRowSet rows = iBenefitSchemeFacade.getBeneSchemePer(beneSchemeId);
        IRow iRow1 = null;
        String personId = null;
        try {
            while (rows.next()) {
                iRow1 = this.tblPerson.addRow();
                personId = rows.getString("person.id");
                iRow1.getCell("id").setValue((Object)personId);
                iRow1.getCell("number").setValue((Object)rows.getString("person.number"));
                iRow1.getCell("name").setValue((Object)rows.getString("person.name"));
                iRow1.getCell("adminOrg.name").setValue((Object)rows.getString("adminOrgUnit.name"));
                iRow1.getCell("position.name").setValue((Object)rows.getString("position.name"));
                iRow1.getCell("benefitDate").setValue((Object)rows.getString("socialInsu.tranSInsuTime"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
            this.handleException(e);
        }
    }

    public BenefitCollection getBeneCollByHr() throws BOSException {
        IBenefit iBenefit = BenefitFactory.getRemoteInstance();
        String hrOrgId = SysContext.getSysContext().getCurrentHRUnit().getId().toString();
        return iBenefit.getBenefitCollection("select * where hrOrgUnit.id = '" + hrOrgId + "' and state = 1");
    }

    public BenefitCollection getBeneCollInBeneScheme(String benefitSchemeId) throws BOSException {
        IBenefitSchemeBenefit iBeneSchemeBene = BenefitSchemeBenefitFactory.getRemoteInstance();
        BenefitSchemeBenefitCollection beneSchemeBeneColl = null;
        beneSchemeBeneColl = iBeneSchemeBene.getBenefitSchemeBenefitCollection("select benefit.* where benefitScheme.id = '" + benefitSchemeId + "'");
        BenefitCollection coll = new BenefitCollection();
        BenefitInfo info = null;
        int size = beneSchemeBeneColl.size();
        for (int i = 0; i < size; ++i) {
            info = beneSchemeBeneColl.get(i).getBenefit();
            coll.add(info);
        }
        return coll;
    }

    public void loadFields() {
        super.loadFields();
        try {
            this.listAll.removeAllElements();
            this.listSelected.removeAllElements();
            this.tblPerson.removeRows();
            this.initEdit();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public void storeFields() {
        super.storeFields();
    }

    protected void btnAdd_actionPerformed(ActionEvent e) throws Exception {
        super.btnAdd_actionPerformed(e);
        EmployeeMultiF7PromptBox personNoPositionPromptBox = new EmployeeMultiF7PromptBox((IUIObject)this);
        personNoPositionPromptBox.showNoPositionPerson(true);
        personNoPositionPromptBox.setIsSingleSelect(false);
        personNoPositionPromptBox.showOnlySocietyPerson(true);
        personNoPositionPromptBox.setIsShowAllAdmin(true);
        personNoPositionPromptBox.show();
        if (!personNoPositionPromptBox.isCanceled() && personNoPositionPromptBox.getData() instanceof Object[]) {
            Object[] obj = (Object[])personNoPositionPromptBox.getData();
            PersonInfo selectedPersonInfo = null;
            int length = obj.length;
            for (int i = 0; i < length; ++i) {
                selectedPersonInfo = (PersonInfo)obj[i];
                this.addPersonInfo(selectedPersonInfo);
            }
        }
    }

    private void addPersonInfo(PersonInfo selectedPersonInfo) throws BOSException, EASBizException {
        if (!this.checkExistInTable(selectedPersonInfo)) {
            IRow curRow = this.tblPerson.addRow();
            curRow.getCell("id").setValue((Object)selectedPersonInfo.getId().toString());
            curRow.getCell("number").setValue((Object)selectedPersonInfo.getNumber());
            curRow.getCell("name").setValue((Object)selectedPersonInfo.getName());
            curRow.getCell("adminOrg.name").setValue(selectedPersonInfo.get("primaryAdminOrg"));
            curRow.getCell("position.name").setValue(selectedPersonInfo.get("primaryPosition"));
            curRow.getCell("benefitDate").setValue(selectedPersonInfo.get("STime"));
        }
    }

    private boolean checkExistInTable(PersonInfo selectedPersonInfo) {
        int counts = this.tblPerson.getRowCount();
        boolean isExist = false;
        for (int i = 0; i < counts; ++i) {
            if (!selectedPersonInfo.getId().toString().equals(this.tblPerson.getRow(i).getCell("id").getValue().toString())) continue;
            isExist = true;
            break;
        }
        return isExist;
    }

    protected void btnAll_actionPerformed(ActionEvent e) throws Exception {
        int i;
        super.btnAll_actionPerformed(e);
        int itemCount = this.listAll.getElementCount();
        if (itemCount == 0) {
            return;
        }
        Object[] items = new Object[itemCount];
        for (i = 0; i < itemCount; ++i) {
            items[i] = this.listAll.getElement(i);
        }
        int size = items.length;
        for (i = 0; i < size; ++i) {
            this.listSelected.addElement(items[i]);
        }
        int[] selected = this.listAll.getSelectedIndices();
        this.listSelected.setSelectedIndices(selected);
        this.listAll.removeAllElements();
    }

    protected void btnDel_actionPerformed(ActionEvent e) throws Exception {
        super.btnDel_actionPerformed(e);
        BenefitUtils.deleteBlock(this.tblPerson);
    }

    protected void btnDelAll_actionPerformed(ActionEvent e) throws Exception {
        int i;
        super.btnDelAll_actionPerformed(e);
        int itemCount = this.listSelected.getElementCount();
        if (itemCount == 0) {
            return;
        }
        Object[] items = new Object[itemCount];
        for (i = 0; i < itemCount; ++i) {
            items[i] = this.listSelected.getElement(i);
        }
        int size = items.length;
        for (i = 0; i < size; ++i) {
            this.listAll.addElement(items[i]);
        }
        int[] selected = this.listSelected.getSelectedIndices();
        this.listAll.setSelectedIndices(selected);
        this.listSelected.removeAllElements();
    }

    protected void btnDelSingle_actionPerformed(ActionEvent e) throws Exception {
        Object[] items = this.listSelected.getSelectedValues();
        int[] leftIndics = this.listSelected.getSelectedIndices();
        if (items == null || items.length == 0) {
            return;
        }
        int size = items.length;
        for (int i = 0; i < size; ++i) {
            this.listAll.addElement(items[i]);
        }
        int[] indices = this.listSelected.getSelectedIndices();
        for (int i = indices.length - 1; i >= 0; --i) {
            this.listSelected.removeElementAt(indices[i]);
        }
        this.setSelectItem(this.listSelected, leftIndics[0]);
    }

    protected void btnSingle_actionPerformed(ActionEvent e) throws Exception {
        Object[] items = this.listAll.getSelectedValues();
        int[] rightIndics = this.listAll.getSelectedIndices();
        if (items == null || items.length == 0) {
            return;
        }
        int size = items.length;
        for (int i = 0; i < size; ++i) {
            this.listSelected.addElement(items[i]);
        }
        int[] indices = this.listAll.getSelectedIndices();
        for (int i = indices.length - 1; i >= 0; --i) {
            this.listAll.removeElementAt(indices[i]);
        }
        this.setSelectItem(this.listAll, rightIndics[0]);
    }

    protected void listAll_mouseClicked(MouseEvent e) throws Exception {
        super.listAll_mouseClicked(e);
        if (e.getClickCount() == 2) {
            Object[] items = this.listAll.getSelectedValues();
            int[] leftIndics = this.listAll.getSelectedIndices();
            if (items == null || items.length == 0) {
                return;
            }
            int size = items.length;
            for (int i = 0; i < size; ++i) {
                this.listSelected.addElement(items[i]);
            }
            int[] indices = this.listAll.getSelectedIndices();
            for (int i = indices.length - 1; i >= 0; --i) {
                this.listAll.removeElementAt(indices[i]);
            }
            this.setSelectItem(this.listAll, leftIndics[0]);
        }
    }

    protected void listSelected_mouseClicked(MouseEvent e) throws Exception {
        super.listSelected_mouseClicked(e);
        if (e.getClickCount() == 2) {
            Object[] items = this.listSelected.getSelectedValues();
            int[] rightIndics = this.listSelected.getSelectedIndices();
            if (items == null || items.length == 0) {
                return;
            }
            int size = items.length;
            for (int i = 0; i < size; ++i) {
                this.listAll.addElement(items[i]);
            }
            int[] indices = this.listSelected.getSelectedIndices();
            for (int i = indices.length - 1; i >= 0; --i) {
                this.listSelected.removeElementAt(indices[i]);
            }
            this.setSelectItem(this.listSelected, rightIndics[0]);
        }
    }

    private void setSelectItem(KDList list, int beginIndex) {
        if (list.getElementCount() > 0 && list.getElementCount() > beginIndex) {
            list.setSelectedIndex(beginIndex);
        } else if (list.getElementCount() > 0 && list.getElementCount() <= beginIndex) {
            list.setSelectedIndex(beginIndex - 1);
        }
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
    }

    private void checkInput() throws BenefitException, BeneSchemeException {
        if (StringUtils.isEmpty((String)this.txtNumber.getText())) {
            this.txtNumber.requestFocusInWindow();
            throw new BeneSchemeException(BeneSchemeException.BS_NUM_NOTNULL);
        }
        BenefitSchemeEditUI benefitSchemeEditUI = this;
        List list = benefitSchemeEditUI.txtName.getLanguageList();
        LanguageInfo lang = null;
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            lang = (LanguageInfo)list.get(i);
            if (!StringUtils.isEmpty((String)((String)this.txtName.getItemBy(lang).getData()))) continue;
            this.txtName.requestFocusInWindow();
            throw new BeneSchemeException(BeneSchemeException.BS_NAME_NOTNULL);
        }
        if (this.listSelected.getElementCount() <= 0) {
            this.listSelected.requestFocusInWindow();
            throw new BenefitException(BenefitException.NO_BENEFIT);
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.checkInput();
        this.editData.put("benefitIdList", this.getChooseIds());
        this.editData.put("perIdList", this.getBeneSchemePerList());
        super.actionSubmit_actionPerformed(e);
    }

    public BenefitSchemePersonCollection getBeneSchemePerColl() throws BOSException, EASBizException {
        BenefitSchemePersonCollection coll = new BenefitSchemePersonCollection();
        IPerson iPerson = PersonFactory.getRemoteInstance();
        PersonInfo pInfo = null;
        BenefitSchemePersonInfo info = null;
        ObjectUuidPK pk = null;
        IRow iRow = null;
        int size = this.tblPerson.getRowCount();
        for (int i = 0; i < size; ++i) {
            iRow = this.tblPerson.getRow(i);
            info = new BenefitSchemePersonInfo();
            pk = new ObjectUuidPK(iRow.getCell("id").getValue().toString());
            pInfo = iPerson.getPersonInfo((IObjectPK)pk);
            info.setPerson(pInfo);
            coll.add(info);
        }
        return coll;
    }

    public List getBeneSchemePerList() throws BOSException, EASBizException {
        ArrayList<String> list = new ArrayList<String>();
        IRow iRow = null;
        int size = this.tblPerson.getRowCount();
        for (int i = 0; i < size; ++i) {
            iRow = this.tblPerson.getRow(i);
            String perId = iRow.getCell("id").getValue().toString();
            list.add(perId);
        }
        return list;
    }

    private ArrayList getChooseIds() {
        ArrayList<String> list = new ArrayList<String>();
        BenefitInfo beInfo = null;
        int size = this.listSelected.getElementCount();
        for (int i = 0; i < size; ++i) {
            beInfo = (BenefitInfo)this.listSelected.getElement(i);
            list.add(beInfo.getId().toString());
        }
        return list;
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancelCancel_actionPerformed(e);
    }

    public void actionFirst_actionPerformed(ActionEvent e) throws Exception {
        super.actionFirst_actionPerformed(e);
    }

    public void actionPre_actionPerformed(ActionEvent e) throws Exception {
        super.actionPre_actionPerformed(e);
    }

    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        super.actionNext_actionPerformed(e);
    }

    public void actionLast_actionPerformed(ActionEvent e) throws Exception {
        super.actionLast_actionPerformed(e);
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopy_actionPerformed(e);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.setWidgetEnable(true);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
    }

    public void actionAttachment_actionPerformed(ActionEvent e) throws Exception {
        super.actionAttachment_actionPerformed(e);
    }

    public void actionSubmitOption_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmitOption_actionPerformed(e);
    }

    protected String getEditUIName() {
        return BenefitSchemeEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BenefitSchemeFactory.getRemoteInstance();
    }

    protected IObjectValue createNewData() {
        BenefitSchemeInfo objectValue = new BenefitSchemeInfo();
        objectValue.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        return objectValue;
    }
}

