/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.benefit.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.benefit.AccountTypeCollection;
import com.kingdee.eas.hr.benefit.AccountTypeInfo;
import com.kingdee.eas.hr.benefit.client.AbstractHROFluctuationPersonFilterUI;
import com.kingdee.eas.hr.benefit.util.BenefitUtils;
import com.kingdee.eas.hr.benefit.util.BenefitVerifyUtils;
import com.kingdee.eas.hr.compensation.CmpPeriodFactory;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.util.StringUtils;
import javax.swing.DefaultComboBoxModel;
import org.apache.log4j.Logger;

public class HROFluctuationPersonFilterUI
extends AbstractHROFluctuationPersonFilterUI {
    private static Logger logger = Logger.getLogger(HROFluctuationPersonFilterUI.class);
    private static final long serialVersionUID = 1L;

    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initPrmtPeriod();
        this.loadComboAccountType();
    }

    private void initPrmtPeriod() {
        this.prmtPeriod.setQueryInfo("com.kingdee.eas.hr.compensation.app.F7CmpPeriodQuery");
        this.prmtPeriod.setDisplayFormat("$name$");
        this.prmtPeriod.setEditFormat("$number$");
        this.prmtPeriod.setCommitFormat("$number$");
        EntityViewInfo eviCmpPeriod = new EntityViewInfo();
        FilterInfo filterInfoCmpPeriod = new FilterInfo();
        filterInfoCmpPeriod.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)HRSchemeUtils.getClientHROrgUnitInfo().getId().toString()));
        eviCmpPeriod.setFilter(filterInfoCmpPeriod);
        this.prmtPeriod.setEntityViewInfo(eviCmpPeriod);
    }

    private void loadComboAccountType() throws BOSException {
        DefaultComboBoxModel<AccountTypeInfo> model = new DefaultComboBoxModel<AccountTypeInfo>();
        AccountTypeCollection accountTypeInfos = BenefitUtils.getAccountTypeColl();
        int size = accountTypeInfos.size();
        for (int i = 0; i < size; ++i) {
            model.addElement(accountTypeInfos.get(i));
        }
        if (accountTypeInfos.size() != 0) {
            model.setSelectedItem(accountTypeInfos.get(0));
        }
        this.comboAccountType.setModel(model);
    }

    public void clear() {
        super.clear();
        this.prmtPeriod.setData(null);
        if (this.comboAccountType.getItemCount() > 0) {
            this.comboAccountType.setSelectedIndex(0);
        }
    }

    public boolean verify() {
        return BenefitVerifyUtils.accountTypeNotNullVerify(this.comboAccountType);
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        if (this.prmtPeriod.getData() != null) {
            CmpPeriodInfo cpInfo = (CmpPeriodInfo)this.prmtPeriod.getData();
            cp.addCustomerParam("Period", cpInfo.getId().toString());
        }
        if (this.comboAccountType.getSelectedItem() != null) {
            AccountTypeInfo atInfo = (AccountTypeInfo)this.comboAccountType.getSelectedItem();
            cp.addCustomerParam("AccountType", atInfo.getId().toString());
        }
        return cp;
    }

    public void setCustomerParams(CustomerParams cp) {
        if (cp == null) {
            return;
        }
        String periodID = cp.getCustomerParam("Period");
        if (!StringUtils.isEmpty((String)periodID)) {
            try {
                CmpPeriodInfo cpInfo = CmpPeriodFactory.getRemoteInstance().getCmpPeriodInfo((IObjectPK)new ObjectStringPK(periodID));
                this.prmtPeriod.setData((Object)cpInfo);
            }
            catch (EASBizException e) {
                logger.error((Object)e.getMessage());
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage());
            }
        }
        String acc = cp.getCustomerParam("AccountType");
        AccountTypeInfo atInfo = null;
        if (!StringUtils.isEmpty((String)acc)) {
            int size = this.comboAccountType.getItemCount();
            for (int i = 0; i < size; ++i) {
                atInfo = (AccountTypeInfo)this.comboAccountType.getItemAt(i);
                if (!acc.equals(atInfo.getId().toString())) continue;
                this.comboAccountType.setSelectedIndex(i);
                break;
            }
        }
    }
}

