/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.hr.emp.EmpHisCompareEnum;
import com.kingdee.eas.hr.emp.EmployeeHisSettingInfo;
import com.kingdee.util.enums.EnumUtils;
import com.kingdee.util.enums.IntEnum;
import com.kingdee.util.enums.StringEnum;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Iterator;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTextField;

public class EmployeeHistoryUtils {
    public static final String SIGN_EQUAL_VALUE = "=";
    public static final String SIGN_GREATE_EQUAL_VALUE = "=";
    public static final String SIGN_GREATE_VALUE = ">";
    public static final String SIGN_LEFT_LIKE_VALUE = "%LIKE";
    public static final String SIGN_LESS_EQUAL_VALUE = "<=";
    public static final String SIGN_LESS_VALUE = "<";
    public static final String SIGN_LIKE_VALUE = "LIKE";
    public static final String SIGN_NOT_EQUAL_VALUE = "<>";
    public static final String SIGN_NOT_LIKE_VALUE = "NOT LIKE";
    public static final String SIGN_NOT_NULL_VALUE = "IS NOT NULL";
    public static final String SIGN_NOTHIING_VALUE = "";
    public static final String SIGN_NULL_VALUE = "IS NULL";
    public static final String SIGN_RIGTH_LIKE_VALUE = "LIKE%";

    public static String getConditionSignByEnumValue(int value) {
        String sign = SIGN_NOTHIING_VALUE;
        if (value == 0) {
            sign = "=";
        } else if (value == 7) {
            sign = "=";
        } else if (value == 6) {
            sign = SIGN_GREATE_VALUE;
        } else if (value == 4) {
            sign = SIGN_LEFT_LIKE_VALUE;
        } else if (value == 9) {
            sign = SIGN_LESS_EQUAL_VALUE;
        } else if (value == 8) {
            sign = SIGN_LESS_VALUE;
        } else if (value == 2) {
            sign = SIGN_LIKE_VALUE;
        } else if (value == 1) {
            sign = SIGN_NOT_EQUAL_VALUE;
        } else if (value == 3) {
            sign = SIGN_NOT_LIKE_VALUE;
        } else if (value == 11) {
            sign = SIGN_NOT_NULL_VALUE;
        } else if (value == -1) {
            sign = SIGN_NOTHIING_VALUE;
        } else if (value == 10) {
            sign = SIGN_NULL_VALUE;
        } else if (value == 5) {
            sign = SIGN_RIGTH_LIKE_VALUE;
        }
        return sign;
    }

    public static String getStringValueByType(String type, Object obj) {
        if (type.equals("REF")) {
            return ((IObjectValue)obj).get("id").toString();
        }
        if (type.equals("DATE")) {
            return String.valueOf(((Date)obj).getTime());
        }
        if (type.equals("TIMESTAMP")) {
            return String.valueOf(((Timestamp)obj).getTime());
        }
        if (type.equals("ENUM")) {
            if (obj instanceof IntEnum) {
                return String.valueOf(((IntEnum)obj).getValue());
            }
            return ((StringEnum)obj).getValue();
        }
        if (type.equals("BOOLEAN")) {
            Boolean bool = (Boolean)obj;
            return String.valueOf(bool != false ? 1 : 0);
        }
        return obj.toString();
    }

    public static ICellEditor getCellEditorByPropertyInfo(EmployeeHisSettingInfo property) throws Exception {
        if (property == null) {
            return new KDTDefaultCellEditor((JTextField)new KDTextField());
        }
        if (property.getType().equals("REF")) {
            if (property.getSpecialF7() != null) {
                KDPromptSelector selector = (KDPromptSelector)Class.forName(property.getSpecialF7()).newInstance();
                KDBizPromptBox f7 = new KDBizPromptBox();
                f7.setSelector(selector);
                f7.setEditable(false);
                return new KDTDefaultCellEditor((IKDEditor)f7);
            }
            if (property.getFullQuery() != null) {
                KDBizPromptBox f7 = new KDBizPromptBox();
                f7.setDisplayFormat("$name$");
                f7.setEditFormat("$number$");
                f7.setCommitFormat("$number$");
                f7.setQueryInfo(property.getFullQuery());
                return new KDTDefaultCellEditor((IKDEditor)f7);
            }
            throw new BOSException("employee history property data is error!!!");
        }
        if (property.getType().equals("ENUM")) {
            Iterator iter = EnumUtils.iterator(Class.forName(property.getFullEnum()));
            DefaultComboBoxModel model = new DefaultComboBoxModel();
            while (iter.hasNext()) {
                model.addElement(iter.next());
            }
            KDComboBox combo = new KDComboBox(model);
            return new KDTDefaultCellEditor((JComboBox)combo);
        }
        if (property.getType().equals("DATE") || property.getType().equals("TIMESTAMP")) {
            KDDatePicker dpDate = new KDDatePicker();
            return new KDTDefaultCellEditor(dpDate);
        }
        if (property.getType().equals("BOOLEAN")) {
            DefaultComboBoxModel<Boolean> model = new DefaultComboBoxModel<Boolean>();
            model.addElement(Boolean.FALSE);
            model.addElement(Boolean.TRUE);
            KDComboBox combo = new KDComboBox(model);
            return new KDTDefaultCellEditor((JComboBox)combo);
        }
        return null;
    }

    public static ICellEditor getCompareCellEditorByType(String type) {
        DefaultComboBoxModel<EmpHisCompareEnum> model = new DefaultComboBoxModel<EmpHisCompareEnum>();
        if (type.equals("BOOLEAN") || type.equals("ENUM") || type.equals("REF")) {
            model.addElement(EmpHisCompareEnum.EQUAL);
            model.addElement(EmpHisCompareEnum.NOT_EQUAL);
            model.addElement(EmpHisCompareEnum.NULL);
            model.addElement(EmpHisCompareEnum.NOT_NULL);
        } else if (type.equals("DATE") || type.equals("DECIMAL") || type.equals("FLOAT") || type.equals("INT") || type.equals("DOUBLE") || type.equals("TIMESTAMP")) {
            model.addElement(EmpHisCompareEnum.EQUAL);
            model.addElement(EmpHisCompareEnum.GREATE);
            model.addElement(EmpHisCompareEnum.GREATE_EQUAL);
            model.addElement(EmpHisCompareEnum.LESS);
            model.addElement(EmpHisCompareEnum.LESS_EQUAL);
            model.addElement(EmpHisCompareEnum.NULL);
            model.addElement(EmpHisCompareEnum.NOT_NULL);
        } else if (type.equals("ENUM")) {
            model.addElement(EmpHisCompareEnum.EQUAL);
            model.addElement(EmpHisCompareEnum.NOT_EQUAL);
            model.addElement(EmpHisCompareEnum.NULL);
            model.addElement(EmpHisCompareEnum.NOT_NULL);
        } else if (type.equals("STRING")) {
            Iterator iter = EmpHisCompareEnum.iterator();
            while (iter.hasNext()) {
                model.addElement((EmpHisCompareEnum)((Object)iter.next()));
            }
        }
        KDComboBox combo = new KDComboBox(model);
        return new KDTDefaultCellEditor((JComboBox)combo);
    }

    private static class EmpHisPropertyInfo {
        private EmpHisEnitityInfo _entity;
        private String _property;
        private String _type;
        private String _alias;

        public EmpHisPropertyInfo(EmpHisEnitityInfo entity, String property, String type, String alias) {
            this._entity = entity;
            this._property = property;
            this._alias = alias;
            this._type = type;
        }

        public EmpHisPropertyInfo() {
        }

        public EmpHisEnitityInfo getEntity() {
            return this._entity;
        }

        public String getProperty() {
            return this._property;
        }

        public String getType() {
            return this._type;
        }

        public String getAlias() {
            return this._alias;
        }

        public void setEntity(EmpHisEnitityInfo entity) {
            this._entity = entity;
        }

        public void setProperty(String property) {
            this._property = property;
        }

        public void setAlias(String alias) {
            this._alias = alias;
        }

        public void setType(String type) {
            this._type = type;
        }
    }

    private static class EmpHisEnitityInfo {
        private String _entity;
        private String _alias;

        public EmpHisEnitityInfo(String entity, String alias) {
            this._alias = alias;
            this._entity = entity;
        }

        public EmpHisEnitityInfo() {
        }

        public void setEntity(String entity) {
            this._entity = entity;
        }

        public void setAlias(String alias) {
            this._alias = alias;
        }

        public String getEntity() {
            return this._entity;
        }

        public String getAlias() {
            return this._alias;
        }
    }
}

