/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFilterTextField;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeListener;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.core.hr.util.HRParamUtil;
import com.kingdee.eas.basedata.hraux.DiplomaFactory;
import com.kingdee.eas.basedata.hraux.DiplomaInfo;
import com.kingdee.eas.basedata.hraux.FolkFactory;
import com.kingdee.eas.basedata.hraux.FolkInfo;
import com.kingdee.eas.basedata.hraux.PoliticalFaceFactory;
import com.kingdee.eas.basedata.hraux.PoliticalFaceInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.PositionMemberCollection;
import com.kingdee.eas.basedata.org.PositionMemberInfo;
import com.kingdee.eas.basedata.org.client.PositionPromptBox2;
import com.kingdee.eas.basedata.person.Genders;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.hr.base.BaseInnerFacadeFactory;
import com.kingdee.eas.hr.base.EmployeeTypeCollection;
import com.kingdee.eas.hr.base.EmployeeTypeFactory;
import com.kingdee.eas.hr.base.EmployeeTypeInfo;
import com.kingdee.eas.hr.base.HROrgContextManagerFacadeFactory;
import com.kingdee.eas.hr.base.IBaseInnerFacade;
import com.kingdee.eas.hr.base.IHROrgContextManagerFacade;
import com.kingdee.eas.hr.base.util.HRUtil;
import com.kingdee.eas.hr.base.util.IDCardCommonUtil;
import com.kingdee.eas.hr.compensation.CmpSchemePerFacadeFactory;
import com.kingdee.eas.hr.compensation.HasSalaryException;
import com.kingdee.eas.hr.compensation.ICmpSchemePerFacade;
import com.kingdee.eas.hr.compensation.TaxSchemeInfo;
import com.kingdee.eas.hr.emp.EmpInnerFacadeFactory;
import com.kingdee.eas.hr.emp.EmployeeException;
import com.kingdee.eas.hr.emp.HrEmpBizException;
import com.kingdee.eas.hr.emp.IEmpInnerFacade;
import com.kingdee.eas.hr.emp.PersonCmpInfo;
import com.kingdee.eas.hr.emp.PersonDegreeInfo;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.hr.emp.SocialInsuranceInfo;
import com.kingdee.eas.hr.emp.client.AbstractEmployeeBatchEditUI;
import com.kingdee.eas.hr.emp.client.EmpFieldPermissionUtil;
import com.kingdee.eas.hr.emp.client.EmployeeClientUtils;
import com.kingdee.eas.hr.emp.client.PersonMultiPromptBox;
import com.kingdee.eas.hr.org.JobGradeInfo;
import com.kingdee.eas.hr.org.client.AdminByOrgRangePromptBox;
import com.kingdee.eas.hr.org.client.JobGradePromptBox;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.BaseException;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JTextField;

public class EmployeeBatchEditUI
extends AbstractEmployeeBatchEditUI {
    private String resClass = "com.kingdee.eas.hr.emp.EmployeeResource.";
    PositionInfo positionInfo = null;
    PersonMultiPromptBox personBox = new PersonMultiPromptBox((IUIObject)this);
    PersonCollection pInfos = null;
    boolean isEmp = true;
    private boolean isUseIntermitNumber = false;
    private boolean isIDCardVerify = true;
    boolean isCheckIDCard18To15 = true;
    private boolean noPosition = false;
    private static final String empInfoSource = "com.kingdee.eas.hr.emp.EmployeeResource";

    protected void initWorkButton() {
        super.initWorkButton();
        this.menuEdit.setVisible(false);
        this.menuView.setVisible(false);
        this.menuItemSave.setVisible(false);
        this.menuItemEdit.setVisible(false);
        this.menuItemRemove.setVisible(false);
        this.actionAddNew.setVisible(false);
    }

    @Override
    public void actionBatchCopy_actionPerformed(ActionEvent e) throws Exception {
        KDTSelectBlock sb = null;
        int size = this.tblEmp.getSelectManager().size();
        if (size > 0 && this.tblEmp.getRowCount() > 0) {
            sb = this.tblEmp.getSelectManager().get(0);
            ICell iCell = null;
            int row = sb.getTop();
            int column = sb.getLeft();
            if (column == 0) {
                return;
            }
            IColumn iColumn = this.tblEmp.getColumn(column);
            if (iColumn.getStyleAttributes().isLocked()) {
                return;
            }
            Object value = this.tblEmp.getCell(row, column).getValue();
            int length = this.tblEmp.getRowCount();
            for (int i = 0; i < length; ++i) {
                if (i == row || this.tblEmp.getCell(i, column).getStyleAttributes().isLocked()) continue;
                iCell = this.tblEmp.getCell(i, column);
                iCell.setValue(value);
            }
        }
    }

    public boolean isSave() {
        return true;
    }

    public boolean isSaved() {
        return true;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension size = new Dimension();
        size.setSize(screenSize.getWidth() * 2.0 / 3.0, screenSize.getHeight() / 2.0);
        this.setPreferredSize(size);
        this.initTableProperty();
        this.positionInfo = (PositionInfo)this.getUIContext().get("PositionNode");
        this.isEmp = Boolean.valueOf(this.getUIContext().get("editType").toString());
        PersonCollection pInfos = (PersonCollection)this.getUIContext().get("personInfos");
        this.addModifyDataToTable(pInfos);
        this.tblEmp.getColumn("colCardNo").getStyleAttributes().setNumberFormat("@");
        EmployeeClientUtils.setCellEditor(this.tblEmp, "colEmpName");
        this.setCellEditor(this.tblEmp, "colNumber");
        this.tblEmp.getActionMap().remove("Paste");
        if (this.getUIContext().get("NO_POSITION") instanceof Boolean) {
            this.noPosition = (Boolean)this.getUIContext().get("NO_POSITION");
        }
        if (this.noPosition) {
            this.tblEmp.getColumn("adminDep").getStyleAttributes().setHided(false);
            this.tblEmp.getColumn("colPosition").getStyleAttributes().setHided(true);
        } else {
            this.setColumnIsHided(false);
            this.isEmp = true;
        }
        this.setEditor();
        if (this.getUIContext().get("cadre") != null) {
            this.setUITitle(EASResource.getString((String)empInfoSource, (String)"CADRE_BATCH"));
        }
        this.editData = new PersonInfo();
        this.setDataObject((IObjectValue)this.editData);
        this.menuTool.remove(0);
    }

    private void setCellEditor(KDTable table, String colName) {
        KDFilterTextField filterField = new KDFilterTextField();
        filterField.setHorizontalAlignment(4);
        filterField.setFilterType(25);
        filterField.setValidCharacters("-_./\\&*()+|@#$%?");
        filterField.putClientProperty((Object)"OriginValue", (Object)Boolean.TRUE);
        filterField.setMaxLength(80);
        table.getColumn(colName).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)filterField));
    }

    protected void inOnload() throws Exception {
    }

    private void setColumnIsHided(boolean isHide) {
        this.tblEmp.getColumn("colPosition").getStyleAttributes().setHided(isHide);
        this.tblEmp.getColumn("colEnterDate").getStyleAttributes().setHided(isHide);
    }

    private void addModifyDataToTable(PersonCollection pInfos) throws EASBizException, BOSException {
        if (pInfos == null || pInfos.size() == 0) {
            return;
        }
        IPerson iPerson = PersonFactory.getRemoteInstance();
        PersonCollection rPersonInfos = iPerson.getOtherPersonCollection(pInfos);
        IRow curRow = null;
        for (int j = 0; j < rPersonInfos.size(); ++j) {
            curRow = this.tblEmp.addRow();
            this.setCurrentRowEditor(curRow);
            this.addNewRow(curRow, rPersonInfos.get(j), j);
        }
    }

    private void setCurrentRowEditor(IRow curRow) {
        KDBizPromptBox promptBoxPerson = new KDBizPromptBox();
        promptBoxPerson.setSelector((KDPromptSelector)this.personBox);
        promptBoxPerson.setRequired(true);
        curRow.getCell("colEmpName").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)promptBoxPerson));
        promptBoxPerson.addPreChangeListener(new PreChangeListener(){

            public void preChange(PreChangeEvent e) {
                try {
                    EmployeeBatchEditUI.this.setPersonValue(e, EmployeeBatchEditUI.this.personBox);
                }
                catch (Exception e1) {
                    ExceptionHandler.handle((Throwable)e1);
                }
            }
        });
    }

    private void initTableProperty() {
        this.tblEmp.checkParsed();
        EmployeeClientUtils.setColumnBackColor(this.tblEmp, "colPosition");
        EmployeeClientUtils.setColumnBackColor(this.tblEmp, "colEmpName");
        EmployeeClientUtils.setColumnBackColor(this.tblEmp, "colNumber");
        EmployeeClientUtils.setColumnBackColor(this.tblEmp, "colEmpType");
        EmployeeClientUtils.setColumnBackColor(this.tblEmp, "adminDep");
        String[] str = EmpFieldPermissionUtil.disableEmpBathColStr;
        int length = str.length;
        for (int i = 0; i < length; ++i) {
            this.tblEmp.getColumn(str[i]).getStyleAttributes().setLocked(true);
        }
    }

    private void setEmpTypeEditory(Map employeeTypeDetail) throws Exception {
        if (employeeTypeDetail == null || employeeTypeDetail.size() <= 0) {
            return;
        }
        HashSet<String> keys = new HashSet<String>();
        IRow row = null;
        int size = this.tblEmp.getRowCount();
        for (int i = 0; i < size; ++i) {
            row = this.tblEmp.getRow(i);
            EmployeeTypeInfo empType = (EmployeeTypeInfo)row.getCell("colEmpType").getValue();
            if (empType == null) continue;
            keys.add(Integer.valueOf(empType.getInService().getValue()).toString());
        }
        HashMap<String, KDTDefaultCellEditor> editors = new HashMap<String, KDTDefaultCellEditor>();
        Iterator ite = keys.iterator();
        String key = null;
        while (ite.hasNext()) {
            key = (String)ite.next();
            editors.put(key, new KDTDefaultCellEditor((JComboBox)HRUtil.createBaseDataComboBox((AbstractObjectCollection)((AbstractObjectCollection)employeeTypeDetail.get(key)))));
        }
        if (keys.size() > 1) {
            int size2 = this.tblEmp.getRowCount();
            for (int i = 0; i < size2; ++i) {
                row = this.tblEmp.getRow(i);
                EmployeeTypeInfo empType = (EmployeeTypeInfo)row.getCell("colEmpType").getValue();
                if (empType != null) {
                    row.getCell("colEmpType").setEditor((ICellEditor)((KDTDefaultCellEditor)editors.get(Integer.valueOf(empType.getInService().getValue()).toString())));
                    continue;
                }
                row.getCell("colEmpType").getStyleAttributes().setLocked(true);
            }
        } else {
            this.tblEmp.getColumn("colEmpType").setEditor((ICellEditor)((KDTDefaultCellEditor)editors.get(key)));
        }
    }

    private void setEditor() throws Exception {
        KDBizPromptBox promptBox = new KDBizPromptBox();
        PositionPromptBox2 positionPromptBox = new PositionPromptBox2((IUIObject)this);
        if (this.getUIContext().get("hrSet") != null) {
            positionPromptBox.setHROFilter((HashSet)this.getUIContext().get("hrSet"));
        }
        promptBox.setSelector((KDPromptSelector)positionPromptBox);
        promptBox.setRequired(true);
        this.tblEmp.getColumn("colPosition").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)promptBox));
        KDBizPromptBox adminPromptBox = new KDBizPromptBox();
        adminPromptBox.setEditable(true);
        AdminByOrgRangePromptBox adminRangePromptBox = new AdminByOrgRangePromptBox((IUIObject)this);
        if (this.getUIContext().get("hrSet") != null) {
            adminRangePromptBox.setHROFilter((HashSet)this.getUIContext().get("hrSet"));
        }
        adminRangePromptBox.setIncludeSealUp("false");
        adminPromptBox.setSelector((KDPromptSelector)adminRangePromptBox);
        this.tblEmp.getColumn("adminDep").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)adminPromptBox));
        KDBizPromptBox promptBoxTax = new KDBizPromptBox();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)SysContext.getSysContext().getCurrentHRUnit().getId().toString()));
        view.setFilter(filter);
        promptBoxTax.setDisplayFormat("$name$");
        promptBoxTax.setCommitFormat("$number$");
        promptBoxTax.setEditFormat("$number$");
        promptBoxTax.setEntityViewInfo(view);
        promptBoxTax.setQueryInfo("com.kingdee.eas.hr.compensation.app.F7TaxSchemeQuery");
        this.tblEmp.getColumn("colTax").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)promptBoxTax));
        ArrayList<String> typeList = new ArrayList<String>();
        typeList.add(DiplomaFactory.class.getName());
        typeList.add(FolkFactory.class.getName());
        typeList.add(EmployeeTypeFactory.class.getName());
        typeList.add(PoliticalFaceFactory.class.getName());
        typeList.add("EmployeeTypeDetail");
        IBaseInnerFacade iBIF = BaseInnerFacadeFactory.getRemoteInstance();
        HashMap map = iBIF.getBaseData(typeList);
        this.tblEmp.getColumn("colDialop").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)HRUtil.createBaseDataComboBox((AbstractObjectCollection)((AbstractObjectCollection)map.get(DiplomaFactory.class.getName())))));
        this.tblEmp.getColumn("colFolk").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)HRUtil.createBaseDataComboBox((AbstractObjectCollection)((AbstractObjectCollection)map.get(FolkFactory.class.getName())))));
        this.setEmpTypeEditory((HashMap)map.get("EmployeeTypeDetail"));
        this.tblEmp.getColumn("colPolicy").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)HRUtil.createBaseDataComboBox((AbstractObjectCollection)((AbstractObjectCollection)map.get(PoliticalFaceFactory.class.getName())))));
        this.tblEmp.getColumn("colSex").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)new KDComboBox((ComboBoxModel)EmployeeBatchEditUI.getGenderComboModel())));
        this.tblEmp.getColumn("colBirthday").setEditor(EmployeeClientUtils.getStartDateCellEditor());
        this.tblEmp.getColumn("colBirthday").getStyleAttributes().setNumberFormat(EmployeeClientUtils.getDateFormatStr());
        this.tblEmp.getColumn("colEnterDate").setEditor(EmployeeClientUtils.getStartDateCellEditor());
        this.tblEmp.getColumn("colEnterDate").getStyleAttributes().setNumberFormat(EmployeeClientUtils.getDateFormatStr());
        this.tblEmp.getColumn("colWorkTime").setEditor(EmployeeClientUtils.getStartDateCellEditor());
        this.tblEmp.getColumn("colWorkTime").getStyleAttributes().setNumberFormat(EmployeeClientUtils.getDateFormatStr());
        KDTextField textField = new KDTextField();
        textField.setMaxLength(18);
        this.tblEmp.getColumn("colCardNo").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)textField));
        KDTextField postTextField = new KDTextField();
        postTextField.setMaxLength(18);
        this.tblEmp.getColumn("colPost").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)textField));
        this.tblEmp.addKDTEditListener(new KDTEditListener(){

            public void editStarting(KDTEditEvent e) {
            }

            public void editStarted(KDTEditEvent e) {
            }

            public void editValueChanged(KDTEditEvent e) {
            }

            public void editStopping(KDTEditEvent e) {
            }

            public void editStopped(KDTEditEvent e) {
            }

            public void editCanceled(KDTEditEvent e) {
            }
        });
        KDBizPromptBox jobGradePromptBox = new KDBizPromptBox();
        JobGradePromptBox jobBox = new JobGradePromptBox((IUIObject)this);
        jobBox.changeContextByCUSet((Set)this.getUIContext().get("cuSet"));
        jobGradePromptBox.setSelector((KDPromptSelector)jobBox);
        jobGradePromptBox.setQueryInfo("com.kingdee.eas.hr.org.app.JobGradeListQuery");
        jobGradePromptBox.setDisplayFormat("$name$");
        jobGradePromptBox.setEditFormat("$grade$");
        jobGradePromptBox.setCommitFormat("$grade$");
        jobGradePromptBox.setEntityViewInfo(this.getEntityViewInfoByCU((Set)this.getUIContext().get("cuSet")));
        this.tblEmp.getColumn("colJobGrade").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)jobGradePromptBox));
        KDFormattedTextField txtFormat = new KDFormattedTextField(0);
        txtFormat.setMaximumValue((Comparable)new BigDecimal("9999"));
        txtFormat.setMinimumValue((Comparable)new BigDecimal("0"));
        txtFormat.setPrecision(0);
        this.tblEmp.getColumn("tryoutMonth").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtFormat));
    }

    public DefaultComboBoxModel getEmployeeTypeComboModel() throws Exception {
        DefaultComboBoxModel<EmployeeTypeInfo> model = new DefaultComboBoxModel<EmployeeTypeInfo>();
        EmployeeTypeCollection typeInfos = this.getEmployeeTypes();
        for (int i = 0; i < typeInfos.size(); ++i) {
            model.addElement(typeInfos.get(i));
        }
        return model;
    }

    public EmployeeTypeCollection getEmployeeTypes() throws Exception {
        if (this.isEmp) {
            return EmployeeTypeFactory.getRemoteInstance().getEmployeeTypeCollection("Select * Where inService=1 and id <> '00000000-0000-0000-0000-000000000015A29E85B3'");
        }
        return EmployeeTypeFactory.getRemoteInstance().getEmployeeTypeCollection("Select * Where inService<>1 and id <> '00000000-0000-0000-0000-000000000015A29E85B3'");
    }

    public static DefaultComboBoxModel getGenderComboModel() {
        DefaultComboBoxModel<Genders> model = new DefaultComboBoxModel<Genders>();
        model.addElement(Genders.Female);
        model.addElement(Genders.Male);
        model.setSelectedItem(Genders.Female);
        return model;
    }

    private void setPersonValue(PreChangeEvent e, PersonMultiPromptBox pmt) {
        if (pmt.getData() instanceof Object[]) {
            IRow curRow = null;
            Object[] obj = (Object[])pmt.getData();
            PersonInfo infoPerson = null;
            int length = obj.length;
            for (int i = 0; i < length; ++i) {
                infoPerson = (PersonInfo)obj[i];
                curRow = i == 0 ? this.tblEmp.getRow(KDTableUtil.getSelectedRow((KDTable)this.tblEmp)) : this.tblEmp.addRow();
                this.addNewRow(curRow, infoPerson, i);
            }
        }
    }

    private void addNewRow(IRow curRow, PersonInfo infoPerson, int i) {
        curRow.getCell("colPosition").getStyleAttributes().setLocked(true);
        curRow.getCell("id").setValue((Object)infoPerson.getId());
        curRow.getCell("colPosition").setValue(infoPerson.get("primaryPosition"));
        curRow.getCell("colNumber").setValue((Object)infoPerson.getNumber());
        curRow.getCell("colEmpName").setValue((Object)infoPerson);
        curRow.getCell("colEmpName").getStyleAttributes().setLocked(true);
        curRow.getCell("colSalery").setValue(infoPerson.get("isPayPerson"));
        curRow.getCell("saleryId").setValue(infoPerson.get("cmpId"));
        curRow.getCell("colSocial").setValue(infoPerson.get("isSocialPerson"));
        curRow.getCell("socialId").setValue(infoPerson.get("socialId"));
        curRow.getCell("colCardNo").setValue((Object)infoPerson.getIdCardNO());
        curRow.getCell("colPost").setValue((Object)infoPerson.getPassportNO());
        curRow.getCell("colTax").setValue(infoPerson.get("cmpTaxScheme"));
        curRow.getCell("colSex").setValue((Object)infoPerson.getGender());
        curRow.getCell("colBirthday").setValue((Object)infoPerson.getBirthday());
        curRow.getCell("colFolk").setValue((Object)infoPerson.getFolk());
        curRow.getCell("colPolicy").setValue((Object)infoPerson.getPoliticalFace());
        curRow.getCell("colEmpType").setValue((Object)infoPerson.getEmployeeType());
        if (infoPerson.get("empPP") != null) {
            curRow.getCell("empPPId").setValue((Object)((PersonPositionInfo)infoPerson.get("empPP")).getId());
            curRow.getCell("colEnterDate").setValue((Object)((PersonPositionInfo)infoPerson.get("empPP")).getEnterDate());
            curRow.getCell("colWorkTime").setValue((Object)((PersonPositionInfo)infoPerson.get("empPP")).getJobStartDate());
            curRow.getCell("adminDep").setValue((Object)((PersonPositionInfo)infoPerson.get("empPP")).getPersonDep());
            curRow.getCell("colJobGrade").setValue((Object)((PersonPositionInfo)infoPerson.get("empPP")).getJobGrade());
            curRow.getCell("tryoutMonth").setValue((Object)((PersonPositionInfo)infoPerson.get("empPP")).getTryoutMonth());
        }
        if (infoPerson.get("degreeInfo") != null) {
            curRow.getCell("degreeId").setValue((Object)((PersonDegreeInfo)infoPerson.get("degreeInfo")).getId());
            curRow.getCell("colDialop").setValue((Object)((PersonDegreeInfo)infoPerson.get("degreeInfo")).getDiploma());
        }
    }

    @Override
    public void initUIToolBarLayout() {
        super.initUIToolBarLayout();
        EmployeeClientUtils.initTableBtn((JButton)this.btnWorkInsert, (JButton)this.btnWorkDelete);
        this.btnBatchCopy.setIcon(EASResource.getIcon((String)"imgTbtn_copytotier"));
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.pInfos = new PersonCollection();
        PersonInfo pInfo = null;
        PersonPositionInfo ppInfo = null;
        PersonDegreeInfo pDegreeInfo = null;
        PersonCmpInfo pCmpInfo = null;
        SocialInsuranceInfo socialInfo = null;
        PositionMemberCollection pmColl = null;
        PositionMemberInfo pmInfo = null;
        for (int i = 0; i < this.tblEmp.getRowCount(); ++i) {
            pInfo = new PersonInfo();
            if (this.tblEmp.getRow(i).getCell("id").getValue() != null) {
                pInfo.setId(BOSUuid.read((String)this.tblEmp.getRow(i).getCell("id").getValue().toString()));
            }
            pInfo.setName(this.tblEmp.getRow(i).getCell("colEmpName").getValue().toString());
            if (this.tblEmp.getRow(i).getCell("colNumber").getValue() != null) {
                pInfo.setNumber(this.tblEmp.getRow(i).getCell("colNumber").getValue().toString());
            }
            pInfo.setEmployeeType((EmployeeTypeInfo)this.tblEmp.getRow(i).getCell("colEmpType").getValue());
            if (this.tblEmp.getRow(i).getCell("colCardNo").getValue() != null) {
                pInfo.setIdCardNO(this.tblEmp.getRow(i).getCell("colCardNo").getValue().toString());
            } else {
                pInfo.setIdCardNO(null);
            }
            if (this.tblEmp.getRow(i).getCell("colPost").getValue() != null) {
                pInfo.setPassportNO(this.tblEmp.getRow(i).getCell("colPost").getValue().toString());
            } else {
                pInfo.setPassportNO(null);
            }
            if (this.tblEmp.getRow(i).getCell("colSex").getValue() == null) {
                pInfo.setGender(Genders.Female);
            } else {
                pInfo.setGender((Genders)this.tblEmp.getRow(i).getCell("colSex").getValue());
            }
            pInfo.setBirthday((Date)this.tblEmp.getRow(i).getCell("colBirthday").getValue());
            pInfo.setFolk((FolkInfo)this.tblEmp.getRow(i).getCell("colFolk").getValue());
            pInfo.setPoliticalFace((PoliticalFaceInfo)this.tblEmp.getRow(i).getCell("colPolicy").getValue());
            ppInfo = new PersonPositionInfo();
            if (this.tblEmp.getRow(i).getCell("empPPId").getValue() != null) {
                ppInfo.setId(BOSUuid.read((String)this.tblEmp.getRow(i).getCell("empPPId").getValue().toString()));
            }
            ppInfo.setGkAdmin((AdminOrgUnitInfo)this.tblEmp.getRow(i).getCell("adminDep").getValue());
            ppInfo.setEnterDate((Date)this.tblEmp.getRow(i).getCell("colEnterDate").getValue());
            ppInfo.setJobStartDate((Date)this.tblEmp.getRow(i).getCell("colWorkTime").getValue());
            if (this.tblEmp.getRow(i).getCell("colWorkTime").getValue() != null) {
                ppInfo.setWorkTime(this.computeDateYear((Date)this.tblEmp.getRow(i).getCell("colWorkTime").getValue(), new Date()).intValue());
            } else {
                ppInfo.setWorkTime(0L);
            }
            if (this.tblEmp.getRow(i).getCell("colJobGrade").getValue() != null) {
                ppInfo.setJobGrade((JobGradeInfo)this.tblEmp.getRow(i).getCell("colJobGrade").getValue());
            }
            if (this.tblEmp.getRow(i).getCell("tryoutMonth").getValue() != null) {
                ppInfo.setTryoutMonth((Integer)this.tblEmp.getRow(i).getCell("tryoutMonth").getValue());
                if (this.tblEmp.getRow(i).getCell("colEnterDate").getValue() != null) {
                    Date newDate = DateTimeUtils.addMonth((Date)((Date)this.tblEmp.getRow(i).getCell("colEnterDate").getValue()), (int)((Integer)this.tblEmp.getRow(i).getCell("tryoutMonth").getValue()));
                    ppInfo.setFormalDate(newDate);
                }
            }
            ppInfo.setIsEnrollAgain(false);
            pInfo.put("personPositionInfo", (Object)ppInfo);
            pDegreeInfo = new PersonDegreeInfo();
            if (this.tblEmp.getRow(i).getCell("degreeId").getValue() != null) {
                pDegreeInfo.setId(BOSUuid.read((String)this.tblEmp.getRow(i).getCell("degreeId").getValue().toString()));
            }
            if (this.tblEmp.getRow(i).getCell("colDialop").getValue() != null) {
                pDegreeInfo.setDiploma((DiplomaInfo)this.tblEmp.getRow(i).getCell("colDialop").getValue());
            }
            pDegreeInfo.setIsHighest(true);
            if (this.tblEmp.getRow(i).getCell("degreeId").getValue() != null || this.tblEmp.getRow(i).getCell("colDialop").getValue() != null) {
                pInfo.put("degreeInfo", (Object)pDegreeInfo);
            }
            pCmpInfo = new PersonCmpInfo();
            if (this.tblEmp.getRow(i).getCell("saleryId").getValue() != null) {
                pCmpInfo.setId(BOSUuid.read((String)this.tblEmp.getRow(i).getCell("saleryId").getValue().toString()));
            }
            pCmpInfo.setIsPayPerson(Boolean.valueOf(this.tblEmp.getRow(i).getCell("colSalery").getValue().toString()));
            pCmpInfo.setCmpTaxScheme((TaxSchemeInfo)this.tblEmp.getRow(i).getCell("colTax").getValue());
            pCmpInfo.setIsSociety(false);
            pInfo.put("cmpInfo", (Object)pCmpInfo);
            socialInfo = new SocialInsuranceInfo();
            if (this.tblEmp.getRow(i).getCell("socialId").getValue() != null) {
                socialInfo.setId(BOSUuid.read((String)this.tblEmp.getRow(i).getCell("socialId").getValue().toString()));
            }
            if (this.tblEmp.getRow(i).getCell("colSocial").getValue() != null) {
                socialInfo.setIsSocialInsu(Boolean.valueOf(this.tblEmp.getRow(i).getCell("colSocial").getValue().toString()));
            } else {
                socialInfo.setIsSocialInsu(false);
            }
            pInfo.put("socialInfo", (Object)socialInfo);
            if (this.tblEmp.getRow(i).getCell("colPosition").getValue() != null) {
                pInfo.put("position", this.tblEmp.getRow(i).getCell("colPosition").getValue());
                if (this.tblEmp.getRow(i).getCell("id").getValue() == null) {
                    pmColl = new PositionMemberCollection();
                    pmInfo = new PositionMemberInfo();
                    pmInfo.setPosition((PositionInfo)this.tblEmp.getRow(i).getCell("colPosition").getValue());
                    pmInfo.setIsPrimary(true);
                    pmColl.add(pmInfo);
                    pInfo.put("PositionList", (Object)pmColl);
                }
            } else {
                pInfo.put("position", null);
                pInfo.put("PositionList", null);
            }
            this.pInfos.add(pInfo);
        }
    }

    private Integer computeDateYear(Date oldDate, Date nowDate) {
        if (oldDate == null || nowDate == null || !DateTimeUtils.dayBefore((Date)oldDate, (Date)nowDate)) {
            return 0;
        }
        Calendar dateCal = Calendar.getInstance();
        dateCal.setTime(oldDate);
        Calendar nowCal = Calendar.getInstance();
        nowCal.setTime(nowDate);
        nowCal.add(5, 1);
        int dateYear = dateCal.get(1);
        int nowYear = nowCal.get(1);
        int dateMonth = dateCal.get(2) + 1;
        int nowMonth = nowCal.get(2) + 1;
        int dateDay = dateCal.get(5);
        int nowDay = nowCal.get(5);
        int tempYear = nowYear - dateYear;
        int tempMonth = nowMonth - dateMonth;
        int tempDay = nowDay - dateDay;
        if (tempDay < 0) {
            --tempMonth;
        }
        int YY = (tempYear * 12 + tempMonth) / 12;
        return YY;
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.checkInput();
        this.storeFields();
        IEmpInnerFacade iInner = EmpInnerFacadeFactory.getRemoteInstance();
        IObjectPK[] pk = iInner.personBatchSubmit(this.pInfos, null);
        if (this.getUIContext().get("cadre") != null) {
            MsgBox.showInfo((String)EASResource.getString((String)empInfoSource, (String)"CADRE_SAVE"));
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)(this.resClass + "PERSONSAVESUCCESS")));
        }
        PersonInfo pInfo = null;
        PersonCollection pInfos = new PersonCollection();
        this.tblEmp.removeRows();
        for (int i = 0; i < pk.length; ++i) {
            pInfo = new PersonInfo();
            pInfo.setId(BOSUuid.read((String)pk[i].toString()));
            pInfos.add(pInfo);
        }
        this.addModifyDataToTable(pInfos);
    }

    protected String getClassAlise() {
        return EASResource.getString((String)(this.resClass + "PERSON_TITLE"));
    }

    private void checkInput() throws Exception {
        if (this.isEmp) {
            EmployeeClientUtils.checkTableCellIsNull(this.tblEmp, "colPosition");
        }
        if (this.noPosition) {
            EmployeeClientUtils.checkTableCellIsNull(this.tblEmp, "adminDep");
        }
        EmployeeClientUtils.checkTableCellIsNull(this.tblEmp, "colEmpName");
        if (!this.isUseIntermitNumber) {
            EmployeeClientUtils.checkTableCellIsNull(this.tblEmp, "colNumber");
        }
        IRow curRow = null;
        int m = 0;
        IPerson iPerson = PersonFactory.getRemoteInstance();
        PersonCollection sInfos = null;
        for (int i = 0; i < this.tblEmp.getRowCount(); ++i) {
            curRow = this.tblEmp.getRow(i);
            m = i + 1;
            String strCard = curRow.getCell("colCardNo").getValue() != null ? curRow.getCell("colCardNo").getValue().toString() : null;
            String strPassport = curRow.getCell("colPost").getValue() != null ? curRow.getCell("colPost").getValue().toString() : null;
            if (StringUtils.isEmpty((String)strCard) && StringUtils.isEmpty((String)strPassport)) {
                if (curRow.getCell("colNumber").getValue() != null) {
                    MsgBox.showInfo((String)(EASResource.getString((String)empInfoSource, (String)"WHERELINE") + m + EASResource.getString((String)empInfoSource, (String)"WHICHLINE") + curRow.getCell("colNumber").getValue().toString() + EASResource.getString((String)empInfoSource, (String)"BOTHNULL")));
                } else {
                    MsgBox.showInfo((String)(EASResource.getString((String)empInfoSource, (String)"WHERELINE") + m + EASResource.getString((String)empInfoSource, (String)"EMPLOYEECONTRACT_ROW_EMP") + curRow.getCell("colEmpName").getValue().toString() + EASResource.getString((String)empInfoSource, (String)"BOTHNULL")));
                }
                SysUtil.abort();
            }
            String id = null;
            if (curRow.getCell("id").getValue() != null) {
                id = curRow.getCell("id").getValue().toString();
            }
            if (!StringUtils.isEmpty((String)strCard)) {
                try {
                    Object sexValue = curRow.getCell("colSex").getValue();
                    this.isIDCardVerify = this.isIDcardVerifyByID(id);
                    if (this.isIDCardVerify) {
                        IDCardCommonUtil idUtil = new IDCardCommonUtil(strCard);
                        if (sexValue instanceof Genders && !sexValue.equals(idUtil.getGenders())) {
                            throw new BaseException((Throwable)((Object)new HrEmpBizException(HrEmpBizException.EXCEPTION7)));
                        }
                    }
                }
                catch (BaseException e) {
                    MsgBox.showInfo((String)(EASResource.getString((String)empInfoSource, (String)"WHERELINE") + m + EASResource.getString((String)empInfoSource, (String)"EMPLOYEECONTRACT_ROW_EMP") + e.getMessage()));
                    SysUtil.abort();
                }
            }
            if (curRow.getCell("colPost").getValue() != null) {
                if (!StringUtils.isEmpty((String)curRow.getCell("colPost").getValue().toString())) {
                    sInfos = iPerson.getPersonCollection("Select id Where passportNO='" + curRow.getCell("colPost").getValue().toString().trim() + "'");
                }
                if (sInfos.size() > 0) {
                    if (sInfos.get(0).getId().toString().equals(id)) {
                        if (sInfos.size() > 1) {
                            MsgBox.showInfo((String)(EASResource.getString((String)empInfoSource, (String)"WHERELINE") + m + EASResource.getString((String)empInfoSource, (String)"HAVEEXITNOPOST")));
                            SysUtil.abort();
                        }
                    } else {
                        MsgBox.showInfo((String)(EASResource.getString((String)empInfoSource, (String)"WHERELINE") + m + EASResource.getString((String)empInfoSource, (String)"HAVEEXITNOPOST")));
                        SysUtil.abort();
                    }
                }
            }
            if (Boolean.valueOf(curRow.getCell("colSalery").getValue().toString()).booleanValue() || curRow.getCell("colTax").getValue() == null) continue;
            throw new EmployeeException(EmployeeException.NOT_SALARY_PERSON_TAT, new Object[]{i});
        }
        EmployeeClientUtils.checkTableCellIsNull(this.tblEmp, "colEmpType");
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        this.tblEmp.removeRows();
        this.setOprtState(OprtState.ADDNEW);
    }

    public void addCodingRule(Object cell, ObjectBaseInfo bgTpInfo, boolean isModify) throws EASBizException, BOSException {
        String number = null;
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
        String strCurCompany = iCodingRuleManager.getCurrentAppOUID((IObjectValue)bgTpInfo);
        try {
            if (strCurCompany == null || strCurCompany.equals("")) {
                return;
            }
            if (iCodingRuleManager.isExist((IObjectValue)bgTpInfo, strCurCompany)) {
                if (isModify) {
                    return;
                }
                if (iCodingRuleManager.isUseIntermitNumber((IObjectValue)bgTpInfo, strCurCompany)) {
                    if (iCodingRuleManager.isAddView((IObjectValue)bgTpInfo, strCurCompany)) {
                        number = iCodingRuleManager.readNumber((IObjectValue)bgTpInfo, strCurCompany);
                    } else {
                        this.isUseIntermitNumber = true;
                    }
                } else if (iCodingRuleManager.isAddView((IObjectValue)bgTpInfo, strCurCompany)) {
                    number = iCodingRuleManager.getNumber((IObjectValue)bgTpInfo, strCurCompany);
                }
                ICell cellObj = (ICell)cell;
                if (iCodingRuleManager.isModifiable((IObjectValue)bgTpInfo, strCurCompany)) {
                    cellObj.getStyleAttributes().setLocked(false);
                } else {
                    cellObj.getStyleAttributes().setLocked(true);
                }
                cellObj.setValue((Object)number);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void actionInsert_actionPerformed(ActionEvent e) throws Exception {
        super.actionInsert_actionPerformed(e);
        IRow curRow = this.tblEmp.addRow();
        curRow.getCell("colPosition").setValue((Object)this.positionInfo);
        curRow.getCell("colEmpName").setEditor(null);
        PersonInfo personInfo = new PersonInfo();
        personInfo.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        this.addCodingRule(curRow.getCell("colNumber"), (ObjectBaseInfo)personInfo, false);
        curRow.getCell("colSalery").setValue((Object)Boolean.valueOf("false"));
        curRow.getCell("colSocial").setValue((Object)Boolean.valueOf("false"));
        curRow.getCell("colSex").setValue((Object)Genders.Female);
        String[] str = EmpFieldPermissionUtil.disableEmpBathColStr;
        int length = str.length;
        for (int i = 0; i < length; ++i) {
            curRow.getCell(str[i]).getStyleAttributes().setLocked(false);
        }
    }

    @Override
    protected void tblEmp_editStopped(KDTEditEvent e) throws Exception {
        super.tblEmp_editStopped(e);
        int colIndex = e.getColIndex();
        int rowIndex = e.getRowIndex();
        if (colIndex == this.tblEmp.getColumnIndex("colSalery")) {
            if (this.tblEmp.getCell(rowIndex, "id").getValue() != null) {
                String personId = this.tblEmp.getCell(rowIndex, "id").getValue().toString();
                String personNum = this.tblEmp.getCell(rowIndex, "colNumber").getValue().toString();
                ICmpSchemePerFacade iCmpSchemePerFacade = CmpSchemePerFacadeFactory.getRemoteInstance();
                if (iCmpSchemePerFacade.checkPersonCmp(personId)) {
                    Object[] param = new Object[]{personNum};
                    this.tblEmp.getCell(rowIndex, "colSalery").setValue(e.getOldValue());
                    throw new HasSalaryException(HasSalaryException.PER_NOT_CHANGE, param);
                }
            }
        } else if (colIndex == this.tblEmp.getColumn("colCardNo").getColumnIndex()) {
            String value = (String)e.getValue();
            if (StringUtils.isEmpty((String)value)) {
                return;
            }
            IRow row = this.tblEmp.getRow(rowIndex);
            String colName = this.tblEmp.getColumnKey(colIndex);
            if (colName != null && colName.equals("colCardNo")) {
                try {
                    this.isIDCardVerify = this.isIDcardVerify();
                    if (this.isIDCardVerify) {
                        IDCardCommonUtil iDCardCommonUtil = new IDCardCommonUtil(value);
                        row.getCell("colBirthday").setValue((Object)DateTimeUtils.parseDate((String)iDCardCommonUtil.getBirthday(), (String)"yyyy-MM-dd"));
                        row.getCell("colSex").setValue((Object)iDCardCommonUtil.getGenders());
                    }
                }
                catch (BaseException be) {
                    MsgBox.showError((String)be.getMessage());
                }
            }
        }
    }

    @Override
    public void actionDelete_actionPerformed(ActionEvent e) throws Exception {
        super.actionDelete_actionPerformed(e);
        int iSelectRow = KDTableUtil.getSelectedRow((KDTable)this.tblEmp);
        this.tblEmp.removeRow(iSelectRow);
    }

    protected IObjectValue createNewData() {
        return new PersonInfo();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return PersonFactory.getRemoteInstance();
    }

    private EntityViewInfo getEntityViewInfoByCU(Set cuSet) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (cuSet != null && cuSet.size() > 0) {
            Iterator it = cuSet.iterator();
            HashSet<String> cuidSet = new HashSet<String>();
            Object ob = null;
            while (it.hasNext()) {
                ob = it.next();
                if (ob instanceof CtrlUnitInfo) {
                    cuidSet.add(((CtrlUnitInfo)ob).getId().toString());
                    continue;
                }
                cuidSet.add(ob);
            }
            filter.getFilterItems().add(new FilterItemInfo("toAdminCU.id", cuidSet, CompareType.INCLUDE));
        }
        filter.getFilterItems().add(new FilterItemInfo("jobGradeModuleState.enable", (Object)"1"));
        viewInfo.setFilter(filter);
        return viewInfo;
    }

    public boolean isIDcardVerify() throws Exception {
        String paramNum = "IS_IDCARD_VERIFY";
        String hrOrgId = null;
        HROrgUnitInfo hrOrg = SysContext.getSysContext().getCurrentHRUnit();
        if (hrOrg != null) {
            hrOrgId = hrOrg.getId().toString();
        }
        this.isIDCardVerify = HRParamUtil.getParamOfHR(null, (String)paramNum, (String)hrOrgId);
        return this.isIDCardVerify;
    }

    private boolean isIDcardVerifyByID(String personId) throws Exception {
        String paramNum = "IS_IDCARD_VERIFY";
        String hrOrgId = null;
        IHROrgContextManagerFacade fac = HROrgContextManagerFacadeFactory.getRemoteInstance();
        HROrgUnitInfo hrOrg = fac.getHROByPerson(personId);
        if (hrOrg != null) {
            hrOrgId = hrOrg.getId().toString();
        } else {
            hrOrg = SysContext.getSysContext().getCurrentHRUnit();
            if (null != hrOrg) {
                hrOrgId = hrOrg.getId().toString();
            } else {
                return false;
            }
        }
        this.isIDCardVerify = HRParamUtil.getParamOfHR(null, (String)paramNum, (String)hrOrgId);
        return this.isIDCardVerify;
    }
}

