/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.client;

import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDRadioButton;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.AdminF7;
import com.kingdee.eas.hr.emp.client.AbstractEmployeeCollectFilterUI;
import com.kingdee.eas.hr.emp.client.EmpCollectFilterInfo;
import com.kingdee.eas.hr.emp.client.EmployeeClientUtils;
import com.kingdee.eas.hr.emp.client.EmployeeCollectOldUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.DateTimeUtils;
import java.awt.event.ActionEvent;
import java.util.Date;
import javax.swing.DefaultComboBoxModel;

public class EmployeeCollectFilterUI
extends AbstractEmployeeCollectFilterUI {
    String periodType = "PERIODTYPE_YEAR";
    public boolean isCancel = true;

    private void initF7() {
        AdminF7 adminF7 = new AdminF7((IUIObject)this);
        adminF7.setIsCUFilter(true);
        adminF7.disablePerm(null, false);
        this.promptOrg.setSelector((KDPromptSelector)adminF7);
    }

    private void loadLayerType() throws Exception {
    }

    private void loadInterval() {
        DefaultComboBoxModel<IntvlType> model = new DefaultComboBoxModel<IntvlType>();
        model.addElement(new IntvlType("MONTH", EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.MONTH")));
        model.addElement(new IntvlType("QUARTER", EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.QUARTER")));
        model.addElement(new IntvlType("HALFYEAR", EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.HALFYEAR")));
        model.addElement(new IntvlType("YEAR", EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.YEAR")));
        this.comboInterval.setModel(model);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        EmployeeClientUtils.checkHasDefaultAdminOrg();
        this.initF7();
        this.lblObj.setIcon(EASResource.getIcon((String)"imgLableword_btn"));
        this.lblPeriod.setIcon(EASResource.getIcon((String)"imgLableword_btn"));
        this.loadInterval();
        this.loadDatas();
    }

    public void loadDatas() {
        EmpCollectFilterInfo filterInfo = (EmpCollectFilterInfo)this.getUIContext().get("filterInfo");
        if (filterInfo != null) {
            this.rdPercent.setSelected(filterInfo.isCaculatePercent);
            this.rdLastYear.setSelected(filterInfo.isCompareToLastYear);
            int size = this.comboInterval.getItemCount();
            for (int i = 0; i < size; ++i) {
                if (!filterInfo.intervalType.equals(((IntvlType)this.comboInterval.getItemAt(i)).getValue())) continue;
                this.comboInterval.setSelectedIndex(i);
                break;
            }
            this.promptOrg.setValue((Object)filterInfo.org);
            this.dateBegin.setValue((Object)filterInfo.ctrlBeginDate);
            this.dateEnd.setValue((Object)filterInfo.ctrlEndDate);
            if (filterInfo.rdName.equals("PERIOD")) {
                this.dateBegin.setValue((Object)filterInfo.beginDate);
                this.dateEnd.setValue((Object)filterInfo.endDate);
                this.dateBegin.setEnabled(true);
                this.dateEnd.setEnabled(true);
                this.rdPeriod.setSelected(true);
            } else {
                this.dateBegin.setEnabled(false);
                this.dateEnd.setEnabled(false);
                if (filterInfo.rdName.equals("QUARTER")) {
                    this.rdQuarter.setSelected(true);
                } else if (filterInfo.rdName.equals("TODAY")) {
                    this.rdToday.setSelected(true);
                } else if (filterInfo.rdName.equals("YEAR")) {
                    this.rdYear.setSelected(true);
                }
            }
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void rdToday_actionPerformed(ActionEvent e) throws Exception {
        this.radioActionPerformed(e);
    }

    @Override
    protected void rdQuarter_actionPerformed(ActionEvent e) throws Exception {
        this.radioActionPerformed(e);
    }

    @Override
    protected void rdYear_actionPerformed(ActionEvent e) throws Exception {
        this.radioActionPerformed(e);
    }

    @Override
    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.isCancel = false;
        this.getUIWindow().close();
    }

    public EmpCollectFilterInfo getFilterInfo() {
        if (this.isCancel) {
            return null;
        }
        EmpCollectFilterInfo filterInfo = new EmpCollectFilterInfo();
        Date[] dates = this.getDates();
        filterInfo.beginDate = dates[0];
        filterInfo.endDate = dates[1];
        filterInfo.ctrlBeginDate = (Date)this.dateBegin.getValue();
        filterInfo.ctrlEndDate = (Date)this.dateEnd.getValue();
        filterInfo.periodType = this.periodType;
        filterInfo.org = (OrgUnitInfo)this.promptOrg.getValue();
        filterInfo.intervalType = ((IntvlType)this.comboInterval.getSelectedItem()).getValue();
        filterInfo.isCompareToLastYear = this.rdLastYear.isSelected();
        filterInfo.isCaculatePercent = this.rdPercent.isSelected();
        filterInfo.rdName = this.rdPeriod.isSelected() ? "PERIOD" : (this.rdQuarter.isSelected() ? "QUARTER" : (this.rdToday.isSelected() ? "TODAY" : "YEAR"));
        return filterInfo;
    }

    private String getUIName() {
        return EmployeeCollectOldUI.class.getName();
    }

    protected String getUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UINewTabFactory";
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.isCancel = true;
        this.getUIWindow().close();
    }

    @Override
    protected void rdPeriod_actionPerformed(ActionEvent e) throws Exception {
        this.radioActionPerformed(e);
    }

    private Date[] getDates() {
        Date[] dates = new Date[2];
        Date today = new Date();
        String intvlType = ((IntvlType)this.comboInterval.getSelectedItem()).getValue();
        if (!this.periodType.equals("PERIODTYPE_PERIOD")) {
            if (this.periodType.equals("PERIODTYPE_YEAR")) {
                dates[0] = new Date(today.getYear(), 0, 1);
                dates[1] = new Date(today.getYear(), 11, 31);
            } else if (this.periodType.equals("PERIODTYPE_QUARTER")) {
                int quarter = DateTimeUtils.getQuarter((Date)today);
                dates[0] = new Date(today.getYear(), 3 * (quarter - 1), 1);
                dates[1] = quarter == 4 ? DateTimeUtils.addDay((Date)new Date(today.getYear() + 1, 0, 1), (long)-1L) : DateTimeUtils.addDay((Date)new Date(today.getYear(), dates[0].getMonth() + 3, 1), (long)-1L);
            } else if (this.periodType.equals("PERIOD_TODAY")) {
                if (intvlType.equals("YEAR")) {
                    dates[0] = new Date(today.getYear(), 0, 1);
                    dates[1] = new Date(today.getYear(), 11, 31);
                } else if (intvlType.equals("QUARTER")) {
                    int quarter = DateTimeUtils.getQuarter((Date)today);
                    dates[0] = new Date(today.getYear(), 3 * (quarter - 1), 1);
                    dates[1] = quarter == 4 ? DateTimeUtils.addDay((Date)new Date(today.getYear() + 1, 0, 1), (long)-1L) : DateTimeUtils.addDay((Date)new Date(today.getYear(), dates[0].getMonth() + 3, 1), (long)-1L);
                } else if (intvlType.equals("MONTH")) {
                    dates[0] = new Date(today.getYear(), today.getMonth(), 1);
                    int month = today.getMonth();
                    dates[1] = month == 11 ? DateTimeUtils.addDay((Date)new Date(today.getYear() + 1, 0, 1), (long)-1L) : DateTimeUtils.addDay((Date)new Date(today.getYear(), month + 1, 1), (long)-1L);
                } else if (intvlType.equals("HALFYEAR")) {
                    int halfYear = EmployeeClientUtils.getHalfYear(DateTimeUtils.getQuarter((Date)today));
                    dates[0] = new Date(today.getYear(), 6 * (halfYear - 1), 1);
                    dates[1] = halfYear == 2 ? DateTimeUtils.addDay((Date)new Date(today.getYear() + 1, 0, 1), (long)-1L) : DateTimeUtils.addDay((Date)new Date(today.getYear(), dates[0].getMonth() + 6, 1), (long)-1L);
                }
            }
        } else {
            Date beginDate = (Date)this.dateBegin.getValue();
            Date endDate = (Date)this.dateEnd.getValue();
            if (intvlType.equals("YEAR")) {
                dates[0] = new Date(beginDate.getYear(), 0, 1);
                dates[1] = new Date(endDate.getYear(), 11, 31);
            } else if (intvlType.equals("QUARTER")) {
                int qrtrBegin = DateTimeUtils.getQuarter((Date)beginDate);
                int qrtrEnd = DateTimeUtils.getQuarter((Date)endDate);
                dates[0] = new Date(beginDate.getYear(), 3 * (qrtrBegin - 1), 1);
                dates[1] = qrtrEnd == 4 ? DateTimeUtils.addDay((Date)new Date(endDate.getYear() + 1, 0, 1), (long)-1L) : DateTimeUtils.addDay((Date)new Date(endDate.getYear(), 3 * qrtrBegin, 1), (long)-1L);
            } else if (intvlType.equals("MONTH")) {
                dates[0] = new Date(beginDate.getYear(), beginDate.getMonth(), 1);
                int month = endDate.getMonth();
                dates[1] = month == 11 ? DateTimeUtils.addDay((Date)new Date(endDate.getYear() + 1, 0, 1), (long)-1L) : DateTimeUtils.addDay((Date)new Date(endDate.getYear(), month + 1, 1), (long)-1L);
            } else if (intvlType.equals("HALFYEAR")) {
                int hlfYrBegin = EmployeeClientUtils.getHalfYear(DateTimeUtils.getQuarter((Date)beginDate));
                int hlfYrEnd = EmployeeClientUtils.getHalfYear(DateTimeUtils.getQuarter((Date)endDate));
                dates[0] = new Date(beginDate.getYear(), 6 * (hlfYrBegin - 1), 1);
                dates[1] = hlfYrEnd == 2 ? DateTimeUtils.addDay((Date)new Date(endDate.getYear() + 1, 0, 1), (long)-1L) : DateTimeUtils.addDay((Date)new Date(endDate.getYear(), 6 * hlfYrBegin, 1), (long)-1L);
            }
        }
        return dates;
    }

    private void radioActionPerformed(ActionEvent e) throws Exception {
        KDRadioButton radio = (KDRadioButton)e.getSource();
        if (radio == this.rdPeriod) {
            this.dateBegin.setEnabled(true);
            this.dateEnd.setEnabled(true);
            this.periodType = "PERIODTYPE_PERIOD";
        } else {
            this.dateBegin.setEnabled(false);
            this.dateEnd.setEnabled(false);
            this.periodType = radio == this.rdToday ? "PERIOD_TODAY" : (radio == this.rdYear ? "PERIODTYPE_YEAR" : "PERIODTYPE_QUARTER");
        }
    }

    private static class IntvlType {
        String _value;
        String _alias;

        public IntvlType(String value, String alias) {
            this._value = value;
            this._alias = alias;
        }

        public String getValue() {
            return this._value;
        }

        public String getAlias() {
            return this._alias;
        }

        public String toString() {
            return this._alias;
        }
    }
}

