/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeManager;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.hr.emp.EmpCollectFacadeFactory;
import com.kingdee.eas.hr.emp.IEmpCollectFacade;
import com.kingdee.eas.hr.emp.client.AbstractEmployeeCollectUI;
import com.kingdee.eas.hr.emp.client.EmpCollectFilterInfo;
import com.kingdee.eas.hr.emp.client.EmpCollectListUI;
import com.kingdee.eas.hr.emp.client.EmployeeClientUtils;
import com.kingdee.eas.hr.emp.client.EmployeeCollectFilterUI;
import com.kingdee.eas.hr.emp.client.HRCellTreeRenderer;
import com.kingdee.eas.hr.emp.client.HRCellUserObject;
import com.kingdee.eas.hr.emp.client.HRTreeTable;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.tree.MutableTreeNode;

public class EmployeeCollectOldUI
extends AbstractEmployeeCollectUI {
    private static final int COUNT_COL_WIDTH = 50;
    private static final int PARTIMECOUNT_COL_WIDTH = 50;
    private static final int ONSTRCOUNT_COL_WIDTH = 50;
    private static final int OFFSTRCOUNT_COL_WIDTH = 50;
    private static final int LASTYEARCOUNT_COL_WIDTH = 70;
    private static final int RATE_COL_WIDTH = 50;
    private static final int PERSENT_COL_WIDTH = 70;
    private static final int FNAME_COL_WIDTH = 200;
    DefaultKingdeeTreeNode childNode = null;
    EmpCollectFilterInfo filterInfo = null;
    int groupCount = -1;
    int beginYear = -1;
    int beginMonth = -1;
    int endYear = -1;
    int endMonth = -1;
    int beginQuarter = -1;
    int endQuarter = -1;
    int beginHalfYear = -1;
    int endHalfYear = -1;
    int minLevel = -1;
    int maxLevel = -1;
    int groupColCount = 4;
    boolean paramPartimeOnStr = false;
    boolean paramPartimeOrg = false;
    IEmpCollectFacade ie = EmpCollectFacadeFactory.getRemoteInstance();

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnQuery.setText(null);
        this.btnQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.btnPrint.setText(null);
        this.btnPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.btnPrintPreview.setText(null);
        this.btnPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.kdtPerson);
        this.kdtPerson.getPrintManager().print();
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.kdtPerson);
        this.kdtPerson.getPrintManager().printPreview();
    }

    private void initParam() throws EASBizException, BOSException {
        HashMap<String, ObjectUuidPK> numMap = new HashMap<String, ObjectUuidPK>();
        ObjectUuidPK adminOrgId = new ObjectUuidPK(SysContext.getSysContext().getCurrentAdminUnit().getId());
        numMap.put("HROP0020", adminOrgId);
        numMap.put("HROP0021", adminOrgId);
        IParamControl pc = ParamControlFactory.getRemoteInstance();
        HashMap valueMap = pc.getParamHashMap(numMap);
        if (valueMap.get("HROP0020") != null) {
            this.paramPartimeOnStr = Boolean.valueOf((String)valueMap.get("HROP0020"));
        }
        if (valueMap.get("HROP0021") != null) {
            this.paramPartimeOrg = Boolean.valueOf((String)valueMap.get("HROP0021"));
        }
    }

    private void initInnerFilter() {
        this.beginYear = DateTimeUtils.getYear((Date)this.filterInfo.beginDate);
        this.endYear = DateTimeUtils.getYear((Date)this.filterInfo.endDate);
        this.beginMonth = this.filterInfo.beginDate.getMonth();
        this.endMonth = this.filterInfo.endDate.getMonth();
        this.beginQuarter = DateTimeUtils.getQuarter((Date)this.filterInfo.beginDate);
        this.endQuarter = DateTimeUtils.getQuarter((Date)this.filterInfo.endDate);
        this.beginHalfYear = EmployeeClientUtils.getHalfYear(this.beginQuarter);
        this.endHalfYear = EmployeeClientUtils.getHalfYear(this.endQuarter);
        if (this.filterInfo.intervalType.equals("YEAR")) {
            this.groupCount = this.endYear + 1 - this.beginYear;
        } else if (this.filterInfo.intervalType.equals("QUARTER")) {
            this.groupCount = (this.endYear - this.beginYear) * 4 + (this.endQuarter - this.beginQuarter + 1);
        } else if (this.filterInfo.intervalType.equals("MONTH")) {
            this.groupCount = (this.endYear - this.beginYear) * 12 + (this.endMonth - this.beginMonth + 1);
        } else if (this.filterInfo.intervalType.equals("HALFYEAR")) {
            this.groupCount = (this.endYear - this.beginYear) * 2 + (this.endHalfYear - this.beginHalfYear + 1);
        }
        ++this.beginMonth;
        ++this.endMonth;
        if (this.filterInfo.isCompareToLastYear && this.filterInfo.isCaculatePercent) {
            this.groupColCount = 7;
        } else if (this.filterInfo.isCompareToLastYear && !this.filterInfo.isCaculatePercent) {
            this.groupColCount = 6;
        } else if (!this.filterInfo.isCompareToLastYear && this.filterInfo.isCaculatePercent) {
            this.groupColCount = 5;
        }
    }

    private String getLocaleSuffix() {
        return "_" + SysContext.getSysContext().getLocale().toString().toUpperCase();
    }

    private IRowSet getDatas() throws Exception {
        String longNumber = null;
        if (this.filterInfo.org != null) {
            longNumber = this.filterInfo.org.getLongNumber();
        } else {
            AdminOrgUnitInfo adminInfo = SysContext.getSysContext().getCurrentAdminUnit();
            if (adminInfo != null) {
                longNumber = adminInfo.getLongNumber();
            }
        }
        IEmpCollectFacade iemp = EmpCollectFacadeFactory.getRemoteInstance();
        return iemp.getRows(this.filterInfo.beginDate, this.filterInfo.endDate, this.filterInfo.isCompareToLastYear, this.filterInfo.intervalType, longNumber, this.filterInfo.isIncludeSubCUs);
    }

    private String getLstYrSuffixByData(int year, int interval) {
        return this.getSuffixByData(year + 1, interval);
    }

    private String getSuffixByData(int year, int interval) {
        if (interval != -100) {
            String tmp = "_" + String.valueOf(year) + "_" + String.valueOf(interval) + "_";
            return tmp + this.filterInfo.intervalType;
        }
        return "_" + String.valueOf(year);
    }

    private String getColName(String suffix, String name) {
        return name + suffix;
    }

    private String getPercentFmtStr() {
        return "%r-{##########.##!%}.2f";
    }

    private void calcuPercent() {
        if (!this.filterInfo.isCaculatePercent) {
            return;
        }
        String zeroStr = "0";
        int rowCount = this.kdtPerson.getRowCount();
        Object tmpValue = null;
        Object tmpAllValue = null;
        double tmpCount = -1.0;
        double tmpAllCount = -1.0;
        String colNameSuffix = null;
        for (int i = 1; i <= this.groupCount; ++i) {
            colNameSuffix = this.getColNameSuffix(i);
            for (int j = 0; j < rowCount; ++j) {
                if (j == 0) {
                    tmpAllValue = this.kdtPerson.getRow(j).getCell("COUNT" + colNameSuffix).getValue();
                    if (tmpAllValue == null || tmpAllValue.toString().equals(zeroStr)) continue;
                    tmpAllCount = Double.parseDouble(tmpAllValue.toString());
                }
                if ((tmpValue = this.kdtPerson.getRow(j).getCell("COUNT" + colNameSuffix).getValue()) == null || tmpValue.toString().equals(zeroStr)) continue;
                tmpCount = Double.parseDouble(tmpValue.toString());
                this.kdtPerson.getRow(j).getCell("PERSENT" + colNameSuffix).setValue((Object)new Double(tmpCount * 100.0 / tmpAllCount));
            }
        }
    }

    private void calcuRate() {
        if (!this.filterInfo.isCompareToLastYear) {
            return;
        }
        int rowCount = this.kdtPerson.getRowCount();
        Object tmpValue = null;
        Object tmpLstYrValue = null;
        String colNameSuffix = null;
        for (int i = 1; i <= this.groupCount; ++i) {
            colNameSuffix = this.getColNameSuffix(i);
            for (int j = 0; j < rowCount; ++j) {
                tmpValue = this.kdtPerson.getRow(j).getCell("COUNT" + colNameSuffix).getValue();
                if (tmpValue == null || (tmpLstYrValue = this.kdtPerson.getRow(j).getCell("LASTYEARCOUNT" + colNameSuffix).getValue()) == null) continue;
                double tmpCount = Double.parseDouble(tmpValue.toString());
                double tmpLstYrCount = Double.parseDouble(tmpLstYrValue.toString());
                if (tmpLstYrCount == 0.0) continue;
                this.kdtPerson.getRow(j).getCell("RATE" + colNameSuffix).setValue((Object)new Double((tmpCount - tmpLstYrCount) * 100.0 / tmpLstYrCount));
            }
        }
    }

    private void getDataList(DefaultKingdeeTreeNode treeNode, ArrayList list) {
        list.add(treeNode.getUserObject());
        for (int i = 0; i < treeNode.getChildCount(); ++i) {
            this.getDataList((DefaultKingdeeTreeNode)treeNode.getChildAt(i), list);
        }
    }

    private DefaultKingdeeTreeNode getRoot(IRowSet rows) throws Exception {
        if (rows.size() == 0) {
            return null;
        }
        DefaultKingdeeTreeNode root = null;
        DefaultKingdeeTreeNode curNode = null;
        DefaultKingdeeTreeNode parent = null;
        DefaultKingdeeTreeNode childNode = null;
        int curLevel = -1;
        Integer index = null;
        int childCount = -1;
        String curId = null;
        int i = 0;
        boolean flag = true;
        while (rows.next()) {
            if (i == 0) {
                root = this.makeNode(rows);
                curLevel = this.getLevel(root);
                curId = this.getId(root);
                curNode = root;
            } else if (!curId.equals(rows.getString("FAdminOrgID"))) {
                parent = curLevel == rows.getInt("FLevel") ? (DefaultKingdeeTreeNode)curNode.getParent() : (curLevel < rows.getInt("FLevel") ? curNode : this.getParent(curNode, curLevel - rows.getInt("FLevel")));
                curNode = this.makeNode(rows);
                index = this.getIndex(curNode);
                childCount = parent.getChildCount();
                if (childCount == 0) {
                    parent.add((MutableTreeNode)curNode);
                } else if (index == 0) {
                    parent.insert((MutableTreeNode)curNode, 0);
                } else {
                    flag = true;
                    int size = childCount;
                    for (int j = 0; j < size; ++j) {
                        childNode = (DefaultKingdeeTreeNode)parent.getChildAt(j);
                        if (index >= this.getIndex(childNode)) continue;
                        parent.insert((MutableTreeNode)curNode, j);
                        flag = false;
                        break;
                    }
                    if (flag) {
                        parent.add((MutableTreeNode)curNode);
                    }
                }
            } else {
                this.putValues(rows, curNode);
            }
            ++i;
            curId = rows.getString("FAdminOrgID");
            curLevel = rows.getInt("FLevel");
        }
        return root;
    }

    private String getId(DefaultKingdeeTreeNode node) {
        return ((HashMap)node.getUserObject()).get("FAdminOrgID").toString();
    }

    private void putValues(IRowSet rows, DefaultKingdeeTreeNode node) throws Exception {
        HashMap<String, Integer> values = new HashMap<String, Integer>();
        values.put("FInterval", rows.getInt("FInterval"));
        values.put("FYear", rows.getInt("FYear"));
        values.put("FCount", rows.getInt("FCount"));
        values.put("FPartimeCount", rows.getInt("FPartimeCount"));
        values.put("FOffStreCount", rows.getInt("FOffStreCount"));
        values.put("FOnStreCount", rows.getInt("FCount"));
        values.put("FOnStreCount2", rows.getInt("FCount"));
        HashMap map = (HashMap)node.getUserObject();
        ((ArrayList)map.get("valueList")).add(values);
    }

    private DefaultKingdeeTreeNode makeNode(IRowSet rows) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FLongNumber", rows.getString("FLongNumber"));
        map.put("FIndex", rows.getInt("FIndex"));
        map.put("FIsLeaf", rows.getBoolean("FIsLeaf"));
        map.put("FLevel", rows.getInt("FLevel"));
        map.put("FAdminOrgID", rows.getString("FAdminOrgID"));
        map.put("FName", rows.getString("FName"));
        HashMap<String, Integer> values = new HashMap<String, Integer>();
        values.put("FInterval", rows.getInt("FInterval"));
        values.put("FYear", rows.getInt("FYear"));
        values.put("FCount", rows.getInt("FCount"));
        values.put("FPartimeCount", rows.getInt("FPartimeCount"));
        values.put("FOffStreCount", rows.getInt("FOffStreCount"));
        values.put("FOnStreCount", rows.getInt("FCount"));
        values.put("FOnStreCount2", rows.getInt("FCount"));
        ArrayList<HashMap<String, Integer>> list = new ArrayList<HashMap<String, Integer>>();
        list.add(values);
        map.put("valueList", list);
        return new DefaultKingdeeTreeNode(map);
    }

    private DefaultKingdeeTreeNode getParent(DefaultKingdeeTreeNode node, int levelInteval) {
        DefaultKingdeeTreeNode parent = null;
        if (levelInteval == 0) {
            return (DefaultKingdeeTreeNode)node.getParent();
        }
        parent = (DefaultKingdeeTreeNode)node.getParent();
        return this.getParent(parent, levelInteval - 1);
    }

    private Integer getIndex(DefaultKingdeeTreeNode node) {
        return (Integer)((HashMap)node.getUserObject()).get("FIndex");
    }

    private int getLevel(DefaultKingdeeTreeNode node) {
        return (Integer)((HashMap)node.getUserObject()).get("FLevel");
    }

    private void initSortedDatas() throws Exception {
        IRowSet datas = this.getDatas();
        IRow row = null;
        DefaultKingdeeTreeNode root = null;
        try {
            root = this.getRoot(datas);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            SQLUtils.cleanup((ResultSet)datas);
        }
        if (root == null) {
            return;
        }
        ArrayList valueList = new ArrayList();
        this.getDataList(root, valueList);
        int year = -1;
        int interval = -1;
        String orgIdColName = "FAdminOrgID";
        String orgNameColName = "FName";
        String curAdminId = "";
        double tmpCount = 0.0;
        double tmpLstYrCount = 0.0;
        HRCellTreeRenderer orgCellRen = new HRCellTreeRenderer();
        HashMap values = null;
        HashMap map = null;
        ArrayList list = null;
        int count = valueList.size();
        for (int k = 0; k < count; ++k) {
            values = (HashMap)valueList.get(k);
            row = this.kdtPerson.addRow();
            HRCellUserObject orgCellObj = new HRCellUserObject();
            orgCellObj.setCompanyId(values.get(orgIdColName).toString());
            orgCellObj.setName(values.get(orgNameColName).toString());
            orgCellObj.setLongNumber(values.get("FLongNumber").toString());
            orgCellObj.setIsLeaf((Boolean)values.get("FIsLeaf"));
            orgCellObj.setLevel((Integer)values.get("FLevel"));
            orgCellObj.setExpanded(true);
            row.getCell(orgIdColName).setValue((Object)values.get(orgIdColName).toString());
            row.getCell(orgNameColName).setValue((Object)orgCellObj);
            row.getCell(orgNameColName).setRenderer((IBasicRender)orgCellRen);
            list = (ArrayList)values.get("valueList");
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                map = (HashMap)list.get(i);
                int tmpYear = (Integer)map.get("FYear");
                int tmpInteval = (Integer)map.get("FInterval");
                String tmpColNameSuffix = this.getSuffixByData(tmpYear, tmpInteval);
                String tmpLstYrColNameSuffix = this.getLstYrSuffixByData(tmpYear, tmpInteval);
                if (this.isInPeriod(tmpYear, tmpInteval, true)) {
                    if (this.paramPartimeOrg) {
                        row.getCell(this.getColName(tmpColNameSuffix, "COUNT")).setValue((Object)((Integer)map.get("FCount") + (Integer)map.get("FPartimeCount")));
                    } else {
                        row.getCell(this.getColName(tmpColNameSuffix, "COUNT")).setValue((Object)((Integer)map.get("FCount")));
                    }
                    row.getCell(this.getColName(tmpColNameSuffix, "PARTIMECOUNT")).setValue((Object)((Integer)map.get("FPartimeCount")));
                    row.getCell(this.getColName(tmpColNameSuffix, "OFFSTRCOUNT")).setValue((Object)((Integer)map.get("FOffStreCount")));
                    if (this.paramPartimeOnStr) {
                        row.getCell(this.getColName(tmpColNameSuffix, "ONSTRCOUNT")).setValue((Object)((Integer)map.get("FOnStreCount")));
                    } else {
                        row.getCell(this.getColName(tmpColNameSuffix, "ONSTRCOUNT")).setValue((Object)((Integer)map.get("FOnStreCount2")));
                    }
                }
                if (!this.filterInfo.isCompareToLastYear || !this.isInPeriod(tmpYear, tmpInteval, false)) continue;
                if (this.paramPartimeOrg) {
                    row.getCell(this.getColName(tmpLstYrColNameSuffix, "LASTYEARCOUNT")).setValue((Object)((Integer)map.get("FCount") + (Integer)map.get("FPartimeCount")));
                    continue;
                }
                row.getCell(this.getColName(tmpLstYrColNameSuffix, "LASTYEARCOUNT")).setValue((Object)((Integer)map.get("FCount")));
            }
        }
        if (this.filterInfo.isCompareToLastYear) {
            this.calcuRate();
        }
        if (this.filterInfo.isCaculatePercent) {
            this.calcuPercent();
        }
        HRTreeTable.setHRTreeTable(this.kdtPerson, orgNameColName);
    }

    private void initDatas() throws Exception {
        IRowSet datas = this.getDatas();
        IRow row = null;
        int year = -1;
        int interval = -1;
        String orgIdColName = "FAdminOrgID";
        String orgNameColName = "FName" + this.getLocaleSuffix();
        String curAdminId = "";
        double tmpCount = 0.0;
        double tmpLstYrCount = 0.0;
        int i = -1;
        HRCellTreeRenderer orgCellRen = new HRCellTreeRenderer();
        while (datas.next()) {
            int tmpYear = datas.getInt("FYear");
            int tmpInteval = datas.getInt("FInterval");
            String tmpColNameSuffix = this.getSuffixByData(tmpYear, tmpInteval);
            String tmpLstYrColNameSuffix = this.getLstYrSuffixByData(tmpYear, tmpInteval);
            if (!curAdminId.equals(datas.getString(orgIdColName))) {
                row = this.kdtPerson.addRow();
                HRCellUserObject orgCellObj = new HRCellUserObject();
                orgCellObj.setCompanyId(datas.getString(orgIdColName));
                orgCellObj.setName(datas.getString(orgNameColName));
                orgCellObj.setLongNumber(datas.getString("FLongNumber"));
                orgCellObj.setIsLeaf(datas.getBoolean("FIsLeaf"));
                orgCellObj.setLevel(datas.getInt("FLevel"));
                orgCellObj.setExpanded(true);
                row.getCell(orgIdColName).setValue((Object)datas.getString(orgIdColName));
                row.getCell(orgNameColName).setValue((Object)orgCellObj);
                row.getCell(orgNameColName).setRenderer((IBasicRender)orgCellRen);
            } else {
                row = this.kdtPerson.getRow(i);
            }
            if (this.isInPeriod(tmpYear, tmpInteval, true)) {
                if (this.paramPartimeOrg) {
                    row.getCell(this.getColName(tmpColNameSuffix, "COUNT")).setValue((Object)(datas.getInt("FCount") + datas.getInt("FPartimeCount")));
                } else {
                    row.getCell(this.getColName(tmpColNameSuffix, "COUNT")).setValue((Object)datas.getInt("FCount"));
                }
                row.getCell(this.getColName(tmpColNameSuffix, "PARTIMECOUNT")).setValue((Object)datas.getInt("FPartimeCount"));
                row.getCell(this.getColName(tmpColNameSuffix, "OFFSTRCOUNT")).setValue((Object)datas.getInt("FOffStreCount"));
                if (this.paramPartimeOnStr) {
                    row.getCell(this.getColName(tmpColNameSuffix, "ONSTRCOUNT")).setValue((Object)datas.getInt("FOnStreCount"));
                } else {
                    row.getCell(this.getColName(tmpColNameSuffix, "ONSTRCOUNT")).setValue((Object)datas.getInt("FOnStreCount2"));
                }
            }
            if (this.filterInfo.isCompareToLastYear && this.isInPeriod(tmpYear, tmpInteval, false)) {
                if (this.paramPartimeOrg) {
                    row.getCell(this.getColName(tmpLstYrColNameSuffix, "LASTYEARCOUNT")).setValue((Object)(datas.getInt("FCount") + datas.getInt("FPartimeCount")));
                } else {
                    row.getCell(this.getColName(tmpLstYrColNameSuffix, "LASTYEARCOUNT")).setValue((Object)datas.getInt("FCount"));
                }
            }
            if (!curAdminId.equals(datas.getString(orgIdColName))) {
                ++i;
            }
            curAdminId = datas.getString(orgIdColName);
        }
        if (this.filterInfo.isCompareToLastYear) {
            this.calcuRate();
        }
        if (this.filterInfo.isCaculatePercent) {
            this.calcuPercent();
        }
        HRTreeTable.setHRTreeTable(this.kdtPerson, orgNameColName);
    }

    private boolean isInPeriod(int year, int count, boolean isCurrent) {
        if (count == -100) {
            if (isCurrent) {
                return year >= this.beginYear && year <= this.endYear;
            }
            return year >= this.beginYear - 1 && year <= this.endYear - 1;
        }
        int i = 12;
        int beginCount = this.beginMonth;
        int endCount = this.endMonth;
        if (this.filterInfo.intervalType.equals("QUARTER")) {
            i = 4;
            beginCount = this.beginQuarter;
            endCount = this.endQuarter;
        } else if (this.filterInfo.intervalType.equals("HALFYEAR")) {
            i = 2;
            beginCount = this.beginHalfYear;
            endCount = this.endHalfYear;
        }
        if (isCurrent) {
            return year * i + count >= this.beginYear * i + beginCount && year * i + count <= this.endYear * i + endCount;
        }
        return year * i + count >= (this.beginYear - 1) * i + beginCount && year * i + count <= (this.endYear - 1) * i + endCount;
    }

    private String getColNameSuffix(int curGroup) {
        String suffix = "_";
        int year = -1;
        int num = -1;
        if (this.filterInfo.intervalType.equals("YEAR")) {
            suffix = suffix + (this.beginYear + curGroup - 1);
        } else if (this.filterInfo.intervalType.equals("QUARTER")) {
            num = (this.beginQuarter + curGroup - 1) % 4;
            year = (this.beginQuarter + curGroup - 1) / 4 + this.beginYear;
            if (num == 0) {
                num = 4;
                --year;
            }
            suffix = suffix + year + "_" + num + "_" + "QUARTER";
        } else if (this.filterInfo.intervalType.equals("MONTH")) {
            num = (this.beginMonth + curGroup - 1) % 12;
            year = (this.beginMonth + curGroup - 1) / 12 + this.beginYear;
            if (num == 0) {
                num = 12;
                --year;
            }
            suffix = suffix + year + "_" + num + "_" + "MONTH";
        } else if (this.filterInfo.intervalType.equals("HALFYEAR")) {
            num = (this.beginHalfYear + curGroup - 1) % 2;
            year = (this.beginHalfYear + curGroup - 1) / 2 + this.beginYear;
            if (num == 0) {
                num = 2;
                --year;
            }
            suffix = suffix + year + "_" + num + "_" + "HALFYEAR";
        }
        return suffix;
    }

    private void setLevels() throws EASBizException, BOSException {
        int[] value = this.ie.getLevels(this.filterInfo.org == null ? null : this.filterInfo.org.getLongNumber());
        this.minLevel = value[0];
        this.maxLevel = value[1];
        if (this.minLevel == -1) {
            // empty if block
        }
    }

    private void initTableColumn() {
        IColumn col = null;
        col = this.kdtPerson.addColumn();
        col.setKey("FAdminOrgID");
        col = this.kdtPerson.addColumn();
        col.setKey("FName");
        col.setWidth(200);
        String colNameSuffix = null;
        String frmStr = this.getPercentFmtStr();
        for (int i = 1; i <= this.groupCount; ++i) {
            colNameSuffix = this.getColNameSuffix(i);
            col = this.kdtPerson.addColumn();
            col.setKey("COUNT" + colNameSuffix);
            col.setWidth(50);
            col = this.kdtPerson.addColumn();
            col.setKey("PARTIMECOUNT" + colNameSuffix);
            col.setWidth(50);
            col = this.kdtPerson.addColumn();
            col.setKey("ONSTRCOUNT" + colNameSuffix);
            col.setWidth(50);
            col = this.kdtPerson.addColumn();
            col.setKey("OFFSTRCOUNT" + colNameSuffix);
            col.setWidth(50);
            if (this.filterInfo.isCompareToLastYear) {
                col = this.kdtPerson.addColumn();
                col.setKey("LASTYEARCOUNT" + colNameSuffix);
                col.setWidth(70);
                col = this.kdtPerson.addColumn();
                col.setKey("RATE" + colNameSuffix);
                col.setWidth(50);
            }
            if (!this.filterInfo.isCaculatePercent) continue;
            col = this.kdtPerson.addColumn();
            col.setKey("PERSENT" + colNameSuffix);
            col.setWidth(70);
        }
    }

    private String getHeaderCellAlias(String cellName, int index) {
        if (cellName.equals("FAdminOrgID")) {
            return "FAdminOrgID";
        }
        if (cellName.equals("FName")) {
            return EmployeeClientUtils.getAlias("ORGNAME");
        }
        String[] strArry = StringUtils.split((String)cellName, (String)"_");
        if (index == 0) {
            if (strArry.length == 2) {
                return strArry[1] + EmployeeClientUtils.ALIAS_YEAR;
            }
            if (this.filterInfo.intervalType.equals("HALFYEAR")) {
                return strArry[1] + EmployeeClientUtils.ALIAS_YEAR + EmployeeClientUtils.getAlias("HALFYEAR_" + strArry[2]) + EmployeeClientUtils.getAlias(strArry[3]) + EmployeeClientUtils.ALIAS_COUNTUNIT;
            }
            return strArry[1] + EmployeeClientUtils.ALIAS_YEAR + strArry[2] + EmployeeClientUtils.getAlias(strArry[3]) + EmployeeClientUtils.ALIAS_COUNTUNIT;
        }
        return EmployeeClientUtils.getAlias(strArry[0]);
    }

    private void initTableHeader() {
        int i;
        IRow row = null;
        String key = null;
        row = this.kdtPerson.addHeadRow();
        int size = this.kdtPerson.getColumnCount();
        for (i = 0; i < size; ++i) {
            key = this.kdtPerson.getColumnKey(i);
            row.getCell(key).setValue((Object)this.getHeaderCellAlias(key, 0));
        }
        row = this.kdtPerson.addHeadRow();
        size = this.kdtPerson.getColumnCount();
        for (i = 0; i < size; ++i) {
            key = this.kdtPerson.getColumnKey(i);
            row.getCell(key).setValue((Object)this.getHeaderCellAlias(key, 1));
        }
        KDTMergeManager merger = this.kdtPerson.getHeadMergeManager();
        merger.mergeBlock(0, 0, 1, 0, 3);
        merger.mergeBlock(0, 1, 1, 1, 3);
        for (int i2 = 0; i2 < this.groupCount; ++i2) {
            merger.mergeBlock(0, 2 + i2 * this.groupColCount, 0, 2 + (i2 + 1) * this.groupColCount - 1, 3);
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnQuery.setText(null);
        this.btnQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.kdtPerson.checkParsed();
        this.initParam();
        this.loadFilterUI(false);
        this.kdtPerson.getStyleAttributes().setLocked(true);
        this.kdtPerson.getSelectManager().setSelectMode(2);
    }

    private void setTableStyle() {
        this.kdtPerson.getSelectManager().setSelectMode(2);
        this.kdtPerson.getColumn("FAdminOrgID").getStyleAttributes().setHided(true);
        this.kdtPerson.getStyleAttributes().setLocked(true);
    }

    private void clearTable() {
        this.kdtPerson.removeRows();
        this.kdtPerson.removeColumns();
    }

    private void initUI() throws Exception {
        this.initInnerFilter();
        this.clearTable();
        this.initTableColumn();
        this.initTableHeader();
        this.initSortedDatas();
        this.setZeroCell();
        this.setTableStyle();
    }

    private void setZeroCell() {
        int rowCount = this.kdtPerson.getRowCount();
        int colCount = this.kdtPerson.getColumnCount();
        IRow row = null;
        Object value = null;
        for (int i = 0; i < rowCount; ++i) {
            row = this.kdtPerson.getRow(i);
            for (int j = 2; j < colCount; ++j) {
                value = row.getCell(j).getValue();
                if (value == null || (!(value instanceof Integer) || (Integer)value != 0) && (!(value instanceof Double) || (Double)value != 0.0)) continue;
                row.getCell(j).setValue(null);
            }
        }
    }

    public void initListener() {
    }

    @Override
    protected void kdtPerson_tableClicked(KDTMouseEvent e) throws Exception {
        super.kdtPerson_tableClicked(e);
        if (e.getClickCount() == 2) {
            int index = e.getRowIndex();
            if (index == -1) {
                return;
            }
            IRow row = this.kdtPerson.getRow(index);
            if (row.getCell("FAdminOrgID").getValue() == null) {
                return;
            }
            String adminOrgId = row.getCell("FAdminOrgID").getValue().toString();
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"AdminOrgId", (Object)adminOrgId);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(EmpCollectListUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
            uiWindow.show();
        }
    }

    public void loadFilterUI(boolean loaded) throws Exception {
        UIContext ctx = new UIContext((Object)this);
        ctx.put((Object)"Owner", (Object)((Component)this.getUIContext().get("OwnerWindow")));
        if (this.filterInfo != null) {
            ctx.put((Object)"filterInfo", (Object)this.filterInfo);
        }
        IUIWindow curDialog = null;
        IUIFactory uiFactory = null;
        uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        curDialog = uiFactory.create(EmployeeCollectFilterUI.class.getName(), (Map)ctx);
        curDialog.show();
        EmployeeCollectFilterUI filterUI = (EmployeeCollectFilterUI)curDialog.getUIObject();
        this.filterInfo = filterUI.getFilterInfo();
        if (filterUI.isCancel && !loaded) {
            SysUtil.abort();
        }
        if (this.filterInfo != null) {
            this.initUI();
        }
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        this.loadFilterUI(true);
    }
}

