/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.person.BloodType;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.hr.base.client.ListEditUI;
import com.kingdee.eas.hr.emp.IPersonLinkman;
import com.kingdee.eas.hr.emp.PersonLinkmanCollection;
import com.kingdee.eas.hr.emp.PersonLinkmanFactory;
import com.kingdee.eas.hr.emp.client.AbstractEmployeeLinkmanUI;
import com.kingdee.eas.hr.emp.client.EmployeeClientUtils;
import com.kingdee.eas.hr.emp.client.IEmpInfoUI;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;

public class EmployeeLinkmanUI
extends AbstractEmployeeLinkmanUI
implements IEmpInfoUI {
    private String empId = null;
    private PersonInfo pInfo = null;
    private ArrayList delList = new ArrayList();

    private void checkInput() throws Exception {
        EmployeeClientUtils.checkTableCellIsNull(this.kdtLinkman, "name");
        EmployeeClientUtils.checkTableCellIsNull(this.kdtLinkman, "phoneNumber");
        EmployeeClientUtils.checkTableCellIsNull(this.kdtLinkman, "bloodType");
        EmployeeClientUtils.checkHasInputRows(this.kdtLinkman, this.delList);
    }

    @Override
    public void submit() throws Exception {
        this.checkInput();
        IObjectPK[] delArray = new IObjectPK[this.delList.size()];
        for (int i = 0; i < this.delList.size(); ++i) {
            delArray[i] = new ObjectUuidPK((BOSUuid)this.delList.get(i));
        }
        IPersonLinkman ipl = PersonLinkmanFactory.getRemoteInstance();
        ipl.saveAll(EmployeeClientUtils.getLinkmanCollectionByKDTable(this.kdtLinkman, EmployeeClientUtils.getPersonInfo(this.empId)), delArray);
        ListEditUI listEditUI = (ListEditUI)this.getUIContext().get("ListEditUI");
        listEditUI.setStatusBarMessage();
        this.refresh();
    }

    private void setBloodTypeCellEditor() {
        KDComboBox combo = new KDComboBox();
        DefaultComboBoxModel model = new DefaultComboBoxModel();
        Iterator iter = BloodType.iterator();
        while (iter.hasNext()) {
            model.addElement(iter.next());
        }
        combo.setModel(model);
        this.kdtLinkman.getColumn("bloodType").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)combo));
    }

    public void firstOnLoad() throws Exception {
        this.refresh();
    }

    private PersonLinkmanCollection getlinkmanColl(String empId) throws BOSException {
        IPersonLinkman ipl = PersonLinkmanFactory.getRemoteInstance();
        String oql = "select * where person.id = '" + empId + "'";
        return ipl.getPersonLinkmanCollection(oql);
    }

    private void refresh() throws Exception {
        this.kdtLinkman.removeRows();
        this.loadRecords();
    }

    @Override
    public void secondLoad() throws Exception {
        this.firstOnLoad();
    }

    public void onLoad() throws Exception {
        this.empId = (String)this.getUIContext().get("ID");
        super.onLoad();
        EmployeeClientUtils.initTableBtn((JButton)this.btnLinkmanAddNew, (JButton)this.btnLinkmanDelete);
        this.kdtLinkman.checkParsed();
        this.setBloodTypeCellEditor();
        if (this.getOprtState().equals(OprtState.VIEW)) {
            EmployeeClientUtils.setKDTableViewState(this.kdtLinkman);
            this.btnLinkmanAddNew.setEnabled(false);
            this.btnLinkmanDelete.setEnabled(false);
        }
        EmployeeClientUtils.setColumnBackColor(this.kdtLinkman, "name");
        EmployeeClientUtils.setColumnBackColor(this.kdtLinkman, "phoneNumber");
        EmployeeClientUtils.setColumnBackColor(this.kdtLinkman, "bloodType");
        this.kdtLinkman.getStyleAttributes().setWrapText(true);
        this.firstOnLoad();
        this.initCellEditLength();
    }

    void initCellEditLength() {
        EmployeeClientUtils.setCellEditor(this.kdtLinkman, "name");
        EmployeeClientUtils.setCellEditor(this.kdtLinkman, "desc");
        EmployeeClientUtils.setCellEditor(this.kdtLinkman, "orgName");
    }

    private void loadRecords() throws Exception {
        if (this.getUIContext().get("ID") != null) {
            this.empId = this.getUIContext().get("ID").toString();
        }
        PersonLinkmanCollection c = this.getlinkmanColl(this.empId);
        Object row = null;
        for (int i = 0; i < c.size(); ++i) {
            EmployeeClientUtils.setTableCellValueByInfo(this.kdtLinkman.addRow(), c.get(i));
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
        try {
            this.refresh();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionLinkmanAddNew_actionPerformed(ActionEvent e) throws Exception {
        EmployeeClientUtils.addNewKDTableRow(this.kdtLinkman);
    }

    @Override
    public void actionLinkmanDelete_actionPerformed(ActionEvent e) throws Exception {
        EmployeeClientUtils.deleteKDTableRow(this.kdtLinkman, this.delList);
    }

    @Override
    public void setAddNewState() throws Exception {
        EmployeeClientUtils.setAddNewState((CoreUI)this);
        this.refresh();
    }

    @Override
    public void setEmpID(String empId) {
        this.empId = empId;
    }

    @Override
    public void setEnabled(boolean isArchives) {
        if (!isArchives) {
            this.btnLinkmanAddNew.setEnabled(false);
            this.btnLinkmanDelete.setEnabled(false);
            this.kdtLinkman.setEnabled(false);
        }
    }

    protected IObjectValue createNewData() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return PersonLinkmanFactory.getRemoteInstance();
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.submit();
    }

    protected void inOnload() throws Exception {
    }
}

