/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.hraux.IBasicItem;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.hr.base.SpecialtyTypeFactory;
import com.kingdee.eas.hr.base.UnitTypeFactory;
import com.kingdee.eas.hr.base.client.ListEditUI;
import com.kingdee.eas.hr.emp.EmployeeException;
import com.kingdee.eas.hr.emp.IPersonWorkExp;
import com.kingdee.eas.hr.emp.PersonWorkExpCollection;
import com.kingdee.eas.hr.emp.PersonWorkExpFactory;
import com.kingdee.eas.hr.emp.client.AbstractEmployeeWorkExpUI;
import com.kingdee.eas.hr.emp.client.EmployeeClientUtils;
import com.kingdee.eas.hr.emp.client.IEmpInfoUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JTextField;

public class EmployeeWorkExpUI
extends AbstractEmployeeWorkExpUI
implements IEmpInfoUI {
    int rowID = 0;
    private String empId = null;
    private PersonInfo pInfo = null;
    private ArrayList delList = new ArrayList();
    private ArrayList delListCur = new ArrayList();

    @Override
    public void actionWorkExpAddNew_actionPerformed(ActionEvent e) throws Exception {
        EmployeeClientUtils.addNewKDTableRow(this.kdtWorkExp);
    }

    @Override
    public void actionWorkExpDelete_actionPerformed(ActionEvent e) throws Exception {
        EmployeeClientUtils.deleteKDTableRow(this.kdtWorkExp, this.delList);
    }

    private void setUnitTypeEditor() throws BOSException {
        this.kdtWorkExp.getColumn("unitType").setEditor(EmployeeClientUtils.getComboBoxCellEditor((IBasicItem)UnitTypeFactory.getRemoteInstance()));
    }

    private void setSpecialtyTypeEditor() throws BOSException {
        this.kdtWorkExp.getColumn("specialtyType").setEditor(EmployeeClientUtils.getComboBoxCellEditor((IBasicItem)SpecialtyTypeFactory.getRemoteInstance()));
    }

    private void setDateEditor() {
        this.kdtWorkExp.getColumn("beginDate").setEditor(EmployeeClientUtils.getStartDateCellEditor());
        this.kdtWorkExp.getColumn("beginDate").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
        this.kdtWorkExp.getColumn("endDate").setEditor(EmployeeClientUtils.getEndDateCellEditor());
        this.kdtWorkExp.getColumn("endDate").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
    }

    private void setSalaryEditor() {
        KDFormattedTextField kft = new KDFormattedTextField();
        kft.setDataType(4);
        kft.setPercentDisplay(true);
        kft.setPrecision(2);
        this.kdtWorkExp.getColumn("salary").setEditor(EmployeeClientUtils.getFloatCellEditor());
    }

    private void setTableCellEditor() throws BOSException {
        this.setDateEditor();
        this.setSalaryEditor();
        this.setSpecialtyTypeEditor();
        this.setUnitTypeEditor();
    }

    public void firstOnLoad() throws Exception {
        this.refreshWorkExp();
    }

    @Override
    public void secondLoad() throws Exception {
        this.firstOnLoad();
    }

    public void onLoad() throws Exception {
        this.empId = (String)this.getUIContext().get("ID");
        super.onLoad();
        EmployeeClientUtils.initTableBtn((JButton)this.btnWorkExpDelete, (JButton)this.btnWorkExpAddNew);
        this.kdtWorkExp.checkParsed();
        this.kdtWorkExp.getStyleAttributes().setWrapText(true);
        this.kdtWorkExp.getStyleAttributes().setVerticalAlign(Styles.VerticalAlignment.TOP);
        this.setTableCellEditor();
        this.kDLabel1.setIcon(EASResource.getIcon((String)"imgLableword_btn"));
        if (this.getOprtState().equals(OprtState.VIEW)) {
            EmployeeClientUtils.setKDTableViewState(this.kdtWorkExp);
            this.btnWorkExpAddNew.setEnabled(false);
            this.btnWorkExpDelete.setEnabled(false);
        }
        KDFormattedTextField integerField = new KDFormattedTextField(0);
        integerField.setHorizontalAlignment(4);
        integerField.putClientProperty((Object)"OriginValue", (Object)Boolean.TRUE);
        KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor((JTextField)integerField);
        this.kdtWorkExp.getColumn("personQuantity").setEditor((ICellEditor)cellEditor);
        this.kdtWorkExp.getColumn("personQuantity").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.kdtWorkExp.getColumn("subordinateQuantity").setEditor((ICellEditor)cellEditor);
        this.kdtWorkExp.getColumn("subordinateQuantity").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        EmployeeClientUtils.setColumnBackColor(this.kdtWorkExp, "beginDate");
        EmployeeClientUtils.setColumnBackColor(this.kdtWorkExp, "endDate");
        EmployeeClientUtils.setColumnBackColor(this.kdtWorkExp, "unitName");
        this.firstOnLoad();
        this.initCellEditLength();
    }

    void initCellEditLength() {
        EmployeeClientUtils.setCellEditor(this.kdtWorkExp, "unitName");
        EmployeeClientUtils.setCellEditor(this.kdtWorkExp, "unitAddress");
        EmployeeClientUtils.setCellEditor(this.kdtWorkExp, "workDept");
        EmployeeClientUtils.setCellEditor(this.kdtWorkExp, "job");
        EmployeeClientUtils.setCellEditor(this.kdtWorkExp, "dimission");
        EmployeeClientUtils.setCellEditor(this.kdtWorkExp, "linkman");
        EmployeeClientUtils.setCellEditor(this.kdtWorkExp, "remark");
        EmployeeClientUtils.setCellEditor(this.kdtWorkExp, "position");
        EmployeeClientUtils.setCellEditor(this.kdtWorkExp, "industryType");
        this.kdtWorkExp.getColumn("personQuantity").setEditor(EmployeeClientUtils.getIntCellEditor(Integer.valueOf(65535)));
        this.kdtWorkExp.getColumn("subordinateQuantity").setEditor(EmployeeClientUtils.getIntCellEditor(Integer.valueOf(65535)));
        this.kdtWorkExp.getColumn("salary").setEditor(EmployeeClientUtils.getIntCellEditor(Integer.valueOf(65535)));
        this.kdtWorkExp.getColumn("linkmanPhone").setEditor(EmployeeClientUtils.getFilterTextFieldCellEditor(25, 20));
    }

    private PersonWorkExpCollection getWXColl(String empId) throws BOSException {
        String oql = "select *, unitType.id, unitType.number, unitType.name,";
        oql = oql + "specialtyType.id, specialtyType.number, specialtyType.name ";
        oql = oql + "where person.id = '" + empId + "'";
        IPersonWorkExp ipwx = PersonWorkExpFactory.getRemoteInstance();
        return ipwx.getPersonWorkExpCollection(oql);
    }

    private void loadWorkExp() throws BOSException {
        if (this.getUIContext().get("ID") != null) {
            this.empId = this.getUIContext().get("ID").toString();
        }
        PersonWorkExpCollection c = this.getWXColl(this.empId);
        for (int i = 0; i < c.size(); ++i) {
            EmployeeClientUtils.setTableCellValueByInfo(this.kdtWorkExp.addRow(), c.get(i));
        }
    }

    private void refreshWorkExp() throws BOSException {
        this.kdtWorkExp.removeRows();
        this.loadWorkExp();
    }

    @Override
    public void submit() throws Exception {
        this.checkInput();
        IObjectPK[] delArray = new IObjectPK[this.delList.size()];
        for (int i = 0; i < this.delList.size(); ++i) {
            delArray[i] = new ObjectUuidPK((BOSUuid)this.delList.get(i));
        }
        IObjectPK[] delArrayCur = new IObjectPK[this.delListCur.size()];
        for (int i = 0; i < this.delListCur.size(); ++i) {
            delArrayCur[i] = new ObjectUuidPK((BOSUuid)this.delListCur.get(i));
        }
        IPersonWorkExp ipwx = PersonWorkExpFactory.getRemoteInstance();
        ipwx.saveAll(EmployeeClientUtils.getWorkExpCollectionByKDTable(this.kdtWorkExp, EmployeeClientUtils.getPersonInfo(this.empId)), delArray);
        ListEditUI listEditUI = (ListEditUI)this.getUIContext().get("ListEditUI");
        listEditUI.setStatusBarMessage();
        this.refreshWorkExp();
    }

    void checkInput() throws Exception {
        EmployeeClientUtils.checkTableCellIsNull(this.kdtWorkExp, "beginDate");
        EmployeeClientUtils.checkTableCellIsNull(this.kdtWorkExp, "endDate");
        EmployeeClientUtils.checkTableCellIsNull(this.kdtWorkExp, "unitName");
        for (int i = 0; i < this.kdtWorkExp.getRowCount(); ++i) {
            Date startDate = (Date)this.kdtWorkExp.getRow(i).getCell("beginDate").getValue();
            Date endDate = (Date)this.kdtWorkExp.getRow(i).getCell("endDate").getValue();
            if (startDate == null || endDate == null || !DateTimeUtils.dayAfter((Date)startDate, (Date)endDate)) continue;
            throw new EmployeeException(EmployeeException.BEGINDATE_NOT_DY_ENDDATE);
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
        try {
            this.refreshWorkExp();
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void setAddNewState() throws Exception {
        EmployeeClientUtils.setAddNewState((CoreUI)this);
        this.refreshWorkExp();
    }

    @Override
    public void setEmpID(String empId) {
        this.empId = empId;
    }

    @Override
    public void setEnabled(boolean isArchives) {
        if (!isArchives) {
            this.btnWorkExpAddNew.setEnabled(false);
            this.btnWorkExpDelete.setEnabled(false);
            this.kdtWorkExp.setEnabled(false);
        }
    }

    protected IObjectValue createNewData() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.submit();
    }

    protected void inOnload() throws Exception {
    }
}

