/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.client;

import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.SimpleTextRender;
import com.kingdee.bos.ctrl.kdf.util.render.icon.Icon;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.eas.hr.emp.TreeIcon;
import com.kingdee.eas.hr.emp.client.HRCellUserObject;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.Hashtable;
import java.util.Map;

public class HRCellTreeRenderer
implements IBasicRender {
    protected SimpleTextRender simpleRender = new SimpleTextRender();
    protected Icon cbIcon;
    private Map mapOfTreeNodeLocation = new Hashtable();

    public HRCellTreeRenderer() {
        this.cbIcon = new TreeIcon();
    }

    public boolean inRect(HRCellUserObject comUserObject, int x, int y) {
        String companyId = comUserObject.getCompanyId().toString();
        Rectangle rec = (Rectangle)this.mapOfTreeNodeLocation.get(companyId);
        if (rec != null) {
            return rec.getX() < (double)x && rec.getX() + rec.getWidth() > (double)x;
        }
        return false;
    }

    public void draw(Graphics g, Shape clip, Object value, Style style) {
        HRCellUserObject comUserObject = (HRCellUserObject)value;
        int ident = comUserObject.getLevel() * 15;
        Rectangle rect = clip.getBounds();
        int x = rect.x + ident;
        int y = rect.y + (rect.height - this.cbIcon.getHeight()) / 2;
        int v = comUserObject.isLeaf() ? 0 : (comUserObject.isExpanded() ? 2 : 1);
        Color color = style.getFontColor();
        g.setColor(color);
        Rectangle locRec = new Rectangle(x, y, this.cbIcon.getWidth(), this.cbIcon.getWidth());
        String companyId = comUserObject.getCompanyId();
        if (this.mapOfTreeNodeLocation.get(companyId) == null) {
            this.mapOfTreeNodeLocation.put(companyId, locRec);
        }
        int xx = x + this.cbIcon.getWidth() + 8;
        if (comUserObject.toString().equals("")) {
            return;
        }
        Rectangle newRec = new Rectangle(xx, rect.y, clip.getBounds().width - this.cbIcon.getWidth() - 8, (int)clip.getBounds().getHeight());
        this.simpleRender.draw(g, (Shape)newRec, comUserObject.getName(), style);
        if (v != 0) {
            this.cbIcon.paint((Object)v, g, x, y);
        }
    }
}

