/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.org.client;

import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.framework.util.EntityControlTypeUtil;
import com.kingdee.eas.basedata.org.OrgBlankException;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.org.PosiQualificationFactory;
import com.kingdee.eas.hr.org.PosiQualificationInfo;
import com.kingdee.eas.hr.org.PosiQualificationTypeInfo;
import com.kingdee.eas.hr.org.client.AbstractPosiQualEditUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;

public class PosiQualEditUI
extends AbstractPosiQualEditUI {
    private boolean hasCodingRule = false;
    private boolean isModifiable = false;

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopy_actionPerformed(e);
        this.editData.setType((PosiQualificationTypeInfo)this.getUIContext().get("ParentNode"));
    }

    public PosiQualEditUI() throws Exception {
        this.txtNumber.setText(null);
    }

    @Override
    public void initUIMenuBarLayout() {
        super.initUIMenuBarLayout();
        this.menuBiz.setEnabled(false);
        this.menuBiz.setVisible(false);
    }

    @Override
    public void loadFields() {
        this.setAutoNumberByOrg("ControlUnit");
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected IObjectValue createNewData() {
        PosiQualificationInfo info = new PosiQualificationInfo();
        info.setType((PosiQualificationTypeInfo)this.getUIContext().get("ParentNode"));
        info.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        return info;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return PosiQualificationFactory.getRemoteInstance();
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        if (!this.hasCodingRule && StringUtils.isEmpty((String)this.editData.getNumber())) {
            this.txtNumber.requestFocusInWindow();
            throw new OrgBlankException(OrgBlankException.NUMBER_CAN_NOT_BLANK);
        }
        if (StringUtils.isEmpty((String)this.editData.getName())) {
            this.txtName.requestFocusInWindow();
            throw new OrgBlankException(OrgBlankException.NAME_CAN_NOT_BLANK);
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection selectors = super.getSelectors();
        selectors.add(new SelectorItemInfo("cu.id"));
        return selectors;
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        EntityControlTypeUtil.checkCanEdit((String)"S4", (String)SysContext.getSysContext().getCurrentCtrlUnit().getId().toString(), (String)this.editData.getCU().getId().toString());
        this.txtNumber.setEnabled(this.isModifiable);
    }

    protected void removeByPK(IObjectPK pk) throws Exception {
        PosiQualificationInfo editData = this.editData;
        super.removeByPK(pk);
        this.recycleNumberByOrg((IObjectValue)editData, "ControlUnit", editData.getString("number"));
    }

    protected void recycleNumberByOrg(IObjectValue editData, String orgType, String number) {
        if (!StringUtils.isEmpty((String)number)) {
            try {
                String companyID = null;
                ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
                if (!StringUtils.isEmpty((String)orgType) && !"NONE".equalsIgnoreCase(orgType) && SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)orgType)) != null) {
                    companyID = SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)orgType)).getString("id");
                } else if (SysContext.getSysContext().getCurrentOrgUnit() != null) {
                    companyID = SysContext.getSysContext().getCurrentOrgUnit().getString("id");
                }
                if (!StringUtils.isEmpty(companyID) && iCodingRuleManager.isExist(editData, companyID) && iCodingRuleManager.isUseIntermitNumber(editData, companyID)) {
                    iCodingRuleManager.recycleNumber(editData, companyID, number);
                }
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }

    protected void setAutoNumberByOrg(String orgType) {
        if (this.editData == null) {
            return;
        }
        try {
            String companyID = null;
            if (!StringUtils.isEmpty((String)orgType) && !"NONE".equalsIgnoreCase(orgType) && SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)orgType)) != null) {
                companyID = SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)orgType)).getString("id");
            } else if (SysContext.getSysContext().getCurrentOrgUnit() != null) {
                companyID = SysContext.getSysContext().getCurrentOrgUnit().getString("id");
            }
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
            if (iCodingRuleManager.isExist((IObjectValue)this.editData, companyID)) {
                this.isModifiable = iCodingRuleManager.isModifiable((IObjectValue)this.editData, companyID);
                this.hasCodingRule = true;
                this.txtNumber.setEnabled(this.isModifiable);
            }
            if (this.editData.getNumber() == null) {
                if (this.hasCodingRule && iCodingRuleManager.isAddView((IObjectValue)this.editData, companyID)) {
                    this.editData.setNumber(iCodingRuleManager.getNumber((IObjectValue)this.editData, companyID));
                    this.txtNumber.setText(this.editData.getNumber());
                }
            } else {
                if (this.editData.getNumber().trim().length() > 0) {
                    this.txtNumber.setText(this.editData.getNumber());
                }
                if (OprtState.VIEW.equals(this.getOprtState())) {
                    this.txtNumber.setEnabled(false);
                    this.txtNumber.setEditable(false);
                }
            }
        }
        catch (Exception e) {
            this.handUIException(e);
            this.oldData = this.editData;
            SysUtil.abort();
        }
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.getEnum((String)"ControlUnit");
    }

    protected void setFieldsNull(AbstractObjectValue newData) {
        newData.setNull("CU");
    }
}

