/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.org.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HierarchyCollection;
import com.kingdee.eas.basedata.org.HierarchyFactory;
import com.kingdee.eas.basedata.org.HierarchyInfo;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionHierarchyCollection;
import com.kingdee.eas.basedata.org.PositionHierarchyFactory;
import com.kingdee.eas.basedata.org.PositionHierarchyInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.client.PositionPromptBox;
import com.kingdee.eas.hr.org.HRPositionFacadeFactory;
import com.kingdee.eas.hr.org.client.AbstractPositionMoveUI;
import com.kingdee.eas.hr.org.client.AdminByOrgRangePromptBox;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class PositionMoveUI
extends AbstractPositionMoveUI {
    private static final Logger logger = CoreUIObject.getLogger(PositionMoveUI.class);
    private static final String RES = "com.kingdee.eas.hr.org.client.PositionResource";
    private String positionId;
    private PositionInfo positionInfo;
    private AdminOrgUnitInfo srcAdminInfo;
    private Map srcMap = new HashMap();

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnRemoveLine.setVisible(false);
        this.btnAddLine.setVisible(false);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        Object obj = this.getUIContext().get("POSITION_ID");
        if (obj instanceof String) {
            this.positionId = (String)obj;
        } else {
            SysUtil.abort();
        }
        this.initEditor();
        this.loadData();
    }

    private void initEditor() throws Exception {
        AdminByOrgRangePromptBox selector = new AdminByOrgRangePromptBox();
        selector.setIncludeSealUp(false);
        this.prmtAdminOrg.setSelector((KDPromptSelector)selector);
        this.prmtAdminOrg.setEditable(false);
        this.prmtAdminOrg.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                Object obj = PositionMoveUI.this.prmtAdminOrg.getData();
                if (obj instanceof AdminOrgUnitInfo && PositionMoveUI.this.srcAdminInfo.getId().equals((Object)((AdminOrgUnitInfo)obj).getId())) {
                    MsgBox.showInfo((Component)((Object)PositionMoveUI.this), (String)EASResource.getString((String)PositionMoveUI.RES, (String)"ADMINORG_NOT_CHANGED"));
                    PositionMoveUI.this.prmtAdminOrg.setData(null);
                }
            }
        });
        this.tblHierarchy.addKDTPropertyChangeListener(new KDTPropertyChangeListener(){

            public void propertyChange(KDTPropertyChangeEvent evt) {
                int hierarchyIndex = PositionMoveUI.this.tblHierarchy.getColumnIndex("hierarchy");
                int positionIndex = PositionMoveUI.this.tblHierarchy.getColumnIndex("parentPosition");
                if (hierarchyIndex == evt.getColIndex()) {
                    Object obj = evt.getNewValue();
                    ICell positionCell = PositionMoveUI.this.tblHierarchy.getCell(evt.getRowIndex(), positionIndex);
                    if (obj instanceof HierarchyInfo) {
                        HashMap<String, HierarchyInfo> ctx = new HashMap<String, HierarchyInfo>();
                        ctx.put("hierarchyInfo", (HierarchyInfo)obj);
                        Frame frame = null;
                        KDBizPromptBox prmtPosition = new KDBizPromptBox();
                        prmtPosition.setSelector((KDPromptSelector)new PositionPromptBox(frame, ctx));
                        prmtPosition.setEditFormat("$number");
                        prmtPosition.setDisplayFormat("$name");
                        prmtPosition.setEditable(false);
                        positionCell.setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtPosition));
                        positionCell.getStyleAttributes().setLocked(false);
                    } else {
                        positionCell.setValue(null);
                        positionCell.getStyleAttributes().setLocked(true);
                    }
                }
                int adminIndex = PositionMoveUI.this.tblHierarchy.getColumnIndex("adminOrg");
                if (positionIndex == evt.getColIndex()) {
                    Object obj = evt.getNewValue();
                    AdminOrgUnitInfo adminOrg = null;
                    if (obj instanceof PositionInfo) {
                        Object aobj = PositionMoveUI.this.tblHierarchy.getCell(evt.getRowIndex(), "srcParentPosition").getValue();
                        if (aobj instanceof PositionInfo && ((PositionInfo)aobj).getId().equals((Object)((PositionInfo)obj).getId())) {
                            MsgBox.showInfo((Component)((Object)PositionMoveUI.this), (String)EASResource.getString((String)PositionMoveUI.RES, (String)"POSITION_NOT_CHANGED"));
                            PositionMoveUI.this.tblHierarchy.getCell(evt.getRowIndex(), evt.getColIndex()).setValue(null);
                        } else {
                            try {
                                PositionInfo pInfo = PositionFactory.getRemoteInstance().getPositionCollection("select adminOrgUnit.id, adminOrgUnit.number, adminOrgUnit.name where id = '" + ((PositionInfo)obj).getId().toString() + "'").get(0);
                                adminOrg = pInfo.getAdminOrgUnit();
                            }
                            catch (Exception e) {
                                ExceptionHandler.handle((Throwable)e);
                            }
                        }
                    }
                    PositionMoveUI.this.tblHierarchy.getCell(evt.getRowIndex(), adminIndex).setValue(adminOrg);
                }
            }
        });
    }

    private void loadData() throws Exception {
        SelectorItemCollection coll = new SelectorItemCollection();
        coll.add(new SelectorItemInfo("id"));
        coll.add(new SelectorItemInfo("number"));
        coll.add(new SelectorItemInfo("longNumber"));
        coll.add(new SelectorItemInfo("name"));
        coll.add(new SelectorItemInfo("adminOrgUnit.id"));
        coll.add(new SelectorItemInfo("adminOrgUnit.number"));
        coll.add(new SelectorItemInfo("adminOrgUnit.longNumber"));
        coll.add(new SelectorItemInfo("adminOrgUnit.name"));
        this.positionInfo = PositionFactory.getRemoteInstance().getPositionInfo((IObjectPK)new ObjectUuidPK(this.positionId), coll);
        this.srcAdminInfo = this.positionInfo.getAdminOrgUnit();
        this.txtPosition.setText(this.positionInfo.getName());
        this.txtAdminOrg.setText(this.srcAdminInfo.getName());
        StringBuffer strFilter = new StringBuffer("id not in (''");
        StringBuffer oql = new StringBuffer("select id, hierarchy.id, hierarchy.number, hierarchy.name, parent.id, ");
        oql.append("parent.name, parent.number, parent.adminOrgUnit.id, parent.adminOrgUnit.name ");
        oql.append("where child.id = '").append(this.positionId).append("' order by hierarchy.isDefault desc");
        PositionHierarchyCollection phColl = PositionHierarchyFactory.getRemoteInstance().getPositionHierarchyCollection(oql.toString());
        int size = phColl.size();
        for (int i = 0; i < size; ++i) {
            PositionHierarchyInfo phInfo = phColl.get(i);
            IRow row = this.tblHierarchy.addRow();
            HierarchyInfo hInfo = phInfo.getHierarchy();
            PositionInfo pInfo = phInfo.getParent();
            row.getCell("hierarchy").setValue((Object)hInfo);
            row.getCell("srcParentPosition").setValue((Object)pInfo);
            row.getCell("srcAdminOrg").setValue((Object)pInfo.getAdminOrgUnit());
            this.srcMap.put(hInfo.getId().toString(), pInfo.getId().toString());
            strFilter.append(", '").append(hInfo.getId().toString()).append("'");
        }
        strFilter.append(")");
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo(strFilter.toString()));
        EntityViewInfo viewInfo = new EntityViewInfo();
        SorterItemInfo sortInfo = new SorterItemInfo("isDefault");
        sortInfo.setSortType(SortType.DESCEND);
        viewInfo.getSorter().add(sortInfo);
        viewInfo.setFilter(filterInfo);
        HierarchyCollection hColl = HierarchyFactory.getRemoteInstance().getHierarchyCollection(viewInfo);
        int size2 = hColl.size();
        for (int i = 0; i < size2; ++i) {
            IRow row = this.tblHierarchy.addRow();
            row.getCell("hierarchy").setValue((Object)hColl.get(i));
        }
    }

    protected void checkTableParsed() {
        this.tblHierarchy.checkParsed();
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }

    @Override
    public void actionOK_actionPerformed(ActionEvent e) throws Exception {
        HashMap<String, String> phMap = new HashMap<String, String>();
        int size = this.tblHierarchy.getRowCount();
        for (int i = 0; i < size; ++i) {
            Object srcParentPosition;
            IRow row = this.tblHierarchy.getRow(i);
            String hierarchyId = ((HierarchyInfo)row.getCell("hierarchy").getValue()).getId().toString();
            Object parentPosition = row.getCell("parentPosition").getValue();
            if (!(parentPosition instanceof PositionInfo) || (srcParentPosition = row.getCell("srcParentPosition").getValue()) instanceof PositionInfo && ((PositionInfo)parentPosition).getId().equals((Object)((PositionInfo)srcParentPosition).getId())) continue;
            phMap.put(hierarchyId, ((PositionInfo)parentPosition).getId().toString());
        }
        if (this.prmtAdminOrg.getData() == null && phMap.size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"POSITION_MOVE_DATANOTCHANGED"));
            SysUtil.abort();
        }
        String adminId = this.srcAdminInfo.getId().toString();
        if (this.prmtAdminOrg.getData() instanceof AdminOrgUnitInfo) {
            adminId = ((AdminOrgUnitInfo)this.prmtAdminOrg.getData()).getId().toString();
        }
        HRPositionFacadeFactory.getRemoteInstance().updatePositionHierarchy(this.positionId, adminId, phMap);
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"POSITION_MOVE_SUCCESSFULLY"));
        Object obj = this.getUIContext().get("positionHROCache");
        if (obj instanceof Map) {
            ((Map)obj).remove(this.positionId);
        }
        this.getUIWindow().close();
    }

    private void verifyInput() throws Exception {
        Object aobj = this.prmtAdminOrg.getData();
        if (aobj instanceof AdminOrgUnitInfo && ((AdminOrgUnitInfo)aobj).getId().equals((Object)this.srcAdminInfo.getId())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"ADMINORG_NOT_CHANGED"));
            SysUtil.abort();
        }
        HashMap<Integer, String> hierarchyMap = new HashMap<Integer, String>();
        int size = this.tblHierarchy.getRowCount();
        for (int i = 0; i < size; ++i) {
            IRow row = this.tblHierarchy.getRow(i);
            Object obj = row.getCell("hierarchy").getValue();
            if (obj instanceof HierarchyInfo) {
                String hierarchyId = ((HierarchyInfo)obj).getId().toString();
                for (Map.Entry entry : hierarchyMap.entrySet()) {
                    if (!hierarchyId.equals(entry.getValue())) continue;
                    MsgBox.showInfo((Component)((Object)this), (String)MessageFormat.format(EASResource.getString((String)RES, (String)"HIERARCHY_DUP"), entry.getKey(), i + 1));
                    SysUtil.abort();
                }
                hierarchyMap.put(i + 1, hierarchyId);
            } else {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"SELECT_INVALID_HIERARCHY"));
                SysUtil.abort();
            }
            obj = row.getCell("parentPosition").getValue();
            if (obj instanceof PositionInfo) continue;
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"SELECT_INVALID_POSITION"));
            SysUtil.abort();
        }
        HierarchyInfo hierarchyInfo = HierarchyFactory.getRemoteInstance().getDefaultHierarchy();
        if (!hierarchyMap.containsValue(hierarchyInfo.getId().toString())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"SELECT_DEFAULT_HIERARCHY"));
            SysUtil.abort();
        }
    }

    @Override
    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        IRow row = this.tblHierarchy.addRow();
        row.getCell("parentPosition").getStyleAttributes().setLocked(true);
    }

    @Override
    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblHierarchy.getRowCount() == 0 || this.tblHierarchy.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        int[] rows = KDTableUtil.getSelectedRows((KDTable)this.tblHierarchy);
        for (int i = rows.length - 1; i >= 0; --i) {
            this.tblHierarchy.removeRow(rows[i]);
        }
    }
}

