/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.org.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.MultiLangItem;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgBlankException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.org.AdminOrgUnitVerCollection;
import com.kingdee.eas.hr.org.AdminOrgUnitVerFactory;
import com.kingdee.eas.hr.org.AdminOrgUnitVerInfo;
import com.kingdee.eas.hr.org.HROrgAdjSchmInfo;
import com.kingdee.eas.hr.org.HROrgVersionFacadeFactory;
import com.kingdee.eas.hr.org.IsMoveEnum;
import com.kingdee.eas.hr.org.OrgAdjSchmVerException;
import com.kingdee.eas.hr.org.PosStateTypeEnum;
import com.kingdee.eas.hr.org.PositionVerFactory;
import com.kingdee.eas.hr.org.PositionVerInfo;
import com.kingdee.eas.hr.org.client.AbstractPositionVerEidtUI;
import com.kingdee.eas.hr.org.client.PositionVerPromptBox;
import com.kingdee.eas.hr.org.util.OrgUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class PositionVerEidtUI
extends AbstractPositionVerEidtUI {
    private static final long serialVersionUID = -5063186086744482228L;
    private static final Logger logger = CoreUIObject.getLogger(PositionVerEidtUI.class);
    private PositionVerInfo editPostion = null;
    private List newValList = new ArrayList();
    public boolean isCanceled = true;

    public List getNewValList() {
        return this.newValList;
    }

    public void setNewValList(List newValList) {
        this.newValList = newValList;
    }

    public PositionVerInfo getEditPostion() {
        if (this.isCanceled) {
            return null;
        }
        return this.editPostion;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAddNew.setVisible(false);
        this.btnEdit.setVisible(false);
        this.btnCopy.setVisible(false);
        this.prmtOrg.setEnabled(false);
        this.prmtParent.setEditable(false);
        this.initF7();
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            this.setUITitle(EASResource.getString((String)"com.kingdee.eas.hr.org.HROrgAdjSchmVerResource", (String)"Position_AddNew"));
        } else if (this.getOprtState().equals(OprtState.EDIT)) {
            this.setUITitle(EASResource.getString((String)"com.kingdee.eas.hr.org.HROrgAdjSchmVerResource", (String)"Position_Edit"));
        } else if (this.getOprtState().equals(OprtState.VIEW)) {
            this.setUITitle(EASResource.getString((String)"com.kingdee.eas.hr.org.HROrgAdjSchmVerResource", (String)"Position_View"));
        }
    }

    private void initF7() {
        this.prmtOrg.setEnabled(false);
        PositionVerPromptBox parentPosF7 = new PositionVerPromptBox((IUIObject)this, this.getUIContext());
        this.prmtParent.setSelector((KDPromptSelector)parentPosF7);
        this.prmtParent.setEnabled(true);
        this.prmtParent.setCommitFormat("$number$");
        this.prmtParent.setEditFormat("$number$");
        this.prmtParent.setDisplayFormat("$name$");
        this.prmtParent.getEditor().addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                PositionVerInfo positionVer = (PositionVerInfo)PositionVerEidtUI.this.prmtParent.getData();
                if (positionVer != null) {
                    PositionVerEidtUI.this.prmtParent.setToolTipText(positionVer.getNumber());
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        this.prmtParent.setRequired(true);
        if (this.getOprtState().equals(OprtState.VIEW)) {
            this.prmtParent.setEnabled(false);
        }
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            this.setUITitle(EASResource.getString((String)"com.kingdee.eas.hr.org.HROrgAdjSchmVerResource", (String)"Position_AddNew"));
        }
    }

    protected ICoreBase getBizInterface() throws Exception {
        return PositionVerFactory.getRemoteInstance();
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        try {
            PositionVerInfo saveSuccessObj = this.editData;
            this.editData.put("SuperPosition", this.prmtParent.getData());
            this.editData.setPosStateType(PosStateTypeEnum.Wait_Enable);
            super.actionSubmit_actionPerformed(e);
            if ("ADDNEW".equals(this.getOprtState())) {
                PositionVerInfo positionVerInfo = saveSuccessObj;
                positionVerInfo.setId(BOSUuid.read((String)this.idList.getCurrentID()));
                positionVerInfo.setDeletedStatus(DeletedStatusEnum.NORMAL);
                positionVerInfo.setPosStateType(PosStateTypeEnum.Wait_Enable);
                positionVerInfo.put("SuperPosition", this.prmtParent.getData());
                this.editPostion = positionVerInfo;
                this.newValList.add(this.editPostion);
            } else if ("EDIT".equals(this.getOprtState())) {
                this.editPostion = saveSuccessObj;
                this.newValList.add(this.editPostion);
            }
            this.isCanceled = false;
        }
        catch (Exception ex) {
            this.editPostion = null;
            this.isCanceled = true;
            throw ex;
        }
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        String number = this.txtNumber.getText();
        if (StringUtils.isEmpty((String)number)) {
            this.txtNumber.requestFocusInWindow();
            throw new OrgBlankException(OrgBlankException.NUMBER_CAN_NOT_BLANK);
        }
        MultiLangItem name = OrgUtils.getDefaultLangItemData(this.txtName);
        if (name == null || StringUtils.isEmpty((String)name.toString())) {
            this.txtName.requestFocusInWindow();
            throw new OrgBlankException(OrgBlankException.NAME_CAN_NOT_BLANK);
        }
        if (this.prmtParent.getData() == null) {
            this.prmtParent.requestFocusInWindow();
            throw new OrgAdjSchmVerException(OrgAdjSchmVerException.PARENT_POSITION_CANTNULL);
        }
        PositionVerInfo parent = (PositionVerInfo)this.prmtParent.getData();
        StringBuffer oql = new StringBuffer();
        oql.append("select level where id='").append(this.editData.getAdminOrgUnit().getId()).append("'");
        AdminOrgUnitVerInfo orgVerInfo = AdminOrgUnitVerFactory.getRemoteInstance().getAdminOrgUnitVerInfo(oql.toString());
        if (orgVerInfo.getLevel() > 1 && parent.getId().equals((Object)this.editData.getId())) {
            this.prmtParent.requestFocusInWindow();
            throw new OrgAdjSchmVerException(OrgAdjSchmVerException.PARENT_POSITION_CANTBESELF);
        }
    }

    public List getnewValList() {
        return this.newValList;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        return sic;
    }

    protected IObjectValue getValue(IObjectPK pk) throws Exception {
        HROrgAdjSchmInfo curSchm = (HROrgAdjSchmInfo)this.getUIContext().get("Current_OrgAdjSchm");
        if (IsMoveEnum.IS_MOVED.equals((Object)curSchm.getIsMoved())) {
            return HROrgVersionFacadeFactory.getRemoteInstance().getPositionVerInfo(pk);
        }
        this.editPostion = (PositionVerInfo)this.getUIContext().get("position");
        StringBuffer oql = new StringBuffer();
        oql.append("select id,name,number,index,isRespPosition,deletedStatus,description,posStateType").append(",adminOrgUnit.id,adminOrgUnit.name,adminOrgUnit.number").append(",parentPosition.id,parentPosition.number,parentPosition.name,orgAdjSchm.* ").append(" where id='").append(this.editPostion.getId().toString()).append("'");
        return this.getBizInterface().getValue(oql.toString());
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void loadFields() {
        super.loadFields();
        if (this.editData.isIsRespPosition()) {
            this.chkIsPrimaryPosition.setEnabled(false);
        }
    }

    protected IObjectValue createNewData() {
        PositionVerInfo info = new PositionVerInfo();
        PositionVerInfo parentPositionInfo = null;
        if (this.getUIContext().get("Current_SelectNode") != null) {
            AdminOrgUnitVerInfo adminInfo = (AdminOrgUnitVerInfo)this.getUIContext().get("Current_SelectNode");
            try {
                this.prmtOrg.setValue((Object)adminInfo);
                info.setAdminOrgUnit(adminInfo);
                parentPositionInfo = this.getDefaultParentPosition(adminInfo);
                if (this.chkIsPrimaryPosition.isSelected()) {
                    info.setIsRespPosition(true);
                } else {
                    info.setIsRespPosition(false);
                }
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
            if (parentPositionInfo != null) {
                this.prmtParent.setData(parentPositionInfo);
                this.prmtParent.setEnabled(true);
                info.setParentPosition(parentPositionInfo);
                info.put("SuperPosition", parentPositionInfo);
            } else if (adminInfo.getLevel() == 1) {
                this.prmtParent.setEnabled(false);
                info.put("SuperPosition", "Me");
            }
            info.setOrgAdjSchm((HROrgAdjSchmInfo)this.getUIContext().get("Current_OrgAdjSchm"));
            info.setCU(adminInfo.getCU());
            info.setDeletedStatus(DeletedStatusEnum.NORMAL);
            info.setPosStateType(PosStateTypeEnum.Wait_Enable);
            info.setIndex(-1);
        }
        return info;
    }

    private PositionVerInfo getDefaultParentPosition(AdminOrgUnitVerInfo adminInfo) throws Exception {
        AdminOrgUnitVerInfo parentAdminInfo = null;
        AdminOrgUnitVerInfo curAdminInfo = this.getResponPositionByAdmin(adminInfo);
        PositionVerInfo positionInfo = null;
        if (curAdminInfo != null) {
            if (curAdminInfo.getParent() != null) {
                parentAdminInfo = this.getResponPositionByAdmin(curAdminInfo.getParent());
            }
            if (curAdminInfo.getResponPosition() == null) {
                if (this.getOprtState().equals(OprtState.ADDNEW)) {
                    this.chkIsPrimaryPosition.setSelected(true);
                }
                if (parentAdminInfo == null) {
                    return null;
                }
                if (parentAdminInfo.getResponPosition() == null) {
                    return null;
                }
                positionInfo = new PositionVerInfo();
                positionInfo.setId(parentAdminInfo.getResponPosition().getId());
                positionInfo.setName(parentAdminInfo.getResponPosition().getName());
                positionInfo.setNumber(parentAdminInfo.getResponPosition().getNumber());
                return positionInfo;
            }
            if (this.getOprtState().equals(OprtState.ADDNEW)) {
                this.chkIsPrimaryPosition.setSelected(false);
            }
            positionInfo = new PositionVerInfo();
            positionInfo.setId(curAdminInfo.getResponPosition().getId());
            positionInfo.setName(curAdminInfo.getResponPosition().getName());
            positionInfo.setNumber(curAdminInfo.getResponPosition().getNumber());
            return positionInfo;
        }
        return null;
    }

    private AdminOrgUnitVerInfo getResponPositionByAdmin(AdminOrgUnitVerInfo adminInfo) throws BOSException {
        AdminOrgUnitVerCollection orgColl;
        String orgAdjSchm = adminInfo.getOrgAdjSchm().getId().toString();
        StringBuffer oql = new StringBuffer();
        oql.append("select id,number,name,level,isRespPosition,responPosition.id,responPosition.name,responPosition.number,").append("parent.id,parent.name,parent.number,parent.level,parent.orgAdjSchm.id,parent.orgAdjSchm.name,parent.orgAdjSchm.number").append(" where id='").append(adminInfo.getId().toString()).append("'").append(" and orgAdjSchm='").append(orgAdjSchm).append("'");
        if (adminInfo.getLevel() > 1) {
            oql.append(" and parent.orgAdjSchm.id='").append(orgAdjSchm).append("'");
        }
        if ((orgColl = AdminOrgUnitVerFactory.getRemoteInstance().getAdminOrgUnitVerCollection(oql.toString())).size() > 0) {
            return orgColl.get(0);
        }
        return null;
    }
}

